/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.config;

import com.ibm.fhir.config.ConfigurationService;
import com.ibm.fhir.config.FHIRConfiguration;
import com.ibm.fhir.config.PropertyGroup;
import com.ibm.fhir.core.TenantSpecificFileBasedCache;
import java.io.File;
import java.io.FileInputStream;

public class TenantSpecificPropertyGroupCache
extends TenantSpecificFileBasedCache<PropertyGroup> {
    public TenantSpecificPropertyGroupCache() {
        super("PropertyGroup");
    }

    public String getCacheEntryFilename(String tenantId) {
        return FHIRConfiguration.getConfigHome() + "config" + File.separator + tenantId + File.separator + "fhir-server-config.json";
    }

    public PropertyGroup createCachedObject(File f) throws Exception {
        try (FileInputStream is = new FileInputStream(f);){
            PropertyGroup propertyGroup = ConfigurationService.loadConfiguration(is);
            return propertyGroup;
        }
    }
}

