/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.generator;

import com.ibm.fhir.model.generator.FHIRAbstractGenerator;
import com.ibm.fhir.model.generator.GeneratingVisitor;
import com.ibm.fhir.model.generator.exception.FHIRGeneratorException;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Xhtml;
import com.ibm.fhir.model.util.JsonSupport;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.model.visitor.PathAwareVisitor;
import com.ibm.fhir.model.visitor.Visitable;
import com.ibm.fhir.model.visitor.Visitor;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

public class FHIRJsonGenerator
extends FHIRAbstractGenerator {
    private static final JsonGeneratorFactory GENERATOR_FACTORY = Json.createGeneratorFactory(null);
    private static final JsonGeneratorFactory PRETTY_PRINTING_GENERATOR_FACTORY = Json.createGeneratorFactory(Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true));

    protected FHIRJsonGenerator(boolean prettyPrinting) {
        super(prettyPrinting);
    }

    @Override
    public void generate(Visitable visitable, OutputStream out) throws FHIRGeneratorException {
        PathAwareVisitor visitor = null;
        try (JsonGenerator generator = this.getGeneratorFactory().createGenerator(JsonSupport.nonClosingOutputStream(out), StandardCharsets.UTF_8);){
            visitor = new JsonGeneratingVisitor(generator);
            visitable.accept(visitor);
            generator.flush();
        }
        catch (Exception e) {
            throw new FHIRGeneratorException(e.getMessage(), visitor != null ? visitor.getPath() : null, e);
        }
    }

    @Override
    public void generate(Visitable visitable, Writer writer) throws FHIRGeneratorException {
        PathAwareVisitor visitor = null;
        try (JsonGenerator generator = this.getGeneratorFactory().createGenerator(JsonSupport.nonClosingWriter(writer));){
            visitor = new JsonGeneratingVisitor(generator);
            visitable.accept(visitor);
            generator.flush();
        }
        catch (Exception e) {
            throw new FHIRGeneratorException(e.getMessage(), visitor != null ? visitor.getPath() : null, e);
        }
    }

    @Override
    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    private JsonGeneratorFactory getGeneratorFactory() {
        return this.prettyPrinting ? PRETTY_PRINTING_GENERATOR_FACTORY : GENERATOR_FACTORY;
    }

    private static class JsonGeneratingVisitor
    extends GeneratingVisitor {
        private final JsonGenerator generator;

        private JsonGeneratingVisitor(JsonGenerator generator) {
            this.generator = generator;
        }

        private void generate(Element element) {
            if (element.getId() != null) {
                this.visit("id", element.getId());
            }
            if (!element.getExtension().isEmpty()) {
                this.visitStart("extension", element.getExtension(), Extension.class);
                int elementIndex = 0;
                for (Extension extension : element.getExtension()) {
                    extension.accept("extension", elementIndex++, (Visitor)this);
                }
                this.visitEnd("extension", element.getExtension(), Extension.class);
            }
        }

        private boolean hasIdOrExtension(Element element) {
            return element.getId() != null || !element.getExtension().isEmpty();
        }

        private boolean hasIdOrExtension(List<? extends Visitable> visitables) {
            for (Visitable visitable : visitables) {
                if (!this.hasIdOrExtension((Element)visitable)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Base64Binary base64Binary) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, Base64Binary.class);
            }
            if (base64Binary.getValue() != null) {
                this.writeValue(elementName, elementIndex, Base64.getEncoder().encodeToString(base64Binary.getValue()));
            } else {
                this.writeNull(elementName, elementIndex, base64Binary);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Boolean _boolean) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, Boolean.class);
            }
            if (_boolean.getValue() != null) {
                this.writeValue(elementName, elementIndex, _boolean.getValue());
            } else {
                this.writeNull(elementName, elementIndex, _boolean);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Date date) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, Date.class);
            }
            if (date.getValue() != null) {
                this.writeValue(elementName, elementIndex, Date.PARSER_FORMATTER.format(date.getValue()));
            } else {
                this.writeNull(elementName, elementIndex, date);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, DateTime dateTime) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, DateTime.class);
            }
            if (dateTime.getValue() != null) {
                this.writeValue(elementName, elementIndex, DateTime.PARSER_FORMATTER.format(dateTime.getValue()));
            } else {
                this.writeNull(elementName, elementIndex, dateTime);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Decimal decimal) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, Decimal.class);
            }
            if (decimal.getValue() != null) {
                this.writeValue(elementName, elementIndex, decimal.getValue());
            } else {
                this.writeNull(elementName, elementIndex, decimal);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Instant instant) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, Instant.class);
            }
            if (instant.getValue() != null) {
                this.writeValue(elementName, elementIndex, Instant.PARSER_FORMATTER.format(instant.getValue()));
            } else {
                this.writeNull(elementName, elementIndex, instant);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Integer integer) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, integer.getClass());
            }
            if (integer.getValue() != null) {
                this.writeValue(elementName, elementIndex, integer.getValue());
            } else {
                this.writeNull(elementName, elementIndex, integer);
            }
            return false;
        }

        @Override
        public void doVisit(java.lang.String elementName, java.lang.String value) {
            this.writeValue(elementName, -1, value);
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, String string) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, string.getClass());
            }
            if (string.getValue() != null) {
                this.writeValue(elementName, elementIndex, string.getValue());
            } else {
                this.writeNull(elementName, elementIndex, string);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Time time) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, Time.class);
            }
            if (time.getValue() != null) {
                this.writeValue(elementName, elementIndex, Time.PARSER_FORMATTER.format(time.getValue()));
            } else {
                this.writeNull(elementName, elementIndex, time);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Uri uri) {
            if (this.isChoiceElement(elementName)) {
                elementName = this.getChoiceElementName(elementName, uri.getClass());
            }
            if (uri.getValue() != null) {
                this.writeValue(elementName, elementIndex, uri.getValue());
            } else {
                this.writeNull(elementName, elementIndex, uri);
            }
            return false;
        }

        @Override
        public boolean visit(java.lang.String elementName, int elementIndex, Xhtml xhtml) {
            this.writeValue(elementName, elementIndex, xhtml.getValue());
            return false;
        }

        @Override
        public void doVisitEnd(java.lang.String elementName, int elementIndex, Element element) {
            Class<?> elementType = element.getClass();
            if (ModelSupport.isPrimitiveType(elementType)) {
                if (this.isChoiceElement(elementName)) {
                    elementName = this.getChoiceElementName(elementName, elementType);
                }
                if (elementIndex == -1 && this.hasIdOrExtension(element)) {
                    this.generator.writeStartObject("_" + elementName);
                    this.generate(element);
                    this.generator.writeEnd();
                }
                if (this.getDepth() == 1) {
                    this.generator.writeEnd();
                }
            } else {
                this.generator.writeEnd();
            }
        }

        @Override
        public void visitEnd(java.lang.String elementName, List<? extends Visitable> visitables, Class<?> type) {
            if (!visitables.isEmpty()) {
                this.generator.writeEnd();
                if (ModelSupport.isPrimitiveType(type) && this.hasIdOrExtension(visitables)) {
                    this.generator.writeStartArray("_" + elementName);
                    for (Visitable visitable : visitables) {
                        if (this.hasIdOrExtension((Element)visitable)) {
                            this.generator.writeStartObject();
                            this.generate((Element)visitable);
                            this.generator.writeEnd();
                            continue;
                        }
                        this.generator.writeNull();
                    }
                    this.generator.writeEnd();
                }
            }
        }

        @Override
        public void doVisitEnd(java.lang.String elementName, int elementIndex, Resource resource) {
            this.generator.writeEnd();
        }

        @Override
        public void doVisitStart(java.lang.String elementName, int elementIndex, Element element) {
            Class<?> elementType = element.getClass();
            if (!ModelSupport.isPrimitiveType(elementType)) {
                if (this.isChoiceElement(elementName)) {
                    elementName = this.getChoiceElementName(elementName, element.getClass());
                }
                this.writeStartObject(elementName, elementIndex);
            } else if (this.getDepth() == 1) {
                this.generator.writeStartObject();
            }
        }

        @Override
        public void visitStart(java.lang.String elementName, List<? extends Visitable> visitables, Class<?> type) {
            if (!visitables.isEmpty()) {
                this.writeStartArray(elementName);
            }
        }

        @Override
        public void doVisitStart(java.lang.String elementName, int elementIndex, Resource resource) {
            this.writeStartObject(elementName, elementIndex);
            Class<?> resourceType = resource.getClass();
            java.lang.String resourceTypeName = resourceType.getSimpleName();
            this.generator.write("resourceType", resourceTypeName);
        }

        private void writeNull(java.lang.String elementName, int elementIndex, Element element) {
            if (elementIndex != -1 && this.hasIdOrExtension(element)) {
                this.generator.writeNull();
            }
        }

        private void writeStartArray(java.lang.String elementName) {
            this.generator.writeStartArray(elementName);
        }

        private void writeStartObject(java.lang.String elementName, int elementIndex) {
            if (this.getDepth() > 1 && elementIndex == -1) {
                this.generator.writeStartObject(elementName);
            } else {
                this.generator.writeStartObject();
            }
        }

        private void writeValue(java.lang.String elementName, int elementIndex, BigDecimal value) {
            if (elementIndex == -1) {
                this.generator.write(elementName, value);
            } else {
                this.generator.write(value);
            }
        }

        private void writeValue(java.lang.String elementName, int elementIndex, java.lang.Boolean value) {
            if (elementIndex == -1) {
                this.generator.write(elementName, value.booleanValue());
            } else {
                this.generator.write(value.booleanValue());
            }
        }

        private void writeValue(java.lang.String elementName, int elementIndex, java.lang.Integer value) {
            if (elementIndex == -1) {
                this.generator.write(elementName, value.intValue());
            } else {
                this.generator.write(value.intValue());
            }
        }

        private void writeValue(java.lang.String elementName, int elementIndex, java.lang.String value) {
            if (elementIndex == -1) {
                this.generator.write(elementName, value);
            } else {
                this.generator.write(value);
            }
        }
    }
}

