/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.AppointmentStatus;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ParticipantRequired;
import com.ibm.fhir.model.type.code.ParticipationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="app-1", level="Rule", location="Appointment.participant", description="Either the type or actor on the participant SHALL be specified", expression="type.exists() or actor.exists()", source="http://hl7.org/fhir/StructureDefinition/Appointment"), @Constraint(id="app-2", level="Rule", location="(base)", description="Either start and end are specified, or neither", expression="start.exists() = end.exists()", source="http://hl7.org/fhir/StructureDefinition/Appointment"), @Constraint(id="app-3", level="Rule", location="(base)", description="Only proposed or cancelled appointments can be missing start/end dates", expression="(start.exists() and end.exists()) or (status in ('proposed' | 'cancelled' | 'waitlist'))", source="http://hl7.org/fhir/StructureDefinition/Appointment"), @Constraint(id="app-4", level="Rule", location="(base)", description="Cancelation reason is only used for appointments that have been cancelled, or no-show", expression="Appointment.cancelationReason.exists() implies (Appointment.status='no-show' or Appointment.status='cancelled')", source="http://hl7.org/fhir/StructureDefinition/Appointment"), @Constraint(id="appointment-5", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/c80-practice-codes", expression="specialty.exists() implies (specialty.all(memberOf('http://hl7.org/fhir/ValueSet/c80-practice-codes', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/Appointment", generated=true), @Constraint(id="appointment-6", level="Warning", location="(base)", description="SHOULD contain a code from value set http://terminology.hl7.org/ValueSet/v2-0276", expression="appointmentType.exists() implies (appointmentType.memberOf('http://terminology.hl7.org/ValueSet/v2-0276', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Appointment", generated=true), @Constraint(id="appointment-7", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/encounter-reason", expression="reasonCode.exists() implies (reasonCode.all(memberOf('http://hl7.org/fhir/ValueSet/encounter-reason', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/Appointment", generated=true), @Constraint(id="appointment-8", level="Warning", location="participant.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/encounter-participant-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/encounter-participant-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Appointment", generated=true)})
public class Appointment
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="AppointmentStatus", strength=BindingStrength.Value.REQUIRED, description="The free/busy status of an appointment.", valueSet="http://hl7.org/fhir/ValueSet/appointmentstatus|4.0.1")
    @Required
    private final AppointmentStatus status;
    @Summary
    @Binding(bindingName="cancelation-reason", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/appointment-cancellation-reason")
    private final CodeableConcept cancelationReason;
    @Summary
    @Binding(bindingName="service-category", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/service-category")
    private final List<CodeableConcept> serviceCategory;
    @Summary
    @Binding(bindingName="service-type", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/service-type")
    private final List<CodeableConcept> serviceType;
    @Summary
    @Binding(bindingName="specialty", strength=BindingStrength.Value.PREFERRED, valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    private final List<CodeableConcept> specialty;
    @Summary
    @Binding(bindingName="appointment-type", strength=BindingStrength.Value.PREFERRED, valueSet="http://terminology.hl7.org/ValueSet/v2-0276")
    private final CodeableConcept appointmentType;
    @Summary
    @Binding(bindingName="ApptReason", strength=BindingStrength.Value.PREFERRED, description="The Reason for the appointment to take place.", valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Procedure", "Observation", "ImmunizationRecommendation"})
    private final List<Reference> reasonReference;
    private final UnsignedInt priority;
    private final String description;
    private final List<Reference> supportingInformation;
    @Summary
    private final Instant start;
    @Summary
    private final Instant end;
    private final PositiveInt minutesDuration;
    @ReferenceTarget(value={"Slot"})
    private final List<Reference> slot;
    private final DateTime created;
    private final String comment;
    private final String patientInstruction;
    @ReferenceTarget(value={"ServiceRequest"})
    private final List<Reference> basedOn;
    @Required
    private final List<Participant> participant;
    private final List<Period> requestedPeriod;

    private Appointment(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.cancelationReason = builder.cancelationReason;
        this.serviceCategory = Collections.unmodifiableList(builder.serviceCategory);
        this.serviceType = Collections.unmodifiableList(builder.serviceType);
        this.specialty = Collections.unmodifiableList(builder.specialty);
        this.appointmentType = builder.appointmentType;
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.priority = builder.priority;
        this.description = builder.description;
        this.supportingInformation = Collections.unmodifiableList(builder.supportingInformation);
        this.start = builder.start;
        this.end = builder.end;
        this.minutesDuration = builder.minutesDuration;
        this.slot = Collections.unmodifiableList(builder.slot);
        this.created = builder.created;
        this.comment = builder.comment;
        this.patientInstruction = builder.patientInstruction;
        this.basedOn = Collections.unmodifiableList(builder.basedOn);
        this.participant = Collections.unmodifiableList(builder.participant);
        this.requestedPeriod = Collections.unmodifiableList(builder.requestedPeriod);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public AppointmentStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getCancelationReason() {
        return this.cancelationReason;
    }

    public List<CodeableConcept> getServiceCategory() {
        return this.serviceCategory;
    }

    public List<CodeableConcept> getServiceType() {
        return this.serviceType;
    }

    public List<CodeableConcept> getSpecialty() {
        return this.specialty;
    }

    public CodeableConcept getAppointmentType() {
        return this.appointmentType;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public UnsignedInt getPriority() {
        return this.priority;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Reference> getSupportingInformation() {
        return this.supportingInformation;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public PositiveInt getMinutesDuration() {
        return this.minutesDuration;
    }

    public List<Reference> getSlot() {
        return this.slot;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public String getComment() {
        return this.comment;
    }

    public String getPatientInstruction() {
        return this.patientInstruction;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Participant> getParticipant() {
        return this.participant;
    }

    public List<Period> getRequestedPeriod() {
        return this.requestedPeriod;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.cancelationReason != null || !this.serviceCategory.isEmpty() || !this.serviceType.isEmpty() || !this.specialty.isEmpty() || this.appointmentType != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || this.priority != null || this.description != null || !this.supportingInformation.isEmpty() || this.start != null || this.end != null || this.minutesDuration != null || !this.slot.isEmpty() || this.created != null || this.comment != null || this.patientInstruction != null || !this.basedOn.isEmpty() || !this.participant.isEmpty() || !this.requestedPeriod.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.cancelationReason, "cancelationReason", visitor);
                this.accept(this.serviceCategory, "serviceCategory", visitor, CodeableConcept.class);
                this.accept(this.serviceType, "serviceType", visitor, CodeableConcept.class);
                this.accept(this.specialty, "specialty", visitor, CodeableConcept.class);
                this.accept(this.appointmentType, "appointmentType", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.supportingInformation, "supportingInformation", visitor, Reference.class);
                this.accept(this.start, "start", visitor);
                this.accept(this.end, "end", visitor);
                this.accept(this.minutesDuration, "minutesDuration", visitor);
                this.accept(this.slot, "slot", visitor, Reference.class);
                this.accept(this.created, "created", visitor);
                this.accept(this.comment, "comment", visitor);
                this.accept(this.patientInstruction, "patientInstruction", visitor);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.participant, "participant", visitor, Participant.class);
                this.accept(this.requestedPeriod, "requestedPeriod", visitor, Period.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Appointment other = (Appointment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.cancelationReason, other.cancelationReason) && Objects.equals(this.serviceCategory, other.serviceCategory) && Objects.equals(this.serviceType, other.serviceType) && Objects.equals(this.specialty, other.specialty) && Objects.equals(this.appointmentType, other.appointmentType) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.priority, other.priority) && Objects.equals(this.description, other.description) && Objects.equals(this.supportingInformation, other.supportingInformation) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.minutesDuration, other.minutesDuration) && Objects.equals(this.slot, other.slot) && Objects.equals(this.created, other.created) && Objects.equals(this.comment, other.comment) && Objects.equals(this.patientInstruction, other.patientInstruction) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.participant, other.participant) && Objects.equals(this.requestedPeriod, other.requestedPeriod);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.cancelationReason, this.serviceCategory, this.serviceType, this.specialty, this.appointmentType, this.reasonCode, this.reasonReference, this.priority, this.description, this.supportingInformation, this.start, this.end, this.minutesDuration, this.slot, this.created, this.comment, this.patientInstruction, this.basedOn, this.participant, this.requestedPeriod);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Participant
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ParticipantType", strength=BindingStrength.Value.EXTENSIBLE, description="Role of participant in encounter.", valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
        private final List<CodeableConcept> type;
        @Summary
        @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device", "HealthcareService", "Location"})
        private final Reference actor;
        @Summary
        @Binding(bindingName="ParticipantRequired", strength=BindingStrength.Value.REQUIRED, description="Is the Participant required to attend the appointment.", valueSet="http://hl7.org/fhir/ValueSet/participantrequired|4.0.1")
        private final ParticipantRequired required;
        @Summary
        @Binding(bindingName="ParticipationStatus", strength=BindingStrength.Value.REQUIRED, description="The Participation status of an appointment.", valueSet="http://hl7.org/fhir/ValueSet/participationstatus|4.0.1")
        @Required
        private final ParticipationStatus status;
        private final Period period;

        private Participant(Builder builder) {
            super(builder);
            this.type = Collections.unmodifiableList(builder.type);
            this.actor = builder.actor;
            this.required = builder.required;
            this.status = builder.status;
            this.period = builder.period;
        }

        public List<CodeableConcept> getType() {
            return this.type;
        }

        public Reference getActor() {
            return this.actor;
        }

        public ParticipantRequired getRequired() {
            return this.required;
        }

        public ParticipationStatus getStatus() {
            return this.status;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.type.isEmpty() || this.actor != null || this.required != null || this.status != null || this.period != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor, CodeableConcept.class);
                    this.accept(this.actor, "actor", visitor);
                    this.accept(this.required, "required", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Participant other = (Participant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.actor, other.actor) && Objects.equals(this.required, other.required) && Objects.equals(this.status, other.status) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.actor, this.required, this.status, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
            private Reference actor;
            private ParticipantRequired required;
            private ParticipationStatus status;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept ... type) {
                for (CodeableConcept value : type) {
                    this.type.add(value);
                }
                return this;
            }

            public Builder type(Collection<CodeableConcept> type) {
                this.type = new ArrayList<CodeableConcept>(type);
                return this;
            }

            public Builder actor(Reference actor) {
                this.actor = actor;
                return this;
            }

            public Builder required(ParticipantRequired required) {
                this.required = required;
                return this;
            }

            public Builder status(ParticipationStatus status) {
                this.status = status;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public Participant build() {
                Participant participant = new Participant(this);
                if (this.validating) {
                    this.validate(participant);
                }
                return participant;
            }

            protected void validate(Participant participant) {
                super.validate(participant);
                ValidationSupport.checkList(participant.type, "type", CodeableConcept.class);
                ValidationSupport.requireNonNull(participant.status, "status");
                ValidationSupport.checkReferenceType(participant.actor, "actor", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device", "HealthcareService", "Location");
                ValidationSupport.requireValueOrChildren(participant);
            }

            protected Builder from(Participant participant) {
                super.from(participant);
                this.type.addAll(participant.type);
                this.actor = participant.actor;
                this.required = participant.required;
                this.status = participant.status;
                this.period = participant.period;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private AppointmentStatus status;
        private CodeableConcept cancelationReason;
        private List<CodeableConcept> serviceCategory = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> serviceType = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> specialty = new ArrayList<CodeableConcept>();
        private CodeableConcept appointmentType;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private UnsignedInt priority;
        private String description;
        private List<Reference> supportingInformation = new ArrayList<Reference>();
        private Instant start;
        private Instant end;
        private PositiveInt minutesDuration;
        private List<Reference> slot = new ArrayList<Reference>();
        private DateTime created;
        private String comment;
        private String patientInstruction;
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Participant> participant = new ArrayList<Participant>();
        private List<Period> requestedPeriod = new ArrayList<Period>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(AppointmentStatus status) {
            this.status = status;
            return this;
        }

        public Builder cancelationReason(CodeableConcept cancelationReason) {
            this.cancelationReason = cancelationReason;
            return this;
        }

        public Builder serviceCategory(CodeableConcept ... serviceCategory) {
            for (CodeableConcept value : serviceCategory) {
                this.serviceCategory.add(value);
            }
            return this;
        }

        public Builder serviceCategory(Collection<CodeableConcept> serviceCategory) {
            this.serviceCategory = new ArrayList<CodeableConcept>(serviceCategory);
            return this;
        }

        public Builder serviceType(CodeableConcept ... serviceType) {
            for (CodeableConcept value : serviceType) {
                this.serviceType.add(value);
            }
            return this;
        }

        public Builder serviceType(Collection<CodeableConcept> serviceType) {
            this.serviceType = new ArrayList<CodeableConcept>(serviceType);
            return this;
        }

        public Builder specialty(CodeableConcept ... specialty) {
            for (CodeableConcept value : specialty) {
                this.specialty.add(value);
            }
            return this;
        }

        public Builder specialty(Collection<CodeableConcept> specialty) {
            this.specialty = new ArrayList<CodeableConcept>(specialty);
            return this;
        }

        public Builder appointmentType(CodeableConcept appointmentType) {
            this.appointmentType = appointmentType;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder priority(UnsignedInt priority) {
            this.priority = priority;
            return this;
        }

        public Builder description(java.lang.String description) {
            this.description = description == null ? null : String.of(description);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder supportingInformation(Reference ... supportingInformation) {
            for (Reference value : supportingInformation) {
                this.supportingInformation.add(value);
            }
            return this;
        }

        public Builder supportingInformation(Collection<Reference> supportingInformation) {
            this.supportingInformation = new ArrayList<Reference>(supportingInformation);
            return this;
        }

        public Builder start(ZonedDateTime start) {
            this.start = start == null ? null : Instant.of(start);
            return this;
        }

        public Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public Builder end(ZonedDateTime end) {
            this.end = end == null ? null : Instant.of(end);
            return this;
        }

        public Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public Builder minutesDuration(PositiveInt minutesDuration) {
            this.minutesDuration = minutesDuration;
            return this;
        }

        public Builder slot(Reference ... slot) {
            for (Reference value : slot) {
                this.slot.add(value);
            }
            return this;
        }

        public Builder slot(Collection<Reference> slot) {
            this.slot = new ArrayList<Reference>(slot);
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder comment(java.lang.String comment) {
            this.comment = comment == null ? null : String.of(comment);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder patientInstruction(java.lang.String patientInstruction) {
            this.patientInstruction = patientInstruction == null ? null : String.of(patientInstruction);
            return this;
        }

        public Builder patientInstruction(String patientInstruction) {
            this.patientInstruction = patientInstruction;
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder participant(Participant ... participant) {
            for (Participant value : participant) {
                this.participant.add(value);
            }
            return this;
        }

        public Builder participant(Collection<Participant> participant) {
            this.participant = new ArrayList<Participant>(participant);
            return this;
        }

        public Builder requestedPeriod(Period ... requestedPeriod) {
            for (Period value : requestedPeriod) {
                this.requestedPeriod.add(value);
            }
            return this;
        }

        public Builder requestedPeriod(Collection<Period> requestedPeriod) {
            this.requestedPeriod = new ArrayList<Period>(requestedPeriod);
            return this;
        }

        @Override
        public Appointment build() {
            Appointment appointment = new Appointment(this);
            if (this.validating) {
                this.validate(appointment);
            }
            return appointment;
        }

        protected void validate(Appointment appointment) {
            super.validate(appointment);
            ValidationSupport.checkList(appointment.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(appointment.status, "status");
            ValidationSupport.checkList(appointment.serviceCategory, "serviceCategory", CodeableConcept.class);
            ValidationSupport.checkList(appointment.serviceType, "serviceType", CodeableConcept.class);
            ValidationSupport.checkList(appointment.specialty, "specialty", CodeableConcept.class);
            ValidationSupport.checkList(appointment.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(appointment.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(appointment.supportingInformation, "supportingInformation", Reference.class);
            ValidationSupport.checkList(appointment.slot, "slot", Reference.class);
            ValidationSupport.checkList(appointment.basedOn, "basedOn", Reference.class);
            ValidationSupport.checkNonEmptyList(appointment.participant, "participant", Participant.class);
            ValidationSupport.checkList(appointment.requestedPeriod, "requestedPeriod", Period.class);
            ValidationSupport.checkReferenceType(appointment.reasonReference, "reasonReference", "Condition", "Procedure", "Observation", "ImmunizationRecommendation");
            ValidationSupport.checkReferenceType(appointment.slot, "slot", "Slot");
            ValidationSupport.checkReferenceType(appointment.basedOn, "basedOn", "ServiceRequest");
        }

        protected Builder from(Appointment appointment) {
            super.from(appointment);
            this.identifier.addAll(appointment.identifier);
            this.status = appointment.status;
            this.cancelationReason = appointment.cancelationReason;
            this.serviceCategory.addAll(appointment.serviceCategory);
            this.serviceType.addAll(appointment.serviceType);
            this.specialty.addAll(appointment.specialty);
            this.appointmentType = appointment.appointmentType;
            this.reasonCode.addAll(appointment.reasonCode);
            this.reasonReference.addAll(appointment.reasonReference);
            this.priority = appointment.priority;
            this.description = appointment.description;
            this.supportingInformation.addAll(appointment.supportingInformation);
            this.start = appointment.start;
            this.end = appointment.end;
            this.minutesDuration = appointment.minutesDuration;
            this.slot.addAll(appointment.slot);
            this.created = appointment.created;
            this.comment = appointment.comment;
            this.patientInstruction = appointment.patientInstruction;
            this.basedOn.addAll(appointment.basedOn);
            this.participant.addAll(appointment.participant);
            this.requestedPeriod.addAll(appointment.requestedPeriod);
            return this;
        }
    }
}

