/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductCategory;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductStatus;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductStorageScale;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class BiologicallyDerivedProduct
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Binding(bindingName="BiologicallyDerivedProductCategory", strength=BindingStrength.Value.REQUIRED, description="Biologically Derived Product Category.", valueSet="http://hl7.org/fhir/ValueSet/product-category|4.0.1")
    private final BiologicallyDerivedProductCategory productCategory;
    @Binding(bindingName="BiologicallyDerivedProductCode", strength=BindingStrength.Value.EXAMPLE, description="Biologically Derived Product Code.")
    private final CodeableConcept productCode;
    @Binding(bindingName="BiologicallyDerivedProductStatus", strength=BindingStrength.Value.REQUIRED, description="Biologically Derived Product Status.", valueSet="http://hl7.org/fhir/ValueSet/product-status|4.0.1")
    private final BiologicallyDerivedProductStatus status;
    @ReferenceTarget(value={"ServiceRequest"})
    private final List<Reference> request;
    private final Integer quantity;
    @ReferenceTarget(value={"BiologicallyDerivedProduct"})
    private final List<Reference> parent;
    private final Collection collection;
    private final List<Processing> processing;
    private final Manipulation manipulation;
    private final List<Storage> storage;

    private BiologicallyDerivedProduct(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.productCategory = builder.productCategory;
        this.productCode = builder.productCode;
        this.status = builder.status;
        this.request = Collections.unmodifiableList(builder.request);
        this.quantity = builder.quantity;
        this.parent = Collections.unmodifiableList(builder.parent);
        this.collection = builder.collection;
        this.processing = Collections.unmodifiableList(builder.processing);
        this.manipulation = builder.manipulation;
        this.storage = Collections.unmodifiableList(builder.storage);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public BiologicallyDerivedProductCategory getProductCategory() {
        return this.productCategory;
    }

    public CodeableConcept getProductCode() {
        return this.productCode;
    }

    public BiologicallyDerivedProductStatus getStatus() {
        return this.status;
    }

    public List<Reference> getRequest() {
        return this.request;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public List<Reference> getParent() {
        return this.parent;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public List<Processing> getProcessing() {
        return this.processing;
    }

    public Manipulation getManipulation() {
        return this.manipulation;
    }

    public List<Storage> getStorage() {
        return this.storage;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.productCategory != null || this.productCode != null || this.status != null || !this.request.isEmpty() || this.quantity != null || !this.parent.isEmpty() || this.collection != null || !this.processing.isEmpty() || this.manipulation != null || !this.storage.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.productCategory, "productCategory", visitor);
                this.accept(this.productCode, "productCode", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.request, "request", visitor, Reference.class);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.parent, "parent", visitor, Reference.class);
                this.accept(this.collection, "collection", visitor);
                this.accept(this.processing, "processing", visitor, Processing.class);
                this.accept(this.manipulation, "manipulation", visitor);
                this.accept(this.storage, "storage", visitor, Storage.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BiologicallyDerivedProduct other = (BiologicallyDerivedProduct)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.productCategory, other.productCategory) && Objects.equals(this.productCode, other.productCode) && Objects.equals(this.status, other.status) && Objects.equals(this.request, other.request) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.parent, other.parent) && Objects.equals(this.collection, other.collection) && Objects.equals(this.processing, other.processing) && Objects.equals(this.manipulation, other.manipulation) && Objects.equals(this.storage, other.storage);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.productCategory, this.productCode, this.status, this.request, this.quantity, this.parent, this.collection, this.processing, this.manipulation, this.storage);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Storage
    extends BackboneElement {
        private final String description;
        private final Decimal temperature;
        @Binding(bindingName="BiologicallyDerivedProductStorageScale", strength=BindingStrength.Value.REQUIRED, description="BiologicallyDerived Product Storage Scale.", valueSet="http://hl7.org/fhir/ValueSet/product-storage-scale|4.0.1")
        private final BiologicallyDerivedProductStorageScale scale;
        private final Period duration;

        private Storage(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.temperature = builder.temperature;
            this.scale = builder.scale;
            this.duration = builder.duration;
        }

        public String getDescription() {
            return this.description;
        }

        public Decimal getTemperature() {
            return this.temperature;
        }

        public BiologicallyDerivedProductStorageScale getScale() {
            return this.scale;
        }

        public Period getDuration() {
            return this.duration;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.temperature != null || this.scale != null || this.duration != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.temperature, "temperature", visitor);
                    this.accept(this.scale, "scale", visitor);
                    this.accept(this.duration, "duration", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Storage other = (Storage)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.scale, other.scale) && Objects.equals(this.duration, other.duration);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.temperature, this.scale, this.duration);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private Decimal temperature;
            private BiologicallyDerivedProductStorageScale scale;
            private Period duration;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(java.util.Collection<Extension> extension) {
                return (Builder)super.extension((java.util.Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder temperature(Decimal temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder scale(BiologicallyDerivedProductStorageScale scale) {
                this.scale = scale;
                return this;
            }

            public Builder duration(Period duration) {
                this.duration = duration;
                return this;
            }

            @Override
            public Storage build() {
                Storage storage = new Storage(this);
                if (this.validating) {
                    this.validate(storage);
                }
                return storage;
            }

            protected void validate(Storage storage) {
                super.validate(storage);
                ValidationSupport.requireValueOrChildren(storage);
            }

            protected Builder from(Storage storage) {
                super.from(storage);
                this.description = storage.description;
                this.temperature = storage.temperature;
                this.scale = storage.scale;
                this.duration = storage.duration;
                return this;
            }
        }
    }

    public static class Manipulation
    extends BackboneElement {
        private final String description;
        @Choice(value={DateTime.class, Period.class})
        private final Element time;

        private Manipulation(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.time = builder.time;
        }

        public String getDescription() {
            return this.description;
        }

        public Element getTime() {
            return this.time;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.time != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.time, "time", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Manipulation other = (Manipulation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.time, other.time);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.time);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private Element time;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(java.util.Collection<Extension> extension) {
                return (Builder)super.extension((java.util.Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder time(Element time) {
                this.time = time;
                return this;
            }

            @Override
            public Manipulation build() {
                Manipulation manipulation = new Manipulation(this);
                if (this.validating) {
                    this.validate(manipulation);
                }
                return manipulation;
            }

            protected void validate(Manipulation manipulation) {
                super.validate(manipulation);
                ValidationSupport.choiceElement(manipulation.time, "time", DateTime.class, Period.class);
                ValidationSupport.requireValueOrChildren(manipulation);
            }

            protected Builder from(Manipulation manipulation) {
                super.from(manipulation);
                this.description = manipulation.description;
                this.time = manipulation.time;
                return this;
            }
        }
    }

    public static class Processing
    extends BackboneElement {
        private final String description;
        @Binding(bindingName="BiologicallyDerivedProductProcedure", strength=BindingStrength.Value.EXAMPLE, description="Biologically Derived Product Procedure.", valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
        private final CodeableConcept procedure;
        @ReferenceTarget(value={"Substance"})
        private final Reference additive;
        @Choice(value={DateTime.class, Period.class})
        private final Element time;

        private Processing(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.procedure = builder.procedure;
            this.additive = builder.additive;
            this.time = builder.time;
        }

        public String getDescription() {
            return this.description;
        }

        public CodeableConcept getProcedure() {
            return this.procedure;
        }

        public Reference getAdditive() {
            return this.additive;
        }

        public Element getTime() {
            return this.time;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.procedure != null || this.additive != null || this.time != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.procedure, "procedure", visitor);
                    this.accept(this.additive, "additive", visitor);
                    this.accept(this.time, "time", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Processing other = (Processing)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.procedure, other.procedure) && Objects.equals(this.additive, other.additive) && Objects.equals(this.time, other.time);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.procedure, this.additive, this.time);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private CodeableConcept procedure;
            private Reference additive;
            private Element time;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(java.util.Collection<Extension> extension) {
                return (Builder)super.extension((java.util.Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder procedure(CodeableConcept procedure) {
                this.procedure = procedure;
                return this;
            }

            public Builder additive(Reference additive) {
                this.additive = additive;
                return this;
            }

            public Builder time(Element time) {
                this.time = time;
                return this;
            }

            @Override
            public Processing build() {
                Processing processing = new Processing(this);
                if (this.validating) {
                    this.validate(processing);
                }
                return processing;
            }

            protected void validate(Processing processing) {
                super.validate(processing);
                ValidationSupport.choiceElement(processing.time, "time", DateTime.class, Period.class);
                ValidationSupport.checkReferenceType(processing.additive, "additive", "Substance");
                ValidationSupport.requireValueOrChildren(processing);
            }

            protected Builder from(Processing processing) {
                super.from(processing);
                this.description = processing.description;
                this.procedure = processing.procedure;
                this.additive = processing.additive;
                this.time = processing.time;
                return this;
            }
        }
    }

    public static class Collection
    extends BackboneElement {
        @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
        private final Reference collector;
        @ReferenceTarget(value={"Patient", "Organization"})
        private final Reference source;
        @Choice(value={DateTime.class, Period.class})
        private final Element collected;

        private Collection(Builder builder) {
            super(builder);
            this.collector = builder.collector;
            this.source = builder.source;
            this.collected = builder.collected;
        }

        public Reference getCollector() {
            return this.collector;
        }

        public Reference getSource() {
            return this.source;
        }

        public Element getCollected() {
            return this.collected;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.collector != null || this.source != null || this.collected != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.collector, "collector", visitor);
                    this.accept(this.source, "source", visitor);
                    this.accept(this.collected, "collected", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Collection other = (Collection)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.collector, other.collector) && Objects.equals(this.source, other.source) && Objects.equals(this.collected, other.collected);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.collector, this.source, this.collected);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference collector;
            private Reference source;
            private Element collected;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(java.util.Collection<Extension> extension) {
                return (Builder)super.extension((java.util.Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder collector(Reference collector) {
                this.collector = collector;
                return this;
            }

            public Builder source(Reference source) {
                this.source = source;
                return this;
            }

            public Builder collected(Element collected) {
                this.collected = collected;
                return this;
            }

            @Override
            public Collection build() {
                Collection collection = new Collection(this);
                if (this.validating) {
                    this.validate(collection);
                }
                return collection;
            }

            protected void validate(Collection collection) {
                super.validate(collection);
                ValidationSupport.choiceElement(collection.collected, "collected", DateTime.class, Period.class);
                ValidationSupport.checkReferenceType(collection.collector, "collector", "Practitioner", "PractitionerRole");
                ValidationSupport.checkReferenceType(collection.source, "source", "Patient", "Organization");
                ValidationSupport.requireValueOrChildren(collection);
            }

            protected Builder from(Collection collection) {
                super.from(collection);
                this.collector = collection.collector;
                this.source = collection.source;
                this.collected = collection.collected;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private BiologicallyDerivedProductCategory productCategory;
        private CodeableConcept productCode;
        private BiologicallyDerivedProductStatus status;
        private List<Reference> request = new ArrayList<Reference>();
        private Integer quantity;
        private List<Reference> parent = new ArrayList<Reference>();
        private Collection collection;
        private List<Processing> processing = new ArrayList<Processing>();
        private Manipulation manipulation;
        private List<Storage> storage = new ArrayList<Storage>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(java.util.Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(java.util.Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(java.util.Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder productCategory(BiologicallyDerivedProductCategory productCategory) {
            this.productCategory = productCategory;
            return this;
        }

        public Builder productCode(CodeableConcept productCode) {
            this.productCode = productCode;
            return this;
        }

        public Builder status(BiologicallyDerivedProductStatus status) {
            this.status = status;
            return this;
        }

        public Builder request(Reference ... request) {
            for (Reference value : request) {
                this.request.add(value);
            }
            return this;
        }

        public Builder request(java.util.Collection<Reference> request) {
            this.request = new ArrayList<Reference>(request);
            return this;
        }

        public Builder quantity(java.lang.Integer quantity) {
            this.quantity = quantity == null ? null : Integer.of(quantity);
            return this;
        }

        public Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder parent(Reference ... parent) {
            for (Reference value : parent) {
                this.parent.add(value);
            }
            return this;
        }

        public Builder parent(java.util.Collection<Reference> parent) {
            this.parent = new ArrayList<Reference>(parent);
            return this;
        }

        public Builder collection(Collection collection) {
            this.collection = collection;
            return this;
        }

        public Builder processing(Processing ... processing) {
            for (Processing value : processing) {
                this.processing.add(value);
            }
            return this;
        }

        public Builder processing(java.util.Collection<Processing> processing) {
            this.processing = new ArrayList<Processing>(processing);
            return this;
        }

        public Builder manipulation(Manipulation manipulation) {
            this.manipulation = manipulation;
            return this;
        }

        public Builder storage(Storage ... storage) {
            for (Storage value : storage) {
                this.storage.add(value);
            }
            return this;
        }

        public Builder storage(java.util.Collection<Storage> storage) {
            this.storage = new ArrayList<Storage>(storage);
            return this;
        }

        @Override
        public BiologicallyDerivedProduct build() {
            BiologicallyDerivedProduct biologicallyDerivedProduct = new BiologicallyDerivedProduct(this);
            if (this.validating) {
                this.validate(biologicallyDerivedProduct);
            }
            return biologicallyDerivedProduct;
        }

        protected void validate(BiologicallyDerivedProduct biologicallyDerivedProduct) {
            super.validate(biologicallyDerivedProduct);
            ValidationSupport.checkList(biologicallyDerivedProduct.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(biologicallyDerivedProduct.request, "request", Reference.class);
            ValidationSupport.checkList(biologicallyDerivedProduct.parent, "parent", Reference.class);
            ValidationSupport.checkList(biologicallyDerivedProduct.processing, "processing", Processing.class);
            ValidationSupport.checkList(biologicallyDerivedProduct.storage, "storage", Storage.class);
            ValidationSupport.checkReferenceType(biologicallyDerivedProduct.request, "request", "ServiceRequest");
            ValidationSupport.checkReferenceType(biologicallyDerivedProduct.parent, "parent", "BiologicallyDerivedProduct");
        }

        protected Builder from(BiologicallyDerivedProduct biologicallyDerivedProduct) {
            super.from(biologicallyDerivedProduct);
            this.identifier.addAll(biologicallyDerivedProduct.identifier);
            this.productCategory = biologicallyDerivedProduct.productCategory;
            this.productCode = biologicallyDerivedProduct.productCode;
            this.status = biologicallyDerivedProduct.status;
            this.request.addAll(biologicallyDerivedProduct.request);
            this.quantity = biologicallyDerivedProduct.quantity;
            this.parent.addAll(biologicallyDerivedProduct.parent);
            this.collection = biologicallyDerivedProduct.collection;
            this.processing.addAll(biologicallyDerivedProduct.processing);
            this.manipulation = biologicallyDerivedProduct.manipulation;
            this.storage.addAll(biologicallyDerivedProduct.storage);
            return this;
        }
    }
}

