/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ContractPublicationStatus;
import com.ibm.fhir.model.type.code.ContractStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="contract-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/contract-legalstate", expression="legalState.exists() implies (legalState.memberOf('http://hl7.org/fhir/ValueSet/contract-legalstate', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Contract", generated=true), @Constraint(id="contract-1", level="Warning", location="term.offer.decision", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-ActConsentDirective", expression="$this.memberOf('http://terminology.hl7.org/ValueSet/v3-ActConsentDirective', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Contract", generated=true), @Constraint(id="contract-2", level="Warning", location="term.asset.relationship", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/consent-content-class", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/consent-content-class', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Contract", generated=true), @Constraint(id="contract-3", level="Warning", location="signer.type", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/contract-signer-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/contract-signer-type', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Contract", generated=true)})
public class Contract
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    private final Uri url;
    @Summary
    private final String version;
    @Summary
    @Binding(bindingName="ContractStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/contract-status|4.0.1")
    private final ContractStatus status;
    @Binding(bindingName="ContractLegalState", strength=BindingStrength.Value.EXTENSIBLE, description="Detailed codes for the legal state of a contract.", valueSet="http://hl7.org/fhir/ValueSet/contract-legalstate")
    private final CodeableConcept legalState;
    @ReferenceTarget(value={"Contract"})
    private final Reference instantiatesCanonical;
    private final Uri instantiatesUri;
    @Binding(bindingName="ContractContentDerivative", strength=BindingStrength.Value.EXAMPLE, description="This is an example set of Content Derivative type codes, which represent the minimal content derived from the basal information source.", valueSet="http://hl7.org/fhir/ValueSet/contract-content-derivative")
    private final CodeableConcept contentDerivative;
    @Summary
    private final DateTime issued;
    @Summary
    private final Period applies;
    @Binding(bindingName="ContractExpiration", strength=BindingStrength.Value.EXAMPLE, description="Codes for the Cessation of Contracts.", valueSet="http://hl7.org/fhir/ValueSet/contract-expiration-type")
    private final CodeableConcept expirationType;
    @Summary
    private final List<Reference> subject;
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> authority;
    @ReferenceTarget(value={"Location"})
    private final List<Reference> domain;
    @ReferenceTarget(value={"Location"})
    private final List<Reference> site;
    @Summary
    private final String name;
    @Summary
    private final String title;
    private final String subtitle;
    private final List<String> alias;
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "Organization"})
    private final Reference author;
    @Binding(bindingName="ContractScope", strength=BindingStrength.Value.EXAMPLE, description="Codes for the range of legal concerns.", valueSet="http://hl7.org/fhir/ValueSet/contract-scope")
    private final CodeableConcept scope;
    @Choice(value={CodeableConcept.class, Reference.class})
    private final Element topic;
    @Summary
    @Binding(bindingName="ContractType", strength=BindingStrength.Value.EXAMPLE, description="List of overall contract codes.", valueSet="http://hl7.org/fhir/ValueSet/contract-type")
    private final CodeableConcept type;
    @Summary
    @Binding(bindingName="ContractSubtype", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes within the above.", valueSet="http://hl7.org/fhir/ValueSet/contract-subtype")
    private final List<CodeableConcept> subType;
    private final ContentDefinition contentDefinition;
    private final List<Term> term;
    private final List<Reference> supportingInfo;
    @ReferenceTarget(value={"Provenance"})
    private final List<Reference> relevantHistory;
    private final List<Signer> signer;
    private final List<Friendly> friendly;
    private final List<Legal> legal;
    private final List<Rule> rule;
    @ReferenceTarget(value={"Composition", "DocumentReference", "QuestionnaireResponse", "Contract"})
    @Choice(value={Attachment.class, Reference.class})
    private final Element legallyBinding;

    private Contract(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.url = builder.url;
        this.version = builder.version;
        this.status = builder.status;
        this.legalState = builder.legalState;
        this.instantiatesCanonical = builder.instantiatesCanonical;
        this.instantiatesUri = builder.instantiatesUri;
        this.contentDerivative = builder.contentDerivative;
        this.issued = builder.issued;
        this.applies = builder.applies;
        this.expirationType = builder.expirationType;
        this.subject = Collections.unmodifiableList(builder.subject);
        this.authority = Collections.unmodifiableList(builder.authority);
        this.domain = Collections.unmodifiableList(builder.domain);
        this.site = Collections.unmodifiableList(builder.site);
        this.name = builder.name;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.alias = Collections.unmodifiableList(builder.alias);
        this.author = builder.author;
        this.scope = builder.scope;
        this.topic = builder.topic;
        this.type = builder.type;
        this.subType = Collections.unmodifiableList(builder.subType);
        this.contentDefinition = builder.contentDefinition;
        this.term = Collections.unmodifiableList(builder.term);
        this.supportingInfo = Collections.unmodifiableList(builder.supportingInfo);
        this.relevantHistory = Collections.unmodifiableList(builder.relevantHistory);
        this.signer = Collections.unmodifiableList(builder.signer);
        this.friendly = Collections.unmodifiableList(builder.friendly);
        this.legal = Collections.unmodifiableList(builder.legal);
        this.rule = Collections.unmodifiableList(builder.rule);
        this.legallyBinding = builder.legallyBinding;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public ContractStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getLegalState() {
        return this.legalState;
    }

    public Reference getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public Uri getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public CodeableConcept getContentDerivative() {
        return this.contentDerivative;
    }

    public DateTime getIssued() {
        return this.issued;
    }

    public Period getApplies() {
        return this.applies;
    }

    public CodeableConcept getExpirationType() {
        return this.expirationType;
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public List<Reference> getAuthority() {
        return this.authority;
    }

    public List<Reference> getDomain() {
        return this.domain;
    }

    public List<Reference> getSite() {
        return this.site;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public CodeableConcept getScope() {
        return this.scope;
    }

    public Element getTopic() {
        return this.topic;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public List<CodeableConcept> getSubType() {
        return this.subType;
    }

    public ContentDefinition getContentDefinition() {
        return this.contentDefinition;
    }

    public List<Term> getTerm() {
        return this.term;
    }

    public List<Reference> getSupportingInfo() {
        return this.supportingInfo;
    }

    public List<Reference> getRelevantHistory() {
        return this.relevantHistory;
    }

    public List<Signer> getSigner() {
        return this.signer;
    }

    public List<Friendly> getFriendly() {
        return this.friendly;
    }

    public List<Legal> getLegal() {
        return this.legal;
    }

    public List<Rule> getRule() {
        return this.rule;
    }

    public Element getLegallyBinding() {
        return this.legallyBinding;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.url != null || this.version != null || this.status != null || this.legalState != null || this.instantiatesCanonical != null || this.instantiatesUri != null || this.contentDerivative != null || this.issued != null || this.applies != null || this.expirationType != null || !this.subject.isEmpty() || !this.authority.isEmpty() || !this.domain.isEmpty() || !this.site.isEmpty() || this.name != null || this.title != null || this.subtitle != null || !this.alias.isEmpty() || this.author != null || this.scope != null || this.topic != null || this.type != null || !this.subType.isEmpty() || this.contentDefinition != null || !this.term.isEmpty() || !this.supportingInfo.isEmpty() || !this.relevantHistory.isEmpty() || !this.signer.isEmpty() || !this.friendly.isEmpty() || !this.legal.isEmpty() || !this.rule.isEmpty() || this.legallyBinding != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.legalState, "legalState", visitor);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor);
                this.accept(this.contentDerivative, "contentDerivative", visitor);
                this.accept(this.issued, "issued", visitor);
                this.accept(this.applies, "applies", visitor);
                this.accept(this.expirationType, "expirationType", visitor);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.authority, "authority", visitor, Reference.class);
                this.accept(this.domain, "domain", visitor, Reference.class);
                this.accept(this.site, "site", visitor, Reference.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.alias, "alias", visitor, String.class);
                this.accept(this.author, "author", visitor);
                this.accept(this.scope, "scope", visitor);
                this.accept(this.topic, "topic", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.subType, "subType", visitor, CodeableConcept.class);
                this.accept(this.contentDefinition, "contentDefinition", visitor);
                this.accept(this.term, "term", visitor, Term.class);
                this.accept(this.supportingInfo, "supportingInfo", visitor, Reference.class);
                this.accept(this.relevantHistory, "relevantHistory", visitor, Reference.class);
                this.accept(this.signer, "signer", visitor, Signer.class);
                this.accept(this.friendly, "friendly", visitor, Friendly.class);
                this.accept(this.legal, "legal", visitor, Legal.class);
                this.accept(this.rule, "rule", visitor, Rule.class);
                this.accept(this.legallyBinding, "legallyBinding", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Contract other = (Contract)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.legalState, other.legalState) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.contentDerivative, other.contentDerivative) && Objects.equals(this.issued, other.issued) && Objects.equals(this.applies, other.applies) && Objects.equals(this.expirationType, other.expirationType) && Objects.equals(this.subject, other.subject) && Objects.equals(this.authority, other.authority) && Objects.equals(this.domain, other.domain) && Objects.equals(this.site, other.site) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.alias, other.alias) && Objects.equals(this.author, other.author) && Objects.equals(this.scope, other.scope) && Objects.equals(this.topic, other.topic) && Objects.equals(this.type, other.type) && Objects.equals(this.subType, other.subType) && Objects.equals(this.contentDefinition, other.contentDefinition) && Objects.equals(this.term, other.term) && Objects.equals(this.supportingInfo, other.supportingInfo) && Objects.equals(this.relevantHistory, other.relevantHistory) && Objects.equals(this.signer, other.signer) && Objects.equals(this.friendly, other.friendly) && Objects.equals(this.legal, other.legal) && Objects.equals(this.rule, other.rule) && Objects.equals(this.legallyBinding, other.legallyBinding);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.url, this.version, this.status, this.legalState, this.instantiatesCanonical, this.instantiatesUri, this.contentDerivative, this.issued, this.applies, this.expirationType, this.subject, this.authority, this.domain, this.site, this.name, this.title, this.subtitle, this.alias, this.author, this.scope, this.topic, this.type, this.subType, this.contentDefinition, this.term, this.supportingInfo, this.relevantHistory, this.signer, this.friendly, this.legal, this.rule, this.legallyBinding);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Rule
    extends BackboneElement {
        @ReferenceTarget(value={"DocumentReference"})
        @Choice(value={Attachment.class, Reference.class})
        @Required
        private final Element content;

        private Rule(Builder builder) {
            super(builder);
            this.content = builder.content;
        }

        public Element getContent() {
            return this.content;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.content != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.content, "content", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Rule other = (Rule)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.content, other.content);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.content);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element content;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder content(Element content) {
                this.content = content;
                return this;
            }

            @Override
            public Rule build() {
                Rule rule = new Rule(this);
                if (this.validating) {
                    this.validate(rule);
                }
                return rule;
            }

            protected void validate(Rule rule) {
                super.validate(rule);
                ValidationSupport.requireChoiceElement(rule.content, "content", Attachment.class, Reference.class);
                ValidationSupport.checkReferenceType(rule.content, "content", "DocumentReference");
                ValidationSupport.requireValueOrChildren(rule);
            }

            protected Builder from(Rule rule) {
                super.from(rule);
                this.content = rule.content;
                return this;
            }
        }
    }

    public static class Legal
    extends BackboneElement {
        @ReferenceTarget(value={"Composition", "DocumentReference", "QuestionnaireResponse"})
        @Choice(value={Attachment.class, Reference.class})
        @Required
        private final Element content;

        private Legal(Builder builder) {
            super(builder);
            this.content = builder.content;
        }

        public Element getContent() {
            return this.content;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.content != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.content, "content", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Legal other = (Legal)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.content, other.content);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.content);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element content;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder content(Element content) {
                this.content = content;
                return this;
            }

            @Override
            public Legal build() {
                Legal legal = new Legal(this);
                if (this.validating) {
                    this.validate(legal);
                }
                return legal;
            }

            protected void validate(Legal legal) {
                super.validate(legal);
                ValidationSupport.requireChoiceElement(legal.content, "content", Attachment.class, Reference.class);
                ValidationSupport.checkReferenceType(legal.content, "content", "Composition", "DocumentReference", "QuestionnaireResponse");
                ValidationSupport.requireValueOrChildren(legal);
            }

            protected Builder from(Legal legal) {
                super.from(legal);
                this.content = legal.content;
                return this;
            }
        }
    }

    public static class Friendly
    extends BackboneElement {
        @ReferenceTarget(value={"Composition", "DocumentReference", "QuestionnaireResponse"})
        @Choice(value={Attachment.class, Reference.class})
        @Required
        private final Element content;

        private Friendly(Builder builder) {
            super(builder);
            this.content = builder.content;
        }

        public Element getContent() {
            return this.content;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.content != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.content, "content", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Friendly other = (Friendly)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.content, other.content);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.content);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element content;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder content(Element content) {
                this.content = content;
                return this;
            }

            @Override
            public Friendly build() {
                Friendly friendly = new Friendly(this);
                if (this.validating) {
                    this.validate(friendly);
                }
                return friendly;
            }

            protected void validate(Friendly friendly) {
                super.validate(friendly);
                ValidationSupport.requireChoiceElement(friendly.content, "content", Attachment.class, Reference.class);
                ValidationSupport.checkReferenceType(friendly.content, "content", "Composition", "DocumentReference", "QuestionnaireResponse");
                ValidationSupport.requireValueOrChildren(friendly);
            }

            protected Builder from(Friendly friendly) {
                super.from(friendly);
                this.content = friendly.content;
                return this;
            }
        }
    }

    public static class Signer
    extends BackboneElement {
        @Binding(bindingName="ContractSignerType", strength=BindingStrength.Value.PREFERRED, description="List of parties who may be signing.", valueSet="http://hl7.org/fhir/ValueSet/contract-signer-type")
        @Required
        private final Coding type;
        @ReferenceTarget(value={"Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
        @Required
        private final Reference party;
        @Required
        private final List<Signature> signature;

        private Signer(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.party = builder.party;
            this.signature = Collections.unmodifiableList(builder.signature);
        }

        public Coding getType() {
            return this.type;
        }

        public Reference getParty() {
            return this.party;
        }

        public List<Signature> getSignature() {
            return this.signature;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.party != null || !this.signature.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.party, "party", visitor);
                    this.accept(this.signature, "signature", visitor, Signature.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Signer other = (Signer)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.party, other.party) && Objects.equals(this.signature, other.signature);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.party, this.signature);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Coding type;
            private Reference party;
            private List<Signature> signature = new ArrayList<Signature>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(Coding type) {
                this.type = type;
                return this;
            }

            public Builder party(Reference party) {
                this.party = party;
                return this;
            }

            public Builder signature(Signature ... signature) {
                for (Signature value : signature) {
                    this.signature.add(value);
                }
                return this;
            }

            public Builder signature(Collection<Signature> signature) {
                this.signature = new ArrayList<Signature>(signature);
                return this;
            }

            @Override
            public Signer build() {
                Signer signer = new Signer(this);
                if (this.validating) {
                    this.validate(signer);
                }
                return signer;
            }

            protected void validate(Signer signer) {
                super.validate(signer);
                ValidationSupport.requireNonNull(signer.type, "type");
                ValidationSupport.requireNonNull(signer.party, "party");
                ValidationSupport.checkNonEmptyList(signer.signature, "signature", Signature.class);
                ValidationSupport.checkReferenceType(signer.party, "party", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(signer);
            }

            protected Builder from(Signer signer) {
                super.from(signer);
                this.type = signer.type;
                this.party = signer.party;
                this.signature.addAll(signer.signature);
                return this;
            }
        }
    }

    public static class Term
    extends BackboneElement {
        @Summary
        private final Identifier identifier;
        @Summary
        private final DateTime issued;
        @Summary
        private final Period applies;
        @Choice(value={CodeableConcept.class, Reference.class})
        private final Element topic;
        @Binding(bindingName="ContractTermType", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the types of contract provisions.", valueSet="http://hl7.org/fhir/ValueSet/contract-term-type")
        private final CodeableConcept type;
        @Binding(bindingName="ContractTermSubType", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the subtypes of contract provisions.", valueSet="http://hl7.org/fhir/ValueSet/contract-term-subtype")
        private final CodeableConcept subType;
        @Summary
        private final String text;
        private final List<SecurityLabel> securityLabel;
        @Required
        private final Offer offer;
        private final List<Asset> asset;
        private final List<Action> action;
        private final List<Term> group;

        private Term(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.issued = builder.issued;
            this.applies = builder.applies;
            this.topic = builder.topic;
            this.type = builder.type;
            this.subType = builder.subType;
            this.text = builder.text;
            this.securityLabel = Collections.unmodifiableList(builder.securityLabel);
            this.offer = builder.offer;
            this.asset = Collections.unmodifiableList(builder.asset);
            this.action = Collections.unmodifiableList(builder.action);
            this.group = Collections.unmodifiableList(builder.group);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public DateTime getIssued() {
            return this.issued;
        }

        public Period getApplies() {
            return this.applies;
        }

        public Element getTopic() {
            return this.topic;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getSubType() {
            return this.subType;
        }

        public String getText() {
            return this.text;
        }

        public List<SecurityLabel> getSecurityLabel() {
            return this.securityLabel;
        }

        public Offer getOffer() {
            return this.offer;
        }

        public List<Asset> getAsset() {
            return this.asset;
        }

        public List<Action> getAction() {
            return this.action;
        }

        public List<Term> getGroup() {
            return this.group;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.issued != null || this.applies != null || this.topic != null || this.type != null || this.subType != null || this.text != null || !this.securityLabel.isEmpty() || this.offer != null || !this.asset.isEmpty() || !this.action.isEmpty() || !this.group.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.issued, "issued", visitor);
                    this.accept(this.applies, "applies", visitor);
                    this.accept(this.topic, "topic", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.subType, "subType", visitor);
                    this.accept(this.text, "text", visitor);
                    this.accept(this.securityLabel, "securityLabel", visitor, SecurityLabel.class);
                    this.accept(this.offer, "offer", visitor);
                    this.accept(this.asset, "asset", visitor, Asset.class);
                    this.accept(this.action, "action", visitor, Action.class);
                    this.accept(this.group, "group", visitor, Term.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Term other = (Term)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.issued, other.issued) && Objects.equals(this.applies, other.applies) && Objects.equals(this.topic, other.topic) && Objects.equals(this.type, other.type) && Objects.equals(this.subType, other.subType) && Objects.equals(this.text, other.text) && Objects.equals(this.securityLabel, other.securityLabel) && Objects.equals(this.offer, other.offer) && Objects.equals(this.asset, other.asset) && Objects.equals(this.action, other.action) && Objects.equals(this.group, other.group);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.issued, this.applies, this.topic, this.type, this.subType, this.text, this.securityLabel, this.offer, this.asset, this.action, this.group);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Action
        extends BackboneElement {
            private final Boolean doNotPerform;
            @Binding(bindingName="ContractAction", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the contract action.", valueSet="http://hl7.org/fhir/ValueSet/contract-action")
            @Required
            private final CodeableConcept type;
            private final List<Subject> subject;
            @Binding(bindingName="ContractActionReason", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the contract action reason.", valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
            @Required
            private final CodeableConcept intent;
            private final List<String> linkId;
            @Binding(bindingName="ContractActionStatus", strength=BindingStrength.Value.EXAMPLE, description="Codes for the status of an term action.", valueSet="http://hl7.org/fhir/ValueSet/contract-actionstatus")
            @Required
            private final CodeableConcept status;
            @ReferenceTarget(value={"Encounter", "EpisodeOfCare"})
            private final Reference context;
            private final List<String> contextLinkId;
            @Choice(value={DateTime.class, Period.class, Timing.class})
            private final Element occurrence;
            @ReferenceTarget(value={"Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Device", "Group", "Organization"})
            private final List<Reference> requester;
            private final List<String> requesterLinkId;
            @Binding(bindingName="ContractActionPerformerType", strength=BindingStrength.Value.EXAMPLE, description="Codes for the types of action perfomer.", valueSet="http://hl7.org/fhir/ValueSet/provenance-agent-type")
            private final List<CodeableConcept> performerType;
            @Binding(bindingName="ContractActionPerformerRole", strength=BindingStrength.Value.EXAMPLE, description="Codes for the role of the action performer.", valueSet="http://hl7.org/fhir/ValueSet/provenance-agent-role")
            private final CodeableConcept performerRole;
            @ReferenceTarget(value={"RelatedPerson", "Patient", "Practitioner", "PractitionerRole", "CareTeam", "Device", "Substance", "Organization", "Location"})
            private final Reference performer;
            private final List<String> performerLinkId;
            @Binding(bindingName="ContractActionReason", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the contract action reason.", valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
            private final List<CodeableConcept> reasonCode;
            @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference", "Questionnaire", "QuestionnaireResponse"})
            private final List<Reference> reasonReference;
            private final List<String> reason;
            private final List<String> reasonLinkId;
            private final List<Annotation> note;
            private final List<UnsignedInt> securityLabelNumber;

            private Action(Builder builder) {
                super(builder);
                this.doNotPerform = builder.doNotPerform;
                this.type = builder.type;
                this.subject = Collections.unmodifiableList(builder.subject);
                this.intent = builder.intent;
                this.linkId = Collections.unmodifiableList(builder.linkId);
                this.status = builder.status;
                this.context = builder.context;
                this.contextLinkId = Collections.unmodifiableList(builder.contextLinkId);
                this.occurrence = builder.occurrence;
                this.requester = Collections.unmodifiableList(builder.requester);
                this.requesterLinkId = Collections.unmodifiableList(builder.requesterLinkId);
                this.performerType = Collections.unmodifiableList(builder.performerType);
                this.performerRole = builder.performerRole;
                this.performer = builder.performer;
                this.performerLinkId = Collections.unmodifiableList(builder.performerLinkId);
                this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
                this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
                this.reason = Collections.unmodifiableList(builder.reason);
                this.reasonLinkId = Collections.unmodifiableList(builder.reasonLinkId);
                this.note = Collections.unmodifiableList(builder.note);
                this.securityLabelNumber = Collections.unmodifiableList(builder.securityLabelNumber);
            }

            public Boolean getDoNotPerform() {
                return this.doNotPerform;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public List<Subject> getSubject() {
                return this.subject;
            }

            public CodeableConcept getIntent() {
                return this.intent;
            }

            public List<String> getLinkId() {
                return this.linkId;
            }

            public CodeableConcept getStatus() {
                return this.status;
            }

            public Reference getContext() {
                return this.context;
            }

            public List<String> getContextLinkId() {
                return this.contextLinkId;
            }

            public Element getOccurrence() {
                return this.occurrence;
            }

            public List<Reference> getRequester() {
                return this.requester;
            }

            public List<String> getRequesterLinkId() {
                return this.requesterLinkId;
            }

            public List<CodeableConcept> getPerformerType() {
                return this.performerType;
            }

            public CodeableConcept getPerformerRole() {
                return this.performerRole;
            }

            public Reference getPerformer() {
                return this.performer;
            }

            public List<String> getPerformerLinkId() {
                return this.performerLinkId;
            }

            public List<CodeableConcept> getReasonCode() {
                return this.reasonCode;
            }

            public List<Reference> getReasonReference() {
                return this.reasonReference;
            }

            public List<String> getReason() {
                return this.reason;
            }

            public List<String> getReasonLinkId() {
                return this.reasonLinkId;
            }

            public List<Annotation> getNote() {
                return this.note;
            }

            public List<UnsignedInt> getSecurityLabelNumber() {
                return this.securityLabelNumber;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.doNotPerform != null || this.type != null || !this.subject.isEmpty() || this.intent != null || !this.linkId.isEmpty() || this.status != null || this.context != null || !this.contextLinkId.isEmpty() || this.occurrence != null || !this.requester.isEmpty() || !this.requesterLinkId.isEmpty() || !this.performerType.isEmpty() || this.performerRole != null || this.performer != null || !this.performerLinkId.isEmpty() || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.reason.isEmpty() || !this.reasonLinkId.isEmpty() || !this.note.isEmpty() || !this.securityLabelNumber.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.doNotPerform, "doNotPerform", visitor);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.subject, "subject", visitor, Subject.class);
                        this.accept(this.intent, "intent", visitor);
                        this.accept(this.linkId, "linkId", visitor, String.class);
                        this.accept(this.status, "status", visitor);
                        this.accept(this.context, "context", visitor);
                        this.accept(this.contextLinkId, "contextLinkId", visitor, String.class);
                        this.accept(this.occurrence, "occurrence", visitor);
                        this.accept(this.requester, "requester", visitor, Reference.class);
                        this.accept(this.requesterLinkId, "requesterLinkId", visitor, String.class);
                        this.accept(this.performerType, "performerType", visitor, CodeableConcept.class);
                        this.accept(this.performerRole, "performerRole", visitor);
                        this.accept(this.performer, "performer", visitor);
                        this.accept(this.performerLinkId, "performerLinkId", visitor, String.class);
                        this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                        this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                        this.accept(this.reason, "reason", visitor, String.class);
                        this.accept(this.reasonLinkId, "reasonLinkId", visitor, String.class);
                        this.accept(this.note, "note", visitor, Annotation.class);
                        this.accept(this.securityLabelNumber, "securityLabelNumber", visitor, UnsignedInt.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Action other = (Action)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.doNotPerform, other.doNotPerform) && Objects.equals(this.type, other.type) && Objects.equals(this.subject, other.subject) && Objects.equals(this.intent, other.intent) && Objects.equals(this.linkId, other.linkId) && Objects.equals(this.status, other.status) && Objects.equals(this.context, other.context) && Objects.equals(this.contextLinkId, other.contextLinkId) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.requester, other.requester) && Objects.equals(this.requesterLinkId, other.requesterLinkId) && Objects.equals(this.performerType, other.performerType) && Objects.equals(this.performerRole, other.performerRole) && Objects.equals(this.performer, other.performer) && Objects.equals(this.performerLinkId, other.performerLinkId) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.reason, other.reason) && Objects.equals(this.reasonLinkId, other.reasonLinkId) && Objects.equals(this.note, other.note) && Objects.equals(this.securityLabelNumber, other.securityLabelNumber);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.doNotPerform, this.type, this.subject, this.intent, this.linkId, this.status, this.context, this.contextLinkId, this.occurrence, this.requester, this.requesterLinkId, this.performerType, this.performerRole, this.performer, this.performerLinkId, this.reasonCode, this.reasonReference, this.reason, this.reasonLinkId, this.note, this.securityLabelNumber);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Subject
            extends BackboneElement {
                @ReferenceTarget(value={"Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Device", "Group", "Organization"})
                @Required
                private final List<Reference> reference;
                @Binding(bindingName="ContractActorRole", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the contract actor role.", valueSet="http://hl7.org/fhir/ValueSet/contract-actorrole")
                private final CodeableConcept role;

                private Subject(Builder builder) {
                    super(builder);
                    this.reference = Collections.unmodifiableList(builder.reference);
                    this.role = builder.role;
                }

                public List<Reference> getReference() {
                    return this.reference;
                }

                public CodeableConcept getRole() {
                    return this.role;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || !this.reference.isEmpty() || this.role != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.reference, "reference", visitor, Reference.class);
                            this.accept(this.role, "role", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Subject other = (Subject)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.role, other.role);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.reference, this.role);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private List<Reference> reference = new ArrayList<Reference>();
                    private CodeableConcept role;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder reference(Reference ... reference) {
                        for (Reference value : reference) {
                            this.reference.add(value);
                        }
                        return this;
                    }

                    public Builder reference(Collection<Reference> reference) {
                        this.reference = new ArrayList<Reference>(reference);
                        return this;
                    }

                    public Builder role(CodeableConcept role) {
                        this.role = role;
                        return this;
                    }

                    @Override
                    public Subject build() {
                        Subject subject = new Subject(this);
                        if (this.validating) {
                            this.validate(subject);
                        }
                        return subject;
                    }

                    protected void validate(Subject subject) {
                        super.validate(subject);
                        ValidationSupport.checkNonEmptyList(subject.reference, "reference", Reference.class);
                        ValidationSupport.checkReferenceType(subject.reference, "reference", "Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Device", "Group", "Organization");
                        ValidationSupport.requireValueOrChildren(subject);
                    }

                    protected Builder from(Subject subject) {
                        super.from(subject);
                        this.reference.addAll(subject.reference);
                        this.role = subject.role;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Boolean doNotPerform;
                private CodeableConcept type;
                private List<Subject> subject = new ArrayList<Subject>();
                private CodeableConcept intent;
                private List<String> linkId = new ArrayList<String>();
                private CodeableConcept status;
                private Reference context;
                private List<String> contextLinkId = new ArrayList<String>();
                private Element occurrence;
                private List<Reference> requester = new ArrayList<Reference>();
                private List<String> requesterLinkId = new ArrayList<String>();
                private List<CodeableConcept> performerType = new ArrayList<CodeableConcept>();
                private CodeableConcept performerRole;
                private Reference performer;
                private List<String> performerLinkId = new ArrayList<String>();
                private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
                private List<Reference> reasonReference = new ArrayList<Reference>();
                private List<String> reason = new ArrayList<String>();
                private List<String> reasonLinkId = new ArrayList<String>();
                private List<Annotation> note = new ArrayList<Annotation>();
                private List<UnsignedInt> securityLabelNumber = new ArrayList<UnsignedInt>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder doNotPerform(java.lang.Boolean doNotPerform) {
                    this.doNotPerform = doNotPerform == null ? null : Boolean.of(doNotPerform);
                    return this;
                }

                public Builder doNotPerform(Boolean doNotPerform) {
                    this.doNotPerform = doNotPerform;
                    return this;
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder subject(Subject ... subject) {
                    for (Subject value : subject) {
                        this.subject.add(value);
                    }
                    return this;
                }

                public Builder subject(Collection<Subject> subject) {
                    this.subject = new ArrayList<Subject>(subject);
                    return this;
                }

                public Builder intent(CodeableConcept intent) {
                    this.intent = intent;
                    return this;
                }

                public Builder linkId(java.lang.String ... linkId) {
                    for (java.lang.String value : linkId) {
                        this.linkId.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder linkId(String ... linkId) {
                    for (String value : linkId) {
                        this.linkId.add(value);
                    }
                    return this;
                }

                public Builder linkId(Collection<String> linkId) {
                    this.linkId = new ArrayList<String>(linkId);
                    return this;
                }

                public Builder status(CodeableConcept status) {
                    this.status = status;
                    return this;
                }

                public Builder context(Reference context) {
                    this.context = context;
                    return this;
                }

                public Builder contextLinkId(java.lang.String ... contextLinkId) {
                    for (java.lang.String value : contextLinkId) {
                        this.contextLinkId.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder contextLinkId(String ... contextLinkId) {
                    for (String value : contextLinkId) {
                        this.contextLinkId.add(value);
                    }
                    return this;
                }

                public Builder contextLinkId(Collection<String> contextLinkId) {
                    this.contextLinkId = new ArrayList<String>(contextLinkId);
                    return this;
                }

                public Builder occurrence(Element occurrence) {
                    this.occurrence = occurrence;
                    return this;
                }

                public Builder requester(Reference ... requester) {
                    for (Reference value : requester) {
                        this.requester.add(value);
                    }
                    return this;
                }

                public Builder requester(Collection<Reference> requester) {
                    this.requester = new ArrayList<Reference>(requester);
                    return this;
                }

                public Builder requesterLinkId(java.lang.String ... requesterLinkId) {
                    for (java.lang.String value : requesterLinkId) {
                        this.requesterLinkId.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder requesterLinkId(String ... requesterLinkId) {
                    for (String value : requesterLinkId) {
                        this.requesterLinkId.add(value);
                    }
                    return this;
                }

                public Builder requesterLinkId(Collection<String> requesterLinkId) {
                    this.requesterLinkId = new ArrayList<String>(requesterLinkId);
                    return this;
                }

                public Builder performerType(CodeableConcept ... performerType) {
                    for (CodeableConcept value : performerType) {
                        this.performerType.add(value);
                    }
                    return this;
                }

                public Builder performerType(Collection<CodeableConcept> performerType) {
                    this.performerType = new ArrayList<CodeableConcept>(performerType);
                    return this;
                }

                public Builder performerRole(CodeableConcept performerRole) {
                    this.performerRole = performerRole;
                    return this;
                }

                public Builder performer(Reference performer) {
                    this.performer = performer;
                    return this;
                }

                public Builder performerLinkId(java.lang.String ... performerLinkId) {
                    for (java.lang.String value : performerLinkId) {
                        this.performerLinkId.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder performerLinkId(String ... performerLinkId) {
                    for (String value : performerLinkId) {
                        this.performerLinkId.add(value);
                    }
                    return this;
                }

                public Builder performerLinkId(Collection<String> performerLinkId) {
                    this.performerLinkId = new ArrayList<String>(performerLinkId);
                    return this;
                }

                public Builder reasonCode(CodeableConcept ... reasonCode) {
                    for (CodeableConcept value : reasonCode) {
                        this.reasonCode.add(value);
                    }
                    return this;
                }

                public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
                    this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
                    return this;
                }

                public Builder reasonReference(Reference ... reasonReference) {
                    for (Reference value : reasonReference) {
                        this.reasonReference.add(value);
                    }
                    return this;
                }

                public Builder reasonReference(Collection<Reference> reasonReference) {
                    this.reasonReference = new ArrayList<Reference>(reasonReference);
                    return this;
                }

                public Builder reason(java.lang.String ... reason) {
                    for (java.lang.String value : reason) {
                        this.reason.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder reason(String ... reason) {
                    for (String value : reason) {
                        this.reason.add(value);
                    }
                    return this;
                }

                public Builder reason(Collection<String> reason) {
                    this.reason = new ArrayList<String>(reason);
                    return this;
                }

                public Builder reasonLinkId(java.lang.String ... reasonLinkId) {
                    for (java.lang.String value : reasonLinkId) {
                        this.reasonLinkId.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder reasonLinkId(String ... reasonLinkId) {
                    for (String value : reasonLinkId) {
                        this.reasonLinkId.add(value);
                    }
                    return this;
                }

                public Builder reasonLinkId(Collection<String> reasonLinkId) {
                    this.reasonLinkId = new ArrayList<String>(reasonLinkId);
                    return this;
                }

                public Builder note(Annotation ... note) {
                    for (Annotation value : note) {
                        this.note.add(value);
                    }
                    return this;
                }

                public Builder note(Collection<Annotation> note) {
                    this.note = new ArrayList<Annotation>(note);
                    return this;
                }

                public Builder securityLabelNumber(UnsignedInt ... securityLabelNumber) {
                    for (UnsignedInt value : securityLabelNumber) {
                        this.securityLabelNumber.add(value);
                    }
                    return this;
                }

                public Builder securityLabelNumber(Collection<UnsignedInt> securityLabelNumber) {
                    this.securityLabelNumber = new ArrayList<UnsignedInt>(securityLabelNumber);
                    return this;
                }

                @Override
                public Action build() {
                    Action action = new Action(this);
                    if (this.validating) {
                        this.validate(action);
                    }
                    return action;
                }

                protected void validate(Action action) {
                    super.validate(action);
                    ValidationSupport.requireNonNull(action.type, "type");
                    ValidationSupport.checkList(action.subject, "subject", Subject.class);
                    ValidationSupport.requireNonNull(action.intent, "intent");
                    ValidationSupport.checkList(action.linkId, "linkId", String.class);
                    ValidationSupport.requireNonNull(action.status, "status");
                    ValidationSupport.checkList(action.contextLinkId, "contextLinkId", String.class);
                    ValidationSupport.choiceElement(action.occurrence, "occurrence", DateTime.class, Period.class, Timing.class);
                    ValidationSupport.checkList(action.requester, "requester", Reference.class);
                    ValidationSupport.checkList(action.requesterLinkId, "requesterLinkId", String.class);
                    ValidationSupport.checkList(action.performerType, "performerType", CodeableConcept.class);
                    ValidationSupport.checkList(action.performerLinkId, "performerLinkId", String.class);
                    ValidationSupport.checkList(action.reasonCode, "reasonCode", CodeableConcept.class);
                    ValidationSupport.checkList(action.reasonReference, "reasonReference", Reference.class);
                    ValidationSupport.checkList(action.reason, "reason", String.class);
                    ValidationSupport.checkList(action.reasonLinkId, "reasonLinkId", String.class);
                    ValidationSupport.checkList(action.note, "note", Annotation.class);
                    ValidationSupport.checkList(action.securityLabelNumber, "securityLabelNumber", UnsignedInt.class);
                    ValidationSupport.checkReferenceType(action.context, "context", "Encounter", "EpisodeOfCare");
                    ValidationSupport.checkReferenceType(action.requester, "requester", "Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Device", "Group", "Organization");
                    ValidationSupport.checkReferenceType(action.performer, "performer", "RelatedPerson", "Patient", "Practitioner", "PractitionerRole", "CareTeam", "Device", "Substance", "Organization", "Location");
                    ValidationSupport.checkReferenceType(action.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference", "Questionnaire", "QuestionnaireResponse");
                    ValidationSupport.requireValueOrChildren(action);
                }

                protected Builder from(Action action) {
                    super.from(action);
                    this.doNotPerform = action.doNotPerform;
                    this.type = action.type;
                    this.subject.addAll(action.subject);
                    this.intent = action.intent;
                    this.linkId.addAll(action.linkId);
                    this.status = action.status;
                    this.context = action.context;
                    this.contextLinkId.addAll(action.contextLinkId);
                    this.occurrence = action.occurrence;
                    this.requester.addAll(action.requester);
                    this.requesterLinkId.addAll(action.requesterLinkId);
                    this.performerType.addAll(action.performerType);
                    this.performerRole = action.performerRole;
                    this.performer = action.performer;
                    this.performerLinkId.addAll(action.performerLinkId);
                    this.reasonCode.addAll(action.reasonCode);
                    this.reasonReference.addAll(action.reasonReference);
                    this.reason.addAll(action.reason);
                    this.reasonLinkId.addAll(action.reasonLinkId);
                    this.note.addAll(action.note);
                    this.securityLabelNumber.addAll(action.securityLabelNumber);
                    return this;
                }
            }
        }

        public static class Asset
        extends BackboneElement {
            @Binding(bindingName="ContractAssetScope", strength=BindingStrength.Value.EXAMPLE, description="Codes for scoping an asset.", valueSet="http://hl7.org/fhir/ValueSet/contract-assetscope")
            private final CodeableConcept scope;
            @Binding(bindingName="ContractAssetType", strength=BindingStrength.Value.EXAMPLE, description="Condes for the type of an asset.", valueSet="http://hl7.org/fhir/ValueSet/contract-assettype")
            private final List<CodeableConcept> type;
            private final List<Reference> typeReference;
            @Binding(bindingName="ContractAssetSubtype", strength=BindingStrength.Value.EXAMPLE, description="Condes for the sub-type of an asset.", valueSet="http://hl7.org/fhir/ValueSet/contract-assetsubtype")
            private final List<CodeableConcept> subtype;
            @Binding(bindingName="ConsentContentClass", strength=BindingStrength.Value.EXTENSIBLE, description="The class (type) of information a consent rule covers.", valueSet="http://hl7.org/fhir/ValueSet/consent-content-class")
            private final Coding relationship;
            private final List<Context> context;
            private final String condition;
            @Binding(bindingName="AssetAvailabilityType", strength=BindingStrength.Value.EXAMPLE, description="Codes for asset availability.", valueSet="http://hl7.org/fhir/ValueSet/asset-availability")
            private final List<CodeableConcept> periodType;
            private final List<Period> period;
            private final List<Period> usePeriod;
            private final String text;
            private final List<String> linkId;
            private final List<Offer.Answer> answer;
            private final List<UnsignedInt> securityLabelNumber;
            private final List<ValuedItem> valuedItem;

            private Asset(Builder builder) {
                super(builder);
                this.scope = builder.scope;
                this.type = Collections.unmodifiableList(builder.type);
                this.typeReference = Collections.unmodifiableList(builder.typeReference);
                this.subtype = Collections.unmodifiableList(builder.subtype);
                this.relationship = builder.relationship;
                this.context = Collections.unmodifiableList(builder.context);
                this.condition = builder.condition;
                this.periodType = Collections.unmodifiableList(builder.periodType);
                this.period = Collections.unmodifiableList(builder.period);
                this.usePeriod = Collections.unmodifiableList(builder.usePeriod);
                this.text = builder.text;
                this.linkId = Collections.unmodifiableList(builder.linkId);
                this.answer = Collections.unmodifiableList(builder.answer);
                this.securityLabelNumber = Collections.unmodifiableList(builder.securityLabelNumber);
                this.valuedItem = Collections.unmodifiableList(builder.valuedItem);
            }

            public CodeableConcept getScope() {
                return this.scope;
            }

            public List<CodeableConcept> getType() {
                return this.type;
            }

            public List<Reference> getTypeReference() {
                return this.typeReference;
            }

            public List<CodeableConcept> getSubtype() {
                return this.subtype;
            }

            public Coding getRelationship() {
                return this.relationship;
            }

            public List<Context> getContext() {
                return this.context;
            }

            public String getCondition() {
                return this.condition;
            }

            public List<CodeableConcept> getPeriodType() {
                return this.periodType;
            }

            public List<Period> getPeriod() {
                return this.period;
            }

            public List<Period> getUsePeriod() {
                return this.usePeriod;
            }

            public String getText() {
                return this.text;
            }

            public List<String> getLinkId() {
                return this.linkId;
            }

            public List<Offer.Answer> getAnswer() {
                return this.answer;
            }

            public List<UnsignedInt> getSecurityLabelNumber() {
                return this.securityLabelNumber;
            }

            public List<ValuedItem> getValuedItem() {
                return this.valuedItem;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.scope != null || !this.type.isEmpty() || !this.typeReference.isEmpty() || !this.subtype.isEmpty() || this.relationship != null || !this.context.isEmpty() || this.condition != null || !this.periodType.isEmpty() || !this.period.isEmpty() || !this.usePeriod.isEmpty() || this.text != null || !this.linkId.isEmpty() || !this.answer.isEmpty() || !this.securityLabelNumber.isEmpty() || !this.valuedItem.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.scope, "scope", visitor);
                        this.accept(this.type, "type", visitor, CodeableConcept.class);
                        this.accept(this.typeReference, "typeReference", visitor, Reference.class);
                        this.accept(this.subtype, "subtype", visitor, CodeableConcept.class);
                        this.accept(this.relationship, "relationship", visitor);
                        this.accept(this.context, "context", visitor, Context.class);
                        this.accept(this.condition, "condition", visitor);
                        this.accept(this.periodType, "periodType", visitor, CodeableConcept.class);
                        this.accept(this.period, "period", visitor, Period.class);
                        this.accept(this.usePeriod, "usePeriod", visitor, Period.class);
                        this.accept(this.text, "text", visitor);
                        this.accept(this.linkId, "linkId", visitor, String.class);
                        this.accept(this.answer, "answer", visitor, Offer.Answer.class);
                        this.accept(this.securityLabelNumber, "securityLabelNumber", visitor, UnsignedInt.class);
                        this.accept(this.valuedItem, "valuedItem", visitor, ValuedItem.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Asset other = (Asset)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.scope, other.scope) && Objects.equals(this.type, other.type) && Objects.equals(this.typeReference, other.typeReference) && Objects.equals(this.subtype, other.subtype) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.context, other.context) && Objects.equals(this.condition, other.condition) && Objects.equals(this.periodType, other.periodType) && Objects.equals(this.period, other.period) && Objects.equals(this.usePeriod, other.usePeriod) && Objects.equals(this.text, other.text) && Objects.equals(this.linkId, other.linkId) && Objects.equals(this.answer, other.answer) && Objects.equals(this.securityLabelNumber, other.securityLabelNumber) && Objects.equals(this.valuedItem, other.valuedItem);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.scope, this.type, this.typeReference, this.subtype, this.relationship, this.context, this.condition, this.periodType, this.period, this.usePeriod, this.text, this.linkId, this.answer, this.securityLabelNumber, this.valuedItem);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class ValuedItem
            extends BackboneElement {
                @Choice(value={CodeableConcept.class, Reference.class})
                private final Element entity;
                private final Identifier identifier;
                private final DateTime effectiveTime;
                private final SimpleQuantity quantity;
                private final Money unitPrice;
                private final Decimal factor;
                private final Decimal points;
                private final Money net;
                private final String payment;
                private final DateTime paymentDate;
                @ReferenceTarget(value={"Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
                private final Reference responsible;
                @ReferenceTarget(value={"Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
                private final Reference recipient;
                private final List<String> linkId;
                private final List<UnsignedInt> securityLabelNumber;

                private ValuedItem(Builder builder) {
                    super(builder);
                    this.entity = builder.entity;
                    this.identifier = builder.identifier;
                    this.effectiveTime = builder.effectiveTime;
                    this.quantity = builder.quantity;
                    this.unitPrice = builder.unitPrice;
                    this.factor = builder.factor;
                    this.points = builder.points;
                    this.net = builder.net;
                    this.payment = builder.payment;
                    this.paymentDate = builder.paymentDate;
                    this.responsible = builder.responsible;
                    this.recipient = builder.recipient;
                    this.linkId = Collections.unmodifiableList(builder.linkId);
                    this.securityLabelNumber = Collections.unmodifiableList(builder.securityLabelNumber);
                }

                public Element getEntity() {
                    return this.entity;
                }

                public Identifier getIdentifier() {
                    return this.identifier;
                }

                public DateTime getEffectiveTime() {
                    return this.effectiveTime;
                }

                public SimpleQuantity getQuantity() {
                    return this.quantity;
                }

                public Money getUnitPrice() {
                    return this.unitPrice;
                }

                public Decimal getFactor() {
                    return this.factor;
                }

                public Decimal getPoints() {
                    return this.points;
                }

                public Money getNet() {
                    return this.net;
                }

                public String getPayment() {
                    return this.payment;
                }

                public DateTime getPaymentDate() {
                    return this.paymentDate;
                }

                public Reference getResponsible() {
                    return this.responsible;
                }

                public Reference getRecipient() {
                    return this.recipient;
                }

                public List<String> getLinkId() {
                    return this.linkId;
                }

                public List<UnsignedInt> getSecurityLabelNumber() {
                    return this.securityLabelNumber;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.entity != null || this.identifier != null || this.effectiveTime != null || this.quantity != null || this.unitPrice != null || this.factor != null || this.points != null || this.net != null || this.payment != null || this.paymentDate != null || this.responsible != null || this.recipient != null || !this.linkId.isEmpty() || !this.securityLabelNumber.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.entity, "entity", visitor);
                            this.accept(this.identifier, "identifier", visitor);
                            this.accept(this.effectiveTime, "effectiveTime", visitor);
                            this.accept(this.quantity, "quantity", visitor);
                            this.accept(this.unitPrice, "unitPrice", visitor);
                            this.accept(this.factor, "factor", visitor);
                            this.accept(this.points, "points", visitor);
                            this.accept(this.net, "net", visitor);
                            this.accept(this.payment, "payment", visitor);
                            this.accept(this.paymentDate, "paymentDate", visitor);
                            this.accept(this.responsible, "responsible", visitor);
                            this.accept(this.recipient, "recipient", visitor);
                            this.accept(this.linkId, "linkId", visitor, String.class);
                            this.accept(this.securityLabelNumber, "securityLabelNumber", visitor, UnsignedInt.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    ValuedItem other = (ValuedItem)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.entity, other.entity) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.effectiveTime, other.effectiveTime) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.factor, other.factor) && Objects.equals(this.points, other.points) && Objects.equals(this.net, other.net) && Objects.equals(this.payment, other.payment) && Objects.equals(this.paymentDate, other.paymentDate) && Objects.equals(this.responsible, other.responsible) && Objects.equals(this.recipient, other.recipient) && Objects.equals(this.linkId, other.linkId) && Objects.equals(this.securityLabelNumber, other.securityLabelNumber);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.entity, this.identifier, this.effectiveTime, this.quantity, this.unitPrice, this.factor, this.points, this.net, this.payment, this.paymentDate, this.responsible, this.recipient, this.linkId, this.securityLabelNumber);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Element entity;
                    private Identifier identifier;
                    private DateTime effectiveTime;
                    private SimpleQuantity quantity;
                    private Money unitPrice;
                    private Decimal factor;
                    private Decimal points;
                    private Money net;
                    private String payment;
                    private DateTime paymentDate;
                    private Reference responsible;
                    private Reference recipient;
                    private List<String> linkId = new ArrayList<String>();
                    private List<UnsignedInt> securityLabelNumber = new ArrayList<UnsignedInt>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder entity(Element entity) {
                        this.entity = entity;
                        return this;
                    }

                    public Builder identifier(Identifier identifier) {
                        this.identifier = identifier;
                        return this;
                    }

                    public Builder effectiveTime(DateTime effectiveTime) {
                        this.effectiveTime = effectiveTime;
                        return this;
                    }

                    public Builder quantity(SimpleQuantity quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder unitPrice(Money unitPrice) {
                        this.unitPrice = unitPrice;
                        return this;
                    }

                    public Builder factor(Decimal factor) {
                        this.factor = factor;
                        return this;
                    }

                    public Builder points(Decimal points) {
                        this.points = points;
                        return this;
                    }

                    public Builder net(Money net) {
                        this.net = net;
                        return this;
                    }

                    public Builder payment(java.lang.String payment) {
                        this.payment = payment == null ? null : String.of(payment);
                        return this;
                    }

                    public Builder payment(String payment) {
                        this.payment = payment;
                        return this;
                    }

                    public Builder paymentDate(DateTime paymentDate) {
                        this.paymentDate = paymentDate;
                        return this;
                    }

                    public Builder responsible(Reference responsible) {
                        this.responsible = responsible;
                        return this;
                    }

                    public Builder recipient(Reference recipient) {
                        this.recipient = recipient;
                        return this;
                    }

                    public Builder linkId(java.lang.String ... linkId) {
                        for (java.lang.String value : linkId) {
                            this.linkId.add(value == null ? null : String.of(value));
                        }
                        return this;
                    }

                    public Builder linkId(String ... linkId) {
                        for (String value : linkId) {
                            this.linkId.add(value);
                        }
                        return this;
                    }

                    public Builder linkId(Collection<String> linkId) {
                        this.linkId = new ArrayList<String>(linkId);
                        return this;
                    }

                    public Builder securityLabelNumber(UnsignedInt ... securityLabelNumber) {
                        for (UnsignedInt value : securityLabelNumber) {
                            this.securityLabelNumber.add(value);
                        }
                        return this;
                    }

                    public Builder securityLabelNumber(Collection<UnsignedInt> securityLabelNumber) {
                        this.securityLabelNumber = new ArrayList<UnsignedInt>(securityLabelNumber);
                        return this;
                    }

                    @Override
                    public ValuedItem build() {
                        ValuedItem valuedItem = new ValuedItem(this);
                        if (this.validating) {
                            this.validate(valuedItem);
                        }
                        return valuedItem;
                    }

                    protected void validate(ValuedItem valuedItem) {
                        super.validate(valuedItem);
                        ValidationSupport.choiceElement(valuedItem.entity, "entity", CodeableConcept.class, Reference.class);
                        ValidationSupport.checkList(valuedItem.linkId, "linkId", String.class);
                        ValidationSupport.checkList(valuedItem.securityLabelNumber, "securityLabelNumber", UnsignedInt.class);
                        ValidationSupport.checkReferenceType(valuedItem.responsible, "responsible", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
                        ValidationSupport.checkReferenceType(valuedItem.recipient, "recipient", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
                        ValidationSupport.requireValueOrChildren(valuedItem);
                    }

                    protected Builder from(ValuedItem valuedItem) {
                        super.from(valuedItem);
                        this.entity = valuedItem.entity;
                        this.identifier = valuedItem.identifier;
                        this.effectiveTime = valuedItem.effectiveTime;
                        this.quantity = valuedItem.quantity;
                        this.unitPrice = valuedItem.unitPrice;
                        this.factor = valuedItem.factor;
                        this.points = valuedItem.points;
                        this.net = valuedItem.net;
                        this.payment = valuedItem.payment;
                        this.paymentDate = valuedItem.paymentDate;
                        this.responsible = valuedItem.responsible;
                        this.recipient = valuedItem.recipient;
                        this.linkId.addAll(valuedItem.linkId);
                        this.securityLabelNumber.addAll(valuedItem.securityLabelNumber);
                        return this;
                    }
                }
            }

            public static class Context
            extends BackboneElement {
                private final Reference reference;
                @Binding(bindingName="ContractAssetContext", strength=BindingStrength.Value.EXAMPLE, description="Codes for the context of the asset.", valueSet="http://hl7.org/fhir/ValueSet/contract-assetcontext")
                private final List<CodeableConcept> code;
                private final String text;

                private Context(Builder builder) {
                    super(builder);
                    this.reference = builder.reference;
                    this.code = Collections.unmodifiableList(builder.code);
                    this.text = builder.text;
                }

                public Reference getReference() {
                    return this.reference;
                }

                public List<CodeableConcept> getCode() {
                    return this.code;
                }

                public String getText() {
                    return this.text;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.reference != null || !this.code.isEmpty() || this.text != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.reference, "reference", visitor);
                            this.accept(this.code, "code", visitor, CodeableConcept.class);
                            this.accept(this.text, "text", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Context other = (Context)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.code, other.code) && Objects.equals(this.text, other.text);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.reference, this.code, this.text);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Reference reference;
                    private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
                    private String text;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder reference(Reference reference) {
                        this.reference = reference;
                        return this;
                    }

                    public Builder code(CodeableConcept ... code) {
                        for (CodeableConcept value : code) {
                            this.code.add(value);
                        }
                        return this;
                    }

                    public Builder code(Collection<CodeableConcept> code) {
                        this.code = new ArrayList<CodeableConcept>(code);
                        return this;
                    }

                    public Builder text(java.lang.String text) {
                        this.text = text == null ? null : String.of(text);
                        return this;
                    }

                    public Builder text(String text) {
                        this.text = text;
                        return this;
                    }

                    @Override
                    public Context build() {
                        Context context = new Context(this);
                        if (this.validating) {
                            this.validate(context);
                        }
                        return context;
                    }

                    protected void validate(Context context) {
                        super.validate(context);
                        ValidationSupport.checkList(context.code, "code", CodeableConcept.class);
                        ValidationSupport.requireValueOrChildren(context);
                    }

                    protected Builder from(Context context) {
                        super.from(context);
                        this.reference = context.reference;
                        this.code.addAll(context.code);
                        this.text = context.text;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept scope;
                private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
                private List<Reference> typeReference = new ArrayList<Reference>();
                private List<CodeableConcept> subtype = new ArrayList<CodeableConcept>();
                private Coding relationship;
                private List<Context> context = new ArrayList<Context>();
                private String condition;
                private List<CodeableConcept> periodType = new ArrayList<CodeableConcept>();
                private List<Period> period = new ArrayList<Period>();
                private List<Period> usePeriod = new ArrayList<Period>();
                private String text;
                private List<String> linkId = new ArrayList<String>();
                private List<Offer.Answer> answer = new ArrayList<Offer.Answer>();
                private List<UnsignedInt> securityLabelNumber = new ArrayList<UnsignedInt>();
                private List<ValuedItem> valuedItem = new ArrayList<ValuedItem>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder scope(CodeableConcept scope) {
                    this.scope = scope;
                    return this;
                }

                public Builder type(CodeableConcept ... type) {
                    for (CodeableConcept value : type) {
                        this.type.add(value);
                    }
                    return this;
                }

                public Builder type(Collection<CodeableConcept> type) {
                    this.type = new ArrayList<CodeableConcept>(type);
                    return this;
                }

                public Builder typeReference(Reference ... typeReference) {
                    for (Reference value : typeReference) {
                        this.typeReference.add(value);
                    }
                    return this;
                }

                public Builder typeReference(Collection<Reference> typeReference) {
                    this.typeReference = new ArrayList<Reference>(typeReference);
                    return this;
                }

                public Builder subtype(CodeableConcept ... subtype) {
                    for (CodeableConcept value : subtype) {
                        this.subtype.add(value);
                    }
                    return this;
                }

                public Builder subtype(Collection<CodeableConcept> subtype) {
                    this.subtype = new ArrayList<CodeableConcept>(subtype);
                    return this;
                }

                public Builder relationship(Coding relationship) {
                    this.relationship = relationship;
                    return this;
                }

                public Builder context(Context ... context) {
                    for (Context value : context) {
                        this.context.add(value);
                    }
                    return this;
                }

                public Builder context(Collection<Context> context) {
                    this.context = new ArrayList<Context>(context);
                    return this;
                }

                public Builder condition(java.lang.String condition) {
                    this.condition = condition == null ? null : String.of(condition);
                    return this;
                }

                public Builder condition(String condition) {
                    this.condition = condition;
                    return this;
                }

                public Builder periodType(CodeableConcept ... periodType) {
                    for (CodeableConcept value : periodType) {
                        this.periodType.add(value);
                    }
                    return this;
                }

                public Builder periodType(Collection<CodeableConcept> periodType) {
                    this.periodType = new ArrayList<CodeableConcept>(periodType);
                    return this;
                }

                public Builder period(Period ... period) {
                    for (Period value : period) {
                        this.period.add(value);
                    }
                    return this;
                }

                public Builder period(Collection<Period> period) {
                    this.period = new ArrayList<Period>(period);
                    return this;
                }

                public Builder usePeriod(Period ... usePeriod) {
                    for (Period value : usePeriod) {
                        this.usePeriod.add(value);
                    }
                    return this;
                }

                public Builder usePeriod(Collection<Period> usePeriod) {
                    this.usePeriod = new ArrayList<Period>(usePeriod);
                    return this;
                }

                public Builder text(java.lang.String text) {
                    this.text = text == null ? null : String.of(text);
                    return this;
                }

                public Builder text(String text) {
                    this.text = text;
                    return this;
                }

                public Builder linkId(java.lang.String ... linkId) {
                    for (java.lang.String value : linkId) {
                        this.linkId.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder linkId(String ... linkId) {
                    for (String value : linkId) {
                        this.linkId.add(value);
                    }
                    return this;
                }

                public Builder linkId(Collection<String> linkId) {
                    this.linkId = new ArrayList<String>(linkId);
                    return this;
                }

                public Builder answer(Offer.Answer ... answer) {
                    for (Offer.Answer value : answer) {
                        this.answer.add(value);
                    }
                    return this;
                }

                public Builder answer(Collection<Offer.Answer> answer) {
                    this.answer = new ArrayList<Offer.Answer>(answer);
                    return this;
                }

                public Builder securityLabelNumber(UnsignedInt ... securityLabelNumber) {
                    for (UnsignedInt value : securityLabelNumber) {
                        this.securityLabelNumber.add(value);
                    }
                    return this;
                }

                public Builder securityLabelNumber(Collection<UnsignedInt> securityLabelNumber) {
                    this.securityLabelNumber = new ArrayList<UnsignedInt>(securityLabelNumber);
                    return this;
                }

                public Builder valuedItem(ValuedItem ... valuedItem) {
                    for (ValuedItem value : valuedItem) {
                        this.valuedItem.add(value);
                    }
                    return this;
                }

                public Builder valuedItem(Collection<ValuedItem> valuedItem) {
                    this.valuedItem = new ArrayList<ValuedItem>(valuedItem);
                    return this;
                }

                @Override
                public Asset build() {
                    Asset asset = new Asset(this);
                    if (this.validating) {
                        this.validate(asset);
                    }
                    return asset;
                }

                protected void validate(Asset asset) {
                    super.validate(asset);
                    ValidationSupport.checkList(asset.type, "type", CodeableConcept.class);
                    ValidationSupport.checkList(asset.typeReference, "typeReference", Reference.class);
                    ValidationSupport.checkList(asset.subtype, "subtype", CodeableConcept.class);
                    ValidationSupport.checkList(asset.context, "context", Context.class);
                    ValidationSupport.checkList(asset.periodType, "periodType", CodeableConcept.class);
                    ValidationSupport.checkList(asset.period, "period", Period.class);
                    ValidationSupport.checkList(asset.usePeriod, "usePeriod", Period.class);
                    ValidationSupport.checkList(asset.linkId, "linkId", String.class);
                    ValidationSupport.checkList(asset.answer, "answer", Offer.Answer.class);
                    ValidationSupport.checkList(asset.securityLabelNumber, "securityLabelNumber", UnsignedInt.class);
                    ValidationSupport.checkList(asset.valuedItem, "valuedItem", ValuedItem.class);
                    ValidationSupport.requireValueOrChildren(asset);
                }

                protected Builder from(Asset asset) {
                    super.from(asset);
                    this.scope = asset.scope;
                    this.type.addAll(asset.type);
                    this.typeReference.addAll(asset.typeReference);
                    this.subtype.addAll(asset.subtype);
                    this.relationship = asset.relationship;
                    this.context.addAll(asset.context);
                    this.condition = asset.condition;
                    this.periodType.addAll(asset.periodType);
                    this.period.addAll(asset.period);
                    this.usePeriod.addAll(asset.usePeriod);
                    this.text = asset.text;
                    this.linkId.addAll(asset.linkId);
                    this.answer.addAll(asset.answer);
                    this.securityLabelNumber.addAll(asset.securityLabelNumber);
                    this.valuedItem.addAll(asset.valuedItem);
                    return this;
                }
            }
        }

        public static class Offer
        extends BackboneElement {
            private final List<Identifier> identifier;
            private final List<Party> party;
            @Summary
            private final Reference topic;
            @Binding(bindingName="ContractTermType", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the types of contract provisions.", valueSet="http://hl7.org/fhir/ValueSet/contract-term-type")
            private final CodeableConcept type;
            @Binding(bindingName="ContractDecisionType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of decision made by a grantor with respect to an offer made by a grantee.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActConsentDirective")
            private final CodeableConcept decision;
            @Binding(bindingName="ContractDecisionMode", strength=BindingStrength.Value.EXAMPLE, description="Codes for conveying a decision.", valueSet="http://hl7.org/fhir/ValueSet/contract-decision-mode")
            private final List<CodeableConcept> decisionMode;
            private final List<Answer> answer;
            private final String text;
            private final List<String> linkId;
            private final List<UnsignedInt> securityLabelNumber;

            private Offer(Builder builder) {
                super(builder);
                this.identifier = Collections.unmodifiableList(builder.identifier);
                this.party = Collections.unmodifiableList(builder.party);
                this.topic = builder.topic;
                this.type = builder.type;
                this.decision = builder.decision;
                this.decisionMode = Collections.unmodifiableList(builder.decisionMode);
                this.answer = Collections.unmodifiableList(builder.answer);
                this.text = builder.text;
                this.linkId = Collections.unmodifiableList(builder.linkId);
                this.securityLabelNumber = Collections.unmodifiableList(builder.securityLabelNumber);
            }

            public List<Identifier> getIdentifier() {
                return this.identifier;
            }

            public List<Party> getParty() {
                return this.party;
            }

            public Reference getTopic() {
                return this.topic;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public CodeableConcept getDecision() {
                return this.decision;
            }

            public List<CodeableConcept> getDecisionMode() {
                return this.decisionMode;
            }

            public List<Answer> getAnswer() {
                return this.answer;
            }

            public String getText() {
                return this.text;
            }

            public List<String> getLinkId() {
                return this.linkId;
            }

            public List<UnsignedInt> getSecurityLabelNumber() {
                return this.securityLabelNumber;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || !this.identifier.isEmpty() || !this.party.isEmpty() || this.topic != null || this.type != null || this.decision != null || !this.decisionMode.isEmpty() || !this.answer.isEmpty() || this.text != null || !this.linkId.isEmpty() || !this.securityLabelNumber.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.identifier, "identifier", visitor, Identifier.class);
                        this.accept(this.party, "party", visitor, Party.class);
                        this.accept(this.topic, "topic", visitor);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.decision, "decision", visitor);
                        this.accept(this.decisionMode, "decisionMode", visitor, CodeableConcept.class);
                        this.accept(this.answer, "answer", visitor, Answer.class);
                        this.accept(this.text, "text", visitor);
                        this.accept(this.linkId, "linkId", visitor, String.class);
                        this.accept(this.securityLabelNumber, "securityLabelNumber", visitor, UnsignedInt.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Offer other = (Offer)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.party, other.party) && Objects.equals(this.topic, other.topic) && Objects.equals(this.type, other.type) && Objects.equals(this.decision, other.decision) && Objects.equals(this.decisionMode, other.decisionMode) && Objects.equals(this.answer, other.answer) && Objects.equals(this.text, other.text) && Objects.equals(this.linkId, other.linkId) && Objects.equals(this.securityLabelNumber, other.securityLabelNumber);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.party, this.topic, this.type, this.decision, this.decisionMode, this.answer, this.text, this.linkId, this.securityLabelNumber);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Answer
            extends BackboneElement {
                @Choice(value={Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class})
                @Required
                private final Element value;

                private Answer(Builder builder) {
                    super(builder);
                    this.value = builder.value;
                }

                public Element getValue() {
                    return this.value;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.value != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.value, "value", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Answer other = (Answer)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Element value;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder value(java.lang.Boolean value) {
                        this.value = value == null ? null : Boolean.of(value);
                        return this;
                    }

                    public Builder value(java.lang.Integer value) {
                        this.value = value == null ? null : Integer.of(value);
                        return this;
                    }

                    public Builder value(LocalDate value) {
                        this.value = value == null ? null : Date.of(value);
                        return this;
                    }

                    public Builder value(LocalTime value) {
                        this.value = value == null ? null : Time.of(value);
                        return this;
                    }

                    public Builder value(java.lang.String value) {
                        this.value = value == null ? null : String.of(value);
                        return this;
                    }

                    public Builder value(Element value) {
                        this.value = value;
                        return this;
                    }

                    @Override
                    public Answer build() {
                        Answer answer = new Answer(this);
                        if (this.validating) {
                            this.validate(answer);
                        }
                        return answer;
                    }

                    protected void validate(Answer answer) {
                        super.validate(answer);
                        ValidationSupport.requireChoiceElement(answer.value, "value", Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class);
                        ValidationSupport.requireValueOrChildren(answer);
                    }

                    protected Builder from(Answer answer) {
                        super.from(answer);
                        this.value = answer.value;
                        return this;
                    }
                }
            }

            public static class Party
            extends BackboneElement {
                @ReferenceTarget(value={"Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Device", "Group", "Organization"})
                @Required
                private final List<Reference> reference;
                @Binding(bindingName="ContractPartyRole", strength=BindingStrength.Value.EXAMPLE, description="Codes for offer participant roles.", valueSet="http://hl7.org/fhir/ValueSet/contract-party-role")
                @Required
                private final CodeableConcept role;

                private Party(Builder builder) {
                    super(builder);
                    this.reference = Collections.unmodifiableList(builder.reference);
                    this.role = builder.role;
                }

                public List<Reference> getReference() {
                    return this.reference;
                }

                public CodeableConcept getRole() {
                    return this.role;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || !this.reference.isEmpty() || this.role != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.reference, "reference", visitor, Reference.class);
                            this.accept(this.role, "role", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Party other = (Party)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.role, other.role);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.reference, this.role);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private List<Reference> reference = new ArrayList<Reference>();
                    private CodeableConcept role;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder reference(Reference ... reference) {
                        for (Reference value : reference) {
                            this.reference.add(value);
                        }
                        return this;
                    }

                    public Builder reference(Collection<Reference> reference) {
                        this.reference = new ArrayList<Reference>(reference);
                        return this;
                    }

                    public Builder role(CodeableConcept role) {
                        this.role = role;
                        return this;
                    }

                    @Override
                    public Party build() {
                        Party party = new Party(this);
                        if (this.validating) {
                            this.validate(party);
                        }
                        return party;
                    }

                    protected void validate(Party party) {
                        super.validate(party);
                        ValidationSupport.checkNonEmptyList(party.reference, "reference", Reference.class);
                        ValidationSupport.requireNonNull(party.role, "role");
                        ValidationSupport.checkReferenceType(party.reference, "reference", "Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Device", "Group", "Organization");
                        ValidationSupport.requireValueOrChildren(party);
                    }

                    protected Builder from(Party party) {
                        super.from(party);
                        this.reference.addAll(party.reference);
                        this.role = party.role;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private List<Identifier> identifier = new ArrayList<Identifier>();
                private List<Party> party = new ArrayList<Party>();
                private Reference topic;
                private CodeableConcept type;
                private CodeableConcept decision;
                private List<CodeableConcept> decisionMode = new ArrayList<CodeableConcept>();
                private List<Answer> answer = new ArrayList<Answer>();
                private String text;
                private List<String> linkId = new ArrayList<String>();
                private List<UnsignedInt> securityLabelNumber = new ArrayList<UnsignedInt>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder identifier(Identifier ... identifier) {
                    for (Identifier value : identifier) {
                        this.identifier.add(value);
                    }
                    return this;
                }

                public Builder identifier(Collection<Identifier> identifier) {
                    this.identifier = new ArrayList<Identifier>(identifier);
                    return this;
                }

                public Builder party(Party ... party) {
                    for (Party value : party) {
                        this.party.add(value);
                    }
                    return this;
                }

                public Builder party(Collection<Party> party) {
                    this.party = new ArrayList<Party>(party);
                    return this;
                }

                public Builder topic(Reference topic) {
                    this.topic = topic;
                    return this;
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder decision(CodeableConcept decision) {
                    this.decision = decision;
                    return this;
                }

                public Builder decisionMode(CodeableConcept ... decisionMode) {
                    for (CodeableConcept value : decisionMode) {
                        this.decisionMode.add(value);
                    }
                    return this;
                }

                public Builder decisionMode(Collection<CodeableConcept> decisionMode) {
                    this.decisionMode = new ArrayList<CodeableConcept>(decisionMode);
                    return this;
                }

                public Builder answer(Answer ... answer) {
                    for (Answer value : answer) {
                        this.answer.add(value);
                    }
                    return this;
                }

                public Builder answer(Collection<Answer> answer) {
                    this.answer = new ArrayList<Answer>(answer);
                    return this;
                }

                public Builder text(java.lang.String text) {
                    this.text = text == null ? null : String.of(text);
                    return this;
                }

                public Builder text(String text) {
                    this.text = text;
                    return this;
                }

                public Builder linkId(java.lang.String ... linkId) {
                    for (java.lang.String value : linkId) {
                        this.linkId.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder linkId(String ... linkId) {
                    for (String value : linkId) {
                        this.linkId.add(value);
                    }
                    return this;
                }

                public Builder linkId(Collection<String> linkId) {
                    this.linkId = new ArrayList<String>(linkId);
                    return this;
                }

                public Builder securityLabelNumber(UnsignedInt ... securityLabelNumber) {
                    for (UnsignedInt value : securityLabelNumber) {
                        this.securityLabelNumber.add(value);
                    }
                    return this;
                }

                public Builder securityLabelNumber(Collection<UnsignedInt> securityLabelNumber) {
                    this.securityLabelNumber = new ArrayList<UnsignedInt>(securityLabelNumber);
                    return this;
                }

                @Override
                public Offer build() {
                    Offer offer = new Offer(this);
                    if (this.validating) {
                        this.validate(offer);
                    }
                    return offer;
                }

                protected void validate(Offer offer) {
                    super.validate(offer);
                    ValidationSupport.checkList(offer.identifier, "identifier", Identifier.class);
                    ValidationSupport.checkList(offer.party, "party", Party.class);
                    ValidationSupport.checkList(offer.decisionMode, "decisionMode", CodeableConcept.class);
                    ValidationSupport.checkList(offer.answer, "answer", Answer.class);
                    ValidationSupport.checkList(offer.linkId, "linkId", String.class);
                    ValidationSupport.checkList(offer.securityLabelNumber, "securityLabelNumber", UnsignedInt.class);
                    ValidationSupport.requireValueOrChildren(offer);
                }

                protected Builder from(Offer offer) {
                    super.from(offer);
                    this.identifier.addAll(offer.identifier);
                    this.party.addAll(offer.party);
                    this.topic = offer.topic;
                    this.type = offer.type;
                    this.decision = offer.decision;
                    this.decisionMode.addAll(offer.decisionMode);
                    this.answer.addAll(offer.answer);
                    this.text = offer.text;
                    this.linkId.addAll(offer.linkId);
                    this.securityLabelNumber.addAll(offer.securityLabelNumber);
                    return this;
                }
            }
        }

        public static class SecurityLabel
        extends BackboneElement {
            private final List<UnsignedInt> number;
            @Binding(bindingName="ContractSecurityClassification", strength=BindingStrength.Value.EXAMPLE, description="Codes for confidentiality protection.", valueSet="http://hl7.org/fhir/ValueSet/contract-security-classification")
            @Required
            private final Coding classification;
            @Binding(bindingName="ContractSecurityCategory", strength=BindingStrength.Value.EXAMPLE, description="Codes for policy category.", valueSet="http://hl7.org/fhir/ValueSet/contract-security-category")
            private final List<Coding> category;
            @Binding(bindingName="ContractSecurityControl", strength=BindingStrength.Value.EXAMPLE, description="Codes for handling instructions.", valueSet="http://hl7.org/fhir/ValueSet/contract-security-control")
            private final List<Coding> control;

            private SecurityLabel(Builder builder) {
                super(builder);
                this.number = Collections.unmodifiableList(builder.number);
                this.classification = builder.classification;
                this.category = Collections.unmodifiableList(builder.category);
                this.control = Collections.unmodifiableList(builder.control);
            }

            public List<UnsignedInt> getNumber() {
                return this.number;
            }

            public Coding getClassification() {
                return this.classification;
            }

            public List<Coding> getCategory() {
                return this.category;
            }

            public List<Coding> getControl() {
                return this.control;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || !this.number.isEmpty() || this.classification != null || !this.category.isEmpty() || !this.control.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.number, "number", visitor, UnsignedInt.class);
                        this.accept(this.classification, "classification", visitor);
                        this.accept(this.category, "category", visitor, Coding.class);
                        this.accept(this.control, "control", visitor, Coding.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SecurityLabel other = (SecurityLabel)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.number, other.number) && Objects.equals(this.classification, other.classification) && Objects.equals(this.category, other.category) && Objects.equals(this.control, other.control);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.number, this.classification, this.category, this.control);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private List<UnsignedInt> number = new ArrayList<UnsignedInt>();
                private Coding classification;
                private List<Coding> category = new ArrayList<Coding>();
                private List<Coding> control = new ArrayList<Coding>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder number(UnsignedInt ... number) {
                    for (UnsignedInt value : number) {
                        this.number.add(value);
                    }
                    return this;
                }

                public Builder number(Collection<UnsignedInt> number) {
                    this.number = new ArrayList<UnsignedInt>(number);
                    return this;
                }

                public Builder classification(Coding classification) {
                    this.classification = classification;
                    return this;
                }

                public Builder category(Coding ... category) {
                    for (Coding value : category) {
                        this.category.add(value);
                    }
                    return this;
                }

                public Builder category(Collection<Coding> category) {
                    this.category = new ArrayList<Coding>(category);
                    return this;
                }

                public Builder control(Coding ... control) {
                    for (Coding value : control) {
                        this.control.add(value);
                    }
                    return this;
                }

                public Builder control(Collection<Coding> control) {
                    this.control = new ArrayList<Coding>(control);
                    return this;
                }

                @Override
                public SecurityLabel build() {
                    SecurityLabel securityLabel = new SecurityLabel(this);
                    if (this.validating) {
                        this.validate(securityLabel);
                    }
                    return securityLabel;
                }

                protected void validate(SecurityLabel securityLabel) {
                    super.validate(securityLabel);
                    ValidationSupport.checkList(securityLabel.number, "number", UnsignedInt.class);
                    ValidationSupport.requireNonNull(securityLabel.classification, "classification");
                    ValidationSupport.checkList(securityLabel.category, "category", Coding.class);
                    ValidationSupport.checkList(securityLabel.control, "control", Coding.class);
                    ValidationSupport.requireValueOrChildren(securityLabel);
                }

                protected Builder from(SecurityLabel securityLabel) {
                    super.from(securityLabel);
                    this.number.addAll(securityLabel.number);
                    this.classification = securityLabel.classification;
                    this.category.addAll(securityLabel.category);
                    this.control.addAll(securityLabel.control);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier identifier;
            private DateTime issued;
            private Period applies;
            private Element topic;
            private CodeableConcept type;
            private CodeableConcept subType;
            private String text;
            private List<SecurityLabel> securityLabel = new ArrayList<SecurityLabel>();
            private Offer offer;
            private List<Asset> asset = new ArrayList<Asset>();
            private List<Action> action = new ArrayList<Action>();
            private List<Term> group = new ArrayList<Term>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder issued(DateTime issued) {
                this.issued = issued;
                return this;
            }

            public Builder applies(Period applies) {
                this.applies = applies;
                return this;
            }

            public Builder topic(Element topic) {
                this.topic = topic;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder subType(CodeableConcept subType) {
                this.subType = subType;
                return this;
            }

            public Builder text(java.lang.String text) {
                this.text = text == null ? null : String.of(text);
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder securityLabel(SecurityLabel ... securityLabel) {
                for (SecurityLabel value : securityLabel) {
                    this.securityLabel.add(value);
                }
                return this;
            }

            public Builder securityLabel(Collection<SecurityLabel> securityLabel) {
                this.securityLabel = new ArrayList<SecurityLabel>(securityLabel);
                return this;
            }

            public Builder offer(Offer offer) {
                this.offer = offer;
                return this;
            }

            public Builder asset(Asset ... asset) {
                for (Asset value : asset) {
                    this.asset.add(value);
                }
                return this;
            }

            public Builder asset(Collection<Asset> asset) {
                this.asset = new ArrayList<Asset>(asset);
                return this;
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            public Builder group(Term ... group) {
                for (Term value : group) {
                    this.group.add(value);
                }
                return this;
            }

            public Builder group(Collection<Term> group) {
                this.group = new ArrayList<Term>(group);
                return this;
            }

            @Override
            public Term build() {
                Term term = new Term(this);
                if (this.validating) {
                    this.validate(term);
                }
                return term;
            }

            protected void validate(Term term) {
                super.validate(term);
                ValidationSupport.choiceElement(term.topic, "topic", CodeableConcept.class, Reference.class);
                ValidationSupport.checkList(term.securityLabel, "securityLabel", SecurityLabel.class);
                ValidationSupport.requireNonNull(term.offer, "offer");
                ValidationSupport.checkList(term.asset, "asset", Asset.class);
                ValidationSupport.checkList(term.action, "action", Action.class);
                ValidationSupport.checkList(term.group, "group", Term.class);
                ValidationSupport.requireValueOrChildren(term);
            }

            protected Builder from(Term term) {
                super.from(term);
                this.identifier = term.identifier;
                this.issued = term.issued;
                this.applies = term.applies;
                this.topic = term.topic;
                this.type = term.type;
                this.subType = term.subType;
                this.text = term.text;
                this.securityLabel.addAll(term.securityLabel);
                this.offer = term.offer;
                this.asset.addAll(term.asset);
                this.action.addAll(term.action);
                this.group.addAll(term.group);
                return this;
            }
        }
    }

    public static class ContentDefinition
    extends BackboneElement {
        @Binding(bindingName="ContractDefinitionType", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the definition of contracts.", valueSet="http://hl7.org/fhir/ValueSet/contract-definition-type")
        @Required
        private final CodeableConcept type;
        @Binding(bindingName="ContractDefinitionSubtype", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the additional definition of contracts.", valueSet="http://hl7.org/fhir/ValueSet/contract-definition-subtype")
        private final CodeableConcept subType;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        private final Reference publisher;
        private final DateTime publicationDate;
        @Binding(bindingName="ContractPublicationStatus", strength=BindingStrength.Value.REQUIRED, description="Status of the publication of contract content.", valueSet="http://hl7.org/fhir/ValueSet/contract-publicationstatus|4.0.1")
        @Required
        private final ContractPublicationStatus publicationStatus;
        private final Markdown copyright;

        private ContentDefinition(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.subType = builder.subType;
            this.publisher = builder.publisher;
            this.publicationDate = builder.publicationDate;
            this.publicationStatus = builder.publicationStatus;
            this.copyright = builder.copyright;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getSubType() {
            return this.subType;
        }

        public Reference getPublisher() {
            return this.publisher;
        }

        public DateTime getPublicationDate() {
            return this.publicationDate;
        }

        public ContractPublicationStatus getPublicationStatus() {
            return this.publicationStatus;
        }

        public Markdown getCopyright() {
            return this.copyright;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.subType != null || this.publisher != null || this.publicationDate != null || this.publicationStatus != null || this.copyright != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.subType, "subType", visitor);
                    this.accept(this.publisher, "publisher", visitor);
                    this.accept(this.publicationDate, "publicationDate", visitor);
                    this.accept(this.publicationStatus, "publicationStatus", visitor);
                    this.accept(this.copyright, "copyright", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContentDefinition other = (ContentDefinition)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.subType, other.subType) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.publicationDate, other.publicationDate) && Objects.equals(this.publicationStatus, other.publicationStatus) && Objects.equals(this.copyright, other.copyright);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.subType, this.publisher, this.publicationDate, this.publicationStatus, this.copyright);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private CodeableConcept subType;
            private Reference publisher;
            private DateTime publicationDate;
            private ContractPublicationStatus publicationStatus;
            private Markdown copyright;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder subType(CodeableConcept subType) {
                this.subType = subType;
                return this;
            }

            public Builder publisher(Reference publisher) {
                this.publisher = publisher;
                return this;
            }

            public Builder publicationDate(DateTime publicationDate) {
                this.publicationDate = publicationDate;
                return this;
            }

            public Builder publicationStatus(ContractPublicationStatus publicationStatus) {
                this.publicationStatus = publicationStatus;
                return this;
            }

            public Builder copyright(Markdown copyright) {
                this.copyright = copyright;
                return this;
            }

            @Override
            public ContentDefinition build() {
                ContentDefinition contentDefinition = new ContentDefinition(this);
                if (this.validating) {
                    this.validate(contentDefinition);
                }
                return contentDefinition;
            }

            protected void validate(ContentDefinition contentDefinition) {
                super.validate(contentDefinition);
                ValidationSupport.requireNonNull(contentDefinition.type, "type");
                ValidationSupport.requireNonNull(contentDefinition.publicationStatus, "publicationStatus");
                ValidationSupport.checkReferenceType(contentDefinition.publisher, "publisher", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.requireValueOrChildren(contentDefinition);
            }

            protected Builder from(ContentDefinition contentDefinition) {
                super.from(contentDefinition);
                this.type = contentDefinition.type;
                this.subType = contentDefinition.subType;
                this.publisher = contentDefinition.publisher;
                this.publicationDate = contentDefinition.publicationDate;
                this.publicationStatus = contentDefinition.publicationStatus;
                this.copyright = contentDefinition.copyright;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Uri url;
        private String version;
        private ContractStatus status;
        private CodeableConcept legalState;
        private Reference instantiatesCanonical;
        private Uri instantiatesUri;
        private CodeableConcept contentDerivative;
        private DateTime issued;
        private Period applies;
        private CodeableConcept expirationType;
        private List<Reference> subject = new ArrayList<Reference>();
        private List<Reference> authority = new ArrayList<Reference>();
        private List<Reference> domain = new ArrayList<Reference>();
        private List<Reference> site = new ArrayList<Reference>();
        private String name;
        private String title;
        private String subtitle;
        private List<String> alias = new ArrayList<String>();
        private Reference author;
        private CodeableConcept scope;
        private Element topic;
        private CodeableConcept type;
        private List<CodeableConcept> subType = new ArrayList<CodeableConcept>();
        private ContentDefinition contentDefinition;
        private List<Term> term = new ArrayList<Term>();
        private List<Reference> supportingInfo = new ArrayList<Reference>();
        private List<Reference> relevantHistory = new ArrayList<Reference>();
        private List<Signer> signer = new ArrayList<Signer>();
        private List<Friendly> friendly = new ArrayList<Friendly>();
        private List<Legal> legal = new ArrayList<Legal>();
        private List<Rule> rule = new ArrayList<Rule>();
        private Element legallyBinding;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder status(ContractStatus status) {
            this.status = status;
            return this;
        }

        public Builder legalState(CodeableConcept legalState) {
            this.legalState = legalState;
            return this;
        }

        public Builder instantiatesCanonical(Reference instantiatesCanonical) {
            this.instantiatesCanonical = instantiatesCanonical;
            return this;
        }

        public Builder instantiatesUri(Uri instantiatesUri) {
            this.instantiatesUri = instantiatesUri;
            return this;
        }

        public Builder contentDerivative(CodeableConcept contentDerivative) {
            this.contentDerivative = contentDerivative;
            return this;
        }

        public Builder issued(DateTime issued) {
            this.issued = issued;
            return this;
        }

        public Builder applies(Period applies) {
            this.applies = applies;
            return this;
        }

        public Builder expirationType(CodeableConcept expirationType) {
            this.expirationType = expirationType;
            return this;
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder authority(Reference ... authority) {
            for (Reference value : authority) {
                this.authority.add(value);
            }
            return this;
        }

        public Builder authority(Collection<Reference> authority) {
            this.authority = new ArrayList<Reference>(authority);
            return this;
        }

        public Builder domain(Reference ... domain) {
            for (Reference value : domain) {
                this.domain.add(value);
            }
            return this;
        }

        public Builder domain(Collection<Reference> domain) {
            this.domain = new ArrayList<Reference>(domain);
            return this;
        }

        public Builder site(Reference ... site) {
            for (Reference value : site) {
                this.site.add(value);
            }
            return this;
        }

        public Builder site(Collection<Reference> site) {
            this.site = new ArrayList<Reference>(site);
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(java.lang.String subtitle) {
            this.subtitle = subtitle == null ? null : String.of(subtitle);
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder alias(java.lang.String ... alias) {
            for (java.lang.String value : alias) {
                this.alias.add(value == null ? null : String.of(value));
            }
            return this;
        }

        public Builder alias(String ... alias) {
            for (String value : alias) {
                this.alias.add(value);
            }
            return this;
        }

        public Builder alias(Collection<String> alias) {
            this.alias = new ArrayList<String>(alias);
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        public Builder scope(CodeableConcept scope) {
            this.scope = scope;
            return this;
        }

        public Builder topic(Element topic) {
            this.topic = topic;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder subType(CodeableConcept ... subType) {
            for (CodeableConcept value : subType) {
                this.subType.add(value);
            }
            return this;
        }

        public Builder subType(Collection<CodeableConcept> subType) {
            this.subType = new ArrayList<CodeableConcept>(subType);
            return this;
        }

        public Builder contentDefinition(ContentDefinition contentDefinition) {
            this.contentDefinition = contentDefinition;
            return this;
        }

        public Builder term(Term ... term) {
            for (Term value : term) {
                this.term.add(value);
            }
            return this;
        }

        public Builder term(Collection<Term> term) {
            this.term = new ArrayList<Term>(term);
            return this;
        }

        public Builder supportingInfo(Reference ... supportingInfo) {
            for (Reference value : supportingInfo) {
                this.supportingInfo.add(value);
            }
            return this;
        }

        public Builder supportingInfo(Collection<Reference> supportingInfo) {
            this.supportingInfo = new ArrayList<Reference>(supportingInfo);
            return this;
        }

        public Builder relevantHistory(Reference ... relevantHistory) {
            for (Reference value : relevantHistory) {
                this.relevantHistory.add(value);
            }
            return this;
        }

        public Builder relevantHistory(Collection<Reference> relevantHistory) {
            this.relevantHistory = new ArrayList<Reference>(relevantHistory);
            return this;
        }

        public Builder signer(Signer ... signer) {
            for (Signer value : signer) {
                this.signer.add(value);
            }
            return this;
        }

        public Builder signer(Collection<Signer> signer) {
            this.signer = new ArrayList<Signer>(signer);
            return this;
        }

        public Builder friendly(Friendly ... friendly) {
            for (Friendly value : friendly) {
                this.friendly.add(value);
            }
            return this;
        }

        public Builder friendly(Collection<Friendly> friendly) {
            this.friendly = new ArrayList<Friendly>(friendly);
            return this;
        }

        public Builder legal(Legal ... legal) {
            for (Legal value : legal) {
                this.legal.add(value);
            }
            return this;
        }

        public Builder legal(Collection<Legal> legal) {
            this.legal = new ArrayList<Legal>(legal);
            return this;
        }

        public Builder rule(Rule ... rule) {
            for (Rule value : rule) {
                this.rule.add(value);
            }
            return this;
        }

        public Builder rule(Collection<Rule> rule) {
            this.rule = new ArrayList<Rule>(rule);
            return this;
        }

        public Builder legallyBinding(Element legallyBinding) {
            this.legallyBinding = legallyBinding;
            return this;
        }

        @Override
        public Contract build() {
            Contract contract = new Contract(this);
            if (this.validating) {
                this.validate(contract);
            }
            return contract;
        }

        protected void validate(Contract contract) {
            super.validate(contract);
            ValidationSupport.checkList(contract.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(contract.subject, "subject", Reference.class);
            ValidationSupport.checkList(contract.authority, "authority", Reference.class);
            ValidationSupport.checkList(contract.domain, "domain", Reference.class);
            ValidationSupport.checkList(contract.site, "site", Reference.class);
            ValidationSupport.checkList(contract.alias, "alias", String.class);
            ValidationSupport.choiceElement(contract.topic, "topic", CodeableConcept.class, Reference.class);
            ValidationSupport.checkList(contract.subType, "subType", CodeableConcept.class);
            ValidationSupport.checkList(contract.term, "term", Term.class);
            ValidationSupport.checkList(contract.supportingInfo, "supportingInfo", Reference.class);
            ValidationSupport.checkList(contract.relevantHistory, "relevantHistory", Reference.class);
            ValidationSupport.checkList(contract.signer, "signer", Signer.class);
            ValidationSupport.checkList(contract.friendly, "friendly", Friendly.class);
            ValidationSupport.checkList(contract.legal, "legal", Legal.class);
            ValidationSupport.checkList(contract.rule, "rule", Rule.class);
            ValidationSupport.choiceElement(contract.legallyBinding, "legallyBinding", Attachment.class, Reference.class);
            ValidationSupport.checkReferenceType(contract.instantiatesCanonical, "instantiatesCanonical", "Contract");
            ValidationSupport.checkReferenceType(contract.authority, "authority", "Organization");
            ValidationSupport.checkReferenceType(contract.domain, "domain", "Location");
            ValidationSupport.checkReferenceType(contract.site, "site", "Location");
            ValidationSupport.checkReferenceType(contract.author, "author", "Patient", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(contract.relevantHistory, "relevantHistory", "Provenance");
            ValidationSupport.checkReferenceType(contract.legallyBinding, "legallyBinding", "Composition", "DocumentReference", "QuestionnaireResponse", "Contract");
        }

        protected Builder from(Contract contract) {
            super.from(contract);
            this.identifier.addAll(contract.identifier);
            this.url = contract.url;
            this.version = contract.version;
            this.status = contract.status;
            this.legalState = contract.legalState;
            this.instantiatesCanonical = contract.instantiatesCanonical;
            this.instantiatesUri = contract.instantiatesUri;
            this.contentDerivative = contract.contentDerivative;
            this.issued = contract.issued;
            this.applies = contract.applies;
            this.expirationType = contract.expirationType;
            this.subject.addAll(contract.subject);
            this.authority.addAll(contract.authority);
            this.domain.addAll(contract.domain);
            this.site.addAll(contract.site);
            this.name = contract.name;
            this.title = contract.title;
            this.subtitle = contract.subtitle;
            this.alias.addAll(contract.alias);
            this.author = contract.author;
            this.scope = contract.scope;
            this.topic = contract.topic;
            this.type = contract.type;
            this.subType.addAll(contract.subType);
            this.contentDefinition = contract.contentDefinition;
            this.term.addAll(contract.term);
            this.supportingInfo.addAll(contract.supportingInfo);
            this.relevantHistory.addAll(contract.relevantHistory);
            this.signer.addAll(contract.signer);
            this.friendly.addAll(contract.friendly);
            this.legal.addAll(contract.legal);
            this.rule.addAll(contract.rule);
            this.legallyBinding = contract.legallyBinding;
            return this;
        }
    }
}

