/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CoverageStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="coverage-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/coverage-type", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/coverage-type', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Coverage", generated=true), @Constraint(id="coverage-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subscriber-relationship", expression="relationship.exists() implies (relationship.memberOf('http://hl7.org/fhir/ValueSet/subscriber-relationship', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Coverage", generated=true), @Constraint(id="coverage-2", level="Warning", location="class.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/coverage-class", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/coverage-class', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Coverage", generated=true), @Constraint(id="coverage-3", level="Warning", location="costToBeneficiary.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/coverage-copay-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/coverage-copay-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Coverage", generated=true)})
public class Coverage
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="CoverageStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    @Required
    private final CoverageStatus status;
    @Summary
    @Binding(bindingName="CoverageType", strength=BindingStrength.Value.PREFERRED, description="The type of insurance: public health, worker compensation; private accident, auto, private health, etc.) or a direct payment by an individual or organization.", valueSet="http://hl7.org/fhir/ValueSet/coverage-type")
    private final CodeableConcept type;
    @Summary
    @ReferenceTarget(value={"Patient", "RelatedPerson", "Organization"})
    private final Reference policyHolder;
    @Summary
    @ReferenceTarget(value={"Patient", "RelatedPerson"})
    private final Reference subscriber;
    @Summary
    private final String subscriberId;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference beneficiary;
    @Summary
    private final String dependent;
    @Binding(bindingName="Relationship", strength=BindingStrength.Value.EXTENSIBLE, description="The relationship between the Subscriber and the Beneficiary (insured/covered party/patient).", valueSet="http://hl7.org/fhir/ValueSet/subscriber-relationship")
    private final CodeableConcept relationship;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Organization", "Patient", "RelatedPerson"})
    @Required
    private final List<Reference> payor;
    private final List<Class> clazz;
    @Summary
    private final PositiveInt order;
    @Summary
    private final String network;
    private final List<CostToBeneficiary> costToBeneficiary;
    private final Boolean subrogation;
    @ReferenceTarget(value={"Contract"})
    private final List<Reference> contract;

    private Coverage(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.type = builder.type;
        this.policyHolder = builder.policyHolder;
        this.subscriber = builder.subscriber;
        this.subscriberId = builder.subscriberId;
        this.beneficiary = builder.beneficiary;
        this.dependent = builder.dependent;
        this.relationship = builder.relationship;
        this.period = builder.period;
        this.payor = Collections.unmodifiableList(builder.payor);
        this.clazz = Collections.unmodifiableList(builder.clazz);
        this.order = builder.order;
        this.network = builder.network;
        this.costToBeneficiary = Collections.unmodifiableList(builder.costToBeneficiary);
        this.subrogation = builder.subrogation;
        this.contract = Collections.unmodifiableList(builder.contract);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CoverageStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Reference getPolicyHolder() {
        return this.policyHolder;
    }

    public Reference getSubscriber() {
        return this.subscriber;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public Reference getBeneficiary() {
        return this.beneficiary;
    }

    public String getDependent() {
        return this.dependent;
    }

    public CodeableConcept getRelationship() {
        return this.relationship;
    }

    public Period getPeriod() {
        return this.period;
    }

    public List<Reference> getPayor() {
        return this.payor;
    }

    public List<Class> getClazz() {
        return this.clazz;
    }

    public PositiveInt getOrder() {
        return this.order;
    }

    public String getNetwork() {
        return this.network;
    }

    public List<CostToBeneficiary> getCostToBeneficiary() {
        return this.costToBeneficiary;
    }

    public Boolean getSubrogation() {
        return this.subrogation;
    }

    public List<Reference> getContract() {
        return this.contract;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.type != null || this.policyHolder != null || this.subscriber != null || this.subscriberId != null || this.beneficiary != null || this.dependent != null || this.relationship != null || this.period != null || !this.payor.isEmpty() || !this.clazz.isEmpty() || this.order != null || this.network != null || !this.costToBeneficiary.isEmpty() || this.subrogation != null || !this.contract.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.policyHolder, "policyHolder", visitor);
                this.accept(this.subscriber, "subscriber", visitor);
                this.accept(this.subscriberId, "subscriberId", visitor);
                this.accept(this.beneficiary, "beneficiary", visitor);
                this.accept(this.dependent, "dependent", visitor);
                this.accept(this.relationship, "relationship", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.payor, "payor", visitor, Reference.class);
                this.accept(this.clazz, "class", visitor, Class.class);
                this.accept(this.order, "order", visitor);
                this.accept(this.network, "network", visitor);
                this.accept(this.costToBeneficiary, "costToBeneficiary", visitor, CostToBeneficiary.class);
                this.accept(this.subrogation, "subrogation", visitor);
                this.accept(this.contract, "contract", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coverage other = (Coverage)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.policyHolder, other.policyHolder) && Objects.equals(this.subscriber, other.subscriber) && Objects.equals(this.subscriberId, other.subscriberId) && Objects.equals(this.beneficiary, other.beneficiary) && Objects.equals(this.dependent, other.dependent) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.period, other.period) && Objects.equals(this.payor, other.payor) && Objects.equals(this.clazz, other.clazz) && Objects.equals(this.order, other.order) && Objects.equals(this.network, other.network) && Objects.equals(this.costToBeneficiary, other.costToBeneficiary) && Objects.equals(this.subrogation, other.subrogation) && Objects.equals(this.contract, other.contract);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.type, this.policyHolder, this.subscriber, this.subscriberId, this.beneficiary, this.dependent, this.relationship, this.period, this.payor, this.clazz, this.order, this.network, this.costToBeneficiary, this.subrogation, this.contract);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class CostToBeneficiary
    extends BackboneElement {
        @Summary
        @Binding(bindingName="CopayTypes", strength=BindingStrength.Value.EXTENSIBLE, description="The types of services to which patient copayments are specified.", valueSet="http://hl7.org/fhir/ValueSet/coverage-copay-type")
        private final CodeableConcept type;
        @Summary
        @Choice(value={SimpleQuantity.class, Money.class})
        @Required
        private final Element value;
        private final List<Exception> exception;

        private CostToBeneficiary(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
            this.exception = Collections.unmodifiableList(builder.exception);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        public List<Exception> getException() {
            return this.exception;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null || !this.exception.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.exception, "exception", visitor, Exception.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CostToBeneficiary other = (CostToBeneficiary)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.exception, other.exception);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value, this.exception);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Exception
        extends BackboneElement {
            @Summary
            @Binding(bindingName="CoverageFinancialException", strength=BindingStrength.Value.EXAMPLE, description="The types of exceptions from the part or full value of financial obligations such as copays.", valueSet="http://hl7.org/fhir/ValueSet/coverage-financial-exception")
            @Required
            private final CodeableConcept type;
            @Summary
            private final Period period;

            private Exception(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.period = builder.period;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Period getPeriod() {
                return this.period;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.period != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.period, "period", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Exception other = (Exception)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.period, other.period);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.period);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private Period period;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder period(Period period) {
                    this.period = period;
                    return this;
                }

                @Override
                public Exception build() {
                    Exception exception = new Exception(this);
                    if (this.validating) {
                        this.validate(exception);
                    }
                    return exception;
                }

                protected void validate(Exception exception) {
                    super.validate(exception);
                    ValidationSupport.requireNonNull(exception.type, "type");
                    ValidationSupport.requireValueOrChildren(exception);
                }

                protected Builder from(Exception exception) {
                    super.from(exception);
                    this.type = exception.type;
                    this.period = exception.period;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;
            private List<Exception> exception = new ArrayList<Exception>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            public Builder exception(Exception ... exception) {
                for (Exception value : exception) {
                    this.exception.add(value);
                }
                return this;
            }

            public Builder exception(Collection<Exception> exception) {
                this.exception = new ArrayList<Exception>(exception);
                return this;
            }

            @Override
            public CostToBeneficiary build() {
                CostToBeneficiary costToBeneficiary = new CostToBeneficiary(this);
                if (this.validating) {
                    this.validate(costToBeneficiary);
                }
                return costToBeneficiary;
            }

            protected void validate(CostToBeneficiary costToBeneficiary) {
                super.validate(costToBeneficiary);
                ValidationSupport.requireChoiceElement(costToBeneficiary.value, "value", SimpleQuantity.class, Money.class);
                ValidationSupport.checkList(costToBeneficiary.exception, "exception", Exception.class);
                ValidationSupport.requireValueOrChildren(costToBeneficiary);
            }

            protected Builder from(CostToBeneficiary costToBeneficiary) {
                super.from(costToBeneficiary);
                this.type = costToBeneficiary.type;
                this.value = costToBeneficiary.value;
                this.exception.addAll(costToBeneficiary.exception);
                return this;
            }
        }
    }

    public static class Class
    extends BackboneElement {
        @Summary
        @Binding(bindingName="CoverageClass", strength=BindingStrength.Value.EXTENSIBLE, description="The policy classifications, eg. Group, Plan, Class, etc.", valueSet="http://hl7.org/fhir/ValueSet/coverage-class")
        @Required
        private final CodeableConcept type;
        @Summary
        @Required
        private final String value;
        @Summary
        private final String name;

        private Class(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
            this.name = builder.name;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null || this.name != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.name, "name", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Class other = (Class)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value, this.name);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private String value;
            private String name;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(java.lang.String value) {
                this.value = value == null ? null : String.of(value);
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder name(java.lang.String name) {
                this.name = name == null ? null : String.of(name);
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public Class build() {
                Class _class = new Class(this);
                if (this.validating) {
                    this.validate(_class);
                }
                return _class;
            }

            protected void validate(Class _class) {
                super.validate(_class);
                ValidationSupport.requireNonNull(_class.type, "type");
                ValidationSupport.requireNonNull(_class.value, "value");
                ValidationSupport.requireValueOrChildren(_class);
            }

            protected Builder from(Class _class) {
                super.from(_class);
                this.type = _class.type;
                this.value = _class.value;
                this.name = _class.name;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CoverageStatus status;
        private CodeableConcept type;
        private Reference policyHolder;
        private Reference subscriber;
        private String subscriberId;
        private Reference beneficiary;
        private String dependent;
        private CodeableConcept relationship;
        private Period period;
        private List<Reference> payor = new ArrayList<Reference>();
        private List<Class> clazz = new ArrayList<Class>();
        private PositiveInt order;
        private String network;
        private List<CostToBeneficiary> costToBeneficiary = new ArrayList<CostToBeneficiary>();
        private Boolean subrogation;
        private List<Reference> contract = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(CoverageStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder policyHolder(Reference policyHolder) {
            this.policyHolder = policyHolder;
            return this;
        }

        public Builder subscriber(Reference subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public Builder subscriberId(java.lang.String subscriberId) {
            this.subscriberId = subscriberId == null ? null : String.of(subscriberId);
            return this;
        }

        public Builder subscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
            return this;
        }

        public Builder beneficiary(Reference beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public Builder dependent(java.lang.String dependent) {
            this.dependent = dependent == null ? null : String.of(dependent);
            return this;
        }

        public Builder dependent(String dependent) {
            this.dependent = dependent;
            return this;
        }

        public Builder relationship(CodeableConcept relationship) {
            this.relationship = relationship;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder payor(Reference ... payor) {
            for (Reference value : payor) {
                this.payor.add(value);
            }
            return this;
        }

        public Builder payor(Collection<Reference> payor) {
            this.payor = new ArrayList<Reference>(payor);
            return this;
        }

        public Builder clazz(Class ... clazz) {
            for (Class value : clazz) {
                this.clazz.add(value);
            }
            return this;
        }

        public Builder clazz(Collection<Class> clazz) {
            this.clazz = new ArrayList<Class>(clazz);
            return this;
        }

        public Builder order(PositiveInt order) {
            this.order = order;
            return this;
        }

        public Builder network(java.lang.String network) {
            this.network = network == null ? null : String.of(network);
            return this;
        }

        public Builder network(String network) {
            this.network = network;
            return this;
        }

        public Builder costToBeneficiary(CostToBeneficiary ... costToBeneficiary) {
            for (CostToBeneficiary value : costToBeneficiary) {
                this.costToBeneficiary.add(value);
            }
            return this;
        }

        public Builder costToBeneficiary(Collection<CostToBeneficiary> costToBeneficiary) {
            this.costToBeneficiary = new ArrayList<CostToBeneficiary>(costToBeneficiary);
            return this;
        }

        public Builder subrogation(java.lang.Boolean subrogation) {
            this.subrogation = subrogation == null ? null : Boolean.of(subrogation);
            return this;
        }

        public Builder subrogation(Boolean subrogation) {
            this.subrogation = subrogation;
            return this;
        }

        public Builder contract(Reference ... contract) {
            for (Reference value : contract) {
                this.contract.add(value);
            }
            return this;
        }

        public Builder contract(Collection<Reference> contract) {
            this.contract = new ArrayList<Reference>(contract);
            return this;
        }

        @Override
        public Coverage build() {
            Coverage coverage = new Coverage(this);
            if (this.validating) {
                this.validate(coverage);
            }
            return coverage;
        }

        protected void validate(Coverage coverage) {
            super.validate(coverage);
            ValidationSupport.checkList(coverage.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(coverage.status, "status");
            ValidationSupport.requireNonNull(coverage.beneficiary, "beneficiary");
            ValidationSupport.checkNonEmptyList(coverage.payor, "payor", Reference.class);
            ValidationSupport.checkList(coverage.clazz, "class", Class.class);
            ValidationSupport.checkList(coverage.costToBeneficiary, "costToBeneficiary", CostToBeneficiary.class);
            ValidationSupport.checkList(coverage.contract, "contract", Reference.class);
            ValidationSupport.checkReferenceType(coverage.policyHolder, "policyHolder", "Patient", "RelatedPerson", "Organization");
            ValidationSupport.checkReferenceType(coverage.subscriber, "subscriber", "Patient", "RelatedPerson");
            ValidationSupport.checkReferenceType(coverage.beneficiary, "beneficiary", "Patient");
            ValidationSupport.checkReferenceType(coverage.payor, "payor", "Organization", "Patient", "RelatedPerson");
            ValidationSupport.checkReferenceType(coverage.contract, "contract", "Contract");
        }

        protected Builder from(Coverage coverage) {
            super.from(coverage);
            this.identifier.addAll(coverage.identifier);
            this.status = coverage.status;
            this.type = coverage.type;
            this.policyHolder = coverage.policyHolder;
            this.subscriber = coverage.subscriber;
            this.subscriberId = coverage.subscriberId;
            this.beneficiary = coverage.beneficiary;
            this.dependent = coverage.dependent;
            this.relationship = coverage.relationship;
            this.period = coverage.period;
            this.payor.addAll(coverage.payor);
            this.clazz.addAll(coverage.clazz);
            this.order = coverage.order;
            this.network = coverage.network;
            this.costToBeneficiary.addAll(coverage.costToBeneficiary);
            this.subrogation = coverage.subrogation;
            this.contract.addAll(coverage.contract);
            return this;
        }
    }
}

