/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.DeviceRequestStatus;
import com.ibm.fhir.model.type.code.RequestIntent;
import com.ibm.fhir.model.type.code.RequestPriority;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
public class DeviceRequest
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    @Summary
    private final List<Reference> basedOn;
    @Summary
    private final List<Reference> priorRequest;
    @Summary
    private final Identifier groupIdentifier;
    @Summary
    @Binding(bindingName="DeviceRequestStatus", strength=BindingStrength.Value.REQUIRED, description="Codes representing the status of the request.", valueSet="http://hl7.org/fhir/ValueSet/request-status|4.0.1")
    private final DeviceRequestStatus status;
    @Summary
    @Binding(bindingName="RequestIntent", strength=BindingStrength.Value.REQUIRED, description="The kind of diagnostic request.", valueSet="http://hl7.org/fhir/ValueSet/request-intent|4.0.1")
    @Required
    private final RequestIntent intent;
    @Summary
    @Binding(bindingName="RequestPriority", strength=BindingStrength.Value.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.0.1")
    private final RequestPriority priority;
    @Summary
    @ReferenceTarget(value={"Device"})
    @Choice(value={Reference.class, CodeableConcept.class})
    @Binding(bindingName="DeviceRequestCode", strength=BindingStrength.Value.EXAMPLE, description="Codes for devices that can be requested.", valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    @Required
    private final Element code;
    private final List<Parameter> parameter;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Location", "Device"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class, Timing.class})
    private final Element occurrence;
    @Summary
    private final DateTime authoredOn;
    @Summary
    @ReferenceTarget(value={"Device", "Practitioner", "PractitionerRole", "Organization"})
    private final Reference requester;
    @Summary
    @Binding(bindingName="DeviceRequestParticipantRole", strength=BindingStrength.Value.EXAMPLE, description="Indicates specific responsibility of an individual within the care team, such as \"Primary physician\", \"Team coordinator\", \"Caregiver\", etc.", valueSet="http://hl7.org/fhir/ValueSet/participant-role")
    private final CodeableConcept performerType;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam", "HealthcareService", "Patient", "Device", "RelatedPerson"})
    private final Reference performer;
    @Summary
    @Binding(bindingName="DeviceRequestReason", strength=BindingStrength.Value.EXAMPLE, description="Diagnosis or problem codes justifying the reason for requesting the device.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    @ReferenceTarget(value={"Coverage", "ClaimResponse"})
    private final List<Reference> insurance;
    private final List<Reference> supportingInfo;
    private final List<Annotation> note;
    @ReferenceTarget(value={"Provenance"})
    private final List<Reference> relevantHistory;

    private DeviceRequest(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.instantiatesCanonical = Collections.unmodifiableList(builder.instantiatesCanonical);
        this.instantiatesUri = Collections.unmodifiableList(builder.instantiatesUri);
        this.basedOn = Collections.unmodifiableList(builder.basedOn);
        this.priorRequest = Collections.unmodifiableList(builder.priorRequest);
        this.groupIdentifier = builder.groupIdentifier;
        this.status = builder.status;
        this.intent = builder.intent;
        this.priority = builder.priority;
        this.code = builder.code;
        this.parameter = Collections.unmodifiableList(builder.parameter);
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.occurrence = builder.occurrence;
        this.authoredOn = builder.authoredOn;
        this.requester = builder.requester;
        this.performerType = builder.performerType;
        this.performer = builder.performer;
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.insurance = Collections.unmodifiableList(builder.insurance);
        this.supportingInfo = Collections.unmodifiableList(builder.supportingInfo);
        this.note = Collections.unmodifiableList(builder.note);
        this.relevantHistory = Collections.unmodifiableList(builder.relevantHistory);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getPriorRequest() {
        return this.priorRequest;
    }

    public Identifier getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public DeviceRequestStatus getStatus() {
        return this.status;
    }

    public RequestIntent getIntent() {
        return this.intent;
    }

    public RequestPriority getPriority() {
        return this.priority;
    }

    public Element getCode() {
        return this.code;
    }

    public List<Parameter> getParameter() {
        return this.parameter;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public DateTime getAuthoredOn() {
        return this.authoredOn;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public CodeableConcept getPerformerType() {
        return this.performerType;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Reference> getInsurance() {
        return this.insurance;
    }

    public List<Reference> getSupportingInfo() {
        return this.supportingInfo;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Reference> getRelevantHistory() {
        return this.relevantHistory;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || !this.basedOn.isEmpty() || !this.priorRequest.isEmpty() || this.groupIdentifier != null || this.status != null || this.intent != null || this.priority != null || this.code != null || !this.parameter.isEmpty() || this.subject != null || this.encounter != null || this.occurrence != null || this.authoredOn != null || this.requester != null || this.performerType != null || this.performer != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.insurance.isEmpty() || !this.supportingInfo.isEmpty() || !this.note.isEmpty() || !this.relevantHistory.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.priorRequest, "priorRequest", visitor, Reference.class);
                this.accept(this.groupIdentifier, "groupIdentifier", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.parameter, "parameter", visitor, Parameter.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.authoredOn, "authoredOn", visitor);
                this.accept(this.requester, "requester", visitor);
                this.accept(this.performerType, "performerType", visitor);
                this.accept(this.performer, "performer", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.insurance, "insurance", visitor, Reference.class);
                this.accept(this.supportingInfo, "supportingInfo", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.relevantHistory, "relevantHistory", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceRequest other = (DeviceRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.priorRequest, other.priorRequest) && Objects.equals(this.groupIdentifier, other.groupIdentifier) && Objects.equals(this.status, other.status) && Objects.equals(this.intent, other.intent) && Objects.equals(this.priority, other.priority) && Objects.equals(this.code, other.code) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.authoredOn, other.authoredOn) && Objects.equals(this.requester, other.requester) && Objects.equals(this.performerType, other.performerType) && Objects.equals(this.performer, other.performer) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.supportingInfo, other.supportingInfo) && Objects.equals(this.note, other.note) && Objects.equals(this.relevantHistory, other.relevantHistory);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.priorRequest, this.groupIdentifier, this.status, this.intent, this.priority, this.code, this.parameter, this.subject, this.encounter, this.occurrence, this.authoredOn, this.requester, this.performerType, this.performer, this.reasonCode, this.reasonReference, this.insurance, this.supportingInfo, this.note, this.relevantHistory);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Parameter
    extends BackboneElement {
        @Binding(bindingName="ParameterCode", strength=BindingStrength.Value.EXAMPLE, description="A code that identifies the device detail.")
        private final CodeableConcept code;
        @Choice(value={CodeableConcept.class, Quantity.class, Range.class, Boolean.class})
        private final Element value;

        private Parameter(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.value = builder.value;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Parameter build() {
                Parameter parameter = new Parameter(this);
                if (this.validating) {
                    this.validate(parameter);
                }
                return parameter;
            }

            protected void validate(Parameter parameter) {
                super.validate(parameter);
                ValidationSupport.choiceElement(parameter.value, "value", CodeableConcept.class, Quantity.class, Range.class, Boolean.class);
                ValidationSupport.requireValueOrChildren(parameter);
            }

            protected Builder from(Parameter parameter) {
                super.from(parameter);
                this.code = parameter.code;
                this.value = parameter.value;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> priorRequest = new ArrayList<Reference>();
        private Identifier groupIdentifier;
        private DeviceRequestStatus status;
        private RequestIntent intent;
        private RequestPriority priority;
        private Element code;
        private List<Parameter> parameter = new ArrayList<Parameter>();
        private Reference subject;
        private Reference encounter;
        private Element occurrence;
        private DateTime authoredOn;
        private Reference requester;
        private CodeableConcept performerType;
        private Reference performer;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Reference> insurance = new ArrayList<Reference>();
        private List<Reference> supportingInfo = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Reference> relevantHistory = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder priorRequest(Reference ... priorRequest) {
            for (Reference value : priorRequest) {
                this.priorRequest.add(value);
            }
            return this;
        }

        public Builder priorRequest(Collection<Reference> priorRequest) {
            this.priorRequest = new ArrayList<Reference>(priorRequest);
            return this;
        }

        public Builder groupIdentifier(Identifier groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public Builder status(DeviceRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder intent(RequestIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder priority(RequestPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder code(Element code) {
            this.code = code;
            return this;
        }

        public Builder parameter(Parameter ... parameter) {
            for (Parameter value : parameter) {
                this.parameter.add(value);
            }
            return this;
        }

        public Builder parameter(Collection<Parameter> parameter) {
            this.parameter = new ArrayList<Parameter>(parameter);
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder authoredOn(DateTime authoredOn) {
            this.authoredOn = authoredOn;
            return this;
        }

        public Builder requester(Reference requester) {
            this.requester = requester;
            return this;
        }

        public Builder performerType(CodeableConcept performerType) {
            this.performerType = performerType;
            return this;
        }

        public Builder performer(Reference performer) {
            this.performer = performer;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder insurance(Reference ... insurance) {
            for (Reference value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Reference> insurance) {
            this.insurance = new ArrayList<Reference>(insurance);
            return this;
        }

        public Builder supportingInfo(Reference ... supportingInfo) {
            for (Reference value : supportingInfo) {
                this.supportingInfo.add(value);
            }
            return this;
        }

        public Builder supportingInfo(Collection<Reference> supportingInfo) {
            this.supportingInfo = new ArrayList<Reference>(supportingInfo);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder relevantHistory(Reference ... relevantHistory) {
            for (Reference value : relevantHistory) {
                this.relevantHistory.add(value);
            }
            return this;
        }

        public Builder relevantHistory(Collection<Reference> relevantHistory) {
            this.relevantHistory = new ArrayList<Reference>(relevantHistory);
            return this;
        }

        @Override
        public DeviceRequest build() {
            DeviceRequest deviceRequest = new DeviceRequest(this);
            if (this.validating) {
                this.validate(deviceRequest);
            }
            return deviceRequest;
        }

        protected void validate(DeviceRequest deviceRequest) {
            super.validate(deviceRequest);
            ValidationSupport.checkList(deviceRequest.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(deviceRequest.instantiatesCanonical, "instantiatesCanonical", Canonical.class);
            ValidationSupport.checkList(deviceRequest.instantiatesUri, "instantiatesUri", Uri.class);
            ValidationSupport.checkList(deviceRequest.basedOn, "basedOn", Reference.class);
            ValidationSupport.checkList(deviceRequest.priorRequest, "priorRequest", Reference.class);
            ValidationSupport.requireNonNull(deviceRequest.intent, "intent");
            ValidationSupport.requireChoiceElement(deviceRequest.code, "code", Reference.class, CodeableConcept.class);
            ValidationSupport.checkList(deviceRequest.parameter, "parameter", Parameter.class);
            ValidationSupport.requireNonNull(deviceRequest.subject, "subject");
            ValidationSupport.choiceElement(deviceRequest.occurrence, "occurrence", DateTime.class, Period.class, Timing.class);
            ValidationSupport.checkList(deviceRequest.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(deviceRequest.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(deviceRequest.insurance, "insurance", Reference.class);
            ValidationSupport.checkList(deviceRequest.supportingInfo, "supportingInfo", Reference.class);
            ValidationSupport.checkList(deviceRequest.note, "note", Annotation.class);
            ValidationSupport.checkList(deviceRequest.relevantHistory, "relevantHistory", Reference.class);
            ValidationSupport.checkReferenceType(deviceRequest.code, "code", "Device");
            ValidationSupport.checkReferenceType(deviceRequest.subject, "subject", "Patient", "Group", "Location", "Device");
            ValidationSupport.checkReferenceType(deviceRequest.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(deviceRequest.requester, "requester", "Device", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(deviceRequest.performer, "performer", "Practitioner", "PractitionerRole", "Organization", "CareTeam", "HealthcareService", "Patient", "Device", "RelatedPerson");
            ValidationSupport.checkReferenceType(deviceRequest.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
            ValidationSupport.checkReferenceType(deviceRequest.insurance, "insurance", "Coverage", "ClaimResponse");
            ValidationSupport.checkReferenceType(deviceRequest.relevantHistory, "relevantHistory", "Provenance");
        }

        protected Builder from(DeviceRequest deviceRequest) {
            super.from(deviceRequest);
            this.identifier.addAll(deviceRequest.identifier);
            this.instantiatesCanonical.addAll(deviceRequest.instantiatesCanonical);
            this.instantiatesUri.addAll(deviceRequest.instantiatesUri);
            this.basedOn.addAll(deviceRequest.basedOn);
            this.priorRequest.addAll(deviceRequest.priorRequest);
            this.groupIdentifier = deviceRequest.groupIdentifier;
            this.status = deviceRequest.status;
            this.intent = deviceRequest.intent;
            this.priority = deviceRequest.priority;
            this.code = deviceRequest.code;
            this.parameter.addAll(deviceRequest.parameter);
            this.subject = deviceRequest.subject;
            this.encounter = deviceRequest.encounter;
            this.occurrence = deviceRequest.occurrence;
            this.authoredOn = deviceRequest.authoredOn;
            this.requester = deviceRequest.requester;
            this.performerType = deviceRequest.performerType;
            this.performer = deviceRequest.performer;
            this.reasonCode.addAll(deviceRequest.reasonCode);
            this.reasonReference.addAll(deviceRequest.reasonReference);
            this.insurance.addAll(deviceRequest.insurance);
            this.supportingInfo.addAll(deviceRequest.supportingInfo);
            this.note.addAll(deviceRequest.note);
            this.relevantHistory.addAll(deviceRequest.relevantHistory);
            return this;
        }
    }
}

