/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.DeviceUseStatementStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class DeviceUseStatement
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"ServiceRequest"})
    private final List<Reference> basedOn;
    @Summary
    @Binding(bindingName="DeviceUseStatementStatus", strength=BindingStrength.Value.REQUIRED, description="A coded concept indicating the current status of the Device Usage.", valueSet="http://hl7.org/fhir/ValueSet/device-statement-status|4.0.1")
    @Required
    private final DeviceUseStatementStatus status;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"ServiceRequest", "Procedure", "Claim", "Observation", "QuestionnaireResponse", "DocumentReference"})
    private final List<Reference> derivedFrom;
    @Summary
    @Choice(value={Timing.class, Period.class, DateTime.class})
    private final Element timing;
    @Summary
    private final DateTime recordedOn;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
    private final Reference source;
    @Summary
    @ReferenceTarget(value={"Device"})
    @Required
    private final Reference device;
    @Summary
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference", "Media"})
    private final List<Reference> reasonReference;
    @Summary
    @Binding(bindingName="BodySite", strength=BindingStrength.Value.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final CodeableConcept bodySite;
    private final List<Annotation> note;

    private DeviceUseStatement(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.basedOn = Collections.unmodifiableList(builder.basedOn);
        this.status = builder.status;
        this.subject = builder.subject;
        this.derivedFrom = Collections.unmodifiableList(builder.derivedFrom);
        this.timing = builder.timing;
        this.recordedOn = builder.recordedOn;
        this.source = builder.source;
        this.device = builder.device;
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.bodySite = builder.bodySite;
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public DeviceUseStatementStatus getStatus() {
        return this.status;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public List<Reference> getDerivedFrom() {
        return this.derivedFrom;
    }

    public Element getTiming() {
        return this.timing;
    }

    public DateTime getRecordedOn() {
        return this.recordedOn;
    }

    public Reference getSource() {
        return this.source;
    }

    public Reference getDevice() {
        return this.device;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public CodeableConcept getBodySite() {
        return this.bodySite;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.basedOn.isEmpty() || this.status != null || this.subject != null || !this.derivedFrom.isEmpty() || this.timing != null || this.recordedOn != null || this.source != null || this.device != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || this.bodySite != null || !this.note.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.derivedFrom, "derivedFrom", visitor, Reference.class);
                this.accept(this.timing, "timing", visitor);
                this.accept(this.recordedOn, "recordedOn", visitor);
                this.accept(this.source, "source", visitor);
                this.accept(this.device, "device", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.bodySite, "bodySite", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceUseStatement other = (DeviceUseStatement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.status, other.status) && Objects.equals(this.subject, other.subject) && Objects.equals(this.derivedFrom, other.derivedFrom) && Objects.equals(this.timing, other.timing) && Objects.equals(this.recordedOn, other.recordedOn) && Objects.equals(this.source, other.source) && Objects.equals(this.device, other.device) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.status, this.subject, this.derivedFrom, this.timing, this.recordedOn, this.source, this.device, this.reasonCode, this.reasonReference, this.bodySite, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private DeviceUseStatementStatus status;
        private Reference subject;
        private List<Reference> derivedFrom = new ArrayList<Reference>();
        private Element timing;
        private DateTime recordedOn;
        private Reference source;
        private Reference device;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private CodeableConcept bodySite;
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder status(DeviceUseStatementStatus status) {
            this.status = status;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder derivedFrom(Reference ... derivedFrom) {
            for (Reference value : derivedFrom) {
                this.derivedFrom.add(value);
            }
            return this;
        }

        public Builder derivedFrom(Collection<Reference> derivedFrom) {
            this.derivedFrom = new ArrayList<Reference>(derivedFrom);
            return this;
        }

        public Builder timing(Element timing) {
            this.timing = timing;
            return this;
        }

        public Builder recordedOn(DateTime recordedOn) {
            this.recordedOn = recordedOn;
            return this;
        }

        public Builder source(Reference source) {
            this.source = source;
            return this;
        }

        public Builder device(Reference device) {
            this.device = device;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder bodySite(CodeableConcept bodySite) {
            this.bodySite = bodySite;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public DeviceUseStatement build() {
            DeviceUseStatement deviceUseStatement = new DeviceUseStatement(this);
            if (this.validating) {
                this.validate(deviceUseStatement);
            }
            return deviceUseStatement;
        }

        protected void validate(DeviceUseStatement deviceUseStatement) {
            super.validate(deviceUseStatement);
            ValidationSupport.checkList(deviceUseStatement.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(deviceUseStatement.basedOn, "basedOn", Reference.class);
            ValidationSupport.requireNonNull(deviceUseStatement.status, "status");
            ValidationSupport.requireNonNull(deviceUseStatement.subject, "subject");
            ValidationSupport.checkList(deviceUseStatement.derivedFrom, "derivedFrom", Reference.class);
            ValidationSupport.choiceElement(deviceUseStatement.timing, "timing", Timing.class, Period.class, DateTime.class);
            ValidationSupport.requireNonNull(deviceUseStatement.device, "device");
            ValidationSupport.checkList(deviceUseStatement.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(deviceUseStatement.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(deviceUseStatement.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(deviceUseStatement.basedOn, "basedOn", "ServiceRequest");
            ValidationSupport.checkReferenceType(deviceUseStatement.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(deviceUseStatement.derivedFrom, "derivedFrom", "ServiceRequest", "Procedure", "Claim", "Observation", "QuestionnaireResponse", "DocumentReference");
            ValidationSupport.checkReferenceType(deviceUseStatement.source, "source", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
            ValidationSupport.checkReferenceType(deviceUseStatement.device, "device", "Device");
            ValidationSupport.checkReferenceType(deviceUseStatement.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference", "Media");
        }

        protected Builder from(DeviceUseStatement deviceUseStatement) {
            super.from(deviceUseStatement);
            this.identifier.addAll(deviceUseStatement.identifier);
            this.basedOn.addAll(deviceUseStatement.basedOn);
            this.status = deviceUseStatement.status;
            this.subject = deviceUseStatement.subject;
            this.derivedFrom.addAll(deviceUseStatement.derivedFrom);
            this.timing = deviceUseStatement.timing;
            this.recordedOn = deviceUseStatement.recordedOn;
            this.source = deviceUseStatement.source;
            this.device = deviceUseStatement.device;
            this.reasonCode.addAll(deviceUseStatement.reasonCode);
            this.reasonReference.addAll(deviceUseStatement.reasonReference);
            this.bodySite = deviceUseStatement.bodySite;
            this.note.addAll(deviceUseStatement.note);
            return this;
        }
    }
}

