/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EnrollmentResponseStatus;
import com.ibm.fhir.model.type.code.RemittanceOutcome;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class EnrollmentResponse
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="EnrollmentResponseStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    private final EnrollmentResponseStatus status;
    @ReferenceTarget(value={"EnrollmentRequest"})
    private final Reference request;
    @Binding(bindingName="RemittanceOutcome", strength=BindingStrength.Value.REQUIRED, description="The outcome of the processing.", valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome|4.0.1")
    private final RemittanceOutcome outcome;
    private final String disposition;
    private final DateTime created;
    @ReferenceTarget(value={"Organization"})
    private final Reference organization;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference requestProvider;

    private EnrollmentResponse(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.request = builder.request;
        this.outcome = builder.outcome;
        this.disposition = builder.disposition;
        this.created = builder.created;
        this.organization = builder.organization;
        this.requestProvider = builder.requestProvider;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public EnrollmentResponseStatus getStatus() {
        return this.status;
    }

    public Reference getRequest() {
        return this.request;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public Reference getRequestProvider() {
        return this.requestProvider;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.request != null || this.outcome != null || this.disposition != null || this.created != null || this.organization != null || this.requestProvider != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.request, "request", visitor);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.disposition, "disposition", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.organization, "organization", visitor);
                this.accept(this.requestProvider, "requestProvider", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnrollmentResponse other = (EnrollmentResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.request, other.request) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.disposition, other.disposition) && Objects.equals(this.created, other.created) && Objects.equals(this.organization, other.organization) && Objects.equals(this.requestProvider, other.requestProvider);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.request, this.outcome, this.disposition, this.created, this.organization, this.requestProvider);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private EnrollmentResponseStatus status;
        private Reference request;
        private RemittanceOutcome outcome;
        private String disposition;
        private DateTime created;
        private Reference organization;
        private Reference requestProvider;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(EnrollmentResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder request(Reference request) {
            this.request = request;
            return this;
        }

        public Builder outcome(RemittanceOutcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder disposition(java.lang.String disposition) {
            this.disposition = disposition == null ? null : String.of(disposition);
            return this;
        }

        public Builder disposition(String disposition) {
            this.disposition = disposition;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder organization(Reference organization) {
            this.organization = organization;
            return this;
        }

        public Builder requestProvider(Reference requestProvider) {
            this.requestProvider = requestProvider;
            return this;
        }

        @Override
        public EnrollmentResponse build() {
            EnrollmentResponse enrollmentResponse = new EnrollmentResponse(this);
            if (this.validating) {
                this.validate(enrollmentResponse);
            }
            return enrollmentResponse;
        }

        protected void validate(EnrollmentResponse enrollmentResponse) {
            super.validate(enrollmentResponse);
            ValidationSupport.checkList(enrollmentResponse.identifier, "identifier", Identifier.class);
            ValidationSupport.checkReferenceType(enrollmentResponse.request, "request", "EnrollmentRequest");
            ValidationSupport.checkReferenceType(enrollmentResponse.organization, "organization", "Organization");
            ValidationSupport.checkReferenceType(enrollmentResponse.requestProvider, "requestProvider", "Practitioner", "PractitionerRole", "Organization");
        }

        protected Builder from(EnrollmentResponse enrollmentResponse) {
            super.from(enrollmentResponse);
            this.identifier.addAll(enrollmentResponse.identifier);
            this.status = enrollmentResponse.status;
            this.request = enrollmentResponse.request;
            this.outcome = enrollmentResponse.outcome;
            this.disposition = enrollmentResponse.disposition;
            this.created = enrollmentResponse.created;
            this.organization = enrollmentResponse.organization;
            this.requestProvider = enrollmentResponse.requestProvider;
            return this;
        }
    }
}

