/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MedicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
public class Medication
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="MedicationFormalRepresentation", strength=BindingStrength.Value.EXAMPLE, description="A coded concept that defines the type of a medication.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    private final CodeableConcept code;
    @Summary
    @Binding(bindingName="MedicationStatus", strength=BindingStrength.Value.REQUIRED, description="A coded concept defining if the medication is in active use.", valueSet="http://hl7.org/fhir/ValueSet/medication-status|4.0.1")
    private final MedicationStatus status;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference manufacturer;
    @Binding(bindingName="MedicationForm", strength=BindingStrength.Value.EXAMPLE, description="A coded concept defining the form of a medication.", valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
    private final CodeableConcept form;
    @Summary
    private final Ratio amount;
    private final List<Ingredient> ingredient;
    private final Batch batch;

    private Medication(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.code = builder.code;
        this.status = builder.status;
        this.manufacturer = builder.manufacturer;
        this.form = builder.form;
        this.amount = builder.amount;
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
        this.batch = builder.batch;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public MedicationStatus getStatus() {
        return this.status;
    }

    public Reference getManufacturer() {
        return this.manufacturer;
    }

    public CodeableConcept getForm() {
        return this.form;
    }

    public Ratio getAmount() {
        return this.amount;
    }

    public List<Ingredient> getIngredient() {
        return this.ingredient;
    }

    public Batch getBatch() {
        return this.batch;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.code != null || this.status != null || this.manufacturer != null || this.form != null || this.amount != null || !this.ingredient.isEmpty() || this.batch != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor);
                this.accept(this.form, "form", visitor);
                this.accept(this.amount, "amount", visitor);
                this.accept(this.ingredient, "ingredient", visitor, Ingredient.class);
                this.accept(this.batch, "batch", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Medication other = (Medication)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.code, other.code) && Objects.equals(this.status, other.status) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.form, other.form) && Objects.equals(this.amount, other.amount) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.batch, other.batch);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.code, this.status, this.manufacturer, this.form, this.amount, this.ingredient, this.batch);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Batch
    extends BackboneElement {
        private final String lotNumber;
        private final DateTime expirationDate;

        private Batch(Builder builder) {
            super(builder);
            this.lotNumber = builder.lotNumber;
            this.expirationDate = builder.expirationDate;
        }

        public String getLotNumber() {
            return this.lotNumber;
        }

        public DateTime getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.lotNumber != null || this.expirationDate != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.lotNumber, "lotNumber", visitor);
                    this.accept(this.expirationDate, "expirationDate", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Batch other = (Batch)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.lotNumber, other.lotNumber) && Objects.equals(this.expirationDate, other.expirationDate);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.lotNumber, this.expirationDate);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String lotNumber;
            private DateTime expirationDate;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder lotNumber(java.lang.String lotNumber) {
                this.lotNumber = lotNumber == null ? null : String.of(lotNumber);
                return this;
            }

            public Builder lotNumber(String lotNumber) {
                this.lotNumber = lotNumber;
                return this;
            }

            public Builder expirationDate(DateTime expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            @Override
            public Batch build() {
                Batch batch = new Batch(this);
                if (this.validating) {
                    this.validate(batch);
                }
                return batch;
            }

            protected void validate(Batch batch) {
                super.validate(batch);
                ValidationSupport.requireValueOrChildren(batch);
            }

            protected Builder from(Batch batch) {
                super.from(batch);
                this.lotNumber = batch.lotNumber;
                this.expirationDate = batch.expirationDate;
                return this;
            }
        }
    }

    public static class Ingredient
    extends BackboneElement {
        @ReferenceTarget(value={"Substance", "Medication"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Required
        private final Element item;
        private final Boolean isActive;
        private final Ratio strength;

        private Ingredient(Builder builder) {
            super(builder);
            this.item = builder.item;
            this.isActive = builder.isActive;
            this.strength = builder.strength;
        }

        public Element getItem() {
            return this.item;
        }

        public Boolean getIsActive() {
            return this.isActive;
        }

        public Ratio getStrength() {
            return this.strength;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.item != null || this.isActive != null || this.strength != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.item, "item", visitor);
                    this.accept(this.isActive, "isActive", visitor);
                    this.accept(this.strength, "strength", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ingredient other = (Ingredient)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.item, other.item) && Objects.equals(this.isActive, other.isActive) && Objects.equals(this.strength, other.strength);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.item, this.isActive, this.strength);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element item;
            private Boolean isActive;
            private Ratio strength;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder item(Element item) {
                this.item = item;
                return this;
            }

            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive == null ? null : Boolean.of(isActive);
                return this;
            }

            public Builder isActive(Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            public Builder strength(Ratio strength) {
                this.strength = strength;
                return this;
            }

            @Override
            public Ingredient build() {
                Ingredient ingredient = new Ingredient(this);
                if (this.validating) {
                    this.validate(ingredient);
                }
                return ingredient;
            }

            protected void validate(Ingredient ingredient) {
                super.validate(ingredient);
                ValidationSupport.requireChoiceElement(ingredient.item, "item", CodeableConcept.class, Reference.class);
                ValidationSupport.checkReferenceType(ingredient.item, "item", "Substance", "Medication");
                ValidationSupport.requireValueOrChildren(ingredient);
            }

            protected Builder from(Ingredient ingredient) {
                super.from(ingredient);
                this.item = ingredient.item;
                this.isActive = ingredient.isActive;
                this.strength = ingredient.strength;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept code;
        private MedicationStatus status;
        private Reference manufacturer;
        private CodeableConcept form;
        private Ratio amount;
        private List<Ingredient> ingredient = new ArrayList<Ingredient>();
        private Batch batch;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder status(MedicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder manufacturer(Reference manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder form(CodeableConcept form) {
            this.form = form;
            return this;
        }

        public Builder amount(Ratio amount) {
            this.amount = amount;
            return this;
        }

        public Builder ingredient(Ingredient ... ingredient) {
            for (Ingredient value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<Ingredient> ingredient) {
            this.ingredient = new ArrayList<Ingredient>(ingredient);
            return this;
        }

        public Builder batch(Batch batch) {
            this.batch = batch;
            return this;
        }

        @Override
        public Medication build() {
            Medication medication = new Medication(this);
            if (this.validating) {
                this.validate(medication);
            }
            return medication;
        }

        protected void validate(Medication medication) {
            super.validate(medication);
            ValidationSupport.checkList(medication.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(medication.ingredient, "ingredient", Ingredient.class);
            ValidationSupport.checkReferenceType(medication.manufacturer, "manufacturer", "Organization");
        }

        protected Builder from(Medication medication) {
            super.from(medication);
            this.identifier.addAll(medication.identifier);
            this.code = medication.code;
            this.status = medication.status;
            this.manufacturer = medication.manufacturer;
            this.form = medication.form;
            this.amount = medication.amount;
            this.ingredient.addAll(medication.ingredient);
            this.batch = medication.batch;
            return this;
        }
    }
}

