/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MedicationDispenseStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="mdd-1", level="Rule", location="(base)", description="whenHandedOver cannot be before whenPrepared", expression="whenHandedOver.empty() or whenPrepared.empty() or whenHandedOver >= whenPrepared", source="http://hl7.org/fhir/StructureDefinition/MedicationDispense"), @Constraint(id="medicationDispense-2", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/medicationdispense-category", expression="category.exists() implies (category.memberOf('http://hl7.org/fhir/ValueSet/medicationdispense-category', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/MedicationDispense", generated=true)})
public class MedicationDispense
extends DomainResource {
    private final List<Identifier> identifier;
    @ReferenceTarget(value={"Procedure"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="MedicationDispenseStatus", strength=BindingStrength.Value.REQUIRED, description="A coded concept specifying the state of the dispense event.", valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-status|4.0.1")
    @Required
    private final MedicationDispenseStatus status;
    @ReferenceTarget(value={"DetectedIssue"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="MedicationDispenseStatusReason", strength=BindingStrength.Value.EXAMPLE, description="A code describing why a dispense was not performed.", valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-status-reason")
    private final Element statusReason;
    @Binding(bindingName="MedicationDispenseCategory", strength=BindingStrength.Value.PREFERRED, description="A code describing where the dispensed medication is expected to be consumed or administered.", valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-category")
    private final CodeableConcept category;
    @Summary
    @ReferenceTarget(value={"Medication"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="MedicationCode", strength=BindingStrength.Value.EXAMPLE, description="A coded concept identifying which substance or product can be dispensed.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    @Required
    private final Element medication;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    private final Reference subject;
    @ReferenceTarget(value={"Encounter", "EpisodeOfCare"})
    private final Reference context;
    private final List<Reference> supportingInformation;
    private final List<Performer> performer;
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    @ReferenceTarget(value={"MedicationRequest"})
    private final List<Reference> authorizingPrescription;
    @Binding(bindingName="MedicationDispenseType", strength=BindingStrength.Value.EXAMPLE, description="Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType")
    private final CodeableConcept type;
    private final SimpleQuantity quantity;
    private final SimpleQuantity daysSupply;
    @Summary
    private final DateTime whenPrepared;
    private final DateTime whenHandedOver;
    @ReferenceTarget(value={"Location"})
    private final Reference destination;
    @ReferenceTarget(value={"Patient", "Practitioner"})
    private final List<Reference> receiver;
    private final List<Annotation> note;
    private final List<Dosage> dosageInstruction;
    private final Substitution substitution;
    @ReferenceTarget(value={"DetectedIssue"})
    private final List<Reference> detectedIssue;
    @ReferenceTarget(value={"Provenance"})
    private final List<Reference> eventHistory;

    private MedicationDispense(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.partOf = Collections.unmodifiableList(builder.partOf);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.category = builder.category;
        this.medication = builder.medication;
        this.subject = builder.subject;
        this.context = builder.context;
        this.supportingInformation = Collections.unmodifiableList(builder.supportingInformation);
        this.performer = Collections.unmodifiableList(builder.performer);
        this.location = builder.location;
        this.authorizingPrescription = Collections.unmodifiableList(builder.authorizingPrescription);
        this.type = builder.type;
        this.quantity = builder.quantity;
        this.daysSupply = builder.daysSupply;
        this.whenPrepared = builder.whenPrepared;
        this.whenHandedOver = builder.whenHandedOver;
        this.destination = builder.destination;
        this.receiver = Collections.unmodifiableList(builder.receiver);
        this.note = Collections.unmodifiableList(builder.note);
        this.dosageInstruction = Collections.unmodifiableList(builder.dosageInstruction);
        this.substitution = builder.substitution;
        this.detectedIssue = Collections.unmodifiableList(builder.detectedIssue);
        this.eventHistory = Collections.unmodifiableList(builder.eventHistory);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public MedicationDispenseStatus getStatus() {
        return this.status;
    }

    public Element getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public Element getMedication() {
        return this.medication;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getContext() {
        return this.context;
    }

    public List<Reference> getSupportingInformation() {
        return this.supportingInformation;
    }

    public List<Performer> getPerformer() {
        return this.performer;
    }

    public Reference getLocation() {
        return this.location;
    }

    public List<Reference> getAuthorizingPrescription() {
        return this.authorizingPrescription;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public SimpleQuantity getQuantity() {
        return this.quantity;
    }

    public SimpleQuantity getDaysSupply() {
        return this.daysSupply;
    }

    public DateTime getWhenPrepared() {
        return this.whenPrepared;
    }

    public DateTime getWhenHandedOver() {
        return this.whenHandedOver;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public List<Reference> getReceiver() {
        return this.receiver;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Dosage> getDosageInstruction() {
        return this.dosageInstruction;
    }

    public Substitution getSubstitution() {
        return this.substitution;
    }

    public List<Reference> getDetectedIssue() {
        return this.detectedIssue;
    }

    public List<Reference> getEventHistory() {
        return this.eventHistory;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.partOf.isEmpty() || this.status != null || this.statusReason != null || this.category != null || this.medication != null || this.subject != null || this.context != null || !this.supportingInformation.isEmpty() || !this.performer.isEmpty() || this.location != null || !this.authorizingPrescription.isEmpty() || this.type != null || this.quantity != null || this.daysSupply != null || this.whenPrepared != null || this.whenHandedOver != null || this.destination != null || !this.receiver.isEmpty() || !this.note.isEmpty() || !this.dosageInstruction.isEmpty() || this.substitution != null || !this.detectedIssue.isEmpty() || !this.eventHistory.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.category, "category", visitor);
                this.accept(this.medication, "medication", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.context, "context", visitor);
                this.accept(this.supportingInformation, "supportingInformation", visitor, Reference.class);
                this.accept(this.performer, "performer", visitor, Performer.class);
                this.accept(this.location, "location", visitor);
                this.accept(this.authorizingPrescription, "authorizingPrescription", visitor, Reference.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.daysSupply, "daysSupply", visitor);
                this.accept(this.whenPrepared, "whenPrepared", visitor);
                this.accept(this.whenHandedOver, "whenHandedOver", visitor);
                this.accept(this.destination, "destination", visitor);
                this.accept(this.receiver, "receiver", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.dosageInstruction, "dosageInstruction", visitor, Dosage.class);
                this.accept(this.substitution, "substitution", visitor);
                this.accept(this.detectedIssue, "detectedIssue", visitor, Reference.class);
                this.accept(this.eventHistory, "eventHistory", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationDispense other = (MedicationDispense)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.category, other.category) && Objects.equals(this.medication, other.medication) && Objects.equals(this.subject, other.subject) && Objects.equals(this.context, other.context) && Objects.equals(this.supportingInformation, other.supportingInformation) && Objects.equals(this.performer, other.performer) && Objects.equals(this.location, other.location) && Objects.equals(this.authorizingPrescription, other.authorizingPrescription) && Objects.equals(this.type, other.type) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.daysSupply, other.daysSupply) && Objects.equals(this.whenPrepared, other.whenPrepared) && Objects.equals(this.whenHandedOver, other.whenHandedOver) && Objects.equals(this.destination, other.destination) && Objects.equals(this.receiver, other.receiver) && Objects.equals(this.note, other.note) && Objects.equals(this.dosageInstruction, other.dosageInstruction) && Objects.equals(this.substitution, other.substitution) && Objects.equals(this.detectedIssue, other.detectedIssue) && Objects.equals(this.eventHistory, other.eventHistory);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.partOf, this.status, this.statusReason, this.category, this.medication, this.subject, this.context, this.supportingInformation, this.performer, this.location, this.authorizingPrescription, this.type, this.quantity, this.daysSupply, this.whenPrepared, this.whenHandedOver, this.destination, this.receiver, this.note, this.dosageInstruction, this.substitution, this.detectedIssue, this.eventHistory);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Substitution
    extends BackboneElement {
        @Required
        private final Boolean wasSubstituted;
        @Binding(bindingName="MedicationIntendedSubstitutionType", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing whether a different medicinal product may be dispensed other than the product as specified exactly in the prescription.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActSubstanceAdminSubstitutionCode")
        private final CodeableConcept type;
        @Binding(bindingName="MedicationIntendedSubstitutionReason", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the reason that a different medication should (or should not) be substituted from what was prescribed.", valueSet="http://terminology.hl7.org/ValueSet/v3-SubstanceAdminSubstitutionReason")
        private final List<CodeableConcept> reason;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
        private final List<Reference> responsibleParty;

        private Substitution(Builder builder) {
            super(builder);
            this.wasSubstituted = builder.wasSubstituted;
            this.type = builder.type;
            this.reason = Collections.unmodifiableList(builder.reason);
            this.responsibleParty = Collections.unmodifiableList(builder.responsibleParty);
        }

        public Boolean getWasSubstituted() {
            return this.wasSubstituted;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<CodeableConcept> getReason() {
            return this.reason;
        }

        public List<Reference> getResponsibleParty() {
            return this.responsibleParty;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.wasSubstituted != null || this.type != null || !this.reason.isEmpty() || !this.responsibleParty.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.wasSubstituted, "wasSubstituted", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.reason, "reason", visitor, CodeableConcept.class);
                    this.accept(this.responsibleParty, "responsibleParty", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Substitution other = (Substitution)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.wasSubstituted, other.wasSubstituted) && Objects.equals(this.type, other.type) && Objects.equals(this.reason, other.reason) && Objects.equals(this.responsibleParty, other.responsibleParty);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.wasSubstituted, this.type, this.reason, this.responsibleParty);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean wasSubstituted;
            private CodeableConcept type;
            private List<CodeableConcept> reason = new ArrayList<CodeableConcept>();
            private List<Reference> responsibleParty = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder wasSubstituted(java.lang.Boolean wasSubstituted) {
                this.wasSubstituted = wasSubstituted == null ? null : Boolean.of(wasSubstituted);
                return this;
            }

            public Builder wasSubstituted(Boolean wasSubstituted) {
                this.wasSubstituted = wasSubstituted;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder reason(CodeableConcept ... reason) {
                for (CodeableConcept value : reason) {
                    this.reason.add(value);
                }
                return this;
            }

            public Builder reason(Collection<CodeableConcept> reason) {
                this.reason = new ArrayList<CodeableConcept>(reason);
                return this;
            }

            public Builder responsibleParty(Reference ... responsibleParty) {
                for (Reference value : responsibleParty) {
                    this.responsibleParty.add(value);
                }
                return this;
            }

            public Builder responsibleParty(Collection<Reference> responsibleParty) {
                this.responsibleParty = new ArrayList<Reference>(responsibleParty);
                return this;
            }

            @Override
            public Substitution build() {
                Substitution substitution = new Substitution(this);
                if (this.validating) {
                    this.validate(substitution);
                }
                return substitution;
            }

            protected void validate(Substitution substitution) {
                super.validate(substitution);
                ValidationSupport.requireNonNull(substitution.wasSubstituted, "wasSubstituted");
                ValidationSupport.checkList(substitution.reason, "reason", CodeableConcept.class);
                ValidationSupport.checkList(substitution.responsibleParty, "responsibleParty", Reference.class);
                ValidationSupport.checkReferenceType(substitution.responsibleParty, "responsibleParty", "Practitioner", "PractitionerRole");
                ValidationSupport.requireValueOrChildren(substitution);
            }

            protected Builder from(Substitution substitution) {
                super.from(substitution);
                this.wasSubstituted = substitution.wasSubstituted;
                this.type = substitution.type;
                this.reason.addAll(substitution.reason);
                this.responsibleParty.addAll(substitution.responsibleParty);
                return this;
            }
        }
    }

    public static class Performer
    extends BackboneElement {
        @Binding(bindingName="MedicationDispensePerformerFunction", strength=BindingStrength.Value.EXAMPLE, description="A code describing the role an individual played in dispensing a medication.", valueSet="http://hl7.org/fhir/ValueSet/medicationdispense-performer-function")
        private final CodeableConcept function;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "Device", "RelatedPerson"})
        @Required
        private final Reference actor;

        private Performer(Builder builder) {
            super(builder);
            this.function = builder.function;
            this.actor = builder.actor;
        }

        public CodeableConcept getFunction() {
            return this.function;
        }

        public Reference getActor() {
            return this.actor;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.function != null || this.actor != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.function, "function", visitor);
                    this.accept(this.actor, "actor", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Performer other = (Performer)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.function, other.function) && Objects.equals(this.actor, other.actor);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.function, this.actor);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept function;
            private Reference actor;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder function(CodeableConcept function) {
                this.function = function;
                return this;
            }

            public Builder actor(Reference actor) {
                this.actor = actor;
                return this;
            }

            @Override
            public Performer build() {
                Performer performer = new Performer(this);
                if (this.validating) {
                    this.validate(performer);
                }
                return performer;
            }

            protected void validate(Performer performer) {
                super.validate(performer);
                ValidationSupport.requireNonNull(performer.actor, "actor");
                ValidationSupport.checkReferenceType(performer.actor, "actor", "Practitioner", "PractitionerRole", "Organization", "Patient", "Device", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(performer);
            }

            protected Builder from(Performer performer) {
                super.from(performer);
                this.function = performer.function;
                this.actor = performer.actor;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private MedicationDispenseStatus status;
        private Element statusReason;
        private CodeableConcept category;
        private Element medication;
        private Reference subject;
        private Reference context;
        private List<Reference> supportingInformation = new ArrayList<Reference>();
        private List<Performer> performer = new ArrayList<Performer>();
        private Reference location;
        private List<Reference> authorizingPrescription = new ArrayList<Reference>();
        private CodeableConcept type;
        private SimpleQuantity quantity;
        private SimpleQuantity daysSupply;
        private DateTime whenPrepared;
        private DateTime whenHandedOver;
        private Reference destination;
        private List<Reference> receiver = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Dosage> dosageInstruction = new ArrayList<Dosage>();
        private Substitution substitution;
        private List<Reference> detectedIssue = new ArrayList<Reference>();
        private List<Reference> eventHistory = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(MedicationDispenseStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(Element statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder category(CodeableConcept category) {
            this.category = category;
            return this;
        }

        public Builder medication(Element medication) {
            this.medication = medication;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder context(Reference context) {
            this.context = context;
            return this;
        }

        public Builder supportingInformation(Reference ... supportingInformation) {
            for (Reference value : supportingInformation) {
                this.supportingInformation.add(value);
            }
            return this;
        }

        public Builder supportingInformation(Collection<Reference> supportingInformation) {
            this.supportingInformation = new ArrayList<Reference>(supportingInformation);
            return this;
        }

        public Builder performer(Performer ... performer) {
            for (Performer value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Performer> performer) {
            this.performer = new ArrayList<Performer>(performer);
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder authorizingPrescription(Reference ... authorizingPrescription) {
            for (Reference value : authorizingPrescription) {
                this.authorizingPrescription.add(value);
            }
            return this;
        }

        public Builder authorizingPrescription(Collection<Reference> authorizingPrescription) {
            this.authorizingPrescription = new ArrayList<Reference>(authorizingPrescription);
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder quantity(SimpleQuantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder daysSupply(SimpleQuantity daysSupply) {
            this.daysSupply = daysSupply;
            return this;
        }

        public Builder whenPrepared(DateTime whenPrepared) {
            this.whenPrepared = whenPrepared;
            return this;
        }

        public Builder whenHandedOver(DateTime whenHandedOver) {
            this.whenHandedOver = whenHandedOver;
            return this;
        }

        public Builder destination(Reference destination) {
            this.destination = destination;
            return this;
        }

        public Builder receiver(Reference ... receiver) {
            for (Reference value : receiver) {
                this.receiver.add(value);
            }
            return this;
        }

        public Builder receiver(Collection<Reference> receiver) {
            this.receiver = new ArrayList<Reference>(receiver);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder dosageInstruction(Dosage ... dosageInstruction) {
            for (Dosage value : dosageInstruction) {
                this.dosageInstruction.add(value);
            }
            return this;
        }

        public Builder dosageInstruction(Collection<Dosage> dosageInstruction) {
            this.dosageInstruction = new ArrayList<Dosage>(dosageInstruction);
            return this;
        }

        public Builder substitution(Substitution substitution) {
            this.substitution = substitution;
            return this;
        }

        public Builder detectedIssue(Reference ... detectedIssue) {
            for (Reference value : detectedIssue) {
                this.detectedIssue.add(value);
            }
            return this;
        }

        public Builder detectedIssue(Collection<Reference> detectedIssue) {
            this.detectedIssue = new ArrayList<Reference>(detectedIssue);
            return this;
        }

        public Builder eventHistory(Reference ... eventHistory) {
            for (Reference value : eventHistory) {
                this.eventHistory.add(value);
            }
            return this;
        }

        public Builder eventHistory(Collection<Reference> eventHistory) {
            this.eventHistory = new ArrayList<Reference>(eventHistory);
            return this;
        }

        @Override
        public MedicationDispense build() {
            MedicationDispense medicationDispense = new MedicationDispense(this);
            if (this.validating) {
                this.validate(medicationDispense);
            }
            return medicationDispense;
        }

        protected void validate(MedicationDispense medicationDispense) {
            super.validate(medicationDispense);
            ValidationSupport.checkList(medicationDispense.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(medicationDispense.partOf, "partOf", Reference.class);
            ValidationSupport.requireNonNull(medicationDispense.status, "status");
            ValidationSupport.choiceElement(medicationDispense.statusReason, "statusReason", CodeableConcept.class, Reference.class);
            ValidationSupport.requireChoiceElement(medicationDispense.medication, "medication", CodeableConcept.class, Reference.class);
            ValidationSupport.checkList(medicationDispense.supportingInformation, "supportingInformation", Reference.class);
            ValidationSupport.checkList(medicationDispense.performer, "performer", Performer.class);
            ValidationSupport.checkList(medicationDispense.authorizingPrescription, "authorizingPrescription", Reference.class);
            ValidationSupport.checkList(medicationDispense.receiver, "receiver", Reference.class);
            ValidationSupport.checkList(medicationDispense.note, "note", Annotation.class);
            ValidationSupport.checkList(medicationDispense.dosageInstruction, "dosageInstruction", Dosage.class);
            ValidationSupport.checkList(medicationDispense.detectedIssue, "detectedIssue", Reference.class);
            ValidationSupport.checkList(medicationDispense.eventHistory, "eventHistory", Reference.class);
            ValidationSupport.checkReferenceType(medicationDispense.partOf, "partOf", "Procedure");
            ValidationSupport.checkReferenceType(medicationDispense.statusReason, "statusReason", "DetectedIssue");
            ValidationSupport.checkReferenceType(medicationDispense.medication, "medication", "Medication");
            ValidationSupport.checkReferenceType(medicationDispense.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(medicationDispense.context, "context", "Encounter", "EpisodeOfCare");
            ValidationSupport.checkReferenceType(medicationDispense.location, "location", "Location");
            ValidationSupport.checkReferenceType(medicationDispense.authorizingPrescription, "authorizingPrescription", "MedicationRequest");
            ValidationSupport.checkReferenceType(medicationDispense.destination, "destination", "Location");
            ValidationSupport.checkReferenceType(medicationDispense.receiver, "receiver", "Patient", "Practitioner");
            ValidationSupport.checkReferenceType(medicationDispense.detectedIssue, "detectedIssue", "DetectedIssue");
            ValidationSupport.checkReferenceType(medicationDispense.eventHistory, "eventHistory", "Provenance");
        }

        protected Builder from(MedicationDispense medicationDispense) {
            super.from(medicationDispense);
            this.identifier.addAll(medicationDispense.identifier);
            this.partOf.addAll(medicationDispense.partOf);
            this.status = medicationDispense.status;
            this.statusReason = medicationDispense.statusReason;
            this.category = medicationDispense.category;
            this.medication = medicationDispense.medication;
            this.subject = medicationDispense.subject;
            this.context = medicationDispense.context;
            this.supportingInformation.addAll(medicationDispense.supportingInformation);
            this.performer.addAll(medicationDispense.performer);
            this.location = medicationDispense.location;
            this.authorizingPrescription.addAll(medicationDispense.authorizingPrescription);
            this.type = medicationDispense.type;
            this.quantity = medicationDispense.quantity;
            this.daysSupply = medicationDispense.daysSupply;
            this.whenPrepared = medicationDispense.whenPrepared;
            this.whenHandedOver = medicationDispense.whenHandedOver;
            this.destination = medicationDispense.destination;
            this.receiver.addAll(medicationDispense.receiver);
            this.note.addAll(medicationDispense.note);
            this.dosageInstruction.addAll(medicationDispense.dosageInstruction);
            this.substitution = medicationDispense.substitution;
            this.detectedIssue.addAll(medicationDispense.detectedIssue);
            this.eventHistory.addAll(medicationDispense.eventHistory);
            return this;
        }
    }
}

