/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicinalProductAuthorization
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"MedicinalProduct", "MedicinalProductPackaged"})
    private final Reference subject;
    @Summary
    private final List<CodeableConcept> country;
    @Summary
    private final List<CodeableConcept> jurisdiction;
    @Summary
    private final CodeableConcept status;
    @Summary
    private final DateTime statusDate;
    @Summary
    private final DateTime restoreDate;
    @Summary
    private final Period validityPeriod;
    @Summary
    private final Period dataExclusivityPeriod;
    @Summary
    private final DateTime dateOfFirstAuthorization;
    @Summary
    private final DateTime internationalBirthDate;
    @Summary
    private final CodeableConcept legalBasis;
    @Summary
    private final List<JurisdictionalAuthorization> jurisdictionalAuthorization;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference holder;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference regulator;
    @Summary
    private final Procedure procedure;

    private MedicinalProductAuthorization(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.subject = builder.subject;
        this.country = Collections.unmodifiableList(builder.country);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.status = builder.status;
        this.statusDate = builder.statusDate;
        this.restoreDate = builder.restoreDate;
        this.validityPeriod = builder.validityPeriod;
        this.dataExclusivityPeriod = builder.dataExclusivityPeriod;
        this.dateOfFirstAuthorization = builder.dateOfFirstAuthorization;
        this.internationalBirthDate = builder.internationalBirthDate;
        this.legalBasis = builder.legalBasis;
        this.jurisdictionalAuthorization = Collections.unmodifiableList(builder.jurisdictionalAuthorization);
        this.holder = builder.holder;
        this.regulator = builder.regulator;
        this.procedure = builder.procedure;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public List<CodeableConcept> getCountry() {
        return this.country;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public DateTime getStatusDate() {
        return this.statusDate;
    }

    public DateTime getRestoreDate() {
        return this.restoreDate;
    }

    public Period getValidityPeriod() {
        return this.validityPeriod;
    }

    public Period getDataExclusivityPeriod() {
        return this.dataExclusivityPeriod;
    }

    public DateTime getDateOfFirstAuthorization() {
        return this.dateOfFirstAuthorization;
    }

    public DateTime getInternationalBirthDate() {
        return this.internationalBirthDate;
    }

    public CodeableConcept getLegalBasis() {
        return this.legalBasis;
    }

    public List<JurisdictionalAuthorization> getJurisdictionalAuthorization() {
        return this.jurisdictionalAuthorization;
    }

    public Reference getHolder() {
        return this.holder;
    }

    public Reference getRegulator() {
        return this.regulator;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.subject != null || !this.country.isEmpty() || !this.jurisdiction.isEmpty() || this.status != null || this.statusDate != null || this.restoreDate != null || this.validityPeriod != null || this.dataExclusivityPeriod != null || this.dateOfFirstAuthorization != null || this.internationalBirthDate != null || this.legalBasis != null || !this.jurisdictionalAuthorization.isEmpty() || this.holder != null || this.regulator != null || this.procedure != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.country, "country", visitor, CodeableConcept.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusDate, "statusDate", visitor);
                this.accept(this.restoreDate, "restoreDate", visitor);
                this.accept(this.validityPeriod, "validityPeriod", visitor);
                this.accept(this.dataExclusivityPeriod, "dataExclusivityPeriod", visitor);
                this.accept(this.dateOfFirstAuthorization, "dateOfFirstAuthorization", visitor);
                this.accept(this.internationalBirthDate, "internationalBirthDate", visitor);
                this.accept(this.legalBasis, "legalBasis", visitor);
                this.accept(this.jurisdictionalAuthorization, "jurisdictionalAuthorization", visitor, JurisdictionalAuthorization.class);
                this.accept(this.holder, "holder", visitor);
                this.accept(this.regulator, "regulator", visitor);
                this.accept(this.procedure, "procedure", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductAuthorization other = (MedicinalProductAuthorization)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.subject, other.subject) && Objects.equals(this.country, other.country) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.status, other.status) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.restoreDate, other.restoreDate) && Objects.equals(this.validityPeriod, other.validityPeriod) && Objects.equals(this.dataExclusivityPeriod, other.dataExclusivityPeriod) && Objects.equals(this.dateOfFirstAuthorization, other.dateOfFirstAuthorization) && Objects.equals(this.internationalBirthDate, other.internationalBirthDate) && Objects.equals(this.legalBasis, other.legalBasis) && Objects.equals(this.jurisdictionalAuthorization, other.jurisdictionalAuthorization) && Objects.equals(this.holder, other.holder) && Objects.equals(this.regulator, other.regulator) && Objects.equals(this.procedure, other.procedure);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.subject, this.country, this.jurisdiction, this.status, this.statusDate, this.restoreDate, this.validityPeriod, this.dataExclusivityPeriod, this.dateOfFirstAuthorization, this.internationalBirthDate, this.legalBasis, this.jurisdictionalAuthorization, this.holder, this.regulator, this.procedure);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Procedure
    extends BackboneElement {
        @Summary
        private final Identifier identifier;
        @Summary
        @Required
        private final CodeableConcept type;
        @Summary
        @Choice(value={Period.class, DateTime.class})
        private final Element date;
        @Summary
        private final List<Procedure> application;

        private Procedure(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.type = builder.type;
            this.date = builder.date;
            this.application = Collections.unmodifiableList(builder.application);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getDate() {
            return this.date;
        }

        public List<Procedure> getApplication() {
            return this.application;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.type != null || this.date != null || !this.application.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.application, "application", visitor, Procedure.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Procedure other = (Procedure)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.date, other.date) && Objects.equals(this.application, other.application);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.type, this.date, this.application);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier identifier;
            private CodeableConcept type;
            private Element date;
            private List<Procedure> application = new ArrayList<Procedure>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder date(Element date) {
                this.date = date;
                return this;
            }

            public Builder application(Procedure ... application) {
                for (Procedure value : application) {
                    this.application.add(value);
                }
                return this;
            }

            public Builder application(Collection<Procedure> application) {
                this.application = new ArrayList<Procedure>(application);
                return this;
            }

            @Override
            public Procedure build() {
                Procedure procedure = new Procedure(this);
                if (this.validating) {
                    this.validate(procedure);
                }
                return procedure;
            }

            protected void validate(Procedure procedure) {
                super.validate(procedure);
                ValidationSupport.requireNonNull(procedure.type, "type");
                ValidationSupport.choiceElement(procedure.date, "date", Period.class, DateTime.class);
                ValidationSupport.checkList(procedure.application, "application", Procedure.class);
                ValidationSupport.requireValueOrChildren(procedure);
            }

            protected Builder from(Procedure procedure) {
                super.from(procedure);
                this.identifier = procedure.identifier;
                this.type = procedure.type;
                this.date = procedure.date;
                this.application.addAll(procedure.application);
                return this;
            }
        }
    }

    public static class JurisdictionalAuthorization
    extends BackboneElement {
        @Summary
        private final List<Identifier> identifier;
        @Summary
        private final CodeableConcept country;
        @Summary
        private final List<CodeableConcept> jurisdiction;
        @Summary
        private final CodeableConcept legalStatusOfSupply;
        @Summary
        private final Period validityPeriod;

        private JurisdictionalAuthorization(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.country = builder.country;
            this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
            this.legalStatusOfSupply = builder.legalStatusOfSupply;
            this.validityPeriod = builder.validityPeriod;
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getCountry() {
            return this.country;
        }

        public List<CodeableConcept> getJurisdiction() {
            return this.jurisdiction;
        }

        public CodeableConcept getLegalStatusOfSupply() {
            return this.legalStatusOfSupply;
        }

        public Period getValidityPeriod() {
            return this.validityPeriod;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || this.country != null || !this.jurisdiction.isEmpty() || this.legalStatusOfSupply != null || this.validityPeriod != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.country, "country", visitor);
                    this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                    this.accept(this.legalStatusOfSupply, "legalStatusOfSupply", visitor);
                    this.accept(this.validityPeriod, "validityPeriod", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JurisdictionalAuthorization other = (JurisdictionalAuthorization)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.country, other.country) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.legalStatusOfSupply, other.legalStatusOfSupply) && Objects.equals(this.validityPeriod, other.validityPeriod);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.country, this.jurisdiction, this.legalStatusOfSupply, this.validityPeriod);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private CodeableConcept country;
            private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
            private CodeableConcept legalStatusOfSupply;
            private Period validityPeriod;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder country(CodeableConcept country) {
                this.country = country;
                return this;
            }

            public Builder jurisdiction(CodeableConcept ... jurisdiction) {
                for (CodeableConcept value : jurisdiction) {
                    this.jurisdiction.add(value);
                }
                return this;
            }

            public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
                this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
                return this;
            }

            public Builder legalStatusOfSupply(CodeableConcept legalStatusOfSupply) {
                this.legalStatusOfSupply = legalStatusOfSupply;
                return this;
            }

            public Builder validityPeriod(Period validityPeriod) {
                this.validityPeriod = validityPeriod;
                return this;
            }

            @Override
            public JurisdictionalAuthorization build() {
                JurisdictionalAuthorization jurisdictionalAuthorization = new JurisdictionalAuthorization(this);
                if (this.validating) {
                    this.validate(jurisdictionalAuthorization);
                }
                return jurisdictionalAuthorization;
            }

            protected void validate(JurisdictionalAuthorization jurisdictionalAuthorization) {
                super.validate(jurisdictionalAuthorization);
                ValidationSupport.checkList(jurisdictionalAuthorization.identifier, "identifier", Identifier.class);
                ValidationSupport.checkList(jurisdictionalAuthorization.jurisdiction, "jurisdiction", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(jurisdictionalAuthorization);
            }

            protected Builder from(JurisdictionalAuthorization jurisdictionalAuthorization) {
                super.from(jurisdictionalAuthorization);
                this.identifier.addAll(jurisdictionalAuthorization.identifier);
                this.country = jurisdictionalAuthorization.country;
                this.jurisdiction.addAll(jurisdictionalAuthorization.jurisdiction);
                this.legalStatusOfSupply = jurisdictionalAuthorization.legalStatusOfSupply;
                this.validityPeriod = jurisdictionalAuthorization.validityPeriod;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Reference subject;
        private List<CodeableConcept> country = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private CodeableConcept status;
        private DateTime statusDate;
        private DateTime restoreDate;
        private Period validityPeriod;
        private Period dataExclusivityPeriod;
        private DateTime dateOfFirstAuthorization;
        private DateTime internationalBirthDate;
        private CodeableConcept legalBasis;
        private List<JurisdictionalAuthorization> jurisdictionalAuthorization = new ArrayList<JurisdictionalAuthorization>();
        private Reference holder;
        private Reference regulator;
        private Procedure procedure;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder country(CodeableConcept ... country) {
            for (CodeableConcept value : country) {
                this.country.add(value);
            }
            return this;
        }

        public Builder country(Collection<CodeableConcept> country) {
            this.country = new ArrayList<CodeableConcept>(country);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder statusDate(DateTime statusDate) {
            this.statusDate = statusDate;
            return this;
        }

        public Builder restoreDate(DateTime restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public Builder validityPeriod(Period validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public Builder dataExclusivityPeriod(Period dataExclusivityPeriod) {
            this.dataExclusivityPeriod = dataExclusivityPeriod;
            return this;
        }

        public Builder dateOfFirstAuthorization(DateTime dateOfFirstAuthorization) {
            this.dateOfFirstAuthorization = dateOfFirstAuthorization;
            return this;
        }

        public Builder internationalBirthDate(DateTime internationalBirthDate) {
            this.internationalBirthDate = internationalBirthDate;
            return this;
        }

        public Builder legalBasis(CodeableConcept legalBasis) {
            this.legalBasis = legalBasis;
            return this;
        }

        public Builder jurisdictionalAuthorization(JurisdictionalAuthorization ... jurisdictionalAuthorization) {
            for (JurisdictionalAuthorization value : jurisdictionalAuthorization) {
                this.jurisdictionalAuthorization.add(value);
            }
            return this;
        }

        public Builder jurisdictionalAuthorization(Collection<JurisdictionalAuthorization> jurisdictionalAuthorization) {
            this.jurisdictionalAuthorization = new ArrayList<JurisdictionalAuthorization>(jurisdictionalAuthorization);
            return this;
        }

        public Builder holder(Reference holder) {
            this.holder = holder;
            return this;
        }

        public Builder regulator(Reference regulator) {
            this.regulator = regulator;
            return this;
        }

        public Builder procedure(Procedure procedure) {
            this.procedure = procedure;
            return this;
        }

        @Override
        public MedicinalProductAuthorization build() {
            MedicinalProductAuthorization medicinalProductAuthorization = new MedicinalProductAuthorization(this);
            if (this.validating) {
                this.validate(medicinalProductAuthorization);
            }
            return medicinalProductAuthorization;
        }

        protected void validate(MedicinalProductAuthorization medicinalProductAuthorization) {
            super.validate(medicinalProductAuthorization);
            ValidationSupport.checkList(medicinalProductAuthorization.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(medicinalProductAuthorization.country, "country", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductAuthorization.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductAuthorization.jurisdictionalAuthorization, "jurisdictionalAuthorization", JurisdictionalAuthorization.class);
            ValidationSupport.checkReferenceType(medicinalProductAuthorization.subject, "subject", "MedicinalProduct", "MedicinalProductPackaged");
            ValidationSupport.checkReferenceType(medicinalProductAuthorization.holder, "holder", "Organization");
            ValidationSupport.checkReferenceType(medicinalProductAuthorization.regulator, "regulator", "Organization");
        }

        protected Builder from(MedicinalProductAuthorization medicinalProductAuthorization) {
            super.from(medicinalProductAuthorization);
            this.identifier.addAll(medicinalProductAuthorization.identifier);
            this.subject = medicinalProductAuthorization.subject;
            this.country.addAll(medicinalProductAuthorization.country);
            this.jurisdiction.addAll(medicinalProductAuthorization.jurisdiction);
            this.status = medicinalProductAuthorization.status;
            this.statusDate = medicinalProductAuthorization.statusDate;
            this.restoreDate = medicinalProductAuthorization.restoreDate;
            this.validityPeriod = medicinalProductAuthorization.validityPeriod;
            this.dataExclusivityPeriod = medicinalProductAuthorization.dataExclusivityPeriod;
            this.dateOfFirstAuthorization = medicinalProductAuthorization.dateOfFirstAuthorization;
            this.internationalBirthDate = medicinalProductAuthorization.internationalBirthDate;
            this.legalBasis = medicinalProductAuthorization.legalBasis;
            this.jurisdictionalAuthorization.addAll(medicinalProductAuthorization.jurisdictionalAuthorization);
            this.holder = medicinalProductAuthorization.holder;
            this.regulator = medicinalProductAuthorization.regulator;
            this.procedure = medicinalProductAuthorization.procedure;
            return this;
        }
    }
}

