/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.NutritionOrderIntent;
import com.ibm.fhir.model.type.code.NutritionOrderStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="nor-1", level="Warning", location="(base)", description="Nutrition Order SHALL contain either Oral Diet , Supplement, or Enteral Formula class", expression="oralDiet.exists() or supplement.exists() or enteralFormula.exists()", source="http://hl7.org/fhir/StructureDefinition/NutritionOrder"), @Constraint(id="nutritionOrder-2", level="Warning", location="enteralFormula.routeofAdministration", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/enteral-route", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/enteral-route', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/NutritionOrder", generated=true)})
public class NutritionOrder
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    private final List<Uri> instantiates;
    @Summary
    @Binding(bindingName="NutritionOrderStatus", strength=BindingStrength.Value.REQUIRED, description="Codes identifying the lifecycle stage of the nutrition order.", valueSet="http://hl7.org/fhir/ValueSet/request-status|4.0.1")
    @Required
    private final NutritionOrderStatus status;
    @Summary
    @Binding(bindingName="NutritiionOrderIntent", strength=BindingStrength.Value.REQUIRED, description="Codes indicating the degree of authority/intentionality associated with a nutrition order.", valueSet="http://hl7.org/fhir/ValueSet/request-intent|4.0.1")
    @Required
    private final NutritionOrderIntent intent;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Required
    private final DateTime dateTime;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference orderer;
    @ReferenceTarget(value={"AllergyIntolerance"})
    private final List<Reference> allergyIntolerance;
    @Binding(bindingName="PatientDiet", strength=BindingStrength.Value.EXAMPLE, description="Medical, cultural or ethical food preferences to help with catering requirements.", valueSet="http://hl7.org/fhir/ValueSet/encounter-diet")
    private final List<CodeableConcept> foodPreferenceModifier;
    @Binding(bindingName="FoodType", strength=BindingStrength.Value.EXAMPLE, description="Codes used to indicate the type of food that should NOT be given to the patient.", valueSet="http://hl7.org/fhir/ValueSet/food-type")
    private final List<CodeableConcept> excludeFoodModifier;
    private final OralDiet oralDiet;
    private final List<Supplement> supplement;
    private final EnteralFormula enteralFormula;
    private final List<Annotation> note;

    private NutritionOrder(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.instantiatesCanonical = Collections.unmodifiableList(builder.instantiatesCanonical);
        this.instantiatesUri = Collections.unmodifiableList(builder.instantiatesUri);
        this.instantiates = Collections.unmodifiableList(builder.instantiates);
        this.status = builder.status;
        this.intent = builder.intent;
        this.patient = builder.patient;
        this.encounter = builder.encounter;
        this.dateTime = builder.dateTime;
        this.orderer = builder.orderer;
        this.allergyIntolerance = Collections.unmodifiableList(builder.allergyIntolerance);
        this.foodPreferenceModifier = Collections.unmodifiableList(builder.foodPreferenceModifier);
        this.excludeFoodModifier = Collections.unmodifiableList(builder.excludeFoodModifier);
        this.oralDiet = builder.oralDiet;
        this.supplement = Collections.unmodifiableList(builder.supplement);
        this.enteralFormula = builder.enteralFormula;
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Uri> getInstantiates() {
        return this.instantiates;
    }

    public NutritionOrderStatus getStatus() {
        return this.status;
    }

    public NutritionOrderIntent getIntent() {
        return this.intent;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public Reference getOrderer() {
        return this.orderer;
    }

    public List<Reference> getAllergyIntolerance() {
        return this.allergyIntolerance;
    }

    public List<CodeableConcept> getFoodPreferenceModifier() {
        return this.foodPreferenceModifier;
    }

    public List<CodeableConcept> getExcludeFoodModifier() {
        return this.excludeFoodModifier;
    }

    public OralDiet getOralDiet() {
        return this.oralDiet;
    }

    public List<Supplement> getSupplement() {
        return this.supplement;
    }

    public EnteralFormula getEnteralFormula() {
        return this.enteralFormula;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || !this.instantiates.isEmpty() || this.status != null || this.intent != null || this.patient != null || this.encounter != null || this.dateTime != null || this.orderer != null || !this.allergyIntolerance.isEmpty() || !this.foodPreferenceModifier.isEmpty() || !this.excludeFoodModifier.isEmpty() || this.oralDiet != null || !this.supplement.isEmpty() || this.enteralFormula != null || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.instantiates, "instantiates", visitor, Uri.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.dateTime, "dateTime", visitor);
                this.accept(this.orderer, "orderer", visitor);
                this.accept(this.allergyIntolerance, "allergyIntolerance", visitor, Reference.class);
                this.accept(this.foodPreferenceModifier, "foodPreferenceModifier", visitor, CodeableConcept.class);
                this.accept(this.excludeFoodModifier, "excludeFoodModifier", visitor, CodeableConcept.class);
                this.accept(this.oralDiet, "oralDiet", visitor);
                this.accept(this.supplement, "supplement", visitor, Supplement.class);
                this.accept(this.enteralFormula, "enteralFormula", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutritionOrder other = (NutritionOrder)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.instantiates, other.instantiates) && Objects.equals(this.status, other.status) && Objects.equals(this.intent, other.intent) && Objects.equals(this.patient, other.patient) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.dateTime, other.dateTime) && Objects.equals(this.orderer, other.orderer) && Objects.equals(this.allergyIntolerance, other.allergyIntolerance) && Objects.equals(this.foodPreferenceModifier, other.foodPreferenceModifier) && Objects.equals(this.excludeFoodModifier, other.excludeFoodModifier) && Objects.equals(this.oralDiet, other.oralDiet) && Objects.equals(this.supplement, other.supplement) && Objects.equals(this.enteralFormula, other.enteralFormula) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.instantiates, this.status, this.intent, this.patient, this.encounter, this.dateTime, this.orderer, this.allergyIntolerance, this.foodPreferenceModifier, this.excludeFoodModifier, this.oralDiet, this.supplement, this.enteralFormula, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class EnteralFormula
    extends BackboneElement {
        @Summary
        @Binding(bindingName="EnteralFormulaType", strength=BindingStrength.Value.EXAMPLE, description="Codes for type of enteral formula to be administered to patient.", valueSet="http://hl7.org/fhir/ValueSet/entformula-type")
        private final CodeableConcept baseFormulaType;
        private final String baseFormulaProductName;
        @Binding(bindingName="EnteralFormulaAdditiveType", strength=BindingStrength.Value.EXAMPLE, description="Codes for the type of modular component such as protein, carbohydrate or fiber to be provided in addition to or mixed with the base formula.", valueSet="http://hl7.org/fhir/ValueSet/entformula-additive")
        private final CodeableConcept additiveType;
        private final String additiveProductName;
        private final SimpleQuantity caloricDensity;
        @Binding(bindingName="EnteralRouteOfAdministration", strength=BindingStrength.Value.EXTENSIBLE, description="Codes specifying the route of administration of enteral formula.", valueSet="http://hl7.org/fhir/ValueSet/enteral-route")
        private final CodeableConcept routeofAdministration;
        private final List<Administration> administration;
        private final SimpleQuantity maxVolumeToDeliver;
        @Summary
        private final String administrationInstruction;

        private EnteralFormula(Builder builder) {
            super(builder);
            this.baseFormulaType = builder.baseFormulaType;
            this.baseFormulaProductName = builder.baseFormulaProductName;
            this.additiveType = builder.additiveType;
            this.additiveProductName = builder.additiveProductName;
            this.caloricDensity = builder.caloricDensity;
            this.routeofAdministration = builder.routeofAdministration;
            this.administration = Collections.unmodifiableList(builder.administration);
            this.maxVolumeToDeliver = builder.maxVolumeToDeliver;
            this.administrationInstruction = builder.administrationInstruction;
        }

        public CodeableConcept getBaseFormulaType() {
            return this.baseFormulaType;
        }

        public String getBaseFormulaProductName() {
            return this.baseFormulaProductName;
        }

        public CodeableConcept getAdditiveType() {
            return this.additiveType;
        }

        public String getAdditiveProductName() {
            return this.additiveProductName;
        }

        public SimpleQuantity getCaloricDensity() {
            return this.caloricDensity;
        }

        public CodeableConcept getRouteofAdministration() {
            return this.routeofAdministration;
        }

        public List<Administration> getAdministration() {
            return this.administration;
        }

        public SimpleQuantity getMaxVolumeToDeliver() {
            return this.maxVolumeToDeliver;
        }

        public String getAdministrationInstruction() {
            return this.administrationInstruction;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.baseFormulaType != null || this.baseFormulaProductName != null || this.additiveType != null || this.additiveProductName != null || this.caloricDensity != null || this.routeofAdministration != null || !this.administration.isEmpty() || this.maxVolumeToDeliver != null || this.administrationInstruction != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.baseFormulaType, "baseFormulaType", visitor);
                    this.accept(this.baseFormulaProductName, "baseFormulaProductName", visitor);
                    this.accept(this.additiveType, "additiveType", visitor);
                    this.accept(this.additiveProductName, "additiveProductName", visitor);
                    this.accept(this.caloricDensity, "caloricDensity", visitor);
                    this.accept(this.routeofAdministration, "routeofAdministration", visitor);
                    this.accept(this.administration, "administration", visitor, Administration.class);
                    this.accept(this.maxVolumeToDeliver, "maxVolumeToDeliver", visitor);
                    this.accept(this.administrationInstruction, "administrationInstruction", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnteralFormula other = (EnteralFormula)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.baseFormulaType, other.baseFormulaType) && Objects.equals(this.baseFormulaProductName, other.baseFormulaProductName) && Objects.equals(this.additiveType, other.additiveType) && Objects.equals(this.additiveProductName, other.additiveProductName) && Objects.equals(this.caloricDensity, other.caloricDensity) && Objects.equals(this.routeofAdministration, other.routeofAdministration) && Objects.equals(this.administration, other.administration) && Objects.equals(this.maxVolumeToDeliver, other.maxVolumeToDeliver) && Objects.equals(this.administrationInstruction, other.administrationInstruction);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.baseFormulaType, this.baseFormulaProductName, this.additiveType, this.additiveProductName, this.caloricDensity, this.routeofAdministration, this.administration, this.maxVolumeToDeliver, this.administrationInstruction);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Administration
        extends BackboneElement {
            private final Timing schedule;
            private final SimpleQuantity quantity;
            @Choice(value={SimpleQuantity.class, Ratio.class})
            private final Element rate;

            private Administration(Builder builder) {
                super(builder);
                this.schedule = builder.schedule;
                this.quantity = builder.quantity;
                this.rate = builder.rate;
            }

            public Timing getSchedule() {
                return this.schedule;
            }

            public SimpleQuantity getQuantity() {
                return this.quantity;
            }

            public Element getRate() {
                return this.rate;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.schedule != null || this.quantity != null || this.rate != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.schedule, "schedule", visitor);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.rate, "rate", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Administration other = (Administration)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.rate, other.rate);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.schedule, this.quantity, this.rate);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Timing schedule;
                private SimpleQuantity quantity;
                private Element rate;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder schedule(Timing schedule) {
                    this.schedule = schedule;
                    return this;
                }

                public Builder quantity(SimpleQuantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder rate(Element rate) {
                    this.rate = rate;
                    return this;
                }

                @Override
                public Administration build() {
                    Administration administration = new Administration(this);
                    if (this.validating) {
                        this.validate(administration);
                    }
                    return administration;
                }

                protected void validate(Administration administration) {
                    super.validate(administration);
                    ValidationSupport.choiceElement(administration.rate, "rate", SimpleQuantity.class, Ratio.class);
                    ValidationSupport.requireValueOrChildren(administration);
                }

                protected Builder from(Administration administration) {
                    super.from(administration);
                    this.schedule = administration.schedule;
                    this.quantity = administration.quantity;
                    this.rate = administration.rate;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept baseFormulaType;
            private String baseFormulaProductName;
            private CodeableConcept additiveType;
            private String additiveProductName;
            private SimpleQuantity caloricDensity;
            private CodeableConcept routeofAdministration;
            private List<Administration> administration = new ArrayList<Administration>();
            private SimpleQuantity maxVolumeToDeliver;
            private String administrationInstruction;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder baseFormulaType(CodeableConcept baseFormulaType) {
                this.baseFormulaType = baseFormulaType;
                return this;
            }

            public Builder baseFormulaProductName(java.lang.String baseFormulaProductName) {
                this.baseFormulaProductName = baseFormulaProductName == null ? null : String.of(baseFormulaProductName);
                return this;
            }

            public Builder baseFormulaProductName(String baseFormulaProductName) {
                this.baseFormulaProductName = baseFormulaProductName;
                return this;
            }

            public Builder additiveType(CodeableConcept additiveType) {
                this.additiveType = additiveType;
                return this;
            }

            public Builder additiveProductName(java.lang.String additiveProductName) {
                this.additiveProductName = additiveProductName == null ? null : String.of(additiveProductName);
                return this;
            }

            public Builder additiveProductName(String additiveProductName) {
                this.additiveProductName = additiveProductName;
                return this;
            }

            public Builder caloricDensity(SimpleQuantity caloricDensity) {
                this.caloricDensity = caloricDensity;
                return this;
            }

            public Builder routeofAdministration(CodeableConcept routeofAdministration) {
                this.routeofAdministration = routeofAdministration;
                return this;
            }

            public Builder administration(Administration ... administration) {
                for (Administration value : administration) {
                    this.administration.add(value);
                }
                return this;
            }

            public Builder administration(Collection<Administration> administration) {
                this.administration = new ArrayList<Administration>(administration);
                return this;
            }

            public Builder maxVolumeToDeliver(SimpleQuantity maxVolumeToDeliver) {
                this.maxVolumeToDeliver = maxVolumeToDeliver;
                return this;
            }

            public Builder administrationInstruction(java.lang.String administrationInstruction) {
                this.administrationInstruction = administrationInstruction == null ? null : String.of(administrationInstruction);
                return this;
            }

            public Builder administrationInstruction(String administrationInstruction) {
                this.administrationInstruction = administrationInstruction;
                return this;
            }

            @Override
            public EnteralFormula build() {
                EnteralFormula enteralFormula = new EnteralFormula(this);
                if (this.validating) {
                    this.validate(enteralFormula);
                }
                return enteralFormula;
            }

            protected void validate(EnteralFormula enteralFormula) {
                super.validate(enteralFormula);
                ValidationSupport.checkList(enteralFormula.administration, "administration", Administration.class);
                ValidationSupport.requireValueOrChildren(enteralFormula);
            }

            protected Builder from(EnteralFormula enteralFormula) {
                super.from(enteralFormula);
                this.baseFormulaType = enteralFormula.baseFormulaType;
                this.baseFormulaProductName = enteralFormula.baseFormulaProductName;
                this.additiveType = enteralFormula.additiveType;
                this.additiveProductName = enteralFormula.additiveProductName;
                this.caloricDensity = enteralFormula.caloricDensity;
                this.routeofAdministration = enteralFormula.routeofAdministration;
                this.administration.addAll(enteralFormula.administration);
                this.maxVolumeToDeliver = enteralFormula.maxVolumeToDeliver;
                this.administrationInstruction = enteralFormula.administrationInstruction;
                return this;
            }
        }
    }

    public static class Supplement
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SupplementType", strength=BindingStrength.Value.EXAMPLE, description="Codes for nutritional supplements to be provided to the patient.", valueSet="http://hl7.org/fhir/ValueSet/supplement-type")
        private final CodeableConcept type;
        private final String productName;
        private final List<Timing> schedule;
        private final SimpleQuantity quantity;
        @Summary
        private final String instruction;

        private Supplement(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.productName = builder.productName;
            this.schedule = Collections.unmodifiableList(builder.schedule);
            this.quantity = builder.quantity;
            this.instruction = builder.instruction;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public String getProductName() {
            return this.productName;
        }

        public List<Timing> getSchedule() {
            return this.schedule;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public String getInstruction() {
            return this.instruction;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.productName != null || !this.schedule.isEmpty() || this.quantity != null || this.instruction != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.productName, "productName", visitor);
                    this.accept(this.schedule, "schedule", visitor, Timing.class);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.instruction, "instruction", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Supplement other = (Supplement)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.productName, other.productName) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.instruction, other.instruction);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.productName, this.schedule, this.quantity, this.instruction);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private String productName;
            private List<Timing> schedule = new ArrayList<Timing>();
            private SimpleQuantity quantity;
            private String instruction;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder productName(java.lang.String productName) {
                this.productName = productName == null ? null : String.of(productName);
                return this;
            }

            public Builder productName(String productName) {
                this.productName = productName;
                return this;
            }

            public Builder schedule(Timing ... schedule) {
                for (Timing value : schedule) {
                    this.schedule.add(value);
                }
                return this;
            }

            public Builder schedule(Collection<Timing> schedule) {
                this.schedule = new ArrayList<Timing>(schedule);
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder instruction(java.lang.String instruction) {
                this.instruction = instruction == null ? null : String.of(instruction);
                return this;
            }

            public Builder instruction(String instruction) {
                this.instruction = instruction;
                return this;
            }

            @Override
            public Supplement build() {
                Supplement supplement = new Supplement(this);
                if (this.validating) {
                    this.validate(supplement);
                }
                return supplement;
            }

            protected void validate(Supplement supplement) {
                super.validate(supplement);
                ValidationSupport.checkList(supplement.schedule, "schedule", Timing.class);
                ValidationSupport.requireValueOrChildren(supplement);
            }

            protected Builder from(Supplement supplement) {
                super.from(supplement);
                this.type = supplement.type;
                this.productName = supplement.productName;
                this.schedule.addAll(supplement.schedule);
                this.quantity = supplement.quantity;
                this.instruction = supplement.instruction;
                return this;
            }
        }
    }

    public static class OralDiet
    extends BackboneElement {
        @Summary
        @Binding(bindingName="OralDiet", strength=BindingStrength.Value.EXAMPLE, description="Codes used to indicate the type of diet being ordered for a patient.", valueSet="http://hl7.org/fhir/ValueSet/diet-type")
        private final List<CodeableConcept> type;
        private final List<Timing> schedule;
        private final List<Nutrient> nutrient;
        private final List<Texture> texture;
        @Binding(bindingName="FluidConsistencyType", strength=BindingStrength.Value.EXAMPLE, description="Codes used to represent the consistency of fluids and liquids provided to the patient.", valueSet="http://hl7.org/fhir/ValueSet/consistency-type")
        private final List<CodeableConcept> fluidConsistencyType;
        @Summary
        private final String instruction;

        private OralDiet(Builder builder) {
            super(builder);
            this.type = Collections.unmodifiableList(builder.type);
            this.schedule = Collections.unmodifiableList(builder.schedule);
            this.nutrient = Collections.unmodifiableList(builder.nutrient);
            this.texture = Collections.unmodifiableList(builder.texture);
            this.fluidConsistencyType = Collections.unmodifiableList(builder.fluidConsistencyType);
            this.instruction = builder.instruction;
        }

        public List<CodeableConcept> getType() {
            return this.type;
        }

        public List<Timing> getSchedule() {
            return this.schedule;
        }

        public List<Nutrient> getNutrient() {
            return this.nutrient;
        }

        public List<Texture> getTexture() {
            return this.texture;
        }

        public List<CodeableConcept> getFluidConsistencyType() {
            return this.fluidConsistencyType;
        }

        public String getInstruction() {
            return this.instruction;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.type.isEmpty() || !this.schedule.isEmpty() || !this.nutrient.isEmpty() || !this.texture.isEmpty() || !this.fluidConsistencyType.isEmpty() || this.instruction != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor, CodeableConcept.class);
                    this.accept(this.schedule, "schedule", visitor, Timing.class);
                    this.accept(this.nutrient, "nutrient", visitor, Nutrient.class);
                    this.accept(this.texture, "texture", visitor, Texture.class);
                    this.accept(this.fluidConsistencyType, "fluidConsistencyType", visitor, CodeableConcept.class);
                    this.accept(this.instruction, "instruction", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OralDiet other = (OralDiet)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.nutrient, other.nutrient) && Objects.equals(this.texture, other.texture) && Objects.equals(this.fluidConsistencyType, other.fluidConsistencyType) && Objects.equals(this.instruction, other.instruction);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.schedule, this.nutrient, this.texture, this.fluidConsistencyType, this.instruction);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Texture
        extends BackboneElement {
            @Binding(bindingName="TextureModifier", strength=BindingStrength.Value.EXAMPLE, description="Codes for food consistency types or texture modifications to apply to foods.", valueSet="http://hl7.org/fhir/ValueSet/texture-code")
            private final CodeableConcept modifier;
            @Binding(bindingName="TextureModifiedFoodType", strength=BindingStrength.Value.EXAMPLE, description="Codes for types of foods that are texture-modified.", valueSet="http://hl7.org/fhir/ValueSet/modified-foodtype")
            private final CodeableConcept foodType;

            private Texture(Builder builder) {
                super(builder);
                this.modifier = builder.modifier;
                this.foodType = builder.foodType;
            }

            public CodeableConcept getModifier() {
                return this.modifier;
            }

            public CodeableConcept getFoodType() {
                return this.foodType;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.modifier != null || this.foodType != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.modifier, "modifier", visitor);
                        this.accept(this.foodType, "foodType", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Texture other = (Texture)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.foodType, other.foodType);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.modifier, this.foodType);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept modifier;
                private CodeableConcept foodType;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder modifier(CodeableConcept modifier) {
                    this.modifier = modifier;
                    return this;
                }

                public Builder foodType(CodeableConcept foodType) {
                    this.foodType = foodType;
                    return this;
                }

                @Override
                public Texture build() {
                    Texture texture = new Texture(this);
                    if (this.validating) {
                        this.validate(texture);
                    }
                    return texture;
                }

                protected void validate(Texture texture) {
                    super.validate(texture);
                    ValidationSupport.requireValueOrChildren(texture);
                }

                protected Builder from(Texture texture) {
                    super.from(texture);
                    this.modifier = texture.modifier;
                    this.foodType = texture.foodType;
                    return this;
                }
            }
        }

        public static class Nutrient
        extends BackboneElement {
            @Binding(bindingName="NutrientModifier", strength=BindingStrength.Value.EXAMPLE, description="Codes for types of nutrients that are being modified such as carbohydrate or sodium.", valueSet="http://hl7.org/fhir/ValueSet/nutrient-code")
            private final CodeableConcept modifier;
            private final SimpleQuantity amount;

            private Nutrient(Builder builder) {
                super(builder);
                this.modifier = builder.modifier;
                this.amount = builder.amount;
            }

            public CodeableConcept getModifier() {
                return this.modifier;
            }

            public SimpleQuantity getAmount() {
                return this.amount;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.modifier != null || this.amount != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.modifier, "modifier", visitor);
                        this.accept(this.amount, "amount", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Nutrient other = (Nutrient)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.amount, other.amount);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.modifier, this.amount);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept modifier;
                private SimpleQuantity amount;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder modifier(CodeableConcept modifier) {
                    this.modifier = modifier;
                    return this;
                }

                public Builder amount(SimpleQuantity amount) {
                    this.amount = amount;
                    return this;
                }

                @Override
                public Nutrient build() {
                    Nutrient nutrient = new Nutrient(this);
                    if (this.validating) {
                        this.validate(nutrient);
                    }
                    return nutrient;
                }

                protected void validate(Nutrient nutrient) {
                    super.validate(nutrient);
                    ValidationSupport.requireValueOrChildren(nutrient);
                }

                protected Builder from(Nutrient nutrient) {
                    super.from(nutrient);
                    this.modifier = nutrient.modifier;
                    this.amount = nutrient.amount;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
            private List<Timing> schedule = new ArrayList<Timing>();
            private List<Nutrient> nutrient = new ArrayList<Nutrient>();
            private List<Texture> texture = new ArrayList<Texture>();
            private List<CodeableConcept> fluidConsistencyType = new ArrayList<CodeableConcept>();
            private String instruction;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept ... type) {
                for (CodeableConcept value : type) {
                    this.type.add(value);
                }
                return this;
            }

            public Builder type(Collection<CodeableConcept> type) {
                this.type = new ArrayList<CodeableConcept>(type);
                return this;
            }

            public Builder schedule(Timing ... schedule) {
                for (Timing value : schedule) {
                    this.schedule.add(value);
                }
                return this;
            }

            public Builder schedule(Collection<Timing> schedule) {
                this.schedule = new ArrayList<Timing>(schedule);
                return this;
            }

            public Builder nutrient(Nutrient ... nutrient) {
                for (Nutrient value : nutrient) {
                    this.nutrient.add(value);
                }
                return this;
            }

            public Builder nutrient(Collection<Nutrient> nutrient) {
                this.nutrient = new ArrayList<Nutrient>(nutrient);
                return this;
            }

            public Builder texture(Texture ... texture) {
                for (Texture value : texture) {
                    this.texture.add(value);
                }
                return this;
            }

            public Builder texture(Collection<Texture> texture) {
                this.texture = new ArrayList<Texture>(texture);
                return this;
            }

            public Builder fluidConsistencyType(CodeableConcept ... fluidConsistencyType) {
                for (CodeableConcept value : fluidConsistencyType) {
                    this.fluidConsistencyType.add(value);
                }
                return this;
            }

            public Builder fluidConsistencyType(Collection<CodeableConcept> fluidConsistencyType) {
                this.fluidConsistencyType = new ArrayList<CodeableConcept>(fluidConsistencyType);
                return this;
            }

            public Builder instruction(java.lang.String instruction) {
                this.instruction = instruction == null ? null : String.of(instruction);
                return this;
            }

            public Builder instruction(String instruction) {
                this.instruction = instruction;
                return this;
            }

            @Override
            public OralDiet build() {
                OralDiet oralDiet = new OralDiet(this);
                if (this.validating) {
                    this.validate(oralDiet);
                }
                return oralDiet;
            }

            protected void validate(OralDiet oralDiet) {
                super.validate(oralDiet);
                ValidationSupport.checkList(oralDiet.type, "type", CodeableConcept.class);
                ValidationSupport.checkList(oralDiet.schedule, "schedule", Timing.class);
                ValidationSupport.checkList(oralDiet.nutrient, "nutrient", Nutrient.class);
                ValidationSupport.checkList(oralDiet.texture, "texture", Texture.class);
                ValidationSupport.checkList(oralDiet.fluidConsistencyType, "fluidConsistencyType", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(oralDiet);
            }

            protected Builder from(OralDiet oralDiet) {
                super.from(oralDiet);
                this.type.addAll(oralDiet.type);
                this.schedule.addAll(oralDiet.schedule);
                this.nutrient.addAll(oralDiet.nutrient);
                this.texture.addAll(oralDiet.texture);
                this.fluidConsistencyType.addAll(oralDiet.fluidConsistencyType);
                this.instruction = oralDiet.instruction;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private List<Uri> instantiates = new ArrayList<Uri>();
        private NutritionOrderStatus status;
        private NutritionOrderIntent intent;
        private Reference patient;
        private Reference encounter;
        private DateTime dateTime;
        private Reference orderer;
        private List<Reference> allergyIntolerance = new ArrayList<Reference>();
        private List<CodeableConcept> foodPreferenceModifier = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> excludeFoodModifier = new ArrayList<CodeableConcept>();
        private OralDiet oralDiet;
        private List<Supplement> supplement = new ArrayList<Supplement>();
        private EnteralFormula enteralFormula;
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder instantiates(Uri ... instantiates) {
            for (Uri value : instantiates) {
                this.instantiates.add(value);
            }
            return this;
        }

        public Builder instantiates(Collection<Uri> instantiates) {
            this.instantiates = new ArrayList<Uri>(instantiates);
            return this;
        }

        public Builder status(NutritionOrderStatus status) {
            this.status = status;
            return this;
        }

        public Builder intent(NutritionOrderIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder dateTime(DateTime dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public Builder orderer(Reference orderer) {
            this.orderer = orderer;
            return this;
        }

        public Builder allergyIntolerance(Reference ... allergyIntolerance) {
            for (Reference value : allergyIntolerance) {
                this.allergyIntolerance.add(value);
            }
            return this;
        }

        public Builder allergyIntolerance(Collection<Reference> allergyIntolerance) {
            this.allergyIntolerance = new ArrayList<Reference>(allergyIntolerance);
            return this;
        }

        public Builder foodPreferenceModifier(CodeableConcept ... foodPreferenceModifier) {
            for (CodeableConcept value : foodPreferenceModifier) {
                this.foodPreferenceModifier.add(value);
            }
            return this;
        }

        public Builder foodPreferenceModifier(Collection<CodeableConcept> foodPreferenceModifier) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>(foodPreferenceModifier);
            return this;
        }

        public Builder excludeFoodModifier(CodeableConcept ... excludeFoodModifier) {
            for (CodeableConcept value : excludeFoodModifier) {
                this.excludeFoodModifier.add(value);
            }
            return this;
        }

        public Builder excludeFoodModifier(Collection<CodeableConcept> excludeFoodModifier) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>(excludeFoodModifier);
            return this;
        }

        public Builder oralDiet(OralDiet oralDiet) {
            this.oralDiet = oralDiet;
            return this;
        }

        public Builder supplement(Supplement ... supplement) {
            for (Supplement value : supplement) {
                this.supplement.add(value);
            }
            return this;
        }

        public Builder supplement(Collection<Supplement> supplement) {
            this.supplement = new ArrayList<Supplement>(supplement);
            return this;
        }

        public Builder enteralFormula(EnteralFormula enteralFormula) {
            this.enteralFormula = enteralFormula;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public NutritionOrder build() {
            NutritionOrder nutritionOrder = new NutritionOrder(this);
            if (this.validating) {
                this.validate(nutritionOrder);
            }
            return nutritionOrder;
        }

        protected void validate(NutritionOrder nutritionOrder) {
            super.validate(nutritionOrder);
            ValidationSupport.checkList(nutritionOrder.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(nutritionOrder.instantiatesCanonical, "instantiatesCanonical", Canonical.class);
            ValidationSupport.checkList(nutritionOrder.instantiatesUri, "instantiatesUri", Uri.class);
            ValidationSupport.checkList(nutritionOrder.instantiates, "instantiates", Uri.class);
            ValidationSupport.requireNonNull(nutritionOrder.status, "status");
            ValidationSupport.requireNonNull(nutritionOrder.intent, "intent");
            ValidationSupport.requireNonNull(nutritionOrder.patient, "patient");
            ValidationSupport.requireNonNull(nutritionOrder.dateTime, "dateTime");
            ValidationSupport.checkList(nutritionOrder.allergyIntolerance, "allergyIntolerance", Reference.class);
            ValidationSupport.checkList(nutritionOrder.foodPreferenceModifier, "foodPreferenceModifier", CodeableConcept.class);
            ValidationSupport.checkList(nutritionOrder.excludeFoodModifier, "excludeFoodModifier", CodeableConcept.class);
            ValidationSupport.checkList(nutritionOrder.supplement, "supplement", Supplement.class);
            ValidationSupport.checkList(nutritionOrder.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(nutritionOrder.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(nutritionOrder.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(nutritionOrder.orderer, "orderer", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(nutritionOrder.allergyIntolerance, "allergyIntolerance", "AllergyIntolerance");
        }

        protected Builder from(NutritionOrder nutritionOrder) {
            super.from(nutritionOrder);
            this.identifier.addAll(nutritionOrder.identifier);
            this.instantiatesCanonical.addAll(nutritionOrder.instantiatesCanonical);
            this.instantiatesUri.addAll(nutritionOrder.instantiatesUri);
            this.instantiates.addAll(nutritionOrder.instantiates);
            this.status = nutritionOrder.status;
            this.intent = nutritionOrder.intent;
            this.patient = nutritionOrder.patient;
            this.encounter = nutritionOrder.encounter;
            this.dateTime = nutritionOrder.dateTime;
            this.orderer = nutritionOrder.orderer;
            this.allergyIntolerance.addAll(nutritionOrder.allergyIntolerance);
            this.foodPreferenceModifier.addAll(nutritionOrder.foodPreferenceModifier);
            this.excludeFoodModifier.addAll(nutritionOrder.excludeFoodModifier);
            this.oralDiet = nutritionOrder.oralDiet;
            this.supplement.addAll(nutritionOrder.supplement);
            this.enteralFormula = nutritionOrder.enteralFormula;
            this.note.addAll(nutritionOrder.note);
            return this;
        }
    }
}

