/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.TriggerDefinition;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.ActionCardinalityBehavior;
import com.ibm.fhir.model.type.code.ActionConditionKind;
import com.ibm.fhir.model.type.code.ActionGroupingBehavior;
import com.ibm.fhir.model.type.code.ActionParticipantType;
import com.ibm.fhir.model.type.code.ActionPrecheckBehavior;
import com.ibm.fhir.model.type.code.ActionRelationshipType;
import com.ibm.fhir.model.type.code.ActionRequiredBehavior;
import com.ibm.fhir.model.type.code.ActionSelectionBehavior;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.RequestPriority;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="pdf-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/PlanDefinition"), @Constraint(id="planDefinition-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/plan-definition-type", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/plan-definition-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/PlanDefinition", generated=true), @Constraint(id="planDefinition-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="subject.as(CodeableConcept).exists() implies (subject.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/PlanDefinition", generated=true), @Constraint(id="planDefinition-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/PlanDefinition", generated=true), @Constraint(id="planDefinition-4", level="Warning", location="goal.priority", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/goal-priority", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/goal-priority', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/PlanDefinition", generated=true), @Constraint(id="planDefinition-5", level="Warning", location="action.subject", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="$this.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/PlanDefinition", generated=true), @Constraint(id="planDefinition-6", level="Warning", location="action.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/action-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/action-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/PlanDefinition", generated=true)})
public class PlanDefinition
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    private final String subtitle;
    @Summary
    @Binding(bindingName="PlanDefinitionType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of PlanDefinition.", valueSet="http://hl7.org/fhir/ValueSet/plan-definition-type")
    private final CodeableConcept type;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @ReferenceTarget(value={"Group"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SubjectType", strength=BindingStrength.Value.EXTENSIBLE, description="The possible types of subjects for a plan definition (E.g. Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    private final Element subject;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final String usage;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Binding(bindingName="DefinitionTopic", strength=BindingStrength.Value.EXAMPLE, description="High-level categorization of the definition, used for searching, sorting, and filtering.", valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    private final List<CodeableConcept> topic;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final List<Canonical> library;
    private final List<Goal> goal;
    private final List<Action> action;

    private PlanDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.type = builder.type;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.subject = builder.subject;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.usage = builder.usage;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.topic = Collections.unmodifiableList(builder.topic);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.library = Collections.unmodifiableList(builder.library);
        this.goal = Collections.unmodifiableList(builder.goal);
        this.action = Collections.unmodifiableList(builder.action);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public Element getSubject() {
        return this.subject;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public String getUsage() {
        return this.usage;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<CodeableConcept> getTopic() {
        return this.topic;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public List<Canonical> getLibrary() {
        return this.library;
    }

    public List<Goal> getGoal() {
        return this.goal;
    }

    public List<Action> getAction() {
        return this.action;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.subtitle != null || this.type != null || this.status != null || this.experimental != null || this.subject != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.usage != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.topic.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || !this.library.isEmpty() || !this.goal.isEmpty() || !this.action.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.usage, "usage", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.topic, "topic", visitor, CodeableConcept.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.library, "library", visitor, Canonical.class);
                this.accept(this.goal, "goal", visitor, Goal.class);
                this.accept(this.action, "action", visitor, Action.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlanDefinition other = (PlanDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.type, other.type) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.usage, other.usage) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.topic, other.topic) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.library, other.library) && Objects.equals(this.goal, other.goal) && Objects.equals(this.action, other.action);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.subtitle, this.type, this.status, this.experimental, this.subject, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.goal, this.action);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Action
    extends BackboneElement {
        private final String prefix;
        private final String title;
        private final String description;
        private final String textEquivalent;
        @Binding(bindingName="RequestPriority", strength=BindingStrength.Value.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.0.1")
        private final RequestPriority priority;
        private final List<CodeableConcept> code;
        private final List<CodeableConcept> reason;
        private final List<RelatedArtifact> documentation;
        private final List<Id> goalId;
        @ReferenceTarget(value={"Group"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Binding(bindingName="SubjectType", strength=BindingStrength.Value.EXTENSIBLE, description="The possible types of subjects for a plan definition (E.g. Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
        private final Element subject;
        private final List<TriggerDefinition> trigger;
        private final List<Condition> condition;
        private final List<DataRequirement> input;
        private final List<DataRequirement> output;
        private final List<RelatedAction> relatedAction;
        @Choice(value={DateTime.class, Age.class, Period.class, Duration.class, Range.class, Timing.class})
        private final Element timing;
        private final List<Participant> participant;
        @Binding(bindingName="ActionType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of action to be performed.", valueSet="http://hl7.org/fhir/ValueSet/action-type")
        private final CodeableConcept type;
        @Binding(bindingName="ActionGroupingBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines organization behavior of a group.", valueSet="http://hl7.org/fhir/ValueSet/action-grouping-behavior|4.0.1")
        private final ActionGroupingBehavior groupingBehavior;
        @Binding(bindingName="ActionSelectionBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines selection behavior of a group.", valueSet="http://hl7.org/fhir/ValueSet/action-selection-behavior|4.0.1")
        private final ActionSelectionBehavior selectionBehavior;
        @Binding(bindingName="ActionRequiredBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines expectations around whether an action or action group is required.", valueSet="http://hl7.org/fhir/ValueSet/action-required-behavior|4.0.1")
        private final ActionRequiredBehavior requiredBehavior;
        @Binding(bindingName="ActionPrecheckBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines selection frequency behavior for an action or group.", valueSet="http://hl7.org/fhir/ValueSet/action-precheck-behavior|4.0.1")
        private final ActionPrecheckBehavior precheckBehavior;
        @Binding(bindingName="ActionCardinalityBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines behavior for an action or a group for how many times that item may be repeated.", valueSet="http://hl7.org/fhir/ValueSet/action-cardinality-behavior|4.0.1")
        private final ActionCardinalityBehavior cardinalityBehavior;
        @Choice(value={Canonical.class, Uri.class})
        private final Element definition;
        private final Canonical transform;
        private final List<DynamicValue> dynamicValue;
        private final List<Action> action;

        private Action(Builder builder) {
            super(builder);
            this.prefix = builder.prefix;
            this.title = builder.title;
            this.description = builder.description;
            this.textEquivalent = builder.textEquivalent;
            this.priority = builder.priority;
            this.code = Collections.unmodifiableList(builder.code);
            this.reason = Collections.unmodifiableList(builder.reason);
            this.documentation = Collections.unmodifiableList(builder.documentation);
            this.goalId = Collections.unmodifiableList(builder.goalId);
            this.subject = builder.subject;
            this.trigger = Collections.unmodifiableList(builder.trigger);
            this.condition = Collections.unmodifiableList(builder.condition);
            this.input = Collections.unmodifiableList(builder.input);
            this.output = Collections.unmodifiableList(builder.output);
            this.relatedAction = Collections.unmodifiableList(builder.relatedAction);
            this.timing = builder.timing;
            this.participant = Collections.unmodifiableList(builder.participant);
            this.type = builder.type;
            this.groupingBehavior = builder.groupingBehavior;
            this.selectionBehavior = builder.selectionBehavior;
            this.requiredBehavior = builder.requiredBehavior;
            this.precheckBehavior = builder.precheckBehavior;
            this.cardinalityBehavior = builder.cardinalityBehavior;
            this.definition = builder.definition;
            this.transform = builder.transform;
            this.dynamicValue = Collections.unmodifiableList(builder.dynamicValue);
            this.action = Collections.unmodifiableList(builder.action);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTextEquivalent() {
            return this.textEquivalent;
        }

        public RequestPriority getPriority() {
            return this.priority;
        }

        public List<CodeableConcept> getCode() {
            return this.code;
        }

        public List<CodeableConcept> getReason() {
            return this.reason;
        }

        public List<RelatedArtifact> getDocumentation() {
            return this.documentation;
        }

        public List<Id> getGoalId() {
            return this.goalId;
        }

        public Element getSubject() {
            return this.subject;
        }

        public List<TriggerDefinition> getTrigger() {
            return this.trigger;
        }

        public List<Condition> getCondition() {
            return this.condition;
        }

        public List<DataRequirement> getInput() {
            return this.input;
        }

        public List<DataRequirement> getOutput() {
            return this.output;
        }

        public List<RelatedAction> getRelatedAction() {
            return this.relatedAction;
        }

        public Element getTiming() {
            return this.timing;
        }

        public List<Participant> getParticipant() {
            return this.participant;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public ActionGroupingBehavior getGroupingBehavior() {
            return this.groupingBehavior;
        }

        public ActionSelectionBehavior getSelectionBehavior() {
            return this.selectionBehavior;
        }

        public ActionRequiredBehavior getRequiredBehavior() {
            return this.requiredBehavior;
        }

        public ActionPrecheckBehavior getPrecheckBehavior() {
            return this.precheckBehavior;
        }

        public ActionCardinalityBehavior getCardinalityBehavior() {
            return this.cardinalityBehavior;
        }

        public Element getDefinition() {
            return this.definition;
        }

        public Canonical getTransform() {
            return this.transform;
        }

        public List<DynamicValue> getDynamicValue() {
            return this.dynamicValue;
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.prefix != null || this.title != null || this.description != null || this.textEquivalent != null || this.priority != null || !this.code.isEmpty() || !this.reason.isEmpty() || !this.documentation.isEmpty() || !this.goalId.isEmpty() || this.subject != null || !this.trigger.isEmpty() || !this.condition.isEmpty() || !this.input.isEmpty() || !this.output.isEmpty() || !this.relatedAction.isEmpty() || this.timing != null || !this.participant.isEmpty() || this.type != null || this.groupingBehavior != null || this.selectionBehavior != null || this.requiredBehavior != null || this.precheckBehavior != null || this.cardinalityBehavior != null || this.definition != null || this.transform != null || !this.dynamicValue.isEmpty() || !this.action.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.prefix, "prefix", visitor);
                    this.accept(this.title, "title", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.textEquivalent, "textEquivalent", visitor);
                    this.accept(this.priority, "priority", visitor);
                    this.accept(this.code, "code", visitor, CodeableConcept.class);
                    this.accept(this.reason, "reason", visitor, CodeableConcept.class);
                    this.accept(this.documentation, "documentation", visitor, RelatedArtifact.class);
                    this.accept(this.goalId, "goalId", visitor, Id.class);
                    this.accept(this.subject, "subject", visitor);
                    this.accept(this.trigger, "trigger", visitor, TriggerDefinition.class);
                    this.accept(this.condition, "condition", visitor, Condition.class);
                    this.accept(this.input, "input", visitor, DataRequirement.class);
                    this.accept(this.output, "output", visitor, DataRequirement.class);
                    this.accept(this.relatedAction, "relatedAction", visitor, RelatedAction.class);
                    this.accept(this.timing, "timing", visitor);
                    this.accept(this.participant, "participant", visitor, Participant.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.groupingBehavior, "groupingBehavior", visitor);
                    this.accept(this.selectionBehavior, "selectionBehavior", visitor);
                    this.accept(this.requiredBehavior, "requiredBehavior", visitor);
                    this.accept(this.precheckBehavior, "precheckBehavior", visitor);
                    this.accept(this.cardinalityBehavior, "cardinalityBehavior", visitor);
                    this.accept(this.definition, "definition", visitor);
                    this.accept(this.transform, "transform", visitor);
                    this.accept(this.dynamicValue, "dynamicValue", visitor, DynamicValue.class);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Action other = (Action)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.textEquivalent, other.textEquivalent) && Objects.equals(this.priority, other.priority) && Objects.equals(this.code, other.code) && Objects.equals(this.reason, other.reason) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.goalId, other.goalId) && Objects.equals(this.subject, other.subject) && Objects.equals(this.trigger, other.trigger) && Objects.equals(this.condition, other.condition) && Objects.equals(this.input, other.input) && Objects.equals(this.output, other.output) && Objects.equals(this.relatedAction, other.relatedAction) && Objects.equals(this.timing, other.timing) && Objects.equals(this.participant, other.participant) && Objects.equals(this.type, other.type) && Objects.equals(this.groupingBehavior, other.groupingBehavior) && Objects.equals(this.selectionBehavior, other.selectionBehavior) && Objects.equals(this.requiredBehavior, other.requiredBehavior) && Objects.equals(this.precheckBehavior, other.precheckBehavior) && Objects.equals(this.cardinalityBehavior, other.cardinalityBehavior) && Objects.equals(this.definition, other.definition) && Objects.equals(this.transform, other.transform) && Objects.equals(this.dynamicValue, other.dynamicValue) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.prefix, this.title, this.description, this.textEquivalent, this.priority, this.code, this.reason, this.documentation, this.goalId, this.subject, this.trigger, this.condition, this.input, this.output, this.relatedAction, this.timing, this.participant, this.type, this.groupingBehavior, this.selectionBehavior, this.requiredBehavior, this.precheckBehavior, this.cardinalityBehavior, this.definition, this.transform, this.dynamicValue, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class DynamicValue
        extends BackboneElement {
            private final String path;
            private final Expression expression;

            private DynamicValue(Builder builder) {
                super(builder);
                this.path = builder.path;
                this.expression = builder.expression;
            }

            public String getPath() {
                return this.path;
            }

            public Expression getExpression() {
                return this.expression;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.path != null || this.expression != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.path, "path", visitor);
                        this.accept(this.expression, "expression", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DynamicValue other = (DynamicValue)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.expression, other.expression);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.expression);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String path;
                private Expression expression;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder path(java.lang.String path) {
                    this.path = path == null ? null : String.of(path);
                    return this;
                }

                public Builder path(String path) {
                    this.path = path;
                    return this;
                }

                public Builder expression(Expression expression) {
                    this.expression = expression;
                    return this;
                }

                @Override
                public DynamicValue build() {
                    DynamicValue dynamicValue = new DynamicValue(this);
                    if (this.validating) {
                        this.validate(dynamicValue);
                    }
                    return dynamicValue;
                }

                protected void validate(DynamicValue dynamicValue) {
                    super.validate(dynamicValue);
                    ValidationSupport.requireValueOrChildren(dynamicValue);
                }

                protected Builder from(DynamicValue dynamicValue) {
                    super.from(dynamicValue);
                    this.path = dynamicValue.path;
                    this.expression = dynamicValue.expression;
                    return this;
                }
            }
        }

        public static class Participant
        extends BackboneElement {
            @Binding(bindingName="ActionParticipantType", strength=BindingStrength.Value.REQUIRED, description="The type of participant for the action.", valueSet="http://hl7.org/fhir/ValueSet/action-participant-type|4.0.1")
            @Required
            private final ActionParticipantType type;
            @Binding(bindingName="ActionParticipantRole", strength=BindingStrength.Value.EXAMPLE, description="Defines roles played by participants for the action.", valueSet="http://hl7.org/fhir/ValueSet/action-participant-role")
            private final CodeableConcept role;

            private Participant(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.role = builder.role;
            }

            public ActionParticipantType getType() {
                return this.type;
            }

            public CodeableConcept getRole() {
                return this.role;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.role != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.role, "role", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Participant other = (Participant)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.role, other.role);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.role);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ActionParticipantType type;
                private CodeableConcept role;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(ActionParticipantType type) {
                    this.type = type;
                    return this;
                }

                public Builder role(CodeableConcept role) {
                    this.role = role;
                    return this;
                }

                @Override
                public Participant build() {
                    Participant participant = new Participant(this);
                    if (this.validating) {
                        this.validate(participant);
                    }
                    return participant;
                }

                protected void validate(Participant participant) {
                    super.validate(participant);
                    ValidationSupport.requireNonNull(participant.type, "type");
                    ValidationSupport.requireValueOrChildren(participant);
                }

                protected Builder from(Participant participant) {
                    super.from(participant);
                    this.type = participant.type;
                    this.role = participant.role;
                    return this;
                }
            }
        }

        public static class RelatedAction
        extends BackboneElement {
            @Required
            private final Id actionId;
            @Binding(bindingName="ActionRelationshipType", strength=BindingStrength.Value.REQUIRED, description="Defines the types of relationships between actions.", valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type|4.0.1")
            @Required
            private final ActionRelationshipType relationship;
            @Choice(value={Duration.class, Range.class})
            private final Element offset;

            private RelatedAction(Builder builder) {
                super(builder);
                this.actionId = builder.actionId;
                this.relationship = builder.relationship;
                this.offset = builder.offset;
            }

            public Id getActionId() {
                return this.actionId;
            }

            public ActionRelationshipType getRelationship() {
                return this.relationship;
            }

            public Element getOffset() {
                return this.offset;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.actionId != null || this.relationship != null || this.offset != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.actionId, "actionId", visitor);
                        this.accept(this.relationship, "relationship", visitor);
                        this.accept(this.offset, "offset", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                RelatedAction other = (RelatedAction)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.actionId, other.actionId) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.offset, other.offset);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.actionId, this.relationship, this.offset);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Id actionId;
                private ActionRelationshipType relationship;
                private Element offset;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder actionId(Id actionId) {
                    this.actionId = actionId;
                    return this;
                }

                public Builder relationship(ActionRelationshipType relationship) {
                    this.relationship = relationship;
                    return this;
                }

                public Builder offset(Element offset) {
                    this.offset = offset;
                    return this;
                }

                @Override
                public RelatedAction build() {
                    RelatedAction relatedAction = new RelatedAction(this);
                    if (this.validating) {
                        this.validate(relatedAction);
                    }
                    return relatedAction;
                }

                protected void validate(RelatedAction relatedAction) {
                    super.validate(relatedAction);
                    ValidationSupport.requireNonNull(relatedAction.actionId, "actionId");
                    ValidationSupport.requireNonNull(relatedAction.relationship, "relationship");
                    ValidationSupport.choiceElement(relatedAction.offset, "offset", Duration.class, Range.class);
                    ValidationSupport.requireValueOrChildren(relatedAction);
                }

                protected Builder from(RelatedAction relatedAction) {
                    super.from(relatedAction);
                    this.actionId = relatedAction.actionId;
                    this.relationship = relatedAction.relationship;
                    this.offset = relatedAction.offset;
                    return this;
                }
            }
        }

        public static class Condition
        extends BackboneElement {
            @Binding(bindingName="ActionConditionKind", strength=BindingStrength.Value.REQUIRED, description="Defines the kinds of conditions that can appear on actions.", valueSet="http://hl7.org/fhir/ValueSet/action-condition-kind|4.0.1")
            @Required
            private final ActionConditionKind kind;
            private final Expression expression;

            private Condition(Builder builder) {
                super(builder);
                this.kind = builder.kind;
                this.expression = builder.expression;
            }

            public ActionConditionKind getKind() {
                return this.kind;
            }

            public Expression getExpression() {
                return this.expression;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.kind != null || this.expression != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.kind, "kind", visitor);
                        this.accept(this.expression, "expression", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Condition other = (Condition)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.kind, other.kind) && Objects.equals(this.expression, other.expression);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.kind, this.expression);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ActionConditionKind kind;
                private Expression expression;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder kind(ActionConditionKind kind) {
                    this.kind = kind;
                    return this;
                }

                public Builder expression(Expression expression) {
                    this.expression = expression;
                    return this;
                }

                @Override
                public Condition build() {
                    Condition condition = new Condition(this);
                    if (this.validating) {
                        this.validate(condition);
                    }
                    return condition;
                }

                protected void validate(Condition condition) {
                    super.validate(condition);
                    ValidationSupport.requireNonNull(condition.kind, "kind");
                    ValidationSupport.requireValueOrChildren(condition);
                }

                protected Builder from(Condition condition) {
                    super.from(condition);
                    this.kind = condition.kind;
                    this.expression = condition.expression;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String prefix;
            private String title;
            private String description;
            private String textEquivalent;
            private RequestPriority priority;
            private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> reason = new ArrayList<CodeableConcept>();
            private List<RelatedArtifact> documentation = new ArrayList<RelatedArtifact>();
            private List<Id> goalId = new ArrayList<Id>();
            private Element subject;
            private List<TriggerDefinition> trigger = new ArrayList<TriggerDefinition>();
            private List<Condition> condition = new ArrayList<Condition>();
            private List<DataRequirement> input = new ArrayList<DataRequirement>();
            private List<DataRequirement> output = new ArrayList<DataRequirement>();
            private List<RelatedAction> relatedAction = new ArrayList<RelatedAction>();
            private Element timing;
            private List<Participant> participant = new ArrayList<Participant>();
            private CodeableConcept type;
            private ActionGroupingBehavior groupingBehavior;
            private ActionSelectionBehavior selectionBehavior;
            private ActionRequiredBehavior requiredBehavior;
            private ActionPrecheckBehavior precheckBehavior;
            private ActionCardinalityBehavior cardinalityBehavior;
            private Element definition;
            private Canonical transform;
            private List<DynamicValue> dynamicValue = new ArrayList<DynamicValue>();
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix == null ? null : String.of(prefix);
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder title(java.lang.String title) {
                this.title = title == null ? null : String.of(title);
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder textEquivalent(java.lang.String textEquivalent) {
                this.textEquivalent = textEquivalent == null ? null : String.of(textEquivalent);
                return this;
            }

            public Builder textEquivalent(String textEquivalent) {
                this.textEquivalent = textEquivalent;
                return this;
            }

            public Builder priority(RequestPriority priority) {
                this.priority = priority;
                return this;
            }

            public Builder code(CodeableConcept ... code) {
                for (CodeableConcept value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<CodeableConcept> code) {
                this.code = new ArrayList<CodeableConcept>(code);
                return this;
            }

            public Builder reason(CodeableConcept ... reason) {
                for (CodeableConcept value : reason) {
                    this.reason.add(value);
                }
                return this;
            }

            public Builder reason(Collection<CodeableConcept> reason) {
                this.reason = new ArrayList<CodeableConcept>(reason);
                return this;
            }

            public Builder documentation(RelatedArtifact ... documentation) {
                for (RelatedArtifact value : documentation) {
                    this.documentation.add(value);
                }
                return this;
            }

            public Builder documentation(Collection<RelatedArtifact> documentation) {
                this.documentation = new ArrayList<RelatedArtifact>(documentation);
                return this;
            }

            public Builder goalId(Id ... goalId) {
                for (Id value : goalId) {
                    this.goalId.add(value);
                }
                return this;
            }

            public Builder goalId(Collection<Id> goalId) {
                this.goalId = new ArrayList<Id>(goalId);
                return this;
            }

            public Builder subject(Element subject) {
                this.subject = subject;
                return this;
            }

            public Builder trigger(TriggerDefinition ... trigger) {
                for (TriggerDefinition value : trigger) {
                    this.trigger.add(value);
                }
                return this;
            }

            public Builder trigger(Collection<TriggerDefinition> trigger) {
                this.trigger = new ArrayList<TriggerDefinition>(trigger);
                return this;
            }

            public Builder condition(Condition ... condition) {
                for (Condition value : condition) {
                    this.condition.add(value);
                }
                return this;
            }

            public Builder condition(Collection<Condition> condition) {
                this.condition = new ArrayList<Condition>(condition);
                return this;
            }

            public Builder input(DataRequirement ... input) {
                for (DataRequirement value : input) {
                    this.input.add(value);
                }
                return this;
            }

            public Builder input(Collection<DataRequirement> input) {
                this.input = new ArrayList<DataRequirement>(input);
                return this;
            }

            public Builder output(DataRequirement ... output) {
                for (DataRequirement value : output) {
                    this.output.add(value);
                }
                return this;
            }

            public Builder output(Collection<DataRequirement> output) {
                this.output = new ArrayList<DataRequirement>(output);
                return this;
            }

            public Builder relatedAction(RelatedAction ... relatedAction) {
                for (RelatedAction value : relatedAction) {
                    this.relatedAction.add(value);
                }
                return this;
            }

            public Builder relatedAction(Collection<RelatedAction> relatedAction) {
                this.relatedAction = new ArrayList<RelatedAction>(relatedAction);
                return this;
            }

            public Builder timing(Element timing) {
                this.timing = timing;
                return this;
            }

            public Builder participant(Participant ... participant) {
                for (Participant value : participant) {
                    this.participant.add(value);
                }
                return this;
            }

            public Builder participant(Collection<Participant> participant) {
                this.participant = new ArrayList<Participant>(participant);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder groupingBehavior(ActionGroupingBehavior groupingBehavior) {
                this.groupingBehavior = groupingBehavior;
                return this;
            }

            public Builder selectionBehavior(ActionSelectionBehavior selectionBehavior) {
                this.selectionBehavior = selectionBehavior;
                return this;
            }

            public Builder requiredBehavior(ActionRequiredBehavior requiredBehavior) {
                this.requiredBehavior = requiredBehavior;
                return this;
            }

            public Builder precheckBehavior(ActionPrecheckBehavior precheckBehavior) {
                this.precheckBehavior = precheckBehavior;
                return this;
            }

            public Builder cardinalityBehavior(ActionCardinalityBehavior cardinalityBehavior) {
                this.cardinalityBehavior = cardinalityBehavior;
                return this;
            }

            public Builder definition(Element definition) {
                this.definition = definition;
                return this;
            }

            public Builder transform(Canonical transform) {
                this.transform = transform;
                return this;
            }

            public Builder dynamicValue(DynamicValue ... dynamicValue) {
                for (DynamicValue value : dynamicValue) {
                    this.dynamicValue.add(value);
                }
                return this;
            }

            public Builder dynamicValue(Collection<DynamicValue> dynamicValue) {
                this.dynamicValue = new ArrayList<DynamicValue>(dynamicValue);
                return this;
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Action build() {
                Action action = new Action(this);
                if (this.validating) {
                    this.validate(action);
                }
                return action;
            }

            protected void validate(Action action) {
                super.validate(action);
                ValidationSupport.checkList(action.code, "code", CodeableConcept.class);
                ValidationSupport.checkList(action.reason, "reason", CodeableConcept.class);
                ValidationSupport.checkList(action.documentation, "documentation", RelatedArtifact.class);
                ValidationSupport.checkList(action.goalId, "goalId", Id.class);
                ValidationSupport.choiceElement(action.subject, "subject", CodeableConcept.class, Reference.class);
                ValidationSupport.checkList(action.trigger, "trigger", TriggerDefinition.class);
                ValidationSupport.checkList(action.condition, "condition", Condition.class);
                ValidationSupport.checkList(action.input, "input", DataRequirement.class);
                ValidationSupport.checkList(action.output, "output", DataRequirement.class);
                ValidationSupport.checkList(action.relatedAction, "relatedAction", RelatedAction.class);
                ValidationSupport.choiceElement(action.timing, "timing", DateTime.class, Age.class, Period.class, Duration.class, Range.class, Timing.class);
                ValidationSupport.checkList(action.participant, "participant", Participant.class);
                ValidationSupport.choiceElement(action.definition, "definition", Canonical.class, Uri.class);
                ValidationSupport.checkList(action.dynamicValue, "dynamicValue", DynamicValue.class);
                ValidationSupport.checkList(action.action, "action", Action.class);
                ValidationSupport.checkReferenceType(action.subject, "subject", "Group");
                ValidationSupport.requireValueOrChildren(action);
            }

            protected Builder from(Action action) {
                super.from(action);
                this.prefix = action.prefix;
                this.title = action.title;
                this.description = action.description;
                this.textEquivalent = action.textEquivalent;
                this.priority = action.priority;
                this.code.addAll(action.code);
                this.reason.addAll(action.reason);
                this.documentation.addAll(action.documentation);
                this.goalId.addAll(action.goalId);
                this.subject = action.subject;
                this.trigger.addAll(action.trigger);
                this.condition.addAll(action.condition);
                this.input.addAll(action.input);
                this.output.addAll(action.output);
                this.relatedAction.addAll(action.relatedAction);
                this.timing = action.timing;
                this.participant.addAll(action.participant);
                this.type = action.type;
                this.groupingBehavior = action.groupingBehavior;
                this.selectionBehavior = action.selectionBehavior;
                this.requiredBehavior = action.requiredBehavior;
                this.precheckBehavior = action.precheckBehavior;
                this.cardinalityBehavior = action.cardinalityBehavior;
                this.definition = action.definition;
                this.transform = action.transform;
                this.dynamicValue.addAll(action.dynamicValue);
                this.action.addAll(action.action);
                return this;
            }
        }
    }

    public static class Goal
    extends BackboneElement {
        @Binding(bindingName="GoalCategory", strength=BindingStrength.Value.EXAMPLE, description="Example codes for grouping goals for filtering or presentation.", valueSet="http://hl7.org/fhir/ValueSet/goal-category")
        private final CodeableConcept category;
        @Binding(bindingName="GoalDescription", strength=BindingStrength.Value.EXAMPLE, description="Describes goals that can be achieved.", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        @Required
        private final CodeableConcept description;
        @Binding(bindingName="GoalPriority", strength=BindingStrength.Value.PREFERRED, description="Indicates the level of importance associated with reaching or sustaining a goal.", valueSet="http://hl7.org/fhir/ValueSet/goal-priority")
        private final CodeableConcept priority;
        @Binding(bindingName="GoalStartEvent", strength=BindingStrength.Value.EXAMPLE, description="Identifies the types of events that might trigger the start of a goal.", valueSet="http://hl7.org/fhir/ValueSet/goal-start-event")
        private final CodeableConcept start;
        @Binding(bindingName="GoalAddresses", strength=BindingStrength.Value.EXAMPLE, description="Identifies problems, conditions, issues, or concerns that goals may address.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        private final List<CodeableConcept> addresses;
        private final List<RelatedArtifact> documentation;
        private final List<Target> target;

        private Goal(Builder builder) {
            super(builder);
            this.category = builder.category;
            this.description = builder.description;
            this.priority = builder.priority;
            this.start = builder.start;
            this.addresses = Collections.unmodifiableList(builder.addresses);
            this.documentation = Collections.unmodifiableList(builder.documentation);
            this.target = Collections.unmodifiableList(builder.target);
        }

        public CodeableConcept getCategory() {
            return this.category;
        }

        public CodeableConcept getDescription() {
            return this.description;
        }

        public CodeableConcept getPriority() {
            return this.priority;
        }

        public CodeableConcept getStart() {
            return this.start;
        }

        public List<CodeableConcept> getAddresses() {
            return this.addresses;
        }

        public List<RelatedArtifact> getDocumentation() {
            return this.documentation;
        }

        public List<Target> getTarget() {
            return this.target;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.category != null || this.description != null || this.priority != null || this.start != null || !this.addresses.isEmpty() || !this.documentation.isEmpty() || !this.target.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.priority, "priority", visitor);
                    this.accept(this.start, "start", visitor);
                    this.accept(this.addresses, "addresses", visitor, CodeableConcept.class);
                    this.accept(this.documentation, "documentation", visitor, RelatedArtifact.class);
                    this.accept(this.target, "target", visitor, Target.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Goal other = (Goal)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.description, other.description) && Objects.equals(this.priority, other.priority) && Objects.equals(this.start, other.start) && Objects.equals(this.addresses, other.addresses) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.target, other.target);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.category, this.description, this.priority, this.start, this.addresses, this.documentation, this.target);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Target
        extends BackboneElement {
            @Binding(bindingName="GoalTargetMeasure", strength=BindingStrength.Value.EXAMPLE, description="Identifies types of parameters that can be tracked to determine goal achievement.", valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
            private final CodeableConcept measure;
            @Choice(value={Quantity.class, Range.class, CodeableConcept.class})
            private final Element detail;
            private final Duration due;

            private Target(Builder builder) {
                super(builder);
                this.measure = builder.measure;
                this.detail = builder.detail;
                this.due = builder.due;
            }

            public CodeableConcept getMeasure() {
                return this.measure;
            }

            public Element getDetail() {
                return this.detail;
            }

            public Duration getDue() {
                return this.due;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.measure != null || this.detail != null || this.due != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.measure, "measure", visitor);
                        this.accept(this.detail, "detail", visitor);
                        this.accept(this.due, "due", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Target other = (Target)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.measure, other.measure) && Objects.equals(this.detail, other.detail) && Objects.equals(this.due, other.due);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.measure, this.detail, this.due);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept measure;
                private Element detail;
                private Duration due;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder measure(CodeableConcept measure) {
                    this.measure = measure;
                    return this;
                }

                public Builder detail(Element detail) {
                    this.detail = detail;
                    return this;
                }

                public Builder due(Duration due) {
                    this.due = due;
                    return this;
                }

                @Override
                public Target build() {
                    Target target = new Target(this);
                    if (this.validating) {
                        this.validate(target);
                    }
                    return target;
                }

                protected void validate(Target target) {
                    super.validate(target);
                    ValidationSupport.choiceElement(target.detail, "detail", Quantity.class, Range.class, CodeableConcept.class);
                    ValidationSupport.requireValueOrChildren(target);
                }

                protected Builder from(Target target) {
                    super.from(target);
                    this.measure = target.measure;
                    this.detail = target.detail;
                    this.due = target.due;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept category;
            private CodeableConcept description;
            private CodeableConcept priority;
            private CodeableConcept start;
            private List<CodeableConcept> addresses = new ArrayList<CodeableConcept>();
            private List<RelatedArtifact> documentation = new ArrayList<RelatedArtifact>();
            private List<Target> target = new ArrayList<Target>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder category(CodeableConcept category) {
                this.category = category;
                return this;
            }

            public Builder description(CodeableConcept description) {
                this.description = description;
                return this;
            }

            public Builder priority(CodeableConcept priority) {
                this.priority = priority;
                return this;
            }

            public Builder start(CodeableConcept start) {
                this.start = start;
                return this;
            }

            public Builder addresses(CodeableConcept ... addresses) {
                for (CodeableConcept value : addresses) {
                    this.addresses.add(value);
                }
                return this;
            }

            public Builder addresses(Collection<CodeableConcept> addresses) {
                this.addresses = new ArrayList<CodeableConcept>(addresses);
                return this;
            }

            public Builder documentation(RelatedArtifact ... documentation) {
                for (RelatedArtifact value : documentation) {
                    this.documentation.add(value);
                }
                return this;
            }

            public Builder documentation(Collection<RelatedArtifact> documentation) {
                this.documentation = new ArrayList<RelatedArtifact>(documentation);
                return this;
            }

            public Builder target(Target ... target) {
                for (Target value : target) {
                    this.target.add(value);
                }
                return this;
            }

            public Builder target(Collection<Target> target) {
                this.target = new ArrayList<Target>(target);
                return this;
            }

            @Override
            public Goal build() {
                Goal goal = new Goal(this);
                if (this.validating) {
                    this.validate(goal);
                }
                return goal;
            }

            protected void validate(Goal goal) {
                super.validate(goal);
                ValidationSupport.requireNonNull(goal.description, "description");
                ValidationSupport.checkList(goal.addresses, "addresses", CodeableConcept.class);
                ValidationSupport.checkList(goal.documentation, "documentation", RelatedArtifact.class);
                ValidationSupport.checkList(goal.target, "target", Target.class);
                ValidationSupport.requireValueOrChildren(goal);
            }

            protected Builder from(Goal goal) {
                super.from(goal);
                this.category = goal.category;
                this.description = goal.description;
                this.priority = goal.priority;
                this.start = goal.start;
                this.addresses.addAll(goal.addresses);
                this.documentation.addAll(goal.documentation);
                this.target.addAll(goal.target);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private String subtitle;
        private CodeableConcept type;
        private PublicationStatus status;
        private Boolean experimental;
        private Element subject;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private String usage;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<CodeableConcept> topic = new ArrayList<CodeableConcept>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private List<Canonical> library = new ArrayList<Canonical>();
        private List<Goal> goal = new ArrayList<Goal>();
        private List<Action> action = new ArrayList<Action>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(java.lang.String subtitle) {
            this.subtitle = subtitle == null ? null : String.of(subtitle);
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder subject(Element subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder usage(java.lang.String usage) {
            this.usage = usage == null ? null : String.of(usage);
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(LocalDate approvalDate) {
            this.approvalDate = approvalDate == null ? null : Date.of(approvalDate);
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(LocalDate lastReviewDate) {
            this.lastReviewDate = lastReviewDate == null ? null : Date.of(lastReviewDate);
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder topic(CodeableConcept ... topic) {
            for (CodeableConcept value : topic) {
                this.topic.add(value);
            }
            return this;
        }

        public Builder topic(Collection<CodeableConcept> topic) {
            this.topic = new ArrayList<CodeableConcept>(topic);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder library(Canonical ... library) {
            for (Canonical value : library) {
                this.library.add(value);
            }
            return this;
        }

        public Builder library(Collection<Canonical> library) {
            this.library = new ArrayList<Canonical>(library);
            return this;
        }

        public Builder goal(Goal ... goal) {
            for (Goal value : goal) {
                this.goal.add(value);
            }
            return this;
        }

        public Builder goal(Collection<Goal> goal) {
            this.goal = new ArrayList<Goal>(goal);
            return this;
        }

        public Builder action(Action ... action) {
            for (Action value : action) {
                this.action.add(value);
            }
            return this;
        }

        public Builder action(Collection<Action> action) {
            this.action = new ArrayList<Action>(action);
            return this;
        }

        @Override
        public PlanDefinition build() {
            PlanDefinition planDefinition = new PlanDefinition(this);
            if (this.validating) {
                this.validate(planDefinition);
            }
            return planDefinition;
        }

        protected void validate(PlanDefinition planDefinition) {
            super.validate(planDefinition);
            ValidationSupport.checkList(planDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(planDefinition.status, "status");
            ValidationSupport.choiceElement(planDefinition.subject, "subject", CodeableConcept.class, Reference.class);
            ValidationSupport.checkList(planDefinition.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(planDefinition.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(planDefinition.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(planDefinition.topic, "topic", CodeableConcept.class);
            ValidationSupport.checkList(planDefinition.author, "author", ContactDetail.class);
            ValidationSupport.checkList(planDefinition.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(planDefinition.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(planDefinition.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(planDefinition.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.checkList(planDefinition.library, "library", Canonical.class);
            ValidationSupport.checkList(planDefinition.goal, "goal", Goal.class);
            ValidationSupport.checkList(planDefinition.action, "action", Action.class);
            ValidationSupport.checkReferenceType(planDefinition.subject, "subject", "Group");
        }

        protected Builder from(PlanDefinition planDefinition) {
            super.from(planDefinition);
            this.url = planDefinition.url;
            this.identifier.addAll(planDefinition.identifier);
            this.version = planDefinition.version;
            this.name = planDefinition.name;
            this.title = planDefinition.title;
            this.subtitle = planDefinition.subtitle;
            this.type = planDefinition.type;
            this.status = planDefinition.status;
            this.experimental = planDefinition.experimental;
            this.subject = planDefinition.subject;
            this.date = planDefinition.date;
            this.publisher = planDefinition.publisher;
            this.contact.addAll(planDefinition.contact);
            this.description = planDefinition.description;
            this.useContext.addAll(planDefinition.useContext);
            this.jurisdiction.addAll(planDefinition.jurisdiction);
            this.purpose = planDefinition.purpose;
            this.usage = planDefinition.usage;
            this.copyright = planDefinition.copyright;
            this.approvalDate = planDefinition.approvalDate;
            this.lastReviewDate = planDefinition.lastReviewDate;
            this.effectivePeriod = planDefinition.effectivePeriod;
            this.topic.addAll(planDefinition.topic);
            this.author.addAll(planDefinition.author);
            this.editor.addAll(planDefinition.editor);
            this.reviewer.addAll(planDefinition.reviewer);
            this.endorser.addAll(planDefinition.endorser);
            this.relatedArtifact.addAll(planDefinition.relatedArtifact);
            this.library.addAll(planDefinition.library);
            this.goal.addAll(planDefinition.goal);
            this.action.addAll(planDefinition.action);
            return this;
        }
    }
}

