/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.AdministrativeGender;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="practitioner-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="communication.exists() implies (communication.all(memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/Practitioner", generated=true)
public class Practitioner
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    private final List<HumanName> name;
    @Summary
    private final List<ContactPoint> telecom;
    @Summary
    private final List<Address> address;
    @Summary
    @Binding(bindingName="AdministrativeGender", strength=BindingStrength.Value.REQUIRED, description="The gender of a person used for administrative purposes.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1")
    private final AdministrativeGender gender;
    @Summary
    private final Date birthDate;
    private final List<Attachment> photo;
    private final List<Qualification> qualification;
    @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="A human language.", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
    private final List<CodeableConcept> communication;

    private Practitioner(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.active = builder.active;
        this.name = Collections.unmodifiableList(builder.name);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.address = Collections.unmodifiableList(builder.address);
        this.gender = builder.gender;
        this.birthDate = builder.birthDate;
        this.photo = Collections.unmodifiableList(builder.photo);
        this.qualification = Collections.unmodifiableList(builder.qualification);
        this.communication = Collections.unmodifiableList(builder.communication);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public List<HumanName> getName() {
        return this.name;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public AdministrativeGender getGender() {
        return this.gender;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public List<Attachment> getPhoto() {
        return this.photo;
    }

    public List<Qualification> getQualification() {
        return this.qualification;
    }

    public List<CodeableConcept> getCommunication() {
        return this.communication;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || !this.name.isEmpty() || !this.telecom.isEmpty() || !this.address.isEmpty() || this.gender != null || this.birthDate != null || !this.photo.isEmpty() || !this.qualification.isEmpty() || !this.communication.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.name, "name", visitor, HumanName.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.address, "address", visitor, Address.class);
                this.accept(this.gender, "gender", visitor);
                this.accept(this.birthDate, "birthDate", visitor);
                this.accept(this.photo, "photo", visitor, Attachment.class);
                this.accept(this.qualification, "qualification", visitor, Qualification.class);
                this.accept(this.communication, "communication", visitor, CodeableConcept.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Practitioner other = (Practitioner)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.address, other.address) && Objects.equals(this.gender, other.gender) && Objects.equals(this.birthDate, other.birthDate) && Objects.equals(this.photo, other.photo) && Objects.equals(this.qualification, other.qualification) && Objects.equals(this.communication, other.communication);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.name, this.telecom, this.address, this.gender, this.birthDate, this.photo, this.qualification, this.communication);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Qualification
    extends BackboneElement {
        private final List<Identifier> identifier;
        @Binding(bindingName="Qualification", strength=BindingStrength.Value.EXAMPLE, description="Specific qualification the practitioner has to provide a service.", valueSet="http://terminology.hl7.org/ValueSet/v2-2.7-0360")
        @Required
        private final CodeableConcept code;
        private final Period period;
        @ReferenceTarget(value={"Organization"})
        private final Reference issuer;

        private Qualification(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.code = builder.code;
            this.period = builder.period;
            this.issuer = builder.issuer;
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Period getPeriod() {
            return this.period;
        }

        public Reference getIssuer() {
            return this.issuer;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || this.code != null || this.period != null || this.issuer != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.issuer, "issuer", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Qualification other = (Qualification)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.code, other.code) && Objects.equals(this.period, other.period) && Objects.equals(this.issuer, other.issuer);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.code, this.period, this.issuer);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private CodeableConcept code;
            private Period period;
            private Reference issuer;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            public Builder issuer(Reference issuer) {
                this.issuer = issuer;
                return this;
            }

            @Override
            public Qualification build() {
                Qualification qualification = new Qualification(this);
                if (this.validating) {
                    this.validate(qualification);
                }
                return qualification;
            }

            protected void validate(Qualification qualification) {
                super.validate(qualification);
                ValidationSupport.checkList(qualification.identifier, "identifier", Identifier.class);
                ValidationSupport.requireNonNull(qualification.code, "code");
                ValidationSupport.checkReferenceType(qualification.issuer, "issuer", "Organization");
                ValidationSupport.requireValueOrChildren(qualification);
            }

            protected Builder from(Qualification qualification) {
                super.from(qualification);
                this.identifier.addAll(qualification.identifier);
                this.code = qualification.code;
                this.period = qualification.period;
                this.issuer = qualification.issuer;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private List<HumanName> name = new ArrayList<HumanName>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private List<Address> address = new ArrayList<Address>();
        private AdministrativeGender gender;
        private Date birthDate;
        private List<Attachment> photo = new ArrayList<Attachment>();
        private List<Qualification> qualification = new ArrayList<Qualification>();
        private List<CodeableConcept> communication = new ArrayList<CodeableConcept>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder name(HumanName ... name) {
            for (HumanName value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<HumanName> name) {
            this.name = new ArrayList<HumanName>(name);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder address(Address ... address) {
            for (Address value : address) {
                this.address.add(value);
            }
            return this;
        }

        public Builder address(Collection<Address> address) {
            this.address = new ArrayList<Address>(address);
            return this;
        }

        public Builder gender(AdministrativeGender gender) {
            this.gender = gender;
            return this;
        }

        public Builder birthDate(LocalDate birthDate) {
            this.birthDate = birthDate == null ? null : Date.of(birthDate);
            return this;
        }

        public Builder birthDate(Date birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Builder photo(Attachment ... photo) {
            for (Attachment value : photo) {
                this.photo.add(value);
            }
            return this;
        }

        public Builder photo(Collection<Attachment> photo) {
            this.photo = new ArrayList<Attachment>(photo);
            return this;
        }

        public Builder qualification(Qualification ... qualification) {
            for (Qualification value : qualification) {
                this.qualification.add(value);
            }
            return this;
        }

        public Builder qualification(Collection<Qualification> qualification) {
            this.qualification = new ArrayList<Qualification>(qualification);
            return this;
        }

        public Builder communication(CodeableConcept ... communication) {
            for (CodeableConcept value : communication) {
                this.communication.add(value);
            }
            return this;
        }

        public Builder communication(Collection<CodeableConcept> communication) {
            this.communication = new ArrayList<CodeableConcept>(communication);
            return this;
        }

        @Override
        public Practitioner build() {
            Practitioner practitioner = new Practitioner(this);
            if (this.validating) {
                this.validate(practitioner);
            }
            return practitioner;
        }

        protected void validate(Practitioner practitioner) {
            super.validate(practitioner);
            ValidationSupport.checkList(practitioner.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(practitioner.name, "name", HumanName.class);
            ValidationSupport.checkList(practitioner.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(practitioner.address, "address", Address.class);
            ValidationSupport.checkList(practitioner.photo, "photo", Attachment.class);
            ValidationSupport.checkList(practitioner.qualification, "qualification", Qualification.class);
            ValidationSupport.checkList(practitioner.communication, "communication", CodeableConcept.class);
            ValidationSupport.checkValueSetBinding(practitioner.communication, "communication", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
        }

        protected Builder from(Practitioner practitioner) {
            super.from(practitioner);
            this.identifier.addAll(practitioner.identifier);
            this.active = practitioner.active;
            this.name.addAll(practitioner.name);
            this.telecom.addAll(practitioner.telecom);
            this.address.addAll(practitioner.address);
            this.gender = practitioner.gender;
            this.birthDate = practitioner.birthDate;
            this.photo.addAll(practitioner.photo);
            this.qualification.addAll(practitioner.qualification);
            this.communication.addAll(practitioner.communication);
            return this;
        }
    }
}

