/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.ElementDefinition;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ExtensionContextType;
import com.ibm.fhir.model.type.code.FHIRVersion;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.StructureDefinitionKind;
import com.ibm.fhir.model.type.code.TypeDerivationRule;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="sdf-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-1", level="Rule", location="(base)", description="Element paths must be unique unless the structure is a constraint", expression="derivation = 'constraint' or snapshot.element.select(path).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-2", level="Rule", location="StructureDefinition.mapping", description="Must have at least a name or a uri (or both)", expression="name.exists() or uri.exists()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-3", level="Rule", location="StructureDefinition.snapshot", description="Each element definition in a snapshot must have a formal definition and cardinalities", expression="element.all(definition.exists() and min.exists() and max.exists())", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-4", level="Rule", location="(base)", description="If the structure is not abstract, then there SHALL be a baseDefinition", expression="abstract = true or baseDefinition.exists()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-5", level="Rule", location="(base)", description="If the structure defines an extension then the structure must have context information", expression="type != 'Extension' or derivation = 'specialization' or (context.exists())", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-6", level="Rule", location="(base)", description="A structure must have either a differential, or a snapshot (or both)", expression="snapshot.exists() or differential.exists()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-8", level="Rule", location="StructureDefinition.snapshot", description="All snapshot elements must start with the StructureDefinition's specified type for non-logical models, or with the same type name for logical models", expression="(%resource.kind = 'logical' or element.first().path = %resource.type) and element.tail().all(path.startsWith(%resource.snapshot.element.first().path&'.'))", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-8a", level="Rule", location="StructureDefinition.differential", description="In any differential, all the elements must start with the StructureDefinition's specified type for non-logical models, or with the same type name for logical models", expression="(%resource.kind = 'logical' or element.first().path.startsWith(%resource.type)) and (element.tail().empty() or element.tail().all(path.startsWith(%resource.differential.element.first().path.replaceMatches('\\..*','')&'.')))", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-8b", level="Rule", location="StructureDefinition.snapshot", description="All snapshot elements must have a base definition", expression="element.all(base.exists())", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-9", level="Rule", location="(base)", description="In any snapshot or differential, no label, code or requirements on an element without a \".\" in the path (e.g. the first element)", expression="children().element.where(path.contains('.').not()).label.empty() and children().element.where(path.contains('.').not()).code.empty() and children().element.where(path.contains('.').not()).requirements.empty()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-10", level="Rule", location="StructureDefinition.snapshot.element", description="provide either a binding reference or a description (or both)", expression="binding.empty() or binding.valueSet.exists() or binding.description.exists()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-11", level="Rule", location="(base)", description="If there's a type, its content must match the path name in the first element of a snapshot", expression="kind != 'logical' implies snapshot.empty() or snapshot.element.first().path = type", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-14", level="Rule", location="(base)", description="All element definitions must have an id", expression="snapshot.element.all(id.exists()) and differential.element.all(id.exists())", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-15", level="Rule", location="(base)", description="The first element in a snapshot has no type unless model is a logical model.", expression="kind!='logical' implies snapshot.element.first().type.empty()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-15a", level="Rule", location="(base)", description="If the first element in a differential has no \".\" in the path and it's not a logical model, it has no type", expression="(kind!='logical'  and differential.element.first().path.contains('.').not()) implies differential.element.first().type.empty()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-16", level="Rule", location="(base)", description="All element definitions must have unique ids (snapshot)", expression="snapshot.element.all(id.exists()) and snapshot.element.id.trace('ids').isDistinct()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-17", level="Rule", location="(base)", description="All element definitions must have unique ids (diff)", expression="differential.element.all(id.exists()) and differential.element.id.trace('ids').isDistinct()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-18", level="Rule", location="(base)", description="Context Invariants can only be used for extensions", expression="contextInvariant.exists() implies type = 'Extension'", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-19", level="Rule", location="(base)", description="FHIR Specification models only use FHIR defined types", expression="url.startsWith('http://hl7.org/fhir/StructureDefinition') implies (differential.element.type.code.all(matches('^[a-zA-Z0-9]+$') or matches('^http:\\/\\/hl7\\.org\\/fhirpath\\/System\\.[A-Z][A-Za-z]+$')) and snapshot.element.type.code.all(matches('^[a-zA-Z0-9\\.]+$') or matches('^http:\\/\\/hl7\\.org\\/fhirpath\\/System\\.[A-Z][A-Za-z]+$')))", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-20", level="Rule", location="StructureDefinition.differential", description="No slicing on the root element", expression="element.where(path.contains('.').not()).slicing.empty()", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-21", level="Rule", location="(base)", description="Default values can only be specified on specializations", expression="differential.element.defaultValue.exists() implies (derivation = 'specialization')", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-22", level="Rule", location="(base)", description="FHIR Specification models never have default values", expression="url.startsWith('http://hl7.org/fhir/StructureDefinition') implies (snapshot.element.defaultValue.empty() and differential.element.defaultValue.empty())", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="sdf-23", level="Rule", location="(base)", description="No slice name on root", expression="(snapshot | differential).element.all(path.contains('.').not() implies sliceName.empty())", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition"), @Constraint(id="structureDefinition-24", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition", generated=true), @Constraint(id="structureDefinition-25", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/definition-use", expression="keyword.exists() implies (keyword.all(memberOf('http://hl7.org/fhir/ValueSet/definition-use', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition", generated=true), @Constraint(id="structureDefinition-26", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/defined-types", expression="type.exists() and type.memberOf('http://hl7.org/fhir/ValueSet/defined-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/StructureDefinition", generated=true)})
public class StructureDefinition
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    @Required
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    @Summary
    @Binding(bindingName="StructureDefinitionKeyword", strength=BindingStrength.Value.EXTENSIBLE, description="Codes for the meaning of the defined structure (SNOMED CT and LOINC codes, as an example).", valueSet="http://hl7.org/fhir/ValueSet/definition-use")
    private final List<Coding> keyword;
    @Summary
    @Binding(bindingName="FHIRVersion", strength=BindingStrength.Value.REQUIRED, description="All published FHIR Versions.", valueSet="http://hl7.org/fhir/ValueSet/FHIR-version|4.0.1")
    private final FHIRVersion fhirVersion;
    private final List<Mapping> mapping;
    @Summary
    @Binding(bindingName="StructureDefinitionKind", strength=BindingStrength.Value.REQUIRED, description="Defines the type of structure that a definition is describing.", valueSet="http://hl7.org/fhir/ValueSet/structure-definition-kind|4.0.1")
    @Required
    private final StructureDefinitionKind kind;
    @Summary
    @Required
    private final Boolean _abstract;
    @Summary
    private final List<Context> context;
    @Summary
    private final List<String> contextInvariant;
    @Summary
    @Binding(bindingName="FHIRDefinedTypeExt", strength=BindingStrength.Value.EXTENSIBLE, description="Either a resource or a data type, including logical model types.", valueSet="http://hl7.org/fhir/ValueSet/defined-types")
    @Required
    private final Uri type;
    @Summary
    private final Canonical baseDefinition;
    @Summary
    @Binding(bindingName="TypeDerivationRule", strength=BindingStrength.Value.REQUIRED, description="How a type relates to its baseDefinition.", valueSet="http://hl7.org/fhir/ValueSet/type-derivation-rule|4.0.1")
    private final TypeDerivationRule derivation;
    private final Snapshot snapshot;
    private final Differential differential;

    private StructureDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.keyword = Collections.unmodifiableList(builder.keyword);
        this.fhirVersion = builder.fhirVersion;
        this.mapping = Collections.unmodifiableList(builder.mapping);
        this.kind = builder.kind;
        this._abstract = builder._abstract;
        this.context = Collections.unmodifiableList(builder.context);
        this.contextInvariant = Collections.unmodifiableList(builder.contextInvariant);
        this.type = builder.type;
        this.baseDefinition = builder.baseDefinition;
        this.derivation = builder.derivation;
        this.snapshot = builder.snapshot;
        this.differential = builder.differential;
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public List<Coding> getKeyword() {
        return this.keyword;
    }

    public FHIRVersion getFhirVersion() {
        return this.fhirVersion;
    }

    public List<Mapping> getMapping() {
        return this.mapping;
    }

    public StructureDefinitionKind getKind() {
        return this.kind;
    }

    public Boolean getAbstract() {
        return this._abstract;
    }

    public List<Context> getContext() {
        return this.context;
    }

    public List<String> getContextInvariant() {
        return this.contextInvariant;
    }

    public Uri getType() {
        return this.type;
    }

    public Canonical getBaseDefinition() {
        return this.baseDefinition;
    }

    public TypeDerivationRule getDerivation() {
        return this.derivation;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Differential getDifferential() {
        return this.differential;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || !this.keyword.isEmpty() || this.fhirVersion != null || !this.mapping.isEmpty() || this.kind != null || this._abstract != null || !this.context.isEmpty() || !this.contextInvariant.isEmpty() || this.type != null || this.baseDefinition != null || this.derivation != null || this.snapshot != null || this.differential != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.keyword, "keyword", visitor, Coding.class);
                this.accept(this.fhirVersion, "fhirVersion", visitor);
                this.accept(this.mapping, "mapping", visitor, Mapping.class);
                this.accept(this.kind, "kind", visitor);
                this.accept(this._abstract, "abstract", visitor);
                this.accept(this.context, "context", visitor, Context.class);
                this.accept(this.contextInvariant, "contextInvariant", visitor, String.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.baseDefinition, "baseDefinition", visitor);
                this.accept(this.derivation, "derivation", visitor);
                this.accept(this.snapshot, "snapshot", visitor);
                this.accept(this.differential, "differential", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureDefinition other = (StructureDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.keyword, other.keyword) && Objects.equals(this.fhirVersion, other.fhirVersion) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.kind, other.kind) && Objects.equals(this._abstract, other._abstract) && Objects.equals(this.context, other.context) && Objects.equals(this.contextInvariant, other.contextInvariant) && Objects.equals(this.type, other.type) && Objects.equals(this.baseDefinition, other.baseDefinition) && Objects.equals(this.derivation, other.derivation) && Objects.equals(this.snapshot, other.snapshot) && Objects.equals(this.differential, other.differential);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.keyword, this.fhirVersion, this.mapping, this.kind, this._abstract, this.context, this.contextInvariant, this.type, this.baseDefinition, this.derivation, this.snapshot, this.differential);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Differential
    extends BackboneElement {
        @Required
        private final List<ElementDefinition> element;

        private Differential(Builder builder) {
            super(builder);
            this.element = Collections.unmodifiableList(builder.element);
        }

        public List<ElementDefinition> getElement() {
            return this.element;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.element.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.element, "element", visitor, ElementDefinition.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Differential other = (Differential)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.element, other.element);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.element);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<ElementDefinition> element = new ArrayList<ElementDefinition>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder element(ElementDefinition ... element) {
                for (ElementDefinition value : element) {
                    this.element.add(value);
                }
                return this;
            }

            public Builder element(Collection<ElementDefinition> element) {
                this.element = new ArrayList<ElementDefinition>(element);
                return this;
            }

            @Override
            public Differential build() {
                Differential differential = new Differential(this);
                if (this.validating) {
                    this.validate(differential);
                }
                return differential;
            }

            protected void validate(Differential differential) {
                super.validate(differential);
                ValidationSupport.checkNonEmptyList(differential.element, "element", ElementDefinition.class);
                ValidationSupport.requireValueOrChildren(differential);
            }

            protected Builder from(Differential differential) {
                super.from(differential);
                this.element.addAll(differential.element);
                return this;
            }
        }
    }

    public static class Snapshot
    extends BackboneElement {
        @Required
        private final List<ElementDefinition> element;

        private Snapshot(Builder builder) {
            super(builder);
            this.element = Collections.unmodifiableList(builder.element);
        }

        public List<ElementDefinition> getElement() {
            return this.element;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.element.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.element, "element", visitor, ElementDefinition.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Snapshot other = (Snapshot)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.element, other.element);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.element);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<ElementDefinition> element = new ArrayList<ElementDefinition>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder element(ElementDefinition ... element) {
                for (ElementDefinition value : element) {
                    this.element.add(value);
                }
                return this;
            }

            public Builder element(Collection<ElementDefinition> element) {
                this.element = new ArrayList<ElementDefinition>(element);
                return this;
            }

            @Override
            public Snapshot build() {
                Snapshot snapshot = new Snapshot(this);
                if (this.validating) {
                    this.validate(snapshot);
                }
                return snapshot;
            }

            protected void validate(Snapshot snapshot) {
                super.validate(snapshot);
                ValidationSupport.checkNonEmptyList(snapshot.element, "element", ElementDefinition.class);
                ValidationSupport.requireValueOrChildren(snapshot);
            }

            protected Builder from(Snapshot snapshot) {
                super.from(snapshot);
                this.element.addAll(snapshot.element);
                return this;
            }
        }
    }

    public static class Context
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ExtensionContextType", strength=BindingStrength.Value.REQUIRED, description="How an extension context is interpreted.", valueSet="http://hl7.org/fhir/ValueSet/extension-context-type|4.0.1")
        @Required
        private final ExtensionContextType type;
        @Summary
        @Required
        private final String expression;

        private Context(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.expression = builder.expression;
        }

        public ExtensionContextType getType() {
            return this.type;
        }

        public String getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.expression != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.expression, "expression", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.expression, other.expression);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.expression);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ExtensionContextType type;
            private String expression;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(ExtensionContextType type) {
                this.type = type;
                return this;
            }

            public Builder expression(java.lang.String expression) {
                this.expression = expression == null ? null : String.of(expression);
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            @Override
            public Context build() {
                Context context = new Context(this);
                if (this.validating) {
                    this.validate(context);
                }
                return context;
            }

            protected void validate(Context context) {
                super.validate(context);
                ValidationSupport.requireNonNull(context.type, "type");
                ValidationSupport.requireNonNull(context.expression, "expression");
                ValidationSupport.requireValueOrChildren(context);
            }

            protected Builder from(Context context) {
                super.from(context);
                this.type = context.type;
                this.expression = context.expression;
                return this;
            }
        }
    }

    public static class Mapping
    extends BackboneElement {
        @Required
        private final Id identity;
        private final Uri uri;
        private final String name;
        private final String comment;

        private Mapping(Builder builder) {
            super(builder);
            this.identity = builder.identity;
            this.uri = builder.uri;
            this.name = builder.name;
            this.comment = builder.comment;
        }

        public Id getIdentity() {
            return this.identity;
        }

        public Uri getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identity != null || this.uri != null || this.name != null || this.comment != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identity, "identity", visitor);
                    this.accept(this.uri, "uri", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.comment, "comment", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mapping other = (Mapping)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identity, other.identity) && Objects.equals(this.uri, other.uri) && Objects.equals(this.name, other.name) && Objects.equals(this.comment, other.comment);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identity, this.uri, this.name, this.comment);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Id identity;
            private Uri uri;
            private String name;
            private String comment;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identity(Id identity) {
                this.identity = identity;
                return this;
            }

            public Builder uri(Uri uri) {
                this.uri = uri;
                return this;
            }

            public Builder name(java.lang.String name) {
                this.name = name == null ? null : String.of(name);
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder comment(java.lang.String comment) {
                this.comment = comment == null ? null : String.of(comment);
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            @Override
            public Mapping build() {
                Mapping mapping = new Mapping(this);
                if (this.validating) {
                    this.validate(mapping);
                }
                return mapping;
            }

            protected void validate(Mapping mapping) {
                super.validate(mapping);
                ValidationSupport.requireNonNull(mapping.identity, "identity");
                ValidationSupport.requireValueOrChildren(mapping);
            }

            protected Builder from(Mapping mapping) {
                super.from(mapping);
                this.identity = mapping.identity;
                this.uri = mapping.uri;
                this.name = mapping.name;
                this.comment = mapping.comment;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private List<Coding> keyword = new ArrayList<Coding>();
        private FHIRVersion fhirVersion;
        private List<Mapping> mapping = new ArrayList<Mapping>();
        private StructureDefinitionKind kind;
        private Boolean _abstract;
        private List<Context> context = new ArrayList<Context>();
        private List<String> contextInvariant = new ArrayList<String>();
        private Uri type;
        private Canonical baseDefinition;
        private TypeDerivationRule derivation;
        private Snapshot snapshot;
        private Differential differential;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder keyword(Coding ... keyword) {
            for (Coding value : keyword) {
                this.keyword.add(value);
            }
            return this;
        }

        public Builder keyword(Collection<Coding> keyword) {
            this.keyword = new ArrayList<Coding>(keyword);
            return this;
        }

        public Builder fhirVersion(FHIRVersion fhirVersion) {
            this.fhirVersion = fhirVersion;
            return this;
        }

        public Builder mapping(Mapping ... mapping) {
            for (Mapping value : mapping) {
                this.mapping.add(value);
            }
            return this;
        }

        public Builder mapping(Collection<Mapping> mapping) {
            this.mapping = new ArrayList<Mapping>(mapping);
            return this;
        }

        public Builder kind(StructureDefinitionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder _abstract(java.lang.Boolean _abstract) {
            this._abstract = _abstract == null ? null : Boolean.of(_abstract);
            return this;
        }

        public Builder _abstract(Boolean _abstract) {
            this._abstract = _abstract;
            return this;
        }

        public Builder context(Context ... context) {
            for (Context value : context) {
                this.context.add(value);
            }
            return this;
        }

        public Builder context(Collection<Context> context) {
            this.context = new ArrayList<Context>(context);
            return this;
        }

        public Builder contextInvariant(java.lang.String ... contextInvariant) {
            for (java.lang.String value : contextInvariant) {
                this.contextInvariant.add(value == null ? null : String.of(value));
            }
            return this;
        }

        public Builder contextInvariant(String ... contextInvariant) {
            for (String value : contextInvariant) {
                this.contextInvariant.add(value);
            }
            return this;
        }

        public Builder contextInvariant(Collection<String> contextInvariant) {
            this.contextInvariant = new ArrayList<String>(contextInvariant);
            return this;
        }

        public Builder type(Uri type) {
            this.type = type;
            return this;
        }

        public Builder baseDefinition(Canonical baseDefinition) {
            this.baseDefinition = baseDefinition;
            return this;
        }

        public Builder derivation(TypeDerivationRule derivation) {
            this.derivation = derivation;
            return this;
        }

        public Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder differential(Differential differential) {
            this.differential = differential;
            return this;
        }

        @Override
        public StructureDefinition build() {
            StructureDefinition structureDefinition = new StructureDefinition(this);
            if (this.validating) {
                this.validate(structureDefinition);
            }
            return structureDefinition;
        }

        protected void validate(StructureDefinition structureDefinition) {
            super.validate(structureDefinition);
            ValidationSupport.requireNonNull(structureDefinition.url, "url");
            ValidationSupport.checkList(structureDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(structureDefinition.name, "name");
            ValidationSupport.requireNonNull(structureDefinition.status, "status");
            ValidationSupport.checkList(structureDefinition.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(structureDefinition.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(structureDefinition.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(structureDefinition.keyword, "keyword", Coding.class);
            ValidationSupport.checkList(structureDefinition.mapping, "mapping", Mapping.class);
            ValidationSupport.requireNonNull(structureDefinition.kind, "kind");
            ValidationSupport.requireNonNull(structureDefinition._abstract, "abstract");
            ValidationSupport.checkList(structureDefinition.context, "context", Context.class);
            ValidationSupport.checkList(structureDefinition.contextInvariant, "contextInvariant", String.class);
            ValidationSupport.requireNonNull(structureDefinition.type, "type");
        }

        protected Builder from(StructureDefinition structureDefinition) {
            super.from(structureDefinition);
            this.url = structureDefinition.url;
            this.identifier.addAll(structureDefinition.identifier);
            this.version = structureDefinition.version;
            this.name = structureDefinition.name;
            this.title = structureDefinition.title;
            this.status = structureDefinition.status;
            this.experimental = structureDefinition.experimental;
            this.date = structureDefinition.date;
            this.publisher = structureDefinition.publisher;
            this.contact.addAll(structureDefinition.contact);
            this.description = structureDefinition.description;
            this.useContext.addAll(structureDefinition.useContext);
            this.jurisdiction.addAll(structureDefinition.jurisdiction);
            this.purpose = structureDefinition.purpose;
            this.copyright = structureDefinition.copyright;
            this.keyword.addAll(structureDefinition.keyword);
            this.fhirVersion = structureDefinition.fhirVersion;
            this.mapping.addAll(structureDefinition.mapping);
            this.kind = structureDefinition.kind;
            this._abstract = structureDefinition._abstract;
            this.context.addAll(structureDefinition.context);
            this.contextInvariant.addAll(structureDefinition.contextInvariant);
            this.type = structureDefinition.type;
            this.baseDefinition = structureDefinition.baseDefinition;
            this.derivation = structureDefinition.derivation;
            this.snapshot = structureDefinition.snapshot;
            this.differential = structureDefinition.differential;
            return this;
        }
    }
}

