/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.Status;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="verificationResult-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/verificationresult-need", expression="need.exists() implies (need.memberOf('http://hl7.org/fhir/ValueSet/verificationresult-need', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/VerificationResult", generated=true), @Constraint(id="verificationResult-1", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/verificationresult-validation-type", expression="validationType.exists() implies (validationType.memberOf('http://hl7.org/fhir/ValueSet/verificationresult-validation-type', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/VerificationResult", generated=true), @Constraint(id="verificationResult-2", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/verificationresult-failure-action", expression="failureAction.exists() implies (failureAction.memberOf('http://hl7.org/fhir/ValueSet/verificationresult-failure-action', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/VerificationResult", generated=true), @Constraint(id="verificationResult-3", level="Warning", location="primarySource.validationStatus", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/verificationresult-validation-status", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/verificationresult-validation-status', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/VerificationResult", generated=true), @Constraint(id="verificationResult-4", level="Warning", location="primarySource.canPushUpdates", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/verificationresult-can-push-updates", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/verificationresult-can-push-updates', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/VerificationResult", generated=true), @Constraint(id="verificationResult-5", level="Warning", location="primarySource.pushTypeAvailable", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/verificationresult-push-type-available", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/verificationresult-push-type-available', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/VerificationResult", generated=true)})
public class VerificationResult
extends DomainResource {
    @Summary
    private final List<Reference> target;
    @Summary
    private final List<String> targetLocation;
    @Summary
    @Binding(bindingName="need", strength=BindingStrength.Value.PREFERRED, description="The frequency with which the target must be validated.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-need")
    private final CodeableConcept need;
    @Summary
    @Binding(bindingName="status", strength=BindingStrength.Value.REQUIRED, description="The validation status of the target.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-status|4.0.1")
    @Required
    private final Status status;
    @Summary
    private final DateTime statusDate;
    @Summary
    @Binding(bindingName="validation-type", strength=BindingStrength.Value.PREFERRED, description="What the target is validated against.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-validation-type")
    private final CodeableConcept validationType;
    @Summary
    @Binding(bindingName="validation-process", strength=BindingStrength.Value.EXAMPLE, description="The primary process by which the target is validated.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-validation-process")
    private final List<CodeableConcept> validationProcess;
    private final Timing frequency;
    private final DateTime lastPerformed;
    private final Date nextScheduled;
    @Summary
    @Binding(bindingName="failure-action", strength=BindingStrength.Value.PREFERRED, description="The result if validation fails.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-failure-action")
    private final CodeableConcept failureAction;
    private final List<PrimarySource> primarySource;
    private final Attestation attestation;
    private final List<Validator> validator;

    private VerificationResult(Builder builder) {
        super(builder);
        this.target = Collections.unmodifiableList(builder.target);
        this.targetLocation = Collections.unmodifiableList(builder.targetLocation);
        this.need = builder.need;
        this.status = builder.status;
        this.statusDate = builder.statusDate;
        this.validationType = builder.validationType;
        this.validationProcess = Collections.unmodifiableList(builder.validationProcess);
        this.frequency = builder.frequency;
        this.lastPerformed = builder.lastPerformed;
        this.nextScheduled = builder.nextScheduled;
        this.failureAction = builder.failureAction;
        this.primarySource = Collections.unmodifiableList(builder.primarySource);
        this.attestation = builder.attestation;
        this.validator = Collections.unmodifiableList(builder.validator);
    }

    public List<Reference> getTarget() {
        return this.target;
    }

    public List<String> getTargetLocation() {
        return this.targetLocation;
    }

    public CodeableConcept getNeed() {
        return this.need;
    }

    public Status getStatus() {
        return this.status;
    }

    public DateTime getStatusDate() {
        return this.statusDate;
    }

    public CodeableConcept getValidationType() {
        return this.validationType;
    }

    public List<CodeableConcept> getValidationProcess() {
        return this.validationProcess;
    }

    public Timing getFrequency() {
        return this.frequency;
    }

    public DateTime getLastPerformed() {
        return this.lastPerformed;
    }

    public Date getNextScheduled() {
        return this.nextScheduled;
    }

    public CodeableConcept getFailureAction() {
        return this.failureAction;
    }

    public List<PrimarySource> getPrimarySource() {
        return this.primarySource;
    }

    public Attestation getAttestation() {
        return this.attestation;
    }

    public List<Validator> getValidator() {
        return this.validator;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.target.isEmpty() || !this.targetLocation.isEmpty() || this.need != null || this.status != null || this.statusDate != null || this.validationType != null || !this.validationProcess.isEmpty() || this.frequency != null || this.lastPerformed != null || this.nextScheduled != null || this.failureAction != null || !this.primarySource.isEmpty() || this.attestation != null || !this.validator.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.target, "target", visitor, Reference.class);
                this.accept(this.targetLocation, "targetLocation", visitor, String.class);
                this.accept(this.need, "need", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusDate, "statusDate", visitor);
                this.accept(this.validationType, "validationType", visitor);
                this.accept(this.validationProcess, "validationProcess", visitor, CodeableConcept.class);
                this.accept(this.frequency, "frequency", visitor);
                this.accept(this.lastPerformed, "lastPerformed", visitor);
                this.accept(this.nextScheduled, "nextScheduled", visitor);
                this.accept(this.failureAction, "failureAction", visitor);
                this.accept(this.primarySource, "primarySource", visitor, PrimarySource.class);
                this.accept(this.attestation, "attestation", visitor);
                this.accept(this.validator, "validator", visitor, Validator.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerificationResult other = (VerificationResult)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.target, other.target) && Objects.equals(this.targetLocation, other.targetLocation) && Objects.equals(this.need, other.need) && Objects.equals(this.status, other.status) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.validationType, other.validationType) && Objects.equals(this.validationProcess, other.validationProcess) && Objects.equals(this.frequency, other.frequency) && Objects.equals(this.lastPerformed, other.lastPerformed) && Objects.equals(this.nextScheduled, other.nextScheduled) && Objects.equals(this.failureAction, other.failureAction) && Objects.equals(this.primarySource, other.primarySource) && Objects.equals(this.attestation, other.attestation) && Objects.equals(this.validator, other.validator);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.target, this.targetLocation, this.need, this.status, this.statusDate, this.validationType, this.validationProcess, this.frequency, this.lastPerformed, this.nextScheduled, this.failureAction, this.primarySource, this.attestation, this.validator);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Validator
    extends BackboneElement {
        @ReferenceTarget(value={"Organization"})
        @Required
        private final Reference organization;
        private final String identityCertificate;
        private final Signature attestationSignature;

        private Validator(Builder builder) {
            super(builder);
            this.organization = builder.organization;
            this.identityCertificate = builder.identityCertificate;
            this.attestationSignature = builder.attestationSignature;
        }

        public Reference getOrganization() {
            return this.organization;
        }

        public String getIdentityCertificate() {
            return this.identityCertificate;
        }

        public Signature getAttestationSignature() {
            return this.attestationSignature;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.organization != null || this.identityCertificate != null || this.attestationSignature != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.organization, "organization", visitor);
                    this.accept(this.identityCertificate, "identityCertificate", visitor);
                    this.accept(this.attestationSignature, "attestationSignature", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Validator other = (Validator)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.organization, other.organization) && Objects.equals(this.identityCertificate, other.identityCertificate) && Objects.equals(this.attestationSignature, other.attestationSignature);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.organization, this.identityCertificate, this.attestationSignature);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference organization;
            private String identityCertificate;
            private Signature attestationSignature;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder organization(Reference organization) {
                this.organization = organization;
                return this;
            }

            public Builder identityCertificate(java.lang.String identityCertificate) {
                this.identityCertificate = identityCertificate == null ? null : String.of(identityCertificate);
                return this;
            }

            public Builder identityCertificate(String identityCertificate) {
                this.identityCertificate = identityCertificate;
                return this;
            }

            public Builder attestationSignature(Signature attestationSignature) {
                this.attestationSignature = attestationSignature;
                return this;
            }

            @Override
            public Validator build() {
                Validator validator = new Validator(this);
                if (this.validating) {
                    this.validate(validator);
                }
                return validator;
            }

            protected void validate(Validator validator) {
                super.validate(validator);
                ValidationSupport.requireNonNull(validator.organization, "organization");
                ValidationSupport.checkReferenceType(validator.organization, "organization", "Organization");
                ValidationSupport.requireValueOrChildren(validator);
            }

            protected Builder from(Validator validator) {
                super.from(validator);
                this.organization = validator.organization;
                this.identityCertificate = validator.identityCertificate;
                this.attestationSignature = validator.attestationSignature;
                return this;
            }
        }
    }

    public static class Attestation
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        private final Reference who;
        @Summary
        @ReferenceTarget(value={"Organization", "Practitioner", "PractitionerRole"})
        private final Reference onBehalfOf;
        @Summary
        @Binding(bindingName="communication-method", strength=BindingStrength.Value.EXAMPLE, description="Method for communicating with the data source (manual; API; Push).", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-communication-method")
        private final CodeableConcept communicationMethod;
        @Summary
        private final Date date;
        private final String sourceIdentityCertificate;
        private final String proxyIdentityCertificate;
        private final Signature proxySignature;
        private final Signature sourceSignature;

        private Attestation(Builder builder) {
            super(builder);
            this.who = builder.who;
            this.onBehalfOf = builder.onBehalfOf;
            this.communicationMethod = builder.communicationMethod;
            this.date = builder.date;
            this.sourceIdentityCertificate = builder.sourceIdentityCertificate;
            this.proxyIdentityCertificate = builder.proxyIdentityCertificate;
            this.proxySignature = builder.proxySignature;
            this.sourceSignature = builder.sourceSignature;
        }

        public Reference getWho() {
            return this.who;
        }

        public Reference getOnBehalfOf() {
            return this.onBehalfOf;
        }

        public CodeableConcept getCommunicationMethod() {
            return this.communicationMethod;
        }

        public Date getDate() {
            return this.date;
        }

        public String getSourceIdentityCertificate() {
            return this.sourceIdentityCertificate;
        }

        public String getProxyIdentityCertificate() {
            return this.proxyIdentityCertificate;
        }

        public Signature getProxySignature() {
            return this.proxySignature;
        }

        public Signature getSourceSignature() {
            return this.sourceSignature;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.who != null || this.onBehalfOf != null || this.communicationMethod != null || this.date != null || this.sourceIdentityCertificate != null || this.proxyIdentityCertificate != null || this.proxySignature != null || this.sourceSignature != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.who, "who", visitor);
                    this.accept(this.onBehalfOf, "onBehalfOf", visitor);
                    this.accept(this.communicationMethod, "communicationMethod", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.sourceIdentityCertificate, "sourceIdentityCertificate", visitor);
                    this.accept(this.proxyIdentityCertificate, "proxyIdentityCertificate", visitor);
                    this.accept(this.proxySignature, "proxySignature", visitor);
                    this.accept(this.sourceSignature, "sourceSignature", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attestation other = (Attestation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.who, other.who) && Objects.equals(this.onBehalfOf, other.onBehalfOf) && Objects.equals(this.communicationMethod, other.communicationMethod) && Objects.equals(this.date, other.date) && Objects.equals(this.sourceIdentityCertificate, other.sourceIdentityCertificate) && Objects.equals(this.proxyIdentityCertificate, other.proxyIdentityCertificate) && Objects.equals(this.proxySignature, other.proxySignature) && Objects.equals(this.sourceSignature, other.sourceSignature);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.who, this.onBehalfOf, this.communicationMethod, this.date, this.sourceIdentityCertificate, this.proxyIdentityCertificate, this.proxySignature, this.sourceSignature);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference who;
            private Reference onBehalfOf;
            private CodeableConcept communicationMethod;
            private Date date;
            private String sourceIdentityCertificate;
            private String proxyIdentityCertificate;
            private Signature proxySignature;
            private Signature sourceSignature;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder who(Reference who) {
                this.who = who;
                return this;
            }

            public Builder onBehalfOf(Reference onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder communicationMethod(CodeableConcept communicationMethod) {
                this.communicationMethod = communicationMethod;
                return this;
            }

            public Builder date(LocalDate date) {
                this.date = date == null ? null : Date.of(date);
                return this;
            }

            public Builder date(Date date) {
                this.date = date;
                return this;
            }

            public Builder sourceIdentityCertificate(java.lang.String sourceIdentityCertificate) {
                this.sourceIdentityCertificate = sourceIdentityCertificate == null ? null : String.of(sourceIdentityCertificate);
                return this;
            }

            public Builder sourceIdentityCertificate(String sourceIdentityCertificate) {
                this.sourceIdentityCertificate = sourceIdentityCertificate;
                return this;
            }

            public Builder proxyIdentityCertificate(java.lang.String proxyIdentityCertificate) {
                this.proxyIdentityCertificate = proxyIdentityCertificate == null ? null : String.of(proxyIdentityCertificate);
                return this;
            }

            public Builder proxyIdentityCertificate(String proxyIdentityCertificate) {
                this.proxyIdentityCertificate = proxyIdentityCertificate;
                return this;
            }

            public Builder proxySignature(Signature proxySignature) {
                this.proxySignature = proxySignature;
                return this;
            }

            public Builder sourceSignature(Signature sourceSignature) {
                this.sourceSignature = sourceSignature;
                return this;
            }

            @Override
            public Attestation build() {
                Attestation attestation = new Attestation(this);
                if (this.validating) {
                    this.validate(attestation);
                }
                return attestation;
            }

            protected void validate(Attestation attestation) {
                super.validate(attestation);
                ValidationSupport.checkReferenceType(attestation.who, "who", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.checkReferenceType(attestation.onBehalfOf, "onBehalfOf", "Organization", "Practitioner", "PractitionerRole");
                ValidationSupport.requireValueOrChildren(attestation);
            }

            protected Builder from(Attestation attestation) {
                super.from(attestation);
                this.who = attestation.who;
                this.onBehalfOf = attestation.onBehalfOf;
                this.communicationMethod = attestation.communicationMethod;
                this.date = attestation.date;
                this.sourceIdentityCertificate = attestation.sourceIdentityCertificate;
                this.proxyIdentityCertificate = attestation.proxyIdentityCertificate;
                this.proxySignature = attestation.proxySignature;
                this.sourceSignature = attestation.sourceSignature;
                return this;
            }
        }
    }

    public static class PrimarySource
    extends BackboneElement {
        @ReferenceTarget(value={"Organization", "Practitioner", "PractitionerRole"})
        private final Reference who;
        @Summary
        @Binding(bindingName="primary-source-type", strength=BindingStrength.Value.EXAMPLE, description="Type of the validation primary source.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-primary-source-type")
        private final List<CodeableConcept> type;
        @Summary
        @Binding(bindingName="communication-method", strength=BindingStrength.Value.EXAMPLE, description="Method for communicating with the data source (manual; API; Push).", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-communication-method")
        private final List<CodeableConcept> communicationMethod;
        @Binding(bindingName="validation-status", strength=BindingStrength.Value.PREFERRED, description="Status of the validation of the target against the primary source.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-validation-status")
        private final CodeableConcept validationStatus;
        private final DateTime validationDate;
        @Summary
        @Binding(bindingName="can-push-updates", strength=BindingStrength.Value.PREFERRED, description="Ability of the primary source to push updates/alerts.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-can-push-updates")
        private final CodeableConcept canPushUpdates;
        @Binding(bindingName="push-type-available", strength=BindingStrength.Value.PREFERRED, description="Type of alerts/updates the primary source can send.", valueSet="http://hl7.org/fhir/ValueSet/verificationresult-push-type-available")
        private final List<CodeableConcept> pushTypeAvailable;

        private PrimarySource(Builder builder) {
            super(builder);
            this.who = builder.who;
            this.type = Collections.unmodifiableList(builder.type);
            this.communicationMethod = Collections.unmodifiableList(builder.communicationMethod);
            this.validationStatus = builder.validationStatus;
            this.validationDate = builder.validationDate;
            this.canPushUpdates = builder.canPushUpdates;
            this.pushTypeAvailable = Collections.unmodifiableList(builder.pushTypeAvailable);
        }

        public Reference getWho() {
            return this.who;
        }

        public List<CodeableConcept> getType() {
            return this.type;
        }

        public List<CodeableConcept> getCommunicationMethod() {
            return this.communicationMethod;
        }

        public CodeableConcept getValidationStatus() {
            return this.validationStatus;
        }

        public DateTime getValidationDate() {
            return this.validationDate;
        }

        public CodeableConcept getCanPushUpdates() {
            return this.canPushUpdates;
        }

        public List<CodeableConcept> getPushTypeAvailable() {
            return this.pushTypeAvailable;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.who != null || !this.type.isEmpty() || !this.communicationMethod.isEmpty() || this.validationStatus != null || this.validationDate != null || this.canPushUpdates != null || !this.pushTypeAvailable.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.who, "who", visitor);
                    this.accept(this.type, "type", visitor, CodeableConcept.class);
                    this.accept(this.communicationMethod, "communicationMethod", visitor, CodeableConcept.class);
                    this.accept(this.validationStatus, "validationStatus", visitor);
                    this.accept(this.validationDate, "validationDate", visitor);
                    this.accept(this.canPushUpdates, "canPushUpdates", visitor);
                    this.accept(this.pushTypeAvailable, "pushTypeAvailable", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimarySource other = (PrimarySource)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.who, other.who) && Objects.equals(this.type, other.type) && Objects.equals(this.communicationMethod, other.communicationMethod) && Objects.equals(this.validationStatus, other.validationStatus) && Objects.equals(this.validationDate, other.validationDate) && Objects.equals(this.canPushUpdates, other.canPushUpdates) && Objects.equals(this.pushTypeAvailable, other.pushTypeAvailable);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.who, this.type, this.communicationMethod, this.validationStatus, this.validationDate, this.canPushUpdates, this.pushTypeAvailable);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference who;
            private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> communicationMethod = new ArrayList<CodeableConcept>();
            private CodeableConcept validationStatus;
            private DateTime validationDate;
            private CodeableConcept canPushUpdates;
            private List<CodeableConcept> pushTypeAvailable = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder who(Reference who) {
                this.who = who;
                return this;
            }

            public Builder type(CodeableConcept ... type) {
                for (CodeableConcept value : type) {
                    this.type.add(value);
                }
                return this;
            }

            public Builder type(Collection<CodeableConcept> type) {
                this.type = new ArrayList<CodeableConcept>(type);
                return this;
            }

            public Builder communicationMethod(CodeableConcept ... communicationMethod) {
                for (CodeableConcept value : communicationMethod) {
                    this.communicationMethod.add(value);
                }
                return this;
            }

            public Builder communicationMethod(Collection<CodeableConcept> communicationMethod) {
                this.communicationMethod = new ArrayList<CodeableConcept>(communicationMethod);
                return this;
            }

            public Builder validationStatus(CodeableConcept validationStatus) {
                this.validationStatus = validationStatus;
                return this;
            }

            public Builder validationDate(DateTime validationDate) {
                this.validationDate = validationDate;
                return this;
            }

            public Builder canPushUpdates(CodeableConcept canPushUpdates) {
                this.canPushUpdates = canPushUpdates;
                return this;
            }

            public Builder pushTypeAvailable(CodeableConcept ... pushTypeAvailable) {
                for (CodeableConcept value : pushTypeAvailable) {
                    this.pushTypeAvailable.add(value);
                }
                return this;
            }

            public Builder pushTypeAvailable(Collection<CodeableConcept> pushTypeAvailable) {
                this.pushTypeAvailable = new ArrayList<CodeableConcept>(pushTypeAvailable);
                return this;
            }

            @Override
            public PrimarySource build() {
                PrimarySource primarySource = new PrimarySource(this);
                if (this.validating) {
                    this.validate(primarySource);
                }
                return primarySource;
            }

            protected void validate(PrimarySource primarySource) {
                super.validate(primarySource);
                ValidationSupport.checkList(primarySource.type, "type", CodeableConcept.class);
                ValidationSupport.checkList(primarySource.communicationMethod, "communicationMethod", CodeableConcept.class);
                ValidationSupport.checkList(primarySource.pushTypeAvailable, "pushTypeAvailable", CodeableConcept.class);
                ValidationSupport.checkReferenceType(primarySource.who, "who", "Organization", "Practitioner", "PractitionerRole");
                ValidationSupport.requireValueOrChildren(primarySource);
            }

            protected Builder from(PrimarySource primarySource) {
                super.from(primarySource);
                this.who = primarySource.who;
                this.type.addAll(primarySource.type);
                this.communicationMethod.addAll(primarySource.communicationMethod);
                this.validationStatus = primarySource.validationStatus;
                this.validationDate = primarySource.validationDate;
                this.canPushUpdates = primarySource.canPushUpdates;
                this.pushTypeAvailable.addAll(primarySource.pushTypeAvailable);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Reference> target = new ArrayList<Reference>();
        private List<String> targetLocation = new ArrayList<String>();
        private CodeableConcept need;
        private Status status;
        private DateTime statusDate;
        private CodeableConcept validationType;
        private List<CodeableConcept> validationProcess = new ArrayList<CodeableConcept>();
        private Timing frequency;
        private DateTime lastPerformed;
        private Date nextScheduled;
        private CodeableConcept failureAction;
        private List<PrimarySource> primarySource = new ArrayList<PrimarySource>();
        private Attestation attestation;
        private List<Validator> validator = new ArrayList<Validator>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder target(Reference ... target) {
            for (Reference value : target) {
                this.target.add(value);
            }
            return this;
        }

        public Builder target(Collection<Reference> target) {
            this.target = new ArrayList<Reference>(target);
            return this;
        }

        public Builder targetLocation(java.lang.String ... targetLocation) {
            for (java.lang.String value : targetLocation) {
                this.targetLocation.add(value == null ? null : String.of(value));
            }
            return this;
        }

        public Builder targetLocation(String ... targetLocation) {
            for (String value : targetLocation) {
                this.targetLocation.add(value);
            }
            return this;
        }

        public Builder targetLocation(Collection<String> targetLocation) {
            this.targetLocation = new ArrayList<String>(targetLocation);
            return this;
        }

        public Builder need(CodeableConcept need) {
            this.need = need;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder statusDate(DateTime statusDate) {
            this.statusDate = statusDate;
            return this;
        }

        public Builder validationType(CodeableConcept validationType) {
            this.validationType = validationType;
            return this;
        }

        public Builder validationProcess(CodeableConcept ... validationProcess) {
            for (CodeableConcept value : validationProcess) {
                this.validationProcess.add(value);
            }
            return this;
        }

        public Builder validationProcess(Collection<CodeableConcept> validationProcess) {
            this.validationProcess = new ArrayList<CodeableConcept>(validationProcess);
            return this;
        }

        public Builder frequency(Timing frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder lastPerformed(DateTime lastPerformed) {
            this.lastPerformed = lastPerformed;
            return this;
        }

        public Builder nextScheduled(LocalDate nextScheduled) {
            this.nextScheduled = nextScheduled == null ? null : Date.of(nextScheduled);
            return this;
        }

        public Builder nextScheduled(Date nextScheduled) {
            this.nextScheduled = nextScheduled;
            return this;
        }

        public Builder failureAction(CodeableConcept failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        public Builder primarySource(PrimarySource ... primarySource) {
            for (PrimarySource value : primarySource) {
                this.primarySource.add(value);
            }
            return this;
        }

        public Builder primarySource(Collection<PrimarySource> primarySource) {
            this.primarySource = new ArrayList<PrimarySource>(primarySource);
            return this;
        }

        public Builder attestation(Attestation attestation) {
            this.attestation = attestation;
            return this;
        }

        public Builder validator(Validator ... validator) {
            for (Validator value : validator) {
                this.validator.add(value);
            }
            return this;
        }

        public Builder validator(Collection<Validator> validator) {
            this.validator = new ArrayList<Validator>(validator);
            return this;
        }

        @Override
        public VerificationResult build() {
            VerificationResult verificationResult = new VerificationResult(this);
            if (this.validating) {
                this.validate(verificationResult);
            }
            return verificationResult;
        }

        protected void validate(VerificationResult verificationResult) {
            super.validate(verificationResult);
            ValidationSupport.checkList(verificationResult.target, "target", Reference.class);
            ValidationSupport.checkList(verificationResult.targetLocation, "targetLocation", String.class);
            ValidationSupport.requireNonNull(verificationResult.status, "status");
            ValidationSupport.checkList(verificationResult.validationProcess, "validationProcess", CodeableConcept.class);
            ValidationSupport.checkList(verificationResult.primarySource, "primarySource", PrimarySource.class);
            ValidationSupport.checkList(verificationResult.validator, "validator", Validator.class);
        }

        protected Builder from(VerificationResult verificationResult) {
            super.from(verificationResult);
            this.target.addAll(verificationResult.target);
            this.targetLocation.addAll(verificationResult.targetLocation);
            this.need = verificationResult.need;
            this.status = verificationResult.status;
            this.statusDate = verificationResult.statusDate;
            this.validationType = verificationResult.validationType;
            this.validationProcess.addAll(verificationResult.validationProcess);
            this.frequency = verificationResult.frequency;
            this.lastPerformed = verificationResult.lastPerformed;
            this.nextScheduled = verificationResult.nextScheduled;
            this.failureAction = verificationResult.failureAction;
            this.primarySource.addAll(verificationResult.primarySource);
            this.attestation = verificationResult.attestation;
            this.validator.addAll(verificationResult.validator);
            return this;
        }
    }
}

