/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ContactPointSystem;
import com.ibm.fhir.model.type.code.ContactPointUse;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="cpt-2", level="Rule", location="(base)", description="A system is required if a value is provided.", expression="value.empty() or system.exists()", source="http://hl7.org/fhir/StructureDefinition/ContactPoint")
public class ContactPoint
extends Element {
    @Summary
    @Binding(bindingName="ContactPointSystem", strength=BindingStrength.Value.REQUIRED, description="Telecommunications form for contact point.", valueSet="http://hl7.org/fhir/ValueSet/contact-point-system|4.0.1")
    private final ContactPointSystem system;
    @Summary
    private final String value;
    @Summary
    @Binding(bindingName="ContactPointUse", strength=BindingStrength.Value.REQUIRED, description="Use of contact point.", valueSet="http://hl7.org/fhir/ValueSet/contact-point-use|4.0.1")
    private final ContactPointUse use;
    @Summary
    private final PositiveInt rank;
    @Summary
    private final Period period;

    private ContactPoint(Builder builder) {
        super(builder);
        this.system = builder.system;
        this.value = builder.value;
        this.use = builder.use;
        this.rank = builder.rank;
        this.period = builder.period;
    }

    public ContactPointSystem getSystem() {
        return this.system;
    }

    public String getValue() {
        return this.value;
    }

    public ContactPointUse getUse() {
        return this.use;
    }

    public PositiveInt getRank() {
        return this.rank;
    }

    public Period getPeriod() {
        return this.period;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.system != null || this.value != null || this.use != null || this.rank != null || this.period != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.system, "system", visitor);
                this.accept(this.value, "value", visitor);
                this.accept(this.use, "use", visitor);
                this.accept(this.rank, "rank", visitor);
                this.accept(this.period, "period", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactPoint other = (ContactPoint)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.system, other.system) && Objects.equals(this.value, other.value) && Objects.equals(this.use, other.use) && Objects.equals(this.rank, other.rank) && Objects.equals(this.period, other.period);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.system, this.value, this.use, this.rank, this.period);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private ContactPointSystem system;
        private String value;
        private ContactPointUse use;
        private PositiveInt rank;
        private Period period;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder system(ContactPointSystem system) {
            this.system = system;
            return this;
        }

        public Builder value(java.lang.String value) {
            this.value = value == null ? null : String.of(value);
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder use(ContactPointUse use) {
            this.use = use;
            return this;
        }

        public Builder rank(PositiveInt rank) {
            this.rank = rank;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        @Override
        public ContactPoint build() {
            ContactPoint contactPoint = new ContactPoint(this);
            if (this.validating) {
                this.validate(contactPoint);
            }
            return contactPoint;
        }

        protected void validate(ContactPoint contactPoint) {
            super.validate(contactPoint);
            ValidationSupport.requireValueOrChildren(contactPoint);
        }

        protected Builder from(ContactPoint contactPoint) {
            super.from(contactPoint);
            this.system = contactPoint.system;
            this.value = contactPoint.value;
            this.use = contactPoint.use;
            this.rank = contactPoint.rank;
            this.period = contactPoint.period;
            return this;
        }
    }
}

