/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="rat-1", level="Rule", location="(base)", description="Numerator and denominator SHALL both be present, or both are absent. If both are absent, there SHALL be some extension present", expression="(numerator.empty() xor denominator.exists()) and (numerator.exists() or extension.exists())", source="http://hl7.org/fhir/StructureDefinition/Ratio")
public class Ratio
extends Element {
    @Summary
    private final Quantity numerator;
    @Summary
    private final Quantity denominator;

    private Ratio(Builder builder) {
        super(builder);
        this.numerator = builder.numerator;
        this.denominator = builder.denominator;
    }

    public Quantity getNumerator() {
        return this.numerator;
    }

    public Quantity getDenominator() {
        return this.denominator;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.numerator != null || this.denominator != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.numerator, "numerator", visitor);
                this.accept(this.denominator, "denominator", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ratio other = (Ratio)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.numerator, other.numerator) && Objects.equals(this.denominator, other.denominator);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.numerator, this.denominator);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Quantity numerator;
        private Quantity denominator;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder numerator(Quantity numerator) {
            this.numerator = numerator;
            return this;
        }

        public Builder denominator(Quantity denominator) {
            this.denominator = denominator;
            return this;
        }

        @Override
        public Ratio build() {
            Ratio ratio = new Ratio(this);
            if (this.validating) {
                this.validate(ratio);
            }
            return ratio;
        }

        protected void validate(Ratio ratio) {
            super.validate(ratio);
            ValidationSupport.requireValueOrChildren(ratio);
        }

        protected Builder from(Ratio ratio) {
            super.from(ratio);
            this.numerator = ratio.numerator;
            this.denominator = ratio.denominator;
            return this;
        }
    }
}

