/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Constraint(id="signature-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/signature-type", expression="type.exists() and type.all(memberOf('http://hl7.org/fhir/ValueSet/signature-type', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Signature", generated=true)
public class Signature
extends Element {
    @Summary
    @Binding(bindingName="SignatureType", strength=BindingStrength.Value.PREFERRED, description="An indication of the reason that an entity signed the object.", valueSet="http://hl7.org/fhir/ValueSet/signature-type")
    @Required
    private final List<Coding> type;
    @Summary
    @Required
    private final Instant when;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization"})
    @Required
    private final Reference who;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization"})
    private final Reference onBehalfOf;
    @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
    private final Code targetFormat;
    @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
    private final Code sigFormat;
    private final Base64Binary data;

    private Signature(Builder builder) {
        super(builder);
        this.type = Collections.unmodifiableList(builder.type);
        this.when = builder.when;
        this.who = builder.who;
        this.onBehalfOf = builder.onBehalfOf;
        this.targetFormat = builder.targetFormat;
        this.sigFormat = builder.sigFormat;
        this.data = builder.data;
    }

    public List<Coding> getType() {
        return this.type;
    }

    public Instant getWhen() {
        return this.when;
    }

    public Reference getWho() {
        return this.who;
    }

    public Reference getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public Code getTargetFormat() {
        return this.targetFormat;
    }

    public Code getSigFormat() {
        return this.sigFormat;
    }

    public Base64Binary getData() {
        return this.data;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.type.isEmpty() || this.when != null || this.who != null || this.onBehalfOf != null || this.targetFormat != null || this.sigFormat != null || this.data != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.type, "type", visitor, Coding.class);
                this.accept(this.when, "when", visitor);
                this.accept(this.who, "who", visitor);
                this.accept(this.onBehalfOf, "onBehalfOf", visitor);
                this.accept(this.targetFormat, "targetFormat", visitor);
                this.accept(this.sigFormat, "sigFormat", visitor);
                this.accept(this.data, "data", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.type, other.type) && Objects.equals(this.when, other.when) && Objects.equals(this.who, other.who) && Objects.equals(this.onBehalfOf, other.onBehalfOf) && Objects.equals(this.targetFormat, other.targetFormat) && Objects.equals(this.sigFormat, other.sigFormat) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.type, this.when, this.who, this.onBehalfOf, this.targetFormat, this.sigFormat, this.data);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private List<Coding> type = new ArrayList<Coding>();
        private Instant when;
        private Reference who;
        private Reference onBehalfOf;
        private Code targetFormat;
        private Code sigFormat;
        private Base64Binary data;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder type(Coding ... type) {
            for (Coding value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<Coding> type) {
            this.type = new ArrayList<Coding>(type);
            return this;
        }

        public Builder when(ZonedDateTime when) {
            this.when = when == null ? null : Instant.of(when);
            return this;
        }

        public Builder when(Instant when) {
            this.when = when;
            return this;
        }

        public Builder who(Reference who) {
            this.who = who;
            return this;
        }

        public Builder onBehalfOf(Reference onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            return this;
        }

        public Builder targetFormat(Code targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }

        public Builder sigFormat(Code sigFormat) {
            this.sigFormat = sigFormat;
            return this;
        }

        public Builder data(Base64Binary data) {
            this.data = data;
            return this;
        }

        @Override
        public Signature build() {
            Signature signature = new Signature(this);
            if (this.validating) {
                this.validate(signature);
            }
            return signature;
        }

        protected void validate(Signature signature) {
            super.validate(signature);
            ValidationSupport.checkNonEmptyList(signature.type, "type", Coding.class);
            ValidationSupport.requireNonNull(signature.when, "when");
            ValidationSupport.requireNonNull(signature.who, "who");
            ValidationSupport.checkReferenceType(signature.who, "who", "Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization");
            ValidationSupport.checkReferenceType(signature.onBehalfOf, "onBehalfOf", "Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization");
            ValidationSupport.requireValueOrChildren(signature);
        }

        protected Builder from(Signature signature) {
            super.from(signature);
            this.type.addAll(signature.type);
            this.when = signature.when;
            this.who = signature.who;
            this.onBehalfOf = signature.onBehalfOf;
            this.targetFormat = signature.targetFormat;
            this.sigFormat = signature.sigFormat;
            this.data = signature.data;
            return this;
        }
    }
}

