/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

public class UnsignedInt
extends Integer {
    private static final int MIN_VALUE = 0;

    private UnsignedInt(Builder builder) {
        super(builder);
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren();
    }

    public static UnsignedInt of(java.lang.Integer value) {
        Objects.requireNonNull(value, "value");
        return UnsignedInt.builder().value(value).build();
    }

    public static UnsignedInt of(String value) {
        Objects.requireNonNull(value, "value");
        return UnsignedInt.builder().value(value).build();
    }

    public static Integer integer(String value) {
        Objects.requireNonNull(value, "value");
        return UnsignedInt.builder().value(value).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedInt other = (UnsignedInt)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Integer.Builder {
        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.Integer value) {
            return (Builder)super.value(value);
        }

        @Override
        public Builder value(String value) {
            return (Builder)super.value(value);
        }

        @Override
        public UnsignedInt build() {
            UnsignedInt unsignedInt = new UnsignedInt(this);
            if (this.validating) {
                this.validate(unsignedInt);
            }
            return unsignedInt;
        }

        protected void validate(UnsignedInt unsignedInt) {
            super.validate(unsignedInt);
            ValidationSupport.checkValue(unsignedInt.value, 0);
            ValidationSupport.requireValueOrChildren(unsignedInt);
        }

        protected Builder from(UnsignedInt unsignedInt) {
            super.from(unsignedInt);
            return this;
        }
    }
}

