/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;
import org.owasp.encoder.Encode;

public class Xhtml
extends Element {
    private static final String DIV_OPEN = "<div xmlns=\"http://www.w3.org/1999/xhtml\">";
    private static final String DIV_CLOSE = "</div>";
    @Required
    private final String value;

    private Xhtml(Builder builder) {
        super(builder);
        this.value = builder.value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren();
    }

    public static Xhtml of(String value) {
        Objects.requireNonNull(value, "value");
        return Xhtml.builder().value(value).build();
    }

    public static Xhtml xhtml(String value) {
        Objects.requireNonNull(value, "value");
        return Xhtml.builder().value(value).build();
    }

    public static Xhtml from(String plainText) {
        Objects.requireNonNull(plainText, "plainText");
        return Xhtml.builder().value(DIV_OPEN + Encode.forHtmlContent((String)plainText) + DIV_CLOSE).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Xhtml other = (Xhtml)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private String value;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Xhtml build() {
            Xhtml xhtml = new Xhtml(this);
            if (this.validating) {
                this.validate(xhtml);
            }
            return xhtml;
        }

        protected void validate(Xhtml xhtml) {
            super.validate(xhtml);
            ValidationSupport.requireNonNull(xhtml.value, "value");
            ValidationSupport.prohibited(xhtml.extension, "extension");
            ValidationSupport.checkXHTMLContent(xhtml.value);
        }

        protected Builder from(Xhtml xhtml) {
            super.from(xhtml);
            this.value = xhtml.value;
            return this;
        }
    }
}

