/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/action-required-behavior")
public class ActionRequiredBehavior
extends Code {
    public static final ActionRequiredBehavior MUST = ActionRequiredBehavior.builder().value(Value.MUST).build();
    public static final ActionRequiredBehavior COULD = ActionRequiredBehavior.builder().value(Value.COULD).build();
    public static final ActionRequiredBehavior MUST_UNLESS_DOCUMENTED = ActionRequiredBehavior.builder().value(Value.MUST_UNLESS_DOCUMENTED).build();
    private volatile int hashCode;

    private ActionRequiredBehavior(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ActionRequiredBehavior of(Value value) {
        switch (value) {
            case MUST: {
                return MUST;
            }
            case COULD: {
                return COULD;
            }
            case MUST_UNLESS_DOCUMENTED: {
                return MUST_UNLESS_DOCUMENTED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ActionRequiredBehavior of(java.lang.String value) {
        return ActionRequiredBehavior.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ActionRequiredBehavior.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ActionRequiredBehavior.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionRequiredBehavior other = (ActionRequiredBehavior)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        MUST("must"),
        COULD("could"),
        MUST_UNLESS_DOCUMENTED("must-unless-documented");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "must": {
                    return MUST;
                }
                case "could": {
                    return COULD;
                }
                case "must-unless-documented": {
                    return MUST_UNLESS_DOCUMENTED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ActionRequiredBehavior build() {
            ActionRequiredBehavior actionRequiredBehavior = new ActionRequiredBehavior(this);
            if (this.validating) {
                this.validate(actionRequiredBehavior);
            }
            return actionRequiredBehavior;
        }

        protected void validate(ActionRequiredBehavior actionRequiredBehavior) {
            super.validate(actionRequiredBehavior);
        }

        protected Builder from(ActionRequiredBehavior actionRequiredBehavior) {
            super.from(actionRequiredBehavior);
            return this;
        }
    }
}

