/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/action-selection-behavior")
public class ActionSelectionBehavior
extends Code {
    public static final ActionSelectionBehavior ANY = ActionSelectionBehavior.builder().value(Value.ANY).build();
    public static final ActionSelectionBehavior ALL = ActionSelectionBehavior.builder().value(Value.ALL).build();
    public static final ActionSelectionBehavior ALL_OR_NONE = ActionSelectionBehavior.builder().value(Value.ALL_OR_NONE).build();
    public static final ActionSelectionBehavior EXACTLY_ONE = ActionSelectionBehavior.builder().value(Value.EXACTLY_ONE).build();
    public static final ActionSelectionBehavior AT_MOST_ONE = ActionSelectionBehavior.builder().value(Value.AT_MOST_ONE).build();
    public static final ActionSelectionBehavior ONE_OR_MORE = ActionSelectionBehavior.builder().value(Value.ONE_OR_MORE).build();
    private volatile int hashCode;

    private ActionSelectionBehavior(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ActionSelectionBehavior of(Value value) {
        switch (value) {
            case ANY: {
                return ANY;
            }
            case ALL: {
                return ALL;
            }
            case ALL_OR_NONE: {
                return ALL_OR_NONE;
            }
            case EXACTLY_ONE: {
                return EXACTLY_ONE;
            }
            case AT_MOST_ONE: {
                return AT_MOST_ONE;
            }
            case ONE_OR_MORE: {
                return ONE_OR_MORE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ActionSelectionBehavior of(java.lang.String value) {
        return ActionSelectionBehavior.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ActionSelectionBehavior.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ActionSelectionBehavior.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionSelectionBehavior other = (ActionSelectionBehavior)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ANY("any"),
        ALL("all"),
        ALL_OR_NONE("all-or-none"),
        EXACTLY_ONE("exactly-one"),
        AT_MOST_ONE("at-most-one"),
        ONE_OR_MORE("one-or-more");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "any": {
                    return ANY;
                }
                case "all": {
                    return ALL;
                }
                case "all-or-none": {
                    return ALL_OR_NONE;
                }
                case "exactly-one": {
                    return EXACTLY_ONE;
                }
                case "at-most-one": {
                    return AT_MOST_ONE;
                }
                case "one-or-more": {
                    return ONE_OR_MORE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ActionSelectionBehavior build() {
            ActionSelectionBehavior actionSelectionBehavior = new ActionSelectionBehavior(this);
            if (this.validating) {
                this.validate(actionSelectionBehavior);
            }
            return actionSelectionBehavior;
        }

        protected void validate(ActionSelectionBehavior actionSelectionBehavior) {
            super.validate(actionSelectionBehavior);
        }

        protected Builder from(ActionSelectionBehavior actionSelectionBehavior) {
            super.from(actionSelectionBehavior);
            return this;
        }
    }
}

