/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/assert-operator-codes")
public class AssertionOperatorType
extends Code {
    public static final AssertionOperatorType EQUALS = AssertionOperatorType.builder().value(Value.EQUALS).build();
    public static final AssertionOperatorType NOT_EQUALS = AssertionOperatorType.builder().value(Value.NOT_EQUALS).build();
    public static final AssertionOperatorType IN = AssertionOperatorType.builder().value(Value.IN).build();
    public static final AssertionOperatorType NOT_IN = AssertionOperatorType.builder().value(Value.NOT_IN).build();
    public static final AssertionOperatorType GREATER_THAN = AssertionOperatorType.builder().value(Value.GREATER_THAN).build();
    public static final AssertionOperatorType LESS_THAN = AssertionOperatorType.builder().value(Value.LESS_THAN).build();
    public static final AssertionOperatorType EMPTY = AssertionOperatorType.builder().value(Value.EMPTY).build();
    public static final AssertionOperatorType NOT_EMPTY = AssertionOperatorType.builder().value(Value.NOT_EMPTY).build();
    public static final AssertionOperatorType CONTAINS = AssertionOperatorType.builder().value(Value.CONTAINS).build();
    public static final AssertionOperatorType NOT_CONTAINS = AssertionOperatorType.builder().value(Value.NOT_CONTAINS).build();
    public static final AssertionOperatorType EVAL = AssertionOperatorType.builder().value(Value.EVAL).build();
    private volatile int hashCode;

    private AssertionOperatorType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static AssertionOperatorType of(Value value) {
        switch (value) {
            case EQUALS: {
                return EQUALS;
            }
            case NOT_EQUALS: {
                return NOT_EQUALS;
            }
            case IN: {
                return IN;
            }
            case NOT_IN: {
                return NOT_IN;
            }
            case GREATER_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN: {
                return LESS_THAN;
            }
            case EMPTY: {
                return EMPTY;
            }
            case NOT_EMPTY: {
                return NOT_EMPTY;
            }
            case CONTAINS: {
                return CONTAINS;
            }
            case NOT_CONTAINS: {
                return NOT_CONTAINS;
            }
            case EVAL: {
                return EVAL;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AssertionOperatorType of(java.lang.String value) {
        return AssertionOperatorType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return AssertionOperatorType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return AssertionOperatorType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssertionOperatorType other = (AssertionOperatorType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        EQUALS("equals"),
        NOT_EQUALS("notEquals"),
        IN("in"),
        NOT_IN("notIn"),
        GREATER_THAN("greaterThan"),
        LESS_THAN("lessThan"),
        EMPTY("empty"),
        NOT_EMPTY("notEmpty"),
        CONTAINS("contains"),
        NOT_CONTAINS("notContains"),
        EVAL("eval");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "equals": {
                    return EQUALS;
                }
                case "notEquals": {
                    return NOT_EQUALS;
                }
                case "in": {
                    return IN;
                }
                case "notIn": {
                    return NOT_IN;
                }
                case "greaterThan": {
                    return GREATER_THAN;
                }
                case "lessThan": {
                    return LESS_THAN;
                }
                case "empty": {
                    return EMPTY;
                }
                case "notEmpty": {
                    return NOT_EMPTY;
                }
                case "contains": {
                    return CONTAINS;
                }
                case "notContains": {
                    return NOT_CONTAINS;
                }
                case "eval": {
                    return EVAL;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public AssertionOperatorType build() {
            AssertionOperatorType assertionOperatorType = new AssertionOperatorType(this);
            if (this.validating) {
                this.validate(assertionOperatorType);
            }
            return assertionOperatorType;
        }

        protected void validate(AssertionOperatorType assertionOperatorType) {
            super.validate(assertionOperatorType);
        }

        protected Builder from(AssertionOperatorType assertionOperatorType) {
            super.from(assertionOperatorType);
            return this;
        }
    }
}

