/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/audit-event-action")
public class AuditEventAction
extends Code {
    public static final AuditEventAction C = AuditEventAction.builder().value(Value.C).build();
    public static final AuditEventAction R = AuditEventAction.builder().value(Value.R).build();
    public static final AuditEventAction U = AuditEventAction.builder().value(Value.U).build();
    public static final AuditEventAction D = AuditEventAction.builder().value(Value.D).build();
    public static final AuditEventAction E = AuditEventAction.builder().value(Value.E).build();
    private volatile int hashCode;

    private AuditEventAction(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static AuditEventAction of(Value value) {
        switch (value) {
            case C: {
                return C;
            }
            case R: {
                return R;
            }
            case U: {
                return U;
            }
            case D: {
                return D;
            }
            case E: {
                return E;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AuditEventAction of(java.lang.String value) {
        return AuditEventAction.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return AuditEventAction.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return AuditEventAction.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditEventAction other = (AuditEventAction)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        C("C"),
        R("R"),
        U("U"),
        D("D"),
        E("E");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "C": {
                    return C;
                }
                case "R": {
                    return R;
                }
                case "U": {
                    return U;
                }
                case "D": {
                    return D;
                }
                case "E": {
                    return E;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public AuditEventAction build() {
            AuditEventAction auditEventAction = new AuditEventAction(this);
            if (this.validating) {
                this.validate(auditEventAction);
            }
            return auditEventAction;
        }

        protected void validate(AuditEventAction auditEventAction) {
            super.validate(auditEventAction);
        }

        protected Builder from(AuditEventAction auditEventAction) {
            super.from(auditEventAction);
            return this;
        }
    }
}

