/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/chargeitem-status")
public class ChargeItemStatus
extends Code {
    public static final ChargeItemStatus PLANNED = ChargeItemStatus.builder().value(Value.PLANNED).build();
    public static final ChargeItemStatus BILLABLE = ChargeItemStatus.builder().value(Value.BILLABLE).build();
    public static final ChargeItemStatus NOT_BILLABLE = ChargeItemStatus.builder().value(Value.NOT_BILLABLE).build();
    public static final ChargeItemStatus ABORTED = ChargeItemStatus.builder().value(Value.ABORTED).build();
    public static final ChargeItemStatus BILLED = ChargeItemStatus.builder().value(Value.BILLED).build();
    public static final ChargeItemStatus ENTERED_IN_ERROR = ChargeItemStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final ChargeItemStatus UNKNOWN = ChargeItemStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private ChargeItemStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ChargeItemStatus of(Value value) {
        switch (value) {
            case PLANNED: {
                return PLANNED;
            }
            case BILLABLE: {
                return BILLABLE;
            }
            case NOT_BILLABLE: {
                return NOT_BILLABLE;
            }
            case ABORTED: {
                return ABORTED;
            }
            case BILLED: {
                return BILLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ChargeItemStatus of(java.lang.String value) {
        return ChargeItemStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ChargeItemStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ChargeItemStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChargeItemStatus other = (ChargeItemStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PLANNED("planned"),
        BILLABLE("billable"),
        NOT_BILLABLE("not-billable"),
        ABORTED("aborted"),
        BILLED("billed"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "planned": {
                    return PLANNED;
                }
                case "billable": {
                    return BILLABLE;
                }
                case "not-billable": {
                    return NOT_BILLABLE;
                }
                case "aborted": {
                    return ABORTED;
                }
                case "billed": {
                    return BILLED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ChargeItemStatus build() {
            ChargeItemStatus chargeItemStatus = new ChargeItemStatus(this);
            if (this.validating) {
                this.validate(chargeItemStatus);
            }
            return chargeItemStatus;
        }

        protected void validate(ChargeItemStatus chargeItemStatus) {
            super.validate(chargeItemStatus);
        }

        protected Builder from(ChargeItemStatus chargeItemStatus) {
            super.from(chargeItemStatus);
            return this;
        }
    }
}

