/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/compartment-type")
public class CompartmentType
extends Code {
    public static final CompartmentType PATIENT = CompartmentType.builder().value(Value.PATIENT).build();
    public static final CompartmentType ENCOUNTER = CompartmentType.builder().value(Value.ENCOUNTER).build();
    public static final CompartmentType RELATED_PERSON = CompartmentType.builder().value(Value.RELATED_PERSON).build();
    public static final CompartmentType PRACTITIONER = CompartmentType.builder().value(Value.PRACTITIONER).build();
    public static final CompartmentType DEVICE = CompartmentType.builder().value(Value.DEVICE).build();
    private volatile int hashCode;

    private CompartmentType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static CompartmentType of(Value value) {
        switch (value) {
            case PATIENT: {
                return PATIENT;
            }
            case ENCOUNTER: {
                return ENCOUNTER;
            }
            case RELATED_PERSON: {
                return RELATED_PERSON;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case DEVICE: {
                return DEVICE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CompartmentType of(java.lang.String value) {
        return CompartmentType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return CompartmentType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return CompartmentType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompartmentType other = (CompartmentType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PATIENT("Patient"),
        ENCOUNTER("Encounter"),
        RELATED_PERSON("RelatedPerson"),
        PRACTITIONER("Practitioner"),
        DEVICE("Device");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "Patient": {
                    return PATIENT;
                }
                case "Encounter": {
                    return ENCOUNTER;
                }
                case "RelatedPerson": {
                    return RELATED_PERSON;
                }
                case "Practitioner": {
                    return PRACTITIONER;
                }
                case "Device": {
                    return DEVICE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CompartmentType build() {
            CompartmentType compartmentType = new CompartmentType(this);
            if (this.validating) {
                this.validate(compartmentType);
            }
            return compartmentType;
        }

        protected void validate(CompartmentType compartmentType) {
            super.validate(compartmentType);
        }

        protected Builder from(CompartmentType compartmentType) {
            super.from(compartmentType);
            return this;
        }
    }
}

