/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/concept-subsumption-outcome")
public class ConceptSubsumptionOutcome
extends Code {
    public static final ConceptSubsumptionOutcome EQUIVALENT = ConceptSubsumptionOutcome.builder().value(Value.EQUIVALENT).build();
    public static final ConceptSubsumptionOutcome SUBSUMES = ConceptSubsumptionOutcome.builder().value(Value.SUBSUMES).build();
    public static final ConceptSubsumptionOutcome SUBSUMED_BY = ConceptSubsumptionOutcome.builder().value(Value.SUBSUMED_BY).build();
    public static final ConceptSubsumptionOutcome NOT_SUBSUMED = ConceptSubsumptionOutcome.builder().value(Value.NOT_SUBSUMED).build();
    private volatile int hashCode;

    private ConceptSubsumptionOutcome(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ConceptSubsumptionOutcome of(Value value) {
        switch (value) {
            case EQUIVALENT: {
                return EQUIVALENT;
            }
            case SUBSUMES: {
                return SUBSUMES;
            }
            case SUBSUMED_BY: {
                return SUBSUMED_BY;
            }
            case NOT_SUBSUMED: {
                return NOT_SUBSUMED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ConceptSubsumptionOutcome of(java.lang.String value) {
        return ConceptSubsumptionOutcome.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ConceptSubsumptionOutcome.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ConceptSubsumptionOutcome.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConceptSubsumptionOutcome other = (ConceptSubsumptionOutcome)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        EQUIVALENT("equivalent"),
        SUBSUMES("subsumes"),
        SUBSUMED_BY("subsumed-by"),
        NOT_SUBSUMED("not-subsumed");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "equivalent": {
                    return EQUIVALENT;
                }
                case "subsumes": {
                    return SUBSUMES;
                }
                case "subsumed-by": {
                    return SUBSUMED_BY;
                }
                case "not-subsumed": {
                    return NOT_SUBSUMED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ConceptSubsumptionOutcome build() {
            ConceptSubsumptionOutcome conceptSubsumptionOutcome = new ConceptSubsumptionOutcome(this);
            if (this.validating) {
                this.validate(conceptSubsumptionOutcome);
            }
            return conceptSubsumptionOutcome;
        }

        protected void validate(ConceptSubsumptionOutcome conceptSubsumptionOutcome) {
            super.validate(conceptSubsumptionOutcome);
        }

        protected Builder from(ConceptSubsumptionOutcome conceptSubsumptionOutcome) {
            super.from(conceptSubsumptionOutcome);
            return this;
        }
    }
}

