/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://terminology.hl7.org/CodeSystem/data-absent-reason")
public class DataAbsentReason
extends Code {
    public static final DataAbsentReason UNKNOWN = DataAbsentReason.builder().value(Value.UNKNOWN).build();
    public static final DataAbsentReason ASKED_UNKNOWN = DataAbsentReason.builder().value(Value.ASKED_UNKNOWN).build();
    public static final DataAbsentReason TEMP_UNKNOWN = DataAbsentReason.builder().value(Value.TEMP_UNKNOWN).build();
    public static final DataAbsentReason NOT_ASKED = DataAbsentReason.builder().value(Value.NOT_ASKED).build();
    public static final DataAbsentReason ASKED_DECLINED = DataAbsentReason.builder().value(Value.ASKED_DECLINED).build();
    public static final DataAbsentReason MASKED = DataAbsentReason.builder().value(Value.MASKED).build();
    public static final DataAbsentReason NOT_APPLICABLE = DataAbsentReason.builder().value(Value.NOT_APPLICABLE).build();
    public static final DataAbsentReason UNSUPPORTED = DataAbsentReason.builder().value(Value.UNSUPPORTED).build();
    public static final DataAbsentReason AS_TEXT = DataAbsentReason.builder().value(Value.AS_TEXT).build();
    public static final DataAbsentReason ERROR = DataAbsentReason.builder().value(Value.ERROR).build();
    public static final DataAbsentReason NOT_A_NUMBER = DataAbsentReason.builder().value(Value.NOT_A_NUMBER).build();
    public static final DataAbsentReason NEGATIVE_INFINITY = DataAbsentReason.builder().value(Value.NEGATIVE_INFINITY).build();
    public static final DataAbsentReason POSITIVE_INFINITY = DataAbsentReason.builder().value(Value.POSITIVE_INFINITY).build();
    public static final DataAbsentReason NOT_PERFORMED = DataAbsentReason.builder().value(Value.NOT_PERFORMED).build();
    public static final DataAbsentReason NOT_PERMITTED = DataAbsentReason.builder().value(Value.NOT_PERMITTED).build();
    private volatile int hashCode;

    private DataAbsentReason(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static DataAbsentReason of(Value value) {
        switch (value) {
            case UNKNOWN: {
                return UNKNOWN;
            }
            case ASKED_UNKNOWN: {
                return ASKED_UNKNOWN;
            }
            case TEMP_UNKNOWN: {
                return TEMP_UNKNOWN;
            }
            case NOT_ASKED: {
                return NOT_ASKED;
            }
            case ASKED_DECLINED: {
                return ASKED_DECLINED;
            }
            case MASKED: {
                return MASKED;
            }
            case NOT_APPLICABLE: {
                return NOT_APPLICABLE;
            }
            case UNSUPPORTED: {
                return UNSUPPORTED;
            }
            case AS_TEXT: {
                return AS_TEXT;
            }
            case ERROR: {
                return ERROR;
            }
            case NOT_A_NUMBER: {
                return NOT_A_NUMBER;
            }
            case NEGATIVE_INFINITY: {
                return NEGATIVE_INFINITY;
            }
            case POSITIVE_INFINITY: {
                return POSITIVE_INFINITY;
            }
            case NOT_PERFORMED: {
                return NOT_PERFORMED;
            }
            case NOT_PERMITTED: {
                return NOT_PERMITTED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DataAbsentReason of(java.lang.String value) {
        return DataAbsentReason.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return DataAbsentReason.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return DataAbsentReason.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataAbsentReason other = (DataAbsentReason)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        UNKNOWN("unknown"),
        ASKED_UNKNOWN("asked-unknown"),
        TEMP_UNKNOWN("temp-unknown"),
        NOT_ASKED("not-asked"),
        ASKED_DECLINED("asked-declined"),
        MASKED("masked"),
        NOT_APPLICABLE("not-applicable"),
        UNSUPPORTED("unsupported"),
        AS_TEXT("as-text"),
        ERROR("error"),
        NOT_A_NUMBER("not-a-number"),
        NEGATIVE_INFINITY("negative-infinity"),
        POSITIVE_INFINITY("positive-infinity"),
        NOT_PERFORMED("not-performed"),
        NOT_PERMITTED("not-permitted");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "unknown": {
                    return UNKNOWN;
                }
                case "asked-unknown": {
                    return ASKED_UNKNOWN;
                }
                case "temp-unknown": {
                    return TEMP_UNKNOWN;
                }
                case "not-asked": {
                    return NOT_ASKED;
                }
                case "asked-declined": {
                    return ASKED_DECLINED;
                }
                case "masked": {
                    return MASKED;
                }
                case "not-applicable": {
                    return NOT_APPLICABLE;
                }
                case "unsupported": {
                    return UNSUPPORTED;
                }
                case "as-text": {
                    return AS_TEXT;
                }
                case "error": {
                    return ERROR;
                }
                case "not-a-number": {
                    return NOT_A_NUMBER;
                }
                case "negative-infinity": {
                    return NEGATIVE_INFINITY;
                }
                case "positive-infinity": {
                    return POSITIVE_INFINITY;
                }
                case "not-performed": {
                    return NOT_PERFORMED;
                }
                case "not-permitted": {
                    return NOT_PERMITTED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DataAbsentReason build() {
            DataAbsentReason dataAbsentReason = new DataAbsentReason(this);
            if (this.validating) {
                this.validate(dataAbsentReason);
            }
            return dataAbsentReason;
        }

        protected void validate(DataAbsentReason dataAbsentReason) {
            super.validate(dataAbsentReason);
        }

        protected Builder from(DataAbsentReason dataAbsentReason) {
            super.from(dataAbsentReason);
            return this;
        }
    }
}

