/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/metric-calibration-state")
public class DeviceMetricCalibrationState
extends Code {
    public static final DeviceMetricCalibrationState NOT_CALIBRATED = DeviceMetricCalibrationState.builder().value(Value.NOT_CALIBRATED).build();
    public static final DeviceMetricCalibrationState CALIBRATION_REQUIRED = DeviceMetricCalibrationState.builder().value(Value.CALIBRATION_REQUIRED).build();
    public static final DeviceMetricCalibrationState CALIBRATED = DeviceMetricCalibrationState.builder().value(Value.CALIBRATED).build();
    public static final DeviceMetricCalibrationState UNSPECIFIED = DeviceMetricCalibrationState.builder().value(Value.UNSPECIFIED).build();
    private volatile int hashCode;

    private DeviceMetricCalibrationState(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static DeviceMetricCalibrationState of(Value value) {
        switch (value) {
            case NOT_CALIBRATED: {
                return NOT_CALIBRATED;
            }
            case CALIBRATION_REQUIRED: {
                return CALIBRATION_REQUIRED;
            }
            case CALIBRATED: {
                return CALIBRATED;
            }
            case UNSPECIFIED: {
                return UNSPECIFIED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DeviceMetricCalibrationState of(java.lang.String value) {
        return DeviceMetricCalibrationState.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return DeviceMetricCalibrationState.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return DeviceMetricCalibrationState.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceMetricCalibrationState other = (DeviceMetricCalibrationState)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        NOT_CALIBRATED("not-calibrated"),
        CALIBRATION_REQUIRED("calibration-required"),
        CALIBRATED("calibrated"),
        UNSPECIFIED("unspecified");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "not-calibrated": {
                    return NOT_CALIBRATED;
                }
                case "calibration-required": {
                    return CALIBRATION_REQUIRED;
                }
                case "calibrated": {
                    return CALIBRATED;
                }
                case "unspecified": {
                    return UNSPECIFIED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DeviceMetricCalibrationState build() {
            DeviceMetricCalibrationState deviceMetricCalibrationState = new DeviceMetricCalibrationState(this);
            if (this.validating) {
                this.validate(deviceMetricCalibrationState);
            }
            return deviceMetricCalibrationState;
        }

        protected void validate(DeviceMetricCalibrationState deviceMetricCalibrationState) {
            super.validate(deviceMetricCalibrationState);
        }

        protected Builder from(DeviceMetricCalibrationState deviceMetricCalibrationState) {
            super.from(deviceMetricCalibrationState);
            return this;
        }
    }
}

