/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/extension-context-type")
public class ExtensionContextType
extends Code {
    public static final ExtensionContextType FHIRPATH = ExtensionContextType.builder().value(Value.FHIRPATH).build();
    public static final ExtensionContextType ELEMENT = ExtensionContextType.builder().value(Value.ELEMENT).build();
    public static final ExtensionContextType EXTENSION = ExtensionContextType.builder().value(Value.EXTENSION).build();
    private volatile int hashCode;

    private ExtensionContextType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ExtensionContextType of(Value value) {
        switch (value) {
            case FHIRPATH: {
                return FHIRPATH;
            }
            case ELEMENT: {
                return ELEMENT;
            }
            case EXTENSION: {
                return EXTENSION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ExtensionContextType of(java.lang.String value) {
        return ExtensionContextType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ExtensionContextType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ExtensionContextType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionContextType other = (ExtensionContextType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        FHIRPATH("fhirpath"),
        ELEMENT("element"),
        EXTENSION("extension");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "fhirpath": {
                    return FHIRPATH;
                }
                case "element": {
                    return ELEMENT;
                }
                case "extension": {
                    return EXTENSION;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ExtensionContextType build() {
            ExtensionContextType extensionContextType = new ExtensionContextType(this);
            if (this.validating) {
                this.validate(extensionContextType);
            }
            return extensionContextType;
        }

        protected void validate(ExtensionContextType extensionContextType) {
            super.validate(extensionContextType);
        }

        protected Builder from(ExtensionContextType extensionContextType) {
            super.from(extensionContextType);
            return this;
        }
    }
}

