/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/goal-status")
public class GoalLifecycleStatus
extends Code {
    public static final GoalLifecycleStatus PROPOSED = GoalLifecycleStatus.builder().value(Value.PROPOSED).build();
    public static final GoalLifecycleStatus PLANNED = GoalLifecycleStatus.builder().value(Value.PLANNED).build();
    public static final GoalLifecycleStatus ACCEPTED = GoalLifecycleStatus.builder().value(Value.ACCEPTED).build();
    public static final GoalLifecycleStatus ACTIVE = GoalLifecycleStatus.builder().value(Value.ACTIVE).build();
    public static final GoalLifecycleStatus ON_HOLD = GoalLifecycleStatus.builder().value(Value.ON_HOLD).build();
    public static final GoalLifecycleStatus COMPLETED = GoalLifecycleStatus.builder().value(Value.COMPLETED).build();
    public static final GoalLifecycleStatus CANCELLED = GoalLifecycleStatus.builder().value(Value.CANCELLED).build();
    public static final GoalLifecycleStatus ENTERED_IN_ERROR = GoalLifecycleStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final GoalLifecycleStatus REJECTED = GoalLifecycleStatus.builder().value(Value.REJECTED).build();
    private volatile int hashCode;

    private GoalLifecycleStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static GoalLifecycleStatus of(Value value) {
        switch (value) {
            case PROPOSED: {
                return PROPOSED;
            }
            case PLANNED: {
                return PLANNED;
            }
            case ACCEPTED: {
                return ACCEPTED;
            }
            case ACTIVE: {
                return ACTIVE;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case REJECTED: {
                return REJECTED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static GoalLifecycleStatus of(java.lang.String value) {
        return GoalLifecycleStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return GoalLifecycleStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return GoalLifecycleStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoalLifecycleStatus other = (GoalLifecycleStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PROPOSED("proposed"),
        PLANNED("planned"),
        ACCEPTED("accepted"),
        ACTIVE("active"),
        ON_HOLD("on-hold"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        REJECTED("rejected");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "proposed": {
                    return PROPOSED;
                }
                case "planned": {
                    return PLANNED;
                }
                case "accepted": {
                    return ACCEPTED;
                }
                case "active": {
                    return ACTIVE;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "rejected": {
                    return REJECTED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public GoalLifecycleStatus build() {
            GoalLifecycleStatus goalLifecycleStatus = new GoalLifecycleStatus(this);
            if (this.validating) {
                this.validate(goalLifecycleStatus);
            }
            return goalLifecycleStatus;
        }

        protected void validate(GoalLifecycleStatus goalLifecycleStatus) {
            super.validate(goalLifecycleStatus);
        }

        protected Builder from(GoalLifecycleStatus goalLifecycleStatus) {
            super.from(goalLifecycleStatus);
            return this;
        }
    }
}

