/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/name-use")
public class NameUse
extends Code {
    public static final NameUse USUAL = NameUse.builder().value(Value.USUAL).build();
    public static final NameUse OFFICIAL = NameUse.builder().value(Value.OFFICIAL).build();
    public static final NameUse TEMP = NameUse.builder().value(Value.TEMP).build();
    public static final NameUse NICKNAME = NameUse.builder().value(Value.NICKNAME).build();
    public static final NameUse ANONYMOUS = NameUse.builder().value(Value.ANONYMOUS).build();
    public static final NameUse OLD = NameUse.builder().value(Value.OLD).build();
    public static final NameUse MAIDEN = NameUse.builder().value(Value.MAIDEN).build();
    private volatile int hashCode;

    private NameUse(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static NameUse of(Value value) {
        switch (value) {
            case USUAL: {
                return USUAL;
            }
            case OFFICIAL: {
                return OFFICIAL;
            }
            case TEMP: {
                return TEMP;
            }
            case NICKNAME: {
                return NICKNAME;
            }
            case ANONYMOUS: {
                return ANONYMOUS;
            }
            case OLD: {
                return OLD;
            }
            case MAIDEN: {
                return MAIDEN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static NameUse of(java.lang.String value) {
        return NameUse.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return NameUse.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return NameUse.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUse other = (NameUse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        USUAL("usual"),
        OFFICIAL("official"),
        TEMP("temp"),
        NICKNAME("nickname"),
        ANONYMOUS("anonymous"),
        OLD("old"),
        MAIDEN("maiden");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "usual": {
                    return USUAL;
                }
                case "official": {
                    return OFFICIAL;
                }
                case "temp": {
                    return TEMP;
                }
                case "nickname": {
                    return NICKNAME;
                }
                case "anonymous": {
                    return ANONYMOUS;
                }
                case "old": {
                    return OLD;
                }
                case "maiden": {
                    return MAIDEN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public NameUse build() {
            NameUse nameUse = new NameUse(this);
            if (this.validating) {
                this.validate(nameUse);
            }
            return nameUse;
        }

        protected void validate(NameUse nameUse) {
            super.validate(nameUse);
        }

        protected Builder from(NameUse nameUse) {
            super.from(nameUse);
            return this;
        }
    }
}

