/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/narrative-status")
public class NarrativeStatus
extends Code {
    public static final NarrativeStatus GENERATED = NarrativeStatus.builder().value(Value.GENERATED).build();
    public static final NarrativeStatus EXTENSIONS = NarrativeStatus.builder().value(Value.EXTENSIONS).build();
    public static final NarrativeStatus ADDITIONAL = NarrativeStatus.builder().value(Value.ADDITIONAL).build();
    public static final NarrativeStatus EMPTY = NarrativeStatus.builder().value(Value.EMPTY).build();
    private volatile int hashCode;

    private NarrativeStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static NarrativeStatus of(Value value) {
        switch (value) {
            case GENERATED: {
                return GENERATED;
            }
            case EXTENSIONS: {
                return EXTENSIONS;
            }
            case ADDITIONAL: {
                return ADDITIONAL;
            }
            case EMPTY: {
                return EMPTY;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static NarrativeStatus of(java.lang.String value) {
        return NarrativeStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return NarrativeStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return NarrativeStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NarrativeStatus other = (NarrativeStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        GENERATED("generated"),
        EXTENSIONS("extensions"),
        ADDITIONAL("additional"),
        EMPTY("empty");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "generated": {
                    return GENERATED;
                }
                case "extensions": {
                    return EXTENSIONS;
                }
                case "additional": {
                    return ADDITIONAL;
                }
                case "empty": {
                    return EMPTY;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public NarrativeStatus build() {
            NarrativeStatus narrativeStatus = new NarrativeStatus(this);
            if (this.validating) {
                this.validate(narrativeStatus);
            }
            return narrativeStatus;
        }

        protected void validate(NarrativeStatus narrativeStatus) {
            super.validate(narrativeStatus);
        }

        protected Builder from(NarrativeStatus narrativeStatus) {
            super.from(narrativeStatus);
            return this;
        }
    }
}

