/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/permitted-data-type")
public class ObservationDataType
extends Code {
    public static final ObservationDataType QUANTITY = ObservationDataType.builder().value(Value.QUANTITY).build();
    public static final ObservationDataType CODEABLE_CONCEPT = ObservationDataType.builder().value(Value.CODEABLE_CONCEPT).build();
    public static final ObservationDataType STRING = ObservationDataType.builder().value(Value.STRING).build();
    public static final ObservationDataType BOOLEAN = ObservationDataType.builder().value(Value.BOOLEAN).build();
    public static final ObservationDataType INTEGER = ObservationDataType.builder().value(Value.INTEGER).build();
    public static final ObservationDataType RANGE = ObservationDataType.builder().value(Value.RANGE).build();
    public static final ObservationDataType RATIO = ObservationDataType.builder().value(Value.RATIO).build();
    public static final ObservationDataType SAMPLED_DATA = ObservationDataType.builder().value(Value.SAMPLED_DATA).build();
    public static final ObservationDataType TIME = ObservationDataType.builder().value(Value.TIME).build();
    public static final ObservationDataType DATE_TIME = ObservationDataType.builder().value(Value.DATE_TIME).build();
    public static final ObservationDataType PERIOD = ObservationDataType.builder().value(Value.PERIOD).build();
    private volatile int hashCode;

    private ObservationDataType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ObservationDataType of(Value value) {
        switch (value) {
            case QUANTITY: {
                return QUANTITY;
            }
            case CODEABLE_CONCEPT: {
                return CODEABLE_CONCEPT;
            }
            case STRING: {
                return STRING;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case INTEGER: {
                return INTEGER;
            }
            case RANGE: {
                return RANGE;
            }
            case RATIO: {
                return RATIO;
            }
            case SAMPLED_DATA: {
                return SAMPLED_DATA;
            }
            case TIME: {
                return TIME;
            }
            case DATE_TIME: {
                return DATE_TIME;
            }
            case PERIOD: {
                return PERIOD;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ObservationDataType of(java.lang.String value) {
        return ObservationDataType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ObservationDataType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ObservationDataType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObservationDataType other = (ObservationDataType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        QUANTITY("Quantity"),
        CODEABLE_CONCEPT("CodeableConcept"),
        STRING("string"),
        BOOLEAN("boolean"),
        INTEGER("integer"),
        RANGE("Range"),
        RATIO("Ratio"),
        SAMPLED_DATA("SampledData"),
        TIME("time"),
        DATE_TIME("dateTime"),
        PERIOD("Period");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "Quantity": {
                    return QUANTITY;
                }
                case "CodeableConcept": {
                    return CODEABLE_CONCEPT;
                }
                case "string": {
                    return STRING;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "integer": {
                    return INTEGER;
                }
                case "Range": {
                    return RANGE;
                }
                case "Ratio": {
                    return RATIO;
                }
                case "SampledData": {
                    return SAMPLED_DATA;
                }
                case "time": {
                    return TIME;
                }
                case "dateTime": {
                    return DATE_TIME;
                }
                case "Period": {
                    return PERIOD;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ObservationDataType build() {
            ObservationDataType observationDataType = new ObservationDataType(this);
            if (this.validating) {
                this.validate(observationDataType);
            }
            return observationDataType;
        }

        protected void validate(ObservationDataType observationDataType) {
            super.validate(observationDataType);
        }

        protected Builder from(ObservationDataType observationDataType) {
            super.from(observationDataType);
            return this;
        }
    }
}

