/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/fm-status")
public class PaymentReconciliationStatus
extends Code {
    public static final PaymentReconciliationStatus ACTIVE = PaymentReconciliationStatus.builder().value(Value.ACTIVE).build();
    public static final PaymentReconciliationStatus CANCELLED = PaymentReconciliationStatus.builder().value(Value.CANCELLED).build();
    public static final PaymentReconciliationStatus DRAFT = PaymentReconciliationStatus.builder().value(Value.DRAFT).build();
    public static final PaymentReconciliationStatus ENTERED_IN_ERROR = PaymentReconciliationStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private PaymentReconciliationStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static PaymentReconciliationStatus of(Value value) {
        switch (value) {
            case ACTIVE: {
                return ACTIVE;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case DRAFT: {
                return DRAFT;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static PaymentReconciliationStatus of(java.lang.String value) {
        return PaymentReconciliationStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return PaymentReconciliationStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return PaymentReconciliationStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentReconciliationStatus other = (PaymentReconciliationStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ACTIVE("active"),
        CANCELLED("cancelled"),
        DRAFT("draft"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "active": {
                    return ACTIVE;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "draft": {
                    return DRAFT;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public PaymentReconciliationStatus build() {
            PaymentReconciliationStatus paymentReconciliationStatus = new PaymentReconciliationStatus(this);
            if (this.validating) {
                this.validate(paymentReconciliationStatus);
            }
            return paymentReconciliationStatus;
        }

        protected void validate(PaymentReconciliationStatus paymentReconciliationStatus) {
            super.validate(paymentReconciliationStatus);
        }

        protected Builder from(PaymentReconciliationStatus paymentReconciliationStatus) {
            super.from(paymentReconciliationStatus);
            return this;
        }
    }
}

