/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/research-study-status")
public class ResearchStudyStatus
extends Code {
    public static final ResearchStudyStatus ACTIVE = ResearchStudyStatus.builder().value(Value.ACTIVE).build();
    public static final ResearchStudyStatus ADMINISTRATIVELY_COMPLETED = ResearchStudyStatus.builder().value(Value.ADMINISTRATIVELY_COMPLETED).build();
    public static final ResearchStudyStatus APPROVED = ResearchStudyStatus.builder().value(Value.APPROVED).build();
    public static final ResearchStudyStatus CLOSED_TO_ACCRUAL = ResearchStudyStatus.builder().value(Value.CLOSED_TO_ACCRUAL).build();
    public static final ResearchStudyStatus CLOSED_TO_ACCRUAL_AND_INTERVENTION = ResearchStudyStatus.builder().value(Value.CLOSED_TO_ACCRUAL_AND_INTERVENTION).build();
    public static final ResearchStudyStatus COMPLETED = ResearchStudyStatus.builder().value(Value.COMPLETED).build();
    public static final ResearchStudyStatus DISAPPROVED = ResearchStudyStatus.builder().value(Value.DISAPPROVED).build();
    public static final ResearchStudyStatus IN_REVIEW = ResearchStudyStatus.builder().value(Value.IN_REVIEW).build();
    public static final ResearchStudyStatus TEMPORARILY_CLOSED_TO_ACCRUAL = ResearchStudyStatus.builder().value(Value.TEMPORARILY_CLOSED_TO_ACCRUAL).build();
    public static final ResearchStudyStatus TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION = ResearchStudyStatus.builder().value(Value.TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION).build();
    public static final ResearchStudyStatus WITHDRAWN = ResearchStudyStatus.builder().value(Value.WITHDRAWN).build();
    private volatile int hashCode;

    private ResearchStudyStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ResearchStudyStatus of(Value value) {
        switch (value) {
            case ACTIVE: {
                return ACTIVE;
            }
            case ADMINISTRATIVELY_COMPLETED: {
                return ADMINISTRATIVELY_COMPLETED;
            }
            case APPROVED: {
                return APPROVED;
            }
            case CLOSED_TO_ACCRUAL: {
                return CLOSED_TO_ACCRUAL;
            }
            case CLOSED_TO_ACCRUAL_AND_INTERVENTION: {
                return CLOSED_TO_ACCRUAL_AND_INTERVENTION;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case DISAPPROVED: {
                return DISAPPROVED;
            }
            case IN_REVIEW: {
                return IN_REVIEW;
            }
            case TEMPORARILY_CLOSED_TO_ACCRUAL: {
                return TEMPORARILY_CLOSED_TO_ACCRUAL;
            }
            case TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION: {
                return TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION;
            }
            case WITHDRAWN: {
                return WITHDRAWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ResearchStudyStatus of(java.lang.String value) {
        return ResearchStudyStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ResearchStudyStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ResearchStudyStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchStudyStatus other = (ResearchStudyStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ACTIVE("active"),
        ADMINISTRATIVELY_COMPLETED("administratively-completed"),
        APPROVED("approved"),
        CLOSED_TO_ACCRUAL("closed-to-accrual"),
        CLOSED_TO_ACCRUAL_AND_INTERVENTION("closed-to-accrual-and-intervention"),
        COMPLETED("completed"),
        DISAPPROVED("disapproved"),
        IN_REVIEW("in-review"),
        TEMPORARILY_CLOSED_TO_ACCRUAL("temporarily-closed-to-accrual"),
        TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION("temporarily-closed-to-accrual-and-intervention"),
        WITHDRAWN("withdrawn");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "active": {
                    return ACTIVE;
                }
                case "administratively-completed": {
                    return ADMINISTRATIVELY_COMPLETED;
                }
                case "approved": {
                    return APPROVED;
                }
                case "closed-to-accrual": {
                    return CLOSED_TO_ACCRUAL;
                }
                case "closed-to-accrual-and-intervention": {
                    return CLOSED_TO_ACCRUAL_AND_INTERVENTION;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "disapproved": {
                    return DISAPPROVED;
                }
                case "in-review": {
                    return IN_REVIEW;
                }
                case "temporarily-closed-to-accrual": {
                    return TEMPORARILY_CLOSED_TO_ACCRUAL;
                }
                case "temporarily-closed-to-accrual-and-intervention": {
                    return TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION;
                }
                case "withdrawn": {
                    return WITHDRAWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ResearchStudyStatus build() {
            ResearchStudyStatus researchStudyStatus = new ResearchStudyStatus(this);
            if (this.validating) {
                this.validate(researchStudyStatus);
            }
            return researchStudyStatus;
        }

        protected void validate(ResearchStudyStatus researchStudyStatus) {
            super.validate(researchStudyStatus);
        }

        protected Builder from(ResearchStudyStatus researchStudyStatus) {
            super.from(researchStudyStatus);
            return this;
        }
    }
}

