/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/sequence-type")
public class SequenceType
extends Code {
    public static final SequenceType AA = SequenceType.builder().value(Value.AA).build();
    public static final SequenceType DNA = SequenceType.builder().value(Value.DNA).build();
    public static final SequenceType RNA = SequenceType.builder().value(Value.RNA).build();
    private volatile int hashCode;

    private SequenceType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static SequenceType of(Value value) {
        switch (value) {
            case AA: {
                return AA;
            }
            case DNA: {
                return DNA;
            }
            case RNA: {
                return RNA;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SequenceType of(java.lang.String value) {
        return SequenceType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SequenceType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SequenceType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceType other = (SequenceType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        AA("aa"),
        DNA("dna"),
        RNA("rna");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "aa": {
                    return AA;
                }
                case "dna": {
                    return DNA;
                }
                case "rna": {
                    return RNA;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SequenceType build() {
            SequenceType sequenceType = new SequenceType(this);
            if (this.validating) {
                this.validate(sequenceType);
            }
            return sequenceType;
        }

        protected void validate(SequenceType sequenceType) {
            super.validate(sequenceType);
        }

        protected Builder from(SequenceType sequenceType) {
            super.from(sequenceType);
            return this;
        }
    }
}

