/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/request-intent")
public class ServiceRequestIntent
extends Code {
    public static final ServiceRequestIntent PROPOSAL = ServiceRequestIntent.builder().value(Value.PROPOSAL).build();
    public static final ServiceRequestIntent PLAN = ServiceRequestIntent.builder().value(Value.PLAN).build();
    public static final ServiceRequestIntent DIRECTIVE = ServiceRequestIntent.builder().value(Value.DIRECTIVE).build();
    public static final ServiceRequestIntent ORDER = ServiceRequestIntent.builder().value(Value.ORDER).build();
    public static final ServiceRequestIntent ORIGINAL_ORDER = ServiceRequestIntent.builder().value(Value.ORIGINAL_ORDER).build();
    public static final ServiceRequestIntent REFLEX_ORDER = ServiceRequestIntent.builder().value(Value.REFLEX_ORDER).build();
    public static final ServiceRequestIntent FILLER_ORDER = ServiceRequestIntent.builder().value(Value.FILLER_ORDER).build();
    public static final ServiceRequestIntent INSTANCE_ORDER = ServiceRequestIntent.builder().value(Value.INSTANCE_ORDER).build();
    public static final ServiceRequestIntent OPTION = ServiceRequestIntent.builder().value(Value.OPTION).build();
    private volatile int hashCode;

    private ServiceRequestIntent(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ServiceRequestIntent of(Value value) {
        switch (value) {
            case PROPOSAL: {
                return PROPOSAL;
            }
            case PLAN: {
                return PLAN;
            }
            case DIRECTIVE: {
                return DIRECTIVE;
            }
            case ORDER: {
                return ORDER;
            }
            case ORIGINAL_ORDER: {
                return ORIGINAL_ORDER;
            }
            case REFLEX_ORDER: {
                return REFLEX_ORDER;
            }
            case FILLER_ORDER: {
                return FILLER_ORDER;
            }
            case INSTANCE_ORDER: {
                return INSTANCE_ORDER;
            }
            case OPTION: {
                return OPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ServiceRequestIntent of(java.lang.String value) {
        return ServiceRequestIntent.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ServiceRequestIntent.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ServiceRequestIntent.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceRequestIntent other = (ServiceRequestIntent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PROPOSAL("proposal"),
        PLAN("plan"),
        DIRECTIVE("directive"),
        ORDER("order"),
        ORIGINAL_ORDER("original-order"),
        REFLEX_ORDER("reflex-order"),
        FILLER_ORDER("filler-order"),
        INSTANCE_ORDER("instance-order"),
        OPTION("option");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "proposal": {
                    return PROPOSAL;
                }
                case "plan": {
                    return PLAN;
                }
                case "directive": {
                    return DIRECTIVE;
                }
                case "order": {
                    return ORDER;
                }
                case "original-order": {
                    return ORIGINAL_ORDER;
                }
                case "reflex-order": {
                    return REFLEX_ORDER;
                }
                case "filler-order": {
                    return FILLER_ORDER;
                }
                case "instance-order": {
                    return INSTANCE_ORDER;
                }
                case "option": {
                    return OPTION;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ServiceRequestIntent build() {
            ServiceRequestIntent serviceRequestIntent = new ServiceRequestIntent(this);
            if (this.validating) {
                this.validate(serviceRequestIntent);
            }
            return serviceRequestIntent;
        }

        protected void validate(ServiceRequestIntent serviceRequestIntent) {
            super.validate(serviceRequestIntent);
        }

        protected Builder from(ServiceRequestIntent serviceRequestIntent) {
            super.from(serviceRequestIntent);
            return this;
        }
    }
}

