/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://terminology.hl7.org/CodeSystem/standards-status")
public class StandardsStatus
extends Code {
    public static final StandardsStatus DRAFT = StandardsStatus.builder().value(Value.DRAFT).build();
    public static final StandardsStatus NORMATIVE = StandardsStatus.builder().value(Value.NORMATIVE).build();
    public static final StandardsStatus TRIAL_USE = StandardsStatus.builder().value(Value.TRIAL_USE).build();
    public static final StandardsStatus INFORMATIVE = StandardsStatus.builder().value(Value.INFORMATIVE).build();
    public static final StandardsStatus DEPRECATED = StandardsStatus.builder().value(Value.DEPRECATED).build();
    public static final StandardsStatus EXTERNAL = StandardsStatus.builder().value(Value.EXTERNAL).build();
    private volatile int hashCode;

    private StandardsStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static StandardsStatus of(Value value) {
        switch (value) {
            case DRAFT: {
                return DRAFT;
            }
            case NORMATIVE: {
                return NORMATIVE;
            }
            case TRIAL_USE: {
                return TRIAL_USE;
            }
            case INFORMATIVE: {
                return INFORMATIVE;
            }
            case DEPRECATED: {
                return DEPRECATED;
            }
            case EXTERNAL: {
                return EXTERNAL;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static StandardsStatus of(java.lang.String value) {
        return StandardsStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return StandardsStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return StandardsStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardsStatus other = (StandardsStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        DRAFT("draft"),
        NORMATIVE("normative"),
        TRIAL_USE("trial-use"),
        INFORMATIVE("informative"),
        DEPRECATED("deprecated"),
        EXTERNAL("external");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "draft": {
                    return DRAFT;
                }
                case "normative": {
                    return NORMATIVE;
                }
                case "trial-use": {
                    return TRIAL_USE;
                }
                case "informative": {
                    return INFORMATIVE;
                }
                case "deprecated": {
                    return DEPRECATED;
                }
                case "external": {
                    return EXTERNAL;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public StandardsStatus build() {
            StandardsStatus standardsStatus = new StandardsStatus(this);
            if (this.validating) {
                this.validate(standardsStatus);
            }
            return standardsStatus;
        }

        protected void validate(StandardsStatus standardsStatus) {
            super.validate(standardsStatus);
        }

        protected Builder from(StandardsStatus standardsStatus) {
            super.from(standardsStatus);
            return this;
        }
    }
}

