/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/subscription-status")
public class SubscriptionStatus
extends Code {
    public static final SubscriptionStatus REQUESTED = SubscriptionStatus.builder().value(Value.REQUESTED).build();
    public static final SubscriptionStatus ACTIVE = SubscriptionStatus.builder().value(Value.ACTIVE).build();
    public static final SubscriptionStatus ERROR = SubscriptionStatus.builder().value(Value.ERROR).build();
    public static final SubscriptionStatus OFF = SubscriptionStatus.builder().value(Value.OFF).build();
    private volatile int hashCode;

    private SubscriptionStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static SubscriptionStatus of(Value value) {
        switch (value) {
            case REQUESTED: {
                return REQUESTED;
            }
            case ACTIVE: {
                return ACTIVE;
            }
            case ERROR: {
                return ERROR;
            }
            case OFF: {
                return OFF;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SubscriptionStatus of(java.lang.String value) {
        return SubscriptionStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SubscriptionStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SubscriptionStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionStatus other = (SubscriptionStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        REQUESTED("requested"),
        ACTIVE("active"),
        ERROR("error"),
        OFF("off");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "requested": {
                    return REQUESTED;
                }
                case "active": {
                    return ACTIVE;
                }
                case "error": {
                    return ERROR;
                }
                case "off": {
                    return OFF;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SubscriptionStatus build() {
            SubscriptionStatus subscriptionStatus = new SubscriptionStatus(this);
            if (this.validating) {
                this.validate(subscriptionStatus);
            }
            return subscriptionStatus;
        }

        protected void validate(SubscriptionStatus subscriptionStatus) {
            super.validate(subscriptionStatus);
        }

        protected Builder from(SubscriptionStatus subscriptionStatus) {
            super.from(subscriptionStatus);
            return this;
        }
    }
}

