/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.util;

import com.ibm.fhir.model.util.JsonSupport;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class ElementFilter
implements Function<JsonObject, JsonObject> {
    private static final JsonBuilderFactory BUILDER_FACTORY = Json.createBuilderFactory(null);
    private static final List<String> REQUIRED_ELEMENTS = Arrays.asList("resourceType", "id", "_id", "meta");
    private Set<String> includeElements = new HashSet<String>();

    public ElementFilter(Class<?> resourceType) {
        this.includeElements.addAll(REQUIRED_ELEMENTS);
        this.includeElements.addAll(JsonSupport.getRequiredElementNames(resourceType));
    }

    public ElementFilter(Class<?> resourceType, Collection<String> elements) {
        this(resourceType);
        this.includeElements.addAll(elements);
    }

    public void addElements(Collection<String> elements) {
        this.includeElements.addAll(elements);
    }

    @Override
    public JsonObject apply(JsonObject jsonObject) {
        JsonObjectBuilder builder = BUILDER_FACTORY.createObjectBuilder();
        jsonObject.entrySet().stream().filter(e -> this.includeElements.contains(e.getKey())).forEach(e -> builder.add((String)e.getKey(), (JsonValue)e.getValue()));
        return builder.build();
    }
}

