/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.util;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.constraint.spi.ConstraintProvider;
import com.ibm.fhir.model.constraint.spi.ModelConstraintProvider;
import com.ibm.fhir.model.resource.Account;
import com.ibm.fhir.model.resource.ActivityDefinition;
import com.ibm.fhir.model.resource.AdverseEvent;
import com.ibm.fhir.model.resource.AllergyIntolerance;
import com.ibm.fhir.model.resource.Appointment;
import com.ibm.fhir.model.resource.AppointmentResponse;
import com.ibm.fhir.model.resource.AuditEvent;
import com.ibm.fhir.model.resource.Basic;
import com.ibm.fhir.model.resource.Binary;
import com.ibm.fhir.model.resource.BiologicallyDerivedProduct;
import com.ibm.fhir.model.resource.BodyStructure;
import com.ibm.fhir.model.resource.Bundle;
import com.ibm.fhir.model.resource.CapabilityStatement;
import com.ibm.fhir.model.resource.CarePlan;
import com.ibm.fhir.model.resource.CareTeam;
import com.ibm.fhir.model.resource.CatalogEntry;
import com.ibm.fhir.model.resource.ChargeItem;
import com.ibm.fhir.model.resource.ChargeItemDefinition;
import com.ibm.fhir.model.resource.Claim;
import com.ibm.fhir.model.resource.ClaimResponse;
import com.ibm.fhir.model.resource.ClinicalImpression;
import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.Communication;
import com.ibm.fhir.model.resource.CommunicationRequest;
import com.ibm.fhir.model.resource.CompartmentDefinition;
import com.ibm.fhir.model.resource.Composition;
import com.ibm.fhir.model.resource.ConceptMap;
import com.ibm.fhir.model.resource.Condition;
import com.ibm.fhir.model.resource.Consent;
import com.ibm.fhir.model.resource.Contract;
import com.ibm.fhir.model.resource.Coverage;
import com.ibm.fhir.model.resource.CoverageEligibilityRequest;
import com.ibm.fhir.model.resource.CoverageEligibilityResponse;
import com.ibm.fhir.model.resource.DetectedIssue;
import com.ibm.fhir.model.resource.Device;
import com.ibm.fhir.model.resource.DeviceDefinition;
import com.ibm.fhir.model.resource.DeviceMetric;
import com.ibm.fhir.model.resource.DeviceRequest;
import com.ibm.fhir.model.resource.DeviceUseStatement;
import com.ibm.fhir.model.resource.DiagnosticReport;
import com.ibm.fhir.model.resource.DocumentManifest;
import com.ibm.fhir.model.resource.DocumentReference;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.EffectEvidenceSynthesis;
import com.ibm.fhir.model.resource.Encounter;
import com.ibm.fhir.model.resource.Endpoint;
import com.ibm.fhir.model.resource.EnrollmentRequest;
import com.ibm.fhir.model.resource.EnrollmentResponse;
import com.ibm.fhir.model.resource.EpisodeOfCare;
import com.ibm.fhir.model.resource.EventDefinition;
import com.ibm.fhir.model.resource.Evidence;
import com.ibm.fhir.model.resource.EvidenceVariable;
import com.ibm.fhir.model.resource.ExampleScenario;
import com.ibm.fhir.model.resource.ExplanationOfBenefit;
import com.ibm.fhir.model.resource.FamilyMemberHistory;
import com.ibm.fhir.model.resource.Flag;
import com.ibm.fhir.model.resource.Goal;
import com.ibm.fhir.model.resource.GraphDefinition;
import com.ibm.fhir.model.resource.Group;
import com.ibm.fhir.model.resource.GuidanceResponse;
import com.ibm.fhir.model.resource.HealthcareService;
import com.ibm.fhir.model.resource.ImagingStudy;
import com.ibm.fhir.model.resource.Immunization;
import com.ibm.fhir.model.resource.ImmunizationEvaluation;
import com.ibm.fhir.model.resource.ImmunizationRecommendation;
import com.ibm.fhir.model.resource.ImplementationGuide;
import com.ibm.fhir.model.resource.InsurancePlan;
import com.ibm.fhir.model.resource.Invoice;
import com.ibm.fhir.model.resource.Library;
import com.ibm.fhir.model.resource.Linkage;
import com.ibm.fhir.model.resource.List;
import com.ibm.fhir.model.resource.Location;
import com.ibm.fhir.model.resource.Measure;
import com.ibm.fhir.model.resource.MeasureReport;
import com.ibm.fhir.model.resource.Media;
import com.ibm.fhir.model.resource.Medication;
import com.ibm.fhir.model.resource.MedicationAdministration;
import com.ibm.fhir.model.resource.MedicationDispense;
import com.ibm.fhir.model.resource.MedicationKnowledge;
import com.ibm.fhir.model.resource.MedicationRequest;
import com.ibm.fhir.model.resource.MedicationStatement;
import com.ibm.fhir.model.resource.MedicinalProduct;
import com.ibm.fhir.model.resource.MedicinalProductAuthorization;
import com.ibm.fhir.model.resource.MedicinalProductContraindication;
import com.ibm.fhir.model.resource.MedicinalProductIndication;
import com.ibm.fhir.model.resource.MedicinalProductIngredient;
import com.ibm.fhir.model.resource.MedicinalProductInteraction;
import com.ibm.fhir.model.resource.MedicinalProductManufactured;
import com.ibm.fhir.model.resource.MedicinalProductPackaged;
import com.ibm.fhir.model.resource.MedicinalProductPharmaceutical;
import com.ibm.fhir.model.resource.MedicinalProductUndesirableEffect;
import com.ibm.fhir.model.resource.MessageDefinition;
import com.ibm.fhir.model.resource.MessageHeader;
import com.ibm.fhir.model.resource.MolecularSequence;
import com.ibm.fhir.model.resource.NamingSystem;
import com.ibm.fhir.model.resource.NutritionOrder;
import com.ibm.fhir.model.resource.Observation;
import com.ibm.fhir.model.resource.ObservationDefinition;
import com.ibm.fhir.model.resource.OperationDefinition;
import com.ibm.fhir.model.resource.OperationOutcome;
import com.ibm.fhir.model.resource.Organization;
import com.ibm.fhir.model.resource.OrganizationAffiliation;
import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.resource.Patient;
import com.ibm.fhir.model.resource.PaymentNotice;
import com.ibm.fhir.model.resource.PaymentReconciliation;
import com.ibm.fhir.model.resource.Person;
import com.ibm.fhir.model.resource.PlanDefinition;
import com.ibm.fhir.model.resource.Practitioner;
import com.ibm.fhir.model.resource.PractitionerRole;
import com.ibm.fhir.model.resource.Procedure;
import com.ibm.fhir.model.resource.Provenance;
import com.ibm.fhir.model.resource.Questionnaire;
import com.ibm.fhir.model.resource.QuestionnaireResponse;
import com.ibm.fhir.model.resource.RelatedPerson;
import com.ibm.fhir.model.resource.RequestGroup;
import com.ibm.fhir.model.resource.ResearchDefinition;
import com.ibm.fhir.model.resource.ResearchElementDefinition;
import com.ibm.fhir.model.resource.ResearchStudy;
import com.ibm.fhir.model.resource.ResearchSubject;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.RiskAssessment;
import com.ibm.fhir.model.resource.RiskEvidenceSynthesis;
import com.ibm.fhir.model.resource.Schedule;
import com.ibm.fhir.model.resource.SearchParameter;
import com.ibm.fhir.model.resource.ServiceRequest;
import com.ibm.fhir.model.resource.Slot;
import com.ibm.fhir.model.resource.Specimen;
import com.ibm.fhir.model.resource.SpecimenDefinition;
import com.ibm.fhir.model.resource.StructureDefinition;
import com.ibm.fhir.model.resource.StructureMap;
import com.ibm.fhir.model.resource.Subscription;
import com.ibm.fhir.model.resource.Substance;
import com.ibm.fhir.model.resource.SubstanceNucleicAcid;
import com.ibm.fhir.model.resource.SubstancePolymer;
import com.ibm.fhir.model.resource.SubstanceProtein;
import com.ibm.fhir.model.resource.SubstanceReferenceInformation;
import com.ibm.fhir.model.resource.SubstanceSourceMaterial;
import com.ibm.fhir.model.resource.SubstanceSpecification;
import com.ibm.fhir.model.resource.SupplyDelivery;
import com.ibm.fhir.model.resource.SupplyRequest;
import com.ibm.fhir.model.resource.Task;
import com.ibm.fhir.model.resource.TerminologyCapabilities;
import com.ibm.fhir.model.resource.TestReport;
import com.ibm.fhir.model.resource.TestScript;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.resource.VerificationResult;
import com.ibm.fhir.model.resource.VisionPrescription;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Contributor;
import com.ibm.fhir.model.type.Count;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Distance;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.ElementDefinition;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.MarketingStatus;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.MoneyQuantity;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Oid;
import com.ibm.fhir.model.type.ParameterDefinition;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Population;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.ProdCharacteristic;
import com.ibm.fhir.model.type.ProductShelfLife;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.SampledData;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.SubstanceAmount;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.TriggerDefinition;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.Uuid;
import com.ibm.fhir.model.type.Xhtml;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class ModelSupport {
    private static final Logger log = Logger.getLogger(ModelSupport.class.getName());
    public static final Class<Boolean> FHIR_BOOLEAN = Boolean.class;
    public static final Class<Integer> FHIR_INTEGER = Integer.class;
    public static final Class<String> FHIR_STRING = String.class;
    public static final Class<Date> FHIR_DATE = Date.class;
    public static final Class<com.ibm.fhir.model.type.Instant> FHIR_INSTANT = com.ibm.fhir.model.type.Instant.class;
    private static final Map<Class<?>, Class<?>> CONCRETE_TYPE_MAP = ModelSupport.buildConcreteTypeMap();
    private static final java.util.List<Class<?>> MODEL_CLASSES = Arrays.asList(Element.class, Extension.class, BackboneElement.class, String.class, Uri.class, Integer.class, Quantity.class, Address.class, Age.class, Annotation.class, Attachment.class, Base64Binary.class, Boolean.class, Canonical.class, Code.class, CodeableConcept.class, Coding.class, ContactDetail.class, ContactPoint.class, Contributor.class, Count.class, DataRequirement.class, DataRequirement.CodeFilter.class, DataRequirement.DateFilter.class, DataRequirement.Sort.class, Date.class, DateTime.class, Decimal.class, Distance.class, Dosage.class, Dosage.DoseAndRate.class, Duration.class, ElementDefinition.class, ElementDefinition.Base.class, ElementDefinition.Binding.class, ElementDefinition.Constraint.class, ElementDefinition.Example.class, ElementDefinition.Mapping.class, ElementDefinition.Slicing.class, ElementDefinition.Slicing.Discriminator.class, ElementDefinition.Type.class, Expression.class, HumanName.class, Id.class, Identifier.class, com.ibm.fhir.model.type.Instant.class, Markdown.class, MarketingStatus.class, Meta.class, Money.class, MoneyQuantity.class, Narrative.class, Oid.class, ParameterDefinition.class, Period.class, Population.class, PositiveInt.class, ProdCharacteristic.class, ProductShelfLife.class, Range.class, Ratio.class, Reference.class, RelatedArtifact.class, SampledData.class, Signature.class, SimpleQuantity.class, SubstanceAmount.class, SubstanceAmount.ReferenceRange.class, Time.class, Timing.class, Timing.Repeat.class, TriggerDefinition.class, UnsignedInt.class, Url.class, UsageContext.class, Uuid.class, Xhtml.class, Resource.class, DomainResource.class, Account.class, Account.Coverage.class, Account.Guarantor.class, ActivityDefinition.class, ActivityDefinition.DynamicValue.class, ActivityDefinition.Participant.class, AdverseEvent.class, AdverseEvent.SuspectEntity.class, AdverseEvent.SuspectEntity.Causality.class, AllergyIntolerance.class, AllergyIntolerance.Reaction.class, Appointment.class, Appointment.Participant.class, AppointmentResponse.class, AuditEvent.class, AuditEvent.Agent.class, AuditEvent.Agent.Network.class, AuditEvent.Entity.class, AuditEvent.Entity.Detail.class, AuditEvent.Source.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProduct.Collection.class, BiologicallyDerivedProduct.Manipulation.class, BiologicallyDerivedProduct.Processing.class, BiologicallyDerivedProduct.Storage.class, BodyStructure.class, Bundle.class, Bundle.Entry.class, Bundle.Entry.Request.class, Bundle.Entry.Response.class, Bundle.Entry.Search.class, Bundle.Link.class, CapabilityStatement.class, CapabilityStatement.Document.class, CapabilityStatement.Implementation.class, CapabilityStatement.Messaging.class, CapabilityStatement.Messaging.Endpoint.class, CapabilityStatement.Messaging.SupportedMessage.class, CapabilityStatement.Rest.class, CapabilityStatement.Rest.Interaction.class, CapabilityStatement.Rest.Resource.class, CapabilityStatement.Rest.Resource.Interaction.class, CapabilityStatement.Rest.Resource.Operation.class, CapabilityStatement.Rest.Resource.SearchParam.class, CapabilityStatement.Rest.Security.class, CapabilityStatement.Software.class, CarePlan.class, CarePlan.Activity.class, CarePlan.Activity.Detail.class, CareTeam.class, CareTeam.Participant.class, CatalogEntry.class, CatalogEntry.RelatedEntry.class, ChargeItem.class, ChargeItem.Performer.class, ChargeItemDefinition.class, ChargeItemDefinition.Applicability.class, ChargeItemDefinition.PropertyGroup.class, ChargeItemDefinition.PropertyGroup.PriceComponent.class, Claim.class, Claim.Accident.class, Claim.CareTeam.class, Claim.Diagnosis.class, Claim.Insurance.class, Claim.Item.class, Claim.Item.Detail.class, Claim.Item.Detail.SubDetail.class, Claim.Payee.class, Claim.Procedure.class, Claim.Related.class, Claim.SupportingInfo.class, ClaimResponse.class, ClaimResponse.AddItem.class, ClaimResponse.AddItem.Detail.class, ClaimResponse.AddItem.Detail.SubDetail.class, ClaimResponse.Error.class, ClaimResponse.Insurance.class, ClaimResponse.Item.class, ClaimResponse.Item.Adjudication.class, ClaimResponse.Item.Detail.class, ClaimResponse.Item.Detail.SubDetail.class, ClaimResponse.Payment.class, ClaimResponse.ProcessNote.class, ClaimResponse.Total.class, ClinicalImpression.class, ClinicalImpression.Finding.class, ClinicalImpression.Investigation.class, CodeSystem.class, CodeSystem.Concept.class, CodeSystem.Concept.Designation.class, CodeSystem.Concept.Property.class, CodeSystem.Filter.class, CodeSystem.Property.class, Communication.class, Communication.Payload.class, CommunicationRequest.class, CommunicationRequest.Payload.class, CompartmentDefinition.class, CompartmentDefinition.Resource.class, Composition.class, Composition.Attester.class, Composition.Event.class, Composition.RelatesTo.class, Composition.Section.class, ConceptMap.class, ConceptMap.Group.class, ConceptMap.Group.Element.class, ConceptMap.Group.Element.Target.class, ConceptMap.Group.Element.Target.DependsOn.class, ConceptMap.Group.Unmapped.class, Condition.class, Condition.Evidence.class, Condition.Stage.class, Consent.class, Consent.Policy.class, Consent.Provision.class, Consent.Provision.Actor.class, Consent.Provision.Data.class, Consent.Verification.class, Contract.class, Contract.ContentDefinition.class, Contract.Friendly.class, Contract.Legal.class, Contract.Rule.class, Contract.Signer.class, Contract.Term.class, Contract.Term.Action.class, Contract.Term.Action.Subject.class, Contract.Term.Asset.class, Contract.Term.Asset.Context.class, Contract.Term.Asset.ValuedItem.class, Contract.Term.Offer.class, Contract.Term.Offer.Answer.class, Contract.Term.Offer.Party.class, Contract.Term.SecurityLabel.class, Coverage.class, Coverage.Class.class, Coverage.CostToBeneficiary.class, Coverage.CostToBeneficiary.Exception.class, CoverageEligibilityRequest.class, CoverageEligibilityRequest.Insurance.class, CoverageEligibilityRequest.Item.class, CoverageEligibilityRequest.Item.Diagnosis.class, CoverageEligibilityRequest.SupportingInfo.class, CoverageEligibilityResponse.class, CoverageEligibilityResponse.Error.class, CoverageEligibilityResponse.Insurance.class, CoverageEligibilityResponse.Insurance.Item.class, CoverageEligibilityResponse.Insurance.Item.Benefit.class, DetectedIssue.class, DetectedIssue.Evidence.class, DetectedIssue.Mitigation.class, Device.class, Device.DeviceName.class, Device.Property.class, Device.Specialization.class, Device.UdiCarrier.class, Device.Version.class, DeviceDefinition.class, DeviceDefinition.Capability.class, DeviceDefinition.DeviceName.class, DeviceDefinition.Material.class, DeviceDefinition.Property.class, DeviceDefinition.Specialization.class, DeviceDefinition.UdiDeviceIdentifier.class, DeviceMetric.class, DeviceMetric.Calibration.class, DeviceRequest.class, DeviceRequest.Parameter.class, DeviceUseStatement.class, DiagnosticReport.class, DiagnosticReport.Media.class, DocumentManifest.class, DocumentManifest.Related.class, DocumentReference.class, DocumentReference.Content.class, DocumentReference.Context.class, DocumentReference.RelatesTo.class, EffectEvidenceSynthesis.class, EffectEvidenceSynthesis.Certainty.class, EffectEvidenceSynthesis.Certainty.CertaintySubcomponent.class, EffectEvidenceSynthesis.EffectEstimate.class, EffectEvidenceSynthesis.EffectEstimate.PrecisionEstimate.class, EffectEvidenceSynthesis.ResultsByExposure.class, EffectEvidenceSynthesis.SampleSize.class, Encounter.class, Encounter.ClassHistory.class, Encounter.Diagnosis.class, Encounter.Hospitalization.class, Encounter.Location.class, Encounter.Participant.class, Encounter.StatusHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EpisodeOfCare.Diagnosis.class, EpisodeOfCare.StatusHistory.class, EventDefinition.class, Evidence.class, EvidenceVariable.class, EvidenceVariable.Characteristic.class, ExampleScenario.class, ExampleScenario.Actor.class, ExampleScenario.Instance.class, ExampleScenario.Instance.ContainedInstance.class, ExampleScenario.Instance.Version.class, ExampleScenario.Process.class, ExampleScenario.Process.Step.class, ExampleScenario.Process.Step.Alternative.class, ExampleScenario.Process.Step.Operation.class, ExplanationOfBenefit.class, ExplanationOfBenefit.Accident.class, ExplanationOfBenefit.AddItem.class, ExplanationOfBenefit.AddItem.Detail.class, ExplanationOfBenefit.AddItem.Detail.SubDetail.class, ExplanationOfBenefit.BenefitBalance.class, ExplanationOfBenefit.BenefitBalance.Financial.class, ExplanationOfBenefit.CareTeam.class, ExplanationOfBenefit.Diagnosis.class, ExplanationOfBenefit.Insurance.class, ExplanationOfBenefit.Item.class, ExplanationOfBenefit.Item.Adjudication.class, ExplanationOfBenefit.Item.Detail.class, ExplanationOfBenefit.Item.Detail.SubDetail.class, ExplanationOfBenefit.Payee.class, ExplanationOfBenefit.Payment.class, ExplanationOfBenefit.Procedure.class, ExplanationOfBenefit.ProcessNote.class, ExplanationOfBenefit.Related.class, ExplanationOfBenefit.SupportingInfo.class, ExplanationOfBenefit.Total.class, FamilyMemberHistory.class, FamilyMemberHistory.Condition.class, Flag.class, Goal.class, Goal.Target.class, GraphDefinition.class, GraphDefinition.Link.class, GraphDefinition.Link.Target.class, GraphDefinition.Link.Target.Compartment.class, Group.class, Group.Characteristic.class, Group.Member.class, GuidanceResponse.class, HealthcareService.class, HealthcareService.AvailableTime.class, HealthcareService.Eligibility.class, HealthcareService.NotAvailable.class, ImagingStudy.class, ImagingStudy.Series.class, ImagingStudy.Series.Instance.class, ImagingStudy.Series.Performer.class, Immunization.class, Immunization.Education.class, Immunization.Performer.class, Immunization.ProtocolApplied.class, Immunization.Reaction.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImmunizationRecommendation.Recommendation.class, ImmunizationRecommendation.Recommendation.DateCriterion.class, ImplementationGuide.class, ImplementationGuide.Definition.class, ImplementationGuide.Definition.Grouping.class, ImplementationGuide.Definition.Page.class, ImplementationGuide.Definition.Parameter.class, ImplementationGuide.Definition.Resource.class, ImplementationGuide.Definition.Template.class, ImplementationGuide.DependsOn.class, ImplementationGuide.Global.class, ImplementationGuide.Manifest.class, ImplementationGuide.Manifest.Page.class, ImplementationGuide.Manifest.Resource.class, InsurancePlan.class, InsurancePlan.Contact.class, InsurancePlan.Coverage.class, InsurancePlan.Coverage.Benefit.class, InsurancePlan.Coverage.Benefit.Limit.class, InsurancePlan.Plan.class, InsurancePlan.Plan.GeneralCost.class, InsurancePlan.Plan.SpecificCost.class, InsurancePlan.Plan.SpecificCost.Benefit.class, InsurancePlan.Plan.SpecificCost.Benefit.Cost.class, Invoice.class, Invoice.LineItem.class, Invoice.LineItem.PriceComponent.class, Invoice.Participant.class, Library.class, Linkage.class, Linkage.Item.class, List.class, List.Entry.class, Location.class, Location.HoursOfOperation.class, Location.Position.class, Measure.class, Measure.Group.class, Measure.Group.Population.class, Measure.Group.Stratifier.class, Measure.Group.Stratifier.Component.class, Measure.SupplementalData.class, MeasureReport.class, MeasureReport.Group.class, MeasureReport.Group.Population.class, MeasureReport.Group.Stratifier.class, MeasureReport.Group.Stratifier.Stratum.class, MeasureReport.Group.Stratifier.Stratum.Component.class, MeasureReport.Group.Stratifier.Stratum.Population.class, Media.class, Medication.class, Medication.Batch.class, Medication.Ingredient.class, MedicationAdministration.class, MedicationAdministration.Dosage.class, MedicationAdministration.Performer.class, MedicationDispense.class, MedicationDispense.Performer.class, MedicationDispense.Substitution.class, MedicationKnowledge.class, MedicationKnowledge.AdministrationGuidelines.class, MedicationKnowledge.AdministrationGuidelines.Dosage.class, MedicationKnowledge.AdministrationGuidelines.PatientCharacteristics.class, MedicationKnowledge.Cost.class, MedicationKnowledge.DrugCharacteristic.class, MedicationKnowledge.Ingredient.class, MedicationKnowledge.Kinetics.class, MedicationKnowledge.MedicineClassification.class, MedicationKnowledge.MonitoringProgram.class, MedicationKnowledge.Monograph.class, MedicationKnowledge.Packaging.class, MedicationKnowledge.Regulatory.class, MedicationKnowledge.Regulatory.MaxDispense.class, MedicationKnowledge.Regulatory.Schedule.class, MedicationKnowledge.Regulatory.Substitution.class, MedicationKnowledge.RelatedMedicationKnowledge.class, MedicationRequest.class, MedicationRequest.DispenseRequest.class, MedicationRequest.DispenseRequest.InitialFill.class, MedicationRequest.Substitution.class, MedicationStatement.class, MedicinalProduct.class, MedicinalProduct.ManufacturingBusinessOperation.class, MedicinalProduct.Name.class, MedicinalProduct.Name.CountryLanguage.class, MedicinalProduct.Name.NamePart.class, MedicinalProduct.SpecialDesignation.class, MedicinalProductAuthorization.class, MedicinalProductAuthorization.JurisdictionalAuthorization.class, MedicinalProductAuthorization.Procedure.class, MedicinalProductContraindication.class, MedicinalProductContraindication.OtherTherapy.class, MedicinalProductIndication.class, MedicinalProductIndication.OtherTherapy.class, MedicinalProductIngredient.class, MedicinalProductIngredient.SpecifiedSubstance.class, MedicinalProductIngredient.SpecifiedSubstance.Strength.class, MedicinalProductIngredient.SpecifiedSubstance.Strength.ReferenceStrength.class, MedicinalProductIngredient.Substance.class, MedicinalProductInteraction.class, MedicinalProductInteraction.Interactant.class, MedicinalProductManufactured.class, MedicinalProductPackaged.class, MedicinalProductPackaged.BatchIdentifier.class, MedicinalProductPackaged.PackageItem.class, MedicinalProductPharmaceutical.class, MedicinalProductPharmaceutical.Characteristics.class, MedicinalProductPharmaceutical.RouteOfAdministration.class, MedicinalProductPharmaceutical.RouteOfAdministration.TargetSpecies.class, MedicinalProductPharmaceutical.RouteOfAdministration.TargetSpecies.WithdrawalPeriod.class, MedicinalProductUndesirableEffect.class, MessageDefinition.class, MessageDefinition.AllowedResponse.class, MessageDefinition.Focus.class, MessageHeader.class, MessageHeader.Destination.class, MessageHeader.Response.class, MessageHeader.Source.class, MolecularSequence.class, MolecularSequence.Quality.class, MolecularSequence.Quality.Roc.class, MolecularSequence.ReferenceSeq.class, MolecularSequence.Repository.class, MolecularSequence.StructureVariant.class, MolecularSequence.StructureVariant.Inner.class, MolecularSequence.StructureVariant.Outer.class, MolecularSequence.Variant.class, NamingSystem.class, NamingSystem.UniqueId.class, NutritionOrder.class, NutritionOrder.EnteralFormula.class, NutritionOrder.EnteralFormula.Administration.class, NutritionOrder.OralDiet.class, NutritionOrder.OralDiet.Nutrient.class, NutritionOrder.OralDiet.Texture.class, NutritionOrder.Supplement.class, Observation.class, Observation.Component.class, Observation.ReferenceRange.class, ObservationDefinition.class, ObservationDefinition.QualifiedInterval.class, ObservationDefinition.QuantitativeDetails.class, OperationDefinition.class, OperationDefinition.Overload.class, OperationDefinition.Parameter.class, OperationDefinition.Parameter.Binding.class, OperationDefinition.Parameter.ReferencedFrom.class, OperationOutcome.class, OperationOutcome.Issue.class, Organization.class, Organization.Contact.class, OrganizationAffiliation.class, Parameters.class, Parameters.Parameter.class, Patient.class, Patient.Communication.class, Patient.Contact.class, Patient.Link.class, PaymentNotice.class, PaymentReconciliation.class, PaymentReconciliation.Detail.class, PaymentReconciliation.ProcessNote.class, Person.class, Person.Link.class, PlanDefinition.class, PlanDefinition.Action.class, PlanDefinition.Action.Condition.class, PlanDefinition.Action.DynamicValue.class, PlanDefinition.Action.Participant.class, PlanDefinition.Action.RelatedAction.class, PlanDefinition.Goal.class, PlanDefinition.Goal.Target.class, Practitioner.class, Practitioner.Qualification.class, PractitionerRole.class, PractitionerRole.AvailableTime.class, PractitionerRole.NotAvailable.class, Procedure.class, Procedure.FocalDevice.class, Procedure.Performer.class, Provenance.class, Provenance.Agent.class, Provenance.Entity.class, Questionnaire.class, Questionnaire.Item.class, Questionnaire.Item.AnswerOption.class, Questionnaire.Item.EnableWhen.class, Questionnaire.Item.Initial.class, QuestionnaireResponse.class, QuestionnaireResponse.Item.class, QuestionnaireResponse.Item.Answer.class, RelatedPerson.class, RelatedPerson.Communication.class, RequestGroup.class, RequestGroup.Action.class, RequestGroup.Action.Condition.class, RequestGroup.Action.RelatedAction.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchElementDefinition.Characteristic.class, ResearchStudy.class, ResearchStudy.Arm.class, ResearchStudy.Objective.class, ResearchSubject.class, RiskAssessment.class, RiskAssessment.Prediction.class, RiskEvidenceSynthesis.class, RiskEvidenceSynthesis.Certainty.class, RiskEvidenceSynthesis.Certainty.CertaintySubcomponent.class, RiskEvidenceSynthesis.RiskEstimate.class, RiskEvidenceSynthesis.RiskEstimate.PrecisionEstimate.class, RiskEvidenceSynthesis.SampleSize.class, Schedule.class, SearchParameter.class, SearchParameter.Component.class, ServiceRequest.class, Slot.class, Specimen.class, Specimen.Collection.class, Specimen.Container.class, Specimen.Processing.class, SpecimenDefinition.class, SpecimenDefinition.TypeTested.class, SpecimenDefinition.TypeTested.Container.class, SpecimenDefinition.TypeTested.Container.Additive.class, SpecimenDefinition.TypeTested.Handling.class, StructureDefinition.class, StructureDefinition.Context.class, StructureDefinition.Differential.class, StructureDefinition.Mapping.class, StructureDefinition.Snapshot.class, StructureMap.class, StructureMap.Group.class, StructureMap.Group.Input.class, StructureMap.Group.Rule.class, StructureMap.Group.Rule.Dependent.class, StructureMap.Group.Rule.Source.class, StructureMap.Group.Rule.Target.class, StructureMap.Group.Rule.Target.Parameter.class, StructureMap.Structure.class, Subscription.class, Subscription.Channel.class, Substance.class, Substance.Ingredient.class, Substance.Instance.class, SubstanceNucleicAcid.class, SubstanceNucleicAcid.Subunit.class, SubstanceNucleicAcid.Subunit.Linkage.class, SubstanceNucleicAcid.Subunit.Sugar.class, SubstancePolymer.class, SubstancePolymer.MonomerSet.class, SubstancePolymer.MonomerSet.StartingMaterial.class, SubstancePolymer.Repeat.class, SubstancePolymer.Repeat.RepeatUnit.class, SubstancePolymer.Repeat.RepeatUnit.DegreeOfPolymerisation.class, SubstancePolymer.Repeat.RepeatUnit.StructuralRepresentation.class, SubstanceProtein.class, SubstanceProtein.Subunit.class, SubstanceReferenceInformation.class, SubstanceReferenceInformation.Classification.class, SubstanceReferenceInformation.Gene.class, SubstanceReferenceInformation.GeneElement.class, SubstanceReferenceInformation.Target.class, SubstanceSourceMaterial.class, SubstanceSourceMaterial.FractionDescription.class, SubstanceSourceMaterial.Organism.class, SubstanceSourceMaterial.Organism.Author.class, SubstanceSourceMaterial.Organism.Hybrid.class, SubstanceSourceMaterial.Organism.OrganismGeneral.class, SubstanceSourceMaterial.PartDescription.class, SubstanceSpecification.class, SubstanceSpecification.Code.class, SubstanceSpecification.Moiety.class, SubstanceSpecification.Name.class, SubstanceSpecification.Name.Official.class, SubstanceSpecification.Property.class, SubstanceSpecification.Relationship.class, SubstanceSpecification.Structure.class, SubstanceSpecification.Structure.Isotope.class, SubstanceSpecification.Structure.Isotope.MolecularWeight.class, SubstanceSpecification.Structure.Representation.class, SupplyDelivery.class, SupplyDelivery.SuppliedItem.class, SupplyRequest.class, SupplyRequest.Parameter.class, Task.class, Task.Input.class, Task.Output.class, Task.Restriction.class, TerminologyCapabilities.class, TerminologyCapabilities.Closure.class, TerminologyCapabilities.CodeSystem.class, TerminologyCapabilities.CodeSystem.Version.class, TerminologyCapabilities.CodeSystem.Version.Filter.class, TerminologyCapabilities.Expansion.class, TerminologyCapabilities.Expansion.Parameter.class, TerminologyCapabilities.Implementation.class, TerminologyCapabilities.Software.class, TerminologyCapabilities.Translation.class, TerminologyCapabilities.ValidateCode.class, TestReport.class, TestReport.Participant.class, TestReport.Setup.class, TestReport.Setup.Action.class, TestReport.Setup.Action.Assert.class, TestReport.Setup.Action.Operation.class, TestReport.Teardown.class, TestReport.Teardown.Action.class, TestReport.Test.class, TestReport.Test.Action.class, TestScript.class, TestScript.Destination.class, TestScript.Fixture.class, TestScript.Metadata.class, TestScript.Metadata.Capability.class, TestScript.Metadata.Link.class, TestScript.Origin.class, TestScript.Setup.class, TestScript.Setup.Action.class, TestScript.Setup.Action.Assert.class, TestScript.Setup.Action.Operation.class, TestScript.Setup.Action.Operation.RequestHeader.class, TestScript.Teardown.class, TestScript.Teardown.Action.class, TestScript.Test.class, TestScript.Test.Action.class, TestScript.Variable.class, ValueSet.class, ValueSet.Compose.class, ValueSet.Compose.Include.class, ValueSet.Compose.Include.Concept.class, ValueSet.Compose.Include.Concept.Designation.class, ValueSet.Compose.Include.Filter.class, ValueSet.Expansion.class, ValueSet.Expansion.Contains.class, ValueSet.Expansion.Parameter.class, VerificationResult.class, VerificationResult.Attestation.class, VerificationResult.PrimarySource.class, VerificationResult.Validator.class, VisionPrescription.class, VisionPrescription.LensSpecification.class, VisionPrescription.LensSpecification.Prism.class);
    private static final Map<Class<?>, Map<java.lang.String, ElementInfo>> MODEL_CLASS_ELEMENT_INFO_MAP = ModelSupport.buildModelClassElementInfoMap();
    private static final Map<java.lang.String, Class<? extends Resource>> RESOURCE_TYPE_MAP = ModelSupport.buildResourceTypeMap();
    private static final Set<Class<? extends Resource>> CONCRETE_RESOURCE_TYPES = ModelSupport.getResourceTypes().stream().filter(rt -> !ModelSupport.isAbstract(rt)).collect(Collectors.toSet());
    private static final Map<Class<?>, java.util.List<Constraint>> MODEL_CLASS_CONSTRAINT_MAP = ModelSupport.buildModelClassConstraintMap();
    private static final Set<Class<? extends Element>> CHOICE_ELEMENT_TYPES = new LinkedHashSet<Class>(Arrays.asList(Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, com.ibm.fhir.model.type.Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, MoneyQuantity.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, SimpleQuantity.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class));
    private static final Set<Class<? extends Element>> DATA_TYPES;
    private static final Map<java.lang.String, Class<?>> DATA_TYPE_MAP;
    private static final Set<java.lang.String> KEYWORDS;
    private static final Map<java.lang.String, Class<?>> CODE_SUBTYPE_MAP;

    private ModelSupport() {
    }

    public static void init() {
    }

    private static Map<java.lang.String, Class<?>> buildCodeSubtypeMap() {
        Map map;
        block9: {
            InputStream in = ModelSupport.class.getClassLoader().getResourceAsStream("codeSubtypeClasses");
            try {
                LinkedHashMap codeSubtypeMap = new LinkedHashMap();
                java.util.List lines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                for (java.lang.String className : lines) {
                    Class<?> codeSubtypeClass = Class.forName(className);
                    codeSubtypeMap.put(codeSubtypeClass.getSimpleName(), codeSubtypeClass);
                }
                map = Collections.unmodifiableMap(codeSubtypeMap);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            in.close();
        }
        return map;
    }

    private static Map<java.lang.String, Class<?>> buildDataTypeMap() {
        LinkedHashMap<java.lang.String, Class<? extends Element>> dataTypeMap = new LinkedHashMap<java.lang.String, Class<? extends Element>>();
        for (Class<? extends Element> dataType : DATA_TYPES) {
            dataTypeMap.put(ModelSupport.getTypeName(dataType), dataType);
        }
        return Collections.unmodifiableMap(dataTypeMap);
    }

    private static Map<Class<?>, Class<?>> buildConcreteTypeMap() {
        LinkedHashMap<Class, Class<Quantity>> concreteTypeMap = new LinkedHashMap<Class, Class<Quantity>>();
        concreteTypeMap.put(SimpleQuantity.class, Quantity.class);
        concreteTypeMap.put(MoneyQuantity.class, Quantity.class);
        return Collections.unmodifiableMap(concreteTypeMap);
    }

    private static Map<Class<?>, java.util.List<Constraint>> buildModelClassConstraintMap() {
        LinkedHashMap modelClassConstraintMap = new LinkedHashMap(1024);
        java.util.List<ModelConstraintProvider> providers = ConstraintProvider.providers(ModelConstraintProvider.class);
        for (Class<?> modelClass : ModelSupport.getModelClasses()) {
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            for (Class<?> clazz : ModelSupport.getClosure(modelClass)) {
                for (Constraint constraint : (Constraint[])clazz.getDeclaredAnnotationsByType(Constraint.class)) {
                    constraints.add(Constraint.Factory.createConstraint(constraint.id(), constraint.level(), constraint.location(), constraint.description(), constraint.expression(), constraint.source(), constraint.modelChecked(), constraint.generated()));
                }
            }
            for (ModelConstraintProvider provider : providers) {
                if (!provider.appliesTo(modelClass)) continue;
                for (Predicate predicate : provider.getRemovalPredicates()) {
                    constraints.removeIf(predicate);
                }
                constraints.addAll(provider.getConstraints());
            }
            modelClassConstraintMap.put(modelClass, Collections.unmodifiableList(constraints));
        }
        return Collections.unmodifiableMap(modelClassConstraintMap);
    }

    private static Map<Class<?>, Map<java.lang.String, ElementInfo>> buildModelClassElementInfoMap() {
        LinkedHashMap modelClassElementInfoMap = new LinkedHashMap(1024);
        for (Class<?> modelClass : MODEL_CLASSES) {
            Map<java.lang.String, ElementInfo> elementInfoMap = ModelSupport.getElementInfoMap(modelClass, modelClassElementInfoMap);
            modelClassElementInfoMap.put(modelClass, Collections.unmodifiableMap(elementInfoMap));
        }
        return Collections.unmodifiableMap(modelClassElementInfoMap);
    }

    private static Map<java.lang.String, Class<? extends Resource>> buildResourceTypeMap() {
        LinkedHashMap resourceTypeMap = new LinkedHashMap(256);
        for (Class<?> modelClass : ModelSupport.getModelClasses()) {
            if (!ModelSupport.isResourceType(modelClass)) continue;
            resourceTypeMap.put(modelClass.getSimpleName(), modelClass);
        }
        return Collections.unmodifiableMap(resourceTypeMap);
    }

    private static Map<java.lang.String, ElementInfo> getElementInfoMap(Class<?> modelClass, Map<Class<?>, Map<java.lang.String, ElementInfo>> elementInfoMapCache) {
        LinkedHashMap<java.lang.String, ElementInfo> elementInfoMap = new LinkedHashMap<java.lang.String, ElementInfo>();
        for (Class<?> clazz : ModelSupport.getClosure(modelClass)) {
            if (elementInfoMapCache.containsKey(clazz)) {
                elementInfoMap.putAll(elementInfoMapCache.get(clazz));
                continue;
            }
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isVolatile(modifiers)) continue;
                java.lang.String elementName = ModelSupport.getElementName(field);
                Class<?> type = ModelSupport.getFieldType(field);
                Class<?> declaringType = field.getDeclaringClass();
                boolean required = ModelSupport.isRequired(field);
                boolean summary = ModelSupport.isSummary(field);
                boolean repeating = ModelSupport.isRepeating(field);
                boolean choice = ModelSupport.isChoice(field);
                boolean reference = ModelSupport.isReference(field);
                Binding binding = field.getAnnotation(Binding.class);
                Set<Class<?>> choiceTypes = choice ? Collections.unmodifiableSet(ModelSupport.getChoiceTypes(field)) : Collections.emptySet();
                Set<java.lang.String> referenceTypes = reference ? Collections.unmodifiableSet(ModelSupport.getReferenceTypes(field)) : Collections.emptySet();
                elementInfoMap.put(elementName, new ElementInfo(elementName, type, declaringType, required, repeating, choice, choiceTypes, reference, referenceTypes, binding, summary));
            }
        }
        return elementInfoMap;
    }

    public static java.lang.String getChoiceElementName(java.lang.String name, Class<?> type) {
        return name + ModelSupport.getConcreteType(type).getSimpleName();
    }

    public static Set<Class<?>> getChoiceElementTypes(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getChoiceTypes();
        }
        return Collections.emptySet();
    }

    public static Set<java.lang.String> getReferenceTargetTypes(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getReferenceTypes();
        }
        return Collections.emptySet();
    }

    private static Set<Class<?>> getChoiceTypes(Field field) {
        return new LinkedHashSet(Arrays.asList(field.getAnnotation(Choice.class).value()));
    }

    private static Set<java.lang.String> getReferenceTypes(Field field) {
        return new LinkedHashSet<java.lang.String>(Arrays.asList(field.getAnnotation(ReferenceTarget.class).value()));
    }

    public static java.util.List<Class<?>> getClosure(Class<?> modelClass) {
        ArrayList closure = new ArrayList();
        while (!Object.class.equals(modelClass)) {
            closure.add(modelClass);
            modelClass = modelClass.getSuperclass();
        }
        Collections.reverse(closure);
        return closure;
    }

    public static Class<?> getConcreteType(Class<?> type) {
        if (ModelSupport.isProfiledType(type)) {
            return CONCRETE_TYPE_MAP.get(type);
        }
        return type;
    }

    public static java.util.List<Constraint> getConstraints(Class<?> modelClass) {
        return MODEL_CLASS_CONSTRAINT_MAP.getOrDefault(modelClass, Collections.emptyList());
    }

    public static ElementInfo getElementInfo(Class<?> modelClass, java.lang.String elementName) {
        return (ElementInfo)MODEL_CLASS_ELEMENT_INFO_MAP.getOrDefault(modelClass, Collections.emptyMap()).get(elementName);
    }

    public static Collection<ElementInfo> getElementInfo(Class<?> modelClass) {
        return MODEL_CLASS_ELEMENT_INFO_MAP.getOrDefault(modelClass, Collections.emptyMap()).values();
    }

    public static ElementInfo getChoiceElementInfo(Class<?> modelClass, java.lang.String typeSpecificElementName) {
        for (ElementInfo elementInfo : ModelSupport.getElementInfo(modelClass)) {
            if (!elementInfo.isChoice() || !elementInfo.getChoiceElementNames().contains(typeSpecificElementName)) continue;
            return elementInfo;
        }
        return null;
    }

    public static java.lang.String getElementName(Field field) {
        return ModelSupport.getElementName(field.getName());
    }

    public static java.lang.String getElementName(java.lang.String fieldName) {
        if ("clazz".equals(fieldName)) {
            return "class";
        }
        if (fieldName.startsWith("_")) {
            return fieldName.substring(1);
        }
        return fieldName;
    }

    public static Set<java.lang.String> getElementNames(Class<?> modelClass) {
        return MODEL_CLASS_ELEMENT_INFO_MAP.getOrDefault(modelClass, Collections.emptyMap()).keySet();
    }

    public static Class<?> getElementType(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getType();
        }
        return null;
    }

    public static Class<?> getElementDeclaringType(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getDeclaringType();
        }
        return null;
    }

    public static boolean isElementDeclaredBy(Class<?> modelClass, java.lang.String elementName, Class<?> type) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isDeclaredBy(type);
        }
        return false;
    }

    private static Class<?> getFieldType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return field.getType();
    }

    public static Set<Class<?>> getModelClasses() {
        return MODEL_CLASS_ELEMENT_INFO_MAP.keySet();
    }

    public static Class<? extends Resource> getResourceType(java.lang.String name) {
        return RESOURCE_TYPE_MAP.get(name);
    }

    public static Collection<Class<? extends Resource>> getResourceTypes() {
        return RESOURCE_TYPE_MAP.values();
    }

    public static Collection<Class<? extends Resource>> getResourceTypes(boolean includeAbstractTypes) {
        if (includeAbstractTypes) {
            return RESOURCE_TYPE_MAP.values();
        }
        return CONCRETE_RESOURCE_TYPES;
    }

    public static Set<Class<? extends Element>> getDataTypes() {
        return DATA_TYPES;
    }

    public static java.lang.String getTypeName(Class<?> type) {
        java.lang.String typeName = type.getSimpleName();
        if (Code.class.isAssignableFrom(type)) {
            typeName = "code";
        } else if (ModelSupport.isPrimitiveType(type)) {
            typeName = typeName.substring(0, 1).toLowerCase() + typeName.substring(1);
        }
        return typeName;
    }

    public static Set<java.lang.String> getTypeNames(Class<?> modelClass) {
        HashSet<java.lang.String> typeNames = new HashSet<java.lang.String>();
        while (!Object.class.equals(modelClass)) {
            typeNames.add(ModelSupport.getTypeName(modelClass));
            modelClass = modelClass.getSuperclass();
        }
        return typeNames;
    }

    public static boolean isBackboneElementType(Class<?> modelClass) {
        return BackboneElement.class.isAssignableFrom(modelClass);
    }

    private static boolean isChoice(Field field) {
        return field.isAnnotationPresent(Choice.class);
    }

    private static boolean isReference(Field field) {
        return field.isAnnotationPresent(ReferenceTarget.class);
    }

    public static boolean isChoiceElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isChoice();
        }
        return false;
    }

    public static boolean isChoiceElementType(Class<?> type) {
        return CHOICE_ELEMENT_TYPES.contains(type);
    }

    public static boolean isCodeSubtype(Class<?> type) {
        return Code.class.isAssignableFrom(type) && !Code.class.equals(type);
    }

    public static boolean isElement(Object modelObject) {
        return modelObject instanceof Element;
    }

    public static boolean isElementType(Class<?> modelClass) {
        return Element.class.isAssignableFrom(modelClass);
    }

    public static boolean isMetadataType(Class<?> type) {
        return ContactDetail.class.equals(type) || Contributor.class.equals(type) || DataRequirement.class.isAssignableFrom(type) || RelatedArtifact.class.isAssignableFrom(type) || UsageContext.class.equals(type) || ParameterDefinition.class.equals(type) || Expression.class.equals(type) || TriggerDefinition.class.equals(type);
    }

    public static boolean isModelClass(Class<?> type) {
        return ModelSupport.isResourceType(type) || ModelSupport.isElementType(type);
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return Base64Binary.class.equals(type) || Boolean.class.equals(type) || String.class.isAssignableFrom(type) || Uri.class.isAssignableFrom(type) || DateTime.class.equals(type) || Date.class.equals(type) || Time.class.equals(type) || com.ibm.fhir.model.type.Instant.class.equals(type) || Integer.class.isAssignableFrom(type) || Decimal.class.equals(type) || Xhtml.class.equals(type);
    }

    public static boolean isProfiledType(Class<?> type) {
        return CONCRETE_TYPE_MAP.containsKey(type);
    }

    private static boolean isRepeating(Field field) {
        return java.util.List.class.equals(field.getType());
    }

    public static boolean isRepeatingElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isRepeating();
        }
        return false;
    }

    private static boolean isRequired(Field field) {
        return field.isAnnotationPresent(Required.class);
    }

    private static boolean isSummary(Field field) {
        return field.isAnnotationPresent(Summary.class);
    }

    public static boolean isRequiredElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isRequired();
        }
        return false;
    }

    public static boolean isResource(Object modelObject) {
        return modelObject instanceof Resource;
    }

    public static boolean isResourceType(Class<?> modelClass) {
        return Resource.class.isAssignableFrom(modelClass);
    }

    public static boolean isAbstract(Class<?> modelClass) {
        return Modifier.isAbstract(modelClass.getModifiers());
    }

    public static boolean isResourceType(java.lang.String name) {
        return RESOURCE_TYPE_MAP.containsKey(name);
    }

    public static boolean isConcreteResourceType(java.lang.String name) {
        Class<? extends Resource> modelClass = RESOURCE_TYPE_MAP.get(name);
        return modelClass != null && !ModelSupport.isAbstract(modelClass);
    }

    public static boolean isSummaryElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isSummary();
        }
        return false;
    }

    public static ZonedDateTime truncateTime(ZonedDateTime dateTime, ChronoUnit unit) {
        return dateTime == null ? null : dateTime.truncatedTo(unit);
    }

    public static LocalTime truncateTime(LocalTime time, ChronoUnit unit) {
        return time == null ? null : time.truncatedTo(unit);
    }

    public static TemporalAccessor truncateTime(TemporalAccessor ta, ChronoUnit unit) {
        if (ta instanceof Instant) {
            ta = ((Instant)ta).truncatedTo(unit);
        } else if (ta instanceof ZonedDateTime) {
            ta = ((ZonedDateTime)ta).truncatedTo(unit);
        } else if (ta instanceof LocalDateTime) {
            ta = ((LocalDateTime)ta).truncatedTo(unit);
        } else if (ta instanceof LocalTime) {
            ta = ((LocalTime)ta).truncatedTo(unit);
        } else if (ta instanceof OffsetTime) {
            ta = ((OffsetTime)ta).truncatedTo(unit);
        } else if (ta instanceof OffsetDateTime) {
            ta = ((OffsetDateTime)ta).truncatedTo(unit);
        }
        return ta;
    }

    public static boolean isKeyword(java.lang.String identifier) {
        return KEYWORDS.contains(identifier);
    }

    public static java.lang.String delimit(java.lang.String identifier) {
        return java.lang.String.format("`%s`", identifier);
    }

    public static java.lang.String getSystem(Code code) {
        if (code != null && code.getClass().isAnnotationPresent(System.class)) {
            return code.getClass().getAnnotation(System.class).value();
        }
        return null;
    }

    public static Class<?> getDataType(java.lang.String typeName) {
        return DATA_TYPE_MAP.get(typeName);
    }

    public static boolean isCodeSubtype(java.lang.String name) {
        return CODE_SUBTYPE_MAP.containsKey(name);
    }

    public static Collection<Class<?>> getCodeSubtypes() {
        return CODE_SUBTYPE_MAP.values();
    }

    static {
        LinkedHashSet<Class<? extends Element>> dataTypes = new LinkedHashSet<Class<? extends Element>>(CHOICE_ELEMENT_TYPES);
        dataTypes.add(Xhtml.class);
        dataTypes.add(Narrative.class);
        dataTypes.add(Extension.class);
        dataTypes.add(ElementDefinition.class);
        dataTypes.add(MarketingStatus.class);
        dataTypes.add(Population.class);
        dataTypes.add(ProductShelfLife.class);
        dataTypes.add(ProdCharacteristic.class);
        dataTypes.add(SubstanceAmount.class);
        DATA_TYPES = Collections.unmodifiableSet(dataTypes);
        DATA_TYPE_MAP = ModelSupport.buildDataTypeMap();
        KEYWORDS = new HashSet<java.lang.String>(Arrays.asList("$index", "$this", "$total", "and", "as", "contains", "day", "days", "div", "false", "hour", "hours", "implies", "in", "is", "millisecond", "milliseconds", "minute", "minutes", "mod", "month", "months", "or", "seconds", "true", "week", "weeks", "xor", "year", "years", "second"));
        CODE_SUBTYPE_MAP = ModelSupport.buildCodeSubtypeMap();
    }

    public static final class ElementInfo {
        private final java.lang.String name;
        private final Class<?> type;
        private final Class<?> declaringType;
        private final boolean required;
        private final boolean repeating;
        private final boolean choice;
        private final Set<Class<?>> choiceTypes;
        private final boolean reference;
        private final Set<java.lang.String> referenceTypes;
        private final Binding binding;
        private final boolean summary;
        private final Set<java.lang.String> choiceElementNames;

        ElementInfo(java.lang.String name, Class<?> type, Class<?> declaringType, boolean required, boolean repeating, boolean choice, Set<Class<?>> choiceTypes, boolean reference, Set<java.lang.String> referenceTypes, Binding binding, boolean isSummary) {
            this.name = name;
            this.declaringType = declaringType;
            this.type = type;
            this.required = required;
            this.repeating = repeating;
            this.choice = choice;
            this.choiceTypes = choiceTypes;
            this.reference = reference;
            this.referenceTypes = referenceTypes;
            this.binding = binding;
            this.summary = isSummary;
            LinkedHashSet<java.lang.String> choiceElementNames = new LinkedHashSet<java.lang.String>();
            if (this.choice) {
                for (Class<?> choiceType : this.choiceTypes) {
                    choiceElementNames.add(ModelSupport.getChoiceElementName(this.name, choiceType));
                }
            }
            this.choiceElementNames = Collections.unmodifiableSet(choiceElementNames);
        }

        public java.lang.String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Class<?> getDeclaringType() {
            return this.declaringType;
        }

        public boolean isDeclaredBy(Class<?> type) {
            return this.declaringType.equals(type);
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isSummary() {
            return this.summary;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public boolean isChoice() {
            return this.choice;
        }

        public Set<Class<?>> getChoiceTypes() {
            return this.choiceTypes;
        }

        public boolean isReference() {
            return this.reference;
        }

        public Set<java.lang.String> getReferenceTypes() {
            return this.referenceTypes;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public boolean hasBinding() {
            return this.binding != null;
        }

        public Set<java.lang.String> getChoiceElementNames() {
            return this.choiceElementNames;
        }
    }
}

