/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.generator;

import com.ibm.fhir.model.generator.FHIRGenerator;
import com.ibm.fhir.model.generator.exception.FHIRGeneratorException;
import com.ibm.fhir.model.visitor.Visitable;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class FHIRAbstractGenerator
implements FHIRGenerator {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected final boolean prettyPrinting;

    protected FHIRAbstractGenerator(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    @Override
    public abstract void generate(Visitable var1, OutputStream var2) throws FHIRGeneratorException;

    @Override
    public abstract void generate(Visitable var1, Writer var2) throws FHIRGeneratorException;

    @Override
    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    @Override
    public void setProperty(String name, Object value) {
        Objects.requireNonNull(name);
        if (!this.isPropertySupported(name)) {
            throw new IllegalArgumentException("Property: " + name + " is not supported.");
        }
        this.properties.put(name, Objects.requireNonNull(value));
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(Objects.requireNonNull(name));
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        return Objects.requireNonNull(type).cast(this.getProperty(name));
    }

    @Override
    public Object getPropertyOrDefault(String name, Object defaultValue) {
        return this.properties.getOrDefault(Objects.requireNonNull(name), Objects.requireNonNull(defaultValue));
    }

    @Override
    public <T> T getPropertyOrDefault(String name, T defaultValue, Class<T> type) {
        return Objects.requireNonNull(type).cast(this.getPropertyOrDefault(name, defaultValue));
    }

    @Override
    public boolean isPropertySupported(String name) {
        return false;
    }

    @Override
    public <T extends FHIRGenerator> T as(Class<T> generatorClass) {
        return (T)((FHIRGenerator)generatorClass.cast(this));
    }
}

