/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.generator;

import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.model.visitor.PathAwareVisitor;
import java.util.Set;
import java.util.Stack;

public abstract class GeneratingVisitor
extends PathAwareVisitor {
    protected final Stack<Class<?>> typeStack = new Stack();

    protected GeneratingVisitor() {
    }

    protected final String getChoiceElementName(String name, Class<?> type) {
        if (!this.isChoiceElement(name)) {
            throw new IllegalArgumentException("Element '" + name + "' is not a choice element");
        }
        Class modelClass = (Class)this.typeStack.get(this.getDepth() - 2);
        Set<Class<?>> choiceElementTypes = ModelSupport.getChoiceElementTypes(modelClass, name);
        if (!choiceElementTypes.contains(type)) {
            for (Class<?> choiceElementType : choiceElementTypes) {
                if (!choiceElementType.isAssignableFrom(type)) continue;
                type = choiceElementType;
                break;
            }
        }
        return ModelSupport.getChoiceElementName(name, type);
    }

    protected final int getDepth() {
        return this.typeStack.size();
    }

    protected final boolean isChoiceElement(String name) {
        if (this.getDepth() > 1) {
            return ModelSupport.isChoiceElement((Class)this.typeStack.get(this.getDepth() - 2), name);
        }
        return false;
    }

    @Override
    public final void postVisit(Element element) {
        this.typeStack.pop();
    }

    @Override
    public final void postVisit(Resource resource) {
        this.typeStack.pop();
    }

    @Override
    public final boolean preVisit(Element element) {
        this.typeStack.push(element.getClass());
        return true;
    }

    @Override
    public final boolean preVisit(Resource resource) {
        this.typeStack.push(resource.getClass());
        return true;
    }
}

