/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.parser;

import com.ibm.fhir.model.parser.FHIRAbstractParser;
import com.ibm.fhir.model.parser.exception.FHIRParserException;
import com.ibm.fhir.model.resource.Account;
import com.ibm.fhir.model.resource.ActivityDefinition;
import com.ibm.fhir.model.resource.AdverseEvent;
import com.ibm.fhir.model.resource.AllergyIntolerance;
import com.ibm.fhir.model.resource.Appointment;
import com.ibm.fhir.model.resource.AppointmentResponse;
import com.ibm.fhir.model.resource.AuditEvent;
import com.ibm.fhir.model.resource.Basic;
import com.ibm.fhir.model.resource.Binary;
import com.ibm.fhir.model.resource.BiologicallyDerivedProduct;
import com.ibm.fhir.model.resource.BodyStructure;
import com.ibm.fhir.model.resource.Bundle;
import com.ibm.fhir.model.resource.CapabilityStatement;
import com.ibm.fhir.model.resource.CarePlan;
import com.ibm.fhir.model.resource.CareTeam;
import com.ibm.fhir.model.resource.CatalogEntry;
import com.ibm.fhir.model.resource.ChargeItem;
import com.ibm.fhir.model.resource.ChargeItemDefinition;
import com.ibm.fhir.model.resource.Claim;
import com.ibm.fhir.model.resource.ClaimResponse;
import com.ibm.fhir.model.resource.ClinicalImpression;
import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.Communication;
import com.ibm.fhir.model.resource.CommunicationRequest;
import com.ibm.fhir.model.resource.CompartmentDefinition;
import com.ibm.fhir.model.resource.Composition;
import com.ibm.fhir.model.resource.ConceptMap;
import com.ibm.fhir.model.resource.Condition;
import com.ibm.fhir.model.resource.Consent;
import com.ibm.fhir.model.resource.Contract;
import com.ibm.fhir.model.resource.Coverage;
import com.ibm.fhir.model.resource.CoverageEligibilityRequest;
import com.ibm.fhir.model.resource.CoverageEligibilityResponse;
import com.ibm.fhir.model.resource.DetectedIssue;
import com.ibm.fhir.model.resource.Device;
import com.ibm.fhir.model.resource.DeviceDefinition;
import com.ibm.fhir.model.resource.DeviceMetric;
import com.ibm.fhir.model.resource.DeviceRequest;
import com.ibm.fhir.model.resource.DeviceUseStatement;
import com.ibm.fhir.model.resource.DiagnosticReport;
import com.ibm.fhir.model.resource.DocumentManifest;
import com.ibm.fhir.model.resource.DocumentReference;
import com.ibm.fhir.model.resource.EffectEvidenceSynthesis;
import com.ibm.fhir.model.resource.Encounter;
import com.ibm.fhir.model.resource.Endpoint;
import com.ibm.fhir.model.resource.EnrollmentRequest;
import com.ibm.fhir.model.resource.EnrollmentResponse;
import com.ibm.fhir.model.resource.EpisodeOfCare;
import com.ibm.fhir.model.resource.EventDefinition;
import com.ibm.fhir.model.resource.Evidence;
import com.ibm.fhir.model.resource.EvidenceVariable;
import com.ibm.fhir.model.resource.ExampleScenario;
import com.ibm.fhir.model.resource.ExplanationOfBenefit;
import com.ibm.fhir.model.resource.FamilyMemberHistory;
import com.ibm.fhir.model.resource.Flag;
import com.ibm.fhir.model.resource.Goal;
import com.ibm.fhir.model.resource.GraphDefinition;
import com.ibm.fhir.model.resource.Group;
import com.ibm.fhir.model.resource.GuidanceResponse;
import com.ibm.fhir.model.resource.HealthcareService;
import com.ibm.fhir.model.resource.ImagingStudy;
import com.ibm.fhir.model.resource.Immunization;
import com.ibm.fhir.model.resource.ImmunizationEvaluation;
import com.ibm.fhir.model.resource.ImmunizationRecommendation;
import com.ibm.fhir.model.resource.ImplementationGuide;
import com.ibm.fhir.model.resource.InsurancePlan;
import com.ibm.fhir.model.resource.Invoice;
import com.ibm.fhir.model.resource.Library;
import com.ibm.fhir.model.resource.Linkage;
import com.ibm.fhir.model.resource.List;
import com.ibm.fhir.model.resource.Location;
import com.ibm.fhir.model.resource.Measure;
import com.ibm.fhir.model.resource.MeasureReport;
import com.ibm.fhir.model.resource.Media;
import com.ibm.fhir.model.resource.Medication;
import com.ibm.fhir.model.resource.MedicationAdministration;
import com.ibm.fhir.model.resource.MedicationDispense;
import com.ibm.fhir.model.resource.MedicationKnowledge;
import com.ibm.fhir.model.resource.MedicationRequest;
import com.ibm.fhir.model.resource.MedicationStatement;
import com.ibm.fhir.model.resource.MedicinalProduct;
import com.ibm.fhir.model.resource.MedicinalProductAuthorization;
import com.ibm.fhir.model.resource.MedicinalProductContraindication;
import com.ibm.fhir.model.resource.MedicinalProductIndication;
import com.ibm.fhir.model.resource.MedicinalProductIngredient;
import com.ibm.fhir.model.resource.MedicinalProductInteraction;
import com.ibm.fhir.model.resource.MedicinalProductManufactured;
import com.ibm.fhir.model.resource.MedicinalProductPackaged;
import com.ibm.fhir.model.resource.MedicinalProductPharmaceutical;
import com.ibm.fhir.model.resource.MedicinalProductUndesirableEffect;
import com.ibm.fhir.model.resource.MessageDefinition;
import com.ibm.fhir.model.resource.MessageHeader;
import com.ibm.fhir.model.resource.MolecularSequence;
import com.ibm.fhir.model.resource.NamingSystem;
import com.ibm.fhir.model.resource.NutritionOrder;
import com.ibm.fhir.model.resource.Observation;
import com.ibm.fhir.model.resource.ObservationDefinition;
import com.ibm.fhir.model.resource.OperationDefinition;
import com.ibm.fhir.model.resource.OperationOutcome;
import com.ibm.fhir.model.resource.Organization;
import com.ibm.fhir.model.resource.OrganizationAffiliation;
import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.resource.Patient;
import com.ibm.fhir.model.resource.PaymentNotice;
import com.ibm.fhir.model.resource.PaymentReconciliation;
import com.ibm.fhir.model.resource.Person;
import com.ibm.fhir.model.resource.PlanDefinition;
import com.ibm.fhir.model.resource.Practitioner;
import com.ibm.fhir.model.resource.PractitionerRole;
import com.ibm.fhir.model.resource.Procedure;
import com.ibm.fhir.model.resource.Provenance;
import com.ibm.fhir.model.resource.Questionnaire;
import com.ibm.fhir.model.resource.QuestionnaireResponse;
import com.ibm.fhir.model.resource.RelatedPerson;
import com.ibm.fhir.model.resource.RequestGroup;
import com.ibm.fhir.model.resource.ResearchDefinition;
import com.ibm.fhir.model.resource.ResearchElementDefinition;
import com.ibm.fhir.model.resource.ResearchStudy;
import com.ibm.fhir.model.resource.ResearchSubject;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.RiskAssessment;
import com.ibm.fhir.model.resource.RiskEvidenceSynthesis;
import com.ibm.fhir.model.resource.Schedule;
import com.ibm.fhir.model.resource.SearchParameter;
import com.ibm.fhir.model.resource.ServiceRequest;
import com.ibm.fhir.model.resource.Slot;
import com.ibm.fhir.model.resource.Specimen;
import com.ibm.fhir.model.resource.SpecimenDefinition;
import com.ibm.fhir.model.resource.StructureDefinition;
import com.ibm.fhir.model.resource.StructureMap;
import com.ibm.fhir.model.resource.Subscription;
import com.ibm.fhir.model.resource.Substance;
import com.ibm.fhir.model.resource.SubstanceNucleicAcid;
import com.ibm.fhir.model.resource.SubstancePolymer;
import com.ibm.fhir.model.resource.SubstanceProtein;
import com.ibm.fhir.model.resource.SubstanceReferenceInformation;
import com.ibm.fhir.model.resource.SubstanceSourceMaterial;
import com.ibm.fhir.model.resource.SubstanceSpecification;
import com.ibm.fhir.model.resource.SupplyDelivery;
import com.ibm.fhir.model.resource.SupplyRequest;
import com.ibm.fhir.model.resource.Task;
import com.ibm.fhir.model.resource.TerminologyCapabilities;
import com.ibm.fhir.model.resource.TestReport;
import com.ibm.fhir.model.resource.TestScript;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.resource.VerificationResult;
import com.ibm.fhir.model.resource.VisionPrescription;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Contributor;
import com.ibm.fhir.model.type.Count;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Distance;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.ElementDefinition;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.MarketingStatus;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Oid;
import com.ibm.fhir.model.type.ParameterDefinition;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Population;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.ProdCharacteristic;
import com.ibm.fhir.model.type.ProductShelfLife;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.SampledData;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.SubstanceAmount;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.TriggerDefinition;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.Uuid;
import com.ibm.fhir.model.type.Xhtml;
import com.ibm.fhir.model.type.code.AccountStatus;
import com.ibm.fhir.model.type.code.ActionCardinalityBehavior;
import com.ibm.fhir.model.type.code.ActionConditionKind;
import com.ibm.fhir.model.type.code.ActionGroupingBehavior;
import com.ibm.fhir.model.type.code.ActionParticipantType;
import com.ibm.fhir.model.type.code.ActionPrecheckBehavior;
import com.ibm.fhir.model.type.code.ActionRelationshipType;
import com.ibm.fhir.model.type.code.ActionRequiredBehavior;
import com.ibm.fhir.model.type.code.ActionSelectionBehavior;
import com.ibm.fhir.model.type.code.ActivityDefinitionKind;
import com.ibm.fhir.model.type.code.ActivityParticipantType;
import com.ibm.fhir.model.type.code.AddressType;
import com.ibm.fhir.model.type.code.AddressUse;
import com.ibm.fhir.model.type.code.AdministrativeGender;
import com.ibm.fhir.model.type.code.AdverseEventActuality;
import com.ibm.fhir.model.type.code.AggregationMode;
import com.ibm.fhir.model.type.code.AllergyIntoleranceCategory;
import com.ibm.fhir.model.type.code.AllergyIntoleranceCriticality;
import com.ibm.fhir.model.type.code.AllergyIntoleranceSeverity;
import com.ibm.fhir.model.type.code.AllergyIntoleranceType;
import com.ibm.fhir.model.type.code.AppointmentStatus;
import com.ibm.fhir.model.type.code.AssertionDirectionType;
import com.ibm.fhir.model.type.code.AssertionOperatorType;
import com.ibm.fhir.model.type.code.AssertionResponseTypes;
import com.ibm.fhir.model.type.code.AuditEventAction;
import com.ibm.fhir.model.type.code.AuditEventAgentNetworkType;
import com.ibm.fhir.model.type.code.AuditEventOutcome;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductCategory;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductStatus;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductStorageScale;
import com.ibm.fhir.model.type.code.BundleType;
import com.ibm.fhir.model.type.code.CapabilityStatementKind;
import com.ibm.fhir.model.type.code.CarePlanActivityKind;
import com.ibm.fhir.model.type.code.CarePlanActivityStatus;
import com.ibm.fhir.model.type.code.CarePlanIntent;
import com.ibm.fhir.model.type.code.CarePlanStatus;
import com.ibm.fhir.model.type.code.CareTeamStatus;
import com.ibm.fhir.model.type.code.CatalogEntryRelationType;
import com.ibm.fhir.model.type.code.ChargeItemDefinitionPriceComponentType;
import com.ibm.fhir.model.type.code.ChargeItemStatus;
import com.ibm.fhir.model.type.code.ClaimResponseStatus;
import com.ibm.fhir.model.type.code.ClaimStatus;
import com.ibm.fhir.model.type.code.ClinicalImpressionStatus;
import com.ibm.fhir.model.type.code.CodeSearchSupport;
import com.ibm.fhir.model.type.code.CodeSystemContentMode;
import com.ibm.fhir.model.type.code.CodeSystemHierarchyMeaning;
import com.ibm.fhir.model.type.code.CommunicationPriority;
import com.ibm.fhir.model.type.code.CommunicationRequestStatus;
import com.ibm.fhir.model.type.code.CommunicationStatus;
import com.ibm.fhir.model.type.code.CompartmentCode;
import com.ibm.fhir.model.type.code.CompartmentType;
import com.ibm.fhir.model.type.code.CompositionAttestationMode;
import com.ibm.fhir.model.type.code.CompositionStatus;
import com.ibm.fhir.model.type.code.ConceptMapEquivalence;
import com.ibm.fhir.model.type.code.ConceptMapGroupUnmappedMode;
import com.ibm.fhir.model.type.code.ConditionalDeleteStatus;
import com.ibm.fhir.model.type.code.ConditionalReadStatus;
import com.ibm.fhir.model.type.code.ConsentDataMeaning;
import com.ibm.fhir.model.type.code.ConsentProvisionType;
import com.ibm.fhir.model.type.code.ConsentState;
import com.ibm.fhir.model.type.code.ConstraintSeverity;
import com.ibm.fhir.model.type.code.ContactPointSystem;
import com.ibm.fhir.model.type.code.ContactPointUse;
import com.ibm.fhir.model.type.code.ContractPublicationStatus;
import com.ibm.fhir.model.type.code.ContractStatus;
import com.ibm.fhir.model.type.code.ContributorType;
import com.ibm.fhir.model.type.code.CoverageStatus;
import com.ibm.fhir.model.type.code.DayOfWeek;
import com.ibm.fhir.model.type.code.DaysOfWeek;
import com.ibm.fhir.model.type.code.DetectedIssueSeverity;
import com.ibm.fhir.model.type.code.DetectedIssueStatus;
import com.ibm.fhir.model.type.code.DeviceMetricCalibrationState;
import com.ibm.fhir.model.type.code.DeviceMetricCalibrationType;
import com.ibm.fhir.model.type.code.DeviceMetricCategory;
import com.ibm.fhir.model.type.code.DeviceMetricColor;
import com.ibm.fhir.model.type.code.DeviceMetricOperationalStatus;
import com.ibm.fhir.model.type.code.DeviceNameType;
import com.ibm.fhir.model.type.code.DeviceRequestStatus;
import com.ibm.fhir.model.type.code.DeviceUseStatementStatus;
import com.ibm.fhir.model.type.code.DiagnosticReportStatus;
import com.ibm.fhir.model.type.code.DiscriminatorType;
import com.ibm.fhir.model.type.code.DocumentConfidentiality;
import com.ibm.fhir.model.type.code.DocumentMode;
import com.ibm.fhir.model.type.code.DocumentReferenceStatus;
import com.ibm.fhir.model.type.code.DocumentRelationshipType;
import com.ibm.fhir.model.type.code.EligibilityRequestPurpose;
import com.ibm.fhir.model.type.code.EligibilityRequestStatus;
import com.ibm.fhir.model.type.code.EligibilityResponsePurpose;
import com.ibm.fhir.model.type.code.EligibilityResponseStatus;
import com.ibm.fhir.model.type.code.EnableWhenBehavior;
import com.ibm.fhir.model.type.code.EncounterLocationStatus;
import com.ibm.fhir.model.type.code.EncounterStatus;
import com.ibm.fhir.model.type.code.EndpointStatus;
import com.ibm.fhir.model.type.code.EnrollmentRequestStatus;
import com.ibm.fhir.model.type.code.EnrollmentResponseStatus;
import com.ibm.fhir.model.type.code.EpisodeOfCareStatus;
import com.ibm.fhir.model.type.code.EventCapabilityMode;
import com.ibm.fhir.model.type.code.EventTiming;
import com.ibm.fhir.model.type.code.EvidenceVariableType;
import com.ibm.fhir.model.type.code.ExampleScenarioActorType;
import com.ibm.fhir.model.type.code.ExplanationOfBenefitStatus;
import com.ibm.fhir.model.type.code.ExposureState;
import com.ibm.fhir.model.type.code.ExtensionContextType;
import com.ibm.fhir.model.type.code.FHIRAllTypes;
import com.ibm.fhir.model.type.code.FHIRDefinedType;
import com.ibm.fhir.model.type.code.FHIRDeviceStatus;
import com.ibm.fhir.model.type.code.FHIRResourceType;
import com.ibm.fhir.model.type.code.FHIRSubstanceStatus;
import com.ibm.fhir.model.type.code.FHIRVersion;
import com.ibm.fhir.model.type.code.FamilyHistoryStatus;
import com.ibm.fhir.model.type.code.FilterOperator;
import com.ibm.fhir.model.type.code.FlagStatus;
import com.ibm.fhir.model.type.code.GoalLifecycleStatus;
import com.ibm.fhir.model.type.code.GraphCompartmentRule;
import com.ibm.fhir.model.type.code.GraphCompartmentUse;
import com.ibm.fhir.model.type.code.GroupMeasure;
import com.ibm.fhir.model.type.code.GroupType;
import com.ibm.fhir.model.type.code.GuidanceResponseStatus;
import com.ibm.fhir.model.type.code.GuidePageGeneration;
import com.ibm.fhir.model.type.code.GuideParameterCode;
import com.ibm.fhir.model.type.code.HTTPVerb;
import com.ibm.fhir.model.type.code.IdentifierUse;
import com.ibm.fhir.model.type.code.IdentityAssuranceLevel;
import com.ibm.fhir.model.type.code.ImagingStudyStatus;
import com.ibm.fhir.model.type.code.ImmunizationEvaluationStatus;
import com.ibm.fhir.model.type.code.ImmunizationStatus;
import com.ibm.fhir.model.type.code.InvoicePriceComponentType;
import com.ibm.fhir.model.type.code.InvoiceStatus;
import com.ibm.fhir.model.type.code.IssueSeverity;
import com.ibm.fhir.model.type.code.IssueType;
import com.ibm.fhir.model.type.code.LinkType;
import com.ibm.fhir.model.type.code.LinkageType;
import com.ibm.fhir.model.type.code.ListMode;
import com.ibm.fhir.model.type.code.ListStatus;
import com.ibm.fhir.model.type.code.LocationMode;
import com.ibm.fhir.model.type.code.LocationStatus;
import com.ibm.fhir.model.type.code.MeasureReportStatus;
import com.ibm.fhir.model.type.code.MeasureReportType;
import com.ibm.fhir.model.type.code.MediaStatus;
import com.ibm.fhir.model.type.code.MedicationAdministrationStatus;
import com.ibm.fhir.model.type.code.MedicationDispenseStatus;
import com.ibm.fhir.model.type.code.MedicationKnowledgeStatus;
import com.ibm.fhir.model.type.code.MedicationRequestIntent;
import com.ibm.fhir.model.type.code.MedicationRequestPriority;
import com.ibm.fhir.model.type.code.MedicationRequestStatus;
import com.ibm.fhir.model.type.code.MedicationStatementStatus;
import com.ibm.fhir.model.type.code.MedicationStatus;
import com.ibm.fhir.model.type.code.MessageHeaderResponseRequest;
import com.ibm.fhir.model.type.code.MessageSignificanceCategory;
import com.ibm.fhir.model.type.code.NameUse;
import com.ibm.fhir.model.type.code.NamingSystemIdentifierType;
import com.ibm.fhir.model.type.code.NamingSystemType;
import com.ibm.fhir.model.type.code.NarrativeStatus;
import com.ibm.fhir.model.type.code.NoteType;
import com.ibm.fhir.model.type.code.NutritionOrderIntent;
import com.ibm.fhir.model.type.code.NutritionOrderStatus;
import com.ibm.fhir.model.type.code.ObservationDataType;
import com.ibm.fhir.model.type.code.ObservationRangeCategory;
import com.ibm.fhir.model.type.code.ObservationStatus;
import com.ibm.fhir.model.type.code.OperationKind;
import com.ibm.fhir.model.type.code.OperationParameterUse;
import com.ibm.fhir.model.type.code.OrientationType;
import com.ibm.fhir.model.type.code.ParameterUse;
import com.ibm.fhir.model.type.code.ParticipantRequired;
import com.ibm.fhir.model.type.code.ParticipantStatus;
import com.ibm.fhir.model.type.code.ParticipationStatus;
import com.ibm.fhir.model.type.code.PaymentNoticeStatus;
import com.ibm.fhir.model.type.code.PaymentReconciliationStatus;
import com.ibm.fhir.model.type.code.ProcedureStatus;
import com.ibm.fhir.model.type.code.PropertyRepresentation;
import com.ibm.fhir.model.type.code.PropertyType;
import com.ibm.fhir.model.type.code.ProvenanceEntityRole;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.QualityType;
import com.ibm.fhir.model.type.code.QuantityComparator;
import com.ibm.fhir.model.type.code.QuestionnaireItemOperator;
import com.ibm.fhir.model.type.code.QuestionnaireItemType;
import com.ibm.fhir.model.type.code.QuestionnaireResponseStatus;
import com.ibm.fhir.model.type.code.ReferenceHandlingPolicy;
import com.ibm.fhir.model.type.code.ReferenceVersionRules;
import com.ibm.fhir.model.type.code.ReferredDocumentStatus;
import com.ibm.fhir.model.type.code.RelatedArtifactType;
import com.ibm.fhir.model.type.code.RemittanceOutcome;
import com.ibm.fhir.model.type.code.RepositoryType;
import com.ibm.fhir.model.type.code.RequestIntent;
import com.ibm.fhir.model.type.code.RequestPriority;
import com.ibm.fhir.model.type.code.RequestStatus;
import com.ibm.fhir.model.type.code.ResearchElementType;
import com.ibm.fhir.model.type.code.ResearchStudyStatus;
import com.ibm.fhir.model.type.code.ResearchSubjectStatus;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.ResourceVersionPolicy;
import com.ibm.fhir.model.type.code.ResponseType;
import com.ibm.fhir.model.type.code.RestfulCapabilityMode;
import com.ibm.fhir.model.type.code.RiskAssessmentStatus;
import com.ibm.fhir.model.type.code.SPDXLicense;
import com.ibm.fhir.model.type.code.SearchComparator;
import com.ibm.fhir.model.type.code.SearchEntryMode;
import com.ibm.fhir.model.type.code.SearchModifierCode;
import com.ibm.fhir.model.type.code.SearchParamType;
import com.ibm.fhir.model.type.code.SectionMode;
import com.ibm.fhir.model.type.code.SequenceType;
import com.ibm.fhir.model.type.code.ServiceRequestIntent;
import com.ibm.fhir.model.type.code.ServiceRequestPriority;
import com.ibm.fhir.model.type.code.ServiceRequestStatus;
import com.ibm.fhir.model.type.code.SlicingRules;
import com.ibm.fhir.model.type.code.SlotStatus;
import com.ibm.fhir.model.type.code.SortDirection;
import com.ibm.fhir.model.type.code.SpecimenContainedPreference;
import com.ibm.fhir.model.type.code.SpecimenStatus;
import com.ibm.fhir.model.type.code.Status;
import com.ibm.fhir.model.type.code.StrandType;
import com.ibm.fhir.model.type.code.StructureDefinitionKind;
import com.ibm.fhir.model.type.code.StructureMapContextType;
import com.ibm.fhir.model.type.code.StructureMapGroupTypeMode;
import com.ibm.fhir.model.type.code.StructureMapInputMode;
import com.ibm.fhir.model.type.code.StructureMapModelMode;
import com.ibm.fhir.model.type.code.StructureMapSourceListMode;
import com.ibm.fhir.model.type.code.StructureMapTargetListMode;
import com.ibm.fhir.model.type.code.StructureMapTransform;
import com.ibm.fhir.model.type.code.SubscriptionChannelType;
import com.ibm.fhir.model.type.code.SubscriptionStatus;
import com.ibm.fhir.model.type.code.SupplyDeliveryStatus;
import com.ibm.fhir.model.type.code.SupplyRequestStatus;
import com.ibm.fhir.model.type.code.SystemRestfulInteraction;
import com.ibm.fhir.model.type.code.TaskIntent;
import com.ibm.fhir.model.type.code.TaskPriority;
import com.ibm.fhir.model.type.code.TaskStatus;
import com.ibm.fhir.model.type.code.TestReportActionResult;
import com.ibm.fhir.model.type.code.TestReportParticipantType;
import com.ibm.fhir.model.type.code.TestReportResult;
import com.ibm.fhir.model.type.code.TestReportStatus;
import com.ibm.fhir.model.type.code.TestScriptRequestMethodCode;
import com.ibm.fhir.model.type.code.TriggerType;
import com.ibm.fhir.model.type.code.TypeDerivationRule;
import com.ibm.fhir.model.type.code.TypeRestfulInteraction;
import com.ibm.fhir.model.type.code.UDIEntryType;
import com.ibm.fhir.model.type.code.UnitsOfTime;
import com.ibm.fhir.model.type.code.Use;
import com.ibm.fhir.model.type.code.VariableType;
import com.ibm.fhir.model.type.code.VisionBase;
import com.ibm.fhir.model.type.code.VisionEyes;
import com.ibm.fhir.model.type.code.VisionStatus;
import com.ibm.fhir.model.type.code.XPathUsageType;
import com.ibm.fhir.model.util.XMLSupport;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import java.util.StringJoiner;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class FHIRXMLParser
extends FHIRAbstractParser {
    public static boolean DEBUG = false;
    private final Stack<String> stack = new Stack();

    FHIRXMLParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Resource> T parse(InputStream in) throws FHIRParserException {
        try (XMLSupport.StreamReaderDelegate delegate = XMLSupport.createStreamReaderDelegate(in);){
            this.reset();
            while (delegate.hasNext()) {
                int eventType = delegate.next();
                switch (eventType) {
                    case 1: {
                        XMLSupport.requireNamespace(delegate, "http://hl7.org/fhir");
                        Resource resource = this.parseResource(this.getResourceType(delegate), delegate, -1);
                        return (T)resource;
                    }
                }
            }
            throw new XMLStreamException("Unexpected end of stream");
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Resource> T parse(Reader reader) throws FHIRParserException {
        try (XMLSupport.StreamReaderDelegate delegate = XMLSupport.createStreamReaderDelegate(reader);){
            this.reset();
            while (delegate.hasNext()) {
                int eventType = delegate.next();
                switch (eventType) {
                    case 1: {
                        XMLSupport.requireNamespace(delegate, "http://hl7.org/fhir");
                        Resource resource = this.parseResource(this.getResourceType(delegate), delegate, -1);
                        return (T)resource;
                    }
                }
            }
            throw new XMLStreamException("Unexpected end of stream");
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    private void reset() {
        this.stack.clear();
    }

    private Resource parseResource(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        String resourceType;
        if (XMLSupport.isResourceContainer(elementName)) {
            reader.nextTag();
        }
        switch (resourceType = this.getResourceType(reader)) {
            case "Account": {
                return this.parseAccount(elementName, reader, elementIndex);
            }
            case "ActivityDefinition": {
                return this.parseActivityDefinition(elementName, reader, elementIndex);
            }
            case "AdverseEvent": {
                return this.parseAdverseEvent(elementName, reader, elementIndex);
            }
            case "AllergyIntolerance": {
                return this.parseAllergyIntolerance(elementName, reader, elementIndex);
            }
            case "Appointment": {
                return this.parseAppointment(elementName, reader, elementIndex);
            }
            case "AppointmentResponse": {
                return this.parseAppointmentResponse(elementName, reader, elementIndex);
            }
            case "AuditEvent": {
                return this.parseAuditEvent(elementName, reader, elementIndex);
            }
            case "Basic": {
                return this.parseBasic(elementName, reader, elementIndex);
            }
            case "Binary": {
                return this.parseBinary(elementName, reader, elementIndex);
            }
            case "BiologicallyDerivedProduct": {
                return this.parseBiologicallyDerivedProduct(elementName, reader, elementIndex);
            }
            case "BodyStructure": {
                return this.parseBodyStructure(elementName, reader, elementIndex);
            }
            case "Bundle": {
                return this.parseBundle(elementName, reader, elementIndex);
            }
            case "CapabilityStatement": {
                return this.parseCapabilityStatement(elementName, reader, elementIndex);
            }
            case "CarePlan": {
                return this.parseCarePlan(elementName, reader, elementIndex);
            }
            case "CareTeam": {
                return this.parseCareTeam(elementName, reader, elementIndex);
            }
            case "CatalogEntry": {
                return this.parseCatalogEntry(elementName, reader, elementIndex);
            }
            case "ChargeItem": {
                return this.parseChargeItem(elementName, reader, elementIndex);
            }
            case "ChargeItemDefinition": {
                return this.parseChargeItemDefinition(elementName, reader, elementIndex);
            }
            case "Claim": {
                return this.parseClaim(elementName, reader, elementIndex);
            }
            case "ClaimResponse": {
                return this.parseClaimResponse(elementName, reader, elementIndex);
            }
            case "ClinicalImpression": {
                return this.parseClinicalImpression(elementName, reader, elementIndex);
            }
            case "CodeSystem": {
                return this.parseCodeSystem(elementName, reader, elementIndex);
            }
            case "Communication": {
                return this.parseCommunication(elementName, reader, elementIndex);
            }
            case "CommunicationRequest": {
                return this.parseCommunicationRequest(elementName, reader, elementIndex);
            }
            case "CompartmentDefinition": {
                return this.parseCompartmentDefinition(elementName, reader, elementIndex);
            }
            case "Composition": {
                return this.parseComposition(elementName, reader, elementIndex);
            }
            case "ConceptMap": {
                return this.parseConceptMap(elementName, reader, elementIndex);
            }
            case "Condition": {
                return this.parseCondition(elementName, reader, elementIndex);
            }
            case "Consent": {
                return this.parseConsent(elementName, reader, elementIndex);
            }
            case "Contract": {
                return this.parseContract(elementName, reader, elementIndex);
            }
            case "Coverage": {
                return this.parseCoverage(elementName, reader, elementIndex);
            }
            case "CoverageEligibilityRequest": {
                return this.parseCoverageEligibilityRequest(elementName, reader, elementIndex);
            }
            case "CoverageEligibilityResponse": {
                return this.parseCoverageEligibilityResponse(elementName, reader, elementIndex);
            }
            case "DetectedIssue": {
                return this.parseDetectedIssue(elementName, reader, elementIndex);
            }
            case "Device": {
                return this.parseDevice(elementName, reader, elementIndex);
            }
            case "DeviceDefinition": {
                return this.parseDeviceDefinition(elementName, reader, elementIndex);
            }
            case "DeviceMetric": {
                return this.parseDeviceMetric(elementName, reader, elementIndex);
            }
            case "DeviceRequest": {
                return this.parseDeviceRequest(elementName, reader, elementIndex);
            }
            case "DeviceUseStatement": {
                return this.parseDeviceUseStatement(elementName, reader, elementIndex);
            }
            case "DiagnosticReport": {
                return this.parseDiagnosticReport(elementName, reader, elementIndex);
            }
            case "DocumentManifest": {
                return this.parseDocumentManifest(elementName, reader, elementIndex);
            }
            case "DocumentReference": {
                return this.parseDocumentReference(elementName, reader, elementIndex);
            }
            case "EffectEvidenceSynthesis": {
                return this.parseEffectEvidenceSynthesis(elementName, reader, elementIndex);
            }
            case "Encounter": {
                return this.parseEncounter(elementName, reader, elementIndex);
            }
            case "Endpoint": {
                return this.parseEndpoint(elementName, reader, elementIndex);
            }
            case "EnrollmentRequest": {
                return this.parseEnrollmentRequest(elementName, reader, elementIndex);
            }
            case "EnrollmentResponse": {
                return this.parseEnrollmentResponse(elementName, reader, elementIndex);
            }
            case "EpisodeOfCare": {
                return this.parseEpisodeOfCare(elementName, reader, elementIndex);
            }
            case "EventDefinition": {
                return this.parseEventDefinition(elementName, reader, elementIndex);
            }
            case "Evidence": {
                return this.parseEvidence(elementName, reader, elementIndex);
            }
            case "EvidenceVariable": {
                return this.parseEvidenceVariable(elementName, reader, elementIndex);
            }
            case "ExampleScenario": {
                return this.parseExampleScenario(elementName, reader, elementIndex);
            }
            case "ExplanationOfBenefit": {
                return this.parseExplanationOfBenefit(elementName, reader, elementIndex);
            }
            case "FamilyMemberHistory": {
                return this.parseFamilyMemberHistory(elementName, reader, elementIndex);
            }
            case "Flag": {
                return this.parseFlag(elementName, reader, elementIndex);
            }
            case "Goal": {
                return this.parseGoal(elementName, reader, elementIndex);
            }
            case "GraphDefinition": {
                return this.parseGraphDefinition(elementName, reader, elementIndex);
            }
            case "Group": {
                return this.parseGroup(elementName, reader, elementIndex);
            }
            case "GuidanceResponse": {
                return this.parseGuidanceResponse(elementName, reader, elementIndex);
            }
            case "HealthcareService": {
                return this.parseHealthcareService(elementName, reader, elementIndex);
            }
            case "ImagingStudy": {
                return this.parseImagingStudy(elementName, reader, elementIndex);
            }
            case "Immunization": {
                return this.parseImmunization(elementName, reader, elementIndex);
            }
            case "ImmunizationEvaluation": {
                return this.parseImmunizationEvaluation(elementName, reader, elementIndex);
            }
            case "ImmunizationRecommendation": {
                return this.parseImmunizationRecommendation(elementName, reader, elementIndex);
            }
            case "ImplementationGuide": {
                return this.parseImplementationGuide(elementName, reader, elementIndex);
            }
            case "InsurancePlan": {
                return this.parseInsurancePlan(elementName, reader, elementIndex);
            }
            case "Invoice": {
                return this.parseInvoice(elementName, reader, elementIndex);
            }
            case "Library": {
                return this.parseLibrary(elementName, reader, elementIndex);
            }
            case "Linkage": {
                return this.parseLinkage(elementName, reader, elementIndex);
            }
            case "List": {
                return this.parseList(elementName, reader, elementIndex);
            }
            case "Location": {
                return this.parseLocation(elementName, reader, elementIndex);
            }
            case "Measure": {
                return this.parseMeasure(elementName, reader, elementIndex);
            }
            case "MeasureReport": {
                return this.parseMeasureReport(elementName, reader, elementIndex);
            }
            case "Media": {
                return this.parseMedia(elementName, reader, elementIndex);
            }
            case "Medication": {
                return this.parseMedication(elementName, reader, elementIndex);
            }
            case "MedicationAdministration": {
                return this.parseMedicationAdministration(elementName, reader, elementIndex);
            }
            case "MedicationDispense": {
                return this.parseMedicationDispense(elementName, reader, elementIndex);
            }
            case "MedicationKnowledge": {
                return this.parseMedicationKnowledge(elementName, reader, elementIndex);
            }
            case "MedicationRequest": {
                return this.parseMedicationRequest(elementName, reader, elementIndex);
            }
            case "MedicationStatement": {
                return this.parseMedicationStatement(elementName, reader, elementIndex);
            }
            case "MedicinalProduct": {
                return this.parseMedicinalProduct(elementName, reader, elementIndex);
            }
            case "MedicinalProductAuthorization": {
                return this.parseMedicinalProductAuthorization(elementName, reader, elementIndex);
            }
            case "MedicinalProductContraindication": {
                return this.parseMedicinalProductContraindication(elementName, reader, elementIndex);
            }
            case "MedicinalProductIndication": {
                return this.parseMedicinalProductIndication(elementName, reader, elementIndex);
            }
            case "MedicinalProductIngredient": {
                return this.parseMedicinalProductIngredient(elementName, reader, elementIndex);
            }
            case "MedicinalProductInteraction": {
                return this.parseMedicinalProductInteraction(elementName, reader, elementIndex);
            }
            case "MedicinalProductManufactured": {
                return this.parseMedicinalProductManufactured(elementName, reader, elementIndex);
            }
            case "MedicinalProductPackaged": {
                return this.parseMedicinalProductPackaged(elementName, reader, elementIndex);
            }
            case "MedicinalProductPharmaceutical": {
                return this.parseMedicinalProductPharmaceutical(elementName, reader, elementIndex);
            }
            case "MedicinalProductUndesirableEffect": {
                return this.parseMedicinalProductUndesirableEffect(elementName, reader, elementIndex);
            }
            case "MessageDefinition": {
                return this.parseMessageDefinition(elementName, reader, elementIndex);
            }
            case "MessageHeader": {
                return this.parseMessageHeader(elementName, reader, elementIndex);
            }
            case "MolecularSequence": {
                return this.parseMolecularSequence(elementName, reader, elementIndex);
            }
            case "NamingSystem": {
                return this.parseNamingSystem(elementName, reader, elementIndex);
            }
            case "NutritionOrder": {
                return this.parseNutritionOrder(elementName, reader, elementIndex);
            }
            case "Observation": {
                return this.parseObservation(elementName, reader, elementIndex);
            }
            case "ObservationDefinition": {
                return this.parseObservationDefinition(elementName, reader, elementIndex);
            }
            case "OperationDefinition": {
                return this.parseOperationDefinition(elementName, reader, elementIndex);
            }
            case "OperationOutcome": {
                return this.parseOperationOutcome(elementName, reader, elementIndex);
            }
            case "Organization": {
                return this.parseOrganization(elementName, reader, elementIndex);
            }
            case "OrganizationAffiliation": {
                return this.parseOrganizationAffiliation(elementName, reader, elementIndex);
            }
            case "Parameters": {
                return this.parseParameters(elementName, reader, elementIndex);
            }
            case "Patient": {
                return this.parsePatient(elementName, reader, elementIndex);
            }
            case "PaymentNotice": {
                return this.parsePaymentNotice(elementName, reader, elementIndex);
            }
            case "PaymentReconciliation": {
                return this.parsePaymentReconciliation(elementName, reader, elementIndex);
            }
            case "Person": {
                return this.parsePerson(elementName, reader, elementIndex);
            }
            case "PlanDefinition": {
                return this.parsePlanDefinition(elementName, reader, elementIndex);
            }
            case "Practitioner": {
                return this.parsePractitioner(elementName, reader, elementIndex);
            }
            case "PractitionerRole": {
                return this.parsePractitionerRole(elementName, reader, elementIndex);
            }
            case "Procedure": {
                return this.parseProcedure(elementName, reader, elementIndex);
            }
            case "Provenance": {
                return this.parseProvenance(elementName, reader, elementIndex);
            }
            case "Questionnaire": {
                return this.parseQuestionnaire(elementName, reader, elementIndex);
            }
            case "QuestionnaireResponse": {
                return this.parseQuestionnaireResponse(elementName, reader, elementIndex);
            }
            case "RelatedPerson": {
                return this.parseRelatedPerson(elementName, reader, elementIndex);
            }
            case "RequestGroup": {
                return this.parseRequestGroup(elementName, reader, elementIndex);
            }
            case "ResearchDefinition": {
                return this.parseResearchDefinition(elementName, reader, elementIndex);
            }
            case "ResearchElementDefinition": {
                return this.parseResearchElementDefinition(elementName, reader, elementIndex);
            }
            case "ResearchStudy": {
                return this.parseResearchStudy(elementName, reader, elementIndex);
            }
            case "ResearchSubject": {
                return this.parseResearchSubject(elementName, reader, elementIndex);
            }
            case "RiskAssessment": {
                return this.parseRiskAssessment(elementName, reader, elementIndex);
            }
            case "RiskEvidenceSynthesis": {
                return this.parseRiskEvidenceSynthesis(elementName, reader, elementIndex);
            }
            case "Schedule": {
                return this.parseSchedule(elementName, reader, elementIndex);
            }
            case "SearchParameter": {
                return this.parseSearchParameter(elementName, reader, elementIndex);
            }
            case "ServiceRequest": {
                return this.parseServiceRequest(elementName, reader, elementIndex);
            }
            case "Slot": {
                return this.parseSlot(elementName, reader, elementIndex);
            }
            case "Specimen": {
                return this.parseSpecimen(elementName, reader, elementIndex);
            }
            case "SpecimenDefinition": {
                return this.parseSpecimenDefinition(elementName, reader, elementIndex);
            }
            case "StructureDefinition": {
                return this.parseStructureDefinition(elementName, reader, elementIndex);
            }
            case "StructureMap": {
                return this.parseStructureMap(elementName, reader, elementIndex);
            }
            case "Subscription": {
                return this.parseSubscription(elementName, reader, elementIndex);
            }
            case "Substance": {
                return this.parseSubstance(elementName, reader, elementIndex);
            }
            case "SubstanceNucleicAcid": {
                return this.parseSubstanceNucleicAcid(elementName, reader, elementIndex);
            }
            case "SubstancePolymer": {
                return this.parseSubstancePolymer(elementName, reader, elementIndex);
            }
            case "SubstanceProtein": {
                return this.parseSubstanceProtein(elementName, reader, elementIndex);
            }
            case "SubstanceReferenceInformation": {
                return this.parseSubstanceReferenceInformation(elementName, reader, elementIndex);
            }
            case "SubstanceSourceMaterial": {
                return this.parseSubstanceSourceMaterial(elementName, reader, elementIndex);
            }
            case "SubstanceSpecification": {
                return this.parseSubstanceSpecification(elementName, reader, elementIndex);
            }
            case "SupplyDelivery": {
                return this.parseSupplyDelivery(elementName, reader, elementIndex);
            }
            case "SupplyRequest": {
                return this.parseSupplyRequest(elementName, reader, elementIndex);
            }
            case "Task": {
                return this.parseTask(elementName, reader, elementIndex);
            }
            case "TerminologyCapabilities": {
                return this.parseTerminologyCapabilities(elementName, reader, elementIndex);
            }
            case "TestReport": {
                return this.parseTestReport(elementName, reader, elementIndex);
            }
            case "TestScript": {
                return this.parseTestScript(elementName, reader, elementIndex);
            }
            case "ValueSet": {
                return this.parseValueSet(elementName, reader, elementIndex);
            }
            case "VerificationResult": {
                return this.parseVerificationResult(elementName, reader, elementIndex);
            }
            case "VisionPrescription": {
                return this.parseVisionPrescription(elementName, reader, elementIndex);
            }
        }
        return null;
    }

    private Account parseAccount(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Account.Builder builder = Account.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int subjectElementIndex = 0;
        int coverageElementIndex = 0;
        int guarantorElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((AccountStatus)this.parseString(AccountStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 10, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 11, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 12, position, true);
                            builder.subject(this.parseReference("subject", reader, subjectElementIndex++));
                            break block0;
                        }
                        case "servicePeriod": {
                            position = XMLSupport.checkElementOrder("servicePeriod", 13, position, false);
                            builder.servicePeriod(this.parsePeriod("servicePeriod", reader, -1));
                            break block0;
                        }
                        case "coverage": {
                            position = XMLSupport.checkElementOrder("coverage", 14, position, true);
                            builder.coverage(this.parseAccountCoverage("coverage", reader, coverageElementIndex++));
                            break block0;
                        }
                        case "owner": {
                            position = XMLSupport.checkElementOrder("owner", 15, position, false);
                            builder.owner(this.parseReference("owner", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 16, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "guarantor": {
                            position = XMLSupport.checkElementOrder("guarantor", 17, position, true);
                            builder.guarantor(this.parseAccountGuarantor("guarantor", reader, guarantorElementIndex++));
                            break block0;
                        }
                        case "partOf": {
                            position = XMLSupport.checkElementOrder("partOf", 18, position, false);
                            builder.partOf(this.parseReference("partOf", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Account.Coverage parseAccountCoverage(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Account.Coverage.Builder builder = Account.Coverage.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "coverage": {
                            position = XMLSupport.checkElementOrder("coverage", 2, position, false);
                            builder.coverage(this.parseReference("coverage", reader, -1));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 3, position, false);
                            builder.priority((PositiveInt)this.parseInteger(PositiveInt.builder(), "priority", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Account.Guarantor parseAccountGuarantor(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Account.Guarantor.Builder builder = Account.Guarantor.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "party": {
                            position = XMLSupport.checkElementOrder("party", 2, position, false);
                            builder.party(this.parseReference("party", reader, -1));
                            break block0;
                        }
                        case "onHold": {
                            position = XMLSupport.checkElementOrder("onHold", 3, position, false);
                            builder.onHold(this.parseBoolean("onHold", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 4, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ActivityDefinition parseActivityDefinition(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ActivityDefinition.Builder builder = ActivityDefinition.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int contactElementIndex = 0;
        int useContextElementIndex = 0;
        int jurisdictionElementIndex = 0;
        int topicElementIndex = 0;
        int authorElementIndex = 0;
        int editorElementIndex = 0;
        int reviewerElementIndex = 0;
        int endorserElementIndex = 0;
        int relatedArtifactElementIndex = 0;
        int libraryElementIndex = 0;
        int participantElementIndex = 0;
        int dosageElementIndex = 0;
        int bodySiteElementIndex = 0;
        int specimenRequirementElementIndex = 0;
        int observationRequirementElementIndex = 0;
        int observationResultRequirementElementIndex = 0;
        int dynamicValueElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 8, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 9, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 10, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 11, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 12, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "subtitle": {
                            position = XMLSupport.checkElementOrder("subtitle", 13, position, false);
                            builder.subtitle(this.parseString("subtitle", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 14, position, false);
                            builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "experimental": {
                            position = XMLSupport.checkElementOrder("experimental", 15, position, false);
                            builder.experimental(this.parseBoolean("experimental", reader, -1));
                            break block0;
                        }
                        case "subjectCodeableConcept": {
                            position = XMLSupport.checkElementOrder("subject[x]", 16, position, false);
                            builder.subject(this.parseCodeableConcept("subjectCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "subjectReference": {
                            position = XMLSupport.checkElementOrder("subject[x]", 16, position, false);
                            builder.subject(this.parseReference("subjectReference", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 17, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "publisher": {
                            position = XMLSupport.checkElementOrder("publisher", 18, position, false);
                            builder.publisher(this.parseString("publisher", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 19, position, true);
                            builder.contact(this.parseContactDetail("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 20, position, false);
                            builder.description((Markdown)this.parseString(Markdown.builder(), "description", reader, -1));
                            break block0;
                        }
                        case "useContext": {
                            position = XMLSupport.checkElementOrder("useContext", 21, position, true);
                            builder.useContext(this.parseUsageContext("useContext", reader, useContextElementIndex++));
                            break block0;
                        }
                        case "jurisdiction": {
                            position = XMLSupport.checkElementOrder("jurisdiction", 22, position, true);
                            builder.jurisdiction(this.parseCodeableConcept("jurisdiction", reader, jurisdictionElementIndex++));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 23, position, false);
                            builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", reader, -1));
                            break block0;
                        }
                        case "usage": {
                            position = XMLSupport.checkElementOrder("usage", 24, position, false);
                            builder.usage(this.parseString("usage", reader, -1));
                            break block0;
                        }
                        case "copyright": {
                            position = XMLSupport.checkElementOrder("copyright", 25, position, false);
                            builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", reader, -1));
                            break block0;
                        }
                        case "approvalDate": {
                            position = XMLSupport.checkElementOrder("approvalDate", 26, position, false);
                            builder.approvalDate(this.parseDate("approvalDate", reader, -1));
                            break block0;
                        }
                        case "lastReviewDate": {
                            position = XMLSupport.checkElementOrder("lastReviewDate", 27, position, false);
                            builder.lastReviewDate(this.parseDate("lastReviewDate", reader, -1));
                            break block0;
                        }
                        case "effectivePeriod": {
                            position = XMLSupport.checkElementOrder("effectivePeriod", 28, position, false);
                            builder.effectivePeriod(this.parsePeriod("effectivePeriod", reader, -1));
                            break block0;
                        }
                        case "topic": {
                            position = XMLSupport.checkElementOrder("topic", 29, position, true);
                            builder.topic(this.parseCodeableConcept("topic", reader, topicElementIndex++));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 30, position, true);
                            builder.author(this.parseContactDetail("author", reader, authorElementIndex++));
                            break block0;
                        }
                        case "editor": {
                            position = XMLSupport.checkElementOrder("editor", 31, position, true);
                            builder.editor(this.parseContactDetail("editor", reader, editorElementIndex++));
                            break block0;
                        }
                        case "reviewer": {
                            position = XMLSupport.checkElementOrder("reviewer", 32, position, true);
                            builder.reviewer(this.parseContactDetail("reviewer", reader, reviewerElementIndex++));
                            break block0;
                        }
                        case "endorser": {
                            position = XMLSupport.checkElementOrder("endorser", 33, position, true);
                            builder.endorser(this.parseContactDetail("endorser", reader, endorserElementIndex++));
                            break block0;
                        }
                        case "relatedArtifact": {
                            position = XMLSupport.checkElementOrder("relatedArtifact", 34, position, true);
                            builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", reader, relatedArtifactElementIndex++));
                            break block0;
                        }
                        case "library": {
                            position = XMLSupport.checkElementOrder("library", 35, position, true);
                            builder.library((Canonical)this.parseUri(Canonical.builder(), "library", reader, libraryElementIndex++));
                            break block0;
                        }
                        case "kind": {
                            position = XMLSupport.checkElementOrder("kind", 36, position, false);
                            builder.kind((ActivityDefinitionKind)this.parseString(ActivityDefinitionKind.builder(), "kind", reader, -1));
                            break block0;
                        }
                        case "profile": {
                            position = XMLSupport.checkElementOrder("profile", 37, position, false);
                            builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 38, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "intent": {
                            position = XMLSupport.checkElementOrder("intent", 39, position, false);
                            builder.intent((RequestIntent)this.parseString(RequestIntent.builder(), "intent", reader, -1));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 40, position, false);
                            builder.priority((RequestPriority)this.parseString(RequestPriority.builder(), "priority", reader, -1));
                            break block0;
                        }
                        case "doNotPerform": {
                            position = XMLSupport.checkElementOrder("doNotPerform", 41, position, false);
                            builder.doNotPerform(this.parseBoolean("doNotPerform", reader, -1));
                            break block0;
                        }
                        case "timingTiming": {
                            position = XMLSupport.checkElementOrder("timing[x]", 42, position, false);
                            builder.timing(this.parseTiming("timingTiming", reader, -1));
                            break block0;
                        }
                        case "timingDateTime": {
                            position = XMLSupport.checkElementOrder("timing[x]", 42, position, false);
                            builder.timing(this.parseDateTime("timingDateTime", reader, -1));
                            break block0;
                        }
                        case "timingAge": {
                            position = XMLSupport.checkElementOrder("timing[x]", 42, position, false);
                            builder.timing((Age)this.parseQuantity(Age.builder(), "timingAge", reader, -1));
                            break block0;
                        }
                        case "timingPeriod": {
                            position = XMLSupport.checkElementOrder("timing[x]", 42, position, false);
                            builder.timing(this.parsePeriod("timingPeriod", reader, -1));
                            break block0;
                        }
                        case "timingRange": {
                            position = XMLSupport.checkElementOrder("timing[x]", 42, position, false);
                            builder.timing(this.parseRange("timingRange", reader, -1));
                            break block0;
                        }
                        case "timingDuration": {
                            position = XMLSupport.checkElementOrder("timing[x]", 42, position, false);
                            builder.timing((Duration)this.parseQuantity(Duration.builder(), "timingDuration", reader, -1));
                            break block0;
                        }
                        case "location": {
                            position = XMLSupport.checkElementOrder("location", 43, position, false);
                            builder.location(this.parseReference("location", reader, -1));
                            break block0;
                        }
                        case "participant": {
                            position = XMLSupport.checkElementOrder("participant", 44, position, true);
                            builder.participant(this.parseActivityDefinitionParticipant("participant", reader, participantElementIndex++));
                            break block0;
                        }
                        case "productReference": {
                            position = XMLSupport.checkElementOrder("product[x]", 45, position, false);
                            builder.product(this.parseReference("productReference", reader, -1));
                            break block0;
                        }
                        case "productCodeableConcept": {
                            position = XMLSupport.checkElementOrder("product[x]", 45, position, false);
                            builder.product(this.parseCodeableConcept("productCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 46, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "dosage": {
                            position = XMLSupport.checkElementOrder("dosage", 47, position, true);
                            builder.dosage(this.parseDosage("dosage", reader, dosageElementIndex++));
                            break block0;
                        }
                        case "bodySite": {
                            position = XMLSupport.checkElementOrder("bodySite", 48, position, true);
                            builder.bodySite(this.parseCodeableConcept("bodySite", reader, bodySiteElementIndex++));
                            break block0;
                        }
                        case "specimenRequirement": {
                            position = XMLSupport.checkElementOrder("specimenRequirement", 49, position, true);
                            builder.specimenRequirement(this.parseReference("specimenRequirement", reader, specimenRequirementElementIndex++));
                            break block0;
                        }
                        case "observationRequirement": {
                            position = XMLSupport.checkElementOrder("observationRequirement", 50, position, true);
                            builder.observationRequirement(this.parseReference("observationRequirement", reader, observationRequirementElementIndex++));
                            break block0;
                        }
                        case "observationResultRequirement": {
                            position = XMLSupport.checkElementOrder("observationResultRequirement", 51, position, true);
                            builder.observationResultRequirement(this.parseReference("observationResultRequirement", reader, observationResultRequirementElementIndex++));
                            break block0;
                        }
                        case "transform": {
                            position = XMLSupport.checkElementOrder("transform", 52, position, false);
                            builder.transform((Canonical)this.parseUri(Canonical.builder(), "transform", reader, -1));
                            break block0;
                        }
                        case "dynamicValue": {
                            position = XMLSupport.checkElementOrder("dynamicValue", 53, position, true);
                            builder.dynamicValue(this.parseActivityDefinitionDynamicValue("dynamicValue", reader, dynamicValueElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ActivityDefinition.DynamicValue parseActivityDefinitionDynamicValue(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ActivityDefinition.DynamicValue.Builder builder = ActivityDefinition.DynamicValue.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "path": {
                            position = XMLSupport.checkElementOrder("path", 2, position, false);
                            builder.path(this.parseString("path", reader, -1));
                            break block0;
                        }
                        case "expression": {
                            position = XMLSupport.checkElementOrder("expression", 3, position, false);
                            builder.expression(this.parseExpression("expression", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ActivityDefinition.Participant parseActivityDefinitionParticipant(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ActivityDefinition.Participant.Builder builder = ActivityDefinition.Participant.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type((ActivityParticipantType)this.parseString(ActivityParticipantType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 3, position, false);
                            builder.role(this.parseCodeableConcept("role", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Address parseAddress(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Address.Builder builder = Address.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int lineElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "use": {
                            position = XMLSupport.checkElementOrder("use", 1, position, false);
                            builder.use((AddressUse)this.parseString(AddressUse.builder(), "use", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type((AddressType)this.parseString(AddressType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 3, position, false);
                            builder.text(this.parseString("text", reader, -1));
                            break block0;
                        }
                        case "line": {
                            position = XMLSupport.checkElementOrder("line", 4, position, true);
                            builder.line(this.parseString("line", reader, lineElementIndex++));
                            break block0;
                        }
                        case "city": {
                            position = XMLSupport.checkElementOrder("city", 5, position, false);
                            builder.city(this.parseString("city", reader, -1));
                            break block0;
                        }
                        case "district": {
                            position = XMLSupport.checkElementOrder("district", 6, position, false);
                            builder.district(this.parseString("district", reader, -1));
                            break block0;
                        }
                        case "state": {
                            position = XMLSupport.checkElementOrder("state", 7, position, false);
                            builder.state(this.parseString("state", reader, -1));
                            break block0;
                        }
                        case "postalCode": {
                            position = XMLSupport.checkElementOrder("postalCode", 8, position, false);
                            builder.postalCode(this.parseString("postalCode", reader, -1));
                            break block0;
                        }
                        case "country": {
                            position = XMLSupport.checkElementOrder("country", 9, position, false);
                            builder.country(this.parseString("country", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 10, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AdverseEvent parseAdverseEvent(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AdverseEvent.Builder builder = AdverseEvent.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int categoryElementIndex = 0;
        int resultingConditionElementIndex = 0;
        int contributorElementIndex = 0;
        int suspectEntityElementIndex = 0;
        int subjectMedicalHistoryElementIndex = 0;
        int referenceDocumentElementIndex = 0;
        int studyElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                        case "actuality": {
                            position = XMLSupport.checkElementOrder("actuality", 9, position, false);
                            builder.actuality((AdverseEventActuality)this.parseString(AdverseEventActuality.builder(), "actuality", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 10, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "event": {
                            position = XMLSupport.checkElementOrder("event", 11, position, false);
                            builder.event(this.parseCodeableConcept("event", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 12, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 13, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 14, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "detected": {
                            position = XMLSupport.checkElementOrder("detected", 15, position, false);
                            builder.detected(this.parseDateTime("detected", reader, -1));
                            break block0;
                        }
                        case "recordedDate": {
                            position = XMLSupport.checkElementOrder("recordedDate", 16, position, false);
                            builder.recordedDate(this.parseDateTime("recordedDate", reader, -1));
                            break block0;
                        }
                        case "resultingCondition": {
                            position = XMLSupport.checkElementOrder("resultingCondition", 17, position, true);
                            builder.resultingCondition(this.parseReference("resultingCondition", reader, resultingConditionElementIndex++));
                            break block0;
                        }
                        case "location": {
                            position = XMLSupport.checkElementOrder("location", 18, position, false);
                            builder.location(this.parseReference("location", reader, -1));
                            break block0;
                        }
                        case "seriousness": {
                            position = XMLSupport.checkElementOrder("seriousness", 19, position, false);
                            builder.seriousness(this.parseCodeableConcept("seriousness", reader, -1));
                            break block0;
                        }
                        case "severity": {
                            position = XMLSupport.checkElementOrder("severity", 20, position, false);
                            builder.severity(this.parseCodeableConcept("severity", reader, -1));
                            break block0;
                        }
                        case "outcome": {
                            position = XMLSupport.checkElementOrder("outcome", 21, position, false);
                            builder.outcome(this.parseCodeableConcept("outcome", reader, -1));
                            break block0;
                        }
                        case "recorder": {
                            position = XMLSupport.checkElementOrder("recorder", 22, position, false);
                            builder.recorder(this.parseReference("recorder", reader, -1));
                            break block0;
                        }
                        case "contributor": {
                            position = XMLSupport.checkElementOrder("contributor", 23, position, true);
                            builder.contributor(this.parseReference("contributor", reader, contributorElementIndex++));
                            break block0;
                        }
                        case "suspectEntity": {
                            position = XMLSupport.checkElementOrder("suspectEntity", 24, position, true);
                            builder.suspectEntity(this.parseAdverseEventSuspectEntity("suspectEntity", reader, suspectEntityElementIndex++));
                            break block0;
                        }
                        case "subjectMedicalHistory": {
                            position = XMLSupport.checkElementOrder("subjectMedicalHistory", 25, position, true);
                            builder.subjectMedicalHistory(this.parseReference("subjectMedicalHistory", reader, subjectMedicalHistoryElementIndex++));
                            break block0;
                        }
                        case "referenceDocument": {
                            position = XMLSupport.checkElementOrder("referenceDocument", 26, position, true);
                            builder.referenceDocument(this.parseReference("referenceDocument", reader, referenceDocumentElementIndex++));
                            break block0;
                        }
                        case "study": {
                            position = XMLSupport.checkElementOrder("study", 27, position, true);
                            builder.study(this.parseReference("study", reader, studyElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AdverseEvent.SuspectEntity parseAdverseEventSuspectEntity(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AdverseEvent.SuspectEntity.Builder builder = AdverseEvent.SuspectEntity.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int causalityElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "instance": {
                            position = XMLSupport.checkElementOrder("instance", 2, position, false);
                            builder.instance(this.parseReference("instance", reader, -1));
                            break block0;
                        }
                        case "causality": {
                            position = XMLSupport.checkElementOrder("causality", 3, position, true);
                            builder.causality(this.parseAdverseEventSuspectEntityCausality("causality", reader, causalityElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AdverseEvent.SuspectEntity.Causality parseAdverseEventSuspectEntityCausality(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AdverseEvent.SuspectEntity.Causality.Builder builder = AdverseEvent.SuspectEntity.Causality.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "assessment": {
                            position = XMLSupport.checkElementOrder("assessment", 2, position, false);
                            builder.assessment(this.parseCodeableConcept("assessment", reader, -1));
                            break block0;
                        }
                        case "productRelatedness": {
                            position = XMLSupport.checkElementOrder("productRelatedness", 3, position, false);
                            builder.productRelatedness(this.parseString("productRelatedness", reader, -1));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 4, position, false);
                            builder.author(this.parseReference("author", reader, -1));
                            break block0;
                        }
                        case "method": {
                            position = XMLSupport.checkElementOrder("method", 5, position, false);
                            builder.method(this.parseCodeableConcept("method", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AllergyIntolerance parseAllergyIntolerance(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AllergyIntolerance.Builder builder = AllergyIntolerance.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int categoryElementIndex = 0;
        int noteElementIndex = 0;
        int reactionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "clinicalStatus": {
                            position = XMLSupport.checkElementOrder("clinicalStatus", 9, position, false);
                            builder.clinicalStatus(this.parseCodeableConcept("clinicalStatus", reader, -1));
                            break block0;
                        }
                        case "verificationStatus": {
                            position = XMLSupport.checkElementOrder("verificationStatus", 10, position, false);
                            builder.verificationStatus(this.parseCodeableConcept("verificationStatus", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 11, position, false);
                            builder.type((AllergyIntoleranceType)this.parseString(AllergyIntoleranceType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 12, position, true);
                            builder.category((AllergyIntoleranceCategory)this.parseString(AllergyIntoleranceCategory.builder(), "category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "criticality": {
                            position = XMLSupport.checkElementOrder("criticality", 13, position, false);
                            builder.criticality((AllergyIntoleranceCriticality)this.parseString(AllergyIntoleranceCriticality.builder(), "criticality", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 14, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 15, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 16, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "onsetDateTime": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parseDateTime("onsetDateTime", reader, -1));
                            break block0;
                        }
                        case "onsetAge": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset((Age)this.parseQuantity(Age.builder(), "onsetAge", reader, -1));
                            break block0;
                        }
                        case "onsetPeriod": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parsePeriod("onsetPeriod", reader, -1));
                            break block0;
                        }
                        case "onsetRange": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parseRange("onsetRange", reader, -1));
                            break block0;
                        }
                        case "onsetString": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parseString("onsetString", reader, -1));
                            break block0;
                        }
                        case "recordedDate": {
                            position = XMLSupport.checkElementOrder("recordedDate", 18, position, false);
                            builder.recordedDate(this.parseDateTime("recordedDate", reader, -1));
                            break block0;
                        }
                        case "recorder": {
                            position = XMLSupport.checkElementOrder("recorder", 19, position, false);
                            builder.recorder(this.parseReference("recorder", reader, -1));
                            break block0;
                        }
                        case "asserter": {
                            position = XMLSupport.checkElementOrder("asserter", 20, position, false);
                            builder.asserter(this.parseReference("asserter", reader, -1));
                            break block0;
                        }
                        case "lastOccurrence": {
                            position = XMLSupport.checkElementOrder("lastOccurrence", 21, position, false);
                            builder.lastOccurrence(this.parseDateTime("lastOccurrence", reader, -1));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 22, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                        case "reaction": {
                            position = XMLSupport.checkElementOrder("reaction", 23, position, true);
                            builder.reaction(this.parseAllergyIntoleranceReaction("reaction", reader, reactionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AllergyIntolerance.Reaction parseAllergyIntoleranceReaction(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AllergyIntolerance.Reaction.Builder builder = AllergyIntolerance.Reaction.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int manifestationElementIndex = 0;
        int noteElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "substance": {
                            position = XMLSupport.checkElementOrder("substance", 2, position, false);
                            builder.substance(this.parseCodeableConcept("substance", reader, -1));
                            break block0;
                        }
                        case "manifestation": {
                            position = XMLSupport.checkElementOrder("manifestation", 3, position, true);
                            builder.manifestation(this.parseCodeableConcept("manifestation", reader, manifestationElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 4, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "onset": {
                            position = XMLSupport.checkElementOrder("onset", 5, position, false);
                            builder.onset(this.parseDateTime("onset", reader, -1));
                            break block0;
                        }
                        case "severity": {
                            position = XMLSupport.checkElementOrder("severity", 6, position, false);
                            builder.severity((AllergyIntoleranceSeverity)this.parseString(AllergyIntoleranceSeverity.builder(), "severity", reader, -1));
                            break block0;
                        }
                        case "exposureRoute": {
                            position = XMLSupport.checkElementOrder("exposureRoute", 7, position, false);
                            builder.exposureRoute(this.parseCodeableConcept("exposureRoute", reader, -1));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 8, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Annotation parseAnnotation(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Annotation.Builder builder = Annotation.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "authorReference": {
                            position = XMLSupport.checkElementOrder("author[x]", 1, position, false);
                            builder.author(this.parseReference("authorReference", reader, -1));
                            break block0;
                        }
                        case "authorString": {
                            position = XMLSupport.checkElementOrder("author[x]", 1, position, false);
                            builder.author(this.parseString("authorString", reader, -1));
                            break block0;
                        }
                        case "time": {
                            position = XMLSupport.checkElementOrder("time", 2, position, false);
                            builder.time(this.parseDateTime("time", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 3, position, false);
                            builder.text((Markdown)this.parseString(Markdown.builder(), "text", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Appointment parseAppointment(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Appointment.Builder builder = Appointment.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int serviceCategoryElementIndex = 0;
        int serviceTypeElementIndex = 0;
        int specialtyElementIndex = 0;
        int reasonCodeElementIndex = 0;
        int reasonReferenceElementIndex = 0;
        int supportingInformationElementIndex = 0;
        int slotElementIndex = 0;
        int basedOnElementIndex = 0;
        int participantElementIndex = 0;
        int requestedPeriodElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((AppointmentStatus)this.parseString(AppointmentStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "cancelationReason": {
                            position = XMLSupport.checkElementOrder("cancelationReason", 10, position, false);
                            builder.cancelationReason(this.parseCodeableConcept("cancelationReason", reader, -1));
                            break block0;
                        }
                        case "serviceCategory": {
                            position = XMLSupport.checkElementOrder("serviceCategory", 11, position, true);
                            builder.serviceCategory(this.parseCodeableConcept("serviceCategory", reader, serviceCategoryElementIndex++));
                            break block0;
                        }
                        case "serviceType": {
                            position = XMLSupport.checkElementOrder("serviceType", 12, position, true);
                            builder.serviceType(this.parseCodeableConcept("serviceType", reader, serviceTypeElementIndex++));
                            break block0;
                        }
                        case "specialty": {
                            position = XMLSupport.checkElementOrder("specialty", 13, position, true);
                            builder.specialty(this.parseCodeableConcept("specialty", reader, specialtyElementIndex++));
                            break block0;
                        }
                        case "appointmentType": {
                            position = XMLSupport.checkElementOrder("appointmentType", 14, position, false);
                            builder.appointmentType(this.parseCodeableConcept("appointmentType", reader, -1));
                            break block0;
                        }
                        case "reasonCode": {
                            position = XMLSupport.checkElementOrder("reasonCode", 15, position, true);
                            builder.reasonCode(this.parseCodeableConcept("reasonCode", reader, reasonCodeElementIndex++));
                            break block0;
                        }
                        case "reasonReference": {
                            position = XMLSupport.checkElementOrder("reasonReference", 16, position, true);
                            builder.reasonReference(this.parseReference("reasonReference", reader, reasonReferenceElementIndex++));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 17, position, false);
                            builder.priority((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "priority", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 18, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "supportingInformation": {
                            position = XMLSupport.checkElementOrder("supportingInformation", 19, position, true);
                            builder.supportingInformation(this.parseReference("supportingInformation", reader, supportingInformationElementIndex++));
                            break block0;
                        }
                        case "start": {
                            position = XMLSupport.checkElementOrder("start", 20, position, false);
                            builder.start(this.parseInstant("start", reader, -1));
                            break block0;
                        }
                        case "end": {
                            position = XMLSupport.checkElementOrder("end", 21, position, false);
                            builder.end(this.parseInstant("end", reader, -1));
                            break block0;
                        }
                        case "minutesDuration": {
                            position = XMLSupport.checkElementOrder("minutesDuration", 22, position, false);
                            builder.minutesDuration((PositiveInt)this.parseInteger(PositiveInt.builder(), "minutesDuration", reader, -1));
                            break block0;
                        }
                        case "slot": {
                            position = XMLSupport.checkElementOrder("slot", 23, position, true);
                            builder.slot(this.parseReference("slot", reader, slotElementIndex++));
                            break block0;
                        }
                        case "created": {
                            position = XMLSupport.checkElementOrder("created", 24, position, false);
                            builder.created(this.parseDateTime("created", reader, -1));
                            break block0;
                        }
                        case "comment": {
                            position = XMLSupport.checkElementOrder("comment", 25, position, false);
                            builder.comment(this.parseString("comment", reader, -1));
                            break block0;
                        }
                        case "patientInstruction": {
                            position = XMLSupport.checkElementOrder("patientInstruction", 26, position, false);
                            builder.patientInstruction(this.parseString("patientInstruction", reader, -1));
                            break block0;
                        }
                        case "basedOn": {
                            position = XMLSupport.checkElementOrder("basedOn", 27, position, true);
                            builder.basedOn(this.parseReference("basedOn", reader, basedOnElementIndex++));
                            break block0;
                        }
                        case "participant": {
                            position = XMLSupport.checkElementOrder("participant", 28, position, true);
                            builder.participant(this.parseAppointmentParticipant("participant", reader, participantElementIndex++));
                            break block0;
                        }
                        case "requestedPeriod": {
                            position = XMLSupport.checkElementOrder("requestedPeriod", 29, position, true);
                            builder.requestedPeriod(this.parsePeriod("requestedPeriod", reader, requestedPeriodElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Appointment.Participant parseAppointmentParticipant(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Appointment.Participant.Builder builder = Appointment.Participant.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int typeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, true);
                            builder.type(this.parseCodeableConcept("type", reader, typeElementIndex++));
                            break block0;
                        }
                        case "actor": {
                            position = XMLSupport.checkElementOrder("actor", 3, position, false);
                            builder.actor(this.parseReference("actor", reader, -1));
                            break block0;
                        }
                        case "required": {
                            position = XMLSupport.checkElementOrder("required", 4, position, false);
                            builder.required((ParticipantRequired)this.parseString(ParticipantRequired.builder(), "required", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 5, position, false);
                            builder.status((ParticipationStatus)this.parseString(ParticipationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 6, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AppointmentResponse parseAppointmentResponse(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AppointmentResponse.Builder builder = AppointmentResponse.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int participantTypeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "appointment": {
                            position = XMLSupport.checkElementOrder("appointment", 9, position, false);
                            builder.appointment(this.parseReference("appointment", reader, -1));
                            break block0;
                        }
                        case "start": {
                            position = XMLSupport.checkElementOrder("start", 10, position, false);
                            builder.start(this.parseInstant("start", reader, -1));
                            break block0;
                        }
                        case "end": {
                            position = XMLSupport.checkElementOrder("end", 11, position, false);
                            builder.end(this.parseInstant("end", reader, -1));
                            break block0;
                        }
                        case "participantType": {
                            position = XMLSupport.checkElementOrder("participantType", 12, position, true);
                            builder.participantType(this.parseCodeableConcept("participantType", reader, participantTypeElementIndex++));
                            break block0;
                        }
                        case "actor": {
                            position = XMLSupport.checkElementOrder("actor", 13, position, false);
                            builder.actor(this.parseReference("actor", reader, -1));
                            break block0;
                        }
                        case "participantStatus": {
                            position = XMLSupport.checkElementOrder("participantStatus", 14, position, false);
                            builder.participantStatus((ParticipantStatus)this.parseString(ParticipantStatus.builder(), "participantStatus", reader, -1));
                            break block0;
                        }
                        case "comment": {
                            position = XMLSupport.checkElementOrder("comment", 15, position, false);
                            builder.comment(this.parseString("comment", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Attachment parseAttachment(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Attachment.Builder builder = Attachment.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "contentType": {
                            position = XMLSupport.checkElementOrder("contentType", 1, position, false);
                            builder.contentType((Code)this.parseString(Code.builder(), "contentType", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 2, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "data": {
                            position = XMLSupport.checkElementOrder("data", 3, position, false);
                            builder.data(this.parseBase64Binary("data", reader, -1));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 4, position, false);
                            builder.url((Url)this.parseUri(Url.builder(), "url", reader, -1));
                            break block0;
                        }
                        case "size": {
                            position = XMLSupport.checkElementOrder("size", 5, position, false);
                            builder.size((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "size", reader, -1));
                            break block0;
                        }
                        case "hash": {
                            position = XMLSupport.checkElementOrder("hash", 6, position, false);
                            builder.hash(this.parseBase64Binary("hash", reader, -1));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 7, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "creation": {
                            position = XMLSupport.checkElementOrder("creation", 8, position, false);
                            builder.creation(this.parseDateTime("creation", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AuditEvent parseAuditEvent(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AuditEvent.Builder builder = AuditEvent.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int subtypeElementIndex = 0;
        int purposeOfEventElementIndex = 0;
        int agentElementIndex = 0;
        int entityElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 8, position, false);
                            builder.type(this.parseCoding("type", reader, -1));
                            break block0;
                        }
                        case "subtype": {
                            position = XMLSupport.checkElementOrder("subtype", 9, position, true);
                            builder.subtype(this.parseCoding("subtype", reader, subtypeElementIndex++));
                            break block0;
                        }
                        case "action": {
                            position = XMLSupport.checkElementOrder("action", 10, position, false);
                            builder.action((AuditEventAction)this.parseString(AuditEventAction.builder(), "action", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 11, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                        case "recorded": {
                            position = XMLSupport.checkElementOrder("recorded", 12, position, false);
                            builder.recorded(this.parseInstant("recorded", reader, -1));
                            break block0;
                        }
                        case "outcome": {
                            position = XMLSupport.checkElementOrder("outcome", 13, position, false);
                            builder.outcome((AuditEventOutcome)this.parseString(AuditEventOutcome.builder(), "outcome", reader, -1));
                            break block0;
                        }
                        case "outcomeDesc": {
                            position = XMLSupport.checkElementOrder("outcomeDesc", 14, position, false);
                            builder.outcomeDesc(this.parseString("outcomeDesc", reader, -1));
                            break block0;
                        }
                        case "purposeOfEvent": {
                            position = XMLSupport.checkElementOrder("purposeOfEvent", 15, position, true);
                            builder.purposeOfEvent(this.parseCodeableConcept("purposeOfEvent", reader, purposeOfEventElementIndex++));
                            break block0;
                        }
                        case "agent": {
                            position = XMLSupport.checkElementOrder("agent", 16, position, true);
                            builder.agent(this.parseAuditEventAgent("agent", reader, agentElementIndex++));
                            break block0;
                        }
                        case "source": {
                            position = XMLSupport.checkElementOrder("source", 17, position, false);
                            builder.source(this.parseAuditEventSource("source", reader, -1));
                            break block0;
                        }
                        case "entity": {
                            position = XMLSupport.checkElementOrder("entity", 18, position, true);
                            builder.entity(this.parseAuditEventEntity("entity", reader, entityElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AuditEvent.Agent parseAuditEventAgent(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AuditEvent.Agent.Builder builder = AuditEvent.Agent.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int roleElementIndex = 0;
        int policyElementIndex = 0;
        int purposeOfUseElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 3, position, true);
                            builder.role(this.parseCodeableConcept("role", reader, roleElementIndex++));
                            break block0;
                        }
                        case "who": {
                            position = XMLSupport.checkElementOrder("who", 4, position, false);
                            builder.who(this.parseReference("who", reader, -1));
                            break block0;
                        }
                        case "altId": {
                            position = XMLSupport.checkElementOrder("altId", 5, position, false);
                            builder.altId(this.parseString("altId", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 6, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "requestor": {
                            position = XMLSupport.checkElementOrder("requestor", 7, position, false);
                            builder.requestor(this.parseBoolean("requestor", reader, -1));
                            break block0;
                        }
                        case "location": {
                            position = XMLSupport.checkElementOrder("location", 8, position, false);
                            builder.location(this.parseReference("location", reader, -1));
                            break block0;
                        }
                        case "policy": {
                            position = XMLSupport.checkElementOrder("policy", 9, position, true);
                            builder.policy(this.parseUri("policy", reader, policyElementIndex++));
                            break block0;
                        }
                        case "media": {
                            position = XMLSupport.checkElementOrder("media", 10, position, false);
                            builder.media(this.parseCoding("media", reader, -1));
                            break block0;
                        }
                        case "network": {
                            position = XMLSupport.checkElementOrder("network", 11, position, false);
                            builder.network(this.parseAuditEventAgentNetwork("network", reader, -1));
                            break block0;
                        }
                        case "purposeOfUse": {
                            position = XMLSupport.checkElementOrder("purposeOfUse", 12, position, true);
                            builder.purposeOfUse(this.parseCodeableConcept("purposeOfUse", reader, purposeOfUseElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AuditEvent.Agent.Network parseAuditEventAgentNetwork(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AuditEvent.Agent.Network.Builder builder = AuditEvent.Agent.Network.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "address": {
                            position = XMLSupport.checkElementOrder("address", 2, position, false);
                            builder.address(this.parseString("address", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, false);
                            builder.type((AuditEventAgentNetworkType)this.parseString(AuditEventAgentNetworkType.builder(), "type", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AuditEvent.Entity parseAuditEventEntity(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AuditEvent.Entity.Builder builder = AuditEvent.Entity.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int securityLabelElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "what": {
                            position = XMLSupport.checkElementOrder("what", 2, position, false);
                            builder.what(this.parseReference("what", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, false);
                            builder.type(this.parseCoding("type", reader, -1));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 4, position, false);
                            builder.role(this.parseCoding("role", reader, -1));
                            break block0;
                        }
                        case "lifecycle": {
                            position = XMLSupport.checkElementOrder("lifecycle", 5, position, false);
                            builder.lifecycle(this.parseCoding("lifecycle", reader, -1));
                            break block0;
                        }
                        case "securityLabel": {
                            position = XMLSupport.checkElementOrder("securityLabel", 6, position, true);
                            builder.securityLabel(this.parseCoding("securityLabel", reader, securityLabelElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 7, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 8, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "query": {
                            position = XMLSupport.checkElementOrder("query", 9, position, false);
                            builder.query(this.parseBase64Binary("query", reader, -1));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 10, position, true);
                            builder.detail(this.parseAuditEventEntityDetail("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AuditEvent.Entity.Detail parseAuditEventEntityDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AuditEvent.Entity.Detail.Builder builder = AuditEvent.Entity.Detail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseString("type", reader, -1));
                            break block0;
                        }
                        case "valueString": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseString("valueString", reader, -1));
                            break block0;
                        }
                        case "valueBase64Binary": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseBase64Binary("valueBase64Binary", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private AuditEvent.Source parseAuditEventSource(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        AuditEvent.Source.Builder builder = AuditEvent.Source.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int typeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "site": {
                            position = XMLSupport.checkElementOrder("site", 2, position, false);
                            builder.site(this.parseString("site", reader, -1));
                            break block0;
                        }
                        case "observer": {
                            position = XMLSupport.checkElementOrder("observer", 3, position, false);
                            builder.observer(this.parseReference("observer", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 4, position, true);
                            builder.type(this.parseCoding("type", reader, typeElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Base64Binary parseBase64Binary(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        String value;
        this.stackPush(elementName, elementIndex);
        Base64Binary.Builder builder = Base64Binary.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        if ((value = reader.getAttributeValue(null, "value")) != null) {
            builder.value(value);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Basic parseBasic(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Basic.Builder builder = Basic.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 9, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 10, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "created": {
                            position = XMLSupport.checkElementOrder("created", 11, position, false);
                            builder.created(this.parseDate("created", reader, -1));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 12, position, false);
                            builder.author(this.parseReference("author", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Binary parseBinary(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Binary.Builder builder = Binary.builder();
        builder.setValidating(this.validating);
        int position = -1;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "contentType": {
                            position = XMLSupport.checkElementOrder("contentType", 4, position, false);
                            builder.contentType((Code)this.parseString(Code.builder(), "contentType", reader, -1));
                            break block0;
                        }
                        case "securityContext": {
                            position = XMLSupport.checkElementOrder("securityContext", 5, position, false);
                            builder.securityContext(this.parseReference("securityContext", reader, -1));
                            break block0;
                        }
                        case "data": {
                            position = XMLSupport.checkElementOrder("data", 6, position, false);
                            builder.data(this.parseBase64Binary("data", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private BiologicallyDerivedProduct parseBiologicallyDerivedProduct(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        BiologicallyDerivedProduct.Builder builder = BiologicallyDerivedProduct.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int requestElementIndex = 0;
        int parentElementIndex = 0;
        int processingElementIndex = 0;
        int storageElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "productCategory": {
                            position = XMLSupport.checkElementOrder("productCategory", 9, position, false);
                            builder.productCategory((BiologicallyDerivedProductCategory)this.parseString(BiologicallyDerivedProductCategory.builder(), "productCategory", reader, -1));
                            break block0;
                        }
                        case "productCode": {
                            position = XMLSupport.checkElementOrder("productCode", 10, position, false);
                            builder.productCode(this.parseCodeableConcept("productCode", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 11, position, false);
                            builder.status((BiologicallyDerivedProductStatus)this.parseString(BiologicallyDerivedProductStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "request": {
                            position = XMLSupport.checkElementOrder("request", 12, position, true);
                            builder.request(this.parseReference("request", reader, requestElementIndex++));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 13, position, false);
                            builder.quantity(this.parseInteger("quantity", reader, -1));
                            break block0;
                        }
                        case "parent": {
                            position = XMLSupport.checkElementOrder("parent", 14, position, true);
                            builder.parent(this.parseReference("parent", reader, parentElementIndex++));
                            break block0;
                        }
                        case "collection": {
                            position = XMLSupport.checkElementOrder("collection", 15, position, false);
                            builder.collection(this.parseBiologicallyDerivedProductCollection("collection", reader, -1));
                            break block0;
                        }
                        case "processing": {
                            position = XMLSupport.checkElementOrder("processing", 16, position, true);
                            builder.processing(this.parseBiologicallyDerivedProductProcessing("processing", reader, processingElementIndex++));
                            break block0;
                        }
                        case "manipulation": {
                            position = XMLSupport.checkElementOrder("manipulation", 17, position, false);
                            builder.manipulation(this.parseBiologicallyDerivedProductManipulation("manipulation", reader, -1));
                            break block0;
                        }
                        case "storage": {
                            position = XMLSupport.checkElementOrder("storage", 18, position, true);
                            builder.storage(this.parseBiologicallyDerivedProductStorage("storage", reader, storageElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private BiologicallyDerivedProduct.Collection parseBiologicallyDerivedProductCollection(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        BiologicallyDerivedProduct.Collection.Builder builder = BiologicallyDerivedProduct.Collection.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "collector": {
                            position = XMLSupport.checkElementOrder("collector", 2, position, false);
                            builder.collector(this.parseReference("collector", reader, -1));
                            break block0;
                        }
                        case "source": {
                            position = XMLSupport.checkElementOrder("source", 3, position, false);
                            builder.source(this.parseReference("source", reader, -1));
                            break block0;
                        }
                        case "collectedDateTime": {
                            position = XMLSupport.checkElementOrder("collected[x]", 4, position, false);
                            builder.collected(this.parseDateTime("collectedDateTime", reader, -1));
                            break block0;
                        }
                        case "collectedPeriod": {
                            position = XMLSupport.checkElementOrder("collected[x]", 4, position, false);
                            builder.collected(this.parsePeriod("collectedPeriod", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private BiologicallyDerivedProduct.Manipulation parseBiologicallyDerivedProductManipulation(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        BiologicallyDerivedProduct.Manipulation.Builder builder = BiologicallyDerivedProduct.Manipulation.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 2, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "timeDateTime": {
                            position = XMLSupport.checkElementOrder("time[x]", 3, position, false);
                            builder.time(this.parseDateTime("timeDateTime", reader, -1));
                            break block0;
                        }
                        case "timePeriod": {
                            position = XMLSupport.checkElementOrder("time[x]", 3, position, false);
                            builder.time(this.parsePeriod("timePeriod", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private BiologicallyDerivedProduct.Processing parseBiologicallyDerivedProductProcessing(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        BiologicallyDerivedProduct.Processing.Builder builder = BiologicallyDerivedProduct.Processing.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 2, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "procedure": {
                            position = XMLSupport.checkElementOrder("procedure", 3, position, false);
                            builder.procedure(this.parseCodeableConcept("procedure", reader, -1));
                            break block0;
                        }
                        case "additive": {
                            position = XMLSupport.checkElementOrder("additive", 4, position, false);
                            builder.additive(this.parseReference("additive", reader, -1));
                            break block0;
                        }
                        case "timeDateTime": {
                            position = XMLSupport.checkElementOrder("time[x]", 5, position, false);
                            builder.time(this.parseDateTime("timeDateTime", reader, -1));
                            break block0;
                        }
                        case "timePeriod": {
                            position = XMLSupport.checkElementOrder("time[x]", 5, position, false);
                            builder.time(this.parsePeriod("timePeriod", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private BiologicallyDerivedProduct.Storage parseBiologicallyDerivedProductStorage(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        BiologicallyDerivedProduct.Storage.Builder builder = BiologicallyDerivedProduct.Storage.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 2, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "temperature": {
                            position = XMLSupport.checkElementOrder("temperature", 3, position, false);
                            builder.temperature(this.parseDecimal("temperature", reader, -1));
                            break block0;
                        }
                        case "scale": {
                            position = XMLSupport.checkElementOrder("scale", 4, position, false);
                            builder.scale((BiologicallyDerivedProductStorageScale)this.parseString(BiologicallyDerivedProductStorageScale.builder(), "scale", reader, -1));
                            break block0;
                        }
                        case "duration": {
                            position = XMLSupport.checkElementOrder("duration", 5, position, false);
                            builder.duration(this.parsePeriod("duration", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private BodyStructure parseBodyStructure(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        BodyStructure.Builder builder = BodyStructure.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int locationQualifierElementIndex = 0;
        int imageElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "active": {
                            position = XMLSupport.checkElementOrder("active", 9, position, false);
                            builder.active(this.parseBoolean("active", reader, -1));
                            break block0;
                        }
                        case "morphology": {
                            position = XMLSupport.checkElementOrder("morphology", 10, position, false);
                            builder.morphology(this.parseCodeableConcept("morphology", reader, -1));
                            break block0;
                        }
                        case "location": {
                            position = XMLSupport.checkElementOrder("location", 11, position, false);
                            builder.location(this.parseCodeableConcept("location", reader, -1));
                            break block0;
                        }
                        case "locationQualifier": {
                            position = XMLSupport.checkElementOrder("locationQualifier", 12, position, true);
                            builder.locationQualifier(this.parseCodeableConcept("locationQualifier", reader, locationQualifierElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 13, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "image": {
                            position = XMLSupport.checkElementOrder("image", 14, position, true);
                            builder.image(this.parseAttachment("image", reader, imageElementIndex++));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 15, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Boolean parseBoolean(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        String value;
        this.stackPush(elementName, elementIndex);
        Boolean.Builder builder = Boolean.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        if ((value = reader.getAttributeValue(null, "value")) != null) {
            builder.value(value);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Bundle parseBundle(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Bundle.Builder builder = Bundle.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int linkElementIndex = 0;
        int entryElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 4, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 5, position, false);
                            builder.type((BundleType)this.parseString(BundleType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "timestamp": {
                            position = XMLSupport.checkElementOrder("timestamp", 6, position, false);
                            builder.timestamp(this.parseInstant("timestamp", reader, -1));
                            break block0;
                        }
                        case "total": {
                            position = XMLSupport.checkElementOrder("total", 7, position, false);
                            builder.total((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "total", reader, -1));
                            break block0;
                        }
                        case "link": {
                            position = XMLSupport.checkElementOrder("link", 8, position, true);
                            builder.link(this.parseBundleLink("link", reader, linkElementIndex++));
                            break block0;
                        }
                        case "entry": {
                            position = XMLSupport.checkElementOrder("entry", 9, position, true);
                            builder.entry(this.parseBundleEntry("entry", reader, entryElementIndex++));
                            break block0;
                        }
                        case "signature": {
                            position = XMLSupport.checkElementOrder("signature", 10, position, false);
                            builder.signature(this.parseSignature("signature", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Bundle.Entry parseBundleEntry(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Bundle.Entry.Builder builder = Bundle.Entry.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int linkElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "link": {
                            position = XMLSupport.checkElementOrder("link", 2, position, true);
                            builder.link(this.parseBundleLink("link", reader, linkElementIndex++));
                            break block0;
                        }
                        case "fullUrl": {
                            position = XMLSupport.checkElementOrder("fullUrl", 3, position, false);
                            builder.fullUrl(this.parseUri("fullUrl", reader, -1));
                            break block0;
                        }
                        case "resource": {
                            position = XMLSupport.checkElementOrder("resource", 4, position, false);
                            builder.resource(this.parseResource("resource", reader, -1));
                            break block0;
                        }
                        case "search": {
                            position = XMLSupport.checkElementOrder("search", 5, position, false);
                            builder.search(this.parseBundleEntrySearch("search", reader, -1));
                            break block0;
                        }
                        case "request": {
                            position = XMLSupport.checkElementOrder("request", 6, position, false);
                            builder.request(this.parseBundleEntryRequest("request", reader, -1));
                            break block0;
                        }
                        case "response": {
                            position = XMLSupport.checkElementOrder("response", 7, position, false);
                            builder.response(this.parseBundleEntryResponse("response", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Bundle.Entry.Request parseBundleEntryRequest(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Bundle.Entry.Request.Builder builder = Bundle.Entry.Request.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "method": {
                            position = XMLSupport.checkElementOrder("method", 2, position, false);
                            builder.method((HTTPVerb)this.parseString(HTTPVerb.builder(), "method", reader, -1));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 3, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "ifNoneMatch": {
                            position = XMLSupport.checkElementOrder("ifNoneMatch", 4, position, false);
                            builder.ifNoneMatch(this.parseString("ifNoneMatch", reader, -1));
                            break block0;
                        }
                        case "ifModifiedSince": {
                            position = XMLSupport.checkElementOrder("ifModifiedSince", 5, position, false);
                            builder.ifModifiedSince(this.parseInstant("ifModifiedSince", reader, -1));
                            break block0;
                        }
                        case "ifMatch": {
                            position = XMLSupport.checkElementOrder("ifMatch", 6, position, false);
                            builder.ifMatch(this.parseString("ifMatch", reader, -1));
                            break block0;
                        }
                        case "ifNoneExist": {
                            position = XMLSupport.checkElementOrder("ifNoneExist", 7, position, false);
                            builder.ifNoneExist(this.parseString("ifNoneExist", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Bundle.Entry.Response parseBundleEntryResponse(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Bundle.Entry.Response.Builder builder = Bundle.Entry.Response.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 2, position, false);
                            builder.status(this.parseString("status", reader, -1));
                            break block0;
                        }
                        case "location": {
                            position = XMLSupport.checkElementOrder("location", 3, position, false);
                            builder.location(this.parseUri("location", reader, -1));
                            break block0;
                        }
                        case "etag": {
                            position = XMLSupport.checkElementOrder("etag", 4, position, false);
                            builder.etag(this.parseString("etag", reader, -1));
                            break block0;
                        }
                        case "lastModified": {
                            position = XMLSupport.checkElementOrder("lastModified", 5, position, false);
                            builder.lastModified(this.parseInstant("lastModified", reader, -1));
                            break block0;
                        }
                        case "outcome": {
                            position = XMLSupport.checkElementOrder("outcome", 6, position, false);
                            builder.outcome(this.parseResource("outcome", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Bundle.Entry.Search parseBundleEntrySearch(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Bundle.Entry.Search.Builder builder = Bundle.Entry.Search.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "mode": {
                            position = XMLSupport.checkElementOrder("mode", 2, position, false);
                            builder.mode((SearchEntryMode)this.parseString(SearchEntryMode.builder(), "mode", reader, -1));
                            break block0;
                        }
                        case "score": {
                            position = XMLSupport.checkElementOrder("score", 3, position, false);
                            builder.score(this.parseDecimal("score", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Bundle.Link parseBundleLink(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Bundle.Link.Builder builder = Bundle.Link.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "relation": {
                            position = XMLSupport.checkElementOrder("relation", 2, position, false);
                            builder.relation(this.parseString("relation", reader, -1));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 3, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement parseCapabilityStatement(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Builder builder = CapabilityStatement.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int contactElementIndex = 0;
        int useContextElementIndex = 0;
        int jurisdictionElementIndex = 0;
        int instantiatesElementIndex = 0;
        int importsElementIndex = 0;
        int formatElementIndex = 0;
        int patchFormatElementIndex = 0;
        int implementationGuideElementIndex = 0;
        int restElementIndex = 0;
        int messagingElementIndex = 0;
        int documentElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 8, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 9, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 10, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 11, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 12, position, false);
                            builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "experimental": {
                            position = XMLSupport.checkElementOrder("experimental", 13, position, false);
                            builder.experimental(this.parseBoolean("experimental", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 14, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "publisher": {
                            position = XMLSupport.checkElementOrder("publisher", 15, position, false);
                            builder.publisher(this.parseString("publisher", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 16, position, true);
                            builder.contact(this.parseContactDetail("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 17, position, false);
                            builder.description((Markdown)this.parseString(Markdown.builder(), "description", reader, -1));
                            break block0;
                        }
                        case "useContext": {
                            position = XMLSupport.checkElementOrder("useContext", 18, position, true);
                            builder.useContext(this.parseUsageContext("useContext", reader, useContextElementIndex++));
                            break block0;
                        }
                        case "jurisdiction": {
                            position = XMLSupport.checkElementOrder("jurisdiction", 19, position, true);
                            builder.jurisdiction(this.parseCodeableConcept("jurisdiction", reader, jurisdictionElementIndex++));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 20, position, false);
                            builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", reader, -1));
                            break block0;
                        }
                        case "copyright": {
                            position = XMLSupport.checkElementOrder("copyright", 21, position, false);
                            builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", reader, -1));
                            break block0;
                        }
                        case "kind": {
                            position = XMLSupport.checkElementOrder("kind", 22, position, false);
                            builder.kind((CapabilityStatementKind)this.parseString(CapabilityStatementKind.builder(), "kind", reader, -1));
                            break block0;
                        }
                        case "instantiates": {
                            position = XMLSupport.checkElementOrder("instantiates", 23, position, true);
                            builder.instantiates((Canonical)this.parseUri(Canonical.builder(), "instantiates", reader, instantiatesElementIndex++));
                            break block0;
                        }
                        case "imports": {
                            position = XMLSupport.checkElementOrder("imports", 24, position, true);
                            builder.imports((Canonical)this.parseUri(Canonical.builder(), "imports", reader, importsElementIndex++));
                            break block0;
                        }
                        case "software": {
                            position = XMLSupport.checkElementOrder("software", 25, position, false);
                            builder.software(this.parseCapabilityStatementSoftware("software", reader, -1));
                            break block0;
                        }
                        case "implementation": {
                            position = XMLSupport.checkElementOrder("implementation", 26, position, false);
                            builder.implementation(this.parseCapabilityStatementImplementation("implementation", reader, -1));
                            break block0;
                        }
                        case "fhirVersion": {
                            position = XMLSupport.checkElementOrder("fhirVersion", 27, position, false);
                            builder.fhirVersion((FHIRVersion)this.parseString(FHIRVersion.builder(), "fhirVersion", reader, -1));
                            break block0;
                        }
                        case "format": {
                            position = XMLSupport.checkElementOrder("format", 28, position, true);
                            builder.format((Code)this.parseString(Code.builder(), "format", reader, formatElementIndex++));
                            break block0;
                        }
                        case "patchFormat": {
                            position = XMLSupport.checkElementOrder("patchFormat", 29, position, true);
                            builder.patchFormat((Code)this.parseString(Code.builder(), "patchFormat", reader, patchFormatElementIndex++));
                            break block0;
                        }
                        case "implementationGuide": {
                            position = XMLSupport.checkElementOrder("implementationGuide", 30, position, true);
                            builder.implementationGuide((Canonical)this.parseUri(Canonical.builder(), "implementationGuide", reader, implementationGuideElementIndex++));
                            break block0;
                        }
                        case "rest": {
                            position = XMLSupport.checkElementOrder("rest", 31, position, true);
                            builder.rest(this.parseCapabilityStatementRest("rest", reader, restElementIndex++));
                            break block0;
                        }
                        case "messaging": {
                            position = XMLSupport.checkElementOrder("messaging", 32, position, true);
                            builder.messaging(this.parseCapabilityStatementMessaging("messaging", reader, messagingElementIndex++));
                            break block0;
                        }
                        case "document": {
                            position = XMLSupport.checkElementOrder("document", 33, position, true);
                            builder.document(this.parseCapabilityStatementDocument("document", reader, documentElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Document parseCapabilityStatementDocument(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Document.Builder builder = CapabilityStatement.Document.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "mode": {
                            position = XMLSupport.checkElementOrder("mode", 2, position, false);
                            builder.mode((DocumentMode)this.parseString(DocumentMode.builder(), "mode", reader, -1));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 3, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                        case "profile": {
                            position = XMLSupport.checkElementOrder("profile", 4, position, false);
                            builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Implementation parseCapabilityStatementImplementation(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Implementation.Builder builder = CapabilityStatement.Implementation.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 2, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 3, position, false);
                            builder.url((Url)this.parseUri(Url.builder(), "url", reader, -1));
                            break block0;
                        }
                        case "custodian": {
                            position = XMLSupport.checkElementOrder("custodian", 4, position, false);
                            builder.custodian(this.parseReference("custodian", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Messaging parseCapabilityStatementMessaging(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Messaging.Builder builder = CapabilityStatement.Messaging.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int endpointElementIndex = 0;
        int supportedMessageElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "endpoint": {
                            position = XMLSupport.checkElementOrder("endpoint", 2, position, true);
                            builder.endpoint(this.parseCapabilityStatementMessagingEndpoint("endpoint", reader, endpointElementIndex++));
                            break block0;
                        }
                        case "reliableCache": {
                            position = XMLSupport.checkElementOrder("reliableCache", 3, position, false);
                            builder.reliableCache((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "reliableCache", reader, -1));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 4, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                        case "supportedMessage": {
                            position = XMLSupport.checkElementOrder("supportedMessage", 5, position, true);
                            builder.supportedMessage(this.parseCapabilityStatementMessagingSupportedMessage("supportedMessage", reader, supportedMessageElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Messaging.Endpoint parseCapabilityStatementMessagingEndpoint(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Messaging.Endpoint.Builder builder = CapabilityStatement.Messaging.Endpoint.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "protocol": {
                            position = XMLSupport.checkElementOrder("protocol", 2, position, false);
                            builder.protocol(this.parseCoding("protocol", reader, -1));
                            break block0;
                        }
                        case "address": {
                            position = XMLSupport.checkElementOrder("address", 3, position, false);
                            builder.address((Url)this.parseUri(Url.builder(), "address", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Messaging.SupportedMessage parseCapabilityStatementMessagingSupportedMessage(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Messaging.SupportedMessage.Builder builder = CapabilityStatement.Messaging.SupportedMessage.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "mode": {
                            position = XMLSupport.checkElementOrder("mode", 2, position, false);
                            builder.mode((EventCapabilityMode)this.parseString(EventCapabilityMode.builder(), "mode", reader, -1));
                            break block0;
                        }
                        case "definition": {
                            position = XMLSupport.checkElementOrder("definition", 3, position, false);
                            builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Rest parseCapabilityStatementRest(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Rest.Builder builder = CapabilityStatement.Rest.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int resourceElementIndex = 0;
        int interactionElementIndex = 0;
        int searchParamElementIndex = 0;
        int operationElementIndex = 0;
        int compartmentElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "mode": {
                            position = XMLSupport.checkElementOrder("mode", 2, position, false);
                            builder.mode((RestfulCapabilityMode)this.parseString(RestfulCapabilityMode.builder(), "mode", reader, -1));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 3, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                        case "security": {
                            position = XMLSupport.checkElementOrder("security", 4, position, false);
                            builder.security(this.parseCapabilityStatementRestSecurity("security", reader, -1));
                            break block0;
                        }
                        case "resource": {
                            position = XMLSupport.checkElementOrder("resource", 5, position, true);
                            builder.resource(this.parseCapabilityStatementRestResource("resource", reader, resourceElementIndex++));
                            break block0;
                        }
                        case "interaction": {
                            position = XMLSupport.checkElementOrder("interaction", 6, position, true);
                            builder.interaction(this.parseCapabilityStatementRestInteraction("interaction", reader, interactionElementIndex++));
                            break block0;
                        }
                        case "searchParam": {
                            position = XMLSupport.checkElementOrder("searchParam", 7, position, true);
                            builder.searchParam(this.parseCapabilityStatementRestResourceSearchParam("searchParam", reader, searchParamElementIndex++));
                            break block0;
                        }
                        case "operation": {
                            position = XMLSupport.checkElementOrder("operation", 8, position, true);
                            builder.operation(this.parseCapabilityStatementRestResourceOperation("operation", reader, operationElementIndex++));
                            break block0;
                        }
                        case "compartment": {
                            position = XMLSupport.checkElementOrder("compartment", 9, position, true);
                            builder.compartment((Canonical)this.parseUri(Canonical.builder(), "compartment", reader, compartmentElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Rest.Interaction parseCapabilityStatementRestInteraction(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Rest.Interaction.Builder builder = CapabilityStatement.Rest.Interaction.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((SystemRestfulInteraction)this.parseString(SystemRestfulInteraction.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 3, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Rest.Resource parseCapabilityStatementRestResource(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Rest.Resource.Builder builder = CapabilityStatement.Rest.Resource.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int supportedProfileElementIndex = 0;
        int interactionElementIndex = 0;
        int referencePolicyElementIndex = 0;
        int searchIncludeElementIndex = 0;
        int searchRevIncludeElementIndex = 0;
        int searchParamElementIndex = 0;
        int operationElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type((ResourceType)this.parseString(ResourceType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "profile": {
                            position = XMLSupport.checkElementOrder("profile", 3, position, false);
                            builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", reader, -1));
                            break block0;
                        }
                        case "supportedProfile": {
                            position = XMLSupport.checkElementOrder("supportedProfile", 4, position, true);
                            builder.supportedProfile((Canonical)this.parseUri(Canonical.builder(), "supportedProfile", reader, supportedProfileElementIndex++));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 5, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                        case "interaction": {
                            position = XMLSupport.checkElementOrder("interaction", 6, position, true);
                            builder.interaction(this.parseCapabilityStatementRestResourceInteraction("interaction", reader, interactionElementIndex++));
                            break block0;
                        }
                        case "versioning": {
                            position = XMLSupport.checkElementOrder("versioning", 7, position, false);
                            builder.versioning((ResourceVersionPolicy)this.parseString(ResourceVersionPolicy.builder(), "versioning", reader, -1));
                            break block0;
                        }
                        case "readHistory": {
                            position = XMLSupport.checkElementOrder("readHistory", 8, position, false);
                            builder.readHistory(this.parseBoolean("readHistory", reader, -1));
                            break block0;
                        }
                        case "updateCreate": {
                            position = XMLSupport.checkElementOrder("updateCreate", 9, position, false);
                            builder.updateCreate(this.parseBoolean("updateCreate", reader, -1));
                            break block0;
                        }
                        case "conditionalCreate": {
                            position = XMLSupport.checkElementOrder("conditionalCreate", 10, position, false);
                            builder.conditionalCreate(this.parseBoolean("conditionalCreate", reader, -1));
                            break block0;
                        }
                        case "conditionalRead": {
                            position = XMLSupport.checkElementOrder("conditionalRead", 11, position, false);
                            builder.conditionalRead((ConditionalReadStatus)this.parseString(ConditionalReadStatus.builder(), "conditionalRead", reader, -1));
                            break block0;
                        }
                        case "conditionalUpdate": {
                            position = XMLSupport.checkElementOrder("conditionalUpdate", 12, position, false);
                            builder.conditionalUpdate(this.parseBoolean("conditionalUpdate", reader, -1));
                            break block0;
                        }
                        case "conditionalDelete": {
                            position = XMLSupport.checkElementOrder("conditionalDelete", 13, position, false);
                            builder.conditionalDelete((ConditionalDeleteStatus)this.parseString(ConditionalDeleteStatus.builder(), "conditionalDelete", reader, -1));
                            break block0;
                        }
                        case "referencePolicy": {
                            position = XMLSupport.checkElementOrder("referencePolicy", 14, position, true);
                            builder.referencePolicy((ReferenceHandlingPolicy)this.parseString(ReferenceHandlingPolicy.builder(), "referencePolicy", reader, referencePolicyElementIndex++));
                            break block0;
                        }
                        case "searchInclude": {
                            position = XMLSupport.checkElementOrder("searchInclude", 15, position, true);
                            builder.searchInclude(this.parseString("searchInclude", reader, searchIncludeElementIndex++));
                            break block0;
                        }
                        case "searchRevInclude": {
                            position = XMLSupport.checkElementOrder("searchRevInclude", 16, position, true);
                            builder.searchRevInclude(this.parseString("searchRevInclude", reader, searchRevIncludeElementIndex++));
                            break block0;
                        }
                        case "searchParam": {
                            position = XMLSupport.checkElementOrder("searchParam", 17, position, true);
                            builder.searchParam(this.parseCapabilityStatementRestResourceSearchParam("searchParam", reader, searchParamElementIndex++));
                            break block0;
                        }
                        case "operation": {
                            position = XMLSupport.checkElementOrder("operation", 18, position, true);
                            builder.operation(this.parseCapabilityStatementRestResourceOperation("operation", reader, operationElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Rest.Resource.Interaction parseCapabilityStatementRestResourceInteraction(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Rest.Resource.Interaction.Builder builder = CapabilityStatement.Rest.Resource.Interaction.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((TypeRestfulInteraction)this.parseString(TypeRestfulInteraction.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 3, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Rest.Resource.Operation parseCapabilityStatementRestResourceOperation(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Rest.Resource.Operation.Builder builder = CapabilityStatement.Rest.Resource.Operation.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 2, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "definition": {
                            position = XMLSupport.checkElementOrder("definition", 3, position, false);
                            builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", reader, -1));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 4, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Rest.Resource.SearchParam parseCapabilityStatementRestResourceSearchParam(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Rest.Resource.SearchParam.Builder builder = CapabilityStatement.Rest.Resource.SearchParam.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 2, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "definition": {
                            position = XMLSupport.checkElementOrder("definition", 3, position, false);
                            builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 4, position, false);
                            builder.type((SearchParamType)this.parseString(SearchParamType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 5, position, false);
                            builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Rest.Security parseCapabilityStatementRestSecurity(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Rest.Security.Builder builder = CapabilityStatement.Rest.Security.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int serviceElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "cors": {
                            position = XMLSupport.checkElementOrder("cors", 2, position, false);
                            builder.cors(this.parseBoolean("cors", reader, -1));
                            break block0;
                        }
                        case "service": {
                            position = XMLSupport.checkElementOrder("service", 3, position, true);
                            builder.service(this.parseCodeableConcept("service", reader, serviceElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 4, position, false);
                            builder.description((Markdown)this.parseString(Markdown.builder(), "description", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CapabilityStatement.Software parseCapabilityStatementSoftware(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CapabilityStatement.Software.Builder builder = CapabilityStatement.Software.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 2, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 3, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "releaseDate": {
                            position = XMLSupport.checkElementOrder("releaseDate", 4, position, false);
                            builder.releaseDate(this.parseDateTime("releaseDate", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CarePlan parseCarePlan(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CarePlan.Builder builder = CarePlan.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int instantiatesCanonicalElementIndex = 0;
        int instantiatesUriElementIndex = 0;
        int basedOnElementIndex = 0;
        int replacesElementIndex = 0;
        int partOfElementIndex = 0;
        int categoryElementIndex = 0;
        int contributorElementIndex = 0;
        int careTeamElementIndex = 0;
        int addressesElementIndex = 0;
        int supportingInfoElementIndex = 0;
        int goalElementIndex = 0;
        int activityElementIndex = 0;
        int noteElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "instantiatesCanonical": {
                            position = XMLSupport.checkElementOrder("instantiatesCanonical", 9, position, true);
                            builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", reader, instantiatesCanonicalElementIndex++));
                            break block0;
                        }
                        case "instantiatesUri": {
                            position = XMLSupport.checkElementOrder("instantiatesUri", 10, position, true);
                            builder.instantiatesUri(this.parseUri("instantiatesUri", reader, instantiatesUriElementIndex++));
                            break block0;
                        }
                        case "basedOn": {
                            position = XMLSupport.checkElementOrder("basedOn", 11, position, true);
                            builder.basedOn(this.parseReference("basedOn", reader, basedOnElementIndex++));
                            break block0;
                        }
                        case "replaces": {
                            position = XMLSupport.checkElementOrder("replaces", 12, position, true);
                            builder.replaces(this.parseReference("replaces", reader, replacesElementIndex++));
                            break block0;
                        }
                        case "partOf": {
                            position = XMLSupport.checkElementOrder("partOf", 13, position, true);
                            builder.partOf(this.parseReference("partOf", reader, partOfElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 14, position, false);
                            builder.status((CarePlanStatus)this.parseString(CarePlanStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "intent": {
                            position = XMLSupport.checkElementOrder("intent", 15, position, false);
                            builder.intent((CarePlanIntent)this.parseString(CarePlanIntent.builder(), "intent", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 16, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 17, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 18, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 19, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 20, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 21, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                        case "created": {
                            position = XMLSupport.checkElementOrder("created", 22, position, false);
                            builder.created(this.parseDateTime("created", reader, -1));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 23, position, false);
                            builder.author(this.parseReference("author", reader, -1));
                            break block0;
                        }
                        case "contributor": {
                            position = XMLSupport.checkElementOrder("contributor", 24, position, true);
                            builder.contributor(this.parseReference("contributor", reader, contributorElementIndex++));
                            break block0;
                        }
                        case "careTeam": {
                            position = XMLSupport.checkElementOrder("careTeam", 25, position, true);
                            builder.careTeam(this.parseReference("careTeam", reader, careTeamElementIndex++));
                            break block0;
                        }
                        case "addresses": {
                            position = XMLSupport.checkElementOrder("addresses", 26, position, true);
                            builder.addresses(this.parseReference("addresses", reader, addressesElementIndex++));
                            break block0;
                        }
                        case "supportingInfo": {
                            position = XMLSupport.checkElementOrder("supportingInfo", 27, position, true);
                            builder.supportingInfo(this.parseReference("supportingInfo", reader, supportingInfoElementIndex++));
                            break block0;
                        }
                        case "goal": {
                            position = XMLSupport.checkElementOrder("goal", 28, position, true);
                            builder.goal(this.parseReference("goal", reader, goalElementIndex++));
                            break block0;
                        }
                        case "activity": {
                            position = XMLSupport.checkElementOrder("activity", 29, position, true);
                            builder.activity(this.parseCarePlanActivity("activity", reader, activityElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 30, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CarePlan.Activity parseCarePlanActivity(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CarePlan.Activity.Builder builder = CarePlan.Activity.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int outcomeCodeableConceptElementIndex = 0;
        int outcomeReferenceElementIndex = 0;
        int progressElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "outcomeCodeableConcept": {
                            position = XMLSupport.checkElementOrder("outcomeCodeableConcept", 2, position, true);
                            builder.outcomeCodeableConcept(this.parseCodeableConcept("outcomeCodeableConcept", reader, outcomeCodeableConceptElementIndex++));
                            break block0;
                        }
                        case "outcomeReference": {
                            position = XMLSupport.checkElementOrder("outcomeReference", 3, position, true);
                            builder.outcomeReference(this.parseReference("outcomeReference", reader, outcomeReferenceElementIndex++));
                            break block0;
                        }
                        case "progress": {
                            position = XMLSupport.checkElementOrder("progress", 4, position, true);
                            builder.progress(this.parseAnnotation("progress", reader, progressElementIndex++));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 5, position, false);
                            builder.reference(this.parseReference("reference", reader, -1));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 6, position, false);
                            builder.detail(this.parseCarePlanActivityDetail("detail", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CarePlan.Activity.Detail parseCarePlanActivityDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CarePlan.Activity.Detail.Builder builder = CarePlan.Activity.Detail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int instantiatesCanonicalElementIndex = 0;
        int instantiatesUriElementIndex = 0;
        int reasonCodeElementIndex = 0;
        int reasonReferenceElementIndex = 0;
        int goalElementIndex = 0;
        int performerElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "kind": {
                            position = XMLSupport.checkElementOrder("kind", 2, position, false);
                            builder.kind((CarePlanActivityKind)this.parseString(CarePlanActivityKind.builder(), "kind", reader, -1));
                            break block0;
                        }
                        case "instantiatesCanonical": {
                            position = XMLSupport.checkElementOrder("instantiatesCanonical", 3, position, true);
                            builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", reader, instantiatesCanonicalElementIndex++));
                            break block0;
                        }
                        case "instantiatesUri": {
                            position = XMLSupport.checkElementOrder("instantiatesUri", 4, position, true);
                            builder.instantiatesUri(this.parseUri("instantiatesUri", reader, instantiatesUriElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 5, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "reasonCode": {
                            position = XMLSupport.checkElementOrder("reasonCode", 6, position, true);
                            builder.reasonCode(this.parseCodeableConcept("reasonCode", reader, reasonCodeElementIndex++));
                            break block0;
                        }
                        case "reasonReference": {
                            position = XMLSupport.checkElementOrder("reasonReference", 7, position, true);
                            builder.reasonReference(this.parseReference("reasonReference", reader, reasonReferenceElementIndex++));
                            break block0;
                        }
                        case "goal": {
                            position = XMLSupport.checkElementOrder("goal", 8, position, true);
                            builder.goal(this.parseReference("goal", reader, goalElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((CarePlanActivityStatus)this.parseString(CarePlanActivityStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "statusReason": {
                            position = XMLSupport.checkElementOrder("statusReason", 10, position, false);
                            builder.statusReason(this.parseCodeableConcept("statusReason", reader, -1));
                            break block0;
                        }
                        case "doNotPerform": {
                            position = XMLSupport.checkElementOrder("doNotPerform", 11, position, false);
                            builder.doNotPerform(this.parseBoolean("doNotPerform", reader, -1));
                            break block0;
                        }
                        case "scheduledTiming": {
                            position = XMLSupport.checkElementOrder("scheduled[x]", 12, position, false);
                            builder.scheduled(this.parseTiming("scheduledTiming", reader, -1));
                            break block0;
                        }
                        case "scheduledPeriod": {
                            position = XMLSupport.checkElementOrder("scheduled[x]", 12, position, false);
                            builder.scheduled(this.parsePeriod("scheduledPeriod", reader, -1));
                            break block0;
                        }
                        case "scheduledString": {
                            position = XMLSupport.checkElementOrder("scheduled[x]", 12, position, false);
                            builder.scheduled(this.parseString("scheduledString", reader, -1));
                            break block0;
                        }
                        case "location": {
                            position = XMLSupport.checkElementOrder("location", 13, position, false);
                            builder.location(this.parseReference("location", reader, -1));
                            break block0;
                        }
                        case "performer": {
                            position = XMLSupport.checkElementOrder("performer", 14, position, true);
                            builder.performer(this.parseReference("performer", reader, performerElementIndex++));
                            break block0;
                        }
                        case "productCodeableConcept": {
                            position = XMLSupport.checkElementOrder("product[x]", 15, position, false);
                            builder.product(this.parseCodeableConcept("productCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "productReference": {
                            position = XMLSupport.checkElementOrder("product[x]", 15, position, false);
                            builder.product(this.parseReference("productReference", reader, -1));
                            break block0;
                        }
                        case "dailyAmount": {
                            position = XMLSupport.checkElementOrder("dailyAmount", 16, position, false);
                            builder.dailyAmount((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "dailyAmount", reader, -1));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 17, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 18, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CareTeam parseCareTeam(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CareTeam.Builder builder = CareTeam.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int categoryElementIndex = 0;
        int participantElementIndex = 0;
        int reasonCodeElementIndex = 0;
        int reasonReferenceElementIndex = 0;
        int managingOrganizationElementIndex = 0;
        int telecomElementIndex = 0;
        int noteElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((CareTeamStatus)this.parseString(CareTeamStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 10, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 11, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 12, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 13, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 14, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                        case "participant": {
                            position = XMLSupport.checkElementOrder("participant", 15, position, true);
                            builder.participant(this.parseCareTeamParticipant("participant", reader, participantElementIndex++));
                            break block0;
                        }
                        case "reasonCode": {
                            position = XMLSupport.checkElementOrder("reasonCode", 16, position, true);
                            builder.reasonCode(this.parseCodeableConcept("reasonCode", reader, reasonCodeElementIndex++));
                            break block0;
                        }
                        case "reasonReference": {
                            position = XMLSupport.checkElementOrder("reasonReference", 17, position, true);
                            builder.reasonReference(this.parseReference("reasonReference", reader, reasonReferenceElementIndex++));
                            break block0;
                        }
                        case "managingOrganization": {
                            position = XMLSupport.checkElementOrder("managingOrganization", 18, position, true);
                            builder.managingOrganization(this.parseReference("managingOrganization", reader, managingOrganizationElementIndex++));
                            break block0;
                        }
                        case "telecom": {
                            position = XMLSupport.checkElementOrder("telecom", 19, position, true);
                            builder.telecom(this.parseContactPoint("telecom", reader, telecomElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 20, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CareTeam.Participant parseCareTeamParticipant(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CareTeam.Participant.Builder builder = CareTeam.Participant.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int roleElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 2, position, true);
                            builder.role(this.parseCodeableConcept("role", reader, roleElementIndex++));
                            break block0;
                        }
                        case "member": {
                            position = XMLSupport.checkElementOrder("member", 3, position, false);
                            builder.member(this.parseReference("member", reader, -1));
                            break block0;
                        }
                        case "onBehalfOf": {
                            position = XMLSupport.checkElementOrder("onBehalfOf", 4, position, false);
                            builder.onBehalfOf(this.parseReference("onBehalfOf", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 5, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CatalogEntry parseCatalogEntry(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CatalogEntry.Builder builder = CatalogEntry.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int additionalIdentifierElementIndex = 0;
        int classificationElementIndex = 0;
        int additionalCharacteristicElementIndex = 0;
        int additionalClassificationElementIndex = 0;
        int relatedEntryElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 9, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "orderable": {
                            position = XMLSupport.checkElementOrder("orderable", 10, position, false);
                            builder.orderable(this.parseBoolean("orderable", reader, -1));
                            break block0;
                        }
                        case "referencedItem": {
                            position = XMLSupport.checkElementOrder("referencedItem", 11, position, false);
                            builder.referencedItem(this.parseReference("referencedItem", reader, -1));
                            break block0;
                        }
                        case "additionalIdentifier": {
                            position = XMLSupport.checkElementOrder("additionalIdentifier", 12, position, true);
                            builder.additionalIdentifier(this.parseIdentifier("additionalIdentifier", reader, additionalIdentifierElementIndex++));
                            break block0;
                        }
                        case "classification": {
                            position = XMLSupport.checkElementOrder("classification", 13, position, true);
                            builder.classification(this.parseCodeableConcept("classification", reader, classificationElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 14, position, false);
                            builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "validityPeriod": {
                            position = XMLSupport.checkElementOrder("validityPeriod", 15, position, false);
                            builder.validityPeriod(this.parsePeriod("validityPeriod", reader, -1));
                            break block0;
                        }
                        case "validTo": {
                            position = XMLSupport.checkElementOrder("validTo", 16, position, false);
                            builder.validTo(this.parseDateTime("validTo", reader, -1));
                            break block0;
                        }
                        case "lastUpdated": {
                            position = XMLSupport.checkElementOrder("lastUpdated", 17, position, false);
                            builder.lastUpdated(this.parseDateTime("lastUpdated", reader, -1));
                            break block0;
                        }
                        case "additionalCharacteristic": {
                            position = XMLSupport.checkElementOrder("additionalCharacteristic", 18, position, true);
                            builder.additionalCharacteristic(this.parseCodeableConcept("additionalCharacteristic", reader, additionalCharacteristicElementIndex++));
                            break block0;
                        }
                        case "additionalClassification": {
                            position = XMLSupport.checkElementOrder("additionalClassification", 19, position, true);
                            builder.additionalClassification(this.parseCodeableConcept("additionalClassification", reader, additionalClassificationElementIndex++));
                            break block0;
                        }
                        case "relatedEntry": {
                            position = XMLSupport.checkElementOrder("relatedEntry", 20, position, true);
                            builder.relatedEntry(this.parseCatalogEntryRelatedEntry("relatedEntry", reader, relatedEntryElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CatalogEntry.RelatedEntry parseCatalogEntryRelatedEntry(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CatalogEntry.RelatedEntry.Builder builder = CatalogEntry.RelatedEntry.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "relationtype": {
                            position = XMLSupport.checkElementOrder("relationtype", 2, position, false);
                            builder.relationtype((CatalogEntryRelationType)this.parseString(CatalogEntryRelationType.builder(), "relationtype", reader, -1));
                            break block0;
                        }
                        case "item": {
                            position = XMLSupport.checkElementOrder("item", 3, position, false);
                            builder.item(this.parseReference("item", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ChargeItem parseChargeItem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ChargeItem.Builder builder = ChargeItem.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int definitionUriElementIndex = 0;
        int definitionCanonicalElementIndex = 0;
        int partOfElementIndex = 0;
        int performerElementIndex = 0;
        int bodysiteElementIndex = 0;
        int reasonElementIndex = 0;
        int serviceElementIndex = 0;
        int accountElementIndex = 0;
        int noteElementIndex = 0;
        int supportingInformationElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "definitionUri": {
                            position = XMLSupport.checkElementOrder("definitionUri", 9, position, true);
                            builder.definitionUri(this.parseUri("definitionUri", reader, definitionUriElementIndex++));
                            break block0;
                        }
                        case "definitionCanonical": {
                            position = XMLSupport.checkElementOrder("definitionCanonical", 10, position, true);
                            builder.definitionCanonical((Canonical)this.parseUri(Canonical.builder(), "definitionCanonical", reader, definitionCanonicalElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 11, position, false);
                            builder.status((ChargeItemStatus)this.parseString(ChargeItemStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "partOf": {
                            position = XMLSupport.checkElementOrder("partOf", 12, position, true);
                            builder.partOf(this.parseReference("partOf", reader, partOfElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 13, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 14, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "context": {
                            position = XMLSupport.checkElementOrder("context", 15, position, false);
                            builder.context(this.parseReference("context", reader, -1));
                            break block0;
                        }
                        case "occurrenceDateTime": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 16, position, false);
                            builder.occurrence(this.parseDateTime("occurrenceDateTime", reader, -1));
                            break block0;
                        }
                        case "occurrencePeriod": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 16, position, false);
                            builder.occurrence(this.parsePeriod("occurrencePeriod", reader, -1));
                            break block0;
                        }
                        case "occurrenceTiming": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 16, position, false);
                            builder.occurrence(this.parseTiming("occurrenceTiming", reader, -1));
                            break block0;
                        }
                        case "performer": {
                            position = XMLSupport.checkElementOrder("performer", 17, position, true);
                            builder.performer(this.parseChargeItemPerformer("performer", reader, performerElementIndex++));
                            break block0;
                        }
                        case "performingOrganization": {
                            position = XMLSupport.checkElementOrder("performingOrganization", 18, position, false);
                            builder.performingOrganization(this.parseReference("performingOrganization", reader, -1));
                            break block0;
                        }
                        case "requestingOrganization": {
                            position = XMLSupport.checkElementOrder("requestingOrganization", 19, position, false);
                            builder.requestingOrganization(this.parseReference("requestingOrganization", reader, -1));
                            break block0;
                        }
                        case "costCenter": {
                            position = XMLSupport.checkElementOrder("costCenter", 20, position, false);
                            builder.costCenter(this.parseReference("costCenter", reader, -1));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 21, position, false);
                            builder.quantity(this.parseQuantity("quantity", reader, -1));
                            break block0;
                        }
                        case "bodysite": {
                            position = XMLSupport.checkElementOrder("bodysite", 22, position, true);
                            builder.bodysite(this.parseCodeableConcept("bodysite", reader, bodysiteElementIndex++));
                            break block0;
                        }
                        case "factorOverride": {
                            position = XMLSupport.checkElementOrder("factorOverride", 23, position, false);
                            builder.factorOverride(this.parseDecimal("factorOverride", reader, -1));
                            break block0;
                        }
                        case "priceOverride": {
                            position = XMLSupport.checkElementOrder("priceOverride", 24, position, false);
                            builder.priceOverride(this.parseMoney("priceOverride", reader, -1));
                            break block0;
                        }
                        case "overrideReason": {
                            position = XMLSupport.checkElementOrder("overrideReason", 25, position, false);
                            builder.overrideReason(this.parseString("overrideReason", reader, -1));
                            break block0;
                        }
                        case "enterer": {
                            position = XMLSupport.checkElementOrder("enterer", 26, position, false);
                            builder.enterer(this.parseReference("enterer", reader, -1));
                            break block0;
                        }
                        case "enteredDate": {
                            position = XMLSupport.checkElementOrder("enteredDate", 27, position, false);
                            builder.enteredDate(this.parseDateTime("enteredDate", reader, -1));
                            break block0;
                        }
                        case "reason": {
                            position = XMLSupport.checkElementOrder("reason", 28, position, true);
                            builder.reason(this.parseCodeableConcept("reason", reader, reasonElementIndex++));
                            break block0;
                        }
                        case "service": {
                            position = XMLSupport.checkElementOrder("service", 29, position, true);
                            builder.service(this.parseReference("service", reader, serviceElementIndex++));
                            break block0;
                        }
                        case "productReference": {
                            position = XMLSupport.checkElementOrder("product[x]", 30, position, false);
                            builder.product(this.parseReference("productReference", reader, -1));
                            break block0;
                        }
                        case "productCodeableConcept": {
                            position = XMLSupport.checkElementOrder("product[x]", 30, position, false);
                            builder.product(this.parseCodeableConcept("productCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "account": {
                            position = XMLSupport.checkElementOrder("account", 31, position, true);
                            builder.account(this.parseReference("account", reader, accountElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 32, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                        case "supportingInformation": {
                            position = XMLSupport.checkElementOrder("supportingInformation", 33, position, true);
                            builder.supportingInformation(this.parseReference("supportingInformation", reader, supportingInformationElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ChargeItem.Performer parseChargeItemPerformer(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ChargeItem.Performer.Builder builder = ChargeItem.Performer.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "function": {
                            position = XMLSupport.checkElementOrder("function", 2, position, false);
                            builder.function(this.parseCodeableConcept("function", reader, -1));
                            break block0;
                        }
                        case "actor": {
                            position = XMLSupport.checkElementOrder("actor", 3, position, false);
                            builder.actor(this.parseReference("actor", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ChargeItemDefinition parseChargeItemDefinition(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ChargeItemDefinition.Builder builder = ChargeItemDefinition.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int derivedFromUriElementIndex = 0;
        int partOfElementIndex = 0;
        int replacesElementIndex = 0;
        int contactElementIndex = 0;
        int useContextElementIndex = 0;
        int jurisdictionElementIndex = 0;
        int instanceElementIndex = 0;
        int applicabilityElementIndex = 0;
        int propertyGroupElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 8, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 9, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 10, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 11, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "derivedFromUri": {
                            position = XMLSupport.checkElementOrder("derivedFromUri", 12, position, true);
                            builder.derivedFromUri(this.parseUri("derivedFromUri", reader, derivedFromUriElementIndex++));
                            break block0;
                        }
                        case "partOf": {
                            position = XMLSupport.checkElementOrder("partOf", 13, position, true);
                            builder.partOf((Canonical)this.parseUri(Canonical.builder(), "partOf", reader, partOfElementIndex++));
                            break block0;
                        }
                        case "replaces": {
                            position = XMLSupport.checkElementOrder("replaces", 14, position, true);
                            builder.replaces((Canonical)this.parseUri(Canonical.builder(), "replaces", reader, replacesElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 15, position, false);
                            builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "experimental": {
                            position = XMLSupport.checkElementOrder("experimental", 16, position, false);
                            builder.experimental(this.parseBoolean("experimental", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 17, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "publisher": {
                            position = XMLSupport.checkElementOrder("publisher", 18, position, false);
                            builder.publisher(this.parseString("publisher", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 19, position, true);
                            builder.contact(this.parseContactDetail("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 20, position, false);
                            builder.description((Markdown)this.parseString(Markdown.builder(), "description", reader, -1));
                            break block0;
                        }
                        case "useContext": {
                            position = XMLSupport.checkElementOrder("useContext", 21, position, true);
                            builder.useContext(this.parseUsageContext("useContext", reader, useContextElementIndex++));
                            break block0;
                        }
                        case "jurisdiction": {
                            position = XMLSupport.checkElementOrder("jurisdiction", 22, position, true);
                            builder.jurisdiction(this.parseCodeableConcept("jurisdiction", reader, jurisdictionElementIndex++));
                            break block0;
                        }
                        case "copyright": {
                            position = XMLSupport.checkElementOrder("copyright", 23, position, false);
                            builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", reader, -1));
                            break block0;
                        }
                        case "approvalDate": {
                            position = XMLSupport.checkElementOrder("approvalDate", 24, position, false);
                            builder.approvalDate(this.parseDate("approvalDate", reader, -1));
                            break block0;
                        }
                        case "lastReviewDate": {
                            position = XMLSupport.checkElementOrder("lastReviewDate", 25, position, false);
                            builder.lastReviewDate(this.parseDate("lastReviewDate", reader, -1));
                            break block0;
                        }
                        case "effectivePeriod": {
                            position = XMLSupport.checkElementOrder("effectivePeriod", 26, position, false);
                            builder.effectivePeriod(this.parsePeriod("effectivePeriod", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 27, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "instance": {
                            position = XMLSupport.checkElementOrder("instance", 28, position, true);
                            builder.instance(this.parseReference("instance", reader, instanceElementIndex++));
                            break block0;
                        }
                        case "applicability": {
                            position = XMLSupport.checkElementOrder("applicability", 29, position, true);
                            builder.applicability(this.parseChargeItemDefinitionApplicability("applicability", reader, applicabilityElementIndex++));
                            break block0;
                        }
                        case "propertyGroup": {
                            position = XMLSupport.checkElementOrder("propertyGroup", 30, position, true);
                            builder.propertyGroup(this.parseChargeItemDefinitionPropertyGroup("propertyGroup", reader, propertyGroupElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ChargeItemDefinition.Applicability parseChargeItemDefinitionApplicability(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ChargeItemDefinition.Applicability.Builder builder = ChargeItemDefinition.Applicability.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 2, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language(this.parseString("language", reader, -1));
                            break block0;
                        }
                        case "expression": {
                            position = XMLSupport.checkElementOrder("expression", 4, position, false);
                            builder.expression(this.parseString("expression", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ChargeItemDefinition.PropertyGroup parseChargeItemDefinitionPropertyGroup(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ChargeItemDefinition.PropertyGroup.Builder builder = ChargeItemDefinition.PropertyGroup.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int applicabilityElementIndex = 0;
        int priceComponentElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "applicability": {
                            position = XMLSupport.checkElementOrder("applicability", 2, position, true);
                            builder.applicability(this.parseChargeItemDefinitionApplicability("applicability", reader, applicabilityElementIndex++));
                            break block0;
                        }
                        case "priceComponent": {
                            position = XMLSupport.checkElementOrder("priceComponent", 3, position, true);
                            builder.priceComponent(this.parseChargeItemDefinitionPropertyGroupPriceComponent("priceComponent", reader, priceComponentElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ChargeItemDefinition.PropertyGroup.PriceComponent parseChargeItemDefinitionPropertyGroupPriceComponent(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ChargeItemDefinition.PropertyGroup.PriceComponent.Builder builder = ChargeItemDefinition.PropertyGroup.PriceComponent.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type((ChargeItemDefinitionPriceComponentType)this.parseString(ChargeItemDefinitionPriceComponentType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 3, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 4, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "amount": {
                            position = XMLSupport.checkElementOrder("amount", 5, position, false);
                            builder.amount(this.parseMoney("amount", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim parseClaim(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Builder builder = Claim.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int relatedElementIndex = 0;
        int careTeamElementIndex = 0;
        int supportingInfoElementIndex = 0;
        int diagnosisElementIndex = 0;
        int procedureElementIndex = 0;
        int insuranceElementIndex = 0;
        int itemElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((ClaimStatus)this.parseString(ClaimStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 10, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "subType": {
                            position = XMLSupport.checkElementOrder("subType", 11, position, false);
                            builder.subType(this.parseCodeableConcept("subType", reader, -1));
                            break block0;
                        }
                        case "use": {
                            position = XMLSupport.checkElementOrder("use", 12, position, false);
                            builder.use((Use)this.parseString(Use.builder(), "use", reader, -1));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 13, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "billablePeriod": {
                            position = XMLSupport.checkElementOrder("billablePeriod", 14, position, false);
                            builder.billablePeriod(this.parsePeriod("billablePeriod", reader, -1));
                            break block0;
                        }
                        case "created": {
                            position = XMLSupport.checkElementOrder("created", 15, position, false);
                            builder.created(this.parseDateTime("created", reader, -1));
                            break block0;
                        }
                        case "enterer": {
                            position = XMLSupport.checkElementOrder("enterer", 16, position, false);
                            builder.enterer(this.parseReference("enterer", reader, -1));
                            break block0;
                        }
                        case "insurer": {
                            position = XMLSupport.checkElementOrder("insurer", 17, position, false);
                            builder.insurer(this.parseReference("insurer", reader, -1));
                            break block0;
                        }
                        case "provider": {
                            position = XMLSupport.checkElementOrder("provider", 18, position, false);
                            builder.provider(this.parseReference("provider", reader, -1));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 19, position, false);
                            builder.priority(this.parseCodeableConcept("priority", reader, -1));
                            break block0;
                        }
                        case "fundsReserve": {
                            position = XMLSupport.checkElementOrder("fundsReserve", 20, position, false);
                            builder.fundsReserve(this.parseCodeableConcept("fundsReserve", reader, -1));
                            break block0;
                        }
                        case "related": {
                            position = XMLSupport.checkElementOrder("related", 21, position, true);
                            builder.related(this.parseClaimRelated("related", reader, relatedElementIndex++));
                            break block0;
                        }
                        case "prescription": {
                            position = XMLSupport.checkElementOrder("prescription", 22, position, false);
                            builder.prescription(this.parseReference("prescription", reader, -1));
                            break block0;
                        }
                        case "originalPrescription": {
                            position = XMLSupport.checkElementOrder("originalPrescription", 23, position, false);
                            builder.originalPrescription(this.parseReference("originalPrescription", reader, -1));
                            break block0;
                        }
                        case "payee": {
                            position = XMLSupport.checkElementOrder("payee", 24, position, false);
                            builder.payee(this.parseClaimPayee("payee", reader, -1));
                            break block0;
                        }
                        case "referral": {
                            position = XMLSupport.checkElementOrder("referral", 25, position, false);
                            builder.referral(this.parseReference("referral", reader, -1));
                            break block0;
                        }
                        case "facility": {
                            position = XMLSupport.checkElementOrder("facility", 26, position, false);
                            builder.facility(this.parseReference("facility", reader, -1));
                            break block0;
                        }
                        case "careTeam": {
                            position = XMLSupport.checkElementOrder("careTeam", 27, position, true);
                            builder.careTeam(this.parseClaimCareTeam("careTeam", reader, careTeamElementIndex++));
                            break block0;
                        }
                        case "supportingInfo": {
                            position = XMLSupport.checkElementOrder("supportingInfo", 28, position, true);
                            builder.supportingInfo(this.parseClaimSupportingInfo("supportingInfo", reader, supportingInfoElementIndex++));
                            break block0;
                        }
                        case "diagnosis": {
                            position = XMLSupport.checkElementOrder("diagnosis", 29, position, true);
                            builder.diagnosis(this.parseClaimDiagnosis("diagnosis", reader, diagnosisElementIndex++));
                            break block0;
                        }
                        case "procedure": {
                            position = XMLSupport.checkElementOrder("procedure", 30, position, true);
                            builder.procedure(this.parseClaimProcedure("procedure", reader, procedureElementIndex++));
                            break block0;
                        }
                        case "insurance": {
                            position = XMLSupport.checkElementOrder("insurance", 31, position, true);
                            builder.insurance(this.parseClaimInsurance("insurance", reader, insuranceElementIndex++));
                            break block0;
                        }
                        case "accident": {
                            position = XMLSupport.checkElementOrder("accident", 32, position, false);
                            builder.accident(this.parseClaimAccident("accident", reader, -1));
                            break block0;
                        }
                        case "item": {
                            position = XMLSupport.checkElementOrder("item", 33, position, true);
                            builder.item(this.parseClaimItem("item", reader, itemElementIndex++));
                            break block0;
                        }
                        case "total": {
                            position = XMLSupport.checkElementOrder("total", 34, position, false);
                            builder.total(this.parseMoney("total", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Accident parseClaimAccident(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Accident.Builder builder = Claim.Accident.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 2, position, false);
                            builder.date(this.parseDate("date", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "locationAddress": {
                            position = XMLSupport.checkElementOrder("location[x]", 4, position, false);
                            builder.location(this.parseAddress("locationAddress", reader, -1));
                            break block0;
                        }
                        case "locationReference": {
                            position = XMLSupport.checkElementOrder("location[x]", 4, position, false);
                            builder.location(this.parseReference("locationReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.CareTeam parseClaimCareTeam(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.CareTeam.Builder builder = Claim.CareTeam.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "provider": {
                            position = XMLSupport.checkElementOrder("provider", 3, position, false);
                            builder.provider(this.parseReference("provider", reader, -1));
                            break block0;
                        }
                        case "responsible": {
                            position = XMLSupport.checkElementOrder("responsible", 4, position, false);
                            builder.responsible(this.parseBoolean("responsible", reader, -1));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 5, position, false);
                            builder.role(this.parseCodeableConcept("role", reader, -1));
                            break block0;
                        }
                        case "qualification": {
                            position = XMLSupport.checkElementOrder("qualification", 6, position, false);
                            builder.qualification(this.parseCodeableConcept("qualification", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Diagnosis parseClaimDiagnosis(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Diagnosis.Builder builder = Claim.Diagnosis.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int typeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "diagnosisCodeableConcept": {
                            position = XMLSupport.checkElementOrder("diagnosis[x]", 3, position, false);
                            builder.diagnosis(this.parseCodeableConcept("diagnosisCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "diagnosisReference": {
                            position = XMLSupport.checkElementOrder("diagnosis[x]", 3, position, false);
                            builder.diagnosis(this.parseReference("diagnosisReference", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 4, position, true);
                            builder.type(this.parseCodeableConcept("type", reader, typeElementIndex++));
                            break block0;
                        }
                        case "onAdmission": {
                            position = XMLSupport.checkElementOrder("onAdmission", 5, position, false);
                            builder.onAdmission(this.parseCodeableConcept("onAdmission", reader, -1));
                            break block0;
                        }
                        case "packageCode": {
                            position = XMLSupport.checkElementOrder("packageCode", 6, position, false);
                            builder.packageCode(this.parseCodeableConcept("packageCode", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Insurance parseClaimInsurance(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Insurance.Builder builder = Claim.Insurance.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int preAuthRefElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "focal": {
                            position = XMLSupport.checkElementOrder("focal", 3, position, false);
                            builder.focal(this.parseBoolean("focal", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 4, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                        case "coverage": {
                            position = XMLSupport.checkElementOrder("coverage", 5, position, false);
                            builder.coverage(this.parseReference("coverage", reader, -1));
                            break block0;
                        }
                        case "businessArrangement": {
                            position = XMLSupport.checkElementOrder("businessArrangement", 6, position, false);
                            builder.businessArrangement(this.parseString("businessArrangement", reader, -1));
                            break block0;
                        }
                        case "preAuthRef": {
                            position = XMLSupport.checkElementOrder("preAuthRef", 7, position, true);
                            builder.preAuthRef(this.parseString("preAuthRef", reader, preAuthRefElementIndex++));
                            break block0;
                        }
                        case "claimResponse": {
                            position = XMLSupport.checkElementOrder("claimResponse", 8, position, false);
                            builder.claimResponse(this.parseReference("claimResponse", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Item parseClaimItem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Item.Builder builder = Claim.Item.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int careTeamSequenceElementIndex = 0;
        int diagnosisSequenceElementIndex = 0;
        int procedureSequenceElementIndex = 0;
        int informationSequenceElementIndex = 0;
        int modifierElementIndex = 0;
        int programCodeElementIndex = 0;
        int udiElementIndex = 0;
        int subSiteElementIndex = 0;
        int encounterElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "careTeamSequence": {
                            position = XMLSupport.checkElementOrder("careTeamSequence", 3, position, true);
                            builder.careTeamSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "careTeamSequence", reader, careTeamSequenceElementIndex++));
                            break block0;
                        }
                        case "diagnosisSequence": {
                            position = XMLSupport.checkElementOrder("diagnosisSequence", 4, position, true);
                            builder.diagnosisSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "diagnosisSequence", reader, diagnosisSequenceElementIndex++));
                            break block0;
                        }
                        case "procedureSequence": {
                            position = XMLSupport.checkElementOrder("procedureSequence", 5, position, true);
                            builder.procedureSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "procedureSequence", reader, procedureSequenceElementIndex++));
                            break block0;
                        }
                        case "informationSequence": {
                            position = XMLSupport.checkElementOrder("informationSequence", 6, position, true);
                            builder.informationSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "informationSequence", reader, informationSequenceElementIndex++));
                            break block0;
                        }
                        case "revenue": {
                            position = XMLSupport.checkElementOrder("revenue", 7, position, false);
                            builder.revenue(this.parseCodeableConcept("revenue", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 8, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 9, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 10, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "programCode": {
                            position = XMLSupport.checkElementOrder("programCode", 11, position, true);
                            builder.programCode(this.parseCodeableConcept("programCode", reader, programCodeElementIndex++));
                            break block0;
                        }
                        case "servicedDate": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 12, position, false);
                            builder.serviced(this.parseDate("servicedDate", reader, -1));
                            break block0;
                        }
                        case "servicedPeriod": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 12, position, false);
                            builder.serviced(this.parsePeriod("servicedPeriod", reader, -1));
                            break block0;
                        }
                        case "locationCodeableConcept": {
                            position = XMLSupport.checkElementOrder("location[x]", 13, position, false);
                            builder.location(this.parseCodeableConcept("locationCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "locationAddress": {
                            position = XMLSupport.checkElementOrder("location[x]", 13, position, false);
                            builder.location(this.parseAddress("locationAddress", reader, -1));
                            break block0;
                        }
                        case "locationReference": {
                            position = XMLSupport.checkElementOrder("location[x]", 13, position, false);
                            builder.location(this.parseReference("locationReference", reader, -1));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 14, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 15, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 16, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "net": {
                            position = XMLSupport.checkElementOrder("net", 17, position, false);
                            builder.net(this.parseMoney("net", reader, -1));
                            break block0;
                        }
                        case "udi": {
                            position = XMLSupport.checkElementOrder("udi", 18, position, true);
                            builder.udi(this.parseReference("udi", reader, udiElementIndex++));
                            break block0;
                        }
                        case "bodySite": {
                            position = XMLSupport.checkElementOrder("bodySite", 19, position, false);
                            builder.bodySite(this.parseCodeableConcept("bodySite", reader, -1));
                            break block0;
                        }
                        case "subSite": {
                            position = XMLSupport.checkElementOrder("subSite", 20, position, true);
                            builder.subSite(this.parseCodeableConcept("subSite", reader, subSiteElementIndex++));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 21, position, true);
                            builder.encounter(this.parseReference("encounter", reader, encounterElementIndex++));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 22, position, true);
                            builder.detail(this.parseClaimItemDetail("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Item.Detail parseClaimItemDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Item.Detail.Builder builder = Claim.Item.Detail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int modifierElementIndex = 0;
        int programCodeElementIndex = 0;
        int udiElementIndex = 0;
        int subDetailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "revenue": {
                            position = XMLSupport.checkElementOrder("revenue", 3, position, false);
                            builder.revenue(this.parseCodeableConcept("revenue", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 4, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 5, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 6, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "programCode": {
                            position = XMLSupport.checkElementOrder("programCode", 7, position, true);
                            builder.programCode(this.parseCodeableConcept("programCode", reader, programCodeElementIndex++));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 8, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 9, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 10, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "net": {
                            position = XMLSupport.checkElementOrder("net", 11, position, false);
                            builder.net(this.parseMoney("net", reader, -1));
                            break block0;
                        }
                        case "udi": {
                            position = XMLSupport.checkElementOrder("udi", 12, position, true);
                            builder.udi(this.parseReference("udi", reader, udiElementIndex++));
                            break block0;
                        }
                        case "subDetail": {
                            position = XMLSupport.checkElementOrder("subDetail", 13, position, true);
                            builder.subDetail(this.parseClaimItemDetailSubDetail("subDetail", reader, subDetailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Item.Detail.SubDetail parseClaimItemDetailSubDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Item.Detail.SubDetail.Builder builder = Claim.Item.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int modifierElementIndex = 0;
        int programCodeElementIndex = 0;
        int udiElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "revenue": {
                            position = XMLSupport.checkElementOrder("revenue", 3, position, false);
                            builder.revenue(this.parseCodeableConcept("revenue", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 4, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 5, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 6, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "programCode": {
                            position = XMLSupport.checkElementOrder("programCode", 7, position, true);
                            builder.programCode(this.parseCodeableConcept("programCode", reader, programCodeElementIndex++));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 8, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 9, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 10, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "net": {
                            position = XMLSupport.checkElementOrder("net", 11, position, false);
                            builder.net(this.parseMoney("net", reader, -1));
                            break block0;
                        }
                        case "udi": {
                            position = XMLSupport.checkElementOrder("udi", 12, position, true);
                            builder.udi(this.parseReference("udi", reader, udiElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Payee parseClaimPayee(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Payee.Builder builder = Claim.Payee.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "party": {
                            position = XMLSupport.checkElementOrder("party", 3, position, false);
                            builder.party(this.parseReference("party", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Procedure parseClaimProcedure(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Procedure.Builder builder = Claim.Procedure.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int typeElementIndex = 0;
        int udiElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, true);
                            builder.type(this.parseCodeableConcept("type", reader, typeElementIndex++));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 4, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "procedureCodeableConcept": {
                            position = XMLSupport.checkElementOrder("procedure[x]", 5, position, false);
                            builder.procedure(this.parseCodeableConcept("procedureCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "procedureReference": {
                            position = XMLSupport.checkElementOrder("procedure[x]", 5, position, false);
                            builder.procedure(this.parseReference("procedureReference", reader, -1));
                            break block0;
                        }
                        case "udi": {
                            position = XMLSupport.checkElementOrder("udi", 6, position, true);
                            builder.udi(this.parseReference("udi", reader, udiElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.Related parseClaimRelated(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.Related.Builder builder = Claim.Related.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "claim": {
                            position = XMLSupport.checkElementOrder("claim", 2, position, false);
                            builder.claim(this.parseReference("claim", reader, -1));
                            break block0;
                        }
                        case "relationship": {
                            position = XMLSupport.checkElementOrder("relationship", 3, position, false);
                            builder.relationship(this.parseCodeableConcept("relationship", reader, -1));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 4, position, false);
                            builder.reference(this.parseIdentifier("reference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Claim.SupportingInfo parseClaimSupportingInfo(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Claim.SupportingInfo.Builder builder = Claim.SupportingInfo.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 3, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 4, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "timingDate": {
                            position = XMLSupport.checkElementOrder("timing[x]", 5, position, false);
                            builder.timing(this.parseDate("timingDate", reader, -1));
                            break block0;
                        }
                        case "timingPeriod": {
                            position = XMLSupport.checkElementOrder("timing[x]", 5, position, false);
                            builder.timing(this.parsePeriod("timingPeriod", reader, -1));
                            break block0;
                        }
                        case "valueBoolean": {
                            position = XMLSupport.checkElementOrder("value[x]", 6, position, false);
                            builder.value(this.parseBoolean("valueBoolean", reader, -1));
                            break block0;
                        }
                        case "valueString": {
                            position = XMLSupport.checkElementOrder("value[x]", 6, position, false);
                            builder.value(this.parseString("valueString", reader, -1));
                            break block0;
                        }
                        case "valueQuantity": {
                            position = XMLSupport.checkElementOrder("value[x]", 6, position, false);
                            builder.value(this.parseQuantity("valueQuantity", reader, -1));
                            break block0;
                        }
                        case "valueAttachment": {
                            position = XMLSupport.checkElementOrder("value[x]", 6, position, false);
                            builder.value(this.parseAttachment("valueAttachment", reader, -1));
                            break block0;
                        }
                        case "valueReference": {
                            position = XMLSupport.checkElementOrder("value[x]", 6, position, false);
                            builder.value(this.parseReference("valueReference", reader, -1));
                            break block0;
                        }
                        case "reason": {
                            position = XMLSupport.checkElementOrder("reason", 7, position, false);
                            builder.reason(this.parseCodeableConcept("reason", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse parseClaimResponse(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Builder builder = ClaimResponse.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int itemElementIndex = 0;
        int addItemElementIndex = 0;
        int adjudicationElementIndex = 0;
        int totalElementIndex = 0;
        int processNoteElementIndex = 0;
        int communicationRequestElementIndex = 0;
        int insuranceElementIndex = 0;
        int errorElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((ClaimResponseStatus)this.parseString(ClaimResponseStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 10, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "subType": {
                            position = XMLSupport.checkElementOrder("subType", 11, position, false);
                            builder.subType(this.parseCodeableConcept("subType", reader, -1));
                            break block0;
                        }
                        case "use": {
                            position = XMLSupport.checkElementOrder("use", 12, position, false);
                            builder.use((Use)this.parseString(Use.builder(), "use", reader, -1));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 13, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "created": {
                            position = XMLSupport.checkElementOrder("created", 14, position, false);
                            builder.created(this.parseDateTime("created", reader, -1));
                            break block0;
                        }
                        case "insurer": {
                            position = XMLSupport.checkElementOrder("insurer", 15, position, false);
                            builder.insurer(this.parseReference("insurer", reader, -1));
                            break block0;
                        }
                        case "requestor": {
                            position = XMLSupport.checkElementOrder("requestor", 16, position, false);
                            builder.requestor(this.parseReference("requestor", reader, -1));
                            break block0;
                        }
                        case "request": {
                            position = XMLSupport.checkElementOrder("request", 17, position, false);
                            builder.request(this.parseReference("request", reader, -1));
                            break block0;
                        }
                        case "outcome": {
                            position = XMLSupport.checkElementOrder("outcome", 18, position, false);
                            builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", reader, -1));
                            break block0;
                        }
                        case "disposition": {
                            position = XMLSupport.checkElementOrder("disposition", 19, position, false);
                            builder.disposition(this.parseString("disposition", reader, -1));
                            break block0;
                        }
                        case "preAuthRef": {
                            position = XMLSupport.checkElementOrder("preAuthRef", 20, position, false);
                            builder.preAuthRef(this.parseString("preAuthRef", reader, -1));
                            break block0;
                        }
                        case "preAuthPeriod": {
                            position = XMLSupport.checkElementOrder("preAuthPeriod", 21, position, false);
                            builder.preAuthPeriod(this.parsePeriod("preAuthPeriod", reader, -1));
                            break block0;
                        }
                        case "payeeType": {
                            position = XMLSupport.checkElementOrder("payeeType", 22, position, false);
                            builder.payeeType(this.parseCodeableConcept("payeeType", reader, -1));
                            break block0;
                        }
                        case "item": {
                            position = XMLSupport.checkElementOrder("item", 23, position, true);
                            builder.item(this.parseClaimResponseItem("item", reader, itemElementIndex++));
                            break block0;
                        }
                        case "addItem": {
                            position = XMLSupport.checkElementOrder("addItem", 24, position, true);
                            builder.addItem(this.parseClaimResponseAddItem("addItem", reader, addItemElementIndex++));
                            break block0;
                        }
                        case "adjudication": {
                            position = XMLSupport.checkElementOrder("adjudication", 25, position, true);
                            builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", reader, adjudicationElementIndex++));
                            break block0;
                        }
                        case "total": {
                            position = XMLSupport.checkElementOrder("total", 26, position, true);
                            builder.total(this.parseClaimResponseTotal("total", reader, totalElementIndex++));
                            break block0;
                        }
                        case "payment": {
                            position = XMLSupport.checkElementOrder("payment", 27, position, false);
                            builder.payment(this.parseClaimResponsePayment("payment", reader, -1));
                            break block0;
                        }
                        case "fundsReserve": {
                            position = XMLSupport.checkElementOrder("fundsReserve", 28, position, false);
                            builder.fundsReserve(this.parseCodeableConcept("fundsReserve", reader, -1));
                            break block0;
                        }
                        case "formCode": {
                            position = XMLSupport.checkElementOrder("formCode", 29, position, false);
                            builder.formCode(this.parseCodeableConcept("formCode", reader, -1));
                            break block0;
                        }
                        case "form": {
                            position = XMLSupport.checkElementOrder("form", 30, position, false);
                            builder.form(this.parseAttachment("form", reader, -1));
                            break block0;
                        }
                        case "processNote": {
                            position = XMLSupport.checkElementOrder("processNote", 31, position, true);
                            builder.processNote(this.parseClaimResponseProcessNote("processNote", reader, processNoteElementIndex++));
                            break block0;
                        }
                        case "communicationRequest": {
                            position = XMLSupport.checkElementOrder("communicationRequest", 32, position, true);
                            builder.communicationRequest(this.parseReference("communicationRequest", reader, communicationRequestElementIndex++));
                            break block0;
                        }
                        case "insurance": {
                            position = XMLSupport.checkElementOrder("insurance", 33, position, true);
                            builder.insurance(this.parseClaimResponseInsurance("insurance", reader, insuranceElementIndex++));
                            break block0;
                        }
                        case "error": {
                            position = XMLSupport.checkElementOrder("error", 34, position, true);
                            builder.error(this.parseClaimResponseError("error", reader, errorElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.AddItem parseClaimResponseAddItem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.AddItem.Builder builder = ClaimResponse.AddItem.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int itemSequenceElementIndex = 0;
        int detailSequenceElementIndex = 0;
        int subdetailSequenceElementIndex = 0;
        int providerElementIndex = 0;
        int modifierElementIndex = 0;
        int programCodeElementIndex = 0;
        int subSiteElementIndex = 0;
        int noteNumberElementIndex = 0;
        int adjudicationElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "itemSequence": {
                            position = XMLSupport.checkElementOrder("itemSequence", 2, position, true);
                            builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", reader, itemSequenceElementIndex++));
                            break block0;
                        }
                        case "detailSequence": {
                            position = XMLSupport.checkElementOrder("detailSequence", 3, position, true);
                            builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", reader, detailSequenceElementIndex++));
                            break block0;
                        }
                        case "subdetailSequence": {
                            position = XMLSupport.checkElementOrder("subdetailSequence", 4, position, true);
                            builder.subdetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subdetailSequence", reader, subdetailSequenceElementIndex++));
                            break block0;
                        }
                        case "provider": {
                            position = XMLSupport.checkElementOrder("provider", 5, position, true);
                            builder.provider(this.parseReference("provider", reader, providerElementIndex++));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 6, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 7, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "programCode": {
                            position = XMLSupport.checkElementOrder("programCode", 8, position, true);
                            builder.programCode(this.parseCodeableConcept("programCode", reader, programCodeElementIndex++));
                            break block0;
                        }
                        case "servicedDate": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 9, position, false);
                            builder.serviced(this.parseDate("servicedDate", reader, -1));
                            break block0;
                        }
                        case "servicedPeriod": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 9, position, false);
                            builder.serviced(this.parsePeriod("servicedPeriod", reader, -1));
                            break block0;
                        }
                        case "locationCodeableConcept": {
                            position = XMLSupport.checkElementOrder("location[x]", 10, position, false);
                            builder.location(this.parseCodeableConcept("locationCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "locationAddress": {
                            position = XMLSupport.checkElementOrder("location[x]", 10, position, false);
                            builder.location(this.parseAddress("locationAddress", reader, -1));
                            break block0;
                        }
                        case "locationReference": {
                            position = XMLSupport.checkElementOrder("location[x]", 10, position, false);
                            builder.location(this.parseReference("locationReference", reader, -1));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 11, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 12, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 13, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "net": {
                            position = XMLSupport.checkElementOrder("net", 14, position, false);
                            builder.net(this.parseMoney("net", reader, -1));
                            break block0;
                        }
                        case "bodySite": {
                            position = XMLSupport.checkElementOrder("bodySite", 15, position, false);
                            builder.bodySite(this.parseCodeableConcept("bodySite", reader, -1));
                            break block0;
                        }
                        case "subSite": {
                            position = XMLSupport.checkElementOrder("subSite", 16, position, true);
                            builder.subSite(this.parseCodeableConcept("subSite", reader, subSiteElementIndex++));
                            break block0;
                        }
                        case "noteNumber": {
                            position = XMLSupport.checkElementOrder("noteNumber", 17, position, true);
                            builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", reader, noteNumberElementIndex++));
                            break block0;
                        }
                        case "adjudication": {
                            position = XMLSupport.checkElementOrder("adjudication", 18, position, true);
                            builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", reader, adjudicationElementIndex++));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 19, position, true);
                            builder.detail(this.parseClaimResponseAddItemDetail("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.AddItem.Detail parseClaimResponseAddItemDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.AddItem.Detail.Builder builder = ClaimResponse.AddItem.Detail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int modifierElementIndex = 0;
        int noteNumberElementIndex = 0;
        int adjudicationElementIndex = 0;
        int subDetailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 2, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 3, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 4, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 5, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 6, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "net": {
                            position = XMLSupport.checkElementOrder("net", 7, position, false);
                            builder.net(this.parseMoney("net", reader, -1));
                            break block0;
                        }
                        case "noteNumber": {
                            position = XMLSupport.checkElementOrder("noteNumber", 8, position, true);
                            builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", reader, noteNumberElementIndex++));
                            break block0;
                        }
                        case "adjudication": {
                            position = XMLSupport.checkElementOrder("adjudication", 9, position, true);
                            builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", reader, adjudicationElementIndex++));
                            break block0;
                        }
                        case "subDetail": {
                            position = XMLSupport.checkElementOrder("subDetail", 10, position, true);
                            builder.subDetail(this.parseClaimResponseAddItemDetailSubDetail("subDetail", reader, subDetailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.AddItem.Detail.SubDetail parseClaimResponseAddItemDetailSubDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.AddItem.Detail.SubDetail.Builder builder = ClaimResponse.AddItem.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int modifierElementIndex = 0;
        int noteNumberElementIndex = 0;
        int adjudicationElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 2, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 3, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 4, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 5, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 6, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "net": {
                            position = XMLSupport.checkElementOrder("net", 7, position, false);
                            builder.net(this.parseMoney("net", reader, -1));
                            break block0;
                        }
                        case "noteNumber": {
                            position = XMLSupport.checkElementOrder("noteNumber", 8, position, true);
                            builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", reader, noteNumberElementIndex++));
                            break block0;
                        }
                        case "adjudication": {
                            position = XMLSupport.checkElementOrder("adjudication", 9, position, true);
                            builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", reader, adjudicationElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Error parseClaimResponseError(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Error.Builder builder = ClaimResponse.Error.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "itemSequence": {
                            position = XMLSupport.checkElementOrder("itemSequence", 2, position, false);
                            builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", reader, -1));
                            break block0;
                        }
                        case "detailSequence": {
                            position = XMLSupport.checkElementOrder("detailSequence", 3, position, false);
                            builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", reader, -1));
                            break block0;
                        }
                        case "subDetailSequence": {
                            position = XMLSupport.checkElementOrder("subDetailSequence", 4, position, false);
                            builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 5, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Insurance parseClaimResponseInsurance(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Insurance.Builder builder = ClaimResponse.Insurance.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "focal": {
                            position = XMLSupport.checkElementOrder("focal", 3, position, false);
                            builder.focal(this.parseBoolean("focal", reader, -1));
                            break block0;
                        }
                        case "coverage": {
                            position = XMLSupport.checkElementOrder("coverage", 4, position, false);
                            builder.coverage(this.parseReference("coverage", reader, -1));
                            break block0;
                        }
                        case "businessArrangement": {
                            position = XMLSupport.checkElementOrder("businessArrangement", 5, position, false);
                            builder.businessArrangement(this.parseString("businessArrangement", reader, -1));
                            break block0;
                        }
                        case "claimResponse": {
                            position = XMLSupport.checkElementOrder("claimResponse", 6, position, false);
                            builder.claimResponse(this.parseReference("claimResponse", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Item parseClaimResponseItem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Item.Builder builder = ClaimResponse.Item.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int noteNumberElementIndex = 0;
        int adjudicationElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "itemSequence": {
                            position = XMLSupport.checkElementOrder("itemSequence", 2, position, false);
                            builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", reader, -1));
                            break block0;
                        }
                        case "noteNumber": {
                            position = XMLSupport.checkElementOrder("noteNumber", 3, position, true);
                            builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", reader, noteNumberElementIndex++));
                            break block0;
                        }
                        case "adjudication": {
                            position = XMLSupport.checkElementOrder("adjudication", 4, position, true);
                            builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", reader, adjudicationElementIndex++));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 5, position, true);
                            builder.detail(this.parseClaimResponseItemDetail("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Item.Adjudication parseClaimResponseItemAdjudication(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Item.Adjudication.Builder builder = ClaimResponse.Item.Adjudication.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 2, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "reason": {
                            position = XMLSupport.checkElementOrder("reason", 3, position, false);
                            builder.reason(this.parseCodeableConcept("reason", reader, -1));
                            break block0;
                        }
                        case "amount": {
                            position = XMLSupport.checkElementOrder("amount", 4, position, false);
                            builder.amount(this.parseMoney("amount", reader, -1));
                            break block0;
                        }
                        case "value": {
                            position = XMLSupport.checkElementOrder("value", 5, position, false);
                            builder.value(this.parseDecimal("value", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Item.Detail parseClaimResponseItemDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Item.Detail.Builder builder = ClaimResponse.Item.Detail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int noteNumberElementIndex = 0;
        int adjudicationElementIndex = 0;
        int subDetailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "detailSequence": {
                            position = XMLSupport.checkElementOrder("detailSequence", 2, position, false);
                            builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", reader, -1));
                            break block0;
                        }
                        case "noteNumber": {
                            position = XMLSupport.checkElementOrder("noteNumber", 3, position, true);
                            builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", reader, noteNumberElementIndex++));
                            break block0;
                        }
                        case "adjudication": {
                            position = XMLSupport.checkElementOrder("adjudication", 4, position, true);
                            builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", reader, adjudicationElementIndex++));
                            break block0;
                        }
                        case "subDetail": {
                            position = XMLSupport.checkElementOrder("subDetail", 5, position, true);
                            builder.subDetail(this.parseClaimResponseItemDetailSubDetail("subDetail", reader, subDetailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Item.Detail.SubDetail parseClaimResponseItemDetailSubDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Item.Detail.SubDetail.Builder builder = ClaimResponse.Item.Detail.SubDetail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int noteNumberElementIndex = 0;
        int adjudicationElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "subDetailSequence": {
                            position = XMLSupport.checkElementOrder("subDetailSequence", 2, position, false);
                            builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", reader, -1));
                            break block0;
                        }
                        case "noteNumber": {
                            position = XMLSupport.checkElementOrder("noteNumber", 3, position, true);
                            builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", reader, noteNumberElementIndex++));
                            break block0;
                        }
                        case "adjudication": {
                            position = XMLSupport.checkElementOrder("adjudication", 4, position, true);
                            builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", reader, adjudicationElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Payment parseClaimResponsePayment(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Payment.Builder builder = ClaimResponse.Payment.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "adjustment": {
                            position = XMLSupport.checkElementOrder("adjustment", 3, position, false);
                            builder.adjustment(this.parseMoney("adjustment", reader, -1));
                            break block0;
                        }
                        case "adjustmentReason": {
                            position = XMLSupport.checkElementOrder("adjustmentReason", 4, position, false);
                            builder.adjustmentReason(this.parseCodeableConcept("adjustmentReason", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 5, position, false);
                            builder.date(this.parseDate("date", reader, -1));
                            break block0;
                        }
                        case "amount": {
                            position = XMLSupport.checkElementOrder("amount", 6, position, false);
                            builder.amount(this.parseMoney("amount", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 7, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.ProcessNote parseClaimResponseProcessNote(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.ProcessNote.Builder builder = ClaimResponse.ProcessNote.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "number": {
                            position = XMLSupport.checkElementOrder("number", 2, position, false);
                            builder.number((PositiveInt)this.parseInteger(PositiveInt.builder(), "number", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, false);
                            builder.type((NoteType)this.parseString(NoteType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseString("text", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 5, position, false);
                            builder.language(this.parseCodeableConcept("language", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClaimResponse.Total parseClaimResponseTotal(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClaimResponse.Total.Builder builder = ClaimResponse.Total.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 2, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "amount": {
                            position = XMLSupport.checkElementOrder("amount", 3, position, false);
                            builder.amount(this.parseMoney("amount", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClinicalImpression parseClinicalImpression(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClinicalImpression.Builder builder = ClinicalImpression.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int problemElementIndex = 0;
        int investigationElementIndex = 0;
        int protocolElementIndex = 0;
        int findingElementIndex = 0;
        int prognosisCodeableConceptElementIndex = 0;
        int prognosisReferenceElementIndex = 0;
        int supportingInfoElementIndex = 0;
        int noteElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((ClinicalImpressionStatus)this.parseString(ClinicalImpressionStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "statusReason": {
                            position = XMLSupport.checkElementOrder("statusReason", 10, position, false);
                            builder.statusReason(this.parseCodeableConcept("statusReason", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 11, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 12, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 13, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 14, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "effectiveDateTime": {
                            position = XMLSupport.checkElementOrder("effective[x]", 15, position, false);
                            builder.effective(this.parseDateTime("effectiveDateTime", reader, -1));
                            break block0;
                        }
                        case "effectivePeriod": {
                            position = XMLSupport.checkElementOrder("effective[x]", 15, position, false);
                            builder.effective(this.parsePeriod("effectivePeriod", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 16, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "assessor": {
                            position = XMLSupport.checkElementOrder("assessor", 17, position, false);
                            builder.assessor(this.parseReference("assessor", reader, -1));
                            break block0;
                        }
                        case "previous": {
                            position = XMLSupport.checkElementOrder("previous", 18, position, false);
                            builder.previous(this.parseReference("previous", reader, -1));
                            break block0;
                        }
                        case "problem": {
                            position = XMLSupport.checkElementOrder("problem", 19, position, true);
                            builder.problem(this.parseReference("problem", reader, problemElementIndex++));
                            break block0;
                        }
                        case "investigation": {
                            position = XMLSupport.checkElementOrder("investigation", 20, position, true);
                            builder.investigation(this.parseClinicalImpressionInvestigation("investigation", reader, investigationElementIndex++));
                            break block0;
                        }
                        case "protocol": {
                            position = XMLSupport.checkElementOrder("protocol", 21, position, true);
                            builder.protocol(this.parseUri("protocol", reader, protocolElementIndex++));
                            break block0;
                        }
                        case "summary": {
                            position = XMLSupport.checkElementOrder("summary", 22, position, false);
                            builder.summary(this.parseString("summary", reader, -1));
                            break block0;
                        }
                        case "finding": {
                            position = XMLSupport.checkElementOrder("finding", 23, position, true);
                            builder.finding(this.parseClinicalImpressionFinding("finding", reader, findingElementIndex++));
                            break block0;
                        }
                        case "prognosisCodeableConcept": {
                            position = XMLSupport.checkElementOrder("prognosisCodeableConcept", 24, position, true);
                            builder.prognosisCodeableConcept(this.parseCodeableConcept("prognosisCodeableConcept", reader, prognosisCodeableConceptElementIndex++));
                            break block0;
                        }
                        case "prognosisReference": {
                            position = XMLSupport.checkElementOrder("prognosisReference", 25, position, true);
                            builder.prognosisReference(this.parseReference("prognosisReference", reader, prognosisReferenceElementIndex++));
                            break block0;
                        }
                        case "supportingInfo": {
                            position = XMLSupport.checkElementOrder("supportingInfo", 26, position, true);
                            builder.supportingInfo(this.parseReference("supportingInfo", reader, supportingInfoElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 27, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClinicalImpression.Finding parseClinicalImpressionFinding(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClinicalImpression.Finding.Builder builder = ClinicalImpression.Finding.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "itemCodeableConcept": {
                            position = XMLSupport.checkElementOrder("itemCodeableConcept", 2, position, false);
                            builder.itemCodeableConcept(this.parseCodeableConcept("itemCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "itemReference": {
                            position = XMLSupport.checkElementOrder("itemReference", 3, position, false);
                            builder.itemReference(this.parseReference("itemReference", reader, -1));
                            break block0;
                        }
                        case "basis": {
                            position = XMLSupport.checkElementOrder("basis", 4, position, false);
                            builder.basis(this.parseString("basis", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ClinicalImpression.Investigation parseClinicalImpressionInvestigation(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ClinicalImpression.Investigation.Builder builder = ClinicalImpression.Investigation.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int itemElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "item": {
                            position = XMLSupport.checkElementOrder("item", 3, position, true);
                            builder.item(this.parseReference("item", reader, itemElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CodeSystem parseCodeSystem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CodeSystem.Builder builder = CodeSystem.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int contactElementIndex = 0;
        int useContextElementIndex = 0;
        int jurisdictionElementIndex = 0;
        int filterElementIndex = 0;
        int propertyElementIndex = 0;
        int conceptElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 8, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 9, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 10, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 11, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 12, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 13, position, false);
                            builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "experimental": {
                            position = XMLSupport.checkElementOrder("experimental", 14, position, false);
                            builder.experimental(this.parseBoolean("experimental", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 15, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "publisher": {
                            position = XMLSupport.checkElementOrder("publisher", 16, position, false);
                            builder.publisher(this.parseString("publisher", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 17, position, true);
                            builder.contact(this.parseContactDetail("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 18, position, false);
                            builder.description((Markdown)this.parseString(Markdown.builder(), "description", reader, -1));
                            break block0;
                        }
                        case "useContext": {
                            position = XMLSupport.checkElementOrder("useContext", 19, position, true);
                            builder.useContext(this.parseUsageContext("useContext", reader, useContextElementIndex++));
                            break block0;
                        }
                        case "jurisdiction": {
                            position = XMLSupport.checkElementOrder("jurisdiction", 20, position, true);
                            builder.jurisdiction(this.parseCodeableConcept("jurisdiction", reader, jurisdictionElementIndex++));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 21, position, false);
                            builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", reader, -1));
                            break block0;
                        }
                        case "copyright": {
                            position = XMLSupport.checkElementOrder("copyright", 22, position, false);
                            builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", reader, -1));
                            break block0;
                        }
                        case "caseSensitive": {
                            position = XMLSupport.checkElementOrder("caseSensitive", 23, position, false);
                            builder.caseSensitive(this.parseBoolean("caseSensitive", reader, -1));
                            break block0;
                        }
                        case "valueSet": {
                            position = XMLSupport.checkElementOrder("valueSet", 24, position, false);
                            builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", reader, -1));
                            break block0;
                        }
                        case "hierarchyMeaning": {
                            position = XMLSupport.checkElementOrder("hierarchyMeaning", 25, position, false);
                            builder.hierarchyMeaning((CodeSystemHierarchyMeaning)this.parseString(CodeSystemHierarchyMeaning.builder(), "hierarchyMeaning", reader, -1));
                            break block0;
                        }
                        case "compositional": {
                            position = XMLSupport.checkElementOrder("compositional", 26, position, false);
                            builder.compositional(this.parseBoolean("compositional", reader, -1));
                            break block0;
                        }
                        case "versionNeeded": {
                            position = XMLSupport.checkElementOrder("versionNeeded", 27, position, false);
                            builder.versionNeeded(this.parseBoolean("versionNeeded", reader, -1));
                            break block0;
                        }
                        case "content": {
                            position = XMLSupport.checkElementOrder("content", 28, position, false);
                            builder.content((CodeSystemContentMode)this.parseString(CodeSystemContentMode.builder(), "content", reader, -1));
                            break block0;
                        }
                        case "supplements": {
                            position = XMLSupport.checkElementOrder("supplements", 29, position, false);
                            builder.supplements((Canonical)this.parseUri(Canonical.builder(), "supplements", reader, -1));
                            break block0;
                        }
                        case "count": {
                            position = XMLSupport.checkElementOrder("count", 30, position, false);
                            builder.count((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "count", reader, -1));
                            break block0;
                        }
                        case "filter": {
                            position = XMLSupport.checkElementOrder("filter", 31, position, true);
                            builder.filter(this.parseCodeSystemFilter("filter", reader, filterElementIndex++));
                            break block0;
                        }
                        case "property": {
                            position = XMLSupport.checkElementOrder("property", 32, position, true);
                            builder.property(this.parseCodeSystemProperty("property", reader, propertyElementIndex++));
                            break block0;
                        }
                        case "concept": {
                            position = XMLSupport.checkElementOrder("concept", 33, position, true);
                            builder.concept(this.parseCodeSystemConcept("concept", reader, conceptElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CodeSystem.Concept parseCodeSystemConcept(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CodeSystem.Concept.Builder builder = CodeSystem.Concept.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int designationElementIndex = 0;
        int propertyElementIndex = 0;
        int conceptElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "display": {
                            position = XMLSupport.checkElementOrder("display", 3, position, false);
                            builder.display(this.parseString("display", reader, -1));
                            break block0;
                        }
                        case "definition": {
                            position = XMLSupport.checkElementOrder("definition", 4, position, false);
                            builder.definition(this.parseString("definition", reader, -1));
                            break block0;
                        }
                        case "designation": {
                            position = XMLSupport.checkElementOrder("designation", 5, position, true);
                            builder.designation(this.parseCodeSystemConceptDesignation("designation", reader, designationElementIndex++));
                            break block0;
                        }
                        case "property": {
                            position = XMLSupport.checkElementOrder("property", 6, position, true);
                            builder.property(this.parseCodeSystemConceptProperty("property", reader, propertyElementIndex++));
                            break block0;
                        }
                        case "concept": {
                            position = XMLSupport.checkElementOrder("concept", 7, position, true);
                            builder.concept(this.parseCodeSystemConcept("concept", reader, conceptElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CodeSystem.Concept.Designation parseCodeSystemConceptDesignation(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CodeSystem.Concept.Designation.Builder builder = CodeSystem.Concept.Designation.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 2, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "use": {
                            position = XMLSupport.checkElementOrder("use", 3, position, false);
                            builder.use(this.parseCoding("use", reader, -1));
                            break block0;
                        }
                        case "value": {
                            position = XMLSupport.checkElementOrder("value", 4, position, false);
                            builder.value(this.parseString("value", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CodeSystem.Concept.Property parseCodeSystemConceptProperty(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CodeSystem.Concept.Property.Builder builder = CodeSystem.Concept.Property.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "valueCode": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value((Code)this.parseString(Code.builder(), "valueCode", reader, -1));
                            break block0;
                        }
                        case "valueCoding": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseCoding("valueCoding", reader, -1));
                            break block0;
                        }
                        case "valueString": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseString("valueString", reader, -1));
                            break block0;
                        }
                        case "valueInteger": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseInteger("valueInteger", reader, -1));
                            break block0;
                        }
                        case "valueBoolean": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseBoolean("valueBoolean", reader, -1));
                            break block0;
                        }
                        case "valueDateTime": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseDateTime("valueDateTime", reader, -1));
                            break block0;
                        }
                        case "valueDecimal": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseDecimal("valueDecimal", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CodeSystem.Filter parseCodeSystemFilter(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CodeSystem.Filter.Builder builder = CodeSystem.Filter.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int operatorElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 3, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "operator": {
                            position = XMLSupport.checkElementOrder("operator", 4, position, true);
                            builder.operator((FilterOperator)this.parseString(FilterOperator.builder(), "operator", reader, operatorElementIndex++));
                            break block0;
                        }
                        case "value": {
                            position = XMLSupport.checkElementOrder("value", 5, position, false);
                            builder.value(this.parseString("value", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CodeSystem.Property parseCodeSystemProperty(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CodeSystem.Property.Builder builder = CodeSystem.Property.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "uri": {
                            position = XMLSupport.checkElementOrder("uri", 3, position, false);
                            builder.uri(this.parseUri("uri", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 4, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 5, position, false);
                            builder.type((PropertyType)this.parseString(PropertyType.builder(), "type", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CodeableConcept parseCodeableConcept(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CodeableConcept.Builder builder = CodeableConcept.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int codingElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "coding": {
                            position = XMLSupport.checkElementOrder("coding", 1, position, true);
                            builder.coding(this.parseCoding("coding", reader, codingElementIndex++));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 2, position, false);
                            builder.text(this.parseString("text", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Coding parseCoding(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Coding.Builder builder = Coding.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "system": {
                            position = XMLSupport.checkElementOrder("system", 1, position, false);
                            builder.system(this.parseUri("system", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 2, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 3, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "display": {
                            position = XMLSupport.checkElementOrder("display", 4, position, false);
                            builder.display(this.parseString("display", reader, -1));
                            break block0;
                        }
                        case "userSelected": {
                            position = XMLSupport.checkElementOrder("userSelected", 5, position, false);
                            builder.userSelected(this.parseBoolean("userSelected", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Communication parseCommunication(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Communication.Builder builder = Communication.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int instantiatesCanonicalElementIndex = 0;
        int instantiatesUriElementIndex = 0;
        int basedOnElementIndex = 0;
        int partOfElementIndex = 0;
        int inResponseToElementIndex = 0;
        int categoryElementIndex = 0;
        int mediumElementIndex = 0;
        int aboutElementIndex = 0;
        int recipientElementIndex = 0;
        int reasonCodeElementIndex = 0;
        int reasonReferenceElementIndex = 0;
        int payloadElementIndex = 0;
        int noteElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "instantiatesCanonical": {
                            position = XMLSupport.checkElementOrder("instantiatesCanonical", 9, position, true);
                            builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", reader, instantiatesCanonicalElementIndex++));
                            break block0;
                        }
                        case "instantiatesUri": {
                            position = XMLSupport.checkElementOrder("instantiatesUri", 10, position, true);
                            builder.instantiatesUri(this.parseUri("instantiatesUri", reader, instantiatesUriElementIndex++));
                            break block0;
                        }
                        case "basedOn": {
                            position = XMLSupport.checkElementOrder("basedOn", 11, position, true);
                            builder.basedOn(this.parseReference("basedOn", reader, basedOnElementIndex++));
                            break block0;
                        }
                        case "partOf": {
                            position = XMLSupport.checkElementOrder("partOf", 12, position, true);
                            builder.partOf(this.parseReference("partOf", reader, partOfElementIndex++));
                            break block0;
                        }
                        case "inResponseTo": {
                            position = XMLSupport.checkElementOrder("inResponseTo", 13, position, true);
                            builder.inResponseTo(this.parseReference("inResponseTo", reader, inResponseToElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 14, position, false);
                            builder.status((CommunicationStatus)this.parseString(CommunicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "statusReason": {
                            position = XMLSupport.checkElementOrder("statusReason", 15, position, false);
                            builder.statusReason(this.parseCodeableConcept("statusReason", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 16, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 17, position, false);
                            builder.priority((CommunicationPriority)this.parseString(CommunicationPriority.builder(), "priority", reader, -1));
                            break block0;
                        }
                        case "medium": {
                            position = XMLSupport.checkElementOrder("medium", 18, position, true);
                            builder.medium(this.parseCodeableConcept("medium", reader, mediumElementIndex++));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 19, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "topic": {
                            position = XMLSupport.checkElementOrder("topic", 20, position, false);
                            builder.topic(this.parseCodeableConcept("topic", reader, -1));
                            break block0;
                        }
                        case "about": {
                            position = XMLSupport.checkElementOrder("about", 21, position, true);
                            builder.about(this.parseReference("about", reader, aboutElementIndex++));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 22, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "sent": {
                            position = XMLSupport.checkElementOrder("sent", 23, position, false);
                            builder.sent(this.parseDateTime("sent", reader, -1));
                            break block0;
                        }
                        case "received": {
                            position = XMLSupport.checkElementOrder("received", 24, position, false);
                            builder.received(this.parseDateTime("received", reader, -1));
                            break block0;
                        }
                        case "recipient": {
                            position = XMLSupport.checkElementOrder("recipient", 25, position, true);
                            builder.recipient(this.parseReference("recipient", reader, recipientElementIndex++));
                            break block0;
                        }
                        case "sender": {
                            position = XMLSupport.checkElementOrder("sender", 26, position, false);
                            builder.sender(this.parseReference("sender", reader, -1));
                            break block0;
                        }
                        case "reasonCode": {
                            position = XMLSupport.checkElementOrder("reasonCode", 27, position, true);
                            builder.reasonCode(this.parseCodeableConcept("reasonCode", reader, reasonCodeElementIndex++));
                            break block0;
                        }
                        case "reasonReference": {
                            position = XMLSupport.checkElementOrder("reasonReference", 28, position, true);
                            builder.reasonReference(this.parseReference("reasonReference", reader, reasonReferenceElementIndex++));
                            break block0;
                        }
                        case "payload": {
                            position = XMLSupport.checkElementOrder("payload", 29, position, true);
                            builder.payload(this.parseCommunicationPayload("payload", reader, payloadElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 30, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Communication.Payload parseCommunicationPayload(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Communication.Payload.Builder builder = Communication.Payload.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "contentString": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseString("contentString", reader, -1));
                            break block0;
                        }
                        case "contentAttachment": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseAttachment("contentAttachment", reader, -1));
                            break block0;
                        }
                        case "contentReference": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseReference("contentReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CommunicationRequest parseCommunicationRequest(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CommunicationRequest.Builder builder = CommunicationRequest.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int basedOnElementIndex = 0;
        int replacesElementIndex = 0;
        int categoryElementIndex = 0;
        int mediumElementIndex = 0;
        int aboutElementIndex = 0;
        int payloadElementIndex = 0;
        int recipientElementIndex = 0;
        int reasonCodeElementIndex = 0;
        int reasonReferenceElementIndex = 0;
        int noteElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "basedOn": {
                            position = XMLSupport.checkElementOrder("basedOn", 9, position, true);
                            builder.basedOn(this.parseReference("basedOn", reader, basedOnElementIndex++));
                            break block0;
                        }
                        case "replaces": {
                            position = XMLSupport.checkElementOrder("replaces", 10, position, true);
                            builder.replaces(this.parseReference("replaces", reader, replacesElementIndex++));
                            break block0;
                        }
                        case "groupIdentifier": {
                            position = XMLSupport.checkElementOrder("groupIdentifier", 11, position, false);
                            builder.groupIdentifier(this.parseIdentifier("groupIdentifier", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 12, position, false);
                            builder.status((CommunicationRequestStatus)this.parseString(CommunicationRequestStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "statusReason": {
                            position = XMLSupport.checkElementOrder("statusReason", 13, position, false);
                            builder.statusReason(this.parseCodeableConcept("statusReason", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 14, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 15, position, false);
                            builder.priority((CommunicationPriority)this.parseString(CommunicationPriority.builder(), "priority", reader, -1));
                            break block0;
                        }
                        case "doNotPerform": {
                            position = XMLSupport.checkElementOrder("doNotPerform", 16, position, false);
                            builder.doNotPerform(this.parseBoolean("doNotPerform", reader, -1));
                            break block0;
                        }
                        case "medium": {
                            position = XMLSupport.checkElementOrder("medium", 17, position, true);
                            builder.medium(this.parseCodeableConcept("medium", reader, mediumElementIndex++));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 18, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "about": {
                            position = XMLSupport.checkElementOrder("about", 19, position, true);
                            builder.about(this.parseReference("about", reader, aboutElementIndex++));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 20, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "payload": {
                            position = XMLSupport.checkElementOrder("payload", 21, position, true);
                            builder.payload(this.parseCommunicationRequestPayload("payload", reader, payloadElementIndex++));
                            break block0;
                        }
                        case "occurrenceDateTime": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 22, position, false);
                            builder.occurrence(this.parseDateTime("occurrenceDateTime", reader, -1));
                            break block0;
                        }
                        case "occurrencePeriod": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 22, position, false);
                            builder.occurrence(this.parsePeriod("occurrencePeriod", reader, -1));
                            break block0;
                        }
                        case "authoredOn": {
                            position = XMLSupport.checkElementOrder("authoredOn", 23, position, false);
                            builder.authoredOn(this.parseDateTime("authoredOn", reader, -1));
                            break block0;
                        }
                        case "requester": {
                            position = XMLSupport.checkElementOrder("requester", 24, position, false);
                            builder.requester(this.parseReference("requester", reader, -1));
                            break block0;
                        }
                        case "recipient": {
                            position = XMLSupport.checkElementOrder("recipient", 25, position, true);
                            builder.recipient(this.parseReference("recipient", reader, recipientElementIndex++));
                            break block0;
                        }
                        case "sender": {
                            position = XMLSupport.checkElementOrder("sender", 26, position, false);
                            builder.sender(this.parseReference("sender", reader, -1));
                            break block0;
                        }
                        case "reasonCode": {
                            position = XMLSupport.checkElementOrder("reasonCode", 27, position, true);
                            builder.reasonCode(this.parseCodeableConcept("reasonCode", reader, reasonCodeElementIndex++));
                            break block0;
                        }
                        case "reasonReference": {
                            position = XMLSupport.checkElementOrder("reasonReference", 28, position, true);
                            builder.reasonReference(this.parseReference("reasonReference", reader, reasonReferenceElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 29, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CommunicationRequest.Payload parseCommunicationRequestPayload(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CommunicationRequest.Payload.Builder builder = CommunicationRequest.Payload.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "contentString": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseString("contentString", reader, -1));
                            break block0;
                        }
                        case "contentAttachment": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseAttachment("contentAttachment", reader, -1));
                            break block0;
                        }
                        case "contentReference": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseReference("contentReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CompartmentDefinition parseCompartmentDefinition(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CompartmentDefinition.Builder builder = CompartmentDefinition.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int contactElementIndex = 0;
        int useContextElementIndex = 0;
        int resourceElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 8, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 9, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 10, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 11, position, false);
                            builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "experimental": {
                            position = XMLSupport.checkElementOrder("experimental", 12, position, false);
                            builder.experimental(this.parseBoolean("experimental", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 13, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "publisher": {
                            position = XMLSupport.checkElementOrder("publisher", 14, position, false);
                            builder.publisher(this.parseString("publisher", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 15, position, true);
                            builder.contact(this.parseContactDetail("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 16, position, false);
                            builder.description((Markdown)this.parseString(Markdown.builder(), "description", reader, -1));
                            break block0;
                        }
                        case "useContext": {
                            position = XMLSupport.checkElementOrder("useContext", 17, position, true);
                            builder.useContext(this.parseUsageContext("useContext", reader, useContextElementIndex++));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 18, position, false);
                            builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 19, position, false);
                            builder.code((CompartmentType)this.parseString(CompartmentType.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "search": {
                            position = XMLSupport.checkElementOrder("search", 20, position, false);
                            builder.search(this.parseBoolean("search", reader, -1));
                            break block0;
                        }
                        case "resource": {
                            position = XMLSupport.checkElementOrder("resource", 21, position, true);
                            builder.resource(this.parseCompartmentDefinitionResource("resource", reader, resourceElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CompartmentDefinition.Resource parseCompartmentDefinitionResource(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CompartmentDefinition.Resource.Builder builder = CompartmentDefinition.Resource.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int paramElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((ResourceType)this.parseString(ResourceType.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "param": {
                            position = XMLSupport.checkElementOrder("param", 3, position, true);
                            builder.param(this.parseString("param", reader, paramElementIndex++));
                            break block0;
                        }
                        case "documentation": {
                            position = XMLSupport.checkElementOrder("documentation", 4, position, false);
                            builder.documentation(this.parseString("documentation", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Composition parseComposition(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Composition.Builder builder = Composition.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int categoryElementIndex = 0;
        int authorElementIndex = 0;
        int attesterElementIndex = 0;
        int relatesToElementIndex = 0;
        int eventElementIndex = 0;
        int sectionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((CompositionStatus)this.parseString(CompositionStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 10, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 11, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 12, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 13, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 14, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 15, position, true);
                            builder.author(this.parseReference("author", reader, authorElementIndex++));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 16, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "confidentiality": {
                            position = XMLSupport.checkElementOrder("confidentiality", 17, position, false);
                            builder.confidentiality((DocumentConfidentiality)this.parseString(DocumentConfidentiality.builder(), "confidentiality", reader, -1));
                            break block0;
                        }
                        case "attester": {
                            position = XMLSupport.checkElementOrder("attester", 18, position, true);
                            builder.attester(this.parseCompositionAttester("attester", reader, attesterElementIndex++));
                            break block0;
                        }
                        case "custodian": {
                            position = XMLSupport.checkElementOrder("custodian", 19, position, false);
                            builder.custodian(this.parseReference("custodian", reader, -1));
                            break block0;
                        }
                        case "relatesTo": {
                            position = XMLSupport.checkElementOrder("relatesTo", 20, position, true);
                            builder.relatesTo(this.parseCompositionRelatesTo("relatesTo", reader, relatesToElementIndex++));
                            break block0;
                        }
                        case "event": {
                            position = XMLSupport.checkElementOrder("event", 21, position, true);
                            builder.event(this.parseCompositionEvent("event", reader, eventElementIndex++));
                            break block0;
                        }
                        case "section": {
                            position = XMLSupport.checkElementOrder("section", 22, position, true);
                            builder.section(this.parseCompositionSection("section", reader, sectionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Composition.Attester parseCompositionAttester(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Composition.Attester.Builder builder = Composition.Attester.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "mode": {
                            position = XMLSupport.checkElementOrder("mode", 2, position, false);
                            builder.mode((CompositionAttestationMode)this.parseString(CompositionAttestationMode.builder(), "mode", reader, -1));
                            break block0;
                        }
                        case "time": {
                            position = XMLSupport.checkElementOrder("time", 3, position, false);
                            builder.time(this.parseDateTime("time", reader, -1));
                            break block0;
                        }
                        case "party": {
                            position = XMLSupport.checkElementOrder("party", 4, position, false);
                            builder.party(this.parseReference("party", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Composition.Event parseCompositionEvent(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Composition.Event.Builder builder = Composition.Event.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int codeElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, true);
                            builder.code(this.parseCodeableConcept("code", reader, codeElementIndex++));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 3, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 4, position, true);
                            builder.detail(this.parseReference("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Composition.RelatesTo parseCompositionRelatesTo(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Composition.RelatesTo.Builder builder = Composition.RelatesTo.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((DocumentRelationshipType)this.parseString(DocumentRelationshipType.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "targetIdentifier": {
                            position = XMLSupport.checkElementOrder("target[x]", 3, position, false);
                            builder.target(this.parseIdentifier("targetIdentifier", reader, -1));
                            break block0;
                        }
                        case "targetReference": {
                            position = XMLSupport.checkElementOrder("target[x]", 3, position, false);
                            builder.target(this.parseReference("targetReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Composition.Section parseCompositionSection(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Composition.Section.Builder builder = Composition.Section.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int authorElementIndex = 0;
        int entryElementIndex = 0;
        int sectionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 2, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 3, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 4, position, true);
                            builder.author(this.parseReference("author", reader, authorElementIndex++));
                            break block0;
                        }
                        case "focus": {
                            position = XMLSupport.checkElementOrder("focus", 5, position, false);
                            builder.focus(this.parseReference("focus", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 6, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "mode": {
                            position = XMLSupport.checkElementOrder("mode", 7, position, false);
                            builder.mode((SectionMode)this.parseString(SectionMode.builder(), "mode", reader, -1));
                            break block0;
                        }
                        case "orderedBy": {
                            position = XMLSupport.checkElementOrder("orderedBy", 8, position, false);
                            builder.orderedBy(this.parseCodeableConcept("orderedBy", reader, -1));
                            break block0;
                        }
                        case "entry": {
                            position = XMLSupport.checkElementOrder("entry", 9, position, true);
                            builder.entry(this.parseReference("entry", reader, entryElementIndex++));
                            break block0;
                        }
                        case "emptyReason": {
                            position = XMLSupport.checkElementOrder("emptyReason", 10, position, false);
                            builder.emptyReason(this.parseCodeableConcept("emptyReason", reader, -1));
                            break block0;
                        }
                        case "section": {
                            position = XMLSupport.checkElementOrder("section", 11, position, true);
                            builder.section(this.parseCompositionSection("section", reader, sectionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ConceptMap parseConceptMap(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ConceptMap.Builder builder = ConceptMap.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int contactElementIndex = 0;
        int useContextElementIndex = 0;
        int jurisdictionElementIndex = 0;
        int groupElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 8, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 9, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 10, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 11, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 12, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 13, position, false);
                            builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "experimental": {
                            position = XMLSupport.checkElementOrder("experimental", 14, position, false);
                            builder.experimental(this.parseBoolean("experimental", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 15, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "publisher": {
                            position = XMLSupport.checkElementOrder("publisher", 16, position, false);
                            builder.publisher(this.parseString("publisher", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 17, position, true);
                            builder.contact(this.parseContactDetail("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 18, position, false);
                            builder.description((Markdown)this.parseString(Markdown.builder(), "description", reader, -1));
                            break block0;
                        }
                        case "useContext": {
                            position = XMLSupport.checkElementOrder("useContext", 19, position, true);
                            builder.useContext(this.parseUsageContext("useContext", reader, useContextElementIndex++));
                            break block0;
                        }
                        case "jurisdiction": {
                            position = XMLSupport.checkElementOrder("jurisdiction", 20, position, true);
                            builder.jurisdiction(this.parseCodeableConcept("jurisdiction", reader, jurisdictionElementIndex++));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 21, position, false);
                            builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", reader, -1));
                            break block0;
                        }
                        case "copyright": {
                            position = XMLSupport.checkElementOrder("copyright", 22, position, false);
                            builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", reader, -1));
                            break block0;
                        }
                        case "sourceUri": {
                            position = XMLSupport.checkElementOrder("source[x]", 23, position, false);
                            builder.source(this.parseUri("sourceUri", reader, -1));
                            break block0;
                        }
                        case "sourceCanonical": {
                            position = XMLSupport.checkElementOrder("source[x]", 23, position, false);
                            builder.source((Canonical)this.parseUri(Canonical.builder(), "sourceCanonical", reader, -1));
                            break block0;
                        }
                        case "targetUri": {
                            position = XMLSupport.checkElementOrder("target[x]", 24, position, false);
                            builder.target(this.parseUri("targetUri", reader, -1));
                            break block0;
                        }
                        case "targetCanonical": {
                            position = XMLSupport.checkElementOrder("target[x]", 24, position, false);
                            builder.target((Canonical)this.parseUri(Canonical.builder(), "targetCanonical", reader, -1));
                            break block0;
                        }
                        case "group": {
                            position = XMLSupport.checkElementOrder("group", 25, position, true);
                            builder.group(this.parseConceptMapGroup("group", reader, groupElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ConceptMap.Group parseConceptMapGroup(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ConceptMap.Group.Builder builder = ConceptMap.Group.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int elementElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "source": {
                            position = XMLSupport.checkElementOrder("source", 2, position, false);
                            builder.source(this.parseUri("source", reader, -1));
                            break block0;
                        }
                        case "sourceVersion": {
                            position = XMLSupport.checkElementOrder("sourceVersion", 3, position, false);
                            builder.sourceVersion(this.parseString("sourceVersion", reader, -1));
                            break block0;
                        }
                        case "target": {
                            position = XMLSupport.checkElementOrder("target", 4, position, false);
                            builder.target(this.parseUri("target", reader, -1));
                            break block0;
                        }
                        case "targetVersion": {
                            position = XMLSupport.checkElementOrder("targetVersion", 5, position, false);
                            builder.targetVersion(this.parseString("targetVersion", reader, -1));
                            break block0;
                        }
                        case "element": {
                            position = XMLSupport.checkElementOrder("element", 6, position, true);
                            builder.element(this.parseConceptMapGroupElement("element", reader, elementElementIndex++));
                            break block0;
                        }
                        case "unmapped": {
                            position = XMLSupport.checkElementOrder("unmapped", 7, position, false);
                            builder.unmapped(this.parseConceptMapGroupUnmapped("unmapped", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ConceptMap.Group.Element parseConceptMapGroupElement(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ConceptMap.Group.Element.Builder builder = ConceptMap.Group.Element.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int targetElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "display": {
                            position = XMLSupport.checkElementOrder("display", 3, position, false);
                            builder.display(this.parseString("display", reader, -1));
                            break block0;
                        }
                        case "target": {
                            position = XMLSupport.checkElementOrder("target", 4, position, true);
                            builder.target(this.parseConceptMapGroupElementTarget("target", reader, targetElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ConceptMap.Group.Element.Target parseConceptMapGroupElementTarget(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ConceptMap.Group.Element.Target.Builder builder = ConceptMap.Group.Element.Target.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int dependsOnElementIndex = 0;
        int productElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "display": {
                            position = XMLSupport.checkElementOrder("display", 3, position, false);
                            builder.display(this.parseString("display", reader, -1));
                            break block0;
                        }
                        case "equivalence": {
                            position = XMLSupport.checkElementOrder("equivalence", 4, position, false);
                            builder.equivalence((ConceptMapEquivalence)this.parseString(ConceptMapEquivalence.builder(), "equivalence", reader, -1));
                            break block0;
                        }
                        case "comment": {
                            position = XMLSupport.checkElementOrder("comment", 5, position, false);
                            builder.comment(this.parseString("comment", reader, -1));
                            break block0;
                        }
                        case "dependsOn": {
                            position = XMLSupport.checkElementOrder("dependsOn", 6, position, true);
                            builder.dependsOn(this.parseConceptMapGroupElementTargetDependsOn("dependsOn", reader, dependsOnElementIndex++));
                            break block0;
                        }
                        case "product": {
                            position = XMLSupport.checkElementOrder("product", 7, position, true);
                            builder.product(this.parseConceptMapGroupElementTargetDependsOn("product", reader, productElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ConceptMap.Group.Element.Target.DependsOn parseConceptMapGroupElementTargetDependsOn(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ConceptMap.Group.Element.Target.DependsOn.Builder builder = ConceptMap.Group.Element.Target.DependsOn.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "property": {
                            position = XMLSupport.checkElementOrder("property", 2, position, false);
                            builder.property(this.parseUri("property", reader, -1));
                            break block0;
                        }
                        case "system": {
                            position = XMLSupport.checkElementOrder("system", 3, position, false);
                            builder.system((Canonical)this.parseUri(Canonical.builder(), "system", reader, -1));
                            break block0;
                        }
                        case "value": {
                            position = XMLSupport.checkElementOrder("value", 4, position, false);
                            builder.value(this.parseString("value", reader, -1));
                            break block0;
                        }
                        case "display": {
                            position = XMLSupport.checkElementOrder("display", 5, position, false);
                            builder.display(this.parseString("display", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ConceptMap.Group.Unmapped parseConceptMapGroupUnmapped(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ConceptMap.Group.Unmapped.Builder builder = ConceptMap.Group.Unmapped.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "mode": {
                            position = XMLSupport.checkElementOrder("mode", 2, position, false);
                            builder.mode((ConceptMapGroupUnmappedMode)this.parseString(ConceptMapGroupUnmappedMode.builder(), "mode", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 3, position, false);
                            builder.code((Code)this.parseString(Code.builder(), "code", reader, -1));
                            break block0;
                        }
                        case "display": {
                            position = XMLSupport.checkElementOrder("display", 4, position, false);
                            builder.display(this.parseString("display", reader, -1));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 5, position, false);
                            builder.url((Canonical)this.parseUri(Canonical.builder(), "url", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Condition parseCondition(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Condition.Builder builder = Condition.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int categoryElementIndex = 0;
        int bodySiteElementIndex = 0;
        int stageElementIndex = 0;
        int evidenceElementIndex = 0;
        int noteElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "clinicalStatus": {
                            position = XMLSupport.checkElementOrder("clinicalStatus", 9, position, false);
                            builder.clinicalStatus(this.parseCodeableConcept("clinicalStatus", reader, -1));
                            break block0;
                        }
                        case "verificationStatus": {
                            position = XMLSupport.checkElementOrder("verificationStatus", 10, position, false);
                            builder.verificationStatus(this.parseCodeableConcept("verificationStatus", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 11, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "severity": {
                            position = XMLSupport.checkElementOrder("severity", 12, position, false);
                            builder.severity(this.parseCodeableConcept("severity", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 13, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "bodySite": {
                            position = XMLSupport.checkElementOrder("bodySite", 14, position, true);
                            builder.bodySite(this.parseCodeableConcept("bodySite", reader, bodySiteElementIndex++));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 15, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 16, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "onsetDateTime": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parseDateTime("onsetDateTime", reader, -1));
                            break block0;
                        }
                        case "onsetAge": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset((Age)this.parseQuantity(Age.builder(), "onsetAge", reader, -1));
                            break block0;
                        }
                        case "onsetPeriod": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parsePeriod("onsetPeriod", reader, -1));
                            break block0;
                        }
                        case "onsetRange": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parseRange("onsetRange", reader, -1));
                            break block0;
                        }
                        case "onsetString": {
                            position = XMLSupport.checkElementOrder("onset[x]", 17, position, false);
                            builder.onset(this.parseString("onsetString", reader, -1));
                            break block0;
                        }
                        case "abatementDateTime": {
                            position = XMLSupport.checkElementOrder("abatement[x]", 18, position, false);
                            builder.abatement(this.parseDateTime("abatementDateTime", reader, -1));
                            break block0;
                        }
                        case "abatementAge": {
                            position = XMLSupport.checkElementOrder("abatement[x]", 18, position, false);
                            builder.abatement((Age)this.parseQuantity(Age.builder(), "abatementAge", reader, -1));
                            break block0;
                        }
                        case "abatementPeriod": {
                            position = XMLSupport.checkElementOrder("abatement[x]", 18, position, false);
                            builder.abatement(this.parsePeriod("abatementPeriod", reader, -1));
                            break block0;
                        }
                        case "abatementRange": {
                            position = XMLSupport.checkElementOrder("abatement[x]", 18, position, false);
                            builder.abatement(this.parseRange("abatementRange", reader, -1));
                            break block0;
                        }
                        case "abatementString": {
                            position = XMLSupport.checkElementOrder("abatement[x]", 18, position, false);
                            builder.abatement(this.parseString("abatementString", reader, -1));
                            break block0;
                        }
                        case "recordedDate": {
                            position = XMLSupport.checkElementOrder("recordedDate", 19, position, false);
                            builder.recordedDate(this.parseDateTime("recordedDate", reader, -1));
                            break block0;
                        }
                        case "recorder": {
                            position = XMLSupport.checkElementOrder("recorder", 20, position, false);
                            builder.recorder(this.parseReference("recorder", reader, -1));
                            break block0;
                        }
                        case "asserter": {
                            position = XMLSupport.checkElementOrder("asserter", 21, position, false);
                            builder.asserter(this.parseReference("asserter", reader, -1));
                            break block0;
                        }
                        case "stage": {
                            position = XMLSupport.checkElementOrder("stage", 22, position, true);
                            builder.stage(this.parseConditionStage("stage", reader, stageElementIndex++));
                            break block0;
                        }
                        case "evidence": {
                            position = XMLSupport.checkElementOrder("evidence", 23, position, true);
                            builder.evidence(this.parseConditionEvidence("evidence", reader, evidenceElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 24, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Condition.Evidence parseConditionEvidence(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Condition.Evidence.Builder builder = Condition.Evidence.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int codeElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, true);
                            builder.code(this.parseCodeableConcept("code", reader, codeElementIndex++));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 3, position, true);
                            builder.detail(this.parseReference("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Condition.Stage parseConditionStage(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Condition.Stage.Builder builder = Condition.Stage.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int assessmentElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "summary": {
                            position = XMLSupport.checkElementOrder("summary", 2, position, false);
                            builder.summary(this.parseCodeableConcept("summary", reader, -1));
                            break block0;
                        }
                        case "assessment": {
                            position = XMLSupport.checkElementOrder("assessment", 3, position, true);
                            builder.assessment(this.parseReference("assessment", reader, assessmentElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 4, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Consent parseConsent(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Consent.Builder builder = Consent.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int categoryElementIndex = 0;
        int performerElementIndex = 0;
        int organizationElementIndex = 0;
        int policyElementIndex = 0;
        int verificationElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((ConsentState)this.parseString(ConsentState.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "scope": {
                            position = XMLSupport.checkElementOrder("scope", 10, position, false);
                            builder.scope(this.parseCodeableConcept("scope", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 11, position, true);
                            builder.category(this.parseCodeableConcept("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 12, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "dateTime": {
                            position = XMLSupport.checkElementOrder("dateTime", 13, position, false);
                            builder.dateTime(this.parseDateTime("dateTime", reader, -1));
                            break block0;
                        }
                        case "performer": {
                            position = XMLSupport.checkElementOrder("performer", 14, position, true);
                            builder.performer(this.parseReference("performer", reader, performerElementIndex++));
                            break block0;
                        }
                        case "organization": {
                            position = XMLSupport.checkElementOrder("organization", 15, position, true);
                            builder.organization(this.parseReference("organization", reader, organizationElementIndex++));
                            break block0;
                        }
                        case "sourceAttachment": {
                            position = XMLSupport.checkElementOrder("source[x]", 16, position, false);
                            builder.source(this.parseAttachment("sourceAttachment", reader, -1));
                            break block0;
                        }
                        case "sourceReference": {
                            position = XMLSupport.checkElementOrder("source[x]", 16, position, false);
                            builder.source(this.parseReference("sourceReference", reader, -1));
                            break block0;
                        }
                        case "policy": {
                            position = XMLSupport.checkElementOrder("policy", 17, position, true);
                            builder.policy(this.parseConsentPolicy("policy", reader, policyElementIndex++));
                            break block0;
                        }
                        case "policyRule": {
                            position = XMLSupport.checkElementOrder("policyRule", 18, position, false);
                            builder.policyRule(this.parseCodeableConcept("policyRule", reader, -1));
                            break block0;
                        }
                        case "verification": {
                            position = XMLSupport.checkElementOrder("verification", 19, position, true);
                            builder.verification(this.parseConsentVerification("verification", reader, verificationElementIndex++));
                            break block0;
                        }
                        case "provision": {
                            position = XMLSupport.checkElementOrder("provision", 20, position, false);
                            builder.provision(this.parseConsentProvision("provision", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Consent.Policy parseConsentPolicy(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Consent.Policy.Builder builder = Consent.Policy.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "authority": {
                            position = XMLSupport.checkElementOrder("authority", 2, position, false);
                            builder.authority(this.parseUri("authority", reader, -1));
                            break block0;
                        }
                        case "uri": {
                            position = XMLSupport.checkElementOrder("uri", 3, position, false);
                            builder.uri(this.parseUri("uri", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Consent.Provision parseConsentProvision(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Consent.Provision.Builder builder = Consent.Provision.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int actorElementIndex = 0;
        int actionElementIndex = 0;
        int securityLabelElementIndex = 0;
        int purposeElementIndex = 0;
        int classElementIndex = 0;
        int codeElementIndex = 0;
        int dataElementIndex = 0;
        int provisionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type((ConsentProvisionType)this.parseString(ConsentProvisionType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 3, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                        case "actor": {
                            position = XMLSupport.checkElementOrder("actor", 4, position, true);
                            builder.actor(this.parseConsentProvisionActor("actor", reader, actorElementIndex++));
                            break block0;
                        }
                        case "action": {
                            position = XMLSupport.checkElementOrder("action", 5, position, true);
                            builder.action(this.parseCodeableConcept("action", reader, actionElementIndex++));
                            break block0;
                        }
                        case "securityLabel": {
                            position = XMLSupport.checkElementOrder("securityLabel", 6, position, true);
                            builder.securityLabel(this.parseCoding("securityLabel", reader, securityLabelElementIndex++));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 7, position, true);
                            builder.purpose(this.parseCoding("purpose", reader, purposeElementIndex++));
                            break block0;
                        }
                        case "class": {
                            position = XMLSupport.checkElementOrder("class", 8, position, true);
                            builder.clazz(this.parseCoding("class", reader, classElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 9, position, true);
                            builder.code(this.parseCodeableConcept("code", reader, codeElementIndex++));
                            break block0;
                        }
                        case "dataPeriod": {
                            position = XMLSupport.checkElementOrder("dataPeriod", 10, position, false);
                            builder.dataPeriod(this.parsePeriod("dataPeriod", reader, -1));
                            break block0;
                        }
                        case "data": {
                            position = XMLSupport.checkElementOrder("data", 11, position, true);
                            builder.data(this.parseConsentProvisionData("data", reader, dataElementIndex++));
                            break block0;
                        }
                        case "provision": {
                            position = XMLSupport.checkElementOrder("provision", 12, position, true);
                            builder.provision(this.parseConsentProvision("provision", reader, provisionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Consent.Provision.Actor parseConsentProvisionActor(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Consent.Provision.Actor.Builder builder = Consent.Provision.Actor.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 2, position, false);
                            builder.role(this.parseCodeableConcept("role", reader, -1));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 3, position, false);
                            builder.reference(this.parseReference("reference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Consent.Provision.Data parseConsentProvisionData(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Consent.Provision.Data.Builder builder = Consent.Provision.Data.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "meaning": {
                            position = XMLSupport.checkElementOrder("meaning", 2, position, false);
                            builder.meaning((ConsentDataMeaning)this.parseString(ConsentDataMeaning.builder(), "meaning", reader, -1));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 3, position, false);
                            builder.reference(this.parseReference("reference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Consent.Verification parseConsentVerification(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Consent.Verification.Builder builder = Consent.Verification.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "verified": {
                            position = XMLSupport.checkElementOrder("verified", 2, position, false);
                            builder.verified(this.parseBoolean("verified", reader, -1));
                            break block0;
                        }
                        case "verifiedWith": {
                            position = XMLSupport.checkElementOrder("verifiedWith", 3, position, false);
                            builder.verifiedWith(this.parseReference("verifiedWith", reader, -1));
                            break block0;
                        }
                        case "verificationDate": {
                            position = XMLSupport.checkElementOrder("verificationDate", 4, position, false);
                            builder.verificationDate(this.parseDateTime("verificationDate", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ContactDetail parseContactDetail(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ContactDetail.Builder builder = ContactDetail.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int telecomElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 1, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "telecom": {
                            position = XMLSupport.checkElementOrder("telecom", 2, position, true);
                            builder.telecom(this.parseContactPoint("telecom", reader, telecomElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private ContactPoint parseContactPoint(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        ContactPoint.Builder builder = ContactPoint.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "system": {
                            position = XMLSupport.checkElementOrder("system", 1, position, false);
                            builder.system((ContactPointSystem)this.parseString(ContactPointSystem.builder(), "system", reader, -1));
                            break block0;
                        }
                        case "value": {
                            position = XMLSupport.checkElementOrder("value", 2, position, false);
                            builder.value(this.parseString("value", reader, -1));
                            break block0;
                        }
                        case "use": {
                            position = XMLSupport.checkElementOrder("use", 3, position, false);
                            builder.use((ContactPointUse)this.parseString(ContactPointUse.builder(), "use", reader, -1));
                            break block0;
                        }
                        case "rank": {
                            position = XMLSupport.checkElementOrder("rank", 4, position, false);
                            builder.rank((PositiveInt)this.parseInteger(PositiveInt.builder(), "rank", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 5, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract parseContract(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Builder builder = Contract.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int subjectElementIndex = 0;
        int authorityElementIndex = 0;
        int domainElementIndex = 0;
        int siteElementIndex = 0;
        int aliasElementIndex = 0;
        int subTypeElementIndex = 0;
        int termElementIndex = 0;
        int supportingInfoElementIndex = 0;
        int relevantHistoryElementIndex = 0;
        int signerElementIndex = 0;
        int friendlyElementIndex = 0;
        int legalElementIndex = 0;
        int ruleElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 9, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 10, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 11, position, false);
                            builder.status((ContractStatus)this.parseString(ContractStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "legalState": {
                            position = XMLSupport.checkElementOrder("legalState", 12, position, false);
                            builder.legalState(this.parseCodeableConcept("legalState", reader, -1));
                            break block0;
                        }
                        case "instantiatesCanonical": {
                            position = XMLSupport.checkElementOrder("instantiatesCanonical", 13, position, false);
                            builder.instantiatesCanonical(this.parseReference("instantiatesCanonical", reader, -1));
                            break block0;
                        }
                        case "instantiatesUri": {
                            position = XMLSupport.checkElementOrder("instantiatesUri", 14, position, false);
                            builder.instantiatesUri(this.parseUri("instantiatesUri", reader, -1));
                            break block0;
                        }
                        case "contentDerivative": {
                            position = XMLSupport.checkElementOrder("contentDerivative", 15, position, false);
                            builder.contentDerivative(this.parseCodeableConcept("contentDerivative", reader, -1));
                            break block0;
                        }
                        case "issued": {
                            position = XMLSupport.checkElementOrder("issued", 16, position, false);
                            builder.issued(this.parseDateTime("issued", reader, -1));
                            break block0;
                        }
                        case "applies": {
                            position = XMLSupport.checkElementOrder("applies", 17, position, false);
                            builder.applies(this.parsePeriod("applies", reader, -1));
                            break block0;
                        }
                        case "expirationType": {
                            position = XMLSupport.checkElementOrder("expirationType", 18, position, false);
                            builder.expirationType(this.parseCodeableConcept("expirationType", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 19, position, true);
                            builder.subject(this.parseReference("subject", reader, subjectElementIndex++));
                            break block0;
                        }
                        case "authority": {
                            position = XMLSupport.checkElementOrder("authority", 20, position, true);
                            builder.authority(this.parseReference("authority", reader, authorityElementIndex++));
                            break block0;
                        }
                        case "domain": {
                            position = XMLSupport.checkElementOrder("domain", 21, position, true);
                            builder.domain(this.parseReference("domain", reader, domainElementIndex++));
                            break block0;
                        }
                        case "site": {
                            position = XMLSupport.checkElementOrder("site", 22, position, true);
                            builder.site(this.parseReference("site", reader, siteElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 23, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "title": {
                            position = XMLSupport.checkElementOrder("title", 24, position, false);
                            builder.title(this.parseString("title", reader, -1));
                            break block0;
                        }
                        case "subtitle": {
                            position = XMLSupport.checkElementOrder("subtitle", 25, position, false);
                            builder.subtitle(this.parseString("subtitle", reader, -1));
                            break block0;
                        }
                        case "alias": {
                            position = XMLSupport.checkElementOrder("alias", 26, position, true);
                            builder.alias(this.parseString("alias", reader, aliasElementIndex++));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 27, position, false);
                            builder.author(this.parseReference("author", reader, -1));
                            break block0;
                        }
                        case "scope": {
                            position = XMLSupport.checkElementOrder("scope", 28, position, false);
                            builder.scope(this.parseCodeableConcept("scope", reader, -1));
                            break block0;
                        }
                        case "topicCodeableConcept": {
                            position = XMLSupport.checkElementOrder("topic[x]", 29, position, false);
                            builder.topic(this.parseCodeableConcept("topicCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "topicReference": {
                            position = XMLSupport.checkElementOrder("topic[x]", 29, position, false);
                            builder.topic(this.parseReference("topicReference", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 30, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "subType": {
                            position = XMLSupport.checkElementOrder("subType", 31, position, true);
                            builder.subType(this.parseCodeableConcept("subType", reader, subTypeElementIndex++));
                            break block0;
                        }
                        case "contentDefinition": {
                            position = XMLSupport.checkElementOrder("contentDefinition", 32, position, false);
                            builder.contentDefinition(this.parseContractContentDefinition("contentDefinition", reader, -1));
                            break block0;
                        }
                        case "term": {
                            position = XMLSupport.checkElementOrder("term", 33, position, true);
                            builder.term(this.parseContractTerm("term", reader, termElementIndex++));
                            break block0;
                        }
                        case "supportingInfo": {
                            position = XMLSupport.checkElementOrder("supportingInfo", 34, position, true);
                            builder.supportingInfo(this.parseReference("supportingInfo", reader, supportingInfoElementIndex++));
                            break block0;
                        }
                        case "relevantHistory": {
                            position = XMLSupport.checkElementOrder("relevantHistory", 35, position, true);
                            builder.relevantHistory(this.parseReference("relevantHistory", reader, relevantHistoryElementIndex++));
                            break block0;
                        }
                        case "signer": {
                            position = XMLSupport.checkElementOrder("signer", 36, position, true);
                            builder.signer(this.parseContractSigner("signer", reader, signerElementIndex++));
                            break block0;
                        }
                        case "friendly": {
                            position = XMLSupport.checkElementOrder("friendly", 37, position, true);
                            builder.friendly(this.parseContractFriendly("friendly", reader, friendlyElementIndex++));
                            break block0;
                        }
                        case "legal": {
                            position = XMLSupport.checkElementOrder("legal", 38, position, true);
                            builder.legal(this.parseContractLegal("legal", reader, legalElementIndex++));
                            break block0;
                        }
                        case "rule": {
                            position = XMLSupport.checkElementOrder("rule", 39, position, true);
                            builder.rule(this.parseContractRule("rule", reader, ruleElementIndex++));
                            break block0;
                        }
                        case "legallyBindingAttachment": {
                            position = XMLSupport.checkElementOrder("legallyBinding[x]", 40, position, false);
                            builder.legallyBinding(this.parseAttachment("legallyBindingAttachment", reader, -1));
                            break block0;
                        }
                        case "legallyBindingReference": {
                            position = XMLSupport.checkElementOrder("legallyBinding[x]", 40, position, false);
                            builder.legallyBinding(this.parseReference("legallyBindingReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.ContentDefinition parseContractContentDefinition(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.ContentDefinition.Builder builder = Contract.ContentDefinition.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "subType": {
                            position = XMLSupport.checkElementOrder("subType", 3, position, false);
                            builder.subType(this.parseCodeableConcept("subType", reader, -1));
                            break block0;
                        }
                        case "publisher": {
                            position = XMLSupport.checkElementOrder("publisher", 4, position, false);
                            builder.publisher(this.parseReference("publisher", reader, -1));
                            break block0;
                        }
                        case "publicationDate": {
                            position = XMLSupport.checkElementOrder("publicationDate", 5, position, false);
                            builder.publicationDate(this.parseDateTime("publicationDate", reader, -1));
                            break block0;
                        }
                        case "publicationStatus": {
                            position = XMLSupport.checkElementOrder("publicationStatus", 6, position, false);
                            builder.publicationStatus((ContractPublicationStatus)this.parseString(ContractPublicationStatus.builder(), "publicationStatus", reader, -1));
                            break block0;
                        }
                        case "copyright": {
                            position = XMLSupport.checkElementOrder("copyright", 7, position, false);
                            builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Friendly parseContractFriendly(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Friendly.Builder builder = Contract.Friendly.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "contentAttachment": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseAttachment("contentAttachment", reader, -1));
                            break block0;
                        }
                        case "contentReference": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseReference("contentReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Legal parseContractLegal(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Legal.Builder builder = Contract.Legal.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "contentAttachment": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseAttachment("contentAttachment", reader, -1));
                            break block0;
                        }
                        case "contentReference": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseReference("contentReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Rule parseContractRule(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Rule.Builder builder = Contract.Rule.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "contentAttachment": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseAttachment("contentAttachment", reader, -1));
                            break block0;
                        }
                        case "contentReference": {
                            position = XMLSupport.checkElementOrder("content[x]", 2, position, false);
                            builder.content(this.parseReference("contentReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Signer parseContractSigner(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Signer.Builder builder = Contract.Signer.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int signatureElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCoding("type", reader, -1));
                            break block0;
                        }
                        case "party": {
                            position = XMLSupport.checkElementOrder("party", 3, position, false);
                            builder.party(this.parseReference("party", reader, -1));
                            break block0;
                        }
                        case "signature": {
                            position = XMLSupport.checkElementOrder("signature", 4, position, true);
                            builder.signature(this.parseSignature("signature", reader, signatureElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term parseContractTerm(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Builder builder = Contract.Term.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int securityLabelElementIndex = 0;
        int assetElementIndex = 0;
        int actionElementIndex = 0;
        int groupElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 2, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                        case "issued": {
                            position = XMLSupport.checkElementOrder("issued", 3, position, false);
                            builder.issued(this.parseDateTime("issued", reader, -1));
                            break block0;
                        }
                        case "applies": {
                            position = XMLSupport.checkElementOrder("applies", 4, position, false);
                            builder.applies(this.parsePeriod("applies", reader, -1));
                            break block0;
                        }
                        case "topicCodeableConcept": {
                            position = XMLSupport.checkElementOrder("topic[x]", 5, position, false);
                            builder.topic(this.parseCodeableConcept("topicCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "topicReference": {
                            position = XMLSupport.checkElementOrder("topic[x]", 5, position, false);
                            builder.topic(this.parseReference("topicReference", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 6, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "subType": {
                            position = XMLSupport.checkElementOrder("subType", 7, position, false);
                            builder.subType(this.parseCodeableConcept("subType", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 8, position, false);
                            builder.text(this.parseString("text", reader, -1));
                            break block0;
                        }
                        case "securityLabel": {
                            position = XMLSupport.checkElementOrder("securityLabel", 9, position, true);
                            builder.securityLabel(this.parseContractTermSecurityLabel("securityLabel", reader, securityLabelElementIndex++));
                            break block0;
                        }
                        case "offer": {
                            position = XMLSupport.checkElementOrder("offer", 10, position, false);
                            builder.offer(this.parseContractTermOffer("offer", reader, -1));
                            break block0;
                        }
                        case "asset": {
                            position = XMLSupport.checkElementOrder("asset", 11, position, true);
                            builder.asset(this.parseContractTermAsset("asset", reader, assetElementIndex++));
                            break block0;
                        }
                        case "action": {
                            position = XMLSupport.checkElementOrder("action", 12, position, true);
                            builder.action(this.parseContractTermAction("action", reader, actionElementIndex++));
                            break block0;
                        }
                        case "group": {
                            position = XMLSupport.checkElementOrder("group", 13, position, true);
                            builder.group(this.parseContractTerm("group", reader, groupElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Action parseContractTermAction(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Action.Builder builder = Contract.Term.Action.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int subjectElementIndex = 0;
        int linkIdElementIndex = 0;
        int contextLinkIdElementIndex = 0;
        int requesterElementIndex = 0;
        int requesterLinkIdElementIndex = 0;
        int performerTypeElementIndex = 0;
        int performerLinkIdElementIndex = 0;
        int reasonCodeElementIndex = 0;
        int reasonReferenceElementIndex = 0;
        int reasonElementIndex = 0;
        int reasonLinkIdElementIndex = 0;
        int noteElementIndex = 0;
        int securityLabelNumberElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "doNotPerform": {
                            position = XMLSupport.checkElementOrder("doNotPerform", 2, position, false);
                            builder.doNotPerform(this.parseBoolean("doNotPerform", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 4, position, true);
                            builder.subject(this.parseContractTermActionSubject("subject", reader, subjectElementIndex++));
                            break block0;
                        }
                        case "intent": {
                            position = XMLSupport.checkElementOrder("intent", 5, position, false);
                            builder.intent(this.parseCodeableConcept("intent", reader, -1));
                            break block0;
                        }
                        case "linkId": {
                            position = XMLSupport.checkElementOrder("linkId", 6, position, true);
                            builder.linkId(this.parseString("linkId", reader, linkIdElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 7, position, false);
                            builder.status(this.parseCodeableConcept("status", reader, -1));
                            break block0;
                        }
                        case "context": {
                            position = XMLSupport.checkElementOrder("context", 8, position, false);
                            builder.context(this.parseReference("context", reader, -1));
                            break block0;
                        }
                        case "contextLinkId": {
                            position = XMLSupport.checkElementOrder("contextLinkId", 9, position, true);
                            builder.contextLinkId(this.parseString("contextLinkId", reader, contextLinkIdElementIndex++));
                            break block0;
                        }
                        case "occurrenceDateTime": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 10, position, false);
                            builder.occurrence(this.parseDateTime("occurrenceDateTime", reader, -1));
                            break block0;
                        }
                        case "occurrencePeriod": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 10, position, false);
                            builder.occurrence(this.parsePeriod("occurrencePeriod", reader, -1));
                            break block0;
                        }
                        case "occurrenceTiming": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 10, position, false);
                            builder.occurrence(this.parseTiming("occurrenceTiming", reader, -1));
                            break block0;
                        }
                        case "requester": {
                            position = XMLSupport.checkElementOrder("requester", 11, position, true);
                            builder.requester(this.parseReference("requester", reader, requesterElementIndex++));
                            break block0;
                        }
                        case "requesterLinkId": {
                            position = XMLSupport.checkElementOrder("requesterLinkId", 12, position, true);
                            builder.requesterLinkId(this.parseString("requesterLinkId", reader, requesterLinkIdElementIndex++));
                            break block0;
                        }
                        case "performerType": {
                            position = XMLSupport.checkElementOrder("performerType", 13, position, true);
                            builder.performerType(this.parseCodeableConcept("performerType", reader, performerTypeElementIndex++));
                            break block0;
                        }
                        case "performerRole": {
                            position = XMLSupport.checkElementOrder("performerRole", 14, position, false);
                            builder.performerRole(this.parseCodeableConcept("performerRole", reader, -1));
                            break block0;
                        }
                        case "performer": {
                            position = XMLSupport.checkElementOrder("performer", 15, position, false);
                            builder.performer(this.parseReference("performer", reader, -1));
                            break block0;
                        }
                        case "performerLinkId": {
                            position = XMLSupport.checkElementOrder("performerLinkId", 16, position, true);
                            builder.performerLinkId(this.parseString("performerLinkId", reader, performerLinkIdElementIndex++));
                            break block0;
                        }
                        case "reasonCode": {
                            position = XMLSupport.checkElementOrder("reasonCode", 17, position, true);
                            builder.reasonCode(this.parseCodeableConcept("reasonCode", reader, reasonCodeElementIndex++));
                            break block0;
                        }
                        case "reasonReference": {
                            position = XMLSupport.checkElementOrder("reasonReference", 18, position, true);
                            builder.reasonReference(this.parseReference("reasonReference", reader, reasonReferenceElementIndex++));
                            break block0;
                        }
                        case "reason": {
                            position = XMLSupport.checkElementOrder("reason", 19, position, true);
                            builder.reason(this.parseString("reason", reader, reasonElementIndex++));
                            break block0;
                        }
                        case "reasonLinkId": {
                            position = XMLSupport.checkElementOrder("reasonLinkId", 20, position, true);
                            builder.reasonLinkId(this.parseString("reasonLinkId", reader, reasonLinkIdElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 21, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                        case "securityLabelNumber": {
                            position = XMLSupport.checkElementOrder("securityLabelNumber", 22, position, true);
                            builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", reader, securityLabelNumberElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Action.Subject parseContractTermActionSubject(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Action.Subject.Builder builder = Contract.Term.Action.Subject.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int referenceElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 2, position, true);
                            builder.reference(this.parseReference("reference", reader, referenceElementIndex++));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 3, position, false);
                            builder.role(this.parseCodeableConcept("role", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Asset parseContractTermAsset(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Asset.Builder builder = Contract.Term.Asset.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int typeElementIndex = 0;
        int typeReferenceElementIndex = 0;
        int subtypeElementIndex = 0;
        int contextElementIndex = 0;
        int periodTypeElementIndex = 0;
        int periodElementIndex = 0;
        int usePeriodElementIndex = 0;
        int linkIdElementIndex = 0;
        int answerElementIndex = 0;
        int securityLabelNumberElementIndex = 0;
        int valuedItemElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "scope": {
                            position = XMLSupport.checkElementOrder("scope", 2, position, false);
                            builder.scope(this.parseCodeableConcept("scope", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, true);
                            builder.type(this.parseCodeableConcept("type", reader, typeElementIndex++));
                            break block0;
                        }
                        case "typeReference": {
                            position = XMLSupport.checkElementOrder("typeReference", 4, position, true);
                            builder.typeReference(this.parseReference("typeReference", reader, typeReferenceElementIndex++));
                            break block0;
                        }
                        case "subtype": {
                            position = XMLSupport.checkElementOrder("subtype", 5, position, true);
                            builder.subtype(this.parseCodeableConcept("subtype", reader, subtypeElementIndex++));
                            break block0;
                        }
                        case "relationship": {
                            position = XMLSupport.checkElementOrder("relationship", 6, position, false);
                            builder.relationship(this.parseCoding("relationship", reader, -1));
                            break block0;
                        }
                        case "context": {
                            position = XMLSupport.checkElementOrder("context", 7, position, true);
                            builder.context(this.parseContractTermAssetContext("context", reader, contextElementIndex++));
                            break block0;
                        }
                        case "condition": {
                            position = XMLSupport.checkElementOrder("condition", 8, position, false);
                            builder.condition(this.parseString("condition", reader, -1));
                            break block0;
                        }
                        case "periodType": {
                            position = XMLSupport.checkElementOrder("periodType", 9, position, true);
                            builder.periodType(this.parseCodeableConcept("periodType", reader, periodTypeElementIndex++));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 10, position, true);
                            builder.period(this.parsePeriod("period", reader, periodElementIndex++));
                            break block0;
                        }
                        case "usePeriod": {
                            position = XMLSupport.checkElementOrder("usePeriod", 11, position, true);
                            builder.usePeriod(this.parsePeriod("usePeriod", reader, usePeriodElementIndex++));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 12, position, false);
                            builder.text(this.parseString("text", reader, -1));
                            break block0;
                        }
                        case "linkId": {
                            position = XMLSupport.checkElementOrder("linkId", 13, position, true);
                            builder.linkId(this.parseString("linkId", reader, linkIdElementIndex++));
                            break block0;
                        }
                        case "answer": {
                            position = XMLSupport.checkElementOrder("answer", 14, position, true);
                            builder.answer(this.parseContractTermOfferAnswer("answer", reader, answerElementIndex++));
                            break block0;
                        }
                        case "securityLabelNumber": {
                            position = XMLSupport.checkElementOrder("securityLabelNumber", 15, position, true);
                            builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", reader, securityLabelNumberElementIndex++));
                            break block0;
                        }
                        case "valuedItem": {
                            position = XMLSupport.checkElementOrder("valuedItem", 16, position, true);
                            builder.valuedItem(this.parseContractTermAssetValuedItem("valuedItem", reader, valuedItemElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Asset.Context parseContractTermAssetContext(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Asset.Context.Builder builder = Contract.Term.Asset.Context.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int codeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 2, position, false);
                            builder.reference(this.parseReference("reference", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 3, position, true);
                            builder.code(this.parseCodeableConcept("code", reader, codeElementIndex++));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseString("text", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Asset.ValuedItem parseContractTermAssetValuedItem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Asset.ValuedItem.Builder builder = Contract.Term.Asset.ValuedItem.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int linkIdElementIndex = 0;
        int securityLabelNumberElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "entityCodeableConcept": {
                            position = XMLSupport.checkElementOrder("entity[x]", 2, position, false);
                            builder.entity(this.parseCodeableConcept("entityCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "entityReference": {
                            position = XMLSupport.checkElementOrder("entity[x]", 2, position, false);
                            builder.entity(this.parseReference("entityReference", reader, -1));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 3, position, false);
                            builder.identifier(this.parseIdentifier("identifier", reader, -1));
                            break block0;
                        }
                        case "effectiveTime": {
                            position = XMLSupport.checkElementOrder("effectiveTime", 4, position, false);
                            builder.effectiveTime(this.parseDateTime("effectiveTime", reader, -1));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 5, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 6, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "factor": {
                            position = XMLSupport.checkElementOrder("factor", 7, position, false);
                            builder.factor(this.parseDecimal("factor", reader, -1));
                            break block0;
                        }
                        case "points": {
                            position = XMLSupport.checkElementOrder("points", 8, position, false);
                            builder.points(this.parseDecimal("points", reader, -1));
                            break block0;
                        }
                        case "net": {
                            position = XMLSupport.checkElementOrder("net", 9, position, false);
                            builder.net(this.parseMoney("net", reader, -1));
                            break block0;
                        }
                        case "payment": {
                            position = XMLSupport.checkElementOrder("payment", 10, position, false);
                            builder.payment(this.parseString("payment", reader, -1));
                            break block0;
                        }
                        case "paymentDate": {
                            position = XMLSupport.checkElementOrder("paymentDate", 11, position, false);
                            builder.paymentDate(this.parseDateTime("paymentDate", reader, -1));
                            break block0;
                        }
                        case "responsible": {
                            position = XMLSupport.checkElementOrder("responsible", 12, position, false);
                            builder.responsible(this.parseReference("responsible", reader, -1));
                            break block0;
                        }
                        case "recipient": {
                            position = XMLSupport.checkElementOrder("recipient", 13, position, false);
                            builder.recipient(this.parseReference("recipient", reader, -1));
                            break block0;
                        }
                        case "linkId": {
                            position = XMLSupport.checkElementOrder("linkId", 14, position, true);
                            builder.linkId(this.parseString("linkId", reader, linkIdElementIndex++));
                            break block0;
                        }
                        case "securityLabelNumber": {
                            position = XMLSupport.checkElementOrder("securityLabelNumber", 15, position, true);
                            builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", reader, securityLabelNumberElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Offer parseContractTermOffer(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Offer.Builder builder = Contract.Term.Offer.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int partyElementIndex = 0;
        int decisionModeElementIndex = 0;
        int answerElementIndex = 0;
        int linkIdElementIndex = 0;
        int securityLabelNumberElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 2, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "party": {
                            position = XMLSupport.checkElementOrder("party", 3, position, true);
                            builder.party(this.parseContractTermOfferParty("party", reader, partyElementIndex++));
                            break block0;
                        }
                        case "topic": {
                            position = XMLSupport.checkElementOrder("topic", 4, position, false);
                            builder.topic(this.parseReference("topic", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 5, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "decision": {
                            position = XMLSupport.checkElementOrder("decision", 6, position, false);
                            builder.decision(this.parseCodeableConcept("decision", reader, -1));
                            break block0;
                        }
                        case "decisionMode": {
                            position = XMLSupport.checkElementOrder("decisionMode", 7, position, true);
                            builder.decisionMode(this.parseCodeableConcept("decisionMode", reader, decisionModeElementIndex++));
                            break block0;
                        }
                        case "answer": {
                            position = XMLSupport.checkElementOrder("answer", 8, position, true);
                            builder.answer(this.parseContractTermOfferAnswer("answer", reader, answerElementIndex++));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 9, position, false);
                            builder.text(this.parseString("text", reader, -1));
                            break block0;
                        }
                        case "linkId": {
                            position = XMLSupport.checkElementOrder("linkId", 10, position, true);
                            builder.linkId(this.parseString("linkId", reader, linkIdElementIndex++));
                            break block0;
                        }
                        case "securityLabelNumber": {
                            position = XMLSupport.checkElementOrder("securityLabelNumber", 11, position, true);
                            builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", reader, securityLabelNumberElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Offer.Answer parseContractTermOfferAnswer(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Offer.Answer.Builder builder = Contract.Term.Offer.Answer.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "valueBoolean": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseBoolean("valueBoolean", reader, -1));
                            break block0;
                        }
                        case "valueDecimal": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseDecimal("valueDecimal", reader, -1));
                            break block0;
                        }
                        case "valueInteger": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseInteger("valueInteger", reader, -1));
                            break block0;
                        }
                        case "valueDate": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseDate("valueDate", reader, -1));
                            break block0;
                        }
                        case "valueDateTime": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseDateTime("valueDateTime", reader, -1));
                            break block0;
                        }
                        case "valueTime": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseTime("valueTime", reader, -1));
                            break block0;
                        }
                        case "valueString": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseString("valueString", reader, -1));
                            break block0;
                        }
                        case "valueUri": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseUri("valueUri", reader, -1));
                            break block0;
                        }
                        case "valueAttachment": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseAttachment("valueAttachment", reader, -1));
                            break block0;
                        }
                        case "valueCoding": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseCoding("valueCoding", reader, -1));
                            break block0;
                        }
                        case "valueQuantity": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseQuantity("valueQuantity", reader, -1));
                            break block0;
                        }
                        case "valueReference": {
                            position = XMLSupport.checkElementOrder("value[x]", 2, position, false);
                            builder.value(this.parseReference("valueReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.Offer.Party parseContractTermOfferParty(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.Offer.Party.Builder builder = Contract.Term.Offer.Party.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int referenceElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 2, position, true);
                            builder.reference(this.parseReference("reference", reader, referenceElementIndex++));
                            break block0;
                        }
                        case "role": {
                            position = XMLSupport.checkElementOrder("role", 3, position, false);
                            builder.role(this.parseCodeableConcept("role", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contract.Term.SecurityLabel parseContractTermSecurityLabel(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contract.Term.SecurityLabel.Builder builder = Contract.Term.SecurityLabel.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int numberElementIndex = 0;
        int categoryElementIndex = 0;
        int controlElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "number": {
                            position = XMLSupport.checkElementOrder("number", 2, position, true);
                            builder.number((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "number", reader, numberElementIndex++));
                            break block0;
                        }
                        case "classification": {
                            position = XMLSupport.checkElementOrder("classification", 3, position, false);
                            builder.classification(this.parseCoding("classification", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 4, position, true);
                            builder.category(this.parseCoding("category", reader, categoryElementIndex++));
                            break block0;
                        }
                        case "control": {
                            position = XMLSupport.checkElementOrder("control", 5, position, true);
                            builder.control(this.parseCoding("control", reader, controlElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Contributor parseContributor(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Contributor.Builder builder = Contributor.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int contactElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 1, position, false);
                            builder.type((ContributorType)this.parseString(ContributorType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 2, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 3, position, true);
                            builder.contact(this.parseContactDetail("contact", reader, contactElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Coverage parseCoverage(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Coverage.Builder builder = Coverage.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int payorElementIndex = 0;
        int classElementIndex = 0;
        int costToBeneficiaryElementIndex = 0;
        int contractElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((CoverageStatus)this.parseString(CoverageStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 10, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "policyHolder": {
                            position = XMLSupport.checkElementOrder("policyHolder", 11, position, false);
                            builder.policyHolder(this.parseReference("policyHolder", reader, -1));
                            break block0;
                        }
                        case "subscriber": {
                            position = XMLSupport.checkElementOrder("subscriber", 12, position, false);
                            builder.subscriber(this.parseReference("subscriber", reader, -1));
                            break block0;
                        }
                        case "subscriberId": {
                            position = XMLSupport.checkElementOrder("subscriberId", 13, position, false);
                            builder.subscriberId(this.parseString("subscriberId", reader, -1));
                            break block0;
                        }
                        case "beneficiary": {
                            position = XMLSupport.checkElementOrder("beneficiary", 14, position, false);
                            builder.beneficiary(this.parseReference("beneficiary", reader, -1));
                            break block0;
                        }
                        case "dependent": {
                            position = XMLSupport.checkElementOrder("dependent", 15, position, false);
                            builder.dependent(this.parseString("dependent", reader, -1));
                            break block0;
                        }
                        case "relationship": {
                            position = XMLSupport.checkElementOrder("relationship", 16, position, false);
                            builder.relationship(this.parseCodeableConcept("relationship", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 17, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                        case "payor": {
                            position = XMLSupport.checkElementOrder("payor", 18, position, true);
                            builder.payor(this.parseReference("payor", reader, payorElementIndex++));
                            break block0;
                        }
                        case "class": {
                            position = XMLSupport.checkElementOrder("class", 19, position, true);
                            builder.clazz(this.parseCoverageClass("class", reader, classElementIndex++));
                            break block0;
                        }
                        case "order": {
                            position = XMLSupport.checkElementOrder("order", 20, position, false);
                            builder.order((PositiveInt)this.parseInteger(PositiveInt.builder(), "order", reader, -1));
                            break block0;
                        }
                        case "network": {
                            position = XMLSupport.checkElementOrder("network", 21, position, false);
                            builder.network(this.parseString("network", reader, -1));
                            break block0;
                        }
                        case "costToBeneficiary": {
                            position = XMLSupport.checkElementOrder("costToBeneficiary", 22, position, true);
                            builder.costToBeneficiary(this.parseCoverageCostToBeneficiary("costToBeneficiary", reader, costToBeneficiaryElementIndex++));
                            break block0;
                        }
                        case "subrogation": {
                            position = XMLSupport.checkElementOrder("subrogation", 23, position, false);
                            builder.subrogation(this.parseBoolean("subrogation", reader, -1));
                            break block0;
                        }
                        case "contract": {
                            position = XMLSupport.checkElementOrder("contract", 24, position, true);
                            builder.contract(this.parseReference("contract", reader, contractElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Coverage.Class parseCoverageClass(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Coverage.Class.Builder builder = Coverage.Class.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "value": {
                            position = XMLSupport.checkElementOrder("value", 3, position, false);
                            builder.value(this.parseString("value", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 4, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Coverage.CostToBeneficiary parseCoverageCostToBeneficiary(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Coverage.CostToBeneficiary.Builder builder = Coverage.CostToBeneficiary.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int exceptionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "valueQuantity": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "valueQuantity", reader, -1));
                            break block0;
                        }
                        case "valueMoney": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseMoney("valueMoney", reader, -1));
                            break block0;
                        }
                        case "exception": {
                            position = XMLSupport.checkElementOrder("exception", 4, position, true);
                            builder.exception(this.parseCoverageCostToBeneficiaryException("exception", reader, exceptionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Coverage.CostToBeneficiary.Exception parseCoverageCostToBeneficiaryException(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Coverage.CostToBeneficiary.Exception.Builder builder = Coverage.CostToBeneficiary.Exception.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "period": {
                            position = XMLSupport.checkElementOrder("period", 3, position, false);
                            builder.period(this.parsePeriod("period", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityRequest parseCoverageEligibilityRequest(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityRequest.Builder builder = CoverageEligibilityRequest.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int purposeElementIndex = 0;
        int supportingInfoElementIndex = 0;
        int insuranceElementIndex = 0;
        int itemElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((EligibilityRequestStatus)this.parseString(EligibilityRequestStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 10, position, false);
                            builder.priority(this.parseCodeableConcept("priority", reader, -1));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 11, position, true);
                            builder.purpose((EligibilityRequestPurpose)this.parseString(EligibilityRequestPurpose.builder(), "purpose", reader, purposeElementIndex++));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 12, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "servicedDate": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 13, position, false);
                            builder.serviced(this.parseDate("servicedDate", reader, -1));
                            break block0;
                        }
                        case "servicedPeriod": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 13, position, false);
                            builder.serviced(this.parsePeriod("servicedPeriod", reader, -1));
                            break block0;
                        }
                        case "created": {
                            position = XMLSupport.checkElementOrder("created", 14, position, false);
                            builder.created(this.parseDateTime("created", reader, -1));
                            break block0;
                        }
                        case "enterer": {
                            position = XMLSupport.checkElementOrder("enterer", 15, position, false);
                            builder.enterer(this.parseReference("enterer", reader, -1));
                            break block0;
                        }
                        case "provider": {
                            position = XMLSupport.checkElementOrder("provider", 16, position, false);
                            builder.provider(this.parseReference("provider", reader, -1));
                            break block0;
                        }
                        case "insurer": {
                            position = XMLSupport.checkElementOrder("insurer", 17, position, false);
                            builder.insurer(this.parseReference("insurer", reader, -1));
                            break block0;
                        }
                        case "facility": {
                            position = XMLSupport.checkElementOrder("facility", 18, position, false);
                            builder.facility(this.parseReference("facility", reader, -1));
                            break block0;
                        }
                        case "supportingInfo": {
                            position = XMLSupport.checkElementOrder("supportingInfo", 19, position, true);
                            builder.supportingInfo(this.parseCoverageEligibilityRequestSupportingInfo("supportingInfo", reader, supportingInfoElementIndex++));
                            break block0;
                        }
                        case "insurance": {
                            position = XMLSupport.checkElementOrder("insurance", 20, position, true);
                            builder.insurance(this.parseCoverageEligibilityRequestInsurance("insurance", reader, insuranceElementIndex++));
                            break block0;
                        }
                        case "item": {
                            position = XMLSupport.checkElementOrder("item", 21, position, true);
                            builder.item(this.parseCoverageEligibilityRequestItem("item", reader, itemElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityRequest.Insurance parseCoverageEligibilityRequestInsurance(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityRequest.Insurance.Builder builder = CoverageEligibilityRequest.Insurance.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "focal": {
                            position = XMLSupport.checkElementOrder("focal", 2, position, false);
                            builder.focal(this.parseBoolean("focal", reader, -1));
                            break block0;
                        }
                        case "coverage": {
                            position = XMLSupport.checkElementOrder("coverage", 3, position, false);
                            builder.coverage(this.parseReference("coverage", reader, -1));
                            break block0;
                        }
                        case "businessArrangement": {
                            position = XMLSupport.checkElementOrder("businessArrangement", 4, position, false);
                            builder.businessArrangement(this.parseString("businessArrangement", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityRequest.Item parseCoverageEligibilityRequestItem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityRequest.Item.Builder builder = CoverageEligibilityRequest.Item.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int supportingInfoSequenceElementIndex = 0;
        int modifierElementIndex = 0;
        int diagnosisElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "supportingInfoSequence": {
                            position = XMLSupport.checkElementOrder("supportingInfoSequence", 2, position, true);
                            builder.supportingInfoSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "supportingInfoSequence", reader, supportingInfoSequenceElementIndex++));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 3, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 4, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 5, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "provider": {
                            position = XMLSupport.checkElementOrder("provider", 6, position, false);
                            builder.provider(this.parseReference("provider", reader, -1));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 7, position, false);
                            builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", reader, -1));
                            break block0;
                        }
                        case "unitPrice": {
                            position = XMLSupport.checkElementOrder("unitPrice", 8, position, false);
                            builder.unitPrice(this.parseMoney("unitPrice", reader, -1));
                            break block0;
                        }
                        case "facility": {
                            position = XMLSupport.checkElementOrder("facility", 9, position, false);
                            builder.facility(this.parseReference("facility", reader, -1));
                            break block0;
                        }
                        case "diagnosis": {
                            position = XMLSupport.checkElementOrder("diagnosis", 10, position, true);
                            builder.diagnosis(this.parseCoverageEligibilityRequestItemDiagnosis("diagnosis", reader, diagnosisElementIndex++));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 11, position, true);
                            builder.detail(this.parseReference("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityRequest.Item.Diagnosis parseCoverageEligibilityRequestItemDiagnosis(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityRequest.Item.Diagnosis.Builder builder = CoverageEligibilityRequest.Item.Diagnosis.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "diagnosisCodeableConcept": {
                            position = XMLSupport.checkElementOrder("diagnosis[x]", 2, position, false);
                            builder.diagnosis(this.parseCodeableConcept("diagnosisCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "diagnosisReference": {
                            position = XMLSupport.checkElementOrder("diagnosis[x]", 2, position, false);
                            builder.diagnosis(this.parseReference("diagnosisReference", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityRequest.SupportingInfo parseCoverageEligibilityRequestSupportingInfo(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityRequest.SupportingInfo.Builder builder = CoverageEligibilityRequest.SupportingInfo.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "sequence": {
                            position = XMLSupport.checkElementOrder("sequence", 2, position, false);
                            builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", reader, -1));
                            break block0;
                        }
                        case "information": {
                            position = XMLSupport.checkElementOrder("information", 3, position, false);
                            builder.information(this.parseReference("information", reader, -1));
                            break block0;
                        }
                        case "appliesToAll": {
                            position = XMLSupport.checkElementOrder("appliesToAll", 4, position, false);
                            builder.appliesToAll(this.parseBoolean("appliesToAll", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityResponse parseCoverageEligibilityResponse(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityResponse.Builder builder = CoverageEligibilityResponse.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int purposeElementIndex = 0;
        int insuranceElementIndex = 0;
        int errorElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((EligibilityResponseStatus)this.parseString(EligibilityResponseStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "purpose": {
                            position = XMLSupport.checkElementOrder("purpose", 10, position, true);
                            builder.purpose((EligibilityResponsePurpose)this.parseString(EligibilityResponsePurpose.builder(), "purpose", reader, purposeElementIndex++));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 11, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "servicedDate": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 12, position, false);
                            builder.serviced(this.parseDate("servicedDate", reader, -1));
                            break block0;
                        }
                        case "servicedPeriod": {
                            position = XMLSupport.checkElementOrder("serviced[x]", 12, position, false);
                            builder.serviced(this.parsePeriod("servicedPeriod", reader, -1));
                            break block0;
                        }
                        case "created": {
                            position = XMLSupport.checkElementOrder("created", 13, position, false);
                            builder.created(this.parseDateTime("created", reader, -1));
                            break block0;
                        }
                        case "requestor": {
                            position = XMLSupport.checkElementOrder("requestor", 14, position, false);
                            builder.requestor(this.parseReference("requestor", reader, -1));
                            break block0;
                        }
                        case "request": {
                            position = XMLSupport.checkElementOrder("request", 15, position, false);
                            builder.request(this.parseReference("request", reader, -1));
                            break block0;
                        }
                        case "outcome": {
                            position = XMLSupport.checkElementOrder("outcome", 16, position, false);
                            builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", reader, -1));
                            break block0;
                        }
                        case "disposition": {
                            position = XMLSupport.checkElementOrder("disposition", 17, position, false);
                            builder.disposition(this.parseString("disposition", reader, -1));
                            break block0;
                        }
                        case "insurer": {
                            position = XMLSupport.checkElementOrder("insurer", 18, position, false);
                            builder.insurer(this.parseReference("insurer", reader, -1));
                            break block0;
                        }
                        case "insurance": {
                            position = XMLSupport.checkElementOrder("insurance", 19, position, true);
                            builder.insurance(this.parseCoverageEligibilityResponseInsurance("insurance", reader, insuranceElementIndex++));
                            break block0;
                        }
                        case "preAuthRef": {
                            position = XMLSupport.checkElementOrder("preAuthRef", 20, position, false);
                            builder.preAuthRef(this.parseString("preAuthRef", reader, -1));
                            break block0;
                        }
                        case "form": {
                            position = XMLSupport.checkElementOrder("form", 21, position, false);
                            builder.form(this.parseCodeableConcept("form", reader, -1));
                            break block0;
                        }
                        case "error": {
                            position = XMLSupport.checkElementOrder("error", 22, position, true);
                            builder.error(this.parseCoverageEligibilityResponseError("error", reader, errorElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityResponse.Error parseCoverageEligibilityResponseError(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityResponse.Error.Builder builder = CoverageEligibilityResponse.Error.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityResponse.Insurance parseCoverageEligibilityResponseInsurance(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityResponse.Insurance.Builder builder = CoverageEligibilityResponse.Insurance.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int itemElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "coverage": {
                            position = XMLSupport.checkElementOrder("coverage", 2, position, false);
                            builder.coverage(this.parseReference("coverage", reader, -1));
                            break block0;
                        }
                        case "inforce": {
                            position = XMLSupport.checkElementOrder("inforce", 3, position, false);
                            builder.inforce(this.parseBoolean("inforce", reader, -1));
                            break block0;
                        }
                        case "benefitPeriod": {
                            position = XMLSupport.checkElementOrder("benefitPeriod", 4, position, false);
                            builder.benefitPeriod(this.parsePeriod("benefitPeriod", reader, -1));
                            break block0;
                        }
                        case "item": {
                            position = XMLSupport.checkElementOrder("item", 5, position, true);
                            builder.item(this.parseCoverageEligibilityResponseInsuranceItem("item", reader, itemElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityResponse.Insurance.Item parseCoverageEligibilityResponseInsuranceItem(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityResponse.Insurance.Item.Builder builder = CoverageEligibilityResponse.Insurance.Item.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int modifierElementIndex = 0;
        int benefitElementIndex = 0;
        int authorizationSupportingElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 2, position, false);
                            builder.category(this.parseCodeableConcept("category", reader, -1));
                            break block0;
                        }
                        case "productOrService": {
                            position = XMLSupport.checkElementOrder("productOrService", 3, position, false);
                            builder.productOrService(this.parseCodeableConcept("productOrService", reader, -1));
                            break block0;
                        }
                        case "modifier": {
                            position = XMLSupport.checkElementOrder("modifier", 4, position, true);
                            builder.modifier(this.parseCodeableConcept("modifier", reader, modifierElementIndex++));
                            break block0;
                        }
                        case "provider": {
                            position = XMLSupport.checkElementOrder("provider", 5, position, false);
                            builder.provider(this.parseReference("provider", reader, -1));
                            break block0;
                        }
                        case "excluded": {
                            position = XMLSupport.checkElementOrder("excluded", 6, position, false);
                            builder.excluded(this.parseBoolean("excluded", reader, -1));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 7, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 8, position, false);
                            builder.description(this.parseString("description", reader, -1));
                            break block0;
                        }
                        case "network": {
                            position = XMLSupport.checkElementOrder("network", 9, position, false);
                            builder.network(this.parseCodeableConcept("network", reader, -1));
                            break block0;
                        }
                        case "unit": {
                            position = XMLSupport.checkElementOrder("unit", 10, position, false);
                            builder.unit(this.parseCodeableConcept("unit", reader, -1));
                            break block0;
                        }
                        case "term": {
                            position = XMLSupport.checkElementOrder("term", 11, position, false);
                            builder.term(this.parseCodeableConcept("term", reader, -1));
                            break block0;
                        }
                        case "benefit": {
                            position = XMLSupport.checkElementOrder("benefit", 12, position, true);
                            builder.benefit(this.parseCoverageEligibilityResponseInsuranceItemBenefit("benefit", reader, benefitElementIndex++));
                            break block0;
                        }
                        case "authorizationRequired": {
                            position = XMLSupport.checkElementOrder("authorizationRequired", 13, position, false);
                            builder.authorizationRequired(this.parseBoolean("authorizationRequired", reader, -1));
                            break block0;
                        }
                        case "authorizationSupporting": {
                            position = XMLSupport.checkElementOrder("authorizationSupporting", 14, position, true);
                            builder.authorizationSupporting(this.parseCodeableConcept("authorizationSupporting", reader, authorizationSupportingElementIndex++));
                            break block0;
                        }
                        case "authorizationUrl": {
                            position = XMLSupport.checkElementOrder("authorizationUrl", 15, position, false);
                            builder.authorizationUrl(this.parseUri("authorizationUrl", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private CoverageEligibilityResponse.Insurance.Item.Benefit parseCoverageEligibilityResponseInsuranceItemBenefit(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        CoverageEligibilityResponse.Insurance.Item.Benefit.Builder builder = CoverageEligibilityResponse.Insurance.Item.Benefit.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "allowedUnsignedInt": {
                            position = XMLSupport.checkElementOrder("allowed[x]", 3, position, false);
                            builder.allowed((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "allowedUnsignedInt", reader, -1));
                            break block0;
                        }
                        case "allowedString": {
                            position = XMLSupport.checkElementOrder("allowed[x]", 3, position, false);
                            builder.allowed(this.parseString("allowedString", reader, -1));
                            break block0;
                        }
                        case "allowedMoney": {
                            position = XMLSupport.checkElementOrder("allowed[x]", 3, position, false);
                            builder.allowed(this.parseMoney("allowedMoney", reader, -1));
                            break block0;
                        }
                        case "usedUnsignedInt": {
                            position = XMLSupport.checkElementOrder("used[x]", 4, position, false);
                            builder.used((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "usedUnsignedInt", reader, -1));
                            break block0;
                        }
                        case "usedString": {
                            position = XMLSupport.checkElementOrder("used[x]", 4, position, false);
                            builder.used(this.parseString("usedString", reader, -1));
                            break block0;
                        }
                        case "usedMoney": {
                            position = XMLSupport.checkElementOrder("used[x]", 4, position, false);
                            builder.used(this.parseMoney("usedMoney", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DataRequirement parseDataRequirement(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DataRequirement.Builder builder = DataRequirement.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int profileElementIndex = 0;
        int mustSupportElementIndex = 0;
        int codeFilterElementIndex = 0;
        int dateFilterElementIndex = 0;
        int sortElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 1, position, false);
                            builder.type((FHIRAllTypes)this.parseString(FHIRAllTypes.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "profile": {
                            position = XMLSupport.checkElementOrder("profile", 2, position, true);
                            builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", reader, profileElementIndex++));
                            break block0;
                        }
                        case "subjectCodeableConcept": {
                            position = XMLSupport.checkElementOrder("subject[x]", 3, position, false);
                            builder.subject(this.parseCodeableConcept("subjectCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "subjectReference": {
                            position = XMLSupport.checkElementOrder("subject[x]", 3, position, false);
                            builder.subject(this.parseReference("subjectReference", reader, -1));
                            break block0;
                        }
                        case "mustSupport": {
                            position = XMLSupport.checkElementOrder("mustSupport", 4, position, true);
                            builder.mustSupport(this.parseString("mustSupport", reader, mustSupportElementIndex++));
                            break block0;
                        }
                        case "codeFilter": {
                            position = XMLSupport.checkElementOrder("codeFilter", 5, position, true);
                            builder.codeFilter(this.parseDataRequirementCodeFilter("codeFilter", reader, codeFilterElementIndex++));
                            break block0;
                        }
                        case "dateFilter": {
                            position = XMLSupport.checkElementOrder("dateFilter", 6, position, true);
                            builder.dateFilter(this.parseDataRequirementDateFilter("dateFilter", reader, dateFilterElementIndex++));
                            break block0;
                        }
                        case "limit": {
                            position = XMLSupport.checkElementOrder("limit", 7, position, false);
                            builder.limit((PositiveInt)this.parseInteger(PositiveInt.builder(), "limit", reader, -1));
                            break block0;
                        }
                        case "sort": {
                            position = XMLSupport.checkElementOrder("sort", 8, position, true);
                            builder.sort(this.parseDataRequirementSort("sort", reader, sortElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DataRequirement.CodeFilter parseDataRequirementCodeFilter(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DataRequirement.CodeFilter.Builder builder = DataRequirement.CodeFilter.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int codeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "path": {
                            position = XMLSupport.checkElementOrder("path", 2, position, false);
                            builder.path(this.parseString("path", reader, -1));
                            break block0;
                        }
                        case "searchParam": {
                            position = XMLSupport.checkElementOrder("searchParam", 3, position, false);
                            builder.searchParam(this.parseString("searchParam", reader, -1));
                            break block0;
                        }
                        case "valueSet": {
                            position = XMLSupport.checkElementOrder("valueSet", 4, position, false);
                            builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 5, position, true);
                            builder.code(this.parseCoding("code", reader, codeElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DataRequirement.DateFilter parseDataRequirementDateFilter(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DataRequirement.DateFilter.Builder builder = DataRequirement.DateFilter.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "path": {
                            position = XMLSupport.checkElementOrder("path", 2, position, false);
                            builder.path(this.parseString("path", reader, -1));
                            break block0;
                        }
                        case "searchParam": {
                            position = XMLSupport.checkElementOrder("searchParam", 3, position, false);
                            builder.searchParam(this.parseString("searchParam", reader, -1));
                            break block0;
                        }
                        case "valueDateTime": {
                            position = XMLSupport.checkElementOrder("value[x]", 4, position, false);
                            builder.value(this.parseDateTime("valueDateTime", reader, -1));
                            break block0;
                        }
                        case "valuePeriod": {
                            position = XMLSupport.checkElementOrder("value[x]", 4, position, false);
                            builder.value(this.parsePeriod("valuePeriod", reader, -1));
                            break block0;
                        }
                        case "valueDuration": {
                            position = XMLSupport.checkElementOrder("value[x]", 4, position, false);
                            builder.value((Duration)this.parseQuantity(Duration.builder(), "valueDuration", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DataRequirement.Sort parseDataRequirementSort(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DataRequirement.Sort.Builder builder = DataRequirement.Sort.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "path": {
                            position = XMLSupport.checkElementOrder("path", 2, position, false);
                            builder.path(this.parseString("path", reader, -1));
                            break block0;
                        }
                        case "direction": {
                            position = XMLSupport.checkElementOrder("direction", 3, position, false);
                            builder.direction((SortDirection)this.parseString(SortDirection.builder(), "direction", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Date parseDate(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        String value;
        this.stackPush(elementName, elementIndex);
        Date.Builder builder = Date.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        if ((value = reader.getAttributeValue(null, "value")) != null) {
            builder.value(value);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DateTime parseDateTime(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        String value;
        this.stackPush(elementName, elementIndex);
        DateTime.Builder builder = DateTime.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        if ((value = reader.getAttributeValue(null, "value")) != null) {
            builder.value(value);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Decimal parseDecimal(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        String value;
        this.stackPush(elementName, elementIndex);
        Decimal.Builder builder = Decimal.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        if ((value = reader.getAttributeValue(null, "value")) != null) {
            builder.value(value);
        }
        int position = -1;
        int extensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DetectedIssue parseDetectedIssue(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DetectedIssue.Builder builder = DetectedIssue.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int implicatedElementIndex = 0;
        int evidenceElementIndex = 0;
        int mitigationElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 9, position, false);
                            builder.status((DetectedIssueStatus)this.parseString(DetectedIssueStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 10, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "severity": {
                            position = XMLSupport.checkElementOrder("severity", 11, position, false);
                            builder.severity((DetectedIssueSeverity)this.parseString(DetectedIssueSeverity.builder(), "severity", reader, -1));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 12, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "identifiedDateTime": {
                            position = XMLSupport.checkElementOrder("identified[x]", 13, position, false);
                            builder.identified(this.parseDateTime("identifiedDateTime", reader, -1));
                            break block0;
                        }
                        case "identifiedPeriod": {
                            position = XMLSupport.checkElementOrder("identified[x]", 13, position, false);
                            builder.identified(this.parsePeriod("identifiedPeriod", reader, -1));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 14, position, false);
                            builder.author(this.parseReference("author", reader, -1));
                            break block0;
                        }
                        case "implicated": {
                            position = XMLSupport.checkElementOrder("implicated", 15, position, true);
                            builder.implicated(this.parseReference("implicated", reader, implicatedElementIndex++));
                            break block0;
                        }
                        case "evidence": {
                            position = XMLSupport.checkElementOrder("evidence", 16, position, true);
                            builder.evidence(this.parseDetectedIssueEvidence("evidence", reader, evidenceElementIndex++));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 17, position, false);
                            builder.detail(this.parseString("detail", reader, -1));
                            break block0;
                        }
                        case "reference": {
                            position = XMLSupport.checkElementOrder("reference", 18, position, false);
                            builder.reference(this.parseUri("reference", reader, -1));
                            break block0;
                        }
                        case "mitigation": {
                            position = XMLSupport.checkElementOrder("mitigation", 19, position, true);
                            builder.mitigation(this.parseDetectedIssueMitigation("mitigation", reader, mitigationElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DetectedIssue.Evidence parseDetectedIssueEvidence(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DetectedIssue.Evidence.Builder builder = DetectedIssue.Evidence.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int codeElementIndex = 0;
        int detailElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, true);
                            builder.code(this.parseCodeableConcept("code", reader, codeElementIndex++));
                            break block0;
                        }
                        case "detail": {
                            position = XMLSupport.checkElementOrder("detail", 3, position, true);
                            builder.detail(this.parseReference("detail", reader, detailElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DetectedIssue.Mitigation parseDetectedIssueMitigation(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DetectedIssue.Mitigation.Builder builder = DetectedIssue.Mitigation.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "action": {
                            position = XMLSupport.checkElementOrder("action", 2, position, false);
                            builder.action(this.parseCodeableConcept("action", reader, -1));
                            break block0;
                        }
                        case "date": {
                            position = XMLSupport.checkElementOrder("date", 3, position, false);
                            builder.date(this.parseDateTime("date", reader, -1));
                            break block0;
                        }
                        case "author": {
                            position = XMLSupport.checkElementOrder("author", 4, position, false);
                            builder.author(this.parseReference("author", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Device parseDevice(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Device.Builder builder = Device.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int udiCarrierElementIndex = 0;
        int statusReasonElementIndex = 0;
        int deviceNameElementIndex = 0;
        int specializationElementIndex = 0;
        int versionElementIndex = 0;
        int propertyElementIndex = 0;
        int contactElementIndex = 0;
        int noteElementIndex = 0;
        int safetyElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "definition": {
                            position = XMLSupport.checkElementOrder("definition", 9, position, false);
                            builder.definition(this.parseReference("definition", reader, -1));
                            break block0;
                        }
                        case "udiCarrier": {
                            position = XMLSupport.checkElementOrder("udiCarrier", 10, position, true);
                            builder.udiCarrier(this.parseDeviceUdiCarrier("udiCarrier", reader, udiCarrierElementIndex++));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 11, position, false);
                            builder.status((FHIRDeviceStatus)this.parseString(FHIRDeviceStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "statusReason": {
                            position = XMLSupport.checkElementOrder("statusReason", 12, position, true);
                            builder.statusReason(this.parseCodeableConcept("statusReason", reader, statusReasonElementIndex++));
                            break block0;
                        }
                        case "distinctIdentifier": {
                            position = XMLSupport.checkElementOrder("distinctIdentifier", 13, position, false);
                            builder.distinctIdentifier(this.parseString("distinctIdentifier", reader, -1));
                            break block0;
                        }
                        case "manufacturer": {
                            position = XMLSupport.checkElementOrder("manufacturer", 14, position, false);
                            builder.manufacturer(this.parseString("manufacturer", reader, -1));
                            break block0;
                        }
                        case "manufactureDate": {
                            position = XMLSupport.checkElementOrder("manufactureDate", 15, position, false);
                            builder.manufactureDate(this.parseDateTime("manufactureDate", reader, -1));
                            break block0;
                        }
                        case "expirationDate": {
                            position = XMLSupport.checkElementOrder("expirationDate", 16, position, false);
                            builder.expirationDate(this.parseDateTime("expirationDate", reader, -1));
                            break block0;
                        }
                        case "lotNumber": {
                            position = XMLSupport.checkElementOrder("lotNumber", 17, position, false);
                            builder.lotNumber(this.parseString("lotNumber", reader, -1));
                            break block0;
                        }
                        case "serialNumber": {
                            position = XMLSupport.checkElementOrder("serialNumber", 18, position, false);
                            builder.serialNumber(this.parseString("serialNumber", reader, -1));
                            break block0;
                        }
                        case "deviceName": {
                            position = XMLSupport.checkElementOrder("deviceName", 19, position, true);
                            builder.deviceName(this.parseDeviceDeviceName("deviceName", reader, deviceNameElementIndex++));
                            break block0;
                        }
                        case "modelNumber": {
                            position = XMLSupport.checkElementOrder("modelNumber", 20, position, false);
                            builder.modelNumber(this.parseString("modelNumber", reader, -1));
                            break block0;
                        }
                        case "partNumber": {
                            position = XMLSupport.checkElementOrder("partNumber", 21, position, false);
                            builder.partNumber(this.parseString("partNumber", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 22, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "specialization": {
                            position = XMLSupport.checkElementOrder("specialization", 23, position, true);
                            builder.specialization(this.parseDeviceSpecialization("specialization", reader, specializationElementIndex++));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 24, position, true);
                            builder.version(this.parseDeviceVersion("version", reader, versionElementIndex++));
                            break block0;
                        }
                        case "property": {
                            position = XMLSupport.checkElementOrder("property", 25, position, true);
                            builder.property(this.parseDeviceProperty("property", reader, propertyElementIndex++));
                            break block0;
                        }
                        case "patient": {
                            position = XMLSupport.checkElementOrder("patient", 26, position, false);
                            builder.patient(this.parseReference("patient", reader, -1));
                            break block0;
                        }
                        case "owner": {
                            position = XMLSupport.checkElementOrder("owner", 27, position, false);
                            builder.owner(this.parseReference("owner", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 28, position, true);
                            builder.contact(this.parseContactPoint("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "location": {
                            position = XMLSupport.checkElementOrder("location", 29, position, false);
                            builder.location(this.parseReference("location", reader, -1));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 30, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 31, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                        case "safety": {
                            position = XMLSupport.checkElementOrder("safety", 32, position, true);
                            builder.safety(this.parseCodeableConcept("safety", reader, safetyElementIndex++));
                            break block0;
                        }
                        case "parent": {
                            position = XMLSupport.checkElementOrder("parent", 33, position, false);
                            builder.parent(this.parseReference("parent", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Device.DeviceName parseDeviceDeviceName(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Device.DeviceName.Builder builder = Device.DeviceName.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 2, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, false);
                            builder.type((DeviceNameType)this.parseString(DeviceNameType.builder(), "type", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Device.Property parseDeviceProperty(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Device.Property.Builder builder = Device.Property.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int valueQuantityElementIndex = 0;
        int valueCodeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "valueQuantity": {
                            position = XMLSupport.checkElementOrder("valueQuantity", 3, position, true);
                            builder.valueQuantity(this.parseQuantity("valueQuantity", reader, valueQuantityElementIndex++));
                            break block0;
                        }
                        case "valueCode": {
                            position = XMLSupport.checkElementOrder("valueCode", 4, position, true);
                            builder.valueCode(this.parseCodeableConcept("valueCode", reader, valueCodeElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Device.Specialization parseDeviceSpecialization(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Device.Specialization.Builder builder = Device.Specialization.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "systemType": {
                            position = XMLSupport.checkElementOrder("systemType", 2, position, false);
                            builder.systemType(this.parseCodeableConcept("systemType", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 3, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Device.UdiCarrier parseDeviceUdiCarrier(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Device.UdiCarrier.Builder builder = Device.UdiCarrier.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "deviceIdentifier": {
                            position = XMLSupport.checkElementOrder("deviceIdentifier", 2, position, false);
                            builder.deviceIdentifier(this.parseString("deviceIdentifier", reader, -1));
                            break block0;
                        }
                        case "issuer": {
                            position = XMLSupport.checkElementOrder("issuer", 3, position, false);
                            builder.issuer(this.parseUri("issuer", reader, -1));
                            break block0;
                        }
                        case "jurisdiction": {
                            position = XMLSupport.checkElementOrder("jurisdiction", 4, position, false);
                            builder.jurisdiction(this.parseUri("jurisdiction", reader, -1));
                            break block0;
                        }
                        case "carrierAIDC": {
                            position = XMLSupport.checkElementOrder("carrierAIDC", 5, position, false);
                            builder.carrierAIDC(this.parseBase64Binary("carrierAIDC", reader, -1));
                            break block0;
                        }
                        case "carrierHRF": {
                            position = XMLSupport.checkElementOrder("carrierHRF", 6, position, false);
                            builder.carrierHRF(this.parseString("carrierHRF", reader, -1));
                            break block0;
                        }
                        case "entryType": {
                            position = XMLSupport.checkElementOrder("entryType", 7, position, false);
                            builder.entryType((UDIEntryType)this.parseString(UDIEntryType.builder(), "entryType", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private Device.Version parseDeviceVersion(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        Device.Version.Builder builder = Device.Version.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "component": {
                            position = XMLSupport.checkElementOrder("component", 3, position, false);
                            builder.component(this.parseIdentifier("component", reader, -1));
                            break block0;
                        }
                        case "value": {
                            position = XMLSupport.checkElementOrder("value", 4, position, false);
                            builder.value(this.parseString("value", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceDefinition parseDeviceDefinition(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceDefinition.Builder builder = DeviceDefinition.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int udiDeviceIdentifierElementIndex = 0;
        int deviceNameElementIndex = 0;
        int specializationElementIndex = 0;
        int versionElementIndex = 0;
        int safetyElementIndex = 0;
        int shelfLifeStorageElementIndex = 0;
        int languageCodeElementIndex = 0;
        int capabilityElementIndex = 0;
        int propertyElementIndex = 0;
        int contactElementIndex = 0;
        int noteElementIndex = 0;
        int materialElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "udiDeviceIdentifier": {
                            position = XMLSupport.checkElementOrder("udiDeviceIdentifier", 9, position, true);
                            builder.udiDeviceIdentifier(this.parseDeviceDefinitionUdiDeviceIdentifier("udiDeviceIdentifier", reader, udiDeviceIdentifierElementIndex++));
                            break block0;
                        }
                        case "manufacturerString": {
                            position = XMLSupport.checkElementOrder("manufacturer[x]", 10, position, false);
                            builder.manufacturer(this.parseString("manufacturerString", reader, -1));
                            break block0;
                        }
                        case "manufacturerReference": {
                            position = XMLSupport.checkElementOrder("manufacturer[x]", 10, position, false);
                            builder.manufacturer(this.parseReference("manufacturerReference", reader, -1));
                            break block0;
                        }
                        case "deviceName": {
                            position = XMLSupport.checkElementOrder("deviceName", 11, position, true);
                            builder.deviceName(this.parseDeviceDefinitionDeviceName("deviceName", reader, deviceNameElementIndex++));
                            break block0;
                        }
                        case "modelNumber": {
                            position = XMLSupport.checkElementOrder("modelNumber", 12, position, false);
                            builder.modelNumber(this.parseString("modelNumber", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 13, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "specialization": {
                            position = XMLSupport.checkElementOrder("specialization", 14, position, true);
                            builder.specialization(this.parseDeviceDefinitionSpecialization("specialization", reader, specializationElementIndex++));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 15, position, true);
                            builder.version(this.parseString("version", reader, versionElementIndex++));
                            break block0;
                        }
                        case "safety": {
                            position = XMLSupport.checkElementOrder("safety", 16, position, true);
                            builder.safety(this.parseCodeableConcept("safety", reader, safetyElementIndex++));
                            break block0;
                        }
                        case "shelfLifeStorage": {
                            position = XMLSupport.checkElementOrder("shelfLifeStorage", 17, position, true);
                            builder.shelfLifeStorage(this.parseProductShelfLife("shelfLifeStorage", reader, shelfLifeStorageElementIndex++));
                            break block0;
                        }
                        case "physicalCharacteristics": {
                            position = XMLSupport.checkElementOrder("physicalCharacteristics", 18, position, false);
                            builder.physicalCharacteristics(this.parseProdCharacteristic("physicalCharacteristics", reader, -1));
                            break block0;
                        }
                        case "languageCode": {
                            position = XMLSupport.checkElementOrder("languageCode", 19, position, true);
                            builder.languageCode(this.parseCodeableConcept("languageCode", reader, languageCodeElementIndex++));
                            break block0;
                        }
                        case "capability": {
                            position = XMLSupport.checkElementOrder("capability", 20, position, true);
                            builder.capability(this.parseDeviceDefinitionCapability("capability", reader, capabilityElementIndex++));
                            break block0;
                        }
                        case "property": {
                            position = XMLSupport.checkElementOrder("property", 21, position, true);
                            builder.property(this.parseDeviceDefinitionProperty("property", reader, propertyElementIndex++));
                            break block0;
                        }
                        case "owner": {
                            position = XMLSupport.checkElementOrder("owner", 22, position, false);
                            builder.owner(this.parseReference("owner", reader, -1));
                            break block0;
                        }
                        case "contact": {
                            position = XMLSupport.checkElementOrder("contact", 23, position, true);
                            builder.contact(this.parseContactPoint("contact", reader, contactElementIndex++));
                            break block0;
                        }
                        case "url": {
                            position = XMLSupport.checkElementOrder("url", 24, position, false);
                            builder.url(this.parseUri("url", reader, -1));
                            break block0;
                        }
                        case "onlineInformation": {
                            position = XMLSupport.checkElementOrder("onlineInformation", 25, position, false);
                            builder.onlineInformation(this.parseUri("onlineInformation", reader, -1));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 26, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                        case "quantity": {
                            position = XMLSupport.checkElementOrder("quantity", 27, position, false);
                            builder.quantity(this.parseQuantity("quantity", reader, -1));
                            break block0;
                        }
                        case "parentDevice": {
                            position = XMLSupport.checkElementOrder("parentDevice", 28, position, false);
                            builder.parentDevice(this.parseReference("parentDevice", reader, -1));
                            break block0;
                        }
                        case "material": {
                            position = XMLSupport.checkElementOrder("material", 29, position, true);
                            builder.material(this.parseDeviceDefinitionMaterial("material", reader, materialElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceDefinition.Capability parseDeviceDefinitionCapability(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceDefinition.Capability.Builder builder = DeviceDefinition.Capability.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int descriptionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "description": {
                            position = XMLSupport.checkElementOrder("description", 3, position, true);
                            builder.description(this.parseCodeableConcept("description", reader, descriptionElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceDefinition.DeviceName parseDeviceDefinitionDeviceName(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceDefinition.DeviceName.Builder builder = DeviceDefinition.DeviceName.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "name": {
                            position = XMLSupport.checkElementOrder("name", 2, position, false);
                            builder.name(this.parseString("name", reader, -1));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 3, position, false);
                            builder.type((DeviceNameType)this.parseString(DeviceNameType.builder(), "type", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceDefinition.Material parseDeviceDefinitionMaterial(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceDefinition.Material.Builder builder = DeviceDefinition.Material.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "substance": {
                            position = XMLSupport.checkElementOrder("substance", 2, position, false);
                            builder.substance(this.parseCodeableConcept("substance", reader, -1));
                            break block0;
                        }
                        case "alternate": {
                            position = XMLSupport.checkElementOrder("alternate", 3, position, false);
                            builder.alternate(this.parseBoolean("alternate", reader, -1));
                            break block0;
                        }
                        case "allergenicIndicator": {
                            position = XMLSupport.checkElementOrder("allergenicIndicator", 4, position, false);
                            builder.allergenicIndicator(this.parseBoolean("allergenicIndicator", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceDefinition.Property parseDeviceDefinitionProperty(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceDefinition.Property.Builder builder = DeviceDefinition.Property.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int valueQuantityElementIndex = 0;
        int valueCodeElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "valueQuantity": {
                            position = XMLSupport.checkElementOrder("valueQuantity", 3, position, true);
                            builder.valueQuantity(this.parseQuantity("valueQuantity", reader, valueQuantityElementIndex++));
                            break block0;
                        }
                        case "valueCode": {
                            position = XMLSupport.checkElementOrder("valueCode", 4, position, true);
                            builder.valueCode(this.parseCodeableConcept("valueCode", reader, valueCodeElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceDefinition.Specialization parseDeviceDefinitionSpecialization(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceDefinition.Specialization.Builder builder = DeviceDefinition.Specialization.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "systemType": {
                            position = XMLSupport.checkElementOrder("systemType", 2, position, false);
                            builder.systemType(this.parseString("systemType", reader, -1));
                            break block0;
                        }
                        case "version": {
                            position = XMLSupport.checkElementOrder("version", 3, position, false);
                            builder.version(this.parseString("version", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceDefinition.UdiDeviceIdentifier parseDeviceDefinitionUdiDeviceIdentifier(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceDefinition.UdiDeviceIdentifier.Builder builder = DeviceDefinition.UdiDeviceIdentifier.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "deviceIdentifier": {
                            position = XMLSupport.checkElementOrder("deviceIdentifier", 2, position, false);
                            builder.deviceIdentifier(this.parseString("deviceIdentifier", reader, -1));
                            break block0;
                        }
                        case "issuer": {
                            position = XMLSupport.checkElementOrder("issuer", 3, position, false);
                            builder.issuer(this.parseUri("issuer", reader, -1));
                            break block0;
                        }
                        case "jurisdiction": {
                            position = XMLSupport.checkElementOrder("jurisdiction", 4, position, false);
                            builder.jurisdiction(this.parseUri("jurisdiction", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceMetric parseDeviceMetric(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceMetric.Builder builder = DeviceMetric.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int calibrationElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 9, position, false);
                            builder.type(this.parseCodeableConcept("type", reader, -1));
                            break block0;
                        }
                        case "unit": {
                            position = XMLSupport.checkElementOrder("unit", 10, position, false);
                            builder.unit(this.parseCodeableConcept("unit", reader, -1));
                            break block0;
                        }
                        case "source": {
                            position = XMLSupport.checkElementOrder("source", 11, position, false);
                            builder.source(this.parseReference("source", reader, -1));
                            break block0;
                        }
                        case "parent": {
                            position = XMLSupport.checkElementOrder("parent", 12, position, false);
                            builder.parent(this.parseReference("parent", reader, -1));
                            break block0;
                        }
                        case "operationalStatus": {
                            position = XMLSupport.checkElementOrder("operationalStatus", 13, position, false);
                            builder.operationalStatus((DeviceMetricOperationalStatus)this.parseString(DeviceMetricOperationalStatus.builder(), "operationalStatus", reader, -1));
                            break block0;
                        }
                        case "color": {
                            position = XMLSupport.checkElementOrder("color", 14, position, false);
                            builder.color((DeviceMetricColor)this.parseString(DeviceMetricColor.builder(), "color", reader, -1));
                            break block0;
                        }
                        case "category": {
                            position = XMLSupport.checkElementOrder("category", 15, position, false);
                            builder.category((DeviceMetricCategory)this.parseString(DeviceMetricCategory.builder(), "category", reader, -1));
                            break block0;
                        }
                        case "measurementPeriod": {
                            position = XMLSupport.checkElementOrder("measurementPeriod", 16, position, false);
                            builder.measurementPeriod(this.parseTiming("measurementPeriod", reader, -1));
                            break block0;
                        }
                        case "calibration": {
                            position = XMLSupport.checkElementOrder("calibration", 17, position, true);
                            builder.calibration(this.parseDeviceMetricCalibration("calibration", reader, calibrationElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceMetric.Calibration parseDeviceMetricCalibration(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceMetric.Calibration.Builder builder = DeviceMetric.Calibration.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "type": {
                            position = XMLSupport.checkElementOrder("type", 2, position, false);
                            builder.type((DeviceMetricCalibrationType)this.parseString(DeviceMetricCalibrationType.builder(), "type", reader, -1));
                            break block0;
                        }
                        case "state": {
                            position = XMLSupport.checkElementOrder("state", 3, position, false);
                            builder.state((DeviceMetricCalibrationState)this.parseString(DeviceMetricCalibrationState.builder(), "state", reader, -1));
                            break block0;
                        }
                        case "time": {
                            position = XMLSupport.checkElementOrder("time", 4, position, false);
                            builder.time(this.parseInstant("time", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceRequest parseDeviceRequest(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceRequest.Builder builder = DeviceRequest.builder();
        builder.setValidating(this.validating);
        int position = -1;
        int containedElementIndex = 0;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        int identifierElementIndex = 0;
        int instantiatesCanonicalElementIndex = 0;
        int instantiatesUriElementIndex = 0;
        int basedOnElementIndex = 0;
        int priorRequestElementIndex = 0;
        int parameterElementIndex = 0;
        int reasonCodeElementIndex = 0;
        int reasonReferenceElementIndex = 0;
        int insuranceElementIndex = 0;
        int supportingInfoElementIndex = 0;
        int noteElementIndex = 0;
        int relevantHistoryElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "id": {
                            position = XMLSupport.checkElementOrder("id", 0, position, false);
                            builder.id(this.parseJavaString("id", reader, -1));
                            break block0;
                        }
                        case "meta": {
                            position = XMLSupport.checkElementOrder("meta", 1, position, false);
                            builder.meta(this.parseMeta("meta", reader, -1));
                            break block0;
                        }
                        case "implicitRules": {
                            position = XMLSupport.checkElementOrder("implicitRules", 2, position, false);
                            builder.implicitRules(this.parseUri("implicitRules", reader, -1));
                            break block0;
                        }
                        case "language": {
                            position = XMLSupport.checkElementOrder("language", 3, position, false);
                            builder.language((Code)this.parseString(Code.builder(), "language", reader, -1));
                            break block0;
                        }
                        case "text": {
                            position = XMLSupport.checkElementOrder("text", 4, position, false);
                            builder.text(this.parseNarrative("text", reader, -1));
                            break block0;
                        }
                        case "contained": {
                            position = XMLSupport.checkElementOrder("contained", 5, position, true);
                            builder.contained(this.parseResource("contained", reader, containedElementIndex++));
                            break block0;
                        }
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 6, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 7, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "identifier": {
                            position = XMLSupport.checkElementOrder("identifier", 8, position, true);
                            builder.identifier(this.parseIdentifier("identifier", reader, identifierElementIndex++));
                            break block0;
                        }
                        case "instantiatesCanonical": {
                            position = XMLSupport.checkElementOrder("instantiatesCanonical", 9, position, true);
                            builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", reader, instantiatesCanonicalElementIndex++));
                            break block0;
                        }
                        case "instantiatesUri": {
                            position = XMLSupport.checkElementOrder("instantiatesUri", 10, position, true);
                            builder.instantiatesUri(this.parseUri("instantiatesUri", reader, instantiatesUriElementIndex++));
                            break block0;
                        }
                        case "basedOn": {
                            position = XMLSupport.checkElementOrder("basedOn", 11, position, true);
                            builder.basedOn(this.parseReference("basedOn", reader, basedOnElementIndex++));
                            break block0;
                        }
                        case "priorRequest": {
                            position = XMLSupport.checkElementOrder("priorRequest", 12, position, true);
                            builder.priorRequest(this.parseReference("priorRequest", reader, priorRequestElementIndex++));
                            break block0;
                        }
                        case "groupIdentifier": {
                            position = XMLSupport.checkElementOrder("groupIdentifier", 13, position, false);
                            builder.groupIdentifier(this.parseIdentifier("groupIdentifier", reader, -1));
                            break block0;
                        }
                        case "status": {
                            position = XMLSupport.checkElementOrder("status", 14, position, false);
                            builder.status((DeviceRequestStatus)this.parseString(DeviceRequestStatus.builder(), "status", reader, -1));
                            break block0;
                        }
                        case "intent": {
                            position = XMLSupport.checkElementOrder("intent", 15, position, false);
                            builder.intent((RequestIntent)this.parseString(RequestIntent.builder(), "intent", reader, -1));
                            break block0;
                        }
                        case "priority": {
                            position = XMLSupport.checkElementOrder("priority", 16, position, false);
                            builder.priority((RequestPriority)this.parseString(RequestPriority.builder(), "priority", reader, -1));
                            break block0;
                        }
                        case "codeReference": {
                            position = XMLSupport.checkElementOrder("code[x]", 17, position, false);
                            builder.code(this.parseReference("codeReference", reader, -1));
                            break block0;
                        }
                        case "codeCodeableConcept": {
                            position = XMLSupport.checkElementOrder("code[x]", 17, position, false);
                            builder.code(this.parseCodeableConcept("codeCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "parameter": {
                            position = XMLSupport.checkElementOrder("parameter", 18, position, true);
                            builder.parameter(this.parseDeviceRequestParameter("parameter", reader, parameterElementIndex++));
                            break block0;
                        }
                        case "subject": {
                            position = XMLSupport.checkElementOrder("subject", 19, position, false);
                            builder.subject(this.parseReference("subject", reader, -1));
                            break block0;
                        }
                        case "encounter": {
                            position = XMLSupport.checkElementOrder("encounter", 20, position, false);
                            builder.encounter(this.parseReference("encounter", reader, -1));
                            break block0;
                        }
                        case "occurrenceDateTime": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 21, position, false);
                            builder.occurrence(this.parseDateTime("occurrenceDateTime", reader, -1));
                            break block0;
                        }
                        case "occurrencePeriod": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 21, position, false);
                            builder.occurrence(this.parsePeriod("occurrencePeriod", reader, -1));
                            break block0;
                        }
                        case "occurrenceTiming": {
                            position = XMLSupport.checkElementOrder("occurrence[x]", 21, position, false);
                            builder.occurrence(this.parseTiming("occurrenceTiming", reader, -1));
                            break block0;
                        }
                        case "authoredOn": {
                            position = XMLSupport.checkElementOrder("authoredOn", 22, position, false);
                            builder.authoredOn(this.parseDateTime("authoredOn", reader, -1));
                            break block0;
                        }
                        case "requester": {
                            position = XMLSupport.checkElementOrder("requester", 23, position, false);
                            builder.requester(this.parseReference("requester", reader, -1));
                            break block0;
                        }
                        case "performerType": {
                            position = XMLSupport.checkElementOrder("performerType", 24, position, false);
                            builder.performerType(this.parseCodeableConcept("performerType", reader, -1));
                            break block0;
                        }
                        case "performer": {
                            position = XMLSupport.checkElementOrder("performer", 25, position, false);
                            builder.performer(this.parseReference("performer", reader, -1));
                            break block0;
                        }
                        case "reasonCode": {
                            position = XMLSupport.checkElementOrder("reasonCode", 26, position, true);
                            builder.reasonCode(this.parseCodeableConcept("reasonCode", reader, reasonCodeElementIndex++));
                            break block0;
                        }
                        case "reasonReference": {
                            position = XMLSupport.checkElementOrder("reasonReference", 27, position, true);
                            builder.reasonReference(this.parseReference("reasonReference", reader, reasonReferenceElementIndex++));
                            break block0;
                        }
                        case "insurance": {
                            position = XMLSupport.checkElementOrder("insurance", 28, position, true);
                            builder.insurance(this.parseReference("insurance", reader, insuranceElementIndex++));
                            break block0;
                        }
                        case "supportingInfo": {
                            position = XMLSupport.checkElementOrder("supportingInfo", 29, position, true);
                            builder.supportingInfo(this.parseReference("supportingInfo", reader, supportingInfoElementIndex++));
                            break block0;
                        }
                        case "note": {
                            position = XMLSupport.checkElementOrder("note", 30, position, true);
                            builder.note(this.parseAnnotation("note", reader, noteElementIndex++));
                            break block0;
                        }
                        case "relevantHistory": {
                            position = XMLSupport.checkElementOrder("relevantHistory", 31, position, true);
                            builder.relevantHistory(this.parseReference("relevantHistory", reader, relevantHistoryElementIndex++));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceRequest.Parameter parseDeviceRequestParameter(String elementName, XMLStreamReader reader, int elementIndex) throws XMLStreamException {
        this.stackPush(elementName, elementIndex);
        DeviceRequest.Parameter.Builder builder = DeviceRequest.Parameter.builder();
        builder.setValidating(this.validating);
        String id = reader.getAttributeValue(null, "id");
        if (id != null) {
            builder.id(id);
        }
        int position = -1;
        int extensionElementIndex = 0;
        int modifierExtensionElementIndex = 0;
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String localName = reader.getLocalName();
                    XMLSupport.requireNamespace(reader, "http://hl7.org/fhir");
                    switch (localName) {
                        case "extension": {
                            position = XMLSupport.checkElementOrder("extension", 0, position, true);
                            builder.extension(this.parseExtension("extension", reader, extensionElementIndex++));
                            break block0;
                        }
                        case "modifierExtension": {
                            position = XMLSupport.checkElementOrder("modifierExtension", 1, position, true);
                            builder.modifierExtension(this.parseExtension("modifierExtension", reader, modifierExtensionElementIndex++));
                            break block0;
                        }
                        case "code": {
                            position = XMLSupport.checkElementOrder("code", 2, position, false);
                            builder.code(this.parseCodeableConcept("code", reader, -1));
                            break block0;
                        }
                        case "valueCodeableConcept": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseCodeableConcept("valueCodeableConcept", reader, -1));
                            break block0;
                        }
                        case "valueQuantity": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseQuantity("valueQuantity", reader, -1));
                            break block0;
                        }
                        case "valueRange": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseRange("valueRange", reader, -1));
                            break block0;
                        }
                        case "valueBoolean": {
                            position = XMLSupport.checkElementOrder("value[x]", 3, position, false);
                            builder.value(this.parseBoolean("valueBoolean", reader, -1));
                            break block0;
                        }
                    }
                    if (!this.ignoringUnrecognizedElements) {
                        throw new IllegalArgumentException("Unrecognized element: '" + localName + "'");
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(elementName)) break;
                    this.stackPop();
                    return builder.build();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    private DeviceUseStatement parseDeviceUseStatement(String elementName, XMLStreamReader reader, int elementIndex) throws XMLS