/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.AdverseEventActuality;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="adverseEvent-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/adverse-event-category", expression="category.exists() implies (category.all(memberOf('http://hl7.org/fhir/ValueSet/adverse-event-category', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/AdverseEvent", generated=true)
public class AdverseEvent
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    @Binding(bindingName="AdverseEventActuality", strength=BindingStrength.Value.REQUIRED, description="Overall nature of the adverse event, e.g. real or potential.", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-actuality|4.0.1")
    @Required
    private final AdverseEventActuality actuality;
    @Summary
    @Binding(bindingName="AdverseEventCategory", strength=BindingStrength.Value.EXTENSIBLE, description="Overall categorization of the event, e.g. product-related or situational.", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="AdverseEventType", strength=BindingStrength.Value.EXAMPLE, description="Detailed type of event.", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-type")
    private final CodeableConcept event;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Practitioner", "RelatedPerson"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    private final DateTime date;
    @Summary
    private final DateTime detected;
    @Summary
    private final DateTime recordedDate;
    @Summary
    @ReferenceTarget(value={"Condition"})
    private final List<Reference> resultingCondition;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    @Summary
    @Binding(bindingName="AdverseEventSeriousness", strength=BindingStrength.Value.EXAMPLE, description="Overall seriousness of this event for the patient.", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-seriousness")
    private final CodeableConcept seriousness;
    @Summary
    @Binding(bindingName="AdverseEventSeverity", strength=BindingStrength.Value.REQUIRED, description="The severity of the adverse event itself, in direct relation to the subject.", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-severity|4.0.1")
    private final CodeableConcept severity;
    @Summary
    @Binding(bindingName="AdverseEventOutcome", strength=BindingStrength.Value.REQUIRED, description="TODO (and should this be required?).", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-outcome|4.0.1")
    private final CodeableConcept outcome;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
    private final Reference recorder;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Device"})
    private final List<Reference> contributor;
    @Summary
    private final List<SuspectEntity> suspectEntity;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "AllergyIntolerance", "FamilyMemberHistory", "Immunization", "Procedure", "Media", "DocumentReference"})
    private final List<Reference> subjectMedicalHistory;
    @Summary
    @ReferenceTarget(value={"DocumentReference"})
    private final List<Reference> referenceDocument;
    @Summary
    @ReferenceTarget(value={"ResearchStudy"})
    private final List<Reference> study;

    private AdverseEvent(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.actuality = builder.actuality;
        this.category = Collections.unmodifiableList(builder.category);
        this.event = builder.event;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.date = builder.date;
        this.detected = builder.detected;
        this.recordedDate = builder.recordedDate;
        this.resultingCondition = Collections.unmodifiableList(builder.resultingCondition);
        this.location = builder.location;
        this.seriousness = builder.seriousness;
        this.severity = builder.severity;
        this.outcome = builder.outcome;
        this.recorder = builder.recorder;
        this.contributor = Collections.unmodifiableList(builder.contributor);
        this.suspectEntity = Collections.unmodifiableList(builder.suspectEntity);
        this.subjectMedicalHistory = Collections.unmodifiableList(builder.subjectMedicalHistory);
        this.referenceDocument = Collections.unmodifiableList(builder.referenceDocument);
        this.study = Collections.unmodifiableList(builder.study);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public AdverseEventActuality getActuality() {
        return this.actuality;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getEvent() {
        return this.event;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getDate() {
        return this.date;
    }

    public DateTime getDetected() {
        return this.detected;
    }

    public DateTime getRecordedDate() {
        return this.recordedDate;
    }

    public List<Reference> getResultingCondition() {
        return this.resultingCondition;
    }

    public Reference getLocation() {
        return this.location;
    }

    public CodeableConcept getSeriousness() {
        return this.seriousness;
    }

    public CodeableConcept getSeverity() {
        return this.severity;
    }

    public CodeableConcept getOutcome() {
        return this.outcome;
    }

    public Reference getRecorder() {
        return this.recorder;
    }

    public List<Reference> getContributor() {
        return this.contributor;
    }

    public List<SuspectEntity> getSuspectEntity() {
        return this.suspectEntity;
    }

    public List<Reference> getSubjectMedicalHistory() {
        return this.subjectMedicalHistory;
    }

    public List<Reference> getReferenceDocument() {
        return this.referenceDocument;
    }

    public List<Reference> getStudy() {
        return this.study;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.actuality != null || !this.category.isEmpty() || this.event != null || this.subject != null || this.encounter != null || this.date != null || this.detected != null || this.recordedDate != null || !this.resultingCondition.isEmpty() || this.location != null || this.seriousness != null || this.severity != null || this.outcome != null || this.recorder != null || !this.contributor.isEmpty() || !this.suspectEntity.isEmpty() || !this.subjectMedicalHistory.isEmpty() || !this.referenceDocument.isEmpty() || !this.study.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.actuality, "actuality", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.event, "event", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.detected, "detected", visitor);
                this.accept(this.recordedDate, "recordedDate", visitor);
                this.accept(this.resultingCondition, "resultingCondition", visitor, Reference.class);
                this.accept(this.location, "location", visitor);
                this.accept(this.seriousness, "seriousness", visitor);
                this.accept(this.severity, "severity", visitor);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.recorder, "recorder", visitor);
                this.accept(this.contributor, "contributor", visitor, Reference.class);
                this.accept(this.suspectEntity, "suspectEntity", visitor, SuspectEntity.class);
                this.accept(this.subjectMedicalHistory, "subjectMedicalHistory", visitor, Reference.class);
                this.accept(this.referenceDocument, "referenceDocument", visitor, Reference.class);
                this.accept(this.study, "study", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdverseEvent other = (AdverseEvent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.actuality, other.actuality) && Objects.equals(this.category, other.category) && Objects.equals(this.event, other.event) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.date, other.date) && Objects.equals(this.detected, other.detected) && Objects.equals(this.recordedDate, other.recordedDate) && Objects.equals(this.resultingCondition, other.resultingCondition) && Objects.equals(this.location, other.location) && Objects.equals(this.seriousness, other.seriousness) && Objects.equals(this.severity, other.severity) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.recorder, other.recorder) && Objects.equals(this.contributor, other.contributor) && Objects.equals(this.suspectEntity, other.suspectEntity) && Objects.equals(this.subjectMedicalHistory, other.subjectMedicalHistory) && Objects.equals(this.referenceDocument, other.referenceDocument) && Objects.equals(this.study, other.study);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.actuality, this.category, this.event, this.subject, this.encounter, this.date, this.detected, this.recordedDate, this.resultingCondition, this.location, this.seriousness, this.severity, this.outcome, this.recorder, this.contributor, this.suspectEntity, this.subjectMedicalHistory, this.referenceDocument, this.study);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SuspectEntity
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Immunization", "Procedure", "Substance", "Medication", "MedicationAdministration", "MedicationStatement", "Device"})
        @Required
        private final Reference instance;
        @Summary
        private final List<Causality> causality;

        private SuspectEntity(Builder builder) {
            super(builder);
            this.instance = builder.instance;
            this.causality = Collections.unmodifiableList(builder.causality);
        }

        public Reference getInstance() {
            return this.instance;
        }

        public List<Causality> getCausality() {
            return this.causality;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.instance != null || !this.causality.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.instance, "instance", visitor);
                    this.accept(this.causality, "causality", visitor, Causality.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuspectEntity other = (SuspectEntity)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.instance, other.instance) && Objects.equals(this.causality, other.causality);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.instance, this.causality);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Causality
        extends BackboneElement {
            @Summary
            @Binding(bindingName="AdverseEventCausalityAssessment", strength=BindingStrength.Value.EXAMPLE, description="Codes for the assessment of whether the entity caused the event.", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-assess")
            private final CodeableConcept assessment;
            @Summary
            private final String productRelatedness;
            @Summary
            @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
            private final Reference author;
            @Summary
            @Binding(bindingName="AdverseEventCausalityMethod", strength=BindingStrength.Value.EXAMPLE, description="TODO.", valueSet="http://hl7.org/fhir/ValueSet/adverse-event-causality-method")
            private final CodeableConcept method;

            private Causality(Builder builder) {
                super(builder);
                this.assessment = builder.assessment;
                this.productRelatedness = builder.productRelatedness;
                this.author = builder.author;
                this.method = builder.method;
            }

            public CodeableConcept getAssessment() {
                return this.assessment;
            }

            public String getProductRelatedness() {
                return this.productRelatedness;
            }

            public Reference getAuthor() {
                return this.author;
            }

            public CodeableConcept getMethod() {
                return this.method;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.assessment != null || this.productRelatedness != null || this.author != null || this.method != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.assessment, "assessment", visitor);
                        this.accept(this.productRelatedness, "productRelatedness", visitor);
                        this.accept(this.author, "author", visitor);
                        this.accept(this.method, "method", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Causality other = (Causality)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.assessment, other.assessment) && Objects.equals(this.productRelatedness, other.productRelatedness) && Objects.equals(this.author, other.author) && Objects.equals(this.method, other.method);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.assessment, this.productRelatedness, this.author, this.method);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept assessment;
                private String productRelatedness;
                private Reference author;
                private CodeableConcept method;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder assessment(CodeableConcept assessment) {
                    this.assessment = assessment;
                    return this;
                }

                public Builder productRelatedness(java.lang.String productRelatedness) {
                    this.productRelatedness = productRelatedness == null ? null : String.of(productRelatedness);
                    return this;
                }

                public Builder productRelatedness(String productRelatedness) {
                    this.productRelatedness = productRelatedness;
                    return this;
                }

                public Builder author(Reference author) {
                    this.author = author;
                    return this;
                }

                public Builder method(CodeableConcept method) {
                    this.method = method;
                    return this;
                }

                @Override
                public Causality build() {
                    Causality causality = new Causality(this);
                    if (this.validating) {
                        this.validate(causality);
                    }
                    return causality;
                }

                protected void validate(Causality causality) {
                    super.validate(causality);
                    ValidationSupport.checkReferenceType(causality.author, "author", "Practitioner", "PractitionerRole");
                    ValidationSupport.requireValueOrChildren(causality);
                }

                protected Builder from(Causality causality) {
                    super.from(causality);
                    this.assessment = causality.assessment;
                    this.productRelatedness = causality.productRelatedness;
                    this.author = causality.author;
                    this.method = causality.method;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference instance;
            private List<Causality> causality = new ArrayList<Causality>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder instance(Reference instance) {
                this.instance = instance;
                return this;
            }

            public Builder causality(Causality ... causality) {
                for (Causality value : causality) {
                    this.causality.add(value);
                }
                return this;
            }

            public Builder causality(Collection<Causality> causality) {
                this.causality = new ArrayList<Causality>(causality);
                return this;
            }

            @Override
            public SuspectEntity build() {
                SuspectEntity suspectEntity = new SuspectEntity(this);
                if (this.validating) {
                    this.validate(suspectEntity);
                }
                return suspectEntity;
            }

            protected void validate(SuspectEntity suspectEntity) {
                super.validate(suspectEntity);
                ValidationSupport.requireNonNull(suspectEntity.instance, "instance");
                ValidationSupport.checkList(suspectEntity.causality, "causality", Causality.class);
                ValidationSupport.checkReferenceType(suspectEntity.instance, "instance", "Immunization", "Procedure", "Substance", "Medication", "MedicationAdministration", "MedicationStatement", "Device");
                ValidationSupport.requireValueOrChildren(suspectEntity);
            }

            protected Builder from(SuspectEntity suspectEntity) {
                super.from(suspectEntity);
                this.instance = suspectEntity.instance;
                this.causality.addAll(suspectEntity.causality);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private AdverseEventActuality actuality;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept event;
        private Reference subject;
        private Reference encounter;
        private DateTime date;
        private DateTime detected;
        private DateTime recordedDate;
        private List<Reference> resultingCondition = new ArrayList<Reference>();
        private Reference location;
        private CodeableConcept seriousness;
        private CodeableConcept severity;
        private CodeableConcept outcome;
        private Reference recorder;
        private List<Reference> contributor = new ArrayList<Reference>();
        private List<SuspectEntity> suspectEntity = new ArrayList<SuspectEntity>();
        private List<Reference> subjectMedicalHistory = new ArrayList<Reference>();
        private List<Reference> referenceDocument = new ArrayList<Reference>();
        private List<Reference> study = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder actuality(AdverseEventActuality actuality) {
            this.actuality = actuality;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder event(CodeableConcept event) {
            this.event = event;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder detected(DateTime detected) {
            this.detected = detected;
            return this;
        }

        public Builder recordedDate(DateTime recordedDate) {
            this.recordedDate = recordedDate;
            return this;
        }

        public Builder resultingCondition(Reference ... resultingCondition) {
            for (Reference value : resultingCondition) {
                this.resultingCondition.add(value);
            }
            return this;
        }

        public Builder resultingCondition(Collection<Reference> resultingCondition) {
            this.resultingCondition = new ArrayList<Reference>(resultingCondition);
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder seriousness(CodeableConcept seriousness) {
            this.seriousness = seriousness;
            return this;
        }

        public Builder severity(CodeableConcept severity) {
            this.severity = severity;
            return this;
        }

        public Builder outcome(CodeableConcept outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder recorder(Reference recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder contributor(Reference ... contributor) {
            for (Reference value : contributor) {
                this.contributor.add(value);
            }
            return this;
        }

        public Builder contributor(Collection<Reference> contributor) {
            this.contributor = new ArrayList<Reference>(contributor);
            return this;
        }

        public Builder suspectEntity(SuspectEntity ... suspectEntity) {
            for (SuspectEntity value : suspectEntity) {
                this.suspectEntity.add(value);
            }
            return this;
        }

        public Builder suspectEntity(Collection<SuspectEntity> suspectEntity) {
            this.suspectEntity = new ArrayList<SuspectEntity>(suspectEntity);
            return this;
        }

        public Builder subjectMedicalHistory(Reference ... subjectMedicalHistory) {
            for (Reference value : subjectMedicalHistory) {
                this.subjectMedicalHistory.add(value);
            }
            return this;
        }

        public Builder subjectMedicalHistory(Collection<Reference> subjectMedicalHistory) {
            this.subjectMedicalHistory = new ArrayList<Reference>(subjectMedicalHistory);
            return this;
        }

        public Builder referenceDocument(Reference ... referenceDocument) {
            for (Reference value : referenceDocument) {
                this.referenceDocument.add(value);
            }
            return this;
        }

        public Builder referenceDocument(Collection<Reference> referenceDocument) {
            this.referenceDocument = new ArrayList<Reference>(referenceDocument);
            return this;
        }

        public Builder study(Reference ... study) {
            for (Reference value : study) {
                this.study.add(value);
            }
            return this;
        }

        public Builder study(Collection<Reference> study) {
            this.study = new ArrayList<Reference>(study);
            return this;
        }

        @Override
        public AdverseEvent build() {
            AdverseEvent adverseEvent = new AdverseEvent(this);
            if (this.validating) {
                this.validate(adverseEvent);
            }
            return adverseEvent;
        }

        protected void validate(AdverseEvent adverseEvent) {
            super.validate(adverseEvent);
            ValidationSupport.requireNonNull(adverseEvent.actuality, "actuality");
            ValidationSupport.checkList(adverseEvent.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(adverseEvent.subject, "subject");
            ValidationSupport.checkList(adverseEvent.resultingCondition, "resultingCondition", Reference.class);
            ValidationSupport.checkList(adverseEvent.contributor, "contributor", Reference.class);
            ValidationSupport.checkList(adverseEvent.suspectEntity, "suspectEntity", SuspectEntity.class);
            ValidationSupport.checkList(adverseEvent.subjectMedicalHistory, "subjectMedicalHistory", Reference.class);
            ValidationSupport.checkList(adverseEvent.referenceDocument, "referenceDocument", Reference.class);
            ValidationSupport.checkList(adverseEvent.study, "study", Reference.class);
            ValidationSupport.checkValueSetBinding(adverseEvent.severity, "severity", "http://hl7.org/fhir/ValueSet/adverse-event-severity", "http://terminology.hl7.org/CodeSystem/adverse-event-severity", "mild", "moderate", "severe");
            ValidationSupport.checkValueSetBinding(adverseEvent.outcome, "outcome", "http://hl7.org/fhir/ValueSet/adverse-event-outcome", "http://terminology.hl7.org/CodeSystem/adverse-event-outcome", "resolved", "recovering", "ongoing", "resolvedWithSequelae", "fatal", "unknown");
            ValidationSupport.checkReferenceType(adverseEvent.subject, "subject", "Patient", "Group", "Practitioner", "RelatedPerson");
            ValidationSupport.checkReferenceType(adverseEvent.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(adverseEvent.resultingCondition, "resultingCondition", "Condition");
            ValidationSupport.checkReferenceType(adverseEvent.location, "location", "Location");
            ValidationSupport.checkReferenceType(adverseEvent.recorder, "recorder", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
            ValidationSupport.checkReferenceType(adverseEvent.contributor, "contributor", "Practitioner", "PractitionerRole", "Device");
            ValidationSupport.checkReferenceType(adverseEvent.subjectMedicalHistory, "subjectMedicalHistory", "Condition", "Observation", "AllergyIntolerance", "FamilyMemberHistory", "Immunization", "Procedure", "Media", "DocumentReference");
            ValidationSupport.checkReferenceType(adverseEvent.referenceDocument, "referenceDocument", "DocumentReference");
            ValidationSupport.checkReferenceType(adverseEvent.study, "study", "ResearchStudy");
        }

        protected Builder from(AdverseEvent adverseEvent) {
            super.from(adverseEvent);
            this.identifier = adverseEvent.identifier;
            this.actuality = adverseEvent.actuality;
            this.category.addAll(adverseEvent.category);
            this.event = adverseEvent.event;
            this.subject = adverseEvent.subject;
            this.encounter = adverseEvent.encounter;
            this.date = adverseEvent.date;
            this.detected = adverseEvent.detected;
            this.recordedDate = adverseEvent.recordedDate;
            this.resultingCondition.addAll(adverseEvent.resultingCondition);
            this.location = adverseEvent.location;
            this.seriousness = adverseEvent.seriousness;
            this.severity = adverseEvent.severity;
            this.outcome = adverseEvent.outcome;
            this.recorder = adverseEvent.recorder;
            this.contributor.addAll(adverseEvent.contributor);
            this.suspectEntity.addAll(adverseEvent.suspectEntity);
            this.subjectMedicalHistory.addAll(adverseEvent.subjectMedicalHistory);
            this.referenceDocument.addAll(adverseEvent.referenceDocument);
            this.study.addAll(adverseEvent.study);
            return this;
        }
    }
}

