/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CapabilityStatementKind;
import com.ibm.fhir.model.type.code.ConditionalDeleteStatus;
import com.ibm.fhir.model.type.code.ConditionalReadStatus;
import com.ibm.fhir.model.type.code.DocumentMode;
import com.ibm.fhir.model.type.code.EventCapabilityMode;
import com.ibm.fhir.model.type.code.FHIRVersion;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.ReferenceHandlingPolicy;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.ResourceVersionPolicy;
import com.ibm.fhir.model.type.code.RestfulCapabilityMode;
import com.ibm.fhir.model.type.code.SearchParamType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.SystemRestfulInteraction;
import com.ibm.fhir.model.type.code.TypeRestfulInteraction;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="cpb-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-1", level="Rule", location="(base)", description="A Capability Statement SHALL have at least one of REST, messaging or document element.", expression="rest.exists() or messaging.exists() or document.exists()", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-2", level="Rule", location="(base)", description="A Capability Statement SHALL have at least one of description, software, or implementation element.", expression="(description.count() + software.count() + implementation.count()) > 0", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-3", level="Rule", location="(base)", description="Messaging end-point is required (and is only permitted) when a statement is for an implementation.", expression="messaging.endpoint.empty() or kind = 'instance'", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-7", level="Rule", location="(base)", description="The set of documents must be unique by the combination of profile and mode.", expression="document.select(profile&mode).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-9", level="Rule", location="CapabilityStatement.rest", description="A given resource can only be described once per RESTful mode.", expression="resource.select(type).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-12", level="Rule", location="CapabilityStatement.rest.resource", description="Search parameter names must be unique in the context of a resource.", expression="searchParam.select(name).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-14", level="Rule", location="(base)", description="If kind = instance, implementation must be present and software may be present", expression="(kind != 'instance') or implementation.exists()", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-15", level="Rule", location="(base)", description="If kind = capability, implementation must be absent, software must be present", expression="(kind != 'capability') or (implementation.exists().not() and software.exists())", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="cpb-16", level="Rule", location="(base)", description="If kind = requirements, implementation and software must be absent", expression="(kind!='requirements') or (implementation.exists().not() and software.exists().not())", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement"), @Constraint(id="capabilityStatement-17", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement", generated=true), @Constraint(id="capabilityStatement-18", level="Warning", location="rest.security.service", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/restful-security-service", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/restful-security-service', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement", generated=true), @Constraint(id="capabilityStatement-19", level="Warning", location="messaging.endpoint.protocol", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/message-transport", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/message-transport', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/CapabilityStatement", generated=true)})
public class CapabilityStatement
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    @Required
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    @Summary
    @Binding(bindingName="CapabilityStatementKind", strength=BindingStrength.Value.REQUIRED, description="How a capability statement is intended to be used.", valueSet="http://hl7.org/fhir/ValueSet/capability-statement-kind|4.0.1")
    @Required
    private final CapabilityStatementKind kind;
    @Summary
    private final List<Canonical> instantiates;
    @Summary
    private final List<Canonical> imports;
    @Summary
    private final Software software;
    @Summary
    private final Implementation implementation;
    @Summary
    @Binding(bindingName="FHIRVersion", strength=BindingStrength.Value.REQUIRED, description="All published FHIR Versions.", valueSet="http://hl7.org/fhir/ValueSet/FHIR-version|4.0.1")
    @Required
    private final FHIRVersion fhirVersion;
    @Summary
    @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
    @Required
    private final List<Code> format;
    @Summary
    @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
    private final List<Code> patchFormat;
    @Summary
    private final List<Canonical> implementationGuide;
    @Summary
    private final List<Rest> rest;
    @Summary
    private final List<Messaging> messaging;
    @Summary
    private final List<Document> document;

    private CapabilityStatement(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.kind = builder.kind;
        this.instantiates = Collections.unmodifiableList(builder.instantiates);
        this.imports = Collections.unmodifiableList(builder.imports);
        this.software = builder.software;
        this.implementation = builder.implementation;
        this.fhirVersion = builder.fhirVersion;
        this.format = Collections.unmodifiableList(builder.format);
        this.patchFormat = Collections.unmodifiableList(builder.patchFormat);
        this.implementationGuide = Collections.unmodifiableList(builder.implementationGuide);
        this.rest = Collections.unmodifiableList(builder.rest);
        this.messaging = Collections.unmodifiableList(builder.messaging);
        this.document = Collections.unmodifiableList(builder.document);
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public CapabilityStatementKind getKind() {
        return this.kind;
    }

    public List<Canonical> getInstantiates() {
        return this.instantiates;
    }

    public List<Canonical> getImports() {
        return this.imports;
    }

    public Software getSoftware() {
        return this.software;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public FHIRVersion getFhirVersion() {
        return this.fhirVersion;
    }

    public List<Code> getFormat() {
        return this.format;
    }

    public List<Code> getPatchFormat() {
        return this.patchFormat;
    }

    public List<Canonical> getImplementationGuide() {
        return this.implementationGuide;
    }

    public List<Rest> getRest() {
        return this.rest;
    }

    public List<Messaging> getMessaging() {
        return this.messaging;
    }

    public List<Document> getDocument() {
        return this.document;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.kind != null || !this.instantiates.isEmpty() || !this.imports.isEmpty() || this.software != null || this.implementation != null || this.fhirVersion != null || !this.format.isEmpty() || !this.patchFormat.isEmpty() || !this.implementationGuide.isEmpty() || !this.rest.isEmpty() || !this.messaging.isEmpty() || !this.document.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.kind, "kind", visitor);
                this.accept(this.instantiates, "instantiates", visitor, Canonical.class);
                this.accept(this.imports, "imports", visitor, Canonical.class);
                this.accept(this.software, "software", visitor);
                this.accept(this.implementation, "implementation", visitor);
                this.accept(this.fhirVersion, "fhirVersion", visitor);
                this.accept(this.format, "format", visitor, Code.class);
                this.accept(this.patchFormat, "patchFormat", visitor, Code.class);
                this.accept(this.implementationGuide, "implementationGuide", visitor, Canonical.class);
                this.accept(this.rest, "rest", visitor, Rest.class);
                this.accept(this.messaging, "messaging", visitor, Messaging.class);
                this.accept(this.document, "document", visitor, Document.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapabilityStatement other = (CapabilityStatement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.kind, other.kind) && Objects.equals(this.instantiates, other.instantiates) && Objects.equals(this.imports, other.imports) && Objects.equals(this.software, other.software) && Objects.equals(this.implementation, other.implementation) && Objects.equals(this.fhirVersion, other.fhirVersion) && Objects.equals(this.format, other.format) && Objects.equals(this.patchFormat, other.patchFormat) && Objects.equals(this.implementationGuide, other.implementationGuide) && Objects.equals(this.rest, other.rest) && Objects.equals(this.messaging, other.messaging) && Objects.equals(this.document, other.document);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.kind, this.instantiates, this.imports, this.software, this.implementation, this.fhirVersion, this.format, this.patchFormat, this.implementationGuide, this.rest, this.messaging, this.document);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Document
    extends BackboneElement {
        @Summary
        @Binding(bindingName="DocumentMode", strength=BindingStrength.Value.REQUIRED, description="Whether the application produces or consumes documents.", valueSet="http://hl7.org/fhir/ValueSet/document-mode|4.0.1")
        @Required
        private final DocumentMode mode;
        private final Markdown documentation;
        @Summary
        @Required
        private final Canonical profile;

        private Document(Builder builder) {
            super(builder);
            this.mode = builder.mode;
            this.documentation = builder.documentation;
            this.profile = builder.profile;
        }

        public DocumentMode getMode() {
            return this.mode;
        }

        public Markdown getDocumentation() {
            return this.documentation;
        }

        public Canonical getProfile() {
            return this.profile;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.mode != null || this.documentation != null || this.profile != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.mode, "mode", visitor);
                    this.accept(this.documentation, "documentation", visitor);
                    this.accept(this.profile, "profile", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Document other = (Document)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.mode, other.mode) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.profile, other.profile);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.mode, this.documentation, this.profile);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private DocumentMode mode;
            private Markdown documentation;
            private Canonical profile;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder mode(DocumentMode mode) {
                this.mode = mode;
                return this;
            }

            public Builder documentation(Markdown documentation) {
                this.documentation = documentation;
                return this;
            }

            public Builder profile(Canonical profile) {
                this.profile = profile;
                return this;
            }

            @Override
            public Document build() {
                Document document = new Document(this);
                if (this.validating) {
                    this.validate(document);
                }
                return document;
            }

            protected void validate(Document document) {
                super.validate(document);
                ValidationSupport.requireNonNull(document.mode, "mode");
                ValidationSupport.requireNonNull(document.profile, "profile");
                ValidationSupport.requireValueOrChildren(document);
            }

            protected Builder from(Document document) {
                super.from(document);
                this.mode = document.mode;
                this.documentation = document.documentation;
                this.profile = document.profile;
                return this;
            }
        }
    }

    public static class Messaging
    extends BackboneElement {
        private final List<Endpoint> endpoint;
        private final UnsignedInt reliableCache;
        private final Markdown documentation;
        @Summary
        private final List<SupportedMessage> supportedMessage;

        private Messaging(Builder builder) {
            super(builder);
            this.endpoint = Collections.unmodifiableList(builder.endpoint);
            this.reliableCache = builder.reliableCache;
            this.documentation = builder.documentation;
            this.supportedMessage = Collections.unmodifiableList(builder.supportedMessage);
        }

        public List<Endpoint> getEndpoint() {
            return this.endpoint;
        }

        public UnsignedInt getReliableCache() {
            return this.reliableCache;
        }

        public Markdown getDocumentation() {
            return this.documentation;
        }

        public List<SupportedMessage> getSupportedMessage() {
            return this.supportedMessage;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.endpoint.isEmpty() || this.reliableCache != null || this.documentation != null || !this.supportedMessage.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.endpoint, "endpoint", visitor, Endpoint.class);
                    this.accept(this.reliableCache, "reliableCache", visitor);
                    this.accept(this.documentation, "documentation", visitor);
                    this.accept(this.supportedMessage, "supportedMessage", visitor, SupportedMessage.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Messaging other = (Messaging)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.reliableCache, other.reliableCache) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.supportedMessage, other.supportedMessage);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.endpoint, this.reliableCache, this.documentation, this.supportedMessage);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class SupportedMessage
        extends BackboneElement {
            @Summary
            @Binding(bindingName="EventCapabilityMode", strength=BindingStrength.Value.REQUIRED, description="The mode of a message capability statement.", valueSet="http://hl7.org/fhir/ValueSet/event-capability-mode|4.0.1")
            @Required
            private final EventCapabilityMode mode;
            @Summary
            @Required
            private final Canonical definition;

            private SupportedMessage(Builder builder) {
                super(builder);
                this.mode = builder.mode;
                this.definition = builder.definition;
            }

            public EventCapabilityMode getMode() {
                return this.mode;
            }

            public Canonical getDefinition() {
                return this.definition;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.mode != null || this.definition != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.mode, "mode", visitor);
                        this.accept(this.definition, "definition", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SupportedMessage other = (SupportedMessage)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.mode, other.mode) && Objects.equals(this.definition, other.definition);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.mode, this.definition);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private EventCapabilityMode mode;
                private Canonical definition;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder mode(EventCapabilityMode mode) {
                    this.mode = mode;
                    return this;
                }

                public Builder definition(Canonical definition) {
                    this.definition = definition;
                    return this;
                }

                @Override
                public SupportedMessage build() {
                    SupportedMessage supportedMessage = new SupportedMessage(this);
                    if (this.validating) {
                        this.validate(supportedMessage);
                    }
                    return supportedMessage;
                }

                protected void validate(SupportedMessage supportedMessage) {
                    super.validate(supportedMessage);
                    ValidationSupport.requireNonNull(supportedMessage.mode, "mode");
                    ValidationSupport.requireNonNull(supportedMessage.definition, "definition");
                    ValidationSupport.requireValueOrChildren(supportedMessage);
                }

                protected Builder from(SupportedMessage supportedMessage) {
                    super.from(supportedMessage);
                    this.mode = supportedMessage.mode;
                    this.definition = supportedMessage.definition;
                    return this;
                }
            }
        }

        public static class Endpoint
        extends BackboneElement {
            @Binding(bindingName="MessageTransport", strength=BindingStrength.Value.EXTENSIBLE, description="The protocol used for message transport.", valueSet="http://hl7.org/fhir/ValueSet/message-transport")
            @Required
            private final Coding protocol;
            @Required
            private final Url address;

            private Endpoint(Builder builder) {
                super(builder);
                this.protocol = builder.protocol;
                this.address = builder.address;
            }

            public Coding getProtocol() {
                return this.protocol;
            }

            public Url getAddress() {
                return this.address;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.protocol != null || this.address != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.protocol, "protocol", visitor);
                        this.accept(this.address, "address", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Endpoint other = (Endpoint)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.address, other.address);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.protocol, this.address);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Coding protocol;
                private Url address;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder protocol(Coding protocol) {
                    this.protocol = protocol;
                    return this;
                }

                public Builder address(Url address) {
                    this.address = address;
                    return this;
                }

                @Override
                public Endpoint build() {
                    Endpoint endpoint = new Endpoint(this);
                    if (this.validating) {
                        this.validate(endpoint);
                    }
                    return endpoint;
                }

                protected void validate(Endpoint endpoint) {
                    super.validate(endpoint);
                    ValidationSupport.requireNonNull(endpoint.protocol, "protocol");
                    ValidationSupport.requireNonNull(endpoint.address, "address");
                    ValidationSupport.requireValueOrChildren(endpoint);
                }

                protected Builder from(Endpoint endpoint) {
                    super.from(endpoint);
                    this.protocol = endpoint.protocol;
                    this.address = endpoint.address;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Endpoint> endpoint = new ArrayList<Endpoint>();
            private UnsignedInt reliableCache;
            private Markdown documentation;
            private List<SupportedMessage> supportedMessage = new ArrayList<SupportedMessage>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder endpoint(Endpoint ... endpoint) {
                for (Endpoint value : endpoint) {
                    this.endpoint.add(value);
                }
                return this;
            }

            public Builder endpoint(Collection<Endpoint> endpoint) {
                this.endpoint = new ArrayList<Endpoint>(endpoint);
                return this;
            }

            public Builder reliableCache(UnsignedInt reliableCache) {
                this.reliableCache = reliableCache;
                return this;
            }

            public Builder documentation(Markdown documentation) {
                this.documentation = documentation;
                return this;
            }

            public Builder supportedMessage(SupportedMessage ... supportedMessage) {
                for (SupportedMessage value : supportedMessage) {
                    this.supportedMessage.add(value);
                }
                return this;
            }

            public Builder supportedMessage(Collection<SupportedMessage> supportedMessage) {
                this.supportedMessage = new ArrayList<SupportedMessage>(supportedMessage);
                return this;
            }

            @Override
            public Messaging build() {
                Messaging messaging = new Messaging(this);
                if (this.validating) {
                    this.validate(messaging);
                }
                return messaging;
            }

            protected void validate(Messaging messaging) {
                super.validate(messaging);
                ValidationSupport.checkList(messaging.endpoint, "endpoint", Endpoint.class);
                ValidationSupport.checkList(messaging.supportedMessage, "supportedMessage", SupportedMessage.class);
                ValidationSupport.requireValueOrChildren(messaging);
            }

            protected Builder from(Messaging messaging) {
                super.from(messaging);
                this.endpoint.addAll(messaging.endpoint);
                this.reliableCache = messaging.reliableCache;
                this.documentation = messaging.documentation;
                this.supportedMessage.addAll(messaging.supportedMessage);
                return this;
            }
        }
    }

    public static class Rest
    extends BackboneElement {
        @Summary
        @Binding(bindingName="RestfulCapabilityMode", strength=BindingStrength.Value.REQUIRED, description="The mode of a RESTful capability statement.", valueSet="http://hl7.org/fhir/ValueSet/restful-capability-mode|4.0.1")
        @Required
        private final RestfulCapabilityMode mode;
        private final Markdown documentation;
        @Summary
        private final Security security;
        @Summary
        private final List<Resource> resource;
        private final List<Interaction> interaction;
        private final List<Resource.SearchParam> searchParam;
        @Summary
        private final List<Resource.Operation> operation;
        private final List<Canonical> compartment;

        private Rest(Builder builder) {
            super(builder);
            this.mode = builder.mode;
            this.documentation = builder.documentation;
            this.security = builder.security;
            this.resource = Collections.unmodifiableList(builder.resource);
            this.interaction = Collections.unmodifiableList(builder.interaction);
            this.searchParam = Collections.unmodifiableList(builder.searchParam);
            this.operation = Collections.unmodifiableList(builder.operation);
            this.compartment = Collections.unmodifiableList(builder.compartment);
        }

        public RestfulCapabilityMode getMode() {
            return this.mode;
        }

        public Markdown getDocumentation() {
            return this.documentation;
        }

        public Security getSecurity() {
            return this.security;
        }

        public List<Resource> getResource() {
            return this.resource;
        }

        public List<Interaction> getInteraction() {
            return this.interaction;
        }

        public List<Resource.SearchParam> getSearchParam() {
            return this.searchParam;
        }

        public List<Resource.Operation> getOperation() {
            return this.operation;
        }

        public List<Canonical> getCompartment() {
            return this.compartment;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.mode != null || this.documentation != null || this.security != null || !this.resource.isEmpty() || !this.interaction.isEmpty() || !this.searchParam.isEmpty() || !this.operation.isEmpty() || !this.compartment.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.mode, "mode", visitor);
                    this.accept(this.documentation, "documentation", visitor);
                    this.accept(this.security, "security", visitor);
                    this.accept(this.resource, "resource", visitor, Resource.class);
                    this.accept(this.interaction, "interaction", visitor, Interaction.class);
                    this.accept(this.searchParam, "searchParam", visitor, Resource.SearchParam.class);
                    this.accept(this.operation, "operation", visitor, Resource.Operation.class);
                    this.accept(this.compartment, "compartment", visitor, Canonical.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Rest other = (Rest)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.mode, other.mode) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.security, other.security) && Objects.equals(this.resource, other.resource) && Objects.equals(this.interaction, other.interaction) && Objects.equals(this.searchParam, other.searchParam) && Objects.equals(this.operation, other.operation) && Objects.equals(this.compartment, other.compartment);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.mode, this.documentation, this.security, this.resource, this.interaction, this.searchParam, this.operation, this.compartment);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Interaction
        extends BackboneElement {
            @Binding(bindingName="SystemRestfulInteraction", strength=BindingStrength.Value.REQUIRED, description="Operations supported by REST at the system level.", valueSet="http://hl7.org/fhir/ValueSet/system-restful-interaction|4.0.1")
            @Required
            private final SystemRestfulInteraction code;
            private final Markdown documentation;

            private Interaction(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.documentation = builder.documentation;
            }

            public SystemRestfulInteraction getCode() {
                return this.code;
            }

            public Markdown getDocumentation() {
                return this.documentation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.documentation != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.documentation, "documentation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Interaction other = (Interaction)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.documentation, other.documentation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.documentation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private SystemRestfulInteraction code;
                private Markdown documentation;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(SystemRestfulInteraction code) {
                    this.code = code;
                    return this;
                }

                public Builder documentation(Markdown documentation) {
                    this.documentation = documentation;
                    return this;
                }

                @Override
                public Interaction build() {
                    Interaction interaction = new Interaction(this);
                    if (this.validating) {
                        this.validate(interaction);
                    }
                    return interaction;
                }

                protected void validate(Interaction interaction) {
                    super.validate(interaction);
                    ValidationSupport.requireNonNull(interaction.code, "code");
                    ValidationSupport.requireValueOrChildren(interaction);
                }

                protected Builder from(Interaction interaction) {
                    super.from(interaction);
                    this.code = interaction.code;
                    this.documentation = interaction.documentation;
                    return this;
                }
            }
        }

        public static class Resource
        extends BackboneElement {
            @Summary
            @Binding(bindingName="ResourceType", strength=BindingStrength.Value.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
            @Required
            private final ResourceType type;
            @Summary
            private final Canonical profile;
            @Summary
            private final List<Canonical> supportedProfile;
            private final Markdown documentation;
            private final List<Interaction> interaction;
            @Binding(bindingName="ResourceVersionPolicy", strength=BindingStrength.Value.REQUIRED, description="How the system supports versioning for a resource.", valueSet="http://hl7.org/fhir/ValueSet/versioning-policy|4.0.1")
            private final ResourceVersionPolicy versioning;
            private final Boolean readHistory;
            private final Boolean updateCreate;
            private final Boolean conditionalCreate;
            @Binding(bindingName="ConditionalReadStatus", strength=BindingStrength.Value.REQUIRED, description="A code that indicates how the server supports conditional read.", valueSet="http://hl7.org/fhir/ValueSet/conditional-read-status|4.0.1")
            private final ConditionalReadStatus conditionalRead;
            private final Boolean conditionalUpdate;
            @Binding(bindingName="ConditionalDeleteStatus", strength=BindingStrength.Value.REQUIRED, description="A code that indicates how the server supports conditional delete.", valueSet="http://hl7.org/fhir/ValueSet/conditional-delete-status|4.0.1")
            private final ConditionalDeleteStatus conditionalDelete;
            @Binding(bindingName="ReferenceHandlingPolicy", strength=BindingStrength.Value.REQUIRED, description="A set of flags that defines how references are supported.", valueSet="http://hl7.org/fhir/ValueSet/reference-handling-policy|4.0.1")
            private final List<ReferenceHandlingPolicy> referencePolicy;
            private final List<String> searchInclude;
            private final List<String> searchRevInclude;
            private final List<SearchParam> searchParam;
            @Summary
            private final List<Operation> operation;

            private Resource(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.profile = builder.profile;
                this.supportedProfile = Collections.unmodifiableList(builder.supportedProfile);
                this.documentation = builder.documentation;
                this.interaction = Collections.unmodifiableList(builder.interaction);
                this.versioning = builder.versioning;
                this.readHistory = builder.readHistory;
                this.updateCreate = builder.updateCreate;
                this.conditionalCreate = builder.conditionalCreate;
                this.conditionalRead = builder.conditionalRead;
                this.conditionalUpdate = builder.conditionalUpdate;
                this.conditionalDelete = builder.conditionalDelete;
                this.referencePolicy = Collections.unmodifiableList(builder.referencePolicy);
                this.searchInclude = Collections.unmodifiableList(builder.searchInclude);
                this.searchRevInclude = Collections.unmodifiableList(builder.searchRevInclude);
                this.searchParam = Collections.unmodifiableList(builder.searchParam);
                this.operation = Collections.unmodifiableList(builder.operation);
            }

            public ResourceType getType() {
                return this.type;
            }

            public Canonical getProfile() {
                return this.profile;
            }

            public List<Canonical> getSupportedProfile() {
                return this.supportedProfile;
            }

            public Markdown getDocumentation() {
                return this.documentation;
            }

            public List<Interaction> getInteraction() {
                return this.interaction;
            }

            public ResourceVersionPolicy getVersioning() {
                return this.versioning;
            }

            public Boolean getReadHistory() {
                return this.readHistory;
            }

            public Boolean getUpdateCreate() {
                return this.updateCreate;
            }

            public Boolean getConditionalCreate() {
                return this.conditionalCreate;
            }

            public ConditionalReadStatus getConditionalRead() {
                return this.conditionalRead;
            }

            public Boolean getConditionalUpdate() {
                return this.conditionalUpdate;
            }

            public ConditionalDeleteStatus getConditionalDelete() {
                return this.conditionalDelete;
            }

            public List<ReferenceHandlingPolicy> getReferencePolicy() {
                return this.referencePolicy;
            }

            public List<String> getSearchInclude() {
                return this.searchInclude;
            }

            public List<String> getSearchRevInclude() {
                return this.searchRevInclude;
            }

            public List<SearchParam> getSearchParam() {
                return this.searchParam;
            }

            public List<Operation> getOperation() {
                return this.operation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.profile != null || !this.supportedProfile.isEmpty() || this.documentation != null || !this.interaction.isEmpty() || this.versioning != null || this.readHistory != null || this.updateCreate != null || this.conditionalCreate != null || this.conditionalRead != null || this.conditionalUpdate != null || this.conditionalDelete != null || !this.referencePolicy.isEmpty() || !this.searchInclude.isEmpty() || !this.searchRevInclude.isEmpty() || !this.searchParam.isEmpty() || !this.operation.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.profile, "profile", visitor);
                        this.accept(this.supportedProfile, "supportedProfile", visitor, Canonical.class);
                        this.accept(this.documentation, "documentation", visitor);
                        this.accept(this.interaction, "interaction", visitor, Interaction.class);
                        this.accept(this.versioning, "versioning", visitor);
                        this.accept(this.readHistory, "readHistory", visitor);
                        this.accept(this.updateCreate, "updateCreate", visitor);
                        this.accept(this.conditionalCreate, "conditionalCreate", visitor);
                        this.accept(this.conditionalRead, "conditionalRead", visitor);
                        this.accept(this.conditionalUpdate, "conditionalUpdate", visitor);
                        this.accept(this.conditionalDelete, "conditionalDelete", visitor);
                        this.accept(this.referencePolicy, "referencePolicy", visitor, ReferenceHandlingPolicy.class);
                        this.accept(this.searchInclude, "searchInclude", visitor, String.class);
                        this.accept(this.searchRevInclude, "searchRevInclude", visitor, String.class);
                        this.accept(this.searchParam, "searchParam", visitor, SearchParam.class);
                        this.accept(this.operation, "operation", visitor, Operation.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Resource other = (Resource)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.profile, other.profile) && Objects.equals(this.supportedProfile, other.supportedProfile) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.interaction, other.interaction) && Objects.equals(this.versioning, other.versioning) && Objects.equals(this.readHistory, other.readHistory) && Objects.equals(this.updateCreate, other.updateCreate) && Objects.equals(this.conditionalCreate, other.conditionalCreate) && Objects.equals(this.conditionalRead, other.conditionalRead) && Objects.equals(this.conditionalUpdate, other.conditionalUpdate) && Objects.equals(this.conditionalDelete, other.conditionalDelete) && Objects.equals(this.referencePolicy, other.referencePolicy) && Objects.equals(this.searchInclude, other.searchInclude) && Objects.equals(this.searchRevInclude, other.searchRevInclude) && Objects.equals(this.searchParam, other.searchParam) && Objects.equals(this.operation, other.operation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.profile, this.supportedProfile, this.documentation, this.interaction, this.versioning, this.readHistory, this.updateCreate, this.conditionalCreate, this.conditionalRead, this.conditionalUpdate, this.conditionalDelete, this.referencePolicy, this.searchInclude, this.searchRevInclude, this.searchParam, this.operation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Operation
            extends BackboneElement {
                @Summary
                @Required
                private final String name;
                @Summary
                @Required
                private final Canonical definition;
                private final Markdown documentation;

                private Operation(Builder builder) {
                    super(builder);
                    this.name = builder.name;
                    this.definition = builder.definition;
                    this.documentation = builder.documentation;
                }

                public String getName() {
                    return this.name;
                }

                public Canonical getDefinition() {
                    return this.definition;
                }

                public Markdown getDocumentation() {
                    return this.documentation;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.name != null || this.definition != null || this.documentation != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.name, "name", visitor);
                            this.accept(this.definition, "definition", visitor);
                            this.accept(this.documentation, "documentation", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Operation other = (Operation)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.definition, other.definition) && Objects.equals(this.documentation, other.documentation);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.definition, this.documentation);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private String name;
                    private Canonical definition;
                    private Markdown documentation;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder name(java.lang.String name) {
                        this.name = name == null ? null : String.of(name);
                        return this;
                    }

                    public Builder name(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder definition(Canonical definition) {
                        this.definition = definition;
                        return this;
                    }

                    public Builder documentation(Markdown documentation) {
                        this.documentation = documentation;
                        return this;
                    }

                    @Override
                    public Operation build() {
                        Operation operation = new Operation(this);
                        if (this.validating) {
                            this.validate(operation);
                        }
                        return operation;
                    }

                    protected void validate(Operation operation) {
                        super.validate(operation);
                        ValidationSupport.requireNonNull(operation.name, "name");
                        ValidationSupport.requireNonNull(operation.definition, "definition");
                        ValidationSupport.requireValueOrChildren(operation);
                    }

                    protected Builder from(Operation operation) {
                        super.from(operation);
                        this.name = operation.name;
                        this.definition = operation.definition;
                        this.documentation = operation.documentation;
                        return this;
                    }
                }
            }

            public static class SearchParam
            extends BackboneElement {
                @Required
                private final String name;
                private final Canonical definition;
                @Binding(bindingName="SearchParamType", strength=BindingStrength.Value.REQUIRED, description="Data types allowed to be used for search parameters.", valueSet="http://hl7.org/fhir/ValueSet/search-param-type|4.0.1")
                @Required
                private final SearchParamType type;
                private final Markdown documentation;

                private SearchParam(Builder builder) {
                    super(builder);
                    this.name = builder.name;
                    this.definition = builder.definition;
                    this.type = builder.type;
                    this.documentation = builder.documentation;
                }

                public String getName() {
                    return this.name;
                }

                public Canonical getDefinition() {
                    return this.definition;
                }

                public SearchParamType getType() {
                    return this.type;
                }

                public Markdown getDocumentation() {
                    return this.documentation;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.name != null || this.definition != null || this.type != null || this.documentation != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.name, "name", visitor);
                            this.accept(this.definition, "definition", visitor);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.documentation, "documentation", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    SearchParam other = (SearchParam)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.definition, other.definition) && Objects.equals(this.type, other.type) && Objects.equals(this.documentation, other.documentation);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.definition, this.type, this.documentation);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private String name;
                    private Canonical definition;
                    private SearchParamType type;
                    private Markdown documentation;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder name(java.lang.String name) {
                        this.name = name == null ? null : String.of(name);
                        return this;
                    }

                    public Builder name(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder definition(Canonical definition) {
                        this.definition = definition;
                        return this;
                    }

                    public Builder type(SearchParamType type) {
                        this.type = type;
                        return this;
                    }

                    public Builder documentation(Markdown documentation) {
                        this.documentation = documentation;
                        return this;
                    }

                    @Override
                    public SearchParam build() {
                        SearchParam searchParam = new SearchParam(this);
                        if (this.validating) {
                            this.validate(searchParam);
                        }
                        return searchParam;
                    }

                    protected void validate(SearchParam searchParam) {
                        super.validate(searchParam);
                        ValidationSupport.requireNonNull(searchParam.name, "name");
                        ValidationSupport.requireNonNull(searchParam.type, "type");
                        ValidationSupport.requireValueOrChildren(searchParam);
                    }

                    protected Builder from(SearchParam searchParam) {
                        super.from(searchParam);
                        this.name = searchParam.name;
                        this.definition = searchParam.definition;
                        this.type = searchParam.type;
                        this.documentation = searchParam.documentation;
                        return this;
                    }
                }
            }

            public static class Interaction
            extends BackboneElement {
                @Binding(bindingName="TypeRestfulInteraction", strength=BindingStrength.Value.REQUIRED, description="Operations supported by REST at the type or instance level.", valueSet="http://hl7.org/fhir/ValueSet/type-restful-interaction|4.0.1")
                @Required
                private final TypeRestfulInteraction code;
                private final Markdown documentation;

                private Interaction(Builder builder) {
                    super(builder);
                    this.code = builder.code;
                    this.documentation = builder.documentation;
                }

                public TypeRestfulInteraction getCode() {
                    return this.code;
                }

                public Markdown getDocumentation() {
                    return this.documentation;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.code != null || this.documentation != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.code, "code", visitor);
                            this.accept(this.documentation, "documentation", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Interaction other = (Interaction)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.documentation, other.documentation);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.documentation);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private TypeRestfulInteraction code;
                    private Markdown documentation;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder code(TypeRestfulInteraction code) {
                        this.code = code;
                        return this;
                    }

                    public Builder documentation(Markdown documentation) {
                        this.documentation = documentation;
                        return this;
                    }

                    @Override
                    public Interaction build() {
                        Interaction interaction = new Interaction(this);
                        if (this.validating) {
                            this.validate(interaction);
                        }
                        return interaction;
                    }

                    protected void validate(Interaction interaction) {
                        super.validate(interaction);
                        ValidationSupport.requireNonNull(interaction.code, "code");
                        ValidationSupport.requireValueOrChildren(interaction);
                    }

                    protected Builder from(Interaction interaction) {
                        super.from(interaction);
                        this.code = interaction.code;
                        this.documentation = interaction.documentation;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ResourceType type;
                private Canonical profile;
                private List<Canonical> supportedProfile = new ArrayList<Canonical>();
                private Markdown documentation;
                private List<Interaction> interaction = new ArrayList<Interaction>();
                private ResourceVersionPolicy versioning;
                private Boolean readHistory;
                private Boolean updateCreate;
                private Boolean conditionalCreate;
                private ConditionalReadStatus conditionalRead;
                private Boolean conditionalUpdate;
                private ConditionalDeleteStatus conditionalDelete;
                private List<ReferenceHandlingPolicy> referencePolicy = new ArrayList<ReferenceHandlingPolicy>();
                private List<String> searchInclude = new ArrayList<String>();
                private List<String> searchRevInclude = new ArrayList<String>();
                private List<SearchParam> searchParam = new ArrayList<SearchParam>();
                private List<Operation> operation = new ArrayList<Operation>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(ResourceType type) {
                    this.type = type;
                    return this;
                }

                public Builder profile(Canonical profile) {
                    this.profile = profile;
                    return this;
                }

                public Builder supportedProfile(Canonical ... supportedProfile) {
                    for (Canonical value : supportedProfile) {
                        this.supportedProfile.add(value);
                    }
                    return this;
                }

                public Builder supportedProfile(Collection<Canonical> supportedProfile) {
                    this.supportedProfile = new ArrayList<Canonical>(supportedProfile);
                    return this;
                }

                public Builder documentation(Markdown documentation) {
                    this.documentation = documentation;
                    return this;
                }

                public Builder interaction(Interaction ... interaction) {
                    for (Interaction value : interaction) {
                        this.interaction.add(value);
                    }
                    return this;
                }

                public Builder interaction(Collection<Interaction> interaction) {
                    this.interaction = new ArrayList<Interaction>(interaction);
                    return this;
                }

                public Builder versioning(ResourceVersionPolicy versioning) {
                    this.versioning = versioning;
                    return this;
                }

                public Builder readHistory(java.lang.Boolean readHistory) {
                    this.readHistory = readHistory == null ? null : Boolean.of(readHistory);
                    return this;
                }

                public Builder readHistory(Boolean readHistory) {
                    this.readHistory = readHistory;
                    return this;
                }

                public Builder updateCreate(java.lang.Boolean updateCreate) {
                    this.updateCreate = updateCreate == null ? null : Boolean.of(updateCreate);
                    return this;
                }

                public Builder updateCreate(Boolean updateCreate) {
                    this.updateCreate = updateCreate;
                    return this;
                }

                public Builder conditionalCreate(java.lang.Boolean conditionalCreate) {
                    this.conditionalCreate = conditionalCreate == null ? null : Boolean.of(conditionalCreate);
                    return this;
                }

                public Builder conditionalCreate(Boolean conditionalCreate) {
                    this.conditionalCreate = conditionalCreate;
                    return this;
                }

                public Builder conditionalRead(ConditionalReadStatus conditionalRead) {
                    this.conditionalRead = conditionalRead;
                    return this;
                }

                public Builder conditionalUpdate(java.lang.Boolean conditionalUpdate) {
                    this.conditionalUpdate = conditionalUpdate == null ? null : Boolean.of(conditionalUpdate);
                    return this;
                }

                public Builder conditionalUpdate(Boolean conditionalUpdate) {
                    this.conditionalUpdate = conditionalUpdate;
                    return this;
                }

                public Builder conditionalDelete(ConditionalDeleteStatus conditionalDelete) {
                    this.conditionalDelete = conditionalDelete;
                    return this;
                }

                public Builder referencePolicy(ReferenceHandlingPolicy ... referencePolicy) {
                    for (ReferenceHandlingPolicy value : referencePolicy) {
                        this.referencePolicy.add(value);
                    }
                    return this;
                }

                public Builder referencePolicy(Collection<ReferenceHandlingPolicy> referencePolicy) {
                    this.referencePolicy = new ArrayList<ReferenceHandlingPolicy>(referencePolicy);
                    return this;
                }

                public Builder searchInclude(java.lang.String ... searchInclude) {
                    for (java.lang.String value : searchInclude) {
                        this.searchInclude.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder searchInclude(String ... searchInclude) {
                    for (String value : searchInclude) {
                        this.searchInclude.add(value);
                    }
                    return this;
                }

                public Builder searchInclude(Collection<String> searchInclude) {
                    this.searchInclude = new ArrayList<String>(searchInclude);
                    return this;
                }

                public Builder searchRevInclude(java.lang.String ... searchRevInclude) {
                    for (java.lang.String value : searchRevInclude) {
                        this.searchRevInclude.add(value == null ? null : String.of(value));
                    }
                    return this;
                }

                public Builder searchRevInclude(String ... searchRevInclude) {
                    for (String value : searchRevInclude) {
                        this.searchRevInclude.add(value);
                    }
                    return this;
                }

                public Builder searchRevInclude(Collection<String> searchRevInclude) {
                    this.searchRevInclude = new ArrayList<String>(searchRevInclude);
                    return this;
                }

                public Builder searchParam(SearchParam ... searchParam) {
                    for (SearchParam value : searchParam) {
                        this.searchParam.add(value);
                    }
                    return this;
                }

                public Builder searchParam(Collection<SearchParam> searchParam) {
                    this.searchParam = new ArrayList<SearchParam>(searchParam);
                    return this;
                }

                public Builder operation(Operation ... operation) {
                    for (Operation value : operation) {
                        this.operation.add(value);
                    }
                    return this;
                }

                public Builder operation(Collection<Operation> operation) {
                    this.operation = new ArrayList<Operation>(operation);
                    return this;
                }

                @Override
                public Resource build() {
                    Resource resource = new Resource(this);
                    if (this.validating) {
                        this.validate(resource);
                    }
                    return resource;
                }

                protected void validate(Resource resource) {
                    super.validate(resource);
                    ValidationSupport.requireNonNull(resource.type, "type");
                    ValidationSupport.checkList(resource.supportedProfile, "supportedProfile", Canonical.class);
                    ValidationSupport.checkList(resource.interaction, "interaction", Interaction.class);
                    ValidationSupport.checkList(resource.referencePolicy, "referencePolicy", ReferenceHandlingPolicy.class);
                    ValidationSupport.checkList(resource.searchInclude, "searchInclude", String.class);
                    ValidationSupport.checkList(resource.searchRevInclude, "searchRevInclude", String.class);
                    ValidationSupport.checkList(resource.searchParam, "searchParam", SearchParam.class);
                    ValidationSupport.checkList(resource.operation, "operation", Operation.class);
                    ValidationSupport.requireValueOrChildren(resource);
                }

                protected Builder from(Resource resource) {
                    super.from(resource);
                    this.type = resource.type;
                    this.profile = resource.profile;
                    this.supportedProfile.addAll(resource.supportedProfile);
                    this.documentation = resource.documentation;
                    this.interaction.addAll(resource.interaction);
                    this.versioning = resource.versioning;
                    this.readHistory = resource.readHistory;
                    this.updateCreate = resource.updateCreate;
                    this.conditionalCreate = resource.conditionalCreate;
                    this.conditionalRead = resource.conditionalRead;
                    this.conditionalUpdate = resource.conditionalUpdate;
                    this.conditionalDelete = resource.conditionalDelete;
                    this.referencePolicy.addAll(resource.referencePolicy);
                    this.searchInclude.addAll(resource.searchInclude);
                    this.searchRevInclude.addAll(resource.searchRevInclude);
                    this.searchParam.addAll(resource.searchParam);
                    this.operation.addAll(resource.operation);
                    return this;
                }
            }
        }

        public static class Security
        extends BackboneElement {
            @Summary
            private final Boolean cors;
            @Summary
            @Binding(bindingName="RestfulSecurityService", strength=BindingStrength.Value.EXTENSIBLE, description="Types of security services used with FHIR.", valueSet="http://hl7.org/fhir/ValueSet/restful-security-service")
            private final List<CodeableConcept> service;
            private final Markdown description;

            private Security(Builder builder) {
                super(builder);
                this.cors = builder.cors;
                this.service = Collections.unmodifiableList(builder.service);
                this.description = builder.description;
            }

            public Boolean getCors() {
                return this.cors;
            }

            public List<CodeableConcept> getService() {
                return this.service;
            }

            public Markdown getDescription() {
                return this.description;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.cors != null || !this.service.isEmpty() || this.description != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.cors, "cors", visitor);
                        this.accept(this.service, "service", visitor, CodeableConcept.class);
                        this.accept(this.description, "description", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Security other = (Security)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.cors, other.cors) && Objects.equals(this.service, other.service) && Objects.equals(this.description, other.description);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.cors, this.service, this.description);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Boolean cors;
                private List<CodeableConcept> service = new ArrayList<CodeableConcept>();
                private Markdown description;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder cors(java.lang.Boolean cors) {
                    this.cors = cors == null ? null : Boolean.of(cors);
                    return this;
                }

                public Builder cors(Boolean cors) {
                    this.cors = cors;
                    return this;
                }

                public Builder service(CodeableConcept ... service) {
                    for (CodeableConcept value : service) {
                        this.service.add(value);
                    }
                    return this;
                }

                public Builder service(Collection<CodeableConcept> service) {
                    this.service = new ArrayList<CodeableConcept>(service);
                    return this;
                }

                public Builder description(Markdown description) {
                    this.description = description;
                    return this;
                }

                @Override
                public Security build() {
                    Security security = new Security(this);
                    if (this.validating) {
                        this.validate(security);
                    }
                    return security;
                }

                protected void validate(Security security) {
                    super.validate(security);
                    ValidationSupport.checkList(security.service, "service", CodeableConcept.class);
                    ValidationSupport.requireValueOrChildren(security);
                }

                protected Builder from(Security security) {
                    super.from(security);
                    this.cors = security.cors;
                    this.service.addAll(security.service);
                    this.description = security.description;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private RestfulCapabilityMode mode;
            private Markdown documentation;
            private Security security;
            private List<Resource> resource = new ArrayList<Resource>();
            private List<Interaction> interaction = new ArrayList<Interaction>();
            private List<Resource.SearchParam> searchParam = new ArrayList<Resource.SearchParam>();
            private List<Resource.Operation> operation = new ArrayList<Resource.Operation>();
            private List<Canonical> compartment = new ArrayList<Canonical>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder mode(RestfulCapabilityMode mode) {
                this.mode = mode;
                return this;
            }

            public Builder documentation(Markdown documentation) {
                this.documentation = documentation;
                return this;
            }

            public Builder security(Security security) {
                this.security = security;
                return this;
            }

            public Builder resource(Resource ... resource) {
                for (Resource value : resource) {
                    this.resource.add(value);
                }
                return this;
            }

            public Builder resource(Collection<Resource> resource) {
                this.resource = new ArrayList<Resource>(resource);
                return this;
            }

            public Builder interaction(Interaction ... interaction) {
                for (Interaction value : interaction) {
                    this.interaction.add(value);
                }
                return this;
            }

            public Builder interaction(Collection<Interaction> interaction) {
                this.interaction = new ArrayList<Interaction>(interaction);
                return this;
            }

            public Builder searchParam(Resource.SearchParam ... searchParam) {
                for (Resource.SearchParam value : searchParam) {
                    this.searchParam.add(value);
                }
                return this;
            }

            public Builder searchParam(Collection<Resource.SearchParam> searchParam) {
                this.searchParam = new ArrayList<Resource.SearchParam>(searchParam);
                return this;
            }

            public Builder operation(Resource.Operation ... operation) {
                for (Resource.Operation value : operation) {
                    this.operation.add(value);
                }
                return this;
            }

            public Builder operation(Collection<Resource.Operation> operation) {
                this.operation = new ArrayList<Resource.Operation>(operation);
                return this;
            }

            public Builder compartment(Canonical ... compartment) {
                for (Canonical value : compartment) {
                    this.compartment.add(value);
                }
                return this;
            }

            public Builder compartment(Collection<Canonical> compartment) {
                this.compartment = new ArrayList<Canonical>(compartment);
                return this;
            }

            @Override
            public Rest build() {
                Rest rest = new Rest(this);
                if (this.validating) {
                    this.validate(rest);
                }
                return rest;
            }

            protected void validate(Rest rest) {
                super.validate(rest);
                ValidationSupport.requireNonNull(rest.mode, "mode");
                ValidationSupport.checkList(rest.resource, "resource", Resource.class);
                ValidationSupport.checkList(rest.interaction, "interaction", Interaction.class);
                ValidationSupport.checkList(rest.searchParam, "searchParam", Resource.SearchParam.class);
                ValidationSupport.checkList(rest.operation, "operation", Resource.Operation.class);
                ValidationSupport.checkList(rest.compartment, "compartment", Canonical.class);
                ValidationSupport.requireValueOrChildren(rest);
            }

            protected Builder from(Rest rest) {
                super.from(rest);
                this.mode = rest.mode;
                this.documentation = rest.documentation;
                this.security = rest.security;
                this.resource.addAll(rest.resource);
                this.interaction.addAll(rest.interaction);
                this.searchParam.addAll(rest.searchParam);
                this.operation.addAll(rest.operation);
                this.compartment.addAll(rest.compartment);
                return this;
            }
        }
    }

    public static class Implementation
    extends BackboneElement {
        @Summary
        @Required
        private final String description;
        @Summary
        private final Url url;
        @Summary
        @ReferenceTarget(value={"Organization"})
        private final Reference custodian;

        private Implementation(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.url = builder.url;
            this.custodian = builder.custodian;
        }

        public String getDescription() {
            return this.description;
        }

        public Url getUrl() {
            return this.url;
        }

        public Reference getCustodian() {
            return this.custodian;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.url != null || this.custodian != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.url, "url", visitor);
                    this.accept(this.custodian, "custodian", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Implementation other = (Implementation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.url, other.url) && Objects.equals(this.custodian, other.custodian);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.url, this.custodian);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private Url url;
            private Reference custodian;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder url(Url url) {
                this.url = url;
                return this;
            }

            public Builder custodian(Reference custodian) {
                this.custodian = custodian;
                return this;
            }

            @Override
            public Implementation build() {
                Implementation implementation = new Implementation(this);
                if (this.validating) {
                    this.validate(implementation);
                }
                return implementation;
            }

            protected void validate(Implementation implementation) {
                super.validate(implementation);
                ValidationSupport.requireNonNull(implementation.description, "description");
                ValidationSupport.checkReferenceType(implementation.custodian, "custodian", "Organization");
                ValidationSupport.requireValueOrChildren(implementation);
            }

            protected Builder from(Implementation implementation) {
                super.from(implementation);
                this.description = implementation.description;
                this.url = implementation.url;
                this.custodian = implementation.custodian;
                return this;
            }
        }
    }

    public static class Software
    extends BackboneElement {
        @Summary
        @Required
        private final String name;
        @Summary
        private final String version;
        @Summary
        private final DateTime releaseDate;

        private Software(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.version = builder.version;
            this.releaseDate = builder.releaseDate;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public DateTime getReleaseDate() {
            return this.releaseDate;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.version != null || this.releaseDate != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.version, "version", visitor);
                    this.accept(this.releaseDate, "releaseDate", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Software other = (Software)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.releaseDate, other.releaseDate);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.version, this.releaseDate);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private String version;
            private DateTime releaseDate;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(java.lang.String name) {
                this.name = name == null ? null : String.of(name);
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder version(java.lang.String version) {
                this.version = version == null ? null : String.of(version);
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder releaseDate(DateTime releaseDate) {
                this.releaseDate = releaseDate;
                return this;
            }

            @Override
            public Software build() {
                Software software = new Software(this);
                if (this.validating) {
                    this.validate(software);
                }
                return software;
            }

            protected void validate(Software software) {
                super.validate(software);
                ValidationSupport.requireNonNull(software.name, "name");
                ValidationSupport.requireValueOrChildren(software);
            }

            protected Builder from(Software software) {
                super.from(software);
                this.name = software.name;
                this.version = software.version;
                this.releaseDate = software.releaseDate;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private CapabilityStatementKind kind;
        private List<Canonical> instantiates = new ArrayList<Canonical>();
        private List<Canonical> imports = new ArrayList<Canonical>();
        private Software software;
        private Implementation implementation;
        private FHIRVersion fhirVersion;
        private List<Code> format = new ArrayList<Code>();
        private List<Code> patchFormat = new ArrayList<Code>();
        private List<Canonical> implementationGuide = new ArrayList<Canonical>();
        private List<Rest> rest = new ArrayList<Rest>();
        private List<Messaging> messaging = new ArrayList<Messaging>();
        private List<Document> document = new ArrayList<Document>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder kind(CapabilityStatementKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder instantiates(Canonical ... instantiates) {
            for (Canonical value : instantiates) {
                this.instantiates.add(value);
            }
            return this;
        }

        public Builder instantiates(Collection<Canonical> instantiates) {
            this.instantiates = new ArrayList<Canonical>(instantiates);
            return this;
        }

        public Builder imports(Canonical ... imports) {
            for (Canonical value : imports) {
                this.imports.add(value);
            }
            return this;
        }

        public Builder imports(Collection<Canonical> imports) {
            this.imports = new ArrayList<Canonical>(imports);
            return this;
        }

        public Builder software(Software software) {
            this.software = software;
            return this;
        }

        public Builder implementation(Implementation implementation) {
            this.implementation = implementation;
            return this;
        }

        public Builder fhirVersion(FHIRVersion fhirVersion) {
            this.fhirVersion = fhirVersion;
            return this;
        }

        public Builder format(Code ... format) {
            for (Code value : format) {
                this.format.add(value);
            }
            return this;
        }

        public Builder format(Collection<Code> format) {
            this.format = new ArrayList<Code>(format);
            return this;
        }

        public Builder patchFormat(Code ... patchFormat) {
            for (Code value : patchFormat) {
                this.patchFormat.add(value);
            }
            return this;
        }

        public Builder patchFormat(Collection<Code> patchFormat) {
            this.patchFormat = new ArrayList<Code>(patchFormat);
            return this;
        }

        public Builder implementationGuide(Canonical ... implementationGuide) {
            for (Canonical value : implementationGuide) {
                this.implementationGuide.add(value);
            }
            return this;
        }

        public Builder implementationGuide(Collection<Canonical> implementationGuide) {
            this.implementationGuide = new ArrayList<Canonical>(implementationGuide);
            return this;
        }

        public Builder rest(Rest ... rest) {
            for (Rest value : rest) {
                this.rest.add(value);
            }
            return this;
        }

        public Builder rest(Collection<Rest> rest) {
            this.rest = new ArrayList<Rest>(rest);
            return this;
        }

        public Builder messaging(Messaging ... messaging) {
            for (Messaging value : messaging) {
                this.messaging.add(value);
            }
            return this;
        }

        public Builder messaging(Collection<Messaging> messaging) {
            this.messaging = new ArrayList<Messaging>(messaging);
            return this;
        }

        public Builder document(Document ... document) {
            for (Document value : document) {
                this.document.add(value);
            }
            return this;
        }

        public Builder document(Collection<Document> document) {
            this.document = new ArrayList<Document>(document);
            return this;
        }

        @Override
        public CapabilityStatement build() {
            CapabilityStatement capabilityStatement = new CapabilityStatement(this);
            if (this.validating) {
                this.validate(capabilityStatement);
            }
            return capabilityStatement;
        }

        protected void validate(CapabilityStatement capabilityStatement) {
            super.validate(capabilityStatement);
            ValidationSupport.requireNonNull(capabilityStatement.status, "status");
            ValidationSupport.requireNonNull(capabilityStatement.date, "date");
            ValidationSupport.checkList(capabilityStatement.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(capabilityStatement.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(capabilityStatement.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.requireNonNull(capabilityStatement.kind, "kind");
            ValidationSupport.checkList(capabilityStatement.instantiates, "instantiates", Canonical.class);
            ValidationSupport.checkList(capabilityStatement.imports, "imports", Canonical.class);
            ValidationSupport.requireNonNull(capabilityStatement.fhirVersion, "fhirVersion");
            ValidationSupport.checkNonEmptyList(capabilityStatement.format, "format", Code.class);
            ValidationSupport.checkList(capabilityStatement.patchFormat, "patchFormat", Code.class);
            ValidationSupport.checkList(capabilityStatement.implementationGuide, "implementationGuide", Canonical.class);
            ValidationSupport.checkList(capabilityStatement.rest, "rest", Rest.class);
            ValidationSupport.checkList(capabilityStatement.messaging, "messaging", Messaging.class);
            ValidationSupport.checkList(capabilityStatement.document, "document", Document.class);
        }

        protected Builder from(CapabilityStatement capabilityStatement) {
            super.from(capabilityStatement);
            this.url = capabilityStatement.url;
            this.version = capabilityStatement.version;
            this.name = capabilityStatement.name;
            this.title = capabilityStatement.title;
            this.status = capabilityStatement.status;
            this.experimental = capabilityStatement.experimental;
            this.date = capabilityStatement.date;
            this.publisher = capabilityStatement.publisher;
            this.contact.addAll(capabilityStatement.contact);
            this.description = capabilityStatement.description;
            this.useContext.addAll(capabilityStatement.useContext);
            this.jurisdiction.addAll(capabilityStatement.jurisdiction);
            this.purpose = capabilityStatement.purpose;
            this.copyright = capabilityStatement.copyright;
            this.kind = capabilityStatement.kind;
            this.instantiates.addAll(capabilityStatement.instantiates);
            this.imports.addAll(capabilityStatement.imports);
            this.software = capabilityStatement.software;
            this.implementation = capabilityStatement.implementation;
            this.fhirVersion = capabilityStatement.fhirVersion;
            this.format.addAll(capabilityStatement.format);
            this.patchFormat.addAll(capabilityStatement.patchFormat);
            this.implementationGuide.addAll(capabilityStatement.implementationGuide);
            this.rest.addAll(capabilityStatement.rest);
            this.messaging.addAll(capabilityStatement.messaging);
            this.document.addAll(capabilityStatement.document);
            return this;
        }
    }
}

