/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ChargeItemDefinitionPriceComponentType;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cid-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/ChargeItemDefinition"), @Constraint(id="chargeItemDefinition-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/ChargeItemDefinition", generated=true)})
public class ChargeItemDefinition
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String title;
    @Summary
    private final List<Uri> derivedFromUri;
    @Summary
    private final List<Canonical> partOf;
    @Summary
    private final List<Canonical> replaces;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Summary
    @Binding(bindingName="ChargeItemDefinitionCode", strength=BindingStrength.Value.EXAMPLE, description="Billing Code defined by this ChargeItemDefinition.", valueSet="http://hl7.org/fhir/ValueSet/chargeitem-billingcodes")
    private final CodeableConcept code;
    @ReferenceTarget(value={"Medication", "Substance", "Device"})
    private final List<Reference> instance;
    private final List<Applicability> applicability;
    private final List<PropertyGroup> propertyGroup;

    private ChargeItemDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.title = builder.title;
        this.derivedFromUri = Collections.unmodifiableList(builder.derivedFromUri);
        this.partOf = Collections.unmodifiableList(builder.partOf);
        this.replaces = Collections.unmodifiableList(builder.replaces);
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.code = builder.code;
        this.instance = Collections.unmodifiableList(builder.instance);
        this.applicability = Collections.unmodifiableList(builder.applicability);
        this.propertyGroup = Collections.unmodifiableList(builder.propertyGroup);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Uri> getDerivedFromUri() {
        return this.derivedFromUri;
    }

    public List<Canonical> getPartOf() {
        return this.partOf;
    }

    public List<Canonical> getReplaces() {
        return this.replaces;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public List<Reference> getInstance() {
        return this.instance;
    }

    public List<Applicability> getApplicability() {
        return this.applicability;
    }

    public List<PropertyGroup> getPropertyGroup() {
        return this.propertyGroup;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.title != null || !this.derivedFromUri.isEmpty() || !this.partOf.isEmpty() || !this.replaces.isEmpty() || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || this.code != null || !this.instance.isEmpty() || !this.applicability.isEmpty() || !this.propertyGroup.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.derivedFromUri, "derivedFromUri", visitor, Uri.class);
                this.accept(this.partOf, "partOf", visitor, Canonical.class);
                this.accept(this.replaces, "replaces", visitor, Canonical.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.instance, "instance", visitor, Reference.class);
                this.accept(this.applicability, "applicability", visitor, Applicability.class);
                this.accept(this.propertyGroup, "propertyGroup", visitor, PropertyGroup.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChargeItemDefinition other = (ChargeItemDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.title, other.title) && Objects.equals(this.derivedFromUri, other.derivedFromUri) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.replaces, other.replaces) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.code, other.code) && Objects.equals(this.instance, other.instance) && Objects.equals(this.applicability, other.applicability) && Objects.equals(this.propertyGroup, other.propertyGroup);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.title, this.derivedFromUri, this.partOf, this.replaces, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.code, this.instance, this.applicability, this.propertyGroup);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class PropertyGroup
    extends BackboneElement {
        private final List<Applicability> applicability;
        private final List<PriceComponent> priceComponent;

        private PropertyGroup(Builder builder) {
            super(builder);
            this.applicability = Collections.unmodifiableList(builder.applicability);
            this.priceComponent = Collections.unmodifiableList(builder.priceComponent);
        }

        public List<Applicability> getApplicability() {
            return this.applicability;
        }

        public List<PriceComponent> getPriceComponent() {
            return this.priceComponent;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.applicability.isEmpty() || !this.priceComponent.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.applicability, "applicability", visitor, Applicability.class);
                    this.accept(this.priceComponent, "priceComponent", visitor, PriceComponent.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyGroup other = (PropertyGroup)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.applicability, other.applicability) && Objects.equals(this.priceComponent, other.priceComponent);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.applicability, this.priceComponent);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class PriceComponent
        extends BackboneElement {
            @Binding(bindingName="ChargeItemDefinitionPriceComponentType", strength=BindingStrength.Value.REQUIRED, description="Codes indicating the kind of the price component.", valueSet="http://hl7.org/fhir/ValueSet/invoice-priceComponentType|4.0.1")
            @Required
            private final ChargeItemDefinitionPriceComponentType type;
            private final CodeableConcept code;
            private final Decimal factor;
            private final Money amount;

            private PriceComponent(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.code = builder.code;
                this.factor = builder.factor;
                this.amount = builder.amount;
            }

            public ChargeItemDefinitionPriceComponentType getType() {
                return this.type;
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public Decimal getFactor() {
                return this.factor;
            }

            public Money getAmount() {
                return this.amount;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.code != null || this.factor != null || this.amount != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.factor, "factor", visitor);
                        this.accept(this.amount, "amount", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PriceComponent other = (PriceComponent)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.code, other.code) && Objects.equals(this.factor, other.factor) && Objects.equals(this.amount, other.amount);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.code, this.factor, this.amount);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ChargeItemDefinitionPriceComponentType type;
                private CodeableConcept code;
                private Decimal factor;
                private Money amount;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(ChargeItemDefinitionPriceComponentType type) {
                    this.type = type;
                    return this;
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder factor(Decimal factor) {
                    this.factor = factor;
                    return this;
                }

                public Builder amount(Money amount) {
                    this.amount = amount;
                    return this;
                }

                @Override
                public PriceComponent build() {
                    PriceComponent priceComponent = new PriceComponent(this);
                    if (this.validating) {
                        this.validate(priceComponent);
                    }
                    return priceComponent;
                }

                protected void validate(PriceComponent priceComponent) {
                    super.validate(priceComponent);
                    ValidationSupport.requireNonNull(priceComponent.type, "type");
                    ValidationSupport.requireValueOrChildren(priceComponent);
                }

                protected Builder from(PriceComponent priceComponent) {
                    super.from(priceComponent);
                    this.type = priceComponent.type;
                    this.code = priceComponent.code;
                    this.factor = priceComponent.factor;
                    this.amount = priceComponent.amount;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Applicability> applicability = new ArrayList<Applicability>();
            private List<PriceComponent> priceComponent = new ArrayList<PriceComponent>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder applicability(Applicability ... applicability) {
                for (Applicability value : applicability) {
                    this.applicability.add(value);
                }
                return this;
            }

            public Builder applicability(Collection<Applicability> applicability) {
                this.applicability = new ArrayList<Applicability>(applicability);
                return this;
            }

            public Builder priceComponent(PriceComponent ... priceComponent) {
                for (PriceComponent value : priceComponent) {
                    this.priceComponent.add(value);
                }
                return this;
            }

            public Builder priceComponent(Collection<PriceComponent> priceComponent) {
                this.priceComponent = new ArrayList<PriceComponent>(priceComponent);
                return this;
            }

            @Override
            public PropertyGroup build() {
                PropertyGroup propertyGroup = new PropertyGroup(this);
                if (this.validating) {
                    this.validate(propertyGroup);
                }
                return propertyGroup;
            }

            protected void validate(PropertyGroup propertyGroup) {
                super.validate(propertyGroup);
                ValidationSupport.checkList(propertyGroup.applicability, "applicability", Applicability.class);
                ValidationSupport.checkList(propertyGroup.priceComponent, "priceComponent", PriceComponent.class);
                ValidationSupport.requireValueOrChildren(propertyGroup);
            }

            protected Builder from(PropertyGroup propertyGroup) {
                super.from(propertyGroup);
                this.applicability.addAll(propertyGroup.applicability);
                this.priceComponent.addAll(propertyGroup.priceComponent);
                return this;
            }
        }
    }

    public static class Applicability
    extends BackboneElement {
        private final String description;
        private final String language;
        private final String expression;

        private Applicability(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.language = builder.language;
            this.expression = builder.expression;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.language != null || this.expression != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.language, "language", visitor);
                    this.accept(this.expression, "expression", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Applicability other = (Applicability)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.language, other.language) && Objects.equals(this.expression, other.expression);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.language, this.expression);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private String language;
            private String expression;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder language(java.lang.String language) {
                this.language = language == null ? null : String.of(language);
                return this;
            }

            public Builder language(String language) {
                this.language = language;
                return this;
            }

            public Builder expression(java.lang.String expression) {
                this.expression = expression == null ? null : String.of(expression);
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            @Override
            public Applicability build() {
                Applicability applicability = new Applicability(this);
                if (this.validating) {
                    this.validate(applicability);
                }
                return applicability;
            }

            protected void validate(Applicability applicability) {
                super.validate(applicability);
                ValidationSupport.requireValueOrChildren(applicability);
            }

            protected Builder from(Applicability applicability) {
                super.from(applicability);
                this.description = applicability.description;
                this.language = applicability.language;
                this.expression = applicability.expression;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String title;
        private List<Uri> derivedFromUri = new ArrayList<Uri>();
        private List<Canonical> partOf = new ArrayList<Canonical>();
        private List<Canonical> replaces = new ArrayList<Canonical>();
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private CodeableConcept code;
        private List<Reference> instance = new ArrayList<Reference>();
        private List<Applicability> applicability = new ArrayList<Applicability>();
        private List<PropertyGroup> propertyGroup = new ArrayList<PropertyGroup>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder derivedFromUri(Uri ... derivedFromUri) {
            for (Uri value : derivedFromUri) {
                this.derivedFromUri.add(value);
            }
            return this;
        }

        public Builder derivedFromUri(Collection<Uri> derivedFromUri) {
            this.derivedFromUri = new ArrayList<Uri>(derivedFromUri);
            return this;
        }

        public Builder partOf(Canonical ... partOf) {
            for (Canonical value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Canonical> partOf) {
            this.partOf = new ArrayList<Canonical>(partOf);
            return this;
        }

        public Builder replaces(Canonical ... replaces) {
            for (Canonical value : replaces) {
                this.replaces.add(value);
            }
            return this;
        }

        public Builder replaces(Collection<Canonical> replaces) {
            this.replaces = new ArrayList<Canonical>(replaces);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(LocalDate approvalDate) {
            this.approvalDate = approvalDate == null ? null : Date.of(approvalDate);
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(LocalDate lastReviewDate) {
            this.lastReviewDate = lastReviewDate == null ? null : Date.of(lastReviewDate);
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder instance(Reference ... instance) {
            for (Reference value : instance) {
                this.instance.add(value);
            }
            return this;
        }

        public Builder instance(Collection<Reference> instance) {
            this.instance = new ArrayList<Reference>(instance);
            return this;
        }

        public Builder applicability(Applicability ... applicability) {
            for (Applicability value : applicability) {
                this.applicability.add(value);
            }
            return this;
        }

        public Builder applicability(Collection<Applicability> applicability) {
            this.applicability = new ArrayList<Applicability>(applicability);
            return this;
        }

        public Builder propertyGroup(PropertyGroup ... propertyGroup) {
            for (PropertyGroup value : propertyGroup) {
                this.propertyGroup.add(value);
            }
            return this;
        }

        public Builder propertyGroup(Collection<PropertyGroup> propertyGroup) {
            this.propertyGroup = new ArrayList<PropertyGroup>(propertyGroup);
            return this;
        }

        @Override
        public ChargeItemDefinition build() {
            ChargeItemDefinition chargeItemDefinition = new ChargeItemDefinition(this);
            if (this.validating) {
                this.validate(chargeItemDefinition);
            }
            return chargeItemDefinition;
        }

        protected void validate(ChargeItemDefinition chargeItemDefinition) {
            super.validate(chargeItemDefinition);
            ValidationSupport.requireNonNull(chargeItemDefinition.url, "url");
            ValidationSupport.checkList(chargeItemDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(chargeItemDefinition.derivedFromUri, "derivedFromUri", Uri.class);
            ValidationSupport.checkList(chargeItemDefinition.partOf, "partOf", Canonical.class);
            ValidationSupport.checkList(chargeItemDefinition.replaces, "replaces", Canonical.class);
            ValidationSupport.requireNonNull(chargeItemDefinition.status, "status");
            ValidationSupport.checkList(chargeItemDefinition.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(chargeItemDefinition.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(chargeItemDefinition.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(chargeItemDefinition.instance, "instance", Reference.class);
            ValidationSupport.checkList(chargeItemDefinition.applicability, "applicability", Applicability.class);
            ValidationSupport.checkList(chargeItemDefinition.propertyGroup, "propertyGroup", PropertyGroup.class);
            ValidationSupport.checkReferenceType(chargeItemDefinition.instance, "instance", "Medication", "Substance", "Device");
        }

        protected Builder from(ChargeItemDefinition chargeItemDefinition) {
            super.from(chargeItemDefinition);
            this.url = chargeItemDefinition.url;
            this.identifier.addAll(chargeItemDefinition.identifier);
            this.version = chargeItemDefinition.version;
            this.title = chargeItemDefinition.title;
            this.derivedFromUri.addAll(chargeItemDefinition.derivedFromUri);
            this.partOf.addAll(chargeItemDefinition.partOf);
            this.replaces.addAll(chargeItemDefinition.replaces);
            this.status = chargeItemDefinition.status;
            this.experimental = chargeItemDefinition.experimental;
            this.date = chargeItemDefinition.date;
            this.publisher = chargeItemDefinition.publisher;
            this.contact.addAll(chargeItemDefinition.contact);
            this.description = chargeItemDefinition.description;
            this.useContext.addAll(chargeItemDefinition.useContext);
            this.jurisdiction.addAll(chargeItemDefinition.jurisdiction);
            this.copyright = chargeItemDefinition.copyright;
            this.approvalDate = chargeItemDefinition.approvalDate;
            this.lastReviewDate = chargeItemDefinition.lastReviewDate;
            this.effectivePeriod = chargeItemDefinition.effectivePeriod;
            this.code = chargeItemDefinition.code;
            this.instance.addAll(chargeItemDefinition.instance);
            this.applicability.addAll(chargeItemDefinition.applicability);
            this.propertyGroup.addAll(chargeItemDefinition.propertyGroup);
            return this;
        }
    }
}

